# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Compute
      module V1
        # Messages
        #
        # Contains the configurations necessary to generate a signature for access to private storage buckets that support Signature Version 4 for authentication. The service name for generating the authentication header will always default to 's3'.
        # @!attribute [rw] access_key
        #   @return [::String]
        #     The access key used for s3 bucket authentication. Required for updating or creating a backend that uses AWS v4 signature authentication, but will not be returned as part of the configuration when queried with a REST API GET request. @InputOnly
        # @!attribute [rw] access_key_id
        #   @return [::String]
        #     The identifier of an access key used for s3 bucket authentication.
        # @!attribute [rw] access_key_version
        #   @return [::String]
        #     The optional version identifier for the access key. You can use this to keep track of different iterations of your access key.
        # @!attribute [rw] origin_region
        #   @return [::String]
        #     The name of the cloud region of your origin. This is a free-form field with the name of the region your cloud uses to host your origin. For example, "us-east-1" for AWS or "us-ashburn-1" for OCI.
        class AWSV4Signature
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for InstanceGroupManagers.AbandonInstances. See the method description for details.
        # @!attribute [rw] instance_group_manager
        #   @return [::String]
        #     The name of the managed instance group.
        # @!attribute [rw] instance_group_managers_abandon_instances_request_resource
        #   @return [::Google::Cloud::Compute::V1::InstanceGroupManagersAbandonInstancesRequest]
        #     The body resource for this request
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone where the managed instance group is located.
        class AbandonInstancesInstanceGroupManagerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionInstanceGroupManagers.AbandonInstances. See the method description for details.
        # @!attribute [rw] instance_group_manager
        #   @return [::String]
        #     Name of the managed instance group.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        # @!attribute [rw] region_instance_group_managers_abandon_instances_request_resource
        #   @return [::Google::Cloud::Compute::V1::RegionInstanceGroupManagersAbandonInstancesRequest]
        #     The body resource for this request
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class AbandonInstancesRegionInstanceGroupManagerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A specification of the type and number of accelerator cards attached to the instance.
        # @!attribute [rw] accelerator_count
        #   @return [::Integer]
        #     The number of the guest accelerator cards exposed to this instance.
        # @!attribute [rw] accelerator_type
        #   @return [::String]
        #     Full or partial URL of the accelerator type resource to attach to this instance. For example: projects/my-project/zones/us-central1-c/acceleratorTypes/nvidia-tesla-p100 If you are creating an instance template, specify only the accelerator name. See GPUs on Compute Engine for a full list of accelerator types.
        class AcceleratorConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents an Accelerator Type resource. Google Cloud Platform provides graphics processing units (accelerators) that you can add to VM instances to improve or accelerate performance when working with intensive workloads. For more information, read GPUs on Compute Engine.
        # @!attribute [rw] creation_timestamp
        #   @return [::String]
        #     [Output Only] Creation timestamp in RFC3339 text format.
        # @!attribute [rw] deprecated
        #   @return [::Google::Cloud::Compute::V1::DeprecationStatus]
        #     [Output Only] The deprecation status associated with this accelerator type.
        # @!attribute [rw] description
        #   @return [::String]
        #     [Output Only] An optional textual description of the resource.
        # @!attribute [rw] id
        #   @return [::Integer]
        #     [Output Only] The unique identifier for the resource. This identifier is defined by the server.
        # @!attribute [rw] kind
        #   @return [::String]
        #     [Output Only] The type of the resource. Always compute#acceleratorType for accelerator types.
        # @!attribute [rw] maximum_cards_per_instance
        #   @return [::Integer]
        #     [Output Only] Maximum number of accelerator cards allowed per instance.
        # @!attribute [rw] name
        #   @return [::String]
        #     [Output Only] Name of the resource.
        # @!attribute [rw] self_link
        #   @return [::String]
        #     [Output Only] Server-defined, fully qualified URL for this resource.
        # @!attribute [rw] zone
        #   @return [::String]
        #     [Output Only] The name of the zone where the accelerator type resides, such as us-central1-a. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
        class AcceleratorType
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] id
        #   @return [::String]
        #     [Output Only] Unique identifier for the resource; defined by the server.
        # @!attribute [rw] items
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Compute::V1::AcceleratorTypesScopedList}]
        #     A list of AcceleratorTypesScopedList resources.
        # @!attribute [rw] kind
        #   @return [::String]
        #     [Output Only] Type of resource. Always compute#acceleratorTypeAggregatedList for aggregated lists of accelerator types.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
        # @!attribute [rw] self_link
        #   @return [::String]
        #     [Output Only] Server-defined URL for this resource.
        # @!attribute [rw] unreachables
        #   @return [::Array<::String>]
        #     [Output Only] Unreachable resources.
        # @!attribute [rw] warning
        #   @return [::Google::Cloud::Compute::V1::Warning]
        #     [Output Only] Informational warning message.
        class AcceleratorTypeAggregatedList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Compute::V1::AcceleratorTypesScopedList]
          class ItemsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Contains a list of accelerator types.
        # @!attribute [rw] id
        #   @return [::String]
        #     [Output Only] Unique identifier for the resource; defined by the server.
        # @!attribute [rw] items
        #   @return [::Array<::Google::Cloud::Compute::V1::AcceleratorType>]
        #     A list of AcceleratorType resources.
        # @!attribute [rw] kind
        #   @return [::String]
        #     [Output Only] Type of resource. Always compute#acceleratorTypeList for lists of accelerator types.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
        # @!attribute [rw] self_link
        #   @return [::String]
        #     [Output Only] Server-defined URL for this resource.
        # @!attribute [rw] warning
        #   @return [::Google::Cloud::Compute::V1::Warning]
        #     [Output Only] Informational warning message.
        class AcceleratorTypeList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] accelerator_types
        #   @return [::Array<::Google::Cloud::Compute::V1::AcceleratorType>]
        #     [Output Only] A list of accelerator types contained in this scope.
        # @!attribute [rw] warning
        #   @return [::Google::Cloud::Compute::V1::Warning]
        #     [Output Only] An informational warning that appears when the accelerator types list is empty.
        class AcceleratorTypesScopedList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] guest_accelerator_count
        #   @return [::Integer]
        #     Number of accelerator cards exposed to the guest.
        # @!attribute [rw] guest_accelerator_type
        #   @return [::String]
        #     The accelerator type resource name, not a full URL, e.g. nvidia-tesla-t4.
        class Accelerators
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An access configuration attached to an instance's network interface. Only one access config per instance is supported.
        # @!attribute [rw] external_ipv6
        #   @return [::String]
        #     Applies to ipv6AccessConfigs only. The first IPv6 address of the external IPv6 range associated with this instance, prefix length is stored in externalIpv6PrefixLength in ipv6AccessConfig. To use a static external IP address, it must be unused and in the same region as the instance's zone. If not specified, Google Cloud will automatically assign an external IPv6 address from the instance's subnetwork.
        # @!attribute [rw] external_ipv6_prefix_length
        #   @return [::Integer]
        #     Applies to ipv6AccessConfigs only. The prefix length of the external IPv6 range.
        # @!attribute [rw] kind
        #   @return [::String]
        #     [Output Only] Type of the resource. Always compute#accessConfig for access configs.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of this access configuration. In accessConfigs (IPv4), the default and recommended name is External NAT, but you can use any arbitrary string, such as My external IP or Network Access. In ipv6AccessConfigs, the recommend name is External IPv6.
        # @!attribute [rw] nat_i_p
        #   @return [::String]
        #     Applies to accessConfigs (IPv4) only. An external IP address associated with this instance. Specify an unused static external IP address available to the project or leave this field undefined to use an IP from a shared ephemeral IP address pool. If you specify a static external IP address, it must live in the same region as the zone of the instance.
        # @!attribute [rw] network_tier
        #   @return [::String]
        #     This signifies the networking tier used for configuring this access configuration and can only take the following values: PREMIUM, STANDARD. If an AccessConfig is specified without a valid external IP address, an ephemeral IP will be created with this networkTier. If an AccessConfig with a valid external IP address is specified, it must match that of the networkTier associated with the Address resource owning that IP.
        #     Check the NetworkTier enum for the list of possible values.
        # @!attribute [rw] public_ptr_domain_name
        #   @return [::String]
        #     The DNS domain name for the public PTR record. You can set this field only if the `setPublicPtr` field is enabled in accessConfig. If this field is unspecified in ipv6AccessConfig, a default PTR record will be created for first IP in associated external IPv6 range.
        # @!attribute [rw] security_policy
        #   @return [::String]
        #     The resource URL for the security policy associated with this access config.
        # @!attribute [rw] set_public_ptr
        #   @return [::Boolean]
        #     Specifies whether a public DNS 'PTR' record should be created to map the external IP address of the instance to a DNS domain name. This field is not used in ipv6AccessConfig. A default PTR record will be created if the VM has external IPv6 range associated.
        # @!attribute [rw] type
        #   @return [::String]
        #     The type of configuration. In accessConfigs (IPv4), the default and only option is ONE_TO_ONE_NAT. In ipv6AccessConfigs, the default and only option is DIRECT_IPV6.
        #     Check the Type enum for the list of possible values.
        class AccessConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # This signifies the networking tier used for configuring this access configuration and can only take the following values: PREMIUM, STANDARD. If an AccessConfig is specified without a valid external IP address, an ephemeral IP will be created with this networkTier. If an AccessConfig with a valid external IP address is specified, it must match that of the networkTier associated with the Address resource owning that IP.
          module NetworkTier
            # A value indicating that the enum field is not set.
            UNDEFINED_NETWORK_TIER = 0

            # Public internet quality with fixed bandwidth.
            FIXED_STANDARD = 310_464_328

            # High quality, Google-grade network tier, support for all networking products.
            PREMIUM = 399_530_551

            # Public internet quality, only limited support for other networking products.
            STANDARD = 484_642_493

            # (Output only) Temporary tier for FIXED_STANDARD when fixed standard tier is expired or not configured.
            STANDARD_OVERRIDES_FIXED_STANDARD = 465_847_234
          end

          # The type of configuration. In accessConfigs (IPv4), the default and only option is ONE_TO_ONE_NAT. In ipv6AccessConfigs, the default and only option is DIRECT_IPV6.
          module Type
            # A value indicating that the enum field is not set.
            UNDEFINED_TYPE = 0

            DIRECT_IPV6 = 4_397_213

            ONE_TO_ONE_NAT = 84_090_205
          end
        end

        # A request message for Instances.AddAccessConfig. See the method description for details.
        # @!attribute [rw] access_config_resource
        #   @return [::Google::Cloud::Compute::V1::AccessConfig]
        #     The body resource for this request
        # @!attribute [rw] instance
        #   @return [::String]
        #     The instance name for this request.
        # @!attribute [rw] network_interface
        #   @return [::String]
        #     The name of the network interface to add to this instance.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone for this request.
        class AddAccessConfigInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for FirewallPolicies.AddAssociation. See the method description for details.
        # @!attribute [rw] firewall_policy
        #   @return [::String]
        #     Name of the firewall policy to update.
        # @!attribute [rw] firewall_policy_association_resource
        #   @return [::Google::Cloud::Compute::V1::FirewallPolicyAssociation]
        #     The body resource for this request
        # @!attribute [rw] replace_existing_association
        #   @return [::Boolean]
        #     Indicates whether or not to replace it if an association of the attachment already exists. This is false by default, in which case an error will be returned if an association already exists.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class AddAssociationFirewallPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for NetworkFirewallPolicies.AddAssociation. See the method description for details.
        # @!attribute [rw] firewall_policy
        #   @return [::String]
        #     Name of the firewall policy to update.
        # @!attribute [rw] firewall_policy_association_resource
        #   @return [::Google::Cloud::Compute::V1::FirewallPolicyAssociation]
        #     The body resource for this request
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] replace_existing_association
        #   @return [::Boolean]
        #     Indicates whether or not to replace it if an association of the attachment already exists. This is false by default, in which case an error will be returned if an association already exists.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class AddAssociationNetworkFirewallPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionNetworkFirewallPolicies.AddAssociation. See the method description for details.
        # @!attribute [rw] firewall_policy
        #   @return [::String]
        #     Name of the firewall policy to update.
        # @!attribute [rw] firewall_policy_association_resource
        #   @return [::Google::Cloud::Compute::V1::FirewallPolicyAssociation]
        #     The body resource for this request
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        # @!attribute [rw] replace_existing_association
        #   @return [::Boolean]
        #     Indicates whether or not to replace it if an association already exists. This is false by default, in which case an error will be returned if an association already exists.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class AddAssociationRegionNetworkFirewallPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for TargetPools.AddHealthCheck. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] target_pool
        #   @return [::String]
        #     Name of the target pool to add a health check to.
        # @!attribute [rw] target_pools_add_health_check_request_resource
        #   @return [::Google::Cloud::Compute::V1::TargetPoolsAddHealthCheckRequest]
        #     The body resource for this request
        class AddHealthCheckTargetPoolRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for TargetPools.AddInstance. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] target_pool
        #   @return [::String]
        #     Name of the TargetPool resource to add instances to.
        # @!attribute [rw] target_pools_add_instance_request_resource
        #   @return [::Google::Cloud::Compute::V1::TargetPoolsAddInstanceRequest]
        #     The body resource for this request
        class AddInstanceTargetPoolRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for InstanceGroups.AddInstances. See the method description for details.
        # @!attribute [rw] instance_group
        #   @return [::String]
        #     The name of the instance group where you are adding instances.
        # @!attribute [rw] instance_groups_add_instances_request_resource
        #   @return [::Google::Cloud::Compute::V1::InstanceGroupsAddInstancesRequest]
        #     The body resource for this request
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone where the instance group is located.
        class AddInstancesInstanceGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Instances.AddNetworkInterface. See the method description for details.
        # @!attribute [rw] instance
        #   @return [::String]
        #     The instance name for this request stored as resource_id. Name should conform to RFC1035 or be an unsigned long integer.
        # @!attribute [rw] network_interface_resource
        #   @return [::Google::Cloud::Compute::V1::NetworkInterface]
        #     The body resource for this request
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone for this request.
        class AddNetworkInterfaceInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for NodeGroups.AddNodes. See the method description for details.
        # @!attribute [rw] node_group
        #   @return [::String]
        #     Name of the NodeGroup resource.
        # @!attribute [rw] node_groups_add_nodes_request_resource
        #   @return [::Google::Cloud::Compute::V1::NodeGroupsAddNodesRequest]
        #     The body resource for this request
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone for this request.
        class AddNodesNodeGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for NetworkFirewallPolicies.AddPacketMirroringRule. See the method description for details.
        # @!attribute [rw] firewall_policy
        #   @return [::String]
        #     Name of the firewall policy to update.
        # @!attribute [rw] firewall_policy_rule_resource
        #   @return [::Google::Cloud::Compute::V1::FirewallPolicyRule]
        #     The body resource for this request
        # @!attribute [rw] max_priority
        #   @return [::Integer]
        #     When rule.priority is not specified, auto choose a unused priority between minPriority and maxPriority>. This field is exclusive with rule.priority.
        # @!attribute [rw] min_priority
        #   @return [::Integer]
        #     When rule.priority is not specified, auto choose a unused priority between minPriority and maxPriority>. This field is exclusive with rule.priority.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class AddPacketMirroringRuleNetworkFirewallPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Networks.AddPeering. See the method description for details.
        # @!attribute [rw] network
        #   @return [::String]
        #     Name of the network resource to add peering to.
        # @!attribute [rw] networks_add_peering_request_resource
        #   @return [::Google::Cloud::Compute::V1::NetworksAddPeeringRequest]
        #     The body resource for this request
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class AddPeeringNetworkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Disks.AddResourcePolicies. See the method description for details.
        # @!attribute [rw] disk
        #   @return [::String]
        #     The disk name for this request.
        # @!attribute [rw] disks_add_resource_policies_request_resource
        #   @return [::Google::Cloud::Compute::V1::DisksAddResourcePoliciesRequest]
        #     The body resource for this request
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone for this request.
        class AddResourcePoliciesDiskRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Instances.AddResourcePolicies. See the method description for details.
        # @!attribute [rw] instance
        #   @return [::String]
        #     The instance name for this request.
        # @!attribute [rw] instances_add_resource_policies_request_resource
        #   @return [::Google::Cloud::Compute::V1::InstancesAddResourcePoliciesRequest]
        #     The body resource for this request
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone for this request.
        class AddResourcePoliciesInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionDisks.AddResourcePolicies. See the method description for details.
        # @!attribute [rw] disk
        #   @return [::String]
        #     The disk name for this request.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     The name of the region for this request.
        # @!attribute [rw] region_disks_add_resource_policies_request_resource
        #   @return [::Google::Cloud::Compute::V1::RegionDisksAddResourcePoliciesRequest]
        #     The body resource for this request
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class AddResourcePoliciesRegionDiskRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for FirewallPolicies.AddRule. See the method description for details.
        # @!attribute [rw] firewall_policy
        #   @return [::String]
        #     Name of the firewall policy to update.
        # @!attribute [rw] firewall_policy_rule_resource
        #   @return [::Google::Cloud::Compute::V1::FirewallPolicyRule]
        #     The body resource for this request
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class AddRuleFirewallPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for NetworkFirewallPolicies.AddRule. See the method description for details.
        # @!attribute [rw] firewall_policy
        #   @return [::String]
        #     Name of the firewall policy to update.
        # @!attribute [rw] firewall_policy_rule_resource
        #   @return [::Google::Cloud::Compute::V1::FirewallPolicyRule]
        #     The body resource for this request
        # @!attribute [rw] max_priority
        #   @return [::Integer]
        #     When rule.priority is not specified, auto choose a unused priority between minPriority and maxPriority>. This field is exclusive with rule.priority.
        # @!attribute [rw] min_priority
        #   @return [::Integer]
        #     When rule.priority is not specified, auto choose a unused priority between minPriority and maxPriority>. This field is exclusive with rule.priority.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class AddRuleNetworkFirewallPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionNetworkFirewallPolicies.AddRule. See the method description for details.
        # @!attribute [rw] firewall_policy
        #   @return [::String]
        #     Name of the firewall policy to update.
        # @!attribute [rw] firewall_policy_rule_resource
        #   @return [::Google::Cloud::Compute::V1::FirewallPolicyRule]
        #     The body resource for this request
        # @!attribute [rw] max_priority
        #   @return [::Integer]
        #     When rule.priority is not specified, auto choose a unused priority between minPriority and maxPriority>. This field is exclusive with rule.priority.
        # @!attribute [rw] min_priority
        #   @return [::Integer]
        #     When rule.priority is not specified, auto choose a unused priority between minPriority and maxPriority>. This field is exclusive with rule.priority.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class AddRuleRegionNetworkFirewallPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionSecurityPolicies.AddRule. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        # @!attribute [rw] security_policy
        #   @return [::String]
        #     Name of the security policy to update.
        # @!attribute [rw] security_policy_rule_resource
        #   @return [::Google::Cloud::Compute::V1::SecurityPolicyRule]
        #     The body resource for this request
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     If true, the request will not be committed.
        class AddRuleRegionSecurityPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for SecurityPolicies.AddRule. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] security_policy
        #   @return [::String]
        #     Name of the security policy to update.
        # @!attribute [rw] security_policy_rule_resource
        #   @return [::Google::Cloud::Compute::V1::SecurityPolicyRule]
        #     The body resource for this request
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     If true, the request will not be committed.
        class AddRuleSecurityPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for BackendBuckets.AddSignedUrlKey. See the method description for details.
        # @!attribute [rw] backend_bucket
        #   @return [::String]
        #     Name of the BackendBucket resource to which the Signed URL Key should be added. The name should conform to RFC1035.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] signed_url_key_resource
        #   @return [::Google::Cloud::Compute::V1::SignedUrlKey]
        #     The body resource for this request
        class AddSignedUrlKeyBackendBucketRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for BackendServices.AddSignedUrlKey. See the method description for details.
        # @!attribute [rw] backend_service
        #   @return [::String]
        #     Name of the BackendService resource to which the Signed URL Key should be added. The name should conform to RFC1035.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] signed_url_key_resource
        #   @return [::Google::Cloud::Compute::V1::SignedUrlKey]
        #     The body resource for this request
        class AddSignedUrlKeyBackendServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents an IP Address resource. Google Compute Engine has two IP Address resources: * [Global (external and internal)](https://cloud.google.com/compute/docs/reference/rest/v1/globalAddresses) * [Regional (external and internal)](https://cloud.google.com/compute/docs/reference/rest/v1/addresses) For more information, see Reserving a static external IP address.
        # @!attribute [rw] address
        #   @return [::String]
        #     The static IP address represented by this resource.
        # @!attribute [rw] address_type
        #   @return [::String]
        #     The type of address to reserve, either INTERNAL or EXTERNAL. If unspecified, defaults to EXTERNAL.
        #     Check the AddressType enum for the list of possible values.
        # @!attribute [rw] creation_timestamp
        #   @return [::String]
        #     [Output Only] Creation timestamp in RFC3339 text format.
        # @!attribute [rw] description
        #   @return [::String]
        #     An optional description of this resource. Provide this field when you create the resource.
        # @!attribute [rw] id
        #   @return [::Integer]
        #     [Output Only] The unique identifier for the resource. This identifier is defined by the server.
        # @!attribute [rw] ip_version
        #   @return [::String]
        #     The IP version that will be used by this address. Valid options are IPV4 or IPV6.
        #     Check the IpVersion enum for the list of possible values.
        # @!attribute [rw] ipv6_endpoint_type
        #   @return [::String]
        #     The endpoint type of this address, which should be VM or NETLB. This is used for deciding which type of endpoint this address can be used after the external IPv6 address reservation.
        #     Check the Ipv6EndpointType enum for the list of possible values.
        # @!attribute [rw] kind
        #   @return [::String]
        #     [Output Only] Type of the resource. Always compute#address for addresses.
        # @!attribute [rw] label_fingerprint
        #   @return [::String]
        #     A fingerprint for the labels being applied to this Address, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an Address.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
        # @!attribute [rw] network
        #   @return [::String]
        #     The URL of the network in which to reserve the address. This field can only be used with INTERNAL type with the VPC_PEERING purpose.
        # @!attribute [rw] network_tier
        #   @return [::String]
        #     This signifies the networking tier used for configuring this address and can only take the following values: PREMIUM or STANDARD. Internal IP addresses are always Premium Tier; global external IP addresses are always Premium Tier; regional external IP addresses can be either Standard or Premium Tier. If this field is not specified, it is assumed to be PREMIUM.
        #     Check the NetworkTier enum for the list of possible values.
        # @!attribute [rw] prefix_length
        #   @return [::Integer]
        #     The prefix length if the resource represents an IP range.
        # @!attribute [rw] purpose
        #   @return [::String]
        #     The purpose of this resource, which can be one of the following values: - GCE_ENDPOINT for addresses that are used by VM instances, alias IP ranges, load balancers, and similar resources. - DNS_RESOLVER for a DNS resolver address in a subnetwork for a Cloud DNS inbound forwarder IP addresses (regional internal IP address in a subnet of a VPC network) - VPC_PEERING for global internal IP addresses used for private services access allocated ranges. - NAT_AUTO for the regional external IP addresses used by Cloud NAT when allocating addresses using automatic NAT IP address allocation. - IPSEC_INTERCONNECT for addresses created from a private IP range that are reserved for a VLAN attachment in an *HA VPN over Cloud Interconnect* configuration. These addresses are regional resources. - `SHARED_LOADBALANCER_VIP` for an internal IP address that is assigned to multiple internal forwarding rules. - `PRIVATE_SERVICE_CONNECT` for a private network address that is used to configure Private Service Connect. Only global internal addresses can use this purpose.
        #     Check the Purpose enum for the list of possible values.
        # @!attribute [rw] region
        #   @return [::String]
        #     [Output Only] The URL of the region where a regional address resides. For regional addresses, you must specify the region as a path parameter in the HTTP request URL. *This field is not applicable to global addresses.*
        # @!attribute [rw] self_link
        #   @return [::String]
        #     [Output Only] Server-defined URL for the resource.
        # @!attribute [rw] status
        #   @return [::String]
        #     [Output Only] The status of the address, which can be one of RESERVING, RESERVED, or IN_USE. An address that is RESERVING is currently in the process of being reserved. A RESERVED address is currently reserved and available to use. An IN_USE address is currently being used by another resource and is not available.
        #     Check the Status enum for the list of possible values.
        # @!attribute [rw] subnetwork
        #   @return [::String]
        #     The URL of the subnetwork in which to reserve the address. If an IP address is specified, it must be within the subnetwork's IP range. This field can only be used with INTERNAL type with a GCE_ENDPOINT or DNS_RESOLVER purpose.
        # @!attribute [rw] users
        #   @return [::Array<::String>]
        #     [Output Only] The URLs of the resources that are using this address.
        class Address
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The type of address to reserve, either INTERNAL or EXTERNAL. If unspecified, defaults to EXTERNAL.
          module AddressType
            # A value indicating that the enum field is not set.
            UNDEFINED_ADDRESS_TYPE = 0

            # A publicly visible external IP address.
            EXTERNAL = 35_607_499

            # A private network IP address, for use with an Instance or Internal Load Balancer forwarding rule.
            INTERNAL = 279_295_677

            UNSPECIFIED_TYPE = 53_933_922
          end

          # The IP version that will be used by this address. Valid options are IPV4 or IPV6.
          module IpVersion
            # A value indicating that the enum field is not set.
            UNDEFINED_IP_VERSION = 0

            IPV4 = 2_254_341

            IPV6 = 2_254_343

            UNSPECIFIED_VERSION = 21_850_000
          end

          # The endpoint type of this address, which should be VM or NETLB. This is used for deciding which type of endpoint this address can be used after the external IPv6 address reservation.
          module Ipv6EndpointType
            # A value indicating that the enum field is not set.
            UNDEFINED_IPV6_ENDPOINT_TYPE = 0

            # Reserved IPv6 address can be used on network load balancer.
            NETLB = 74_173_363

            # Reserved IPv6 address can be used on VM.
            VM = 2743
          end

          # This signifies the networking tier used for configuring this address and can only take the following values: PREMIUM or STANDARD. Internal IP addresses are always Premium Tier; global external IP addresses are always Premium Tier; regional external IP addresses can be either Standard or Premium Tier. If this field is not specified, it is assumed to be PREMIUM.
          module NetworkTier
            # A value indicating that the enum field is not set.
            UNDEFINED_NETWORK_TIER = 0

            # Public internet quality with fixed bandwidth.
            FIXED_STANDARD = 310_464_328

            # High quality, Google-grade network tier, support for all networking products.
            PREMIUM = 399_530_551

            # Public internet quality, only limited support for other networking products.
            STANDARD = 484_642_493

            # (Output only) Temporary tier for FIXED_STANDARD when fixed standard tier is expired or not configured.
            STANDARD_OVERRIDES_FIXED_STANDARD = 465_847_234
          end

          # The purpose of this resource, which can be one of the following values: - GCE_ENDPOINT for addresses that are used by VM instances, alias IP ranges, load balancers, and similar resources. - DNS_RESOLVER for a DNS resolver address in a subnetwork for a Cloud DNS inbound forwarder IP addresses (regional internal IP address in a subnet of a VPC network) - VPC_PEERING for global internal IP addresses used for private services access allocated ranges. - NAT_AUTO for the regional external IP addresses used by Cloud NAT when allocating addresses using automatic NAT IP address allocation. - IPSEC_INTERCONNECT for addresses created from a private IP range that are reserved for a VLAN attachment in an *HA VPN over Cloud Interconnect* configuration. These addresses are regional resources. - `SHARED_LOADBALANCER_VIP` for an internal IP address that is assigned to multiple internal forwarding rules. - `PRIVATE_SERVICE_CONNECT` for a private network address that is used to configure Private Service Connect. Only global internal addresses can use this purpose.
          module Purpose
            # A value indicating that the enum field is not set.
            UNDEFINED_PURPOSE = 0

            # DNS resolver address in the subnetwork.
            DNS_RESOLVER = 476_114_556

            # VM internal/alias IP, Internal LB service IP, etc.
            GCE_ENDPOINT = 230_515_243

            # A regional internal IP address range reserved for the VLAN attachment that is used in HA VPN over Cloud Interconnect. This regional internal IP address range must not overlap with any IP address range of subnet/route in the VPC network and its peering networks. After the VLAN attachment is created with the reserved IP address range, when creating a new VPN gateway, its interface IP address is allocated from the associated VLAN attachment’s IP address range.
            IPSEC_INTERCONNECT = 340_437_251

            # External IP automatically reserved for Cloud NAT.
            NAT_AUTO = 163_666_477

            # A private network IP address that can be used to configure Private Service Connect. This purpose can be specified only for GLOBAL addresses of Type INTERNAL
            PRIVATE_SERVICE_CONNECT = 48_134_724

            # A regional internal IP address range reserved for Serverless.
            SERVERLESS = 270_492_508

            # A private network IP address that can be shared by multiple Internal Load Balancer forwarding rules.
            SHARED_LOADBALANCER_VIP = 294_447_572

            # IP range for peer networks.
            VPC_PEERING = 400_800_170
          end

          # [Output Only] The status of the address, which can be one of RESERVING, RESERVED, or IN_USE. An address that is RESERVING is currently in the process of being reserved. A RESERVED address is currently reserved and available to use. An IN_USE address is currently being used by another resource and is not available.
          module Status
            # A value indicating that the enum field is not set.
            UNDEFINED_STATUS = 0

            # Address is being used by another resource and is not available.
            IN_USE = 17_393_485

            # Address is reserved and available to use.
            RESERVED = 432_241_448

            # Address is being reserved.
            RESERVING = 514_587_225
          end
        end

        # @!attribute [rw] id
        #   @return [::String]
        #     [Output Only] Unique identifier for the resource; defined by the server.
        # @!attribute [rw] items
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Compute::V1::AddressesScopedList}]
        #     A list of AddressesScopedList resources.
        # @!attribute [rw] kind
        #   @return [::String]
        #     [Output Only] Type of resource. Always compute#addressAggregatedList for aggregated lists of addresses.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
        # @!attribute [rw] self_link
        #   @return [::String]
        #     [Output Only] Server-defined URL for this resource.
        # @!attribute [rw] unreachables
        #   @return [::Array<::String>]
        #     [Output Only] Unreachable resources.
        # @!attribute [rw] warning
        #   @return [::Google::Cloud::Compute::V1::Warning]
        #     [Output Only] Informational warning message.
        class AddressAggregatedList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Compute::V1::AddressesScopedList]
          class ItemsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Contains a list of addresses.
        # @!attribute [rw] id
        #   @return [::String]
        #     [Output Only] Unique identifier for the resource; defined by the server.
        # @!attribute [rw] items
        #   @return [::Array<::Google::Cloud::Compute::V1::Address>]
        #     A list of Address resources.
        # @!attribute [rw] kind
        #   @return [::String]
        #     [Output Only] Type of resource. Always compute#addressList for lists of addresses.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
        # @!attribute [rw] self_link
        #   @return [::String]
        #     [Output Only] Server-defined URL for this resource.
        # @!attribute [rw] warning
        #   @return [::Google::Cloud::Compute::V1::Warning]
        #     [Output Only] Informational warning message.
        class AddressList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] addresses
        #   @return [::Array<::Google::Cloud::Compute::V1::Address>]
        #     [Output Only] A list of addresses contained in this scope.
        # @!attribute [rw] warning
        #   @return [::Google::Cloud::Compute::V1::Warning]
        #     [Output Only] Informational warning which replaces the list of addresses when the list is empty.
        class AddressesScopedList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Specifies options for controlling advanced machine features. Options that would traditionally be configured in a BIOS belong here. Features that require operating system support may have corresponding entries in the GuestOsFeatures of an Image (e.g., whether or not the OS in the Image supports nested virtualization being enabled or disabled).
        # @!attribute [rw] enable_nested_virtualization
        #   @return [::Boolean]
        #     Whether to enable nested virtualization or not (default is false).
        # @!attribute [rw] enable_uefi_networking
        #   @return [::Boolean]
        #     Whether to enable UEFI networking for instance creation.
        # @!attribute [rw] performance_monitoring_unit
        #   @return [::String]
        #     Type of Performance Monitoring Unit requested on instance.
        #     Check the PerformanceMonitoringUnit enum for the list of possible values.
        # @!attribute [rw] threads_per_core
        #   @return [::Integer]
        #     The number of threads per physical core. To disable simultaneous multithreading (SMT) set this to 1. If unset, the maximum number of threads supported per core by the underlying processor is assumed.
        # @!attribute [rw] turbo_mode
        #   @return [::String]
        #     Turbo frequency mode to use for the instance. Supported modes include: * ALL_CORE_MAX Using empty string or not setting this field will use the platform-specific default turbo mode.
        # @!attribute [rw] visible_core_count
        #   @return [::Integer]
        #     The number of physical cores to expose to an instance. Multiply by the number of threads per core to compute the total number of virtual CPUs to expose to the instance. If unset, the number of cores is inferred from the instance's nominal CPU count and the underlying platform's SMT width.
        class AdvancedMachineFeatures
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Type of Performance Monitoring Unit requested on instance.
          module PerformanceMonitoringUnit
            # A value indicating that the enum field is not set.
            UNDEFINED_PERFORMANCE_MONITORING_UNIT = 0

            # Architecturally defined non-LLC events.
            ARCHITECTURAL = 155_113_693

            # Most documented core/L2 and LLC events.
            ENHANCED = 476_873_590

            PERFORMANCE_MONITORING_UNIT_UNSPECIFIED = 429_210_692

            # Most documented core/L2 events.
            STANDARD = 484_642_493
          end
        end

        # A request message for AcceleratorTypes.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListAcceleratorTypesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Addresses.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListAddressesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Autoscalers.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListAutoscalersRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for BackendServices.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Name of the project scoping this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListBackendServicesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for DiskTypes.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListDiskTypesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Disks.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListDisksRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for ForwardingRules.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListForwardingRulesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for GlobalOperations.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListGlobalOperationsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for HealthChecks.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Name of the project scoping this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListHealthChecksRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for InstanceGroupManagers.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListInstanceGroupManagersRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for InstanceGroups.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListInstanceGroupsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for InstanceTemplates.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Name of the project scoping this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListInstanceTemplatesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Instances.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListInstancesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for InstantSnapshots.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListInstantSnapshotsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for InterconnectAttachments.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListInterconnectAttachmentsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for MachineTypes.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListMachineTypesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for NetworkAttachments.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListNetworkAttachmentsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for NetworkEdgeSecurityServices.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Name of the project scoping this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListNetworkEdgeSecurityServicesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for NetworkEndpointGroups.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListNetworkEndpointGroupsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for NetworkFirewallPolicies.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListNetworkFirewallPoliciesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for NodeGroups.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListNodeGroupsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for NodeTemplates.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListNodeTemplatesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for NodeTypes.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListNodeTypesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for PacketMirrorings.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListPacketMirroringsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for PublicDelegatedPrefixes.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Name of the project scoping this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListPublicDelegatedPrefixesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionCommitments.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListRegionCommitmentsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Reservations.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListReservationsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for ResourcePolicies.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListResourcePoliciesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Routers.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListRoutersRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for SecurityPolicies.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Name of the project scoping this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListSecurityPoliciesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for ServiceAttachments.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Name of the project scoping this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListServiceAttachmentsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for SslCertificates.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Name of the project scoping this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListSslCertificatesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for SslPolicies.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Name of the project scoping this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListSslPoliciesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for StoragePoolTypes.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListStoragePoolTypesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for StoragePools.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListStoragePoolsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Subnetworks.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListSubnetworksRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for TargetHttpProxies.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Name of the project scoping this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListTargetHttpProxiesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for TargetHttpsProxies.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Name of the project scoping this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListTargetHttpsProxiesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for TargetInstances.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListTargetInstancesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for TargetPools.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListTargetPoolsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for TargetTcpProxies.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Name of the project scoping this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListTargetTcpProxiesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for TargetVpnGateways.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListTargetVpnGatewaysRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for UrlMaps.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Name of the project scoping this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListUrlMapsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for VpnGateways.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListVpnGatewaysRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for VpnTunnels.AggregatedList. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] include_all_scopes
        #   @return [::Boolean]
        #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] service_project_number
        #   @return [::Integer]
        #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
        class AggregatedListVpnTunnelsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An alias IP range attached to an instance's network interface.
        # @!attribute [rw] ip_cidr_range
        #   @return [::String]
        #     The IP alias ranges to allocate for this interface. This IP CIDR range must belong to the specified subnetwork and cannot contain IP addresses reserved by system or used by other network interfaces. This range may be a single IP address (such as 10.2.3.4), a netmask (such as /24) or a CIDR-formatted string (such as 10.1.2.0/24).
        # @!attribute [rw] subnetwork_range_name
        #   @return [::String]
        #     The name of a subnetwork secondary IP range from which to allocate an IP alias range. If not specified, the primary range of the subnetwork is used.
        class AliasIpRange
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # This reservation type is specified by total resource amounts (e.g. total count of CPUs) and can account for multiple instance SKUs. In other words, one can create instances of varying shapes against this reservation.
        # @!attribute [rw] in_use_resources
        #   @return [::Array<::Google::Cloud::Compute::V1::AllocationAggregateReservationReservedResourceInfo>]
        #     [Output only] List of resources currently in use.
        # @!attribute [rw] reserved_resources
        #   @return [::Array<::Google::Cloud::Compute::V1::AllocationAggregateReservationReservedResourceInfo>]
        #     List of reserved resources (CPUs, memory, accelerators).
        # @!attribute [rw] vm_family
        #   @return [::String]
        #     The VM family that all instances scheduled against this reservation must belong to.
        #     Check the VmFamily enum for the list of possible values.
        # @!attribute [rw] workload_type
        #   @return [::String]
        #     The workload type of the instances that will target this reservation.
        #     Check the WorkloadType enum for the list of possible values.
        class AllocationAggregateReservation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The VM family that all instances scheduled against this reservation must belong to.
          module VmFamily
            # A value indicating that the enum field is not set.
            UNDEFINED_VM_FAMILY = 0

            VM_FAMILY_CLOUD_TPU_DEVICE_CT3 = 42_845_948

            VM_FAMILY_CLOUD_TPU_LITE_DEVICE_CT5L = 108_020_067

            VM_FAMILY_CLOUD_TPU_LITE_POD_SLICE_CT5LP = 18_705_267

            VM_FAMILY_CLOUD_TPU_LITE_POD_SLICE_CT6E = 398_926_997

            VM_FAMILY_CLOUD_TPU_POD_SLICE_CT3P = 517_384_376

            VM_FAMILY_CLOUD_TPU_POD_SLICE_CT4P = 517_384_407

            VM_FAMILY_CLOUD_TPU_POD_SLICE_CT5P = 517_384_438
          end

          # The workload type of the instances that will target this reservation.
          module WorkloadType
            # A value indicating that the enum field is not set.
            UNDEFINED_WORKLOAD_TYPE = 0

            # Reserved resources will be optimized for BATCH workloads, such as ML training.
            BATCH = 62_971_674

            # Reserved resources will be optimized for SERVING workloads, such as ML inference.
            SERVING = 17_781_740

            UNSPECIFIED = 526_786_327
          end
        end

        # @!attribute [rw] accelerator
        #   @return [::Google::Cloud::Compute::V1::AllocationAggregateReservationReservedResourceInfoAccelerator]
        #     Properties of accelerator resources in this reservation.
        class AllocationAggregateReservationReservedResourceInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] accelerator_count
        #   @return [::Integer]
        #     Number of accelerators of specified type.
        # @!attribute [rw] accelerator_type
        #   @return [::String]
        #     Full or partial URL to accelerator type. e.g. "projects/\\{PROJECT}/zones/\\{ZONE}/acceleratorTypes/ct4l"
        class AllocationAggregateReservationReservedResourceInfoAccelerator
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] service_share_type
        #   @return [::String]
        #     Sharing config for all Google Cloud services.
        #     Check the ServiceShareType enum for the list of possible values.
        class AllocationReservationSharingPolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Sharing config for all Google Cloud services.
          module ServiceShareType
            # A value indicating that the enum field is not set.
            UNDEFINED_SERVICE_SHARE_TYPE = 0

            # Allow all Google Cloud managed services to share reservations.
            ALLOW_ALL = 475_536_235

            # [Default] Disallow sharing with all Google Cloud services.
            DISALLOW_ALL = 277_786_301

            SERVICE_SHARE_TYPE_UNSPECIFIED = 279_057_148
          end
        end

        # [Output Only] Contains output only fields.
        # @!attribute [rw] health_info
        #   @return [::Google::Cloud::Compute::V1::AllocationResourceStatusHealthInfo]
        #     [Output only] Health information for the reservation.
        # @!attribute [rw] reservation_block_count
        #   @return [::Integer]
        #     The number of reservation blocks associated with this reservation.
        # @!attribute [rw] reservation_maintenance
        #   @return [::Google::Cloud::Compute::V1::GroupMaintenanceInfo]
        #     Maintenance information for this reservation
        # @!attribute [rw] specific_sku_allocation
        #   @return [::Google::Cloud::Compute::V1::AllocationResourceStatusSpecificSKUAllocation]
        #     Allocation Properties of this reservation.
        class AllocationResourceStatus
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Health information for the reservation.
        # @!attribute [rw] degraded_block_count
        #   @return [::Integer]
        #     The number of reservation blocks that are degraded.
        # @!attribute [rw] health_status
        #   @return [::String]
        #     The health status of the reservation.
        #     Check the HealthStatus enum for the list of possible values.
        # @!attribute [rw] healthy_block_count
        #   @return [::Integer]
        #     The number of reservation blocks that are healthy.
        class AllocationResourceStatusHealthInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The health status of the reservation.
          module HealthStatus
            # A value indicating that the enum field is not set.
            UNDEFINED_HEALTH_STATUS = 0

            # The reservation is degraded.
            DEGRADED = 396_890_926

            # The reservation is healthy.
            HEALTHY = 439_801_213

            # The health status of the reservation is unspecified.
            HEALTH_STATUS_UNSPECIFIED = 482_246_925
          end
        end

        # Contains Properties set for the reservation.
        # @!attribute [rw] source_instance_template_id
        #   @return [::String]
        #     ID of the instance template used to populate reservation properties.
        # @!attribute [rw] utilizations
        #   @return [::Google::Protobuf::Map{::String => ::Integer}]
        #     Per service utilization breakdown. The Key is the Google Cloud managed service name.
        class AllocationResourceStatusSpecificSKUAllocation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Integer]
          class UtilizationsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # @!attribute [rw] disk_size_gb
        #   @return [::Integer]
        #     Specifies the size of the disk in base-2 GB.
        # @!attribute [rw] interface
        #   @return [::String]
        #     Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI. For performance characteristics of SCSI over NVMe, see Local SSD performance.
        #     Check the Interface enum for the list of possible values.
        class AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI. For performance characteristics of SCSI over NVMe, see Local SSD performance.
          module Interface
            # A value indicating that the enum field is not set.
            UNDEFINED_INTERFACE = 0

            NVME = 2_408_800

            SCSI = 2_539_686
          end
        end

        # Properties of the SKU instances being reserved. Next ID: 9
        # @!attribute [rw] guest_accelerators
        #   @return [::Array<::Google::Cloud::Compute::V1::AcceleratorConfig>]
        #     Specifies accelerator type and count.
        # @!attribute [rw] local_ssds
        #   @return [::Array<::Google::Cloud::Compute::V1::AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk>]
        #     Specifies amount of local ssd to reserve with each instance. The type of disk is local-ssd.
        # @!attribute [rw] location_hint
        #   @return [::String]
        #     An opaque location hint used to place the allocation close to other resources. This field is for use by internal tools that use the public API.
        # @!attribute [rw] machine_type
        #   @return [::String]
        #     Specifies type of machine (name only) which has fixed number of vCPUs and fixed amount of memory. This also includes specifying custom machine type following custom-NUMBER_OF_CPUS-AMOUNT_OF_MEMORY pattern.
        # @!attribute [rw] min_cpu_platform
        #   @return [::String]
        #     Minimum cpu platform the reservation.
        class AllocationSpecificSKUAllocationReservedInstanceProperties
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # This reservation type allows to pre allocate specific instance configuration.
        # @!attribute [rw] assured_count
        #   @return [::Integer]
        #     [Output Only] Indicates how many instances are actually usable currently.
        # @!attribute [rw] count
        #   @return [::Integer]
        #     Specifies the number of resources that are allocated.
        # @!attribute [rw] in_use_count
        #   @return [::Integer]
        #     [Output Only] Indicates how many instances are in use.
        # @!attribute [rw] instance_properties
        #   @return [::Google::Cloud::Compute::V1::AllocationSpecificSKUAllocationReservedInstanceProperties]
        #     The instance properties for the reservation.
        # @!attribute [rw] source_instance_template
        #   @return [::String]
        #     Specifies the instance template to create the reservation. If you use this field, you must exclude the instanceProperties field. This field is optional, and it can be a full or partial URL. For example, the following are all valid URLs to an instance template: - https://www.googleapis.com/compute/v1/projects/project /global/instanceTemplates/instanceTemplate - projects/project/global/instanceTemplates/instanceTemplate - global/instanceTemplates/instanceTemplate
        class AllocationSpecificSKUReservation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] I_p_protocol
        #   @return [::String]
        #     The IP protocol to which this rule applies. The protocol type is required when creating a firewall rule. This value can either be one of the following well known protocol strings (tcp, udp, icmp, esp, ah, ipip, sctp) or the IP protocol number.
        # @!attribute [rw] ports
        #   @return [::Array<::String>]
        #     An optional list of ports to which this rule applies. This field is only applicable for the UDP or TCP protocol. Each entry must be either an integer or a range. If not specified, this rule applies to connections through any port. Example inputs include: ["22"], ["80","443"], and ["12345-12349"].
        class Allowed
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for PublicAdvertisedPrefixes.Announce. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] public_advertised_prefix
        #   @return [::String]
        #     The name of the public advertised prefix. It should comply with RFC1035.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class AnnouncePublicAdvertisedPrefixeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for PublicDelegatedPrefixes.Announce. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] public_delegated_prefix
        #   @return [::String]
        #     The name of the public delegated prefix. It should comply with RFC1035.
        # @!attribute [rw] region
        #   @return [::String]
        #     The name of the region where the public delegated prefix is located. It should comply with RFC1035.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class AnnouncePublicDelegatedPrefixeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for InstanceGroupManagers.ApplyUpdatesToInstances. See the method description for details.
        # @!attribute [rw] instance_group_manager
        #   @return [::String]
        #     The name of the managed instance group, should conform to RFC1035.
        # @!attribute [rw] instance_group_managers_apply_updates_request_resource
        #   @return [::Google::Cloud::Compute::V1::InstanceGroupManagersApplyUpdatesRequest]
        #     The body resource for this request
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone where the managed instance group is located. Should conform to RFC1035.
        class ApplyUpdatesToInstancesInstanceGroupManagerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionInstanceGroupManagers.ApplyUpdatesToInstances. See the method description for details.
        # @!attribute [rw] instance_group_manager
        #   @return [::String]
        #     The name of the managed instance group, should conform to RFC1035.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request, should conform to RFC1035.
        # @!attribute [rw] region_instance_group_managers_apply_updates_request_resource
        #   @return [::Google::Cloud::Compute::V1::RegionInstanceGroupManagersApplyUpdatesRequest]
        #     The body resource for this request
        class ApplyUpdatesToInstancesRegionInstanceGroupManagerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Instances.AttachDisk. See the method description for details.
        # @!attribute [rw] attached_disk_resource
        #   @return [::Google::Cloud::Compute::V1::AttachedDisk]
        #     The body resource for this request
        # @!attribute [rw] force_attach
        #   @return [::Boolean]
        #     Whether to force attach the regional disk even if it's currently attached to another instance. If you try to force attach a zonal disk to an instance, you will receive an error.
        # @!attribute [rw] instance
        #   @return [::String]
        #     The instance name for this request.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone for this request.
        class AttachDiskInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for GlobalNetworkEndpointGroups.AttachNetworkEndpoints. See the method description for details.
        # @!attribute [rw] global_network_endpoint_groups_attach_endpoints_request_resource
        #   @return [::Google::Cloud::Compute::V1::GlobalNetworkEndpointGroupsAttachEndpointsRequest]
        #     The body resource for this request
        # @!attribute [rw] network_endpoint_group
        #   @return [::String]
        #     The name of the network endpoint group where you are attaching network endpoints to. It should comply with RFC1035.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class AttachNetworkEndpointsGlobalNetworkEndpointGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for NetworkEndpointGroups.AttachNetworkEndpoints. See the method description for details.
        # @!attribute [rw] network_endpoint_group
        #   @return [::String]
        #     The name of the network endpoint group where you are attaching network endpoints to. It should comply with RFC1035.
        # @!attribute [rw] network_endpoint_groups_attach_endpoints_request_resource
        #   @return [::Google::Cloud::Compute::V1::NetworkEndpointGroupsAttachEndpointsRequest]
        #     The body resource for this request
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone where the network endpoint group is located. It should comply with RFC1035.
        class AttachNetworkEndpointsNetworkEndpointGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionNetworkEndpointGroups.AttachNetworkEndpoints. See the method description for details.
        # @!attribute [rw] network_endpoint_group
        #   @return [::String]
        #     The name of the network endpoint group where you are attaching network endpoints to. It should comply with RFC1035.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     The name of the region where you want to create the network endpoint group. It should comply with RFC1035.
        # @!attribute [rw] region_network_endpoint_groups_attach_endpoints_request_resource
        #   @return [::Google::Cloud::Compute::V1::RegionNetworkEndpointGroupsAttachEndpointsRequest]
        #     The body resource for this request
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class AttachNetworkEndpointsRegionNetworkEndpointGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An instance-attached disk resource.
        # @!attribute [rw] architecture
        #   @return [::String]
        #     [Output Only] The architecture of the attached disk. Valid values are ARM64 or X86_64.
        #     Check the Architecture enum for the list of possible values.
        # @!attribute [rw] auto_delete
        #   @return [::Boolean]
        #     Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
        # @!attribute [rw] boot
        #   @return [::Boolean]
        #     Indicates that this is a boot disk. The virtual machine will use the first partition of the disk for its root filesystem.
        # @!attribute [rw] device_name
        #   @return [::String]
        #     Specifies a unique device name of your choice that is reflected into the /dev/disk/by-id/google-* tree of a Linux operating system running within the instance. This name can be used to reference the device for mounting, resizing, and so on, from within the instance. If not specified, the server chooses a default device name to apply to this disk, in the form persistent-disk-x, where x is a number assigned by Google Compute Engine. This field is only applicable for persistent disks.
        # @!attribute [rw] disk_encryption_key
        #   @return [::Google::Cloud::Compute::V1::CustomerEncryptionKey]
        #     Encrypts or decrypts a disk using a customer-supplied encryption key. If you are creating a new disk, this field encrypts the new disk using an encryption key that you provide. If you are attaching an existing disk that is already encrypted, this field decrypts the disk using the customer-supplied encryption key. If you encrypt a disk using a customer-supplied key, you must provide the same key again when you attempt to use this resource at a later time. For example, you must provide the key when you create a snapshot or an image from the disk or when you attach the disk to a virtual machine instance. If you do not provide an encryption key, then the disk will be encrypted using an automatically generated key and you do not need to provide a key to use the disk later. Note: Instance templates do not store customer-supplied encryption keys, so you cannot use your own keys to encrypt disks in a managed instance group. You cannot create VMs that have disks with customer-supplied keys using the bulk insert method.
        # @!attribute [rw] disk_size_gb
        #   @return [::Integer]
        #     The size of the disk in GB.
        # @!attribute [rw] force_attach
        #   @return [::Boolean]
        #     [Input Only] Whether to force attach the regional disk even if it's currently attached to another instance. If you try to force attach a zonal disk to an instance, you will receive an error.
        # @!attribute [rw] guest_os_features
        #   @return [::Array<::Google::Cloud::Compute::V1::GuestOsFeature>]
        #     A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
        # @!attribute [rw] index
        #   @return [::Integer]
        #     [Output Only] A zero-based index to this disk, where 0 is reserved for the boot disk. If you have many disks attached to an instance, each disk would have a unique index number.
        # @!attribute [rw] initialize_params
        #   @return [::Google::Cloud::Compute::V1::AttachedDiskInitializeParams]
        #     [Input Only] Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance. This property is mutually exclusive with the source property; you can only define one or the other, but not both.
        # @!attribute [rw] interface
        #   @return [::String]
        #     Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. For most machine types, the default is SCSI. Local SSDs can use either NVME or SCSI. In certain configurations, persistent disks can use NVMe. For more information, see About persistent disks.
        #     Check the Interface enum for the list of possible values.
        # @!attribute [rw] kind
        #   @return [::String]
        #     [Output Only] Type of the resource. Always compute#attachedDisk for attached disks.
        # @!attribute [rw] licenses
        #   @return [::Array<::String>]
        #     [Output Only] Any valid publicly visible licenses.
        # @!attribute [rw] mode
        #   @return [::String]
        #     The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the default is to attach the disk in READ_WRITE mode.
        #     Check the Mode enum for the list of possible values.
        # @!attribute [rw] saved_state
        #   @return [::String]
        #     For LocalSSD disks on VM Instances in STOPPED or SUSPENDED state, this field is set to PRESERVED if the LocalSSD data has been saved to a persistent location by customer request. (see the discard_local_ssd option on Stop/Suspend). Read-only in the api.
        #     Check the SavedState enum for the list of possible values.
        # @!attribute [rw] shielded_instance_initial_state
        #   @return [::Google::Cloud::Compute::V1::InitialStateConfig]
        #     [Output Only] shielded vm initial state stored on disk
        # @!attribute [rw] source
        #   @return [::String]
        #     Specifies a valid partial or full URL to an existing Persistent Disk resource. When creating a new instance boot disk, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required. If desired, you can also attach existing non-root persistent disks using this property. This field is only applicable for persistent disks. Note that for InstanceTemplate, specify the disk name for zonal disk, and the URL for regional disk.
        # @!attribute [rw] type
        #   @return [::String]
        #     Specifies the type of the disk, either SCRATCH or PERSISTENT. If not specified, the default is PERSISTENT.
        #     Check the Type enum for the list of possible values.
        class AttachedDisk
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # [Output Only] The architecture of the attached disk. Valid values are ARM64 or X86_64.
          module Architecture
            # A value indicating that the enum field is not set.
            UNDEFINED_ARCHITECTURE = 0

            # Default value indicating Architecture is not set.
            ARCHITECTURE_UNSPECIFIED = 394_750_507

            # Machines with architecture ARM64
            ARM64 = 62_547_450

            # Machines with architecture X86_64
            X86_64 = 425_300_551
          end

          # Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. For most machine types, the default is SCSI. Local SSDs can use either NVME or SCSI. In certain configurations, persistent disks can use NVMe. For more information, see About persistent disks.
          module Interface
            # A value indicating that the enum field is not set.
            UNDEFINED_INTERFACE = 0

            NVME = 2_408_800

            SCSI = 2_539_686
          end

          # The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the default is to attach the disk in READ_WRITE mode.
          module Mode
            # A value indicating that the enum field is not set.
            UNDEFINED_MODE = 0

            # Attaches this disk in read-only mode. Multiple virtual machines can use a disk in read-only mode at a time.
            READ_ONLY = 91_950_261

            # *[Default]* Attaches this disk in read-write mode. Only one virtual machine at a time can be attached to a disk in read-write mode.
            READ_WRITE = 173_607_894
          end

          # For LocalSSD disks on VM Instances in STOPPED or SUSPENDED state, this field is set to PRESERVED if the LocalSSD data has been saved to a persistent location by customer request. (see the discard_local_ssd option on Stop/Suspend). Read-only in the api.
          module SavedState
            # A value indicating that the enum field is not set.
            UNDEFINED_SAVED_STATE = 0

            # *[Default]* Disk state has not been preserved.
            DISK_SAVED_STATE_UNSPECIFIED = 391_290_831

            # Disk state has been preserved.
            PRESERVED = 254_159_736
          end

          # Specifies the type of the disk, either SCRATCH or PERSISTENT. If not specified, the default is PERSISTENT.
          module Type
            # A value indicating that the enum field is not set.
            UNDEFINED_TYPE = 0

            PERSISTENT = 460_683_927

            SCRATCH = 496_778_970
          end
        end

        # [Input Only] Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance. This field is persisted and returned for instanceTemplate and not returned in the context of instance. This property is mutually exclusive with the source property; you can only define one or the other, but not both.
        # @!attribute [rw] architecture
        #   @return [::String]
        #     The architecture of the attached disk. Valid values are arm64 or x86_64.
        #     Check the Architecture enum for the list of possible values.
        # @!attribute [rw] description
        #   @return [::String]
        #     An optional description. Provide this property when creating the disk.
        # @!attribute [rw] disk_name
        #   @return [::String]
        #     Specifies the disk name. If not specified, the default is to use the name of the instance. If a disk with the same name already exists in the given region, the existing disk is attached to the new instance and the new disk is not created.
        # @!attribute [rw] disk_size_gb
        #   @return [::Integer]
        #     Specifies the size of the disk in base-2 GB. The size must be at least 10 GB. If you specify a sourceImage, which is required for boot disks, the default size is the size of the sourceImage. If you do not specify a sourceImage, the default disk size is 500 GB.
        # @!attribute [rw] disk_type
        #   @return [::String]
        #     Specifies the disk type to use to create the instance. If not specified, the default is pd-standard, specified using the full URL. For example: https://www.googleapis.com/compute/v1/projects/project/zones/zone /diskTypes/pd-standard For a full list of acceptable values, see Persistent disk types. If you specify this field when creating a VM, you can provide either the full or partial URL. For example, the following values are valid: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /diskTypes/diskType - projects/project/zones/zone/diskTypes/diskType - zones/zone/diskTypes/diskType If you specify this field when creating or updating an instance template or all-instances configuration, specify the type of the disk, not the URL. For example: pd-standard.
        # @!attribute [rw] enable_confidential_compute
        #   @return [::Boolean]
        #     Whether this disk is using confidential compute mode.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels to apply to this disk. These can be later modified by the disks.setLabels method. This field is only applicable for persistent disks.
        # @!attribute [rw] licenses
        #   @return [::Array<::String>]
        #     A list of publicly visible licenses. Reserved for Google's use.
        # @!attribute [rw] on_update_action
        #   @return [::String]
        #     Specifies which action to take on instance update with this disk. Default is to use the existing disk.
        #     Check the OnUpdateAction enum for the list of possible values.
        # @!attribute [rw] provisioned_iops
        #   @return [::Integer]
        #     Indicates how many IOPS to provision for the disk. This sets the number of I/O operations per second that the disk can handle. Values must be between 10,000 and 120,000. For more details, see the Extreme persistent disk documentation.
        # @!attribute [rw] provisioned_throughput
        #   @return [::Integer]
        #     Indicates how much throughput to provision for the disk. This sets the number of throughput mb per second that the disk can handle. Values must greater than or equal to 1.
        # @!attribute [rw] replica_zones
        #   @return [::Array<::String>]
        #     Required for each regional disk associated with the instance. Specify the URLs of the zones where the disk should be replicated to. You must provide exactly two replica zones, and one zone must be the same as the instance zone.
        # @!attribute [rw] resource_manager_tags
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Resource manager tags to be bound to the disk. Tag keys and values have the same definition as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id}`, and values are in the format `tagValues/456`. The field is ignored (both PUT & PATCH) when empty.
        # @!attribute [rw] resource_policies
        #   @return [::Array<::String>]
        #     Resource policies applied to this disk for automatic snapshot creations. Specified using the full or partial URL. For instance template, specify only the resource policy name.
        # @!attribute [rw] source_image
        #   @return [::String]
        #     The source image to create this disk. When creating a new instance boot disk, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required. To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image: projects/debian-cloud/global/images/family/debian-9 Alternatively, use a specific version of a public operating system image: projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD To create a disk with a custom image that you created, specify the image name in the following format: global/images/my-custom-image You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name: global/images/family/my-image-family If the source image is deleted later, this field will not be set.
        # @!attribute [rw] source_image_encryption_key
        #   @return [::Google::Cloud::Compute::V1::CustomerEncryptionKey]
        #     The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key. InstanceTemplate and InstancePropertiesPatch do not store customer-supplied encryption keys, so you cannot create disks for instances in a managed instance group if the source images are encrypted with your own keys.
        # @!attribute [rw] source_snapshot
        #   @return [::String]
        #     The source snapshot to create this disk. When creating a new instance boot disk, one of initializeParams.sourceSnapshot or initializeParams.sourceImage or disks.source is required. To create a disk with a snapshot that you created, specify the snapshot name in the following format: global/snapshots/my-backup If the source snapshot is deleted later, this field will not be set. Note: You cannot create VMs in bulk using a snapshot as the source. Use an image instead when you create VMs using the bulk insert method.
        # @!attribute [rw] source_snapshot_encryption_key
        #   @return [::Google::Cloud::Compute::V1::CustomerEncryptionKey]
        #     The customer-supplied encryption key of the source snapshot.
        # @!attribute [rw] storage_pool
        #   @return [::String]
        #     The storage pool in which the new disk is created. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /storagePools/storagePool - projects/project/zones/zone/storagePools/storagePool - zones/zone/storagePools/storagePool
        class AttachedDiskInitializeParams
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class ResourceManagerTagsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The architecture of the attached disk. Valid values are arm64 or x86_64.
          module Architecture
            # A value indicating that the enum field is not set.
            UNDEFINED_ARCHITECTURE = 0

            # Default value indicating Architecture is not set.
            ARCHITECTURE_UNSPECIFIED = 394_750_507

            # Machines with architecture ARM64
            ARM64 = 62_547_450

            # Machines with architecture X86_64
            X86_64 = 425_300_551
          end

          # Specifies which action to take on instance update with this disk. Default is to use the existing disk.
          module OnUpdateAction
            # A value indicating that the enum field is not set.
            UNDEFINED_ON_UPDATE_ACTION = 0

            # Always recreate the disk.
            RECREATE_DISK = 494_767_853

            # Recreate the disk if source (image, snapshot) of this disk is different from source of existing disk.
            RECREATE_DISK_IF_SOURCE_CHANGED = 398_099_712

            # Use the existing disk, this is the default behaviour.
            USE_EXISTING_DISK = 232_682_233
          end
        end

        # Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
        # @!attribute [rw] audit_log_configs
        #   @return [::Array<::Google::Cloud::Compute::V1::AuditLogConfig>]
        #     The configuration for logging of each type of permission.
        # @!attribute [rw] exempted_members
        #   @return [::Array<::String>]
        # @!attribute [rw] service
        #   @return [::String]
        #     Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        class AuditConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        # @!attribute [rw] exempted_members
        #   @return [::Array<::String>]
        #     Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        # @!attribute [rw] ignore_child_exemptions
        #   @return [::Boolean]
        # @!attribute [rw] log_type
        #   @return [::String]
        #     The log type that this config enables.
        #     Check the LogType enum for the list of possible values.
        class AuditLogConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The log type that this config enables.
          module LogType
            # A value indicating that the enum field is not set.
            UNDEFINED_LOG_TYPE = 0

            # Admin reads. Example: CloudIAM getIamPolicy
            ADMIN_READ = 128_951_462

            # Data reads. Example: CloudSQL Users list
            DATA_READ = 305_224_971

            # Data writes. Example: CloudSQL Users create
            DATA_WRITE = 340_181_738

            # Default case. Should never be this.
            LOG_TYPE_UNSPECIFIED = 154_527_053
          end
        end

        # Represents an Autoscaler resource. Google Compute Engine has two Autoscaler resources: * [Zonal](/compute/docs/reference/rest/v1/autoscalers) * [Regional](/compute/docs/reference/rest/v1/regionAutoscalers) Use autoscalers to automatically add or delete instances from a managed instance group according to your defined autoscaling policy. For more information, read Autoscaling Groups of Instances. For zonal managed instance groups resource, use the autoscaler resource. For regional managed instance groups, use the regionAutoscalers resource.
        # @!attribute [rw] autoscaling_policy
        #   @return [::Google::Cloud::Compute::V1::AutoscalingPolicy]
        #     The configuration parameters for the autoscaling algorithm. You can define one or more signals for an autoscaler: cpuUtilization, customMetricUtilizations, and loadBalancingUtilization. If none of these are specified, the default will be to autoscale based on cpuUtilization to 0.6 or 60%.
        # @!attribute [rw] creation_timestamp
        #   @return [::String]
        #     [Output Only] Creation timestamp in RFC3339 text format.
        # @!attribute [rw] description
        #   @return [::String]
        #     An optional description of this resource. Provide this property when you create the resource.
        # @!attribute [rw] id
        #   @return [::Integer]
        #     [Output Only] The unique identifier for the resource. This identifier is defined by the server.
        # @!attribute [rw] kind
        #   @return [::String]
        #     [Output Only] Type of the resource. Always compute#autoscaler for autoscalers.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        # @!attribute [rw] recommended_size
        #   @return [::Integer]
        #     [Output Only] Target recommended MIG size (number of instances) computed by autoscaler. Autoscaler calculates the recommended MIG size even when the autoscaling policy mode is different from ON. This field is empty when autoscaler is not connected to an existing managed instance group or autoscaler did not generate its prediction.
        # @!attribute [rw] region
        #   @return [::String]
        #     [Output Only] URL of the region where the instance group resides (for autoscalers living in regional scope).
        # @!attribute [rw] scaling_schedule_status
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Compute::V1::ScalingScheduleStatus}]
        #     [Output Only] Status information of existing scaling schedules.
        # @!attribute [rw] self_link
        #   @return [::String]
        #     [Output Only] Server-defined URL for the resource.
        # @!attribute [rw] status
        #   @return [::String]
        #     [Output Only] The status of the autoscaler configuration. Current set of possible values: - PENDING: Autoscaler backend hasn't read new/updated configuration. - DELETING: Configuration is being deleted. - ACTIVE: Configuration is acknowledged to be effective. Some warnings might be present in the statusDetails field. - ERROR: Configuration has errors. Actionable for users. Details are present in the statusDetails field. New values might be added in the future.
        #     Check the Status enum for the list of possible values.
        # @!attribute [rw] status_details
        #   @return [::Array<::Google::Cloud::Compute::V1::AutoscalerStatusDetails>]
        #     [Output Only] Human-readable details about the current state of the autoscaler. Read the documentation for Commonly returned status messages for examples of status messages you might encounter.
        # @!attribute [rw] target
        #   @return [::String]
        #     URL of the managed instance group that this autoscaler will scale. This field is required when creating an autoscaler.
        # @!attribute [rw] zone
        #   @return [::String]
        #     [Output Only] URL of the zone where the instance group resides (for autoscalers living in zonal scope).
        class Autoscaler
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Compute::V1::ScalingScheduleStatus]
          class ScalingScheduleStatusEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # [Output Only] The status of the autoscaler configuration. Current set of possible values: - PENDING: Autoscaler backend hasn't read new/updated configuration. - DELETING: Configuration is being deleted. - ACTIVE: Configuration is acknowledged to be effective. Some warnings might be present in the statusDetails field. - ERROR: Configuration has errors. Actionable for users. Details are present in the statusDetails field. New values might be added in the future.
          module Status
            # A value indicating that the enum field is not set.
            UNDEFINED_STATUS = 0

            # Configuration is acknowledged to be effective
            ACTIVE = 314_733_318

            # Configuration is being deleted
            DELETING = 528_602_024

            # Configuration has errors. Actionable for users.
            ERROR = 66_247_144

            # Autoscaler backend hasn't read new/updated configuration
            PENDING = 35_394_935
          end
        end

        # @!attribute [rw] id
        #   @return [::String]
        #     [Output Only] Unique identifier for the resource; defined by the server.
        # @!attribute [rw] items
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Compute::V1::AutoscalersScopedList}]
        #     A list of AutoscalersScopedList resources.
        # @!attribute [rw] kind
        #   @return [::String]
        #     [Output Only] Type of resource. Always compute#autoscalerAggregatedList for aggregated lists of autoscalers.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
        # @!attribute [rw] self_link
        #   @return [::String]
        #     [Output Only] Server-defined URL for this resource.
        # @!attribute [rw] unreachables
        #   @return [::Array<::String>]
        #     [Output Only] Unreachable resources. end_interface: MixerListResponseWithEtagBuilder
        # @!attribute [rw] warning
        #   @return [::Google::Cloud::Compute::V1::Warning]
        #     [Output Only] Informational warning message.
        class AutoscalerAggregatedList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Compute::V1::AutoscalersScopedList]
          class ItemsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Contains a list of Autoscaler resources.
        # @!attribute [rw] id
        #   @return [::String]
        #     [Output Only] Unique identifier for the resource; defined by the server.
        # @!attribute [rw] items
        #   @return [::Array<::Google::Cloud::Compute::V1::Autoscaler>]
        #     A list of Autoscaler resources.
        # @!attribute [rw] kind
        #   @return [::String]
        #     [Output Only] Type of resource. Always compute#autoscalerList for lists of autoscalers.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
        # @!attribute [rw] self_link
        #   @return [::String]
        #     [Output Only] Server-defined URL for this resource.
        # @!attribute [rw] warning
        #   @return [::Google::Cloud::Compute::V1::Warning]
        #     [Output Only] Informational warning message.
        class AutoscalerList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] message
        #   @return [::String]
        #     The status message.
        # @!attribute [rw] type
        #   @return [::String]
        #     The type of error, warning, or notice returned. Current set of possible values: - ALL_INSTANCES_UNHEALTHY (WARNING): All instances in the instance group are unhealthy (not in RUNNING state). - BACKEND_SERVICE_DOES_NOT_EXIST (ERROR): There is no backend service attached to the instance group. - CAPPED_AT_MAX_NUM_REPLICAS (WARNING): Autoscaler recommends a size greater than maxNumReplicas. - CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE (WARNING): The custom metric samples are not exported often enough to be a credible base for autoscaling. - CUSTOM_METRIC_INVALID (ERROR): The custom metric that was specified does not exist or does not have the necessary labels. - MIN_EQUALS_MAX (WARNING): The minNumReplicas is equal to maxNumReplicas. This means the autoscaler cannot add or remove instances from the instance group. - MISSING_CUSTOM_METRIC_DATA_POINTS (WARNING): The autoscaler did not receive any data from the custom metric configured for autoscaling. - MISSING_LOAD_BALANCING_DATA_POINTS (WARNING): The autoscaler is configured to scale based on a load balancing signal but the instance group has not received any requests from the load balancer. - MODE_OFF (WARNING): Autoscaling is turned off. The number of instances in the group won't change automatically. The autoscaling configuration is preserved. - MODE_ONLY_UP (WARNING): Autoscaling is in the "Autoscale only out" mode. The autoscaler can add instances but not remove any. - MORE_THAN_ONE_BACKEND_SERVICE (ERROR): The instance group cannot be autoscaled because it has more than one backend service attached to it. - NOT_ENOUGH_QUOTA_AVAILABLE (ERROR): There is insufficient quota for the necessary resources, such as CPU or number of instances. - REGION_RESOURCE_STOCKOUT (ERROR): Shown only for regional autoscalers: there is a resource stockout in the chosen region. - SCALING_TARGET_DOES_NOT_EXIST (ERROR): The target to be scaled does not exist. - UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION (ERROR): Autoscaling does not work with an HTTP/S load balancer that has been configured for maxRate. - ZONE_RESOURCE_STOCKOUT (ERROR): For zonal autoscalers: there is a resource stockout in the chosen zone. For regional autoscalers: in at least one of the zones you're using there is a resource stockout. New values might be added in the future. Some of the values might not be available in all API versions.
        #     Check the Type enum for the list of possible values.
        class AutoscalerStatusDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The type of error, warning, or notice returned. Current set of possible values: - ALL_INSTANCES_UNHEALTHY (WARNING): All instances in the instance group are unhealthy (not in RUNNING state). - BACKEND_SERVICE_DOES_NOT_EXIST (ERROR): There is no backend service attached to the instance group. - CAPPED_AT_MAX_NUM_REPLICAS (WARNING): Autoscaler recommends a size greater than maxNumReplicas. - CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE (WARNING): The custom metric samples are not exported often enough to be a credible base for autoscaling. - CUSTOM_METRIC_INVALID (ERROR): The custom metric that was specified does not exist or does not have the necessary labels. - MIN_EQUALS_MAX (WARNING): The minNumReplicas is equal to maxNumReplicas. This means the autoscaler cannot add or remove instances from the instance group. - MISSING_CUSTOM_METRIC_DATA_POINTS (WARNING): The autoscaler did not receive any data from the custom metric configured for autoscaling. - MISSING_LOAD_BALANCING_DATA_POINTS (WARNING): The autoscaler is configured to scale based on a load balancing signal but the instance group has not received any requests from the load balancer. - MODE_OFF (WARNING): Autoscaling is turned off. The number of instances in the group won't change automatically. The autoscaling configuration is preserved. - MODE_ONLY_UP (WARNING): Autoscaling is in the "Autoscale only out" mode. The autoscaler can add instances but not remove any. - MORE_THAN_ONE_BACKEND_SERVICE (ERROR): The instance group cannot be autoscaled because it has more than one backend service attached to it. - NOT_ENOUGH_QUOTA_AVAILABLE (ERROR): There is insufficient quota for the necessary resources, such as CPU or number of instances. - REGION_RESOURCE_STOCKOUT (ERROR): Shown only for regional autoscalers: there is a resource stockout in the chosen region. - SCALING_TARGET_DOES_NOT_EXIST (ERROR): The target to be scaled does not exist. - UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION (ERROR): Autoscaling does not work with an HTTP/S load balancer that has been configured for maxRate. - ZONE_RESOURCE_STOCKOUT (ERROR): For zonal autoscalers: there is a resource stockout in the chosen zone. For regional autoscalers: in at least one of the zones you're using there is a resource stockout. New values might be added in the future. Some of the values might not be available in all API versions.
          module Type
            # A value indicating that the enum field is not set.
            UNDEFINED_TYPE = 0

            # All instances in the instance group are unhealthy (not in RUNNING state).
            ALL_INSTANCES_UNHEALTHY = 404_965_477

            # There is no backend service attached to the instance group.
            BACKEND_SERVICE_DOES_NOT_EXIST = 191_417_626

            # Autoscaler recommends a size greater than maxNumReplicas.
            CAPPED_AT_MAX_NUM_REPLICAS = 518_617

            # The custom metric samples are not exported often enough to be a credible base for autoscaling.
            CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE = 328_964_659

            # The custom metric that was specified does not exist or does not have the necessary labels.
            CUSTOM_METRIC_INVALID = 204_430_550

            # The minNumReplicas is equal to maxNumReplicas. This means the autoscaler cannot add or remove instances from the instance group.
            MIN_EQUALS_MAX = 2_821_361

            # The autoscaler did not receive any data from the custom metric configured for autoscaling.
            MISSING_CUSTOM_METRIC_DATA_POINTS = 94_885_086

            # The autoscaler is configured to scale based on a load balancing signal but the instance group has not received any requests from the load balancer.
            MISSING_LOAD_BALANCING_DATA_POINTS = 509_858_898

            # Autoscaling is turned off. The number of instances in the group won't change automatically. The autoscaling configuration is preserved.
            MODE_OFF = 164_169_907

            # Autoscaling is in the "Autoscale only scale out" mode. Instances in the group will be only added.
            MODE_ONLY_SCALE_OUT = 3_840_994

            # Autoscaling is in the "Autoscale only out" mode. Instances in the group will be only added.
            MODE_ONLY_UP = 100_969_842

            # The instance group cannot be autoscaled because it has more than one backend service attached to it.
            MORE_THAN_ONE_BACKEND_SERVICE = 151_922_141

            # There is insufficient quota for the necessary resources, such as CPU or number of instances.
            NOT_ENOUGH_QUOTA_AVAILABLE = 403_101_631

            # Showed only for regional autoscalers: there is a resource stockout in the chosen region.
            REGION_RESOURCE_STOCKOUT = 528_622_846

            # The target to be scaled does not exist.
            SCALING_TARGET_DOES_NOT_EXIST = 122_636_699

            # For some scaling schedules minRequiredReplicas is greater than maxNumReplicas. Autoscaler always recommends at most maxNumReplicas instances.
            SCHEDULED_INSTANCES_GREATER_THAN_AUTOSCALER_MAX = 29_275_586

            # For some scaling schedules minRequiredReplicas is less than minNumReplicas. Autoscaler always recommends at least minNumReplicas instances.
            SCHEDULED_INSTANCES_LESS_THAN_AUTOSCALER_MIN = 398_287_669

            UNKNOWN = 433_141_802

            # Autoscaling does not work with an HTTP/S load balancer that has been configured for maxRate.
            UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION = 330_845_009

            # For zonal autoscalers: there is a resource stockout in the chosen zone. For regional autoscalers: in at least one of the zones you're using there is a resource stockout.
            ZONE_RESOURCE_STOCKOUT = 210_200_502
          end
        end

        # @!attribute [rw] autoscalers
        #   @return [::Array<::Google::Cloud::Compute::V1::Autoscaler>]
        #     [Output Only] A list of autoscalers contained in this scope.
        # @!attribute [rw] warning
        #   @return [::Google::Cloud::Compute::V1::Warning]
        #     [Output Only] Informational warning which replaces the list of autoscalers when the list is empty.
        class AutoscalersScopedList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Cloud Autoscaler policy.
        # @!attribute [rw] cool_down_period_sec
        #   @return [::Integer]
        #     The number of seconds that your application takes to initialize on a VM instance. This is referred to as the [initialization period](/compute/docs/autoscaler#cool_down_period). Specifying an accurate initialization period improves autoscaler decisions. For example, when scaling out, the autoscaler ignores data from VMs that are still initializing because those VMs might not yet represent normal usage of your application. The default initialization period is 60 seconds. Initialization periods might vary because of numerous factors. We recommend that you test how long your application takes to initialize. To do this, create a VM and time your application's startup process.
        # @!attribute [rw] cpu_utilization
        #   @return [::Google::Cloud::Compute::V1::AutoscalingPolicyCpuUtilization]
        #     Defines the CPU utilization policy that allows the autoscaler to scale based on the average CPU utilization of a managed instance group.
        # @!attribute [rw] custom_metric_utilizations
        #   @return [::Array<::Google::Cloud::Compute::V1::AutoscalingPolicyCustomMetricUtilization>]
        #     Configuration parameters of autoscaling based on a custom metric.
        # @!attribute [rw] load_balancing_utilization
        #   @return [::Google::Cloud::Compute::V1::AutoscalingPolicyLoadBalancingUtilization]
        #     Configuration parameters of autoscaling based on load balancer.
        # @!attribute [rw] max_num_replicas
        #   @return [::Integer]
        #     The maximum number of instances that the autoscaler can scale out to. This is required when creating or updating an autoscaler. The maximum number of replicas must not be lower than minimal number of replicas.
        # @!attribute [rw] min_num_replicas
        #   @return [::Integer]
        #     The minimum number of replicas that the autoscaler can scale in to. This cannot be less than 0. If not provided, autoscaler chooses a default value depending on maximum number of instances allowed.
        # @!attribute [rw] mode
        #   @return [::String]
        #     Defines the operating mode for this policy. The following modes are available: - OFF: Disables the autoscaler but maintains its configuration. - ONLY_SCALE_OUT: Restricts the autoscaler to add VM instances only. - ON: Enables all autoscaler activities according to its policy. For more information, see "Turning off or restricting an autoscaler"
        #     Check the Mode enum for the list of possible values.
        # @!attribute [rw] scale_in_control
        #   @return [::Google::Cloud::Compute::V1::AutoscalingPolicyScaleInControl]
        # @!attribute [rw] scaling_schedules
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Compute::V1::AutoscalingPolicyScalingSchedule}]
        #     Scaling schedules defined for an autoscaler. Multiple schedules can be set on an autoscaler, and they can overlap. During overlapping periods the greatest min_required_replicas of all scaling schedules is applied. Up to 128 scaling schedules are allowed.
        class AutoscalingPolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Compute::V1::AutoscalingPolicyScalingSchedule]
          class ScalingSchedulesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Defines the operating mode for this policy. The following modes are available: - OFF: Disables the autoscaler but maintains its configuration. - ONLY_SCALE_OUT: Restricts the autoscaler to add VM instances only. - ON: Enables all autoscaler activities according to its policy. For more information, see "Turning off or restricting an autoscaler"
          module Mode
            # A value indicating that the enum field is not set.
            UNDEFINED_MODE = 0

            # Do not automatically scale the MIG in or out. The recommended_size field contains the size of MIG that would be set if the actuation mode was enabled.
            OFF = 78_159

            # Automatically scale the MIG in and out according to the policy.
            ON = 2527

            # Automatically create VMs according to the policy, but do not scale the MIG in.
            ONLY_SCALE_OUT = 152_713_670

            # Automatically create VMs according to the policy, but do not scale the MIG in.
            ONLY_UP = 478_095_374
          end
        end

        # CPU utilization policy.
        # @!attribute [rw] predictive_method
        #   @return [::String]
        #     Indicates whether predictive autoscaling based on CPU metric is enabled. Valid values are: * NONE (default). No predictive method is used. The autoscaler scales the group to meet current demand based on real-time metrics. * OPTIMIZE_AVAILABILITY. Predictive autoscaling improves availability by monitoring daily and weekly load patterns and scaling out ahead of anticipated demand.
        #     Check the PredictiveMethod enum for the list of possible values.
        # @!attribute [rw] utilization_target
        #   @return [::Float]
        #     The target CPU utilization that the autoscaler maintains. Must be a float value in the range (0, 1]. If not specified, the default is 0.6. If the CPU level is below the target utilization, the autoscaler scales in the number of instances until it reaches the minimum number of instances you specified or until the average CPU of your instances reaches the target utilization. If the average CPU is above the target utilization, the autoscaler scales out until it reaches the maximum number of instances you specified or until the average utilization reaches the target utilization.
        class AutoscalingPolicyCpuUtilization
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Indicates whether predictive autoscaling based on CPU metric is enabled. Valid values are: * NONE (default). No predictive method is used. The autoscaler scales the group to meet current demand based on real-time metrics. * OPTIMIZE_AVAILABILITY. Predictive autoscaling improves availability by monitoring daily and weekly load patterns and scaling out ahead of anticipated demand.
          module PredictiveMethod
            # A value indicating that the enum field is not set.
            UNDEFINED_PREDICTIVE_METHOD = 0

            # No predictive method is used. The autoscaler scales the group to meet current demand based on real-time metrics
            NONE = 2_402_104

            # Predictive autoscaling improves availability by monitoring daily and weekly load patterns and scaling out ahead of anticipated demand.
            OPTIMIZE_AVAILABILITY = 11_629_437
          end
        end

        # Custom utilization metric policy.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter string, compatible with a Stackdriver Monitoring filter string for TimeSeries.list API call. This filter is used to select a specific TimeSeries for the purpose of autoscaling and to determine whether the metric is exporting per-instance or per-group data. For the filter to be valid for autoscaling purposes, the following rules apply: - You can only use the AND operator for joining selectors. - You can only use direct equality comparison operator (=) without any functions for each selector. - You can specify the metric in both the filter string and in the metric field. However, if specified in both places, the metric must be identical. - The monitored resource type determines what kind of values are expected for the metric. If it is a gce_instance, the autoscaler expects the metric to include a separate TimeSeries for each instance in a group. In such a case, you cannot filter on resource labels. If the resource type is any other value, the autoscaler expects this metric to contain values that apply to the entire autoscaled instance group and resource label filtering can be performed to point autoscaler at the correct TimeSeries to scale upon. This is called a *per-group metric* for the purpose of autoscaling. If not specified, the type defaults to gce_instance. Try to provide a filter that is selective enough to pick just one TimeSeries for the autoscaled group or for each of the instances (if you are using gce_instance resource type). If multiple TimeSeries are returned upon the query execution, the autoscaler will sum their respective values to obtain its scaling value.
        # @!attribute [rw] metric
        #   @return [::String]
        #     The identifier (type) of the Stackdriver Monitoring metric. The metric cannot have negative values. The metric must have a value type of INT64 or DOUBLE.
        # @!attribute [rw] single_instance_assignment
        #   @return [::Float]
        #     If scaling is based on a per-group metric value that represents the total amount of work to be done or resource usage, set this value to an amount assigned for a single instance of the scaled group. Autoscaler keeps the number of instances proportional to the value of this metric. The metric itself does not change value due to group resizing. A good metric to use with the target is for example pubsub.googleapis.com/subscription/num_undelivered_messages or a custom metric exporting the total number of requests coming to your instances. A bad example would be a metric exporting an average or median latency, since this value can't include a chunk assignable to a single instance, it could be better used with utilization_target instead.
        # @!attribute [rw] utilization_target
        #   @return [::Float]
        #     The target value of the metric that autoscaler maintains. This must be a positive value. A utilization metric scales number of virtual machines handling requests to increase or decrease proportionally to the metric. For example, a good metric to use as a utilization_target is https://www.googleapis.com/compute/v1/instance/network/received_bytes_count. The autoscaler works to keep this value constant for each of the instances.
        # @!attribute [rw] utilization_target_type
        #   @return [::String]
        #     Defines how target utilization value is expressed for a Stackdriver Monitoring metric. Either GAUGE, DELTA_PER_SECOND, or DELTA_PER_MINUTE.
        #     Check the UtilizationTargetType enum for the list of possible values.
        class AutoscalingPolicyCustomMetricUtilization
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Defines how target utilization value is expressed for a Stackdriver Monitoring metric. Either GAUGE, DELTA_PER_SECOND, or DELTA_PER_MINUTE.
          module UtilizationTargetType
            # A value indicating that the enum field is not set.
            UNDEFINED_UTILIZATION_TARGET_TYPE = 0

            # Sets the utilization target value for a cumulative or delta metric, expressed as the rate of growth per minute.
            DELTA_PER_MINUTE = 87_432_861

            # Sets the utilization target value for a cumulative or delta metric, expressed as the rate of growth per second.
            DELTA_PER_SECOND = 255_180_029

            # Sets the utilization target value for a gauge metric. The autoscaler will collect the average utilization of the virtual machines from the last couple of minutes, and compare the value to the utilization target value to perform autoscaling.
            GAUGE = 67_590_361
          end
        end

        # Configuration parameters of autoscaling based on load balancing.
        # @!attribute [rw] utilization_target
        #   @return [::Float]
        #     Fraction of backend capacity utilization (set in HTTP(S) load balancing configuration) that the autoscaler maintains. Must be a positive float value. If not defined, the default is 0.8.
        class AutoscalingPolicyLoadBalancingUtilization
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration that allows for slower scale in so that even if Autoscaler recommends an abrupt scale in of a MIG, it will be throttled as specified by the parameters below.
        # @!attribute [rw] max_scaled_in_replicas
        #   @return [::Google::Cloud::Compute::V1::FixedOrPercent]
        #     Maximum allowed number (or %) of VMs that can be deducted from the peak recommendation during the window autoscaler looks at when computing recommendations. Possibly all these VMs can be deleted at once so user service needs to be prepared to lose that many VMs in one step.
        # @!attribute [rw] time_window_sec
        #   @return [::Integer]
        #     How far back autoscaling looks when computing recommendations to include directives regarding slower scale in, as described above.
        class AutoscalingPolicyScaleInControl
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Scaling based on user-defined schedule. The message describes a single scaling schedule. A scaling schedule changes the minimum number of VM instances an autoscaler can recommend, which can trigger scaling out.
        # @!attribute [rw] description
        #   @return [::String]
        #     A description of a scaling schedule.
        # @!attribute [rw] disabled
        #   @return [::Boolean]
        #     A boolean value that specifies whether a scaling schedule can influence autoscaler recommendations. If set to true, then a scaling schedule has no effect. This field is optional, and its value is false by default.
        # @!attribute [rw] duration_sec
        #   @return [::Integer]
        #     The duration of time intervals, in seconds, for which this scaling schedule is to run. The minimum allowed value is 300. This field is required.
        # @!attribute [rw] min_required_replicas
        #   @return [::Integer]
        #     The minimum number of VM instances that the autoscaler will recommend in time intervals starting according to schedule. This field is required.
        # @!attribute [rw] schedule
        #   @return [::String]
        #     The start timestamps of time intervals when this scaling schedule is to provide a scaling signal. This field uses the extended cron format (with an optional year field). The expression can describe a single timestamp if the optional year is set, in which case the scaling schedule runs once. The schedule is interpreted with respect to time_zone. This field is required. Note: These timestamps only describe when autoscaler starts providing the scaling signal. The VMs need additional time to become serving.
        # @!attribute [rw] time_zone
        #   @return [::String]
        #     The time zone to use when interpreting the schedule. The value of this field must be a time zone name from the tz database: https://en.wikipedia.org/wiki/Tz_database. This field is assigned a default value of "UTC" if left empty.
        class AutoscalingPolicyScalingSchedule
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message containing information of one individual backend.
        # @!attribute [rw] balancing_mode
        #   @return [::String]
        #     Specifies how to determine whether the backend of a load balancer can handle additional traffic or is fully loaded. For usage guidelines, see Connection balancing mode. Backends must use compatible balancing modes. For more information, see Supported balancing modes and target capacity settings and Restrictions and guidance for instance groups. Note: Currently, if you use the API to configure incompatible balancing modes, the configuration might be accepted even though it has no impact and is ignored. Specifically, Backend.maxUtilization is ignored when Backend.balancingMode is RATE. In the future, this incompatible combination will be rejected.
        #     Check the BalancingMode enum for the list of possible values.
        # @!attribute [rw] capacity_scaler
        #   @return [::Float]
        #     A multiplier applied to the backend's target capacity of its balancing mode. The default value is 1, which means the group serves up to 100% of its configured capacity (depending on balancingMode). A setting of 0 means the group is completely drained, offering 0% of its available capacity. The valid ranges are 0.0 and [0.1,1.0]. You cannot configure a setting larger than 0 and smaller than 0.1. You cannot configure a setting of 0 when there is only one backend attached to the backend service. Not available with backends that don't support using a balancingMode. This includes backends such as global internet NEGs, regional serverless NEGs, and PSC NEGs.
        # @!attribute [rw] custom_metrics
        #   @return [::Array<::Google::Cloud::Compute::V1::BackendCustomMetric>]
        #     List of custom metrics that are used for CUSTOM_METRICS BalancingMode.
        # @!attribute [rw] description
        #   @return [::String]
        #     An optional description of this resource. Provide this property when you create the resource.
        # @!attribute [rw] failover
        #   @return [::Boolean]
        #     This field designates whether this is a failover backend. More than one failover backend can be configured for a given BackendService.
        # @!attribute [rw] group
        #   @return [::String]
        #     The fully-qualified URL of an instance group or network endpoint group (NEG) resource. To determine what types of backends a load balancer supports, see the [Backend services overview](https://cloud.google.com/load-balancing/docs/backend-service#backends). You must use the *fully-qualified* URL (starting with https://www.googleapis.com/) to specify the instance group or NEG. Partial URLs are not supported. If haPolicy is specified, backends must refer to NEG resources of type GCE_VM_IP.
        # @!attribute [rw] max_connections
        #   @return [::Integer]
        #     Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.
        # @!attribute [rw] max_connections_per_endpoint
        #   @return [::Integer]
        #     Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.
        # @!attribute [rw] max_connections_per_instance
        #   @return [::Integer]
        #     Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.
        # @!attribute [rw] max_rate
        #   @return [::Integer]
        #     Defines a maximum number of HTTP requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.
        # @!attribute [rw] max_rate_per_endpoint
        #   @return [::Float]
        #     Defines a maximum target for requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.
        # @!attribute [rw] max_rate_per_instance
        #   @return [::Float]
        #     Defines a maximum target for requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.
        # @!attribute [rw] max_utilization
        #   @return [::Float]
        #     Optional parameter to define a target capacity for the UTILIZATION balancing mode. The valid range is [0.0, 1.0]. For usage guidelines, see Utilization balancing mode.
        # @!attribute [rw] preference
        #   @return [::String]
        #     This field indicates whether this backend should be fully utilized before sending traffic to backends with default preference. The possible values are: - PREFERRED: Backends with this preference level will be filled up to their capacity limits first, based on RTT. - DEFAULT: If preferred backends don't have enough capacity, backends in this layer would be used and traffic would be assigned based on the load balancing algorithm you use. This is the default
        #     Check the Preference enum for the list of possible values.
        class Backend
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Specifies how to determine whether the backend of a load balancer can handle additional traffic or is fully loaded. For usage guidelines, see Connection balancing mode. Backends must use compatible balancing modes. For more information, see Supported balancing modes and target capacity settings and Restrictions and guidance for instance groups. Note: Currently, if you use the API to configure incompatible balancing modes, the configuration might be accepted even though it has no impact and is ignored. Specifically, Backend.maxUtilization is ignored when Backend.balancingMode is RATE. In the future, this incompatible combination will be rejected.
          module BalancingMode
            # A value indicating that the enum field is not set.
            UNDEFINED_BALANCING_MODE = 0

            # Balance based on the number of simultaneous connections.
            CONNECTION = 246_311_646

            # Based on custom defined and reported metrics.
            CUSTOM_METRICS = 331_575_765

            # Balance based on requests per second (RPS).
            RATE = 2_508_000

            # Balance based on the backend utilization.
            UTILIZATION = 157_008_386
          end

          # This field indicates whether this backend should be fully utilized before sending traffic to backends with default preference. The possible values are: - PREFERRED: Backends with this preference level will be filled up to their capacity limits first, based on RTT. - DEFAULT: If preferred backends don't have enough capacity, backends in this layer would be used and traffic would be assigned based on the load balancing algorithm you use. This is the default
          module Preference
            # A value indicating that the enum field is not set.
            UNDEFINED_PREFERENCE = 0

            # No preference.
            DEFAULT = 115_302_945

            # If preference is unspecified, we set it to the DEFAULT value
            PREFERENCE_UNSPECIFIED = 496_219_571

            # Traffic will be sent to this backend first.
            PREFERRED = 418_847_841
          end
        end

        # Represents a Cloud Storage Bucket resource. This Cloud Storage bucket resource is referenced by a URL map of a load balancer. For more information, read Backend Buckets.
        # @!attribute [rw] bucket_name
        #   @return [::String]
        #     Cloud Storage bucket name.
        # @!attribute [rw] cdn_policy
        #   @return [::Google::Cloud::Compute::V1::BackendBucketCdnPolicy]
        #     Cloud CDN configuration for this BackendBucket.
        # @!attribute [rw] compression_mode
        #   @return [::String]
        #     Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
        #     Check the CompressionMode enum for the list of possible values.
        # @!attribute [rw] creation_timestamp
        #   @return [::String]
        #     [Output Only] Creation timestamp in RFC3339 text format.
        # @!attribute [rw] custom_response_headers
        #   @return [::Array<::String>]
        #     Headers that the Application Load Balancer should add to proxied responses.
        # @!attribute [rw] description
        #   @return [::String]
        #     An optional textual description of the resource; provided by the client when the resource is created.
        # @!attribute [rw] edge_security_policy
        #   @return [::String]
        #     [Output Only] The resource URL for the edge security policy associated with this backend bucket.
        # @!attribute [rw] enable_cdn
        #   @return [::Boolean]
        #     If true, enable Cloud CDN for this BackendBucket.
        # @!attribute [rw] id
        #   @return [::Integer]
        #     [Output Only] Unique identifier for the resource; defined by the server.
        # @!attribute [rw] kind
        #   @return [::String]
        #     Type of the resource.
        # @!attribute [rw] load_balancing_scheme
        #   @return [::String]
        #     The value can only be INTERNAL_MANAGED for cross-region internal layer 7 load balancer. If loadBalancingScheme is not specified, the backend bucket can be used by classic global external load balancers, or global application external load balancers, or both.
        #     Check the LoadBalancingScheme enum for the list of possible values.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        # @!attribute [rw] params
        #   @return [::Google::Cloud::Compute::V1::BackendBucketParams]
        #     Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
        # @!attribute [rw] self_link
        #   @return [::String]
        #     [Output Only] Server-defined URL for the resource.
        # @!attribute [rw] used_by
        #   @return [::Array<::Google::Cloud::Compute::V1::BackendBucketUsedBy>]
        #     [Output Only] List of resources referencing that backend bucket.
        class BackendBucket
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
          module CompressionMode
            # A value indicating that the enum field is not set.
            UNDEFINED_COMPRESSION_MODE = 0

            # Automatically uses the best compression based on the Accept-Encoding header sent by the client.
            AUTOMATIC = 165_298_699

            # Disables compression. Existing compressed responses cached by Cloud CDN will not be served to clients.
            DISABLED = 516_696_700
          end

          # The value can only be INTERNAL_MANAGED for cross-region internal layer 7 load balancer. If loadBalancingScheme is not specified, the backend bucket can be used by classic global external load balancers, or global application external load balancers, or both.
          module LoadBalancingScheme
            # A value indicating that the enum field is not set.
            UNDEFINED_LOAD_BALANCING_SCHEME = 0

            # Signifies that this will be used for internal Application Load Balancers.
            INTERNAL_MANAGED = 37_350_397
          end
        end

        # Message containing Cloud CDN configuration for a backend bucket.
        # @!attribute [rw] bypass_cache_on_request_headers
        #   @return [::Array<::Google::Cloud::Compute::V1::BackendBucketCdnPolicyBypassCacheOnRequestHeader>]
        #     Bypass the cache when the specified request headers are matched - e.g. Pragma or Authorization headers. Up to 5 headers can be specified. The cache is bypassed for all cdnPolicy.cacheMode settings.
        # @!attribute [rw] cache_key_policy
        #   @return [::Google::Cloud::Compute::V1::BackendBucketCdnPolicyCacheKeyPolicy]
        #     The CacheKeyPolicy for this CdnPolicy.
        # @!attribute [rw] cache_mode
        #   @return [::String]
        #     Specifies the cache setting for all responses from this backend. The possible values are: USE_ORIGIN_HEADERS Requires the origin to set valid caching headers to cache content. Responses without these headers will not be cached at Google's edge, and will require a full trip to the origin on every request, potentially impacting performance and increasing load on the origin server. FORCE_CACHE_ALL Cache all content, ignoring any "private", "no-store" or "no-cache" directives in Cache-Control response headers. Warning: this may result in Cloud CDN caching private, per-user (user identifiable) content. CACHE_ALL_STATIC Automatically cache static content, including common image formats, media (video and audio), and web assets (JavaScript and CSS). Requests and responses that are marked as uncacheable, as well as dynamic content (including HTML), will not be cached. If no value is provided for cdnPolicy.cacheMode, it defaults to CACHE_ALL_STATIC.
        #     Check the CacheMode enum for the list of possible values.
        # @!attribute [rw] client_ttl
        #   @return [::Integer]
        #     Specifies a separate client (e.g. browser client) maximum TTL. This is used to clamp the max-age (or Expires) value sent to the client. With FORCE_CACHE_ALL, the lesser of client_ttl and default_ttl is used for the response max-age directive, along with a "public" directive. For cacheable content in CACHE_ALL_STATIC mode, client_ttl clamps the max-age from the origin (if specified), or else sets the response max-age directive to the lesser of the client_ttl and default_ttl, and also ensures a "public" cache-control directive is present. If a client TTL is not specified, a default value (1 hour) will be used. The maximum allowed value is 31,622,400s (1 year).
        # @!attribute [rw] default_ttl
        #   @return [::Integer]
        #     Specifies the default TTL for cached content served by this origin for responses that do not have an existing valid TTL (max-age or s-maxage). Setting a TTL of "0" means "always revalidate". The value of defaultTTL cannot be set to a value greater than that of maxTTL, but can be equal. When the cacheMode is set to FORCE_CACHE_ALL, the defaultTTL will overwrite the TTL set in all responses. The maximum allowed value is 31,622,400s (1 year), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
        # @!attribute [rw] max_ttl
        #   @return [::Integer]
        #     Specifies the maximum allowed TTL for cached content served by this origin. Cache directives that attempt to set a max-age or s-maxage higher than this, or an Expires header more than maxTTL seconds in the future will be capped at the value of maxTTL, as if it were the value of an s-maxage Cache-Control directive. Headers sent to the client will not be modified. Setting a TTL of "0" means "always revalidate". The maximum allowed value is 31,622,400s (1 year), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
        # @!attribute [rw] negative_caching
        #   @return [::Boolean]
        #     Negative caching allows per-status code TTLs to be set, in order to apply fine-grained caching for common errors or redirects. This can reduce the load on your origin and improve end-user experience by reducing response latency. When the cache mode is set to CACHE_ALL_STATIC or USE_ORIGIN_HEADERS, negative caching applies to responses with the specified response code that lack any Cache-Control, Expires, or Pragma: no-cache directives. When the cache mode is set to FORCE_CACHE_ALL, negative caching applies to all responses with the specified response code, and override any caching headers. By default, Cloud CDN will apply the following default TTLs to these status codes: HTTP 300 (Multiple Choice), 301, 308 (Permanent Redirects): 10m HTTP 404 (Not Found), 410 (Gone), 451 (Unavailable For Legal Reasons): 120s HTTP 405 (Method Not Found), 501 (Not Implemented): 60s. These defaults can be overridden in negative_caching_policy.
        # @!attribute [rw] negative_caching_policy
        #   @return [::Array<::Google::Cloud::Compute::V1::BackendBucketCdnPolicyNegativeCachingPolicy>]
        #     Sets a cache TTL for the specified HTTP status code. negative_caching must be enabled to configure negative_caching_policy. Omitting the policy and leaving negative_caching enabled will use Cloud CDN's default cache TTLs. Note that when specifying an explicit negative_caching_policy, you should take care to specify a cache TTL for all response codes that you wish to cache. Cloud CDN will not apply any default negative caching when a policy exists.
        # @!attribute [rw] request_coalescing
        #   @return [::Boolean]
        #     If true then Cloud CDN will combine multiple concurrent cache fill requests into a small number of requests to the origin.
        # @!attribute [rw] serve_while_stale
        #   @return [::Integer]
        #     Serve existing content from the cache (if available) when revalidating content with the origin, or when an error is encountered when refreshing the cache. This setting defines the default "max-stale" duration for any cached responses that do not specify a max-stale directive. Stale responses that exceed the TTL configured here will not be served. The default limit (max-stale) is 86400s (1 day), which will allow stale content to be served up to this limit beyond the max-age (or s-maxage) of a cached response. The maximum allowed value is 604800 (1 week). Set this to zero (0) to disable serve-while-stale.
        # @!attribute [rw] signed_url_cache_max_age_sec
        #   @return [::Integer]
        #     Maximum number of seconds the response to a signed URL request will be considered fresh. After this time period, the response will be revalidated before being served. Defaults to 1hr (3600s). When serving responses to signed URL requests, Cloud CDN will internally behave as though all responses from this backend had a "Cache-Control: public, max-age=[TTL]" header, regardless of any existing Cache-Control header. The actual headers served in responses will not be altered.
        # @!attribute [rw] signed_url_key_names
        #   @return [::Array<::String>]
        #     [Output Only] Names of the keys for signing request URLs.
        class BackendBucketCdnPolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Specifies the cache setting for all responses from this backend. The possible values are: USE_ORIGIN_HEADERS Requires the origin to set valid caching headers to cache content. Responses without these headers will not be cached at Google's edge, and will require a full trip to the origin on every request, potentially impacting performance and increasing load on the origin server. FORCE_CACHE_ALL Cache all content, ignoring any "private", "no-store" or "no-cache" directives in Cache-Control response headers. Warning: this may result in Cloud CDN caching private, per-user (user identifiable) content. CACHE_ALL_STATIC Automatically cache static content, including common image formats, media (video and audio), and web assets (JavaScript and CSS). Requests and responses that are marked as uncacheable, as well as dynamic content (including HTML), will not be cached. If no value is provided for cdnPolicy.cacheMode, it defaults to CACHE_ALL_STATIC.
          module CacheMode
            # A value indicating that the enum field is not set.
            UNDEFINED_CACHE_MODE = 0

            # Automatically cache static content, including common image formats, media (video and audio), and web assets (JavaScript and CSS). Requests and responses that are marked as uncacheable, as well as dynamic content (including HTML), will not be cached.
            CACHE_ALL_STATIC = 355_027_945

            # Cache all content, ignoring any "private", "no-store" or "no-cache" directives in Cache-Control response headers. Warning: this may result in Cloud CDN caching private, per-user (user identifiable) content.
            FORCE_CACHE_ALL = 486_026_928

            INVALID_CACHE_MODE = 381_295_560

            # Requires the origin to set valid caching headers to cache content. Responses without these headers will not be cached at Google's edge, and will require a full trip to the origin on every request, potentially impacting performance and increasing load on the origin server.
            USE_ORIGIN_HEADERS = 55_380_261
          end
        end

        # Bypass the cache when the specified request headers are present, e.g. Pragma or Authorization headers. Values are case insensitive. The presence of such a header overrides the cache_mode setting.
        # @!attribute [rw] header_name
        #   @return [::String]
        #     The header field name to match on when bypassing cache. Values are case-insensitive.
        class BackendBucketCdnPolicyBypassCacheOnRequestHeader
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message containing what to include in the cache key for a request for Cloud CDN.
        # @!attribute [rw] include_http_headers
        #   @return [::Array<::String>]
        #     Allows HTTP request headers (by name) to be used in the cache key.
        # @!attribute [rw] query_string_whitelist
        #   @return [::Array<::String>]
        #     Names of query string parameters to include in cache keys. Default parameters are always included. '&' and '=' will be percent encoded and not treated as delimiters.
        class BackendBucketCdnPolicyCacheKeyPolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Specify CDN TTLs for response error codes.
        # @!attribute [rw] code
        #   @return [::Integer]
        #     The HTTP status code to define a TTL against. Only HTTP status codes 300, 301, 302, 307, 308, 404, 405, 410, 421, 451 and 501 are can be specified as values, and you cannot specify a status code more than once.
        # @!attribute [rw] ttl
        #   @return [::Integer]
        #     The TTL (in seconds) for which to cache responses with the corresponding status code. The maximum allowed value is 1800s (30 minutes), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
        class BackendBucketCdnPolicyNegativeCachingPolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Contains a list of BackendBucket resources.
        # @!attribute [rw] id
        #   @return [::String]
        #     [Output Only] Unique identifier for the resource; defined by the server.
        # @!attribute [rw] items
        #   @return [::Array<::Google::Cloud::Compute::V1::BackendBucket>]
        #     A list of BackendBucket resources.
        # @!attribute [rw] kind
        #   @return [::String]
        #     Type of resource.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
        # @!attribute [rw] self_link
        #   @return [::String]
        #     [Output Only] Server-defined URL for this resource.
        # @!attribute [rw] warning
        #   @return [::Google::Cloud::Compute::V1::Warning]
        #     [Output Only] Informational warning message.
        class BackendBucketList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Additional Backend Bucket parameters.
        # @!attribute [rw] resource_manager_tags
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Tag keys/values directly bound to this resource. Tag keys and values have the same definition as resource manager tags. The field is allowed for INSERT only. The keys/values to set on the resource should be specified in either ID { : } or Namespaced format { : }. For example the following are valid inputs: * \\{"tagKeys/333" : "tagValues/444", "tagKeys/123" : "tagValues/456"} * \\{"123/environment" : "production", "345/abc" : "xyz"} Note: * Invalid combinations of ID & namespaced format is not supported. For instance: \\{"123/environment" : "tagValues/444"} is invalid.
        class BackendBucketParams
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class ResourceManagerTagsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # @!attribute [rw] reference
        #   @return [::String]
        #     [Output Only] Server-defined URL for UrlMaps referencing that BackendBucket.
        class BackendBucketUsedBy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Custom Metrics are used for CUSTOM_METRICS balancing_mode.
        # @!attribute [rw] dry_run
        #   @return [::Boolean]
        #     If true, the metric data is collected and reported to Cloud Monitoring, but is not used for load balancing.
        # @!attribute [rw] max_utilization
        #   @return [::Float]
        #     Optional parameter to define a target utilization for the Custom Metrics balancing mode. The valid range is [0.0, 1.0].
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of a custom utilization signal. The name must be 1-64 characters long and match the regular expression [a-z]([-_.a-z0-9]*[a-z0-9])? which means that the first character must be a lowercase letter, and all following characters must be a dash, period, underscore, lowercase letter, or digit, except the last character, which cannot be a dash, period, or underscore. For usage guidelines, see Custom Metrics balancing mode. This field can only be used for a global or regional backend service with the loadBalancingScheme set to EXTERNAL_MANAGED, INTERNAL_MANAGED INTERNAL_SELF_MANAGED.
        class BackendCustomMetric
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a Backend Service resource. A backend service defines how Google Cloud load balancers distribute traffic. The backend service configuration contains a set of values, such as the protocol used to connect to backends, various distribution and session settings, health checks, and timeouts. These settings provide fine-grained control over how your load balancer behaves. Most of the settings have default values that allow for easy configuration if you need to get started quickly. Backend services in Google Compute Engine can be either regionally or globally scoped. * [Global](https://cloud.google.com/compute/docs/reference/rest/v1/backendServices) * [Regional](https://cloud.google.com/compute/docs/reference/rest/v1/regionBackendServices) For more information, see Backend Services.
        # @!attribute [rw] affinity_cookie_ttl_sec
        #   @return [::Integer]
        #     Lifetime of cookies in seconds. This setting is applicable to Application Load Balancers and Traffic Director and requires GENERATED_COOKIE or HTTP_COOKIE session affinity. If set to 0, the cookie is non-persistent and lasts only until the end of the browser session (or equivalent). The maximum allowed value is two weeks (1,209,600). Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        # @!attribute [rw] backends
        #   @return [::Array<::Google::Cloud::Compute::V1::Backend>]
        #     The list of backends that serve this BackendService.
        # @!attribute [rw] cdn_policy
        #   @return [::Google::Cloud::Compute::V1::BackendServiceCdnPolicy]
        #     Cloud CDN configuration for this BackendService. Only available for specified load balancer types.
        # @!attribute [rw] circuit_breakers
        #   @return [::Google::Cloud::Compute::V1::CircuitBreakers]
        # @!attribute [rw] compression_mode
        #   @return [::String]
        #     Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
        #     Check the CompressionMode enum for the list of possible values.
        # @!attribute [rw] connection_draining
        #   @return [::Google::Cloud::Compute::V1::ConnectionDraining]
        #     connectionDraining cannot be specified with haPolicy.
        # @!attribute [rw] connection_tracking_policy
        #   @return [::Google::Cloud::Compute::V1::BackendServiceConnectionTrackingPolicy]
        #     Connection Tracking configuration for this BackendService. Connection tracking policy settings are only available for external passthrough Network Load Balancers and internal passthrough Network Load Balancers. connectionTrackingPolicy cannot be specified with haPolicy.
        # @!attribute [rw] consistent_hash
        #   @return [::Google::Cloud::Compute::V1::ConsistentHashLoadBalancerSettings]
        #     Consistent Hash-based load balancing can be used to provide soft session affinity based on HTTP headers, cookies or other properties. This load balancing policy is applicable only for HTTP connections. The affinity to a particular destination host will be lost when one or more hosts are added/removed from the destination service. This field specifies parameters that control consistent hashing. This field is only applicable when localityLbPolicy is set to MAGLEV or RING_HASH. This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, HTTP2 or H2C, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
        # @!attribute [rw] creation_timestamp
        #   @return [::String]
        #     [Output Only] Creation timestamp in RFC3339 text format.
        # @!attribute [rw] custom_metrics
        #   @return [::Array<::Google::Cloud::Compute::V1::BackendServiceCustomMetric>]
        #     List of custom metrics that are used for the WEIGHTED_ROUND_ROBIN locality_lb_policy.
        # @!attribute [rw] custom_request_headers
        #   @return [::Array<::String>]
        #     Headers that the load balancer adds to proxied requests. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
        # @!attribute [rw] custom_response_headers
        #   @return [::Array<::String>]
        #     Headers that the load balancer adds to proxied responses. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
        # @!attribute [rw] description
        #   @return [::String]
        #     An optional description of this resource. Provide this property when you create the resource.
        # @!attribute [rw] edge_security_policy
        #   @return [::String]
        #     [Output Only] The resource URL for the edge security policy associated with this backend service.
        # @!attribute [rw] enable_c_d_n
        #   @return [::Boolean]
        #     If true, enables Cloud CDN for the backend service of a global external Application Load Balancer.
        # @!attribute [rw] external_managed_migration_state
        #   @return [::String]
        #     Specifies the canary migration state. Possible values are PREPARE, TEST_BY_PERCENTAGE, and TEST_ALL_TRAFFIC. To begin the migration from EXTERNAL to EXTERNAL_MANAGED, the state must be changed to PREPARE. The state must be changed to TEST_ALL_TRAFFIC before the loadBalancingScheme can be changed to EXTERNAL_MANAGED. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate traffic by percentage using externalManagedMigrationTestingPercentage. Rolling back a migration requires the states to be set in reverse order. So changing the scheme from EXTERNAL_MANAGED to EXTERNAL requires the state to be set to TEST_ALL_TRAFFIC at the same time. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate some traffic back to EXTERNAL or PREPARE can be used to migrate all traffic back to EXTERNAL.
        #     Check the ExternalManagedMigrationState enum for the list of possible values.
        # @!attribute [rw] external_managed_migration_testing_percentage
        #   @return [::Float]
        #     Determines the fraction of requests that should be processed by the Global external Application Load Balancer. The value of this field must be in the range [0, 100]. Session affinity options will slightly affect this routing behavior, for more details, see: Session Affinity. This value can only be set if the loadBalancingScheme in the BackendService is set to EXTERNAL (when using the classic Application Load Balancer) and the migration state is TEST_BY_PERCENTAGE.
        # @!attribute [rw] failover_policy
        #   @return [::Google::Cloud::Compute::V1::BackendServiceFailoverPolicy]
        #     Requires at least one backend instance group to be defined as a backup (failover) backend. For load balancers that have configurable failover: [Internal passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/internal/failover-overview) and [external passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview). failoverPolicy cannot be specified with haPolicy.
        # @!attribute [rw] fingerprint
        #   @return [::String]
        #     Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a BackendService. An up-to-date fingerprint must be provided in order to update the BackendService, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a BackendService.
        # @!attribute [rw] ha_policy
        #   @return [::Google::Cloud::Compute::V1::BackendServiceHAPolicy]
        #     Configures self-managed High Availability (HA) for External and Internal Protocol Forwarding. The backends of this regional backend service must only specify zonal network endpoint groups (NEGs) of type GCE_VM_IP. When haPolicy is set for an Internal Passthrough Network Load Balancer, the regional backend service must set the network field. All zonal NEGs must belong to the same network. However, individual NEGs can belong to different subnetworks of that network. When haPolicy is specified, the set of attached network endpoints across all backends comprise an High Availability domain from which one endpoint is selected as the active endpoint (the leader) that receives all traffic. haPolicy can be added only at backend service creation time. Once set up, it cannot be deleted. Note that haPolicy is not for load balancing, and therefore cannot be specified with sessionAffinity, connectionTrackingPolicy, and failoverPolicy. haPolicy requires customers to be responsible for tracking backend endpoint health and electing a leader among the healthy endpoints. Therefore, haPolicy cannot be specified with healthChecks. haPolicy can only be specified for External Passthrough Network Load Balancers and Internal Passthrough Network Load Balancers.
        # @!attribute [rw] health_checks
        #   @return [::Array<::String>]
        #     The list of URLs to the healthChecks, httpHealthChecks (legacy), or httpsHealthChecks (legacy) resource for health checking this backend service. Not all backend services support legacy health checks. See Load balancer guide. Currently, at most one health check can be specified for each backend service. Backend services with instance group or zonal NEG backends must have a health check unless haPolicy is specified. Backend services with internet or serverless NEG backends must not have a health check. healthChecks[] cannot be specified with haPolicy.
        # @!attribute [rw] iap
        #   @return [::Google::Cloud::Compute::V1::BackendServiceIAP]
        #     The configurations for Identity-Aware Proxy on this resource. Not available for internal passthrough Network Load Balancers and external passthrough Network Load Balancers.
        # @!attribute [rw] id
        #   @return [::Integer]
        #     [Output Only] The unique identifier for the resource. This identifier is defined by the server.
        # @!attribute [rw] ip_address_selection_policy
        #   @return [::String]
        #     Specifies a preference for traffic sent from the proxy to the backend (or from the client to the backend for proxyless gRPC). The possible values are: - IPV4_ONLY: Only send IPv4 traffic to the backends of the backend service (Instance Group, Managed Instance Group, Network Endpoint Group), regardless of traffic from the client to the proxy. Only IPv4 health checks are used to check the health of the backends. This is the default setting. - PREFER_IPV6: Prioritize the connection to the endpoint's IPv6 address over its IPv4 address (provided there is a healthy IPv6 address). - IPV6_ONLY: Only send IPv6 traffic to the backends of the backend service (Instance Group, Managed Instance Group, Network Endpoint Group), regardless of traffic from the client to the proxy. Only IPv6 health checks are used to check the health of the backends. This field is applicable to either: - Advanced global external Application Load Balancer (load balancing scheme EXTERNAL_MANAGED), - Regional external Application Load Balancer, - Internal proxy Network Load Balancer (load balancing scheme INTERNAL_MANAGED), - Regional internal Application Load Balancer (load balancing scheme INTERNAL_MANAGED), - Traffic Director with Envoy proxies and proxyless gRPC (load balancing scheme INTERNAL_SELF_MANAGED).
        #     Check the IpAddressSelectionPolicy enum for the list of possible values.
        # @!attribute [rw] kind
        #   @return [::String]
        #     [Output Only] Type of resource. Always compute#backendService for backend services.
        # @!attribute [rw] load_balancing_scheme
        #   @return [::String]
        #     Specifies the load balancer type. A backend service created for one type of load balancer cannot be used with another. For more information, refer to Choosing a load balancer.
        #     Check the LoadBalancingScheme enum for the list of possible values.
        # @!attribute [rw] locality_lb_policies
        #   @return [::Array<::Google::Cloud::Compute::V1::BackendServiceLocalityLoadBalancingPolicyConfig>]
        #     A list of locality load-balancing policies to be used in order of preference. When you use localityLbPolicies, you must set at least one value for either the localityLbPolicies[].policy or the localityLbPolicies[].customPolicy field. localityLbPolicies overrides any value set in the localityLbPolicy field. For an example of how to use this field, see Define a list of preferred policies. Caution: This field and its children are intended for use in a service mesh that includes gRPC clients only. Envoy proxies can't use backend services that have this configuration.
        # @!attribute [rw] locality_lb_policy
        #   @return [::String]
        #     The load balancing algorithm used within the scope of the locality. The possible values are: - ROUND_ROBIN: This is a simple policy in which each healthy backend is selected in round robin order. This is the default. - LEAST_REQUEST: An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests. - RING_HASH: The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests. - RANDOM: The load balancer selects a random healthy host. - ORIGINAL_DESTINATION: Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer. - MAGLEV: used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see Maglev: A Fast and Reliable Software Network Load Balancer. - WEIGHTED_ROUND_ROBIN: Per-endpoint Weighted Round Robin Load Balancing using weights computed from Backend reported Custom Metrics. If set, the Backend Service responses are expected to contain non-standard HTTP response header field Endpoint-Load-Metrics. The reported metrics to use for computing the weights are specified via the customMetrics field. This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, HTTP2 or H2C, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED, INTERNAL_MANAGED, or EXTERNAL_MANAGED. If sessionAffinity is not configured—that is, if session affinity remains at the default value of NONE—then the default value for localityLbPolicy is ROUND_ROBIN. If session affinity is set to a value other than NONE, then the default value for localityLbPolicy is MAGLEV. Only ROUND_ROBIN and RING_HASH are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. localityLbPolicy cannot be specified with haPolicy.
        #     Check the LocalityLbPolicy enum for the list of possible values.
        # @!attribute [rw] log_config
        #   @return [::Google::Cloud::Compute::V1::BackendServiceLogConfig]
        #     This field denotes the logging options for the load balancer traffic served by this backend service. If logging is enabled, logs will be exported to Stackdriver.
        # @!attribute [rw] max_stream_duration
        #   @return [::Google::Cloud::Compute::V1::Duration]
        #     Specifies the default maximum duration (timeout) for streams to this service. Duration is computed from the beginning of the stream until the response has been completely processed, including all retries. A stream that does not complete in this duration is closed. If not specified, there will be no timeout limit, i.e. the maximum duration is infinite. This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service. This field is only allowed when the loadBalancingScheme of the backend service is INTERNAL_SELF_MANAGED.
        # @!attribute [rw] metadatas
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Deployment metadata associated with the resource to be set by a GKE hub controller and read by the backend RCTH
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        # @!attribute [rw] network
        #   @return [::String]
        #     The URL of the network to which this backend service belongs. This field must be set for Internal Passthrough Network Load Balancers when the haPolicy is enabled, and for External Passthrough Network Load Balancers when the haPolicy fastIpMove is enabled. This field can only be specified when the load balancing scheme is set to INTERNAL, or when the load balancing scheme is set to EXTERNAL and haPolicy fastIpMove is enabled.
        # @!attribute [rw] outlier_detection
        #   @return [::Google::Cloud::Compute::V1::OutlierDetection]
        #     Settings controlling the ejection of unhealthy backend endpoints from the load balancing pool of each individual proxy instance that processes the traffic for the given backend service. If not set, this feature is considered disabled. Results of the outlier detection algorithm (ejection of endpoints from the load balancing pool and returning them back to the pool) are executed independently by each proxy instance of the load balancer. In most cases, more than one proxy instance handles the traffic received by a backend service. Thus, it is possible that an unhealthy endpoint is detected and ejected by only some of the proxies, and while this happens, other proxies may continue to send requests to the same unhealthy endpoint until they detect and eject the unhealthy endpoint. Applicable backend endpoints can be: - VM instances in an Instance Group - Endpoints in a Zonal NEG (GCE_VM_IP, GCE_VM_IP_PORT) - Endpoints in a Hybrid Connectivity NEG (NON_GCP_PRIVATE_IP_PORT) - Serverless NEGs, that resolve to Cloud Run, App Engine, or Cloud Functions Services - Private Service Connect NEGs, that resolve to Google-managed regional API endpoints or managed services published using Private Service Connect Applicable backend service types can be: - A global backend service with the loadBalancingScheme set to INTERNAL_SELF_MANAGED or EXTERNAL_MANAGED. - A regional backend service with the serviceProtocol set to HTTP, HTTPS, HTTP2 or H2C, and loadBalancingScheme set to INTERNAL_MANAGED or EXTERNAL_MANAGED. Not supported for Serverless NEGs. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        # @!attribute [rw] params
        #   @return [::Google::Cloud::Compute::V1::BackendServiceParams]
        #     Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
        # @!attribute [rw] port
        #   @return [::Integer]
        #     Deprecated in favor of portName. The TCP port to connect on the backend. The default value is 80. For internal passthrough Network Load Balancers and external passthrough Network Load Balancers, omit port.
        # @!attribute [rw] port_name
        #   @return [::String]
        #     A named port on a backend instance group representing the port for communication to the backend VMs in that group. The named port must be [defined on each backend instance group](https://cloud.google.com/load-balancing/docs/backend-service#named_ports). This parameter has no meaning if the backends are NEGs. For internal passthrough Network Load Balancers and external passthrough Network Load Balancers, omit port_name.
        # @!attribute [rw] protocol
        #   @return [::String]
        #     The protocol this BackendService uses to communicate with backends. Possible values are HTTP, HTTPS, HTTP2, H2C, TCP, SSL, UDP or GRPC. depending on the chosen load balancer or Traffic Director configuration. Refer to the documentation for the load balancers or for Traffic Director for more information. Must be set to GRPC when the backend service is referenced by a URL map that is bound to target gRPC proxy.
        #     Check the Protocol enum for the list of possible values.
        # @!attribute [rw] region
        #   @return [::String]
        #     [Output Only] URL of the region where the regional backend service resides. This field is not applicable to global backend services. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
        # @!attribute [rw] security_policy
        #   @return [::String]
        #     [Output Only] The resource URL for the security policy associated with this backend service.
        # @!attribute [rw] security_settings
        #   @return [::Google::Cloud::Compute::V1::SecuritySettings]
        #     This field specifies the security settings that apply to this backend service. This field is applicable to a global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
        # @!attribute [rw] self_link
        #   @return [::String]
        #     [Output Only] Server-defined URL for the resource.
        # @!attribute [rw] service_bindings
        #   @return [::Array<::String>]
        #     URLs of networkservices.ServiceBinding resources. Can only be set if load balancing scheme is INTERNAL_SELF_MANAGED. If set, lists of backends and health checks must be both empty.
        # @!attribute [rw] service_lb_policy
        #   @return [::String]
        #     URL to networkservices.ServiceLbPolicy resource. Can only be set if load balancing scheme is EXTERNAL_MANAGED, INTERNAL_MANAGED or INTERNAL_SELF_MANAGED and the scope is global.
        # @!attribute [rw] session_affinity
        #   @return [::String]
        #     Type of session affinity to use. The default is NONE. Only NONE and HEADER_FIELD are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. For more details, see: [Session Affinity](https://cloud.google.com/load-balancing/docs/backend-service#session_affinity). sessionAffinity cannot be specified with haPolicy.
        #     Check the SessionAffinity enum for the list of possible values.
        # @!attribute [rw] strong_session_affinity_cookie
        #   @return [::Google::Cloud::Compute::V1::BackendServiceHttpCookie]
        #     Describes the HTTP cookie used for stateful session affinity. This field is applicable and required if the sessionAffinity is set to STRONG_COOKIE_AFFINITY.
        # @!attribute [rw] subsetting
        #   @return [::Google::Cloud::Compute::V1::Subsetting]
        #     subsetting cannot be specified with haPolicy.
        # @!attribute [rw] timeout_sec
        #   @return [::Integer]
        #     The backend service timeout has a different meaning depending on the type of load balancer. For more information see, Backend service settings. The default is 30 seconds. The full range of timeout values allowed goes from 1 through 2,147,483,647 seconds. This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. Instead, use maxStreamDuration.
        # @!attribute [rw] tls_settings
        #   @return [::Google::Cloud::Compute::V1::BackendServiceTlsSettings]
        #     Configuration for Backend Authenticated TLS and mTLS. May only be specified when the backend protocol is SSL, HTTPS or HTTP2.
        # @!attribute [rw] used_by
        #   @return [::Array<::Google::Cloud::Compute::V1::BackendServiceUsedBy>]
        #     [Output Only] List of resources referencing given backend service.
        class BackendService
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class MetadatasEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
          module CompressionMode
            # A value indicating that the enum field is not set.
            UNDEFINED_COMPRESSION_MODE = 0

            # Automatically uses the best compression based on the Accept-Encoding header sent by the client.
            AUTOMATIC = 165_298_699

            # Disables compression. Existing compressed responses cached by Cloud CDN will not be served to clients.
            DISABLED = 516_696_700
          end

          # Specifies the canary migration state. Possible values are PREPARE, TEST_BY_PERCENTAGE, and TEST_ALL_TRAFFIC. To begin the migration from EXTERNAL to EXTERNAL_MANAGED, the state must be changed to PREPARE. The state must be changed to TEST_ALL_TRAFFIC before the loadBalancingScheme can be changed to EXTERNAL_MANAGED. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate traffic by percentage using externalManagedMigrationTestingPercentage. Rolling back a migration requires the states to be set in reverse order. So changing the scheme from EXTERNAL_MANAGED to EXTERNAL requires the state to be set to TEST_ALL_TRAFFIC at the same time. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate some traffic back to EXTERNAL or PREPARE can be used to migrate all traffic back to EXTERNAL.
          module ExternalManagedMigrationState
            # A value indicating that the enum field is not set.
            UNDEFINED_EXTERNAL_MANAGED_MIGRATION_STATE = 0

            PREPARE = 399_612_135

            TEST_ALL_TRAFFIC = 79_728_882

            TEST_BY_PERCENTAGE = 513_738_389
          end

          # Specifies a preference for traffic sent from the proxy to the backend (or from the client to the backend for proxyless gRPC). The possible values are: - IPV4_ONLY: Only send IPv4 traffic to the backends of the backend service (Instance Group, Managed Instance Group, Network Endpoint Group), regardless of traffic from the client to the proxy. Only IPv4 health checks are used to check the health of the backends. This is the default setting. - PREFER_IPV6: Prioritize the connection to the endpoint's IPv6 address over its IPv4 address (provided there is a healthy IPv6 address). - IPV6_ONLY: Only send IPv6 traffic to the backends of the backend service (Instance Group, Managed Instance Group, Network Endpoint Group), regardless of traffic from the client to the proxy. Only IPv6 health checks are used to check the health of the backends. This field is applicable to either: - Advanced global external Application Load Balancer (load balancing scheme EXTERNAL_MANAGED), - Regional external Application Load Balancer, - Internal proxy Network Load Balancer (load balancing scheme INTERNAL_MANAGED), - Regional internal Application Load Balancer (load balancing scheme INTERNAL_MANAGED), - Traffic Director with Envoy proxies and proxyless gRPC (load balancing scheme INTERNAL_SELF_MANAGED).
          module IpAddressSelectionPolicy
            # A value indicating that the enum field is not set.
            UNDEFINED_IP_ADDRESS_SELECTION_POLICY = 0

            # Only send IPv4 traffic to the backends of the Backend Service (Instance Group, Managed Instance Group, Network Endpoint Group) regardless of traffic from the client to the proxy. Only IPv4 health-checks are used to check the health of the backends. This is the default setting.
            IPV4_ONLY = 22_373_798

            # Only send IPv6 traffic to the backends of the Backend Service (Instance Group, Managed Instance Group, Network Endpoint Group) regardless of traffic from the client to the proxy. Only IPv6 health-checks are used to check the health of the backends.
            IPV6_ONLY = 79_632_100

            # Unspecified IP address selection policy.
            IP_ADDRESS_SELECTION_POLICY_UNSPECIFIED = 36_210_144

            # Prioritize the connection to the endpoints IPv6 address over its IPv4 address (provided there is a healthy IPv6 address).
            PREFER_IPV6 = 408_601_302
          end

          # Specifies the load balancer type. A backend service created for one type of load balancer cannot be used with another. For more information, refer to Choosing a load balancer.
          module LoadBalancingScheme
            # A value indicating that the enum field is not set.
            UNDEFINED_LOAD_BALANCING_SCHEME = 0

            # Signifies that this will be used for classic Application Load Balancers, global external proxy Network Load Balancers, or external passthrough Network Load Balancers.
            EXTERNAL = 35_607_499

            # Signifies that this will be used for global external Application Load Balancers, regional external Application Load Balancers, or regional external proxy Network Load Balancers.
            EXTERNAL_MANAGED = 512_006_923

            # Signifies that this will be used for internal passthrough Network Load Balancers.
            INTERNAL = 279_295_677

            # Signifies that this will be used for internal Application Load Balancers.
            INTERNAL_MANAGED = 37_350_397

            # Signifies that this will be used by Traffic Director.
            INTERNAL_SELF_MANAGED = 236_211_150

            INVALID_LOAD_BALANCING_SCHEME = 275_352_060
          end

          # The load balancing algorithm used within the scope of the locality. The possible values are: - ROUND_ROBIN: This is a simple policy in which each healthy backend is selected in round robin order. This is the default. - LEAST_REQUEST: An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests. - RING_HASH: The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests. - RANDOM: The load balancer selects a random healthy host. - ORIGINAL_DESTINATION: Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer. - MAGLEV: used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see Maglev: A Fast and Reliable Software Network Load Balancer. - WEIGHTED_ROUND_ROBIN: Per-endpoint Weighted Round Robin Load Balancing using weights computed from Backend reported Custom Metrics. If set, the Backend Service responses are expected to contain non-standard HTTP response header field Endpoint-Load-Metrics. The reported metrics to use for computing the weights are specified via the customMetrics field. This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, HTTP2 or H2C, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED, INTERNAL_MANAGED, or EXTERNAL_MANAGED. If sessionAffinity is not configured—that is, if session affinity remains at the default value of NONE—then the default value for localityLbPolicy is ROUND_ROBIN. If session affinity is set to a value other than NONE, then the default value for localityLbPolicy is MAGLEV. Only ROUND_ROBIN and RING_HASH are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. localityLbPolicy cannot be specified with haPolicy.
          module LocalityLbPolicy
            # A value indicating that the enum field is not set.
            UNDEFINED_LOCALITY_LB_POLICY = 0

            INVALID_LB_POLICY = 323_318_707

            # An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests.
            LEAST_REQUEST = 46_604_921

            # This algorithm implements consistent hashing to backends. Maglev can be used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see Maglev: A Fast and Reliable Software Network Load Balancer.
            MAGLEV = 119_180_266

            # Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer.
            ORIGINAL_DESTINATION = 166_297_216

            # The load balancer selects a random healthy host.
            RANDOM = 262_527_171

            # The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests.
            RING_HASH = 432_795_069

            # This is a simple policy in which each healthy backend is selected in round robin order. This is the default.
            ROUND_ROBIN = 153_895_801

            # Per-instance weighted Load Balancing via health check reported weights. In internal passthrough network load balancing, it is weighted rendezvous hashing. This option is only supported in internal passthrough network load balancing.
            WEIGHTED_GCP_RENDEZVOUS = 82_501_640

            # Per-instance weighted Load Balancing via health check reported weights. If set, the Backend Service must configure a non legacy HTTP-based Health Check, and health check replies are expected to contain non-standard HTTP response header field X-Load-Balancing-Endpoint-Weight to specify the per-instance weights. If set, Load Balancing is weighted based on the per-instance weights reported in the last processed health check replies, as long as every instance either reported a valid weight or had UNAVAILABLE_WEIGHT. Otherwise, Load Balancing remains equal-weight. This option is only supported in Network Load Balancing.
            WEIGHTED_MAGLEV = 254_930_962

            # Per-endpoint weighted round-robin Load Balancing using weights computed from Backend reported Custom Metrics. If set, the Backend Service responses are expected to contain non-standard HTTP response header field Endpoint-Load-Metrics. The reported metrics to use for computing the weights are specified via the customMetrics fields.
            WEIGHTED_ROUND_ROBIN = 5_584_977
          end

          # The protocol this BackendService uses to communicate with backends. Possible values are HTTP, HTTPS, HTTP2, H2C, TCP, SSL, UDP or GRPC. depending on the chosen load balancer or Traffic Director configuration. Refer to the documentation for the load balancers or for Traffic Director for more information. Must be set to GRPC when the backend service is referenced by a URL map that is bound to target gRPC proxy.
          module Protocol
            # A value indicating that the enum field is not set.
            UNDEFINED_PROTOCOL = 0

            # gRPC (available for Traffic Director).
            GRPC = 2_196_510

            # HTTP2 over cleartext
            H2C = 70_809

            HTTP = 2_228_360

            # HTTP/2 with SSL.
            HTTP2 = 69_079_210

            HTTPS = 69_079_243

            # TCP proxying with SSL.
            SSL = 82_412

            # TCP proxying or TCP pass-through.
            TCP = 82_881

            # UDP.
            UDP = 83_873

            # If a Backend Service has UNSPECIFIED as its protocol, it can be used with any L3/L4 Forwarding Rules.
            UNSPECIFIED = 526_786_327
          end

          # Type of session affinity to use. The default is NONE. Only NONE and HEADER_FIELD are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. For more details, see: [Session Affinity](https://cloud.google.com/load-balancing/docs/backend-service#session_affinity). sessionAffinity cannot be specified with haPolicy.
          module SessionAffinity
            # A value indicating that the enum field is not set.
            UNDEFINED_SESSION_AFFINITY = 0

            # 2-tuple hash on packet's source and destination IP addresses. Connections from the same source IP address to the same destination IP address will be served by the same backend VM while that VM remains healthy.
            CLIENT_IP = 345_665_051

            # 1-tuple hash only on packet's source IP address. Connections from the same source IP address will be served by the same backend VM while that VM remains healthy. This option can only be used for Internal TCP/UDP Load Balancing.
            CLIENT_IP_NO_DESTINATION = 106_122_516

            # 5-tuple hash on packet's source and destination IP addresses, IP protocol, and source and destination ports. Connections for the same IP protocol from the same source IP address and port to the same destination IP address and port will be served by the same backend VM while that VM remains healthy. This option cannot be used for HTTP(S) load balancing.
            CLIENT_IP_PORT_PROTO = 221_722_926

            # 3-tuple hash on packet's source and destination IP addresses, and IP protocol. Connections for the same IP protocol from the same source IP address to the same destination IP address will be served by the same backend VM while that VM remains healthy. This option cannot be used for HTTP(S) load balancing.
            CLIENT_IP_PROTO = 25_322_148

            # Hash based on a cookie generated by the L7 loadbalancer. Only valid for HTTP(S) load balancing.
            GENERATED_COOKIE = 370_321_204

            # The hash is based on a user specified header field.
            HEADER_FIELD = 200_737_960

            # The hash is based on a user provided cookie.
            HTTP_COOKIE = 494_981_627

            # No session affinity. Connections from the same client IP may go to any instance in the pool.
            NONE = 2_402_104

            # Strong cookie-based affinity. Connections bearing the same cookie will be served by the same backend VM while that VM remains healthy, as long as the cookie has not expired.
            STRONG_COOKIE_AFFINITY = 438_628_091
          end
        end

        # Contains a list of BackendServicesScopedList.
        # @!attribute [rw] id
        #   @return [::String]
        #     [Output Only] Unique identifier for the resource; defined by the server.
        # @!attribute [rw] items
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Compute::V1::BackendServicesScopedList}]
        #     A list of BackendServicesScopedList resources.
        # @!attribute [rw] kind
        #   @return [::String]
        #     Type of resource.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
        # @!attribute [rw] self_link
        #   @return [::String]
        #     [Output Only] Server-defined URL for this resource.
        # @!attribute [rw] unreachables
        #   @return [::Array<::String>]
        #     [Output Only] Unreachable resources.
        # @!attribute [rw] warning
        #   @return [::Google::Cloud::Compute::V1::Warning]
        #     [Output Only] Informational warning message.
        class BackendServiceAggregatedList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Compute::V1::BackendServicesScopedList]
          class ItemsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Message containing Cloud CDN configuration for a backend service.
        # @!attribute [rw] bypass_cache_on_request_headers
        #   @return [::Array<::Google::Cloud::Compute::V1::BackendServiceCdnPolicyBypassCacheOnRequestHeader>]
        #     Bypass the cache when the specified request headers are matched - e.g. Pragma or Authorization headers. Up to 5 headers can be specified. The cache is bypassed for all cdnPolicy.cacheMode settings.
        # @!attribute [rw] cache_key_policy
        #   @return [::Google::Cloud::Compute::V1::CacheKeyPolicy]
        #     The CacheKeyPolicy for this CdnPolicy.
        # @!attribute [rw] cache_mode
        #   @return [::String]
        #     Specifies the cache setting for all responses from this backend. The possible values are: USE_ORIGIN_HEADERS Requires the origin to set valid caching headers to cache content. Responses without these headers will not be cached at Google's edge, and will require a full trip to the origin on every request, potentially impacting performance and increasing load on the origin server. FORCE_CACHE_ALL Cache all content, ignoring any "private", "no-store" or "no-cache" directives in Cache-Control response headers. Warning: this may result in Cloud CDN caching private, per-user (user identifiable) content. CACHE_ALL_STATIC Automatically cache static content, including common image formats, media (video and audio), and web assets (JavaScript and CSS). Requests and responses that are marked as uncacheable, as well as dynamic content (including HTML), will not be cached. If no value is provided for cdnPolicy.cacheMode, it defaults to CACHE_ALL_STATIC.
        #     Check the CacheMode enum for the list of possible values.
        # @!attribute [rw] client_ttl
        #   @return [::Integer]
        #     Specifies a separate client (e.g. browser client) maximum TTL. This is used to clamp the max-age (or Expires) value sent to the client. With FORCE_CACHE_ALL, the lesser of client_ttl and default_ttl is used for the response max-age directive, along with a "public" directive. For cacheable content in CACHE_ALL_STATIC mode, client_ttl clamps the max-age from the origin (if specified), or else sets the response max-age directive to the lesser of the client_ttl and default_ttl, and also ensures a "public" cache-control directive is present. If a client TTL is not specified, a default value (1 hour) will be used. The maximum allowed value is 31,622,400s (1 year).
        # @!attribute [rw] default_ttl
        #   @return [::Integer]
        #     Specifies the default TTL for cached content served by this origin for responses that do not have an existing valid TTL (max-age or s-maxage). Setting a TTL of "0" means "always revalidate". The value of defaultTTL cannot be set to a value greater than that of maxTTL, but can be equal. When the cacheMode is set to FORCE_CACHE_ALL, the defaultTTL will overwrite the TTL set in all responses. The maximum allowed value is 31,622,400s (1 year), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
        # @!attribute [rw] max_ttl
        #   @return [::Integer]
        #     Specifies the maximum allowed TTL for cached content served by this origin. Cache directives that attempt to set a max-age or s-maxage higher than this, or an Expires header more than maxTTL seconds in the future will be capped at the value of maxTTL, as if it were the value of an s-maxage Cache-Control directive. Headers sent to the client will not be modified. Setting a TTL of "0" means "always revalidate". The maximum allowed value is 31,622,400s (1 year), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
        # @!attribute [rw] negative_caching
        #   @return [::Boolean]
        #     Negative caching allows per-status code TTLs to be set, in order to apply fine-grained caching for common errors or redirects. This can reduce the load on your origin and improve end-user experience by reducing response latency. When the cache mode is set to CACHE_ALL_STATIC or USE_ORIGIN_HEADERS, negative caching applies to responses with the specified response code that lack any Cache-Control, Expires, or Pragma: no-cache directives. When the cache mode is set to FORCE_CACHE_ALL, negative caching applies to all responses with the specified response code, and override any caching headers. By default, Cloud CDN will apply the following default TTLs to these status codes: HTTP 300 (Multiple Choice), 301, 308 (Permanent Redirects): 10m HTTP 404 (Not Found), 410 (Gone), 451 (Unavailable For Legal Reasons): 120s HTTP 405 (Method Not Found), 501 (Not Implemented): 60s. These defaults can be overridden in negative_caching_policy.
        # @!attribute [rw] negative_caching_policy
        #   @return [::Array<::Google::Cloud::Compute::V1::BackendServiceCdnPolicyNegativeCachingPolicy>]
        #     Sets a cache TTL for the specified HTTP status code. negative_caching must be enabled to configure negative_caching_policy. Omitting the policy and leaving negative_caching enabled will use Cloud CDN's default cache TTLs. Note that when specifying an explicit negative_caching_policy, you should take care to specify a cache TTL for all response codes that you wish to cache. Cloud CDN will not apply any default negative caching when a policy exists.
        # @!attribute [rw] request_coalescing
        #   @return [::Boolean]
        #     If true then Cloud CDN will combine multiple concurrent cache fill requests into a small number of requests to the origin.
        # @!attribute [rw] serve_while_stale
        #   @return [::Integer]
        #     Serve existing content from the cache (if available) when revalidating content with the origin, or when an error is encountered when refreshing the cache. This setting defines the default "max-stale" duration for any cached responses that do not specify a max-stale directive. Stale responses that exceed the TTL configured here will not be served. The default limit (max-stale) is 86400s (1 day), which will allow stale content to be served up to this limit beyond the max-age (or s-maxage) of a cached response. The maximum allowed value is 604800 (1 week). Set this to zero (0) to disable serve-while-stale.
        # @!attribute [rw] signed_url_cache_max_age_sec
        #   @return [::Integer]
        #     Maximum number of seconds the response to a signed URL request will be considered fresh. After this time period, the response will be revalidated before being served. Defaults to 1hr (3600s). When serving responses to signed URL requests, Cloud CDN will internally behave as though all responses from this backend had a "Cache-Control: public, max-age=[TTL]" header, regardless of any existing Cache-Control header. The actual headers served in responses will not be altered.
        # @!attribute [rw] signed_url_key_names
        #   @return [::Array<::String>]
        #     [Output Only] Names of the keys for signing request URLs.
        class BackendServiceCdnPolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Specifies the cache setting for all responses from this backend. The possible values are: USE_ORIGIN_HEADERS Requires the origin to set valid caching headers to cache content. Responses without these headers will not be cached at Google's edge, and will require a full trip to the origin on every request, potentially impacting performance and increasing load on the origin server. FORCE_CACHE_ALL Cache all content, ignoring any "private", "no-store" or "no-cache" directives in Cache-Control response headers. Warning: this may result in Cloud CDN caching private, per-user (user identifiable) content. CACHE_ALL_STATIC Automatically cache static content, including common image formats, media (video and audio), and web assets (JavaScript and CSS). Requests and responses that are marked as uncacheable, as well as dynamic content (including HTML), will not be cached. If no value is provided for cdnPolicy.cacheMode, it defaults to CACHE_ALL_STATIC.
          module CacheMode
            # A value indicating that the enum field is not set.
            UNDEFINED_CACHE_MODE = 0

            # Automatically cache static content, including common image formats, media (video and audio), and web assets (JavaScript and CSS). Requests and responses that are marked as uncacheable, as well as dynamic content (including HTML), will not be cached.
            CACHE_ALL_STATIC = 355_027_945

            # Cache all content, ignoring any "private", "no-store" or "no-cache" directives in Cache-Control response headers. Warning: this may result in Cloud CDN caching private, per-user (user identifiable) content.
            FORCE_CACHE_ALL = 486_026_928

            INVALID_CACHE_MODE = 381_295_560

            # Requires the origin to set valid caching headers to cache content. Responses without these headers will not be cached at Google's edge, and will require a full trip to the origin on every request, potentially impacting performance and increasing load on the origin server.
            USE_ORIGIN_HEADERS = 55_380_261
          end
        end

        # Bypass the cache when the specified request headers are present, e.g. Pragma or Authorization headers. Values are case insensitive. The presence of such a header overrides the cache_mode setting.
        # @!attribute [rw] header_name
        #   @return [::String]
        #     The header field name to match on when bypassing cache. Values are case-insensitive.
        class BackendServiceCdnPolicyBypassCacheOnRequestHeader
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Specify CDN TTLs for response error codes.
        # @!attribute [rw] code
        #   @return [::Integer]
        #     The HTTP status code to define a TTL against. Only HTTP status codes 300, 301, 302, 307, 308, 404, 405, 410, 421, 451 and 501 are can be specified as values, and you cannot specify a status code more than once.
        # @!attribute [rw] ttl
        #   @return [::Integer]
        #     The TTL (in seconds) for which to cache responses with the corresponding status code. The maximum allowed value is 1800s (30 minutes), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
        class BackendServiceCdnPolicyNegativeCachingPolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Connection Tracking configuration for this BackendService.
        # @!attribute [rw] connection_persistence_on_unhealthy_backends
        #   @return [::String]
        #     Specifies connection persistence when backends are unhealthy. The default value is DEFAULT_FOR_PROTOCOL. If set to DEFAULT_FOR_PROTOCOL, the existing connections persist on unhealthy backends only for connection-oriented protocols (TCP and SCTP) and only if the Tracking Mode is PER_CONNECTION (default tracking mode) or the Session Affinity is configured for 5-tuple. They do not persist for UDP. If set to NEVER_PERSIST, after a backend becomes unhealthy, the existing connections on the unhealthy backend are never persisted on the unhealthy backend. They are always diverted to newly selected healthy backends (unless all backends are unhealthy). If set to ALWAYS_PERSIST, existing connections always persist on unhealthy backends regardless of protocol and session affinity. It is generally not recommended to use this mode overriding the default. For more details, see [Connection Persistence for Network Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#connection-persistence) and [Connection Persistence for Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal#connection-persistence).
        #     Check the ConnectionPersistenceOnUnhealthyBackends enum for the list of possible values.
        # @!attribute [rw] enable_strong_affinity
        #   @return [::Boolean]
        #     Enable Strong Session Affinity for external passthrough Network Load Balancers. This option is not available publicly.
        # @!attribute [rw] idle_timeout_sec
        #   @return [::Integer]
        #     Specifies how long to keep a Connection Tracking entry while there is no matching traffic (in seconds). For internal passthrough Network Load Balancers: - The minimum (default) is 10 minutes and the maximum is 16 hours. - It can be set only if Connection Tracking is less than 5-tuple (i.e. Session Affinity is CLIENT_IP_NO_DESTINATION, CLIENT_IP or CLIENT_IP_PROTO, and Tracking Mode is PER_SESSION). For external passthrough Network Load Balancers the default is 60 seconds. This option is not available publicly.
        # @!attribute [rw] tracking_mode
        #   @return [::String]
        #     Specifies the key used for connection tracking. There are two options: - PER_CONNECTION: This is the default mode. The Connection Tracking is performed as per the Connection Key (default Hash Method) for the specific protocol. - PER_SESSION: The Connection Tracking is performed as per the configured Session Affinity. It matches the configured Session Affinity. For more details, see [Tracking Mode for Network Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#tracking-mode) and [Tracking Mode for Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal#tracking-mode).
        #     Check the TrackingMode enum for the list of possible values.
        class BackendServiceConnectionTrackingPolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Specifies connection persistence when backends are unhealthy. The default value is DEFAULT_FOR_PROTOCOL. If set to DEFAULT_FOR_PROTOCOL, the existing connections persist on unhealthy backends only for connection-oriented protocols (TCP and SCTP) and only if the Tracking Mode is PER_CONNECTION (default tracking mode) or the Session Affinity is configured for 5-tuple. They do not persist for UDP. If set to NEVER_PERSIST, after a backend becomes unhealthy, the existing connections on the unhealthy backend are never persisted on the unhealthy backend. They are always diverted to newly selected healthy backends (unless all backends are unhealthy). If set to ALWAYS_PERSIST, existing connections always persist on unhealthy backends regardless of protocol and session affinity. It is generally not recommended to use this mode overriding the default. For more details, see [Connection Persistence for Network Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#connection-persistence) and [Connection Persistence for Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal#connection-persistence).
          module ConnectionPersistenceOnUnhealthyBackends
            # A value indicating that the enum field is not set.
            UNDEFINED_CONNECTION_PERSISTENCE_ON_UNHEALTHY_BACKENDS = 0

            ALWAYS_PERSIST = 38_400_900

            DEFAULT_FOR_PROTOCOL = 145_265_356

            NEVER_PERSIST = 138_646_241
          end

          # Specifies the key used for connection tracking. There are two options: - PER_CONNECTION: This is the default mode. The Connection Tracking is performed as per the Connection Key (default Hash Method) for the specific protocol. - PER_SESSION: The Connection Tracking is performed as per the configured Session Affinity. It matches the configured Session Affinity. For more details, see [Tracking Mode for Network Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#tracking-mode) and [Tracking Mode for Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal#tracking-mode).
          module TrackingMode
            # A value indicating that the enum field is not set.
            UNDEFINED_TRACKING_MODE = 0

            INVALID_TRACKING_MODE = 49_234_371

            PER_CONNECTION = 85_162_848

            PER_SESSION = 182_099_252
          end
        end

        # Custom Metrics are used for WEIGHTED_ROUND_ROBIN locality_lb_policy.
        # @!attribute [rw] dry_run
        #   @return [::Boolean]
        #     If true, the metric data is not used for load balancing.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of a custom utilization signal. The name must be 1-64 characters long and match the regular expression [a-z]([-_.a-z0-9]*[a-z0-9])? which means that the first character must be a lowercase letter, and all following characters must be a dash, period, underscore, lowercase letter, or digit, except the last character, which cannot be a dash, period, or underscore. For usage guidelines, see Custom Metrics balancing mode. This field can only be used for a global or regional backend service with the loadBalancingScheme set to EXTERNAL_MANAGED, INTERNAL_MANAGED INTERNAL_SELF_MANAGED.
        class BackendServiceCustomMetric
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # For load balancers that have configurable failover: [Internal passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/internal/failover-overview) and [external passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview). On failover or failback, this field indicates whether connection draining will be honored. Google Cloud has a fixed connection draining timeout of 10 minutes. A setting of true terminates existing TCP connections to the active pool during failover and failback, immediately draining traffic. A setting of false allows existing TCP connections to persist, even on VMs no longer in the active pool, for up to the duration of the connection draining timeout (10 minutes).
        # @!attribute [rw] disable_connection_drain_on_failover
        #   @return [::Boolean]
        #     This can be set to true only if the protocol is TCP. The default is false.
        # @!attribute [rw] drop_traffic_if_unhealthy
        #   @return [::Boolean]
        #     If set to true, connections to the load balancer are dropped when all primary and all backup backend VMs are unhealthy.If set to false, connections are distributed among all primary VMs when all primary and all backup backend VMs are unhealthy. For load balancers that have configurable failover: [Internal passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/internal/failover-overview) and [external passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview). The default is false.
        # @!attribute [rw] failover_ratio
        #   @return [::Float]
        #     The value of the field must be in the range [0, 1]. If the value is 0, the load balancer performs a failover when the number of healthy primary VMs equals zero. For all other values, the load balancer performs a failover when the total number of healthy primary VMs is less than this ratio. For load balancers that have configurable failover: [Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal/failover-overview) and [external TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview).
        class BackendServiceFailoverPolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] annotations
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Metadata defined as annotations on the network endpoint group.
        # @!attribute [rw] health_status
        #   @return [::Array<::Google::Cloud::Compute::V1::HealthStatus>]
        #     Health state of the backend instances or endpoints in requested instance or network endpoint group, determined based on configured health checks.
        # @!attribute [rw] kind
        #   @return [::String]
        #     [Output Only] Type of resource. Always compute#backendServiceGroupHealth for the health of backend services.
        class BackendServiceGroupHealth
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AnnotationsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # @!attribute [rw] fast_i_p_move
        #   @return [::String]
        #     Specifies whether fast IP move is enabled, and if so, the mechanism to achieve it. Supported values are: - DISABLED: Fast IP Move is disabled. You can only use the haPolicy.leader API to update the leader. - >GARP_RA: Provides a method to very quickly define a new network endpoint as the leader. This method is faster than updating the leader using the haPolicy.leader API. Fast IP move works as follows: The VM hosting the network endpoint that should become the new leader sends either a Gratuitous ARP (GARP) packet (IPv4) or an ICMPv6 Router Advertisement(RA) packet (IPv6). Google Cloud immediately but temporarily associates the forwarding rule IP address with that VM, and both new and in-flight packets are quickly delivered to that VM. Note the important properties of the Fast IP Move functionality: - The GARP/RA-initiated re-routing stays active for approximately 20 minutes. After triggering fast failover, you must also appropriately set the haPolicy.leader. - The new leader instance should continue to send GARP/RA packets periodically every 10 seconds until at least 10 minutes after updating the haPolicy.leader (but stop immediately if it is no longer the leader). - After triggering a fast failover, we recommend that you wait at least 3 seconds before sending another GARP/RA packet from a different VM instance to avoid race conditions. - Don't send GARP/RA packets from different VM instances at the same time. If multiple instances continue to send GARP/RA packets, traffic might be routed to different destinations in an alternating order. This condition ceases when a single instance issues a GARP/RA packet. - The GARP/RA request always takes priority over the leader API. Using the haPolicy.leader API to change the leader to a different instance will have no effect until the GARP/RA request becomes inactive. - The GARP/RA packets should follow the GARP/RA Packet Specifications.. - When multiple forwarding rules refer to a regional backend service, you need only send a GARP or RA packet for a single forwarding rule virtual IP. The virtual IPs for all forwarding rules targeting the same backend service will also be moved to the sender of the GARP or RA packet. The following are the Fast IP Move limitations (that is, when fastIPMove is not DISABLED): - Multiple forwarding rules cannot use the same IP address if one of them refers to a regional backend service with fastIPMove. - The regional backend service must set the network field, and all NEGs must belong to that network. However, individual NEGs can belong to different subnetworks of that network. - The maximum number of network endpoints across all backends of a backend service with fastIPMove is 32. - The maximum number of backend services with fastIPMove that can have the same network endpoint attached to one of its backends is 64. - The maximum number of backend services with fastIPMove in a VPC in a region is 64. - The network endpoints that are attached to a backend of a backend service with fastIPMove cannot resolve to Gen3+ machines for IPv6. - Traffic directed to the leader by a static route next hop will not be redirected to a new leader by fast failover. Such traffic will only be redirected once an haPolicy.leader update has taken effect. Only traffic to the forwarding rule's virtual IP will be redirected to a new leader by fast failover. haPolicy.fastIPMove can be set only at backend service creation time. Once set, it cannot be updated. By default, fastIpMove is set to DISABLED.
        #     Check the FastIPMove enum for the list of possible values.
        # @!attribute [rw] leader
        #   @return [::Google::Cloud::Compute::V1::BackendServiceHAPolicyLeader]
        #     Selects one of the network endpoints attached to the backend NEGs of this service as the active endpoint (the leader) that receives all traffic. When the leader changes, there is no connection draining to persist existing connections on the old leader. You are responsible for selecting a suitable endpoint as the leader. For example, preferring a healthy endpoint over unhealthy ones. Note that this service does not track backend endpoint health, and selects the configured leader unconditionally.
        class BackendServiceHAPolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Specifies whether fast IP move is enabled, and if so, the mechanism to achieve it. Supported values are: - DISABLED: Fast IP Move is disabled. You can only use the haPolicy.leader API to update the leader. - >GARP_RA: Provides a method to very quickly define a new network endpoint as the leader. This method is faster than updating the leader using the haPolicy.leader API. Fast IP move works as follows: The VM hosting the network endpoint that should become the new leader sends either a Gratuitous ARP (GARP) packet (IPv4) or an ICMPv6 Router Advertisement(RA) packet (IPv6). Google Cloud immediately but temporarily associates the forwarding rule IP address with that VM, and both new and in-flight packets are quickly delivered to that VM. Note the important properties of the Fast IP Move functionality: - The GARP/RA-initiated re-routing stays active for approximately 20 minutes. After triggering fast failover, you must also appropriately set the haPolicy.leader. - The new leader instance should continue to send GARP/RA packets periodically every 10 seconds until at least 10 minutes after updating the haPolicy.leader (but stop immediately if it is no longer the leader). - After triggering a fast failover, we recommend that you wait at least 3 seconds before sending another GARP/RA packet from a different VM instance to avoid race conditions. - Don't send GARP/RA packets from different VM instances at the same time. If multiple instances continue to send GARP/RA packets, traffic might be routed to different destinations in an alternating order. This condition ceases when a single instance issues a GARP/RA packet. - The GARP/RA request always takes priority over the leader API. Using the haPolicy.leader API to change the leader to a different instance will have no effect until the GARP/RA request becomes inactive. - The GARP/RA packets should follow the GARP/RA Packet Specifications.. - When multiple forwarding rules refer to a regional backend service, you need only send a GARP or RA packet for a single forwarding rule virtual IP. The virtual IPs for all forwarding rules targeting the same backend service will also be moved to the sender of the GARP or RA packet. The following are the Fast IP Move limitations (that is, when fastIPMove is not DISABLED): - Multiple forwarding rules cannot use the same IP address if one of them refers to a regional backend service with fastIPMove. - The regional backend service must set the network field, and all NEGs must belong to that network. However, individual NEGs can belong to different subnetworks of that network. - The maximum number of network endpoints across all backends of a backend service with fastIPMove is 32. - The maximum number of backend services with fastIPMove that can have the same network endpoint attached to one of its backends is 64. - The maximum number of backend services with fastIPMove in a VPC in a region is 64. - The network endpoints that are attached to a backend of a backend service with fastIPMove cannot resolve to Gen3+ machines for IPv6. - Traffic directed to the leader by a static route next hop will not be redirected to a new leader by fast failover. Such traffic will only be redirected once an haPolicy.leader update has taken effect. Only traffic to the forwarding rule's virtual IP will be redirected to a new leader by fast failover. haPolicy.fastIPMove can be set only at backend service creation time. Once set, it cannot be updated. By default, fastIpMove is set to DISABLED.
          module FastIPMove
            # A value indicating that the enum field is not set.
            UNDEFINED_FAST_I_P_MOVE = 0

            DISABLED = 516_696_700

            GARP_RA = 527_352_630
          end
        end

        # @!attribute [rw] backend_group
        #   @return [::String]
        #     A fully-qualified URL (starting with https://www.googleapis.com/) of the zonal Network Endpoint Group (NEG) with `GCE_VM_IP` endpoints that the leader is attached to. The leader's backendGroup must already be specified as a backend of this backend service. Removing a backend that is designated as the leader's backendGroup is not permitted.
        # @!attribute [rw] network_endpoint
        #   @return [::Google::Cloud::Compute::V1::BackendServiceHAPolicyLeaderNetworkEndpoint]
        #     The network endpoint within the leader.backendGroup that is designated as the leader. This network endpoint cannot be detached from the NEG specified in the haPolicy.leader.backendGroup until the leader is updated with another network endpoint, or the leader is removed from the haPolicy.
        class BackendServiceHAPolicyLeader
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] instance
        #   @return [::String]
        #     The name of the VM instance of the leader network endpoint. The instance must already be attached to the NEG specified in the haPolicy.leader.backendGroup. The name must be 1-63 characters long, and comply with RFC1035. Authorization requires the following IAM permission on the specified resource instance: compute.instances.use
        class BackendServiceHAPolicyLeaderNetworkEndpoint
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The HTTP cookie used for stateful session affinity.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the cookie.
        # @!attribute [rw] path
        #   @return [::String]
        #     Path to set for the cookie.
        # @!attribute [rw] ttl
        #   @return [::Google::Cloud::Compute::V1::Duration]
        #     Lifetime of the cookie.
        class BackendServiceHttpCookie
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Identity-Aware Proxy
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Whether the serving infrastructure will authenticate and authorize all incoming requests.
        # @!attribute [rw] oauth2_client_id
        #   @return [::String]
        #     OAuth2 client ID to use for the authentication flow.
        # @!attribute [rw] oauth2_client_secret
        #   @return [::String]
        #     OAuth2 client secret to use for the authentication flow. For security reasons, this value cannot be retrieved via the API. Instead, the SHA-256 hash of the value is returned in the oauth2ClientSecretSha256 field. @InputOnly
        # @!attribute [rw] oauth2_client_secret_sha256
        #   @return [::String]
        #     [Output Only] SHA256 hash value for the field oauth2_client_secret above.
        class BackendServiceIAP
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Contains a list of BackendService resources.
        # @!attribute [rw] id
        #   @return [::String]
        #     [Output Only] Unique identifier for the resource; defined by the server.
        # @!attribute [rw] items
        #   @return [::Array<::Google::Cloud::Compute::V1::BackendService>]
        #     A list of BackendService resources.
        # @!attribute [rw] kind
        #   @return [::String]
        #     [Output Only] Type of resource. Always compute#backendServiceList for lists of backend services.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
        # @!attribute [rw] self_link
        #   @return [::String]
        #     [Output Only] Server-defined URL for this resource.
        # @!attribute [rw] warning
        #   @return [::Google::Cloud::Compute::V1::Warning]
        #     [Output Only] Informational warning message.
        class BackendServiceList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Contains a list of usable BackendService resources.
        # @!attribute [rw] id
        #   @return [::String]
        #     [Output Only] Unique identifier for the resource; defined by the server.
        # @!attribute [rw] items
        #   @return [::Array<::Google::Cloud::Compute::V1::BackendService>]
        #     A list of BackendService resources.
        # @!attribute [rw] kind
        #   @return [::String]
        #     [Output Only] Type of resource. Always compute#usableBackendServiceList for lists of usable backend services.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
        # @!attribute [rw] self_link
        #   @return [::String]
        #     [Output Only] Server-defined URL for this resource.
        # @!attribute [rw] warning
        #   @return [::Google::Cloud::Compute::V1::Warning]
        #     [Output Only] Informational warning message.
        class BackendServiceListUsable
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Container for either a built-in LB policy supported by gRPC or Envoy or a custom one implemented by the end user.
        # @!attribute [rw] custom_policy
        #   @return [::Google::Cloud::Compute::V1::BackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy]
        # @!attribute [rw] policy
        #   @return [::Google::Cloud::Compute::V1::BackendServiceLocalityLoadBalancingPolicyConfigPolicy]
        class BackendServiceLocalityLoadBalancingPolicyConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The configuration for a custom policy implemented by the user and deployed with the client.
        # @!attribute [rw] data
        #   @return [::String]
        #     An optional, arbitrary JSON object with configuration data, understood by a locally installed custom policy implementation.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifies the custom policy. The value should match the name of a custom implementation registered on the gRPC clients. It should follow protocol buffer message naming conventions and include the full path (for example, myorg.CustomLbPolicy). The maximum length is 256 characters. Do not specify the same custom policy more than once for a backend. If you do, the configuration is rejected. For an example of how to use this field, see Use a custom policy.
        class BackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The configuration for a built-in load balancing policy.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of a locality load-balancing policy. Valid values include ROUND_ROBIN and, for Java clients, LEAST_REQUEST. For information about these values, see the description of localityLbPolicy. Do not specify the same policy more than once for a backend. If you do, the configuration is rejected.
        #     Check the Name enum for the list of possible values.
        class BackendServiceLocalityLoadBalancingPolicyConfigPolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The name of a locality load-balancing policy. Valid values include ROUND_ROBIN and, for Java clients, LEAST_REQUEST. For information about these values, see the description of localityLbPolicy. Do not specify the same policy more than once for a backend. If you do, the configuration is rejected.
          module Name
            # A value indicating that the enum field is not set.
            UNDEFINED_NAME = 0

            INVALID_LB_POLICY = 323_318_707

            # An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests.
            LEAST_REQUEST = 46_604_921

            # This algorithm implements consistent hashing to backends. Maglev can be used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see Maglev: A Fast and Reliable Software Network Load Balancer.
            MAGLEV = 119_180_266

            # Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer.
            ORIGINAL_DESTINATION = 166_297_216

            # The load balancer selects a random healthy host.
            RANDOM = 262_527_171

            # The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests.
            RING_HASH = 432_795_069

            # This is a simple policy in which each healthy backend is selected in round robin order. This is the default.
            ROUND_ROBIN = 153_895_801

            # Per-instance weighted Load Balancing via health check reported weights. In internal passthrough network load balancing, it is weighted rendezvous hashing. This option is only supported in internal passthrough network load balancing.
            WEIGHTED_GCP_RENDEZVOUS = 82_501_640

            # Per-instance weighted Load Balancing via health check reported weights. If set, the Backend Service must configure a non legacy HTTP-based Health Check, and health check replies are expected to contain non-standard HTTP response header field X-Load-Balancing-Endpoint-Weight to specify the per-instance weights. If set, Load Balancing is weighted based on the per-instance weights reported in the last processed health check replies, as long as every instance either reported a valid weight or had UNAVAILABLE_WEIGHT. Otherwise, Load Balancing remains equal-weight. This option is only supported in Network Load Balancing.
            WEIGHTED_MAGLEV = 254_930_962

            # Per-endpoint weighted round-robin Load Balancing using weights computed from Backend reported Custom Metrics. If set, the Backend Service responses are expected to contain non-standard HTTP response header field Endpoint-Load-Metrics. The reported metrics to use for computing the weights are specified via the customMetrics fields.
            WEIGHTED_ROUND_ROBIN = 5_584_977
          end
        end

        # The available logging options for the load balancer traffic served by this backend service.
        # @!attribute [rw] enable
        #   @return [::Boolean]
        #     Denotes whether to enable logging for the load balancer traffic served by this backend service. The default value is false.
        # @!attribute [rw] optional_fields
        #   @return [::Array<::String>]
        #     This field can only be specified if logging is enabled for this backend service and "logConfig.optionalMode" was set to CUSTOM. Contains a list of optional fields you want to include in the logs. For example: serverInstance, serverGkeDetails.cluster, serverGkeDetails.pod.podNamespace
        # @!attribute [rw] optional_mode
        #   @return [::String]
        #     This field can only be specified if logging is enabled for this backend service. Configures whether all, none or a subset of optional fields should be added to the reported logs. One of [INCLUDE_ALL_OPTIONAL, EXCLUDE_ALL_OPTIONAL, CUSTOM]. Default is EXCLUDE_ALL_OPTIONAL.
        #     Check the OptionalMode enum for the list of possible values.
        # @!attribute [rw] sample_rate
        #   @return [::Float]
        #     This field can only be specified if logging is enabled for this backend service. The value of the field must be in [0, 1]. This configures the sampling rate of requests to the load balancer where 1.0 means all logged requests are reported and 0.0 means no logged requests are reported. The default value is 1.0.
        class BackendServiceLogConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # This field can only be specified if logging is enabled for this backend service. Configures whether all, none or a subset of optional fields should be added to the reported logs. One of [INCLUDE_ALL_OPTIONAL, EXCLUDE_ALL_OPTIONAL, CUSTOM]. Default is EXCLUDE_ALL_OPTIONAL.
          module OptionalMode
            # A value indicating that the enum field is not set.
            UNDEFINED_OPTIONAL_MODE = 0

            # A subset of optional fields.
            CUSTOM = 388_595_569

            # None optional fields.
            EXCLUDE_ALL_OPTIONAL = 168_636_099

            # All optional fields.
            INCLUDE_ALL_OPTIONAL = 535_606_965
          end
        end

        # Additional Backend Service parameters.
        # @!attribute [rw] resource_manager_tags
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Tag keys/values directly bound to this resource. Tag keys and values have the same definition as resource manager tags. The field is allowed for INSERT only. The keys/values to set on the resource should be specified in either ID { : } or Namespaced format { : }. For example the following are valid inputs: * \\{"tagKeys/333" : "tagValues/444", "tagKeys/123" : "tagValues/456"} * \\{"123/environment" : "production", "345/abc" : "xyz"} Note: * Invalid combinations of ID & namespaced format is not supported. For instance: \\{"123/environment" : "tagValues/444"} is invalid.
        class BackendServiceParams
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class ResourceManagerTagsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # @!attribute [rw] backend_service
        #   @return [::String]
        class BackendServiceReference
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] authentication_config
        #   @return [::String]
        #     Reference to the BackendAuthenticationConfig resource from the networksecurity.googleapis.com namespace. Can be used in authenticating TLS connections to the backend, as specified by the authenticationMode field. Can only be specified if authenticationMode is not NONE.
        # @!attribute [rw] sni
        #   @return [::String]
        #     Server Name Indication - see RFC3546 section 3.1. If set, the load balancer sends this string as the SNI hostname in the TLS connection to the backend, and requires that this string match a Subject Alternative Name (SAN) in the backend's server certificate. With a Regional Internet NEG backend, if the SNI is specified here, the load balancer uses it regardless of whether the Regional Internet NEG is specified with FQDN or IP address and port. When both sni and subjectAltNames[] are specified, the load balancer matches the backend certificate's SAN only to subjectAltNames[].
        # @!attribute [rw] subject_alt_names
        #   @return [::Array<::Google::Cloud::Compute::V1::BackendServiceTlsSettingsSubjectAltName>]
        #     A list of Subject Alternative Names (SANs) that the Load Balancer verifies during a TLS handshake with the backend. When the server presents its X.509 certificate to the Load Balancer, the Load Balancer inspects the certificate's SAN field, and requires that at least one SAN match one of the subjectAltNames in the list. This field is limited to 5 entries. When both sni and subjectAltNames[] are specified, the load balancer matches the backend certificate's SAN only to subjectAltNames[].
        class BackendServiceTlsSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A Subject Alternative Name that the load balancer matches against the SAN field in the TLS certificate provided by the backend, specified as either a DNS name or a URI, in accordance with RFC 5280 4.2.1.6
        # @!attribute [rw] dns_name
        #   @return [::String]
        #     The SAN specified as a DNS Name.
        # @!attribute [rw] uniform_resource_identifier
        #   @return [::String]
        #     The SAN specified as a URI.
        class BackendServiceTlsSettingsSubjectAltName
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] reference
        #   @return [::String]
        #     [Output Only] Server-defined URL for resources referencing given BackendService like UrlMaps, TargetTcpProxies, TargetSslProxies and ForwardingRule.
        class BackendServiceUsedBy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] backend_services
        #   @return [::Array<::Google::Cloud::Compute::V1::BackendService>]
        #     A list of BackendServices contained in this scope.
        # @!attribute [rw] warning
        #   @return [::Google::Cloud::Compute::V1::Warning]
        #     Informational warning which replaces the list of backend services when the list is empty.
        class BackendServicesScopedList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] authentication_present
        #   @return [::Boolean]
        #     The Authentication Present bit of the BFD packet. This is specified in section 4.1 of RFC5880
        # @!attribute [rw] control_plane_independent
        #   @return [::Boolean]
        #     The Control Plane Independent bit of the BFD packet. This is specified in section 4.1 of RFC5880
        # @!attribute [rw] demand
        #   @return [::Boolean]
        #     The demand bit of the BFD packet. This is specified in section 4.1 of RFC5880
        # @!attribute [rw] diagnostic
        #   @return [::String]
        #     The diagnostic code specifies the local system's reason for the last change in session state. This allows remote systems to determine the reason that the previous session failed, for example. These diagnostic codes are specified in section 4.1 of RFC5880
        #     Check the Diagnostic enum for the list of possible values.
        # @!attribute [rw] final
        #   @return [::Boolean]
        #     The Final bit of the BFD packet. This is specified in section 4.1 of RFC5880
        # @!attribute [rw] length
        #   @return [::Integer]
        #     The length of the BFD Control packet in bytes. This is specified in section 4.1 of RFC5880
        # @!attribute [rw] min_echo_rx_interval_ms
        #   @return [::Integer]
        #     The Required Min Echo RX Interval value in the BFD packet. This is specified in section 4.1 of RFC5880
        # @!attribute [rw] min_rx_interval_ms
        #   @return [::Integer]
        #     The Required Min RX Interval value in the BFD packet. This is specified in section 4.1 of RFC5880
        # @!attribute [rw] min_tx_interval_ms
        #   @return [::Integer]
        #     The Desired Min TX Interval value in the BFD packet. This is specified in section 4.1 of RFC5880
        # @!attribute [rw] multiplier
        #   @return [::Integer]
        #     The detection time multiplier of the BFD packet. This is specified in section 4.1 of RFC5880
        # @!attribute [rw] multipoint
        #   @return [::Boolean]
        #     The multipoint bit of the BFD packet. This is specified in section 4.1 of RFC5880
        # @!attribute [rw] my_discriminator
        #   @return [::Integer]
        #     The My Discriminator value in the BFD packet. This is specified in section 4.1 of RFC5880
        # @!attribute [rw] poll
        #   @return [::Boolean]
        #     The Poll bit of the BFD packet. This is specified in section 4.1 of RFC5880
        # @!attribute [rw] state
        #   @return [::String]
        #     The current BFD session state as seen by the transmitting system. These states are specified in section 4.1 of RFC5880
        #     Check the State enum for the list of possible values.
        # @!attribute [rw] version
        #   @return [::Integer]
        #     The version number of the BFD protocol, as specified in section 4.1 of RFC5880.
        # @!attribute [rw] your_discriminator
        #   @return [::Integer]
        #     The Your Discriminator value in the BFD packet. This is specified in section 4.1 of RFC5880
        class BfdPacket
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The diagnostic code specifies the local system's reason for the last change in session state. This allows remote systems to determine the reason that the previous session failed, for example. These diagnostic codes are specified in section 4.1 of RFC5880
          module Diagnostic
            # A value indicating that the enum field is not set.
            UNDEFINED_DIAGNOSTIC = 0

            ADMINISTRATIVELY_DOWN = 121_685_798

            CONCATENATED_PATH_DOWN = 26_186_892

            CONTROL_DETECTION_TIME_EXPIRED = 135_478_383

            DIAGNOSTIC_UNSPECIFIED = 58_720_895

            ECHO_FUNCTION_FAILED = 220_687_466

            FORWARDING_PLANE_RESET = 19_715_882

            NEIGHBOR_SIGNALED_SESSION_DOWN = 374_226_742

            NO_DIAGNOSTIC = 222_503_141

            PATH_DOWN = 290_605_180

            REVERSE_CONCATENATED_PATH_DOWN = 479_337_129
          end

          # The current BFD session state as seen by the transmitting system. These states are specified in section 4.1 of RFC5880
          module State
            # A value indicating that the enum field is not set.
            UNDEFINED_STATE = 0

            ADMIN_DOWN = 128_544_690

            DOWN = 2_104_482

            INIT = 2_252_048

            STATE_UNSPECIFIED = 470_755_401

            UP = 2715
          end
        end

        # Next free: 15
        # @!attribute [rw] bfd_session_initialization_mode
        #   @return [::String]
        #     The BFD session initialization mode for this BGP peer. If set to ACTIVE, the Cloud Router will initiate the BFD session for this BGP peer. If set to PASSIVE, the Cloud Router will wait for the peer router to initiate the BFD session for this BGP peer. If set to DISABLED, BFD is disabled for this BGP peer.
        #     Check the BfdSessionInitializationMode enum for the list of possible values.
        # @!attribute [rw] config_update_timestamp_micros
        #   @return [::Integer]
        #     Unix timestamp of the most recent config update.
        # @!attribute [rw] control_packet_counts
        #   @return [::Google::Cloud::Compute::V1::BfdStatusPacketCounts]
        #     Control packet counts for the current BFD session.
        # @!attribute [rw] control_packet_intervals
        #   @return [::Array<::Google::Cloud::Compute::V1::PacketIntervals>]
        #     Inter-packet time interval statistics for control packets.
        # @!attribute [rw] local_diagnostic
        #   @return [::String]
        #     The diagnostic code specifies the local system's reason for the last change in session state. This allows remote systems to determine the reason that the previous session failed, for example. These diagnostic codes are specified in section 4.1 of RFC5880
        #     Check the LocalDiagnostic enum for the list of possible values.
        # @!attribute [rw] local_state
        #   @return [::String]
        #     The current BFD session state as seen by the transmitting system. These states are specified in section 4.1 of RFC5880
        #     Check the LocalState enum for the list of possible values.
        # @!attribute [rw] negotiated_local_control_tx_interval_ms
        #   @return [::Integer]
        #     Negotiated transmit interval for control packets.
        # @!attribute [rw] rx_packet
        #   @return [::Google::Cloud::Compute::V1::BfdPacket]
        #     The most recent Rx control packet for this BFD session.
        # @!attribute [rw] tx_packet
        #   @return [::Google::Cloud::Compute::V1::BfdPacket]
        #     The most recent Tx control packet for this BFD session.
        # @!attribute [rw] uptime_ms
        #   @return [::Integer]
        #     Session uptime in milliseconds. Value will be 0 if session is not up.
        class BfdStatus
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The BFD session initialization mode for this BGP peer. If set to ACTIVE, the Cloud Router will initiate the BFD session for this BGP peer. If set to PASSIVE, the Cloud Router will wait for the peer router to initiate the BFD session for this BGP peer. If set to DISABLED, BFD is disabled for this BGP peer.
          module BfdSessionInitializationMode
            # A value indicating that the enum field is not set.
            UNDEFINED_BFD_SESSION_INITIALIZATION_MODE = 0

            ACTIVE = 314_733_318

            DISABLED = 516_696_700

            PASSIVE = 462_813_959
          end

          # The diagnostic code specifies the local system's reason for the last change in session state. This allows remote systems to determine the reason that the previous session failed, for example. These diagnostic codes are specified in section 4.1 of RFC5880
          module LocalDiagnostic
            # A value indicating that the enum field is not set.
            UNDEFINED_LOCAL_DIAGNOSTIC = 0

            ADMINISTRATIVELY_DOWN = 121_685_798

            CONCATENATED_PATH_DOWN = 26_186_892

            CONTROL_DETECTION_TIME_EXPIRED = 135_478_383

            DIAGNOSTIC_UNSPECIFIED = 58_720_895

            ECHO_FUNCTION_FAILED = 220_687_466

            FORWARDING_PLANE_RESET = 19_715_882

            NEIGHBOR_SIGNALED_SESSION_DOWN = 374_226_742

            NO_DIAGNOSTIC = 222_503_141

            PATH_DOWN = 290_605_180

            REVERSE_CONCATENATED_PATH_DOWN = 479_337_129
          end

          # The current BFD session state as seen by the transmitting system. These states are specified in section 4.1 of RFC5880
          module LocalState
            # A value indicating that the enum field is not set.
            UNDEFINED_LOCAL_STATE = 0

            ADMIN_DOWN = 128_544_690

            DOWN = 2_104_482

            INIT = 2_252_048

            STATE_UNSPECIFIED = 470_755_401

            UP = 2715
          end
        end

        # @!attribute [rw] num_rx
        #   @return [::Integer]
        #     Number of packets received since the beginning of the current BFD session.
        # @!attribute [rw] num_rx_rejected
        #   @return [::Integer]
        #     Number of packets received that were rejected because of errors since the beginning of the current BFD session.
        # @!attribute [rw] num_rx_successful
        #   @return [::Integer]
        #     Number of packets received that were successfully processed since the beginning of the current BFD session.
        # @!attribute [rw] num_tx
        #   @return [::Integer]
        #     Number of packets transmitted since the beginning of the current BFD session.
        class BfdStatusPacketCounts
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] as_paths
        #   @return [::Array<::Google::Cloud::Compute::V1::BgpRouteAsPath>]
        #     [Output only] AS-PATH for the route
        # @!attribute [rw] communities
        #   @return [::Array<::String>]
        #     [Output only] BGP communities in human-readable A:B format.
        # @!attribute [rw] destination
        #   @return [::Google::Cloud::Compute::V1::BgpRouteNetworkLayerReachabilityInformation]
        #     [Output only] Destination IP range for the route, in human-readable CIDR format
        # @!attribute [rw] med
        #   @return [::Integer]
        #     [Output only] BGP multi-exit discriminator
        # @!attribute [rw] origin
        #   @return [::String]
        #     [Output only] BGP origin (EGP, IGP or INCOMPLETE)
        #     Check the Origin enum for the list of possible values.
        class BgpRoute
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # [Output only] BGP origin (EGP, IGP or INCOMPLETE)
          module Origin
            # A value indicating that the enum field is not set.
            UNDEFINED_ORIGIN = 0

            BGP_ORIGIN_EGP = 378_906_473

            BGP_ORIGIN_IGP = 378_910_317

            BGP_ORIGIN_INCOMPLETE = 452_839_811
          end
        end

        # @!attribute [rw] asns
        #   @return [::Array<::Integer>]
        #     [Output only] ASNs in the path segment. When type is SEQUENCE, these are ordered.
        # @!attribute [rw] type
        #   @return [::String]
        #     [Output only] Type of AS-PATH segment (SEQUENCE or SET)
        #     Check the Type enum for the list of possible values.
        class BgpRouteAsPath
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # [Output only] Type of AS-PATH segment (SEQUENCE or SET)
          module Type
            # A value indicating that the enum field is not set.
            UNDEFINED_TYPE = 0

            AS_PATH_TYPE_SEQUENCE = 362_887_609

            AS_PATH_TYPE_SET = 302_584_650
          end
        end

        # Network Layer Reachability Information (NLRI) for a route.
        # @!attribute [rw] path_id
        #   @return [::Integer]
        #     If the BGP session supports multiple paths (RFC 7911), the path identifier for this route.
        # @!attribute [rw] prefix
        #   @return [::String]
        #     Human readable CIDR notation for a prefix. E.g. 10.42.0.0/16.
        class BgpRouteNetworkLayerReachabilityInformation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Associates `members`, or principals, with a `role`.
        # @!attribute [rw] binding_id
        #   @return [::String]
        # @!attribute [rw] condition
        #   @return [::Google::Cloud::Compute::V1::Expr]
        #     The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        # @!attribute [rw] members
        #   @return [::Array<::String>]
        #     Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. Does not include identities that come from external identity providers (IdPs) through identity federation. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a Google service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An identifier for a [Kubernetes service account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. * `principal://iam.googleapis.com/locations/global/workforcePools/{pool_id}/subject/{subject_attribute_value}`: A single identity in a workforce identity pool. * `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/group/{group_id}`: All workforce identities in a group. * `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/attribute.{attribute_name}/{attribute_value}`: All workforce identities with a specific attribute value. * `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/*`: All identities in a workforce identity pool. * `principal://iam.googleapis.com/projects/{project_number}/locations/global/workloadIdentityPools/{pool_id}/subject/{subject_attribute_value}`: A single identity in a workload identity pool. * `principalSet://iam.googleapis.com/projects/{project_number}/locations/global/workloadIdentityPools/{pool_id}/group/{group_id}`: A workload identity pool group. * `principalSet://iam.googleapis.com/projects/{project_number}/locations/global/workloadIdentityPools/{pool_id}/attribute.{attribute_name}/{attribute_value}`: All identities in a workload identity pool with a certain attribute. * `principalSet://iam.googleapis.com/projects/{project_number}/locations/global/workloadIdentityPools/{pool_id}/*`: All identities in a workload identity pool. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `deleted:principal://iam.googleapis.com/locations/global/workforcePools/{pool_id}/subject/{subject_attribute_value}`: Deleted single identity in a workforce identity pool. For example, `deleted:principal://iam.googleapis.com/locations/global/workforcePools/my-pool-id/subject/my-subject-attribute-value`.
        # @!attribute [rw] role
        #   @return [::String]
        #     Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`. For an overview of the IAM roles and permissions, see the [IAM documentation](https://cloud.google.com/iam/docs/roles-overview). For a list of the available pre-defined roles, see [here](https://cloud.google.com/iam/docs/understanding-roles).
        class Binding
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Disks.BulkInsert. See the method description for details.
        # @!attribute [rw] bulk_insert_disk_resource_resource
        #   @return [::Google::Cloud::Compute::V1::BulkInsertDiskResource]
        #     The body resource for this request
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone for this request.
        class BulkInsertDiskRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A transient resource used in compute.disks.bulkInsert and compute.regionDisks.bulkInsert. It is only used to process requests and is not persisted.
        # @!attribute [rw] source_consistency_group_policy
        #   @return [::String]
        #     The URL of the DiskConsistencyGroupPolicy for the group of disks to clone. This may be a full or partial URL, such as: - https://www.googleapis.com/compute/v1/projects/project/regions/region /resourcePolicies/resourcePolicy - projects/project/regions/region/resourcePolicies/resourcePolicy - regions/region/resourcePolicies/resourcePolicy
        class BulkInsertDiskResource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Instances.BulkInsert. See the method description for details.
        # @!attribute [rw] bulk_insert_instance_resource_resource
        #   @return [::Google::Cloud::Compute::V1::BulkInsertInstanceResource]
        #     The body resource for this request
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone for this request.
        class BulkInsertInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A transient resource used in compute.instances.bulkInsert and compute.regionInstances.bulkInsert . This resource is not persisted anywhere, it is used only for processing the requests.
        # @!attribute [rw] count
        #   @return [::Integer]
        #     The maximum number of instances to create.
        # @!attribute [rw] instance_properties
        #   @return [::Google::Cloud::Compute::V1::InstanceProperties]
        #     The instance properties defining the VM instances to be created. Required if sourceInstanceTemplate is not provided.
        # @!attribute [rw] location_policy
        #   @return [::Google::Cloud::Compute::V1::LocationPolicy]
        #     Policy for choosing target zone. For more information, see Create VMs in bulk.
        # @!attribute [rw] min_count
        #   @return [::Integer]
        #     The minimum number of instances to create. If no min_count is specified then count is used as the default value. If min_count instances cannot be created, then no instances will be created and instances already created will be deleted.
        # @!attribute [rw] name_pattern
        #   @return [::String]
        #     The string pattern used for the names of the VMs. Either name_pattern or per_instance_properties must be set. The pattern must contain one continuous sequence of placeholder hash characters (#) with each character corresponding to one digit of the generated instance name. Example: a name_pattern of inst-#### generates instance names such as inst-0001 and inst-0002. If existing instances in the same project and zone have names that match the name pattern then the generated instance numbers start after the biggest existing number. For example, if there exists an instance with name inst-0050, then instance names generated using the pattern inst-#### begin with inst-0051. The name pattern placeholder #...# can contain up to 18 characters.
        # @!attribute [rw] per_instance_properties
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Compute::V1::BulkInsertInstanceResourcePerInstanceProperties}]
        #     Per-instance properties to be set on individual instances. Keys of this map specify requested instance names. Can be empty if name_pattern is used.
        # @!attribute [rw] source_instance_template
        #   @return [::String]
        #     Specifies the instance template from which to create instances. You may combine sourceInstanceTemplate with instanceProperties to override specific values from an existing instance template. Bulk API follows the semantics of JSON Merge Patch described by RFC 7396. It can be a full or partial URL. For example, the following are all valid URLs to an instance template: - https://www.googleapis.com/compute/v1/projects/project /global/instanceTemplates/instanceTemplate - projects/project/global/instanceTemplates/instanceTemplate - global/instanceTemplates/instanceTemplate This field is optional.
        class BulkInsertInstanceResource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Compute::V1::BulkInsertInstanceResourcePerInstanceProperties]
          class PerInstancePropertiesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Per-instance properties to be set on individual instances. To be extended in the future.
        # @!attribute [rw] hostname
        #   @return [::String]
        #     Specifies the hostname of the instance. More details in: https://cloud.google.com/compute/docs/instances/custom-hostname-vm#naming_convention
        # @!attribute [rw] name
        #   @return [::String]
        #     This field is only temporary. It will be removed. Do not use it.
        class BulkInsertInstanceResourcePerInstanceProperties
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] created_vm_count
        #   @return [::Integer]
        #     [Output Only] Count of VMs successfully created so far.
        # @!attribute [rw] deleted_vm_count
        #   @return [::Integer]
        #     [Output Only] Count of VMs that got deleted during rollback.
        # @!attribute [rw] failed_to_create_vm_count
        #   @return [::Integer]
        #     [Output Only] Count of VMs that started creating but encountered an error.
        # @!attribute [rw] status
        #   @return [::String]
        #     [Output Only] Creation status of BulkInsert operation - information if the flow is rolling forward or rolling back.
        #     Check the Status enum for the list of possible values.
        # @!attribute [rw] target_vm_count
        #   @return [::Integer]
        #     [Output Only] Count of VMs originally planned to be created.
        class BulkInsertOperationStatus
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # [Output Only] Creation status of BulkInsert operation - information if the flow is rolling forward or rolling back.
          module Status
            # A value indicating that the enum field is not set.
            UNDEFINED_STATUS = 0

            # Rolling forward - creating VMs.
            CREATING = 455_564_985

            # Done
            DONE = 2_104_194

            # Rolling back - cleaning up after an error.
            ROLLING_BACK = 259_411_649

            STATUS_UNSPECIFIED = 42_133_066
          end
        end

        # A request message for RegionDisks.BulkInsert. See the method description for details.
        # @!attribute [rw] bulk_insert_disk_resource_resource
        #   @return [::Google::Cloud::Compute::V1::BulkInsertDiskResource]
        #     The body resource for this request
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     The name of the region for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class BulkInsertRegionDiskRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionInstances.BulkInsert. See the method description for details.
        # @!attribute [rw] bulk_insert_instance_resource_resource
        #   @return [::Google::Cloud::Compute::V1::BulkInsertInstanceResource]
        #     The body resource for this request
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     The name of the region for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class BulkInsertRegionInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Disks.BulkSetLabels. See the method description for details.
        # @!attribute [rw] bulk_zone_set_labels_request_resource
        #   @return [::Google::Cloud::Compute::V1::BulkZoneSetLabelsRequest]
        #     The body resource for this request
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] resource
        #   @return [::String]
        #     Name or id of the resource for this request.
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone for this request.
        class BulkSetLabelsDiskRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] label_fingerprint
        #   @return [::String]
        #     The fingerprint of the previous set of labels for this resource, used to detect conflicts. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You may optionally provide an up-to-date fingerprint hash in order to update or change labels. Make a get() request to the resource to get the latest fingerprint.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     The labels to set for this resource.
        class BulkSetLabelsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # @!attribute [rw] requests
        #   @return [::Array<::Google::Cloud::Compute::V1::BulkSetLabelsRequest>]
        class BulkZoneSetLabelsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] cache_tags
        #   @return [::Array<::String>]
        #     A list of cache tags used to identify cached objects. - Cache tags are specified when the response is first cached, by setting the `Cache-Tag` response header at the origin. - Multiple cache tags in the same invalidation request are treated as Boolean `OR` - for example, `tag1 OR tag2 OR tag3`. - If other fields are also specified, these are treated as Boolean `AND` with any tags. Up to 10 tags can be specified in a single invalidation request.
        # @!attribute [rw] host
        #   @return [::String]
        #     If set, this invalidation rule will only apply to requests with a Host header matching host.
        # @!attribute [rw] path
        #   @return [::String]
        class CacheInvalidationRule
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message containing what to include in the cache key for a request for Cloud CDN.
        # @!attribute [rw] include_host
        #   @return [::Boolean]
        #     If true, requests to different hosts will be cached separately.
        # @!attribute [rw] include_http_headers
        #   @return [::Array<::String>]
        #     Allows HTTP request headers (by name) to be used in the cache key.
        # @!attribute [rw] include_named_cookies
        #   @return [::Array<::String>]
        #     Allows HTTP cookies (by name) to be used in the cache key. The name=value pair will be used in the cache key Cloud CDN generates.
        # @!attribute [rw] include_protocol
        #   @return [::Boolean]
        #     If true, http and https requests will be cached separately.
        # @!attribute [rw] include_query_string
        #   @return [::Boolean]
        #     If true, include query string parameters in the cache key according to query_string_whitelist and query_string_blacklist. If neither is set, the entire query string will be included. If false, the query string will be excluded from the cache key entirely.
        # @!attribute [rw] query_string_blacklist
        #   @return [::Array<::String>]
        #     Names of query string parameters to exclude in cache keys. All other parameters will be included. Either specify query_string_whitelist or query_string_blacklist, not both. '&' and '=' will be percent encoded and not treated as delimiters.
        # @!attribute [rw] query_string_whitelist
        #   @return [::Array<::String>]
        #     Names of query string parameters to include in cache keys. All other parameters will be excluded. Either specify query_string_whitelist or query_string_blacklist, not both. '&' and '=' will be percent encoded and not treated as delimiters.
        class CacheKeyPolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for InstanceGroupManagerResizeRequests.Cancel. See the method description for details.
        # @!attribute [rw] instance_group_manager
        #   @return [::String]
        #     The name of the managed instance group. The name should conform to RFC1035 or be a resource ID.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] resize_request
        #   @return [::String]
        #     The name of the resize request to cancel. The name should conform to RFC1035 or be a resource ID.
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone where the managed instance group is located. The name should conform to RFC1035.
        class CancelInstanceGroupManagerResizeRequestRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Settings controlling the volume of requests, connections and retries to this backend service.
        # @!attribute [rw] max_connections
        #   @return [::Integer]
        #     The maximum number of connections to the backend service. If not specified, there is no limit. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        # @!attribute [rw] max_pending_requests
        #   @return [::Integer]
        #     The maximum number of pending requests allowed to the backend service. If not specified, there is no limit. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        # @!attribute [rw] max_requests
        #   @return [::Integer]
        #     The maximum number of parallel requests that allowed to the backend service. If not specified, there is no limit.
        # @!attribute [rw] max_requests_per_connection
        #   @return [::Integer]
        #     Maximum requests for a single connection to the backend service. This parameter is respected by both the HTTP/1.1 and HTTP/2 implementations. If not specified, there is no limit. Setting this parameter to 1 will effectively disable keep alive. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        # @!attribute [rw] max_retries
        #   @return [::Integer]
        #     The maximum number of parallel retries allowed to the backend cluster. If not specified, the default is 1. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        class CircuitBreakers
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for FirewallPolicies.CloneRules. See the method description for details.
        # @!attribute [rw] firewall_policy
        #   @return [::String]
        #     Name of the firewall policy to update.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] source_firewall_policy
        #   @return [::String]
        #     The firewall policy from which to copy rules.
        class CloneRulesFirewallPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for NetworkFirewallPolicies.CloneRules. See the method description for details.
        # @!attribute [rw] firewall_policy
        #   @return [::String]
        #     Name of the firewall policy to update.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] source_firewall_policy
        #   @return [::String]
        #     The firewall policy from which to copy rules.
        class CloneRulesNetworkFirewallPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionNetworkFirewallPolicies.CloneRules. See the method description for details.
        # @!attribute [rw] firewall_policy
        #   @return [::String]
        #     Name of the firewall policy to update.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] source_firewall_policy
        #   @return [::String]
        #     The firewall policy from which to copy rules.
        class CloneRulesRegionNetworkFirewallPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a regional resource-based commitment resource. Creating this commitment resource means that you are purchasing a resource-based committed use contract, with an explicit start and end time. You can purchase resource-based commitments for both hardware and software resources. For more information, read Resource-based committed use discounts
        # @!attribute [rw] auto_renew
        #   @return [::Boolean]
        #     Specifies whether to automatically renew the commitment at the end of its current term. The default value is false. If you set the field to true, each time your commitment reaches the end of its term, Compute Engine automatically renews it for another term. You can update this field anytime before the commitment expires. For example, if the commitment is set to expire at 12 AM UTC-8 on January 3, 2027, you can update this field until 11:59 PM UTC-8 on January 2, 2027.
        # @!attribute [rw] category
        #   @return [::String]
        #     The category of the commitment; specifies whether the commitment is for hardware or software resources. Category MACHINE specifies that you are committing to hardware machine resources such as VCPU or MEMORY, listed in resources. Category LICENSE specifies that you are committing to software licenses, listed in licenseResources. Note that if you specify MACHINE commitments, then you must also specify a type to indicate the machine series of the hardware resource that you are committing to.
        #     Check the Category enum for the list of possible values.
        # @!attribute [rw] creation_timestamp
        #   @return [::String]
        #     [Output Only] Creation timestamp in RFC3339 text format.
        # @!attribute [rw] custom_end_timestamp
        #   @return [::String]
        #     [Input Only] Optional, specifies the requested commitment end time in RFC3339 text format. Use this option when the desired commitment's end date is later than the start date + term duration.
        # @!attribute [rw] description
        #   @return [::String]
        #     An optional description of the commitment. You can provide this property when you create the resource.
        # @!attribute [rw] end_timestamp
        #   @return [::String]
        #     [Output Only] Commitment end time in RFC3339 text format.
        # @!attribute [rw] existing_reservations
        #   @return [::Array<::String>]
        # @!attribute [rw] id
        #   @return [::Integer]
        #     [Output Only] The unique identifier for the resource. This identifier is defined by the server.
        # @!attribute [rw] kind
        #   @return [::String]
        #     [Output Only] Type of the resource. Always compute#commitment for commitments.
        # @!attribute [rw] license_resource
        #   @return [::Google::Cloud::Compute::V1::LicenseResourceCommitment]
        #     The license specification required as part of a license commitment.
        # @!attribute [rw] merge_source_commitments
        #   @return [::Array<::String>]
        #     The list of source commitments that you are merging to create the new merged commitment. For more information, see Merging commitments.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the commitment. You must specify a name when you purchase the commitment. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        # @!attribute [rw] plan
        #   @return [::String]
        #     The minimum time duration that you commit to purchasing resources. The plan that you choose determines the preset term length of the commitment (which is 1 year or 3 years) and affects the discount rate that you receive for your resources. Committing to a longer time duration typically gives you a higher discount rate. The supported values for this field are TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH (3 years).
        #     Check the Plan enum for the list of possible values.
        # @!attribute [rw] region
        #   @return [::String]
        #     [Output Only] URL of the region where the commitment and committed resources are located.
        # @!attribute [rw] reservations
        #   @return [::Array<::Google::Cloud::Compute::V1::Reservation>]
        #     The list of new reservations that you want to create and attach to this commitment. You must attach reservations to your commitment if your commitment specifies any GPUs or Local SSD disks. For more information, see Attach reservations to resource-based commitments. Specify this property only if you want to create new reservations to attach. To attach existing reservations, specify the existingReservations property instead.
        # @!attribute [rw] resource_status
        #   @return [::Google::Cloud::Compute::V1::CommitmentResourceStatus]
        #     [Output Only] Status information for Commitment resource.
        # @!attribute [rw] resources
        #   @return [::Array<::Google::Cloud::Compute::V1::ResourceCommitment>]
        #     The list of all the hardware resources, with their types and amounts, that you want to commit to. Specify as a separate entry in the list for each individual resource type.
        # @!attribute [rw] self_link
        #   @return [::String]
        #     [Output Only] Server-defined URL for the resource.
        # @!attribute [rw] split_source_commitment
        #   @return [::String]
        #     The source commitment from which you are transferring resources to create the new split commitment. For more information, see Split commitments.
        # @!attribute [rw] start_timestamp
        #   @return [::String]
        #     [Output Only] Commitment start time in RFC3339 text format.
        # @!attribute [rw] status
        #   @return [::String]
        #     [Output Only] Status of the commitment with regards to eventual expiration (each commitment has an end date defined). Status can be one of the following values: NOT_YET_ACTIVE, ACTIVE, or EXPIRED.
        #     Check the Status enum for the list of possible values.
        # @!attribute [rw] status_message
        #   @return [::String]
        #     [Output Only] An optional, human-readable explanation of the status.
        # @!attribute [rw] type
        #   @return [::String]
        #     The type of commitment; specifies the machine series for which you want to commit to purchasing resources. The choice of machine series affects the discount rate and the eligible resource types. The type must be one of the following: ACCELERATOR_OPTIMIZED, ACCELERATOR_OPTIMIZED_A3, ACCELERATOR_OPTIMIZED_A3_MEGA, COMPUTE_OPTIMIZED, COMPUTE_OPTIMIZED_C2D, COMPUTE_OPTIMIZED_C3, COMPUTE_OPTIMIZED_C3D, COMPUTE_OPTIMIZED_H3, GENERAL_PURPOSE, GENERAL_PURPOSE_C4, GENERAL_PURPOSE_E2, GENERAL_PURPOSE_N2, GENERAL_PURPOSE_N2D, GENERAL_PURPOSE_N4, GENERAL_PURPOSE_T2D, GRAPHICS_OPTIMIZED, MEMORY_OPTIMIZED, MEMORY_OPTIMIZED_M3, MEMORY_OPTIMIZED_X4, STORAGE_OPTIMIZED_Z3. For example, type MEMORY_OPTIMIZED specifies a commitment that applies only to eligible resources of memory optimized M1 and M2 machine series. Type GENERAL_PURPOSE specifies a commitment that applies only to eligible resources of general purpose N1 machine series.
        #     Check the Type enum for the list of possible values.
        class Commitment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The category of the commitment; specifies whether the commitment is for hardware or software resources. Category MACHINE specifies that you are committing to hardware machine resources such as VCPU or MEMORY, listed in resources. Category LICENSE specifies that you are committing to software licenses, listed in licenseResources. Note that if you specify MACHINE commitments, then you must also specify a type to indicate the machine series of the hardware resource that you are committing to.
          module Category
            # A value indicating that the enum field is not set.
            UNDEFINED_CATEGORY = 0

            CATEGORY_UNSPECIFIED = 509_189_462

            LICENSE = 347_869_217

            MACHINE = 469_553_191
          end

          # The minimum time duration that you commit to purchasing resources. The plan that you choose determines the preset term length of the commitment (which is 1 year or 3 years) and affects the discount rate that you receive for your resources. Committing to a longer time duration typically gives you a higher discount rate. The supported values for this field are TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH (3 years).
          module Plan
            # A value indicating that the enum field is not set.
            UNDEFINED_PLAN = 0

            INVALID = 530_283_991

            THIRTY_SIX_MONTH = 266_295_942

            TWELVE_MONTH = 173_083_962
          end

          # [Output Only] Status of the commitment with regards to eventual expiration (each commitment has an end date defined). Status can be one of the following values: NOT_YET_ACTIVE, ACTIVE, or EXPIRED.
          module Status
            # A value indicating that the enum field is not set.
            UNDEFINED_STATUS = 0

            ACTIVE = 314_733_318

            # Deprecate CANCELED status. Will use separate status to differentiate cancel by mergeCud or manual cancellation.
            CANCELLED = 41_957_681

            CREATING = 455_564_985

            EXPIRED = 482_489_093

            NOT_YET_ACTIVE = 20_607_337
          end

          # The type of commitment; specifies the machine series for which you want to commit to purchasing resources. The choice of machine series affects the discount rate and the eligible resource types. The type must be one of the following: ACCELERATOR_OPTIMIZED, ACCELERATOR_OPTIMIZED_A3, ACCELERATOR_OPTIMIZED_A3_MEGA, COMPUTE_OPTIMIZED, COMPUTE_OPTIMIZED_C2D, COMPUTE_OPTIMIZED_C3, COMPUTE_OPTIMIZED_C3D, COMPUTE_OPTIMIZED_H3, GENERAL_PURPOSE, GENERAL_PURPOSE_C4, GENERAL_PURPOSE_E2, GENERAL_PURPOSE_N2, GENERAL_PURPOSE_N2D, GENERAL_PURPOSE_N4, GENERAL_PURPOSE_T2D, GRAPHICS_OPTIMIZED, MEMORY_OPTIMIZED, MEMORY_OPTIMIZED_M3, MEMORY_OPTIMIZED_X4, STORAGE_OPTIMIZED_Z3. For example, type MEMORY_OPTIMIZED specifies a commitment that applies only to eligible resources of memory optimized M1 and M2 machine series. Type GENERAL_PURPOSE specifies a commitment that applies only to eligible resources of general purpose N1 machine series.
          module Type
            # A value indicating that the enum field is not set.
            UNDEFINED_TYPE = 0

            ACCELERATOR_OPTIMIZED = 280_848_403

            ACCELERATOR_OPTIMIZED_A3 = 158_574_526

            ACCELERATOR_OPTIMIZED_A3_MEGA = 156_517_459

            ACCELERATOR_OPTIMIZED_A3_ULTRA = 27_812_811

            ACCELERATOR_OPTIMIZED_A4 = 158_574_527

            COMPUTE_OPTIMIZED = 158_349_023

            COMPUTE_OPTIMIZED_C2D = 383_246_453

            COMPUTE_OPTIMIZED_C3 = 428_004_784

            COMPUTE_OPTIMIZED_C3D = 383_246_484

            COMPUTE_OPTIMIZED_H3 = 428_004_939

            COMPUTE_OPTIMIZED_H4D = 383_251_320

            GENERAL_PURPOSE = 299_793_543

            GENERAL_PURPOSE_C4 = 301_911_817

            GENERAL_PURPOSE_C4A = 232_460_888

            GENERAL_PURPOSE_C4D = 232_460_891

            GENERAL_PURPOSE_E2 = 301_911_877

            GENERAL_PURPOSE_N2 = 301_912_156

            GENERAL_PURPOSE_N2D = 232_471_400

            GENERAL_PURPOSE_N4 = 301_912_158

            GENERAL_PURPOSE_T2D = 232_477_166

            GRAPHICS_OPTIMIZED = 68_500_563

            MEMORY_OPTIMIZED = 281_753_417

            MEMORY_OPTIMIZED_M3 = 276_301_372

            MEMORY_OPTIMIZED_M4 = 276_301_373

            MEMORY_OPTIMIZED_M4_6TB = 210_543_650

            MEMORY_OPTIMIZED_X4_16TB = 183_089_120

            MEMORY_OPTIMIZED_X4_24TB = 183_116_989

            MEMORY_OPTIMIZED_X4_32TB = 183_144_858

            STORAGE_OPTIMIZED_Z3 = 316_796_085

            # Note for internal users: When adding a new enum Type for v1, make sure to also add it in the comment for the `optional Type type` definition. This ensures that the public documentation displays the new enum Type.
            TYPE_UNSPECIFIED = 437_714_322
          end
        end

        # @!attribute [rw] id
        #   @return [::String]
        #     [Output Only] Unique identifier for the resource; defined by the server.
        # @!attribute [rw] items
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Compute::V1::CommitmentsScopedList}]
        #     A list of CommitmentsScopedList resources.
        # @!attribute [rw] kind
        #   @return [::String]
        #     [Output Only] Type of resource. Always compute#commitmentAggregatedList for aggregated lists of commitments.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
        # @!attribute [rw] self_link
        #   @return [::String]
        #     [Output Only] Server-defined URL for this resource.
        # @!attribute [rw] unreachables
        #   @return [::Array<::String>]
        #     [Output Only] Unreachable resources.
        # @!attribute [rw] warning
        #   @return [::Google::Cloud::Compute::V1::Warning]
        #     [Output Only] Informational warning message.
        class CommitmentAggregatedList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Compute::V1::CommitmentsScopedList]
          class ItemsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Contains a list of Commitment resources.
        # @!attribute [rw] id
        #   @return [::String]
        #     [Output Only] Unique identifier for the resource; defined by the server.
        # @!attribute [rw] items
        #   @return [::Array<::Google::Cloud::Compute::V1::Commitment>]
        #     A list of Commitment resources.
        # @!attribute [rw] kind
        #   @return [::String]
        #     [Output Only] Type of resource. Always compute#commitmentList for lists of commitments.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
        # @!attribute [rw] self_link
        #   @return [::String]
        #     [Output Only] Server-defined URL for this resource.
        # @!attribute [rw] warning
        #   @return [::Google::Cloud::Compute::V1::Warning]
        #     [Output Only] Informational warning message.
        class CommitmentList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # [Output Only] Contains output only fields.
        # @!attribute [rw] custom_term_eligibility_end_timestamp
        #   @return [::String]
        #     [Output Only] Indicates the end time of customer's eligibility to send custom term requests in RFC3339 text format. Term extension requests that (not the end time in the request) after this time will be rejected.
        class CommitmentResourceStatus
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] commitments
        #   @return [::Array<::Google::Cloud::Compute::V1::Commitment>]
        #     [Output Only] The list of commitments contained in this scope.
        # @!attribute [rw] warning
        #   @return [::Google::Cloud::Compute::V1::Warning]
        #     [Output Only] Informational warning which replaces the list of commitments when the list is empty.
        class CommitmentsScopedList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A set of Confidential Instance options.
        # @!attribute [rw] confidential_instance_type
        #   @return [::String]
        #     Defines the type of technology used by the confidential instance.
        #     Check the ConfidentialInstanceType enum for the list of possible values.
        # @!attribute [rw] enable_confidential_compute
        #   @return [::Boolean]
        #     Defines whether the instance should have confidential compute enabled.
        class ConfidentialInstanceConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Defines the type of technology used by the confidential instance.
          module ConfidentialInstanceType
            # A value indicating that the enum field is not set.
            UNDEFINED_CONFIDENTIAL_INSTANCE_TYPE = 0

            # No type specified. Do not use this value.
            CONFIDENTIAL_INSTANCE_TYPE_UNSPECIFIED = 115_021_829

            # AMD Secure Encrypted Virtualization.
            SEV = 81_988

            # AMD Secure Encrypted Virtualization - Secure Nested Paging.
            SEV_SNP = 21_753_562

            # Intel Trust Domain eXtension.
            TDX = 82_920
          end
        end

        # Message containing connection draining configuration.
        # @!attribute [rw] draining_timeout_sec
        #   @return [::Integer]
        #     Configures a duration timeout for existing requests on a removed backend instance. For supported load balancers and protocols, as described in Enabling connection draining.
        class ConnectionDraining
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # This message defines settings for a consistent hash style load balancer.
        # @!attribute [rw] http_cookie
        #   @return [::Google::Cloud::Compute::V1::ConsistentHashLoadBalancerSettingsHttpCookie]
        #     Hash is based on HTTP Cookie. This field describes a HTTP cookie that will be used as the hash key for the consistent hash load balancer. If the cookie is not present, it will be generated. This field is applicable if the sessionAffinity is set to HTTP_COOKIE. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        # @!attribute [rw] http_header_name
        #   @return [::String]
        #     The hash based on the value of the specified header field. This field is applicable if the sessionAffinity is set to HEADER_FIELD.
        # @!attribute [rw] minimum_ring_size
        #   @return [::Integer]
        #     The minimum number of virtual nodes to use for the hash ring. Defaults to 1024. Larger ring sizes result in more granular load distributions. If the number of hosts in the load balancing pool is larger than the ring size, each host will be assigned a single virtual node.
        class ConsistentHashLoadBalancerSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The information about the HTTP Cookie on which the hash function is based for load balancing policies that use a consistent hash.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the cookie.
        # @!attribute [rw] path
        #   @return [::String]
        #     Path to set for the cookie.
        # @!attribute [rw] ttl
        #   @return [::Google::Cloud::Compute::V1::Duration]
        #     Lifetime of the cookie.
        class ConsistentHashLoadBalancerSettingsHttpCookie
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The specification for allowing client-side cross-origin requests. For more information about the W3C recommendation for cross-origin resource sharing (CORS), see Fetch API Living Standard.
        # @!attribute [rw] allow_credentials
        #   @return [::Boolean]
        #     In response to a preflight request, setting this to true indicates that the actual request can include user credentials. This field translates to the Access-Control-Allow-Credentials header. Default is false.
        # @!attribute [rw] allow_headers
        #   @return [::Array<::String>]
        #     Specifies the content for the Access-Control-Allow-Headers header.
        # @!attribute [rw] allow_methods
        #   @return [::Array<::String>]
        #     Specifies the content for the Access-Control-Allow-Methods header.
        # @!attribute [rw] allow_origin_regexes
        #   @return [::Array<::String>]
        #     Specifies a regular expression that matches allowed origins. For more information, see regular expression syntax . An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes. Regular expressions can only be used when the loadBalancingScheme is set to INTERNAL_SELF_MANAGED.
        # @!attribute [rw] allow_origins
        #   @return [::Array<::String>]
        #     Specifies the list of origins that is allowed to do CORS requests. An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
        # @!attribute [rw] disabled
        #   @return [::Boolean]
        #     If true, disables the CORS policy. The default value is false, which indicates that the CORS policy is in effect.
        # @!attribute [rw] expose_headers
        #   @return [::Array<::String>]
        #     Specifies the content for the Access-Control-Expose-Headers header.
        # @!attribute [rw] max_age
        #   @return [::Integer]
        #     Specifies how long results of a preflight request can be cached in seconds. This field translates to the Access-Control-Max-Age header.
        class CorsPolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for InstanceGroupManagers.CreateInstances. See the method description for details.
        # @!attribute [rw] instance_group_manager
        #   @return [::String]
        #     The name of the managed instance group. It should conform to RFC1035.
        # @!attribute [rw] instance_group_managers_create_instances_request_resource
        #   @return [::Google::Cloud::Compute::V1::InstanceGroupManagersCreateInstancesRequest]
        #     The body resource for this request
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone where the managed instance group is located. It should conform to RFC1035.
        class CreateInstancesInstanceGroupManagerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionInstanceGroupManagers.CreateInstances. See the method description for details.
        # @!attribute [rw] instance_group_manager
        #   @return [::String]
        #     The name of the managed instance group. It should conform to RFC1035.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     The name of the region where the managed instance group is located. It should conform to RFC1035.
        # @!attribute [rw] region_instance_group_managers_create_instances_request_resource
        #   @return [::Google::Cloud::Compute::V1::RegionInstanceGroupManagersCreateInstancesRequest]
        #     The body resource for this request
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class CreateInstancesRegionInstanceGroupManagerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for InterconnectGroups.CreateMembers. See the method description for details.
        # @!attribute [rw] interconnect_group
        #   @return [::String]
        #     Name of the group resource to create members for.
        # @!attribute [rw] interconnect_groups_create_members_request_resource
        #   @return [::Google::Cloud::Compute::V1::InterconnectGroupsCreateMembersRequest]
        #     The body resource for this request
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        class CreateMembersInterconnectGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Disks.CreateSnapshot. See the method description for details.
        # @!attribute [rw] disk
        #   @return [::String]
        #     Name of the persistent disk to snapshot.
        # @!attribute [rw] guest_flush
        #   @return [::Boolean]
        #     [Input Only] Whether to attempt an application consistent snapshot by informing the OS to prepare for the snapshot process.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] snapshot_resource
        #   @return [::Google::Cloud::Compute::V1::Snapshot]
        #     The body resource for this request
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone for this request.
        class CreateSnapshotDiskRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionDisks.CreateSnapshot. See the method description for details.
        # @!attribute [rw] disk
        #   @return [::String]
        #     Name of the regional persistent disk to snapshot.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] snapshot_resource
        #   @return [::Google::Cloud::Compute::V1::Snapshot]
        #     The body resource for this request
        class CreateSnapshotRegionDiskRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Specifies the custom error response policy that must be applied when the backend service or backend bucket responds with an error.
        # @!attribute [rw] error_response_rules
        #   @return [::Array<::Google::Cloud::Compute::V1::CustomErrorResponsePolicyCustomErrorResponseRule>]
        #     Specifies rules for returning error responses. In a given policy, if you specify rules for both a range of error codes as well as rules for specific error codes then rules with specific error codes have a higher priority. For example, assume that you configure a rule for 401 (Un-authorized) code, and another for all 4 series error codes (4XX). If the backend service returns a 401, then the rule for 401 will be applied. However if the backend service returns a 403, the rule for 4xx takes effect.
        # @!attribute [rw] error_service
        #   @return [::String]
        #     The full or partial URL to the BackendBucket resource that contains the custom error content. Examples are: - https://www.googleapis.com/compute/v1/projects/project/global/backendBuckets/myBackendBucket - compute/v1/projects/project/global/backendBuckets/myBackendBucket - global/backendBuckets/myBackendBucket If errorService is not specified at lower levels like pathMatcher, pathRule and routeRule, an errorService specified at a higher level in the UrlMap will be used. If UrlMap.defaultCustomErrorResponsePolicy contains one or more errorResponseRules[], it must specify errorService. If load balancer cannot reach the backendBucket, a simple Not Found Error will be returned, with the original response code (or overrideResponseCode if configured). errorService is not supported for internal or regional HTTP/HTTPS load balancers.
        class CustomErrorResponsePolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Specifies the mapping between the response code that will be returned along with the custom error content and the response code returned by the backend service.
        # @!attribute [rw] match_response_codes
        #   @return [::Array<::String>]
        #     Valid values include: - A number between 400 and 599: For example 401 or 503, in which case the load balancer applies the policy if the error code exactly matches this value. - 5xx: Load Balancer will apply the policy if the backend service responds with any response code in the range of 500 to 599. - 4xx: Load Balancer will apply the policy if the backend service responds with any response code in the range of 400 to 499. Values must be unique within matchResponseCodes and across all errorResponseRules of CustomErrorResponsePolicy.
        # @!attribute [rw] override_response_code
        #   @return [::Integer]
        #     The HTTP status code returned with the response containing the custom error content. If overrideResponseCode is not supplied, the same response code returned by the original backend bucket or backend service is returned to the client.
        # @!attribute [rw] path
        #   @return [::String]
        #     The full path to a file within backendBucket . For example: /errors/defaultError.html path must start with a leading slash. path cannot have trailing slashes. If the file is not available in backendBucket or the load balancer cannot reach the BackendBucket, a simple Not Found Error is returned to the client. The value must be from 1 to 1024 characters
        class CustomErrorResponsePolicyCustomErrorResponseRule
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] kms_key_name
        #   @return [::String]
        #     The name of the encryption key that is stored in Google Cloud KMS. For example: "kmsKeyName": "projects/kms_project_id/locations/region/keyRings/ key_region/cryptoKeys/key The fully-qualifed key name may be returned for resource GET requests. For example: "kmsKeyName": "projects/kms_project_id/locations/region/keyRings/ key_region/cryptoKeys/key /cryptoKeyVersions/1
        # @!attribute [rw] kms_key_service_account
        #   @return [::String]
        #     The service account being used for the encryption request for the given KMS key. If absent, the Compute Engine default service account is used. For example: "kmsKeyServiceAccount": "name@project_id.iam.gserviceaccount.com/
        # @!attribute [rw] raw_key
        #   @return [::String]
        #     Specifies a 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to either encrypt or decrypt this resource. You can provide either the rawKey or the rsaEncryptedKey. For example: "rawKey": "SGVsbG8gZnJvbSBHb29nbGUgQ2xvdWQgUGxhdGZvcm0="
        # @!attribute [rw] rsa_encrypted_key
        #   @return [::String]
        #     Specifies an RFC 4648 base64 encoded, RSA-wrapped 2048-bit customer-supplied encryption key to either encrypt or decrypt this resource. You can provide either the rawKey or the rsaEncryptedKey. For example: "rsaEncryptedKey": "ieCx/NcW06PcT7Ep1X6LUTc/hLvUDYyzSZPPVCVPTVEohpeHASqC8uw5TzyO9U+Fka9JFH z0mBibXUInrC/jEk014kCK/NPjYgEMOyssZ4ZINPKxlUh2zn1bV+MCaTICrdmuSBTWlUUiFoD D6PYznLwh8ZNdaheCeZ8ewEXgFQ8V+sDroLaN3Xs3MDTXQEMMoNUXMCZEIpg9Vtp9x2oe==" The key must meet the following requirements before you can provide it to Compute Engine: 1. The key is wrapped using a RSA public key certificate provided by Google. 2. After being wrapped, the key must be encoded in RFC 4648 base64 encoding. Gets the RSA public key certificate provided by Google at: https://cloud-certs.storage.googleapis.com/google-cloud-csek-ingress.pem
        # @!attribute [rw] sha256
        #   @return [::String]
        #     [Output only] The RFC 4648 base64 encoded SHA-256 hash of the customer-supplied encryption key that protects this resource.
        class CustomerEncryptionKey
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] disk_encryption_key
        #   @return [::Google::Cloud::Compute::V1::CustomerEncryptionKey]
        #     Decrypts data associated with the disk with a customer-supplied encryption key.
        # @!attribute [rw] source
        #   @return [::String]
        #     Specifies a valid partial or full URL to an existing Persistent Disk resource. This field is only applicable for persistent disks. For example: "source": "/compute/v1/projects/project_id/zones/zone/disks/ disk_name
        class CustomerEncryptionKeyProtectedDisk
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] key
        #   @return [::String]
        #     [Output Only] A key that provides more detail on the warning being returned. For example, for warnings where there are no results in a list request for a particular zone, this key might be scope and the key value might be the zone name. Other examples might be a key indicating a deprecated resource and a suggested replacement, or a warning about invalid network settings (for example, if an instance attempts to perform IP forwarding but is not enabled for IP forwarding).
        # @!attribute [rw] value
        #   @return [::String]
        #     [Output Only] A warning data value corresponding to the key.
        class Data
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Instances.DeleteAccessConfig. See the method description for details.
        # @!attribute [rw] access_config
        #   @return [::String]
        #     The name of the access config to delete.
        # @!attribute [rw] instance
        #   @return [::String]
        #     The instance name for this request.
        # @!attribute [rw] network_interface
        #   @return [::String]
        #     The name of the network interface.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone for this request.
        class DeleteAccessConfigInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Addresses.Delete. See the method description for details.
        # @!attribute [rw] address
        #   @return [::String]
        #     Name of the address resource to delete.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DeleteAddressRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Autoscalers.Delete. See the method description for details.
        # @!attribute [rw] autoscaler
        #   @return [::String]
        #     Name of the autoscaler to delete.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] zone
        #   @return [::String]
        #     Name of the zone for this request.
        class DeleteAutoscalerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for BackendBuckets.Delete. See the method description for details.
        # @!attribute [rw] backend_bucket
        #   @return [::String]
        #     Name of the BackendBucket resource to delete.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DeleteBackendBucketRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for BackendServices.Delete. See the method description for details.
        # @!attribute [rw] backend_service
        #   @return [::String]
        #     Name of the BackendService resource to delete.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DeleteBackendServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Disks.Delete. See the method description for details.
        # @!attribute [rw] disk
        #   @return [::String]
        #     Name of the persistent disk to delete.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone for this request.
        class DeleteDiskRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for ExternalVpnGateways.Delete. See the method description for details.
        # @!attribute [rw] external_vpn_gateway
        #   @return [::String]
        #     Name of the externalVpnGateways to delete.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DeleteExternalVpnGatewayRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for FirewallPolicies.Delete. See the method description for details.
        # @!attribute [rw] firewall_policy
        #   @return [::String]
        #     Name of the firewall policy to delete.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DeleteFirewallPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Firewalls.Delete. See the method description for details.
        # @!attribute [rw] firewall
        #   @return [::String]
        #     Name of the firewall rule to delete.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DeleteFirewallRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for ForwardingRules.Delete. See the method description for details.
        # @!attribute [rw] forwarding_rule
        #   @return [::String]
        #     Name of the ForwardingRule resource to delete.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DeleteForwardingRuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for GlobalAddresses.Delete. See the method description for details.
        # @!attribute [rw] address
        #   @return [::String]
        #     Name of the address resource to delete.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DeleteGlobalAddressRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for GlobalForwardingRules.Delete. See the method description for details.
        # @!attribute [rw] forwarding_rule
        #   @return [::String]
        #     Name of the ForwardingRule resource to delete.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DeleteGlobalForwardingRuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for GlobalNetworkEndpointGroups.Delete. See the method description for details.
        # @!attribute [rw] network_endpoint_group
        #   @return [::String]
        #     The name of the network endpoint group to delete. It should comply with RFC1035.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DeleteGlobalNetworkEndpointGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for GlobalOperations.Delete. See the method description for details.
        # @!attribute [rw] operation
        #   @return [::String]
        #     Name of the Operations resource to delete, or its unique numeric identifier.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        class DeleteGlobalOperationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A response message for GlobalOperations.Delete. See the method description for details.
        class DeleteGlobalOperationResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for GlobalOrganizationOperations.Delete. See the method description for details.
        # @!attribute [rw] operation
        #   @return [::String]
        #     Name of the Operations resource to delete, or its unique numeric identifier.
        # @!attribute [rw] parent_id
        #   @return [::String]
        #     Parent ID for this request.
        class DeleteGlobalOrganizationOperationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A response message for GlobalOrganizationOperations.Delete. See the method description for details.
        class DeleteGlobalOrganizationOperationResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for GlobalPublicDelegatedPrefixes.Delete. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] public_delegated_prefix
        #   @return [::String]
        #     Name of the PublicDelegatedPrefix resource to delete.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DeleteGlobalPublicDelegatedPrefixeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for HealthChecks.Delete. See the method description for details.
        # @!attribute [rw] health_check
        #   @return [::String]
        #     Name of the HealthCheck resource to delete.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DeleteHealthCheckRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Images.Delete. See the method description for details.
        # @!attribute [rw] image
        #   @return [::String]
        #     Name of the image resource to delete.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DeleteImageRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for InstanceGroupManagers.Delete. See the method description for details.
        # @!attribute [rw] instance_group_manager
        #   @return [::String]
        #     The name of the managed instance group to delete.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone where the managed instance group is located.
        class DeleteInstanceGroupManagerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for InstanceGroupManagerResizeRequests.Delete. See the method description for details.
        # @!attribute [rw] instance_group_manager
        #   @return [::String]
        #     The name of the managed instance group. The name should conform to RFC1035 or be a resource ID.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] resize_request
        #   @return [::String]
        #     The name of the resize request to delete. The name should conform to RFC1035 or be a resource ID.
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone where the managed instance group is located. The name should conform to RFC1035.
        class DeleteInstanceGroupManagerResizeRequestRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for InstanceGroups.Delete. See the method description for details.
        # @!attribute [rw] instance_group
        #   @return [::String]
        #     The name of the instance group to delete.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone where the instance group is located.
        class DeleteInstanceGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Instances.Delete. See the method description for details.
        # @!attribute [rw] instance
        #   @return [::String]
        #     Name of the instance resource to delete.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone for this request.
        class DeleteInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for InstanceTemplates.Delete. See the method description for details.
        # @!attribute [rw] instance_template
        #   @return [::String]
        #     The name of the instance template to delete.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DeleteInstanceTemplateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for InstanceGroupManagers.DeleteInstances. See the method description for details.
        # @!attribute [rw] instance_group_manager
        #   @return [::String]
        #     The name of the managed instance group.
        # @!attribute [rw] instance_group_managers_delete_instances_request_resource
        #   @return [::Google::Cloud::Compute::V1::InstanceGroupManagersDeleteInstancesRequest]
        #     The body resource for this request
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone where the managed instance group is located.
        class DeleteInstancesInstanceGroupManagerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionInstanceGroupManagers.DeleteInstances. See the method description for details.
        # @!attribute [rw] instance_group_manager
        #   @return [::String]
        #     Name of the managed instance group.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        # @!attribute [rw] region_instance_group_managers_delete_instances_request_resource
        #   @return [::Google::Cloud::Compute::V1::RegionInstanceGroupManagersDeleteInstancesRequest]
        #     The body resource for this request
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DeleteInstancesRegionInstanceGroupManagerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for InstantSnapshots.Delete. See the method description for details.
        # @!attribute [rw] instant_snapshot
        #   @return [::String]
        #     Name of the InstantSnapshot resource to delete.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone for this request.
        class DeleteInstantSnapshotRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for InterconnectAttachmentGroups.Delete. See the method description for details.
        # @!attribute [rw] interconnect_attachment_group
        #   @return [::String]
        #     Name of the InterconnectAttachmentGroup resource to delete.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000). end_interface: MixerMutationRequestBuilder
        class DeleteInterconnectAttachmentGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for InterconnectAttachments.Delete. See the method description for details.
        # @!attribute [rw] interconnect_attachment
        #   @return [::String]
        #     Name of the interconnect attachment to delete.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DeleteInterconnectAttachmentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for InterconnectGroups.Delete. See the method description for details.
        # @!attribute [rw] interconnect_group
        #   @return [::String]
        #     Name of the InterconnectGroup resource to delete.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000). end_interface: MixerMutationRequestBuilder
        class DeleteInterconnectGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Interconnects.Delete. See the method description for details.
        # @!attribute [rw] interconnect
        #   @return [::String]
        #     Name of the interconnect to delete.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DeleteInterconnectRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Licenses.Delete. See the method description for details.
        # @!attribute [rw] license
        #   @return [::String]
        #     Name of the license resource to delete.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DeleteLicenseRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for MachineImages.Delete. See the method description for details.
        # @!attribute [rw] machine_image
        #   @return [::String]
        #     The name of the machine image to delete.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DeleteMachineImageRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for NetworkAttachments.Delete. See the method description for details.
        # @!attribute [rw] network_attachment
        #   @return [::String]
        #     Name of the NetworkAttachment resource to delete.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region of this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000). end_interface: MixerMutationRequestBuilder
        class DeleteNetworkAttachmentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for NetworkEdgeSecurityServices.Delete. See the method description for details.
        # @!attribute [rw] network_edge_security_service
        #   @return [::String]
        #     Name of the network edge security service to delete.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DeleteNetworkEdgeSecurityServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for NetworkEndpointGroups.Delete. See the method description for details.
        # @!attribute [rw] network_endpoint_group
        #   @return [::String]
        #     The name of the network endpoint group to delete. It should comply with RFC1035.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone where the network endpoint group is located. It should comply with RFC1035.
        class DeleteNetworkEndpointGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for NetworkFirewallPolicies.Delete. See the method description for details.
        # @!attribute [rw] firewall_policy
        #   @return [::String]
        #     Name of the firewall policy to delete.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DeleteNetworkFirewallPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Instances.DeleteNetworkInterface. See the method description for details.
        # @!attribute [rw] instance
        #   @return [::String]
        #     The instance name for this request stored as resource_id. Name should conform to RFC1035 or be an unsigned long integer.
        # @!attribute [rw] network_interface_name
        #   @return [::String]
        #     The name of the dynamic network interface to be deleted from the instance.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone for this request.
        class DeleteNetworkInterfaceInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Networks.Delete. See the method description for details.
        # @!attribute [rw] network
        #   @return [::String]
        #     Name of the network to delete.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DeleteNetworkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for NodeGroups.Delete. See the method description for details.
        # @!attribute [rw] node_group
        #   @return [::String]
        #     Name of the NodeGroup resource to delete.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone for this request.
        class DeleteNodeGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for NodeTemplates.Delete. See the method description for details.
        # @!attribute [rw] node_template
        #   @return [::String]
        #     Name of the NodeTemplate resource to delete.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     The name of the region for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DeleteNodeTemplateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for NodeGroups.DeleteNodes. See the method description for details.
        # @!attribute [rw] node_group
        #   @return [::String]
        #     Name of the NodeGroup resource whose nodes will be deleted.
        # @!attribute [rw] node_groups_delete_nodes_request_resource
        #   @return [::Google::Cloud::Compute::V1::NodeGroupsDeleteNodesRequest]
        #     The body resource for this request
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone for this request.
        class DeleteNodesNodeGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for PacketMirrorings.Delete. See the method description for details.
        # @!attribute [rw] packet_mirroring
        #   @return [::String]
        #     Name of the PacketMirroring resource to delete.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DeletePacketMirroringRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for InstanceGroupManagers.DeletePerInstanceConfigs. See the method description for details.
        # @!attribute [rw] instance_group_manager
        #   @return [::String]
        #     The name of the managed instance group. It should conform to RFC1035.
        # @!attribute [rw] instance_group_managers_delete_per_instance_configs_req_resource
        #   @return [::Google::Cloud::Compute::V1::InstanceGroupManagersDeletePerInstanceConfigsReq]
        #     The body resource for this request
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone where the managed instance group is located. It should conform to RFC1035.
        class DeletePerInstanceConfigsInstanceGroupManagerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionInstanceGroupManagers.DeletePerInstanceConfigs. See the method description for details.
        # @!attribute [rw] instance_group_manager
        #   @return [::String]
        #     The name of the managed instance group. It should conform to RFC1035.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request, should conform to RFC1035.
        # @!attribute [rw] region_instance_group_manager_delete_instance_config_req_resource
        #   @return [::Google::Cloud::Compute::V1::RegionInstanceGroupManagerDeleteInstanceConfigReq]
        #     The body resource for this request
        class DeletePerInstanceConfigsRegionInstanceGroupManagerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for PublicAdvertisedPrefixes.Delete. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] public_advertised_prefix
        #   @return [::String]
        #     Name of the PublicAdvertisedPrefix resource to delete.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DeletePublicAdvertisedPrefixeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for PublicDelegatedPrefixes.Delete. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] public_delegated_prefix
        #   @return [::String]
        #     Name of the PublicDelegatedPrefix resource to delete.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region of this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DeletePublicDelegatedPrefixeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionAutoscalers.Delete. See the method description for details.
        # @!attribute [rw] autoscaler
        #   @return [::String]
        #     Name of the autoscaler to delete.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DeleteRegionAutoscalerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionBackendServices.Delete. See the method description for details.
        # @!attribute [rw] backend_service
        #   @return [::String]
        #     Name of the BackendService resource to delete.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DeleteRegionBackendServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionDisks.Delete. See the method description for details.
        # @!attribute [rw] disk
        #   @return [::String]
        #     Name of the regional persistent disk to delete.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DeleteRegionDiskRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionHealthChecks.Delete. See the method description for details.
        # @!attribute [rw] health_check
        #   @return [::String]
        #     Name of the HealthCheck resource to delete.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DeleteRegionHealthCheckRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionHealthCheckServices.Delete. See the method description for details.
        # @!attribute [rw] health_check_service
        #   @return [::String]
        #     Name of the HealthCheckService to delete. The name must be 1-63 characters long, and comply with RFC1035.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DeleteRegionHealthCheckServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionInstanceGroupManagers.Delete. See the method description for details.
        # @!attribute [rw] instance_group_manager
        #   @return [::String]
        #     Name of the managed instance group to delete.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DeleteRegionInstanceGroupManagerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionInstanceTemplates.Delete. See the method description for details.
        # @!attribute [rw] instance_template
        #   @return [::String]
        #     The name of the instance template to delete.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     The name of the region for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DeleteRegionInstanceTemplateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionInstantSnapshots.Delete. See the method description for details.
        # @!attribute [rw] instant_snapshot
        #   @return [::String]
        #     Name of the InstantSnapshot resource to delete.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     The name of the region for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DeleteRegionInstantSnapshotRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionNetworkEndpointGroups.Delete. See the method description for details.
        # @!attribute [rw] network_endpoint_group
        #   @return [::String]
        #     The name of the network endpoint group to delete. It should comply with RFC1035.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     The name of the region where the network endpoint group is located. It should comply with RFC1035.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DeleteRegionNetworkEndpointGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionNetworkFirewallPolicies.Delete. See the method description for details.
        # @!attribute [rw] firewall_policy
        #   @return [::String]
        #     Name of the firewall policy to delete.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DeleteRegionNetworkFirewallPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionNotificationEndpoints.Delete. See the method description for details.
        # @!attribute [rw] notification_endpoint
        #   @return [::String]
        #     Name of the NotificationEndpoint resource to delete.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DeleteRegionNotificationEndpointRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionOperations.Delete. See the method description for details.
        # @!attribute [rw] operation
        #   @return [::String]
        #     Name of the Operations resource to delete, or its unique numeric identifier.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region for this request.
        class DeleteRegionOperationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A response message for RegionOperations.Delete. See the method description for details.
        class DeleteRegionOperationResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionSecurityPolicies.Delete. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] security_policy
        #   @return [::String]
        #     Name of the security policy to delete.
        class DeleteRegionSecurityPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionSslCertificates.Delete. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] ssl_certificate
        #   @return [::String]
        #     Name of the SslCertificate resource to delete.
        class DeleteRegionSslCertificateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionSslPolicies.Delete. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] ssl_policy
        #   @return [::String]
        #     Name of the SSL policy to delete. The name must be 1-63 characters long, and comply with RFC1035.
        class DeleteRegionSslPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionTargetHttpProxies.Delete. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] target_http_proxy
        #   @return [::String]
        #     Name of the TargetHttpProxy resource to delete.
        class DeleteRegionTargetHttpProxyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionTargetHttpsProxies.Delete. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] target_https_proxy
        #   @return [::String]
        #     Name of the TargetHttpsProxy resource to delete.
        class DeleteRegionTargetHttpsProxyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionTargetTcpProxies.Delete. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] target_tcp_proxy
        #   @return [::String]
        #     Name of the TargetTcpProxy resource to delete.
        class DeleteRegionTargetTcpProxyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionUrlMaps.Delete. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     begin_interface: MixerMutationRequestBuilder Request ID to support idempotency.
        # @!attribute [rw] url_map
        #   @return [::String]
        #     Name of the UrlMap resource to delete.
        class DeleteRegionUrlMapRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Reservations.Delete. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] reservation
        #   @return [::String]
        #     Name of the reservation to delete.
        # @!attribute [rw] zone
        #   @return [::String]
        #     Name of the zone for this request.
        class DeleteReservationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for ResourcePolicies.Delete. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] resource_policy
        #   @return [::String]
        #     Name of the resource policy to delete.
        class DeleteResourcePolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Routers.DeleteRoutePolicy. See the method description for details.
        # @!attribute [rw] policy
        #   @return [::String]
        #     The Policy name for this request. Name must conform to RFC1035
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] router
        #   @return [::String]
        #     Name of the Router resource where Route Policy is defined.
        class DeleteRoutePolicyRouterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Routes.Delete. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] route
        #   @return [::String]
        #     Name of the Route resource to delete.
        class DeleteRouteRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Routers.Delete. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] router
        #   @return [::String]
        #     Name of the Router resource to delete.
        class DeleteRouterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for SecurityPolicies.Delete. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] security_policy
        #   @return [::String]
        #     Name of the security policy to delete.
        class DeleteSecurityPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for ServiceAttachments.Delete. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region of this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] service_attachment
        #   @return [::String]
        #     Name of the ServiceAttachment resource to delete.
        class DeleteServiceAttachmentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for BackendBuckets.DeleteSignedUrlKey. See the method description for details.
        # @!attribute [rw] backend_bucket
        #   @return [::String]
        #     Name of the BackendBucket resource to which the Signed URL Key should be added. The name should conform to RFC1035.
        # @!attribute [rw] key_name
        #   @return [::String]
        #     The name of the Signed URL Key to delete.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DeleteSignedUrlKeyBackendBucketRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for BackendServices.DeleteSignedUrlKey. See the method description for details.
        # @!attribute [rw] backend_service
        #   @return [::String]
        #     Name of the BackendService resource to which the Signed URL Key should be added. The name should conform to RFC1035.
        # @!attribute [rw] key_name
        #   @return [::String]
        #     The name of the Signed URL Key to delete.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DeleteSignedUrlKeyBackendServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Snapshots.Delete. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] snapshot
        #   @return [::String]
        #     Name of the Snapshot resource to delete.
        class DeleteSnapshotRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for SslCertificates.Delete. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] ssl_certificate
        #   @return [::String]
        #     Name of the SslCertificate resource to delete.
        class DeleteSslCertificateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for SslPolicies.Delete. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] ssl_policy
        #   @return [::String]
        #     Name of the SSL policy to delete. The name must be 1-63 characters long, and comply with RFC1035.
        class DeleteSslPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for StoragePools.Delete. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] storage_pool
        #   @return [::String]
        #     Name of the storage pool to delete.
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone for this request.
        class DeleteStoragePoolRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Subnetworks.Delete. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] subnetwork
        #   @return [::String]
        #     Name of the Subnetwork resource to delete.
        class DeleteSubnetworkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for TargetGrpcProxies.Delete. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] target_grpc_proxy
        #   @return [::String]
        #     Name of the TargetGrpcProxy resource to delete.
        class DeleteTargetGrpcProxyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for TargetHttpProxies.Delete. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] target_http_proxy
        #   @return [::String]
        #     Name of the TargetHttpProxy resource to delete.
        class DeleteTargetHttpProxyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for TargetHttpsProxies.Delete. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] target_https_proxy
        #   @return [::String]
        #     Name of the TargetHttpsProxy resource to delete.
        class DeleteTargetHttpsProxyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for TargetInstances.Delete. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] target_instance
        #   @return [::String]
        #     Name of the TargetInstance resource to delete.
        # @!attribute [rw] zone
        #   @return [::String]
        #     Name of the zone scoping this request.
        class DeleteTargetInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for TargetPools.Delete. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] target_pool
        #   @return [::String]
        #     Name of the TargetPool resource to delete.
        class DeleteTargetPoolRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for TargetSslProxies.Delete. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] target_ssl_proxy
        #   @return [::String]
        #     Name of the TargetSslProxy resource to delete.
        class DeleteTargetSslProxyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for TargetTcpProxies.Delete. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] target_tcp_proxy
        #   @return [::String]
        #     Name of the TargetTcpProxy resource to delete.
        class DeleteTargetTcpProxyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for TargetVpnGateways.Delete. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] target_vpn_gateway
        #   @return [::String]
        #     Name of the target VPN gateway to delete.
        class DeleteTargetVpnGatewayRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for UrlMaps.Delete. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] url_map
        #   @return [::String]
        #     Name of the UrlMap resource to delete.
        class DeleteUrlMapRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for VpnGateways.Delete. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] vpn_gateway
        #   @return [::String]
        #     Name of the VPN gateway to delete.
        class DeleteVpnGatewayRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for VpnTunnels.Delete. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] vpn_tunnel
        #   @return [::String]
        #     Name of the VpnTunnel resource to delete.
        class DeleteVpnTunnelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for ZoneOperations.Delete. See the method description for details.
        # @!attribute [rw] operation
        #   @return [::String]
        #     Name of the Operations resource to delete, or its unique numeric identifier.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] zone
        #   @return [::String]
        #     Name of the zone for this request.
        class DeleteZoneOperationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A response message for ZoneOperations.Delete. See the method description for details.
        class DeleteZoneOperationResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] I_p_protocol
        #   @return [::String]
        #     The IP protocol to which this rule applies. The protocol type is required when creating a firewall rule. This value can either be one of the following well known protocol strings (tcp, udp, icmp, esp, ah, ipip, sctp) or the IP protocol number.
        # @!attribute [rw] ports
        #   @return [::Array<::String>]
        #     An optional list of ports to which this rule applies. This field is only applicable for the UDP or TCP protocol. Each entry must be either an integer or a range. If not specified, this rule applies to connections through any port. Example inputs include: ["22"], ["80","443"], and ["12345-12349"].
        class Denied
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Images.Deprecate. See the method description for details.
        # @!attribute [rw] deprecation_status_resource
        #   @return [::Google::Cloud::Compute::V1::DeprecationStatus]
        #     The body resource for this request
        # @!attribute [rw] image
        #   @return [::String]
        #     Image name.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DeprecateImageRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Deprecation status for a public resource.
        # @!attribute [rw] deleted
        #   @return [::String]
        #     An optional RFC3339 timestamp on or after which the state of this resource is intended to change to DELETED. This is only informational and the status will not change unless the client explicitly changes it.
        # @!attribute [rw] deprecated
        #   @return [::String]
        #     An optional RFC3339 timestamp on or after which the state of this resource is intended to change to DEPRECATED. This is only informational and the status will not change unless the client explicitly changes it.
        # @!attribute [rw] obsolete
        #   @return [::String]
        #     An optional RFC3339 timestamp on or after which the state of this resource is intended to change to OBSOLETE. This is only informational and the status will not change unless the client explicitly changes it.
        # @!attribute [rw] replacement
        #   @return [::String]
        #     The URL of the suggested replacement for a deprecated resource. The suggested replacement resource must be the same kind of resource as the deprecated resource.
        # @!attribute [rw] state
        #   @return [::String]
        #     The deprecation state of this resource. This can be ACTIVE, DEPRECATED, OBSOLETE, or DELETED. Operations which communicate the end of life date for an image, can use ACTIVE. Operations which create a new resource using a DEPRECATED resource will return successfully, but with a warning indicating the deprecated resource and recommending its replacement. Operations which use OBSOLETE or DELETED resources will be rejected and result in an error.
        #     Check the State enum for the list of possible values.
        class DeprecationStatus
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The deprecation state of this resource. This can be ACTIVE, DEPRECATED, OBSOLETE, or DELETED. Operations which communicate the end of life date for an image, can use ACTIVE. Operations which create a new resource using a DEPRECATED resource will return successfully, but with a warning indicating the deprecated resource and recommending its replacement. Operations which use OBSOLETE or DELETED resources will be rejected and result in an error.
          module State
            # A value indicating that the enum field is not set.
            UNDEFINED_STATE = 0

            ACTIVE = 314_733_318

            DELETED = 120_962_041

            DEPRECATED = 463_360_435

            OBSOLETE = 66_532_761
          end
        end

        # A request message for Instances.DetachDisk. See the method description for details.
        # @!attribute [rw] device_name
        #   @return [::String]
        #     The device name of the disk to detach. Make a get() request on the instance to view currently attached disks and device names.
        # @!attribute [rw] instance
        #   @return [::String]
        #     Instance name for this request.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone for this request.
        class DetachDiskInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for GlobalNetworkEndpointGroups.DetachNetworkEndpoints. See the method description for details.
        # @!attribute [rw] global_network_endpoint_groups_detach_endpoints_request_resource
        #   @return [::Google::Cloud::Compute::V1::GlobalNetworkEndpointGroupsDetachEndpointsRequest]
        #     The body resource for this request
        # @!attribute [rw] network_endpoint_group
        #   @return [::String]
        #     The name of the network endpoint group where you are removing network endpoints. It should comply with RFC1035.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DetachNetworkEndpointsGlobalNetworkEndpointGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for NetworkEndpointGroups.DetachNetworkEndpoints. See the method description for details.
        # @!attribute [rw] network_endpoint_group
        #   @return [::String]
        #     The name of the network endpoint group where you are removing network endpoints. It should comply with RFC1035.
        # @!attribute [rw] network_endpoint_groups_detach_endpoints_request_resource
        #   @return [::Google::Cloud::Compute::V1::NetworkEndpointGroupsDetachEndpointsRequest]
        #     The body resource for this request
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone where the network endpoint group is located. It should comply with RFC1035.
        class DetachNetworkEndpointsNetworkEndpointGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionNetworkEndpointGroups.DetachNetworkEndpoints. See the method description for details.
        # @!attribute [rw] network_endpoint_group
        #   @return [::String]
        #     The name of the network endpoint group you are detaching network endpoints from. It should comply with RFC1035.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     The name of the region where the network endpoint group is located. It should comply with RFC1035.
        # @!attribute [rw] region_network_endpoint_groups_detach_endpoints_request_resource
        #   @return [::Google::Cloud::Compute::V1::RegionNetworkEndpointGroupsDetachEndpointsRequest]
        #     The body resource for this request
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000). end_interface: MixerMutationRequestBuilder
        class DetachNetworkEndpointsRegionNetworkEndpointGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Projects.DisableXpnHost. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DisableXpnHostProjectRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Projects.DisableXpnResource. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] projects_disable_xpn_resource_request_resource
        #   @return [::Google::Cloud::Compute::V1::ProjectsDisableXpnResourceRequest]
        #     The body resource for this request
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class DisableXpnResourceProjectRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a Persistent Disk resource. Google Compute Engine has two Disk resources: * [Zonal](/compute/docs/reference/rest/v1/disks) * [Regional](/compute/docs/reference/rest/v1/regionDisks) Persistent disks are required for running your VM instances. Create both boot and non-boot (data) persistent disks. For more information, read Persistent Disks. For more storage options, read Storage options. The disks resource represents a zonal persistent disk. For more information, read Zonal persistent disks. The regionDisks resource represents a regional persistent disk. For more information, read Regional resources.
        # @!attribute [rw] access_mode
        #   @return [::String]
        #     The access mode of the disk. - READ_WRITE_SINGLE: The default AccessMode, means the disk can be attached to single instance in RW mode. - READ_WRITE_MANY: The AccessMode means the disk can be attached to multiple instances in RW mode. - READ_ONLY_MANY: The AccessMode means the disk can be attached to multiple instances in RO mode. The AccessMode is only valid for Hyperdisk disk types.
        #     Check the AccessMode enum for the list of possible values.
        # @!attribute [rw] architecture
        #   @return [::String]
        #     The architecture of the disk. Valid values are ARM64 or X86_64.
        #     Check the Architecture enum for the list of possible values.
        # @!attribute [rw] async_primary_disk
        #   @return [::Google::Cloud::Compute::V1::DiskAsyncReplication]
        #     Disk asynchronously replicated into this disk.
        # @!attribute [rw] async_secondary_disks
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Compute::V1::DiskAsyncReplicationList}]
        #     [Output Only] A list of disks this disk is asynchronously replicated to.
        # @!attribute [rw] creation_timestamp
        #   @return [::String]
        #     [Output Only] Creation timestamp in RFC3339 text format.
        # @!attribute [rw] description
        #   @return [::String]
        #     An optional description of this resource. Provide this property when you create the resource.
        # @!attribute [rw] disk_encryption_key
        #   @return [::Google::Cloud::Compute::V1::CustomerEncryptionKey]
        #     Encrypts the disk using a customer-supplied encryption key or a customer-managed encryption key. Encryption keys do not protect access to metadata of the disk. After you encrypt a disk with a customer-supplied key, you must provide the same key if you use the disk later. For example, to create a disk snapshot, to create a disk image, to create a machine image, or to attach the disk to a virtual machine. After you encrypt a disk with a customer-managed key, the diskEncryptionKey.kmsKeyName is set to a key *version* name once the disk is created. The disk is encrypted with this version of the key. In the response, diskEncryptionKey.kmsKeyName appears in the following format: "diskEncryptionKey.kmsKeyName": "projects/kms_project_id/locations/region/keyRings/ key_region/cryptoKeys/key /cryptoKeysVersions/version If you do not provide an encryption key when creating the disk, then the disk is encrypted using an automatically generated key and you don't need to provide a key to use the disk later.
        # @!attribute [rw] enable_confidential_compute
        #   @return [::Boolean]
        #     Whether this disk is using confidential compute mode.
        # @!attribute [rw] guest_os_features
        #   @return [::Array<::Google::Cloud::Compute::V1::GuestOsFeature>]
        #     A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
        # @!attribute [rw] id
        #   @return [::Integer]
        #     [Output Only] The unique identifier for the resource. This identifier is defined by the server.
        # @!attribute [rw] kind
        #   @return [::String]
        #     [Output Only] Type of the resource. Always compute#disk for disks.
        # @!attribute [rw] label_fingerprint
        #   @return [::String]
        #     A fingerprint for the labels being applied to this disk, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a disk.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels to apply to this disk. These can be later modified by the setLabels method.
        # @!attribute [rw] last_attach_timestamp
        #   @return [::String]
        #     [Output Only] Last attach timestamp in RFC3339 text format.
        # @!attribute [rw] last_detach_timestamp
        #   @return [::String]
        #     [Output Only] Last detach timestamp in RFC3339 text format.
        # @!attribute [rw] license_codes
        #   @return [::Array<::Integer>]
        #     Integer license codes indicating which licenses are attached to this disk.
        # @!attribute [rw] licenses
        #   @return [::Array<::String>]
        #     A list of publicly visible licenses. Reserved for Google's use.
        # @!attribute [rw] location_hint
        #   @return [::String]
        #     An opaque location hint used to place the disk close to other resources. This field is for use by internal tools that use the public API.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        # @!attribute [rw] options
        #   @return [::String]
        #     Internal use only.
        # @!attribute [rw] params
        #   @return [::Google::Cloud::Compute::V1::DiskParams]
        #     Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
        # @!attribute [rw] physical_block_size_bytes
        #   @return [::Integer]
        #     Physical block size of the persistent disk, in bytes. If not present in a request, a default value is used. The currently supported size is 4096, other sizes may be added in the future. If an unsupported value is requested, the error message will list the supported values for the caller's project.
        # @!attribute [rw] provisioned_iops
        #   @return [::Integer]
        #     Indicates how many IOPS to provision for the disk. This sets the number of I/O operations per second that the disk can handle. Values must be between 10,000 and 120,000. For more details, see the Extreme persistent disk documentation.
        # @!attribute [rw] provisioned_throughput
        #   @return [::Integer]
        #     Indicates how much throughput to provision for the disk. This sets the number of throughput mb per second that the disk can handle. Values must be greater than or equal to 1.
        # @!attribute [rw] region
        #   @return [::String]
        #     [Output Only] URL of the region where the disk resides. Only applicable for regional resources. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
        # @!attribute [rw] replica_zones
        #   @return [::Array<::String>]
        #     URLs of the zones where the disk should be replicated to. Only applicable for regional resources.
        # @!attribute [rw] resource_policies
        #   @return [::Array<::String>]
        #     Resource policies applied to this disk for automatic snapshot creations.
        # @!attribute [rw] resource_status
        #   @return [::Google::Cloud::Compute::V1::DiskResourceStatus]
        #     [Output Only] Status information for the disk resource.
        # @!attribute [rw] satisfies_pzi
        #   @return [::Boolean]
        #     Output only. Reserved for future use.
        # @!attribute [rw] satisfies_pzs
        #   @return [::Boolean]
        #     [Output Only] Reserved for future use.
        # @!attribute [rw] self_link
        #   @return [::String]
        #     [Output Only] Server-defined fully-qualified URL for this resource.
        # @!attribute [rw] size_gb
        #   @return [::Integer]
        #     Size, in GB, of the persistent disk. You can specify this field when creating a persistent disk using the sourceImage, sourceSnapshot, or sourceDisk parameter, or specify it alone to create an empty persistent disk. If you specify this field along with a source, the value of sizeGb must not be less than the size of the source. Acceptable values are greater than 0.
        # @!attribute [rw] source_consistency_group_policy
        #   @return [::String]
        #     [Output Only] URL of the DiskConsistencyGroupPolicy for a secondary disk that was created using a consistency group.
        # @!attribute [rw] source_consistency_group_policy_id
        #   @return [::String]
        #     [Output Only] ID of the DiskConsistencyGroupPolicy for a secondary disk that was created using a consistency group.
        # @!attribute [rw] source_disk
        #   @return [::String]
        #     The source disk used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /disks/disk - https://www.googleapis.com/compute/v1/projects/project/regions/region /disks/disk - projects/project/zones/zone/disks/disk - projects/project/regions/region/disks/disk - zones/zone/disks/disk - regions/region/disks/disk
        # @!attribute [rw] source_disk_id
        #   @return [::String]
        #     [Output Only] The unique ID of the disk used to create this disk. This value identifies the exact disk that was used to create this persistent disk. For example, if you created the persistent disk from a disk that was later deleted and recreated under the same name, the source disk ID would identify the exact version of the disk that was used.
        # @!attribute [rw] source_image
        #   @return [::String]
        #     The source image used to create this disk. If the source image is deleted, this field will not be set. To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image: projects/debian-cloud/global/images/family/debian-9 Alternatively, use a specific version of a public operating system image: projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD To create a disk with a custom image that you created, specify the image name in the following format: global/images/my-custom-image You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name: global/images/family/my-image-family
        # @!attribute [rw] source_image_encryption_key
        #   @return [::Google::Cloud::Compute::V1::CustomerEncryptionKey]
        #     The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key.
        # @!attribute [rw] source_image_id
        #   @return [::String]
        #     [Output Only] The ID value of the image used to create this disk. This value identifies the exact image that was used to create this persistent disk. For example, if you created the persistent disk from an image that was later deleted and recreated under the same name, the source image ID would identify the exact version of the image that was used.
        # @!attribute [rw] source_instant_snapshot
        #   @return [::String]
        #     The source instant snapshot used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instantSnapshots/instantSnapshot - projects/project/zones/zone/instantSnapshots/instantSnapshot - zones/zone/instantSnapshots/instantSnapshot
        # @!attribute [rw] source_instant_snapshot_id
        #   @return [::String]
        #     [Output Only] The unique ID of the instant snapshot used to create this disk. This value identifies the exact instant snapshot that was used to create this persistent disk. For example, if you created the persistent disk from an instant snapshot that was later deleted and recreated under the same name, the source instant snapshot ID would identify the exact version of the instant snapshot that was used.
        # @!attribute [rw] source_snapshot
        #   @return [::String]
        #     The source snapshot used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project /global/snapshots/snapshot - projects/project/global/snapshots/snapshot - global/snapshots/snapshot
        # @!attribute [rw] source_snapshot_encryption_key
        #   @return [::Google::Cloud::Compute::V1::CustomerEncryptionKey]
        #     The customer-supplied encryption key of the source snapshot. Required if the source snapshot is protected by a customer-supplied encryption key.
        # @!attribute [rw] source_snapshot_id
        #   @return [::String]
        #     [Output Only] The unique ID of the snapshot used to create this disk. This value identifies the exact snapshot that was used to create this persistent disk. For example, if you created the persistent disk from a snapshot that was later deleted and recreated under the same name, the source snapshot ID would identify the exact version of the snapshot that was used.
        # @!attribute [rw] source_storage_object
        #   @return [::String]
        #     The full Google Cloud Storage URI where the disk image is stored. This file must be a gzip-compressed tarball whose name ends in .tar.gz or virtual machine disk whose name ends in vmdk. Valid URIs may start with gs:// or https://storage.googleapis.com/. This flag is not optimized for creating multiple disks from a source storage object. To create many disks from a source storage object, use gcloud compute images import instead.
        # @!attribute [rw] status
        #   @return [::String]
        #     [Output Only] The status of disk creation. - CREATING: Disk is provisioning. - RESTORING: Source data is being copied into the disk. - FAILED: Disk creation failed. - READY: Disk is ready for use. - DELETING: Disk is deleting.
        #     Check the Status enum for the list of possible values.
        # @!attribute [rw] storage_pool
        #   @return [::String]
        #     The storage pool in which the new disk is created. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /storagePools/storagePool - projects/project/zones/zone/storagePools/storagePool - zones/zone/storagePools/storagePool
        # @!attribute [rw] type
        #   @return [::String]
        #     URL of the disk type resource describing which disk type to use to create the disk. Provide this when creating the disk. For example: projects/project /zones/zone/diskTypes/pd-ssd . See Persistent disk types.
        # @!attribute [rw] users
        #   @return [::Array<::String>]
        #     [Output Only] Links to the users of the disk (attached instances) in form: projects/project/zones/zone/instances/instance
        # @!attribute [rw] zone
        #   @return [::String]
        #     [Output Only] URL of the zone where the disk resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
        class Disk
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Compute::V1::DiskAsyncReplicationList]
          class AsyncSecondaryDisksEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The access mode of the disk. - READ_WRITE_SINGLE: The default AccessMode, means the disk can be attached to single instance in RW mode. - READ_WRITE_MANY: The AccessMode means the disk can be attached to multiple instances in RW mode. - READ_ONLY_MANY: The AccessMode means the disk can be attached to multiple instances in RO mode. The AccessMode is only valid for Hyperdisk disk types.
          module AccessMode
            # A value indicating that the enum field is not set.
            UNDEFINED_ACCESS_MODE = 0

            # The AccessMode means the disk can be attached to multiple instances in RO mode.
            READ_ONLY_MANY = 63_460_265

            # The AccessMode means the disk can be attached to multiple instances in RW mode.
            READ_WRITE_MANY = 488_743_208

            # The default AccessMode, means the disk can be attached to single instance in RW mode.
            READ_WRITE_SINGLE = 99_323_089
          end

          # The architecture of the disk. Valid values are ARM64 or X86_64.
          module Architecture
            # A value indicating that the enum field is not set.
            UNDEFINED_ARCHITECTURE = 0

            # Default value indicating Architecture is not set.
            ARCHITECTURE_UNSPECIFIED = 394_750_507

            # Machines with architecture ARM64
            ARM64 = 62_547_450

            # Machines with architecture X86_64
            X86_64 = 425_300_551
          end

          # [Output Only] The status of disk creation. - CREATING: Disk is provisioning. - RESTORING: Source data is being copied into the disk. - FAILED: Disk creation failed. - READY: Disk is ready for use. - DELETING: Disk is deleting.
          module Status
            # A value indicating that the enum field is not set.
            UNDEFINED_STATUS = 0

            # Disk is provisioning
            CREATING = 455_564_985

            # Disk is deleting.
            DELETING = 528_602_024

            # Disk creation failed.
            FAILED = 455_706_685

            # Disk is ready for use.
            READY = 77_848_963

            # Source data is being copied into the disk.
            RESTORING = 404_263_851

            # Disk is currently unavailable and cannot be accessed, attached or detached.
            UNAVAILABLE = 413_756_464
          end
        end

        # @!attribute [rw] id
        #   @return [::String]
        #     [Output Only] Unique identifier for the resource; defined by the server.
        # @!attribute [rw] items
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Compute::V1::DisksScopedList}]
        #     A list of DisksScopedList resources.
        # @!attribute [rw] kind
        #   @return [::String]
        #     [Output Only] Type of resource. Always compute#diskAggregatedList for aggregated lists of persistent disks.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
        # @!attribute [rw] self_link
        #   @return [::String]
        #     [Output Only] Server-defined URL for this resource.
        # @!attribute [rw] unreachables
        #   @return [::Array<::String>]
        #     [Output Only] Unreachable resources.
        # @!attribute [rw] warning
        #   @return [::Google::Cloud::Compute::V1::Warning]
        #     [Output Only] Informational warning message.
        class DiskAggregatedList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Compute::V1::DisksScopedList]
          class ItemsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # @!attribute [rw] consistency_group_policy
        #   @return [::String]
        #     [Output Only] URL of the DiskConsistencyGroupPolicy if replication was started on the disk as a member of a group.
        # @!attribute [rw] consistency_group_policy_id
        #   @return [::String]
        #     [Output Only] ID of the DiskConsistencyGroupPolicy if replication was started on the disk as a member of a group.
        # @!attribute [rw] disk
        #   @return [::String]
        #     The other disk asynchronously replicated to or from the current disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /disks/disk - projects/project/zones/zone/disks/disk - zones/zone/disks/disk
        # @!attribute [rw] disk_id
        #   @return [::String]
        #     [Output Only] The unique ID of the other disk asynchronously replicated to or from the current disk. This value identifies the exact disk that was used to create this replication. For example, if you started replicating the persistent disk from a disk that was later deleted and recreated under the same name, the disk ID would identify the exact version of the disk that was used.
        class DiskAsyncReplication
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] async_replication_disk
        #   @return [::Google::Cloud::Compute::V1::DiskAsyncReplication]
        class DiskAsyncReplicationList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A specification of the desired way to instantiate a disk in the instance template when its created from a source instance.
        # @!attribute [rw] auto_delete
        #   @return [::Boolean]
        #     Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
        # @!attribute [rw] custom_image
        #   @return [::String]
        #     The custom source image to be used to restore this disk when instantiating this instance template.
        # @!attribute [rw] device_name
        #   @return [::String]
        #     Specifies the device name of the disk to which the configurations apply to.
        # @!attribute [rw] instantiate_from
        #   @return [::String]
        #     Specifies whether to include the disk and what image to use. Possible values are: - source-image: to use the same image that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - source-image-family: to use the same image family that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - custom-image: to use a user-provided image url for disk creation. Applicable to the boot disk and additional read-write disks. - attach-read-only: to attach a read-only disk. Applicable to read-only disks. - do-not-include: to exclude a disk from the template. Applicable to additional read-write disks, local SSDs, and read-only disks.
        #     Check the InstantiateFrom enum for the list of possible values.
        class DiskInstantiationConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Specifies whether to include the disk and what image to use. Possible values are: - source-image: to use the same image that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - source-image-family: to use the same image family that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - custom-image: to use a user-provided image url for disk creation. Applicable to the boot disk and additional read-write disks. - attach-read-only: to attach a read-only disk. Applicable to read-only disks. - do-not-include: to exclude a disk from the template. Applicable to additional read-write disks, local SSDs, and read-only disks.
          module InstantiateFrom
            # A value indicating that the enum field is not set.
            UNDEFINED_INSTANTIATE_FROM = 0

            # Attach the existing disk in read-only mode. The request will fail if the disk was attached in read-write mode on the source instance. Applicable to: read-only disks.
            ATTACH_READ_ONLY = 513_775_419

            # Create a blank disk. The disk will be created unformatted. Applicable to: additional read-write disks, local SSDs.
            BLANK = 63_281_460

            # Use the custom image specified in the custom_image field. Applicable to: boot disk, additional read-write disks.
            CUSTOM_IMAGE = 196_311_789

            # Use the default instantiation option for the corresponding type of disk. For boot disk and any other R/W disks, new custom images will be created from each disk. For read-only disks, they will be attached in read-only mode. Local SSD disks will be created as blank volumes.
            DEFAULT = 115_302_945

            # Do not include the disk in the instance template. Applicable to: additional read-write disks, local SSDs, read-only disks.
            DO_NOT_INCLUDE = 104_218_952

            # Use the same source image used for creation of the source instance's corresponding disk. The request will fail if the source VM's disk was created from a snapshot. Applicable to: boot disk, additional read-write disks.
            SOURCE_IMAGE = 62_631_959

            # Use the same source image family used for creation of the source instance's corresponding disk. The request will fail if the source image of the source disk does not belong to any image family. Applicable to: boot disk, additional read-write disks.
            SOURCE_IMAGE_FAMILY = 76_850_316
          end
        end

        # A list of Disk resources.
        # @!attribute [rw] id
        #   @return [::String]
        #     [Output Only] Unique identifier for the resource; defined by the server.
        # @!attribute [rw] items
        #   @return [::Array<::Google::Cloud::Compute::V1::Disk>]
        #     A list of Disk resources.
        # @!attribute [rw] kind
        #   @return [::String]
        #     [Output Only] Type of resource. Always compute#diskList for lists of disks.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
        # @!attribute [rw] self_link
        #   @return [::String]
        #     [Output Only] Server-defined URL for this resource.
        # @!attribute [rw] warning
        #   @return [::Google::Cloud::Compute::V1::Warning]
        #     [Output Only] Informational warning message.
        class DiskList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] destination_zone
        #   @return [::String]
        #     The URL of the destination zone to move the disk. This can be a full or partial URL. For example, the following are all valid URLs to a zone: - https://www.googleapis.com/compute/v1/projects/project/zones/zone - projects/project/zones/zone - zones/zone
        # @!attribute [rw] target_disk
        #   @return [::String]
        #     The URL of the target disk to move. This can be a full or partial URL. For example, the following are all valid URLs to a disk: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /disks/disk - projects/project/zones/zone/disks/disk - zones/zone/disks/disk
        class DiskMoveRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Additional disk params.
        # @!attribute [rw] resource_manager_tags
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Resource manager tags to be bound to the disk. Tag keys and values have the same definition as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id}`, and values are in the format `tagValues/456`. The field is ignored (both PUT & PATCH) when empty.
        class DiskParams
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class ResourceManagerTagsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # @!attribute [rw] async_primary_disk
        #   @return [::Google::Cloud::Compute::V1::DiskResourceStatusAsyncReplicationStatus]
        # @!attribute [rw] async_secondary_disks
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Compute::V1::DiskResourceStatusAsyncReplicationStatus}]
        #     Key: disk, value: AsyncReplicationStatus message
        class DiskResourceStatus
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Compute::V1::DiskResourceStatusAsyncReplicationStatus]
          class AsyncSecondaryDisksEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # @!attribute [rw] state
        #   @return [::String]
        #     Check the State enum for the list of possible values.
        class DiskResourceStatusAsyncReplicationStatus
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods


          module State
            # A value indicating that the enum field is not set.
            UNDEFINED_STATE = 0

            # Replication is active.
            ACTIVE = 314_733_318

            # Secondary disk is created and is waiting for replication to start.
            CREATED = 135_924_424

            # Replication is starting.
            STARTING = 488_820_800

            STATE_UNSPECIFIED = 470_755_401

            # Replication is stopped.
            STOPPED = 444_276_141

            # Replication is stopping.
            STOPPING = 350_791_796
          end
        end

        # Represents a Disk Type resource. Google Compute Engine has two Disk Type resources: * [Regional](/compute/docs/reference/rest/v1/regionDiskTypes) * [Zonal](/compute/docs/reference/rest/v1/diskTypes) You can choose from a variety of disk types based on your needs. For more information, read Storage options. The diskTypes resource represents disk types for a zonal persistent disk. For more information, read Zonal persistent disks. The regionDiskTypes resource represents disk types for a regional persistent disk. For more information, read Regional persistent disks.
        # @!attribute [rw] creation_timestamp
        #   @return [::String]
        #     [Output Only] Creation timestamp in RFC3339 text format.
        # @!attribute [rw] default_disk_size_gb
        #   @return [::Integer]
        #     [Output Only] Server-defined default disk size in GB.
        # @!attribute [rw] deprecated
        #   @return [::Google::Cloud::Compute::V1::DeprecationStatus]
        #     [Output Only] The deprecation status associated with this disk type.
        # @!attribute [rw] description
        #   @return [::String]
        #     [Output Only] An optional description of this resource.
        # @!attribute [rw] id
        #   @return [::Integer]
        #     [Output Only] The unique identifier for the resource. This identifier is defined by the server.
        # @!attribute [rw] kind
        #   @return [::String]
        #     [Output Only] Type of the resource. Always compute#diskType for disk types.
        # @!attribute [rw] name
        #   @return [::String]
        #     [Output Only] Name of the resource.
        # @!attribute [rw] region
        #   @return [::String]
        #     [Output Only] URL of the region where the disk type resides. Only applicable for regional resources. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
        # @!attribute [rw] self_link
        #   @return [::String]
        #     [Output Only] Server-defined URL for the resource.
        # @!attribute [rw] valid_disk_size
        #   @return [::String]
        #     [Output Only] An optional textual description of the valid disk size, such as "10GB-10TB".
        # @!attribute [rw] zone
        #   @return [::String]
        #     [Output Only] URL of the zone where the disk type resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
        class DiskType
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] id
        #   @return [::String]
        #     [Output Only] Unique identifier for the resource; defined by the server.
        # @!attribute [rw] items
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Compute::V1::DiskTypesScopedList}]
        #     A list of DiskTypesScopedList resources.
        # @!attribute [rw] kind
        #   @return [::String]
        #     [Output Only] Type of resource. Always compute#diskTypeAggregatedList.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
        # @!attribute [rw] self_link
        #   @return [::String]
        #     [Output Only] Server-defined URL for this resource.
        # @!attribute [rw] unreachables
        #   @return [::Array<::String>]
        #     [Output Only] Unreachable resources.
        # @!attribute [rw] warning
        #   @return [::Google::Cloud::Compute::V1::Warning]
        #     [Output Only] Informational warning message.
        class DiskTypeAggregatedList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Compute::V1::DiskTypesScopedList]
          class ItemsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Contains a list of disk types.
        # @!attribute [rw] id
        #   @return [::String]
        #     [Output Only] Unique identifier for the resource; defined by the server.
        # @!attribute [rw] items
        #   @return [::Array<::Google::Cloud::Compute::V1::DiskType>]
        #     A list of DiskType resources.
        # @!attribute [rw] kind
        #   @return [::String]
        #     [Output Only] Type of resource. Always compute#diskTypeList for disk types.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
        # @!attribute [rw] self_link
        #   @return [::String]
        #     [Output Only] Server-defined URL for this resource.
        # @!attribute [rw] warning
        #   @return [::Google::Cloud::Compute::V1::Warning]
        #     [Output Only] Informational warning message.
        class DiskTypeList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] disk_types
        #   @return [::Array<::Google::Cloud::Compute::V1::DiskType>]
        #     [Output Only] A list of disk types contained in this scope.
        # @!attribute [rw] warning
        #   @return [::Google::Cloud::Compute::V1::Warning]
        #     [Output Only] Informational warning which replaces the list of disk types when the list is empty.
        class DiskTypesScopedList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] resource_policies
        #   @return [::Array<::String>]
        #     Full or relative path to the resource policy to be added to this disk. You can only specify one resource policy.
        class DisksAddResourcePoliciesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] resource_policies
        #   @return [::Array<::String>]
        #     Resource policies to be removed from this disk.
        class DisksRemoveResourcePoliciesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] size_gb
        #   @return [::Integer]
        #     The new size of the persistent disk, which is specified in GB.
        class DisksResizeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] disks
        #   @return [::Array<::Google::Cloud::Compute::V1::Disk>]
        #     [Output Only] A list of disks contained in this scope.
        # @!attribute [rw] warning
        #   @return [::Google::Cloud::Compute::V1::Warning]
        #     [Output Only] Informational warning which replaces the list of disks when the list is empty.
        class DisksScopedList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] async_secondary_disk
        #   @return [::String]
        #     The secondary disk to start asynchronous replication to. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /disks/disk - https://www.googleapis.com/compute/v1/projects/project/regions/region /disks/disk - projects/project/zones/zone/disks/disk - projects/project/regions/region/disks/disk - zones/zone/disks/disk - regions/region/disks/disk
        class DisksStartAsyncReplicationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A transient resource used in compute.disks.stopGroupAsyncReplication and compute.regionDisks.stopGroupAsyncReplication. It is only used to process requests and is not persisted.
        # @!attribute [rw] resource_policy
        #   @return [::String]
        #     The URL of the DiskConsistencyGroupPolicy for the group of disks to stop. This may be a full or partial URL, such as: - https://www.googleapis.com/compute/v1/projects/project/regions/region /resourcePolicies/resourcePolicy - projects/project/regions/region/resourcePolicies/resourcePolicy - regions/region/resourcePolicies/resourcePolicy
        class DisksStopGroupAsyncReplicationResource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A set of Display Device options
        # @!attribute [rw] enable_display
        #   @return [::Boolean]
        #     Defines whether the instance has Display enabled.
        class DisplayDevice
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] target_shape
        #   @return [::String]
        #     The distribution shape to which the group converges either proactively or on resize events (depending on the value set in updatePolicy.instanceRedistributionType).
        #     Check the TargetShape enum for the list of possible values.
        # @!attribute [rw] zones
        #   @return [::Array<::Google::Cloud::Compute::V1::DistributionPolicyZoneConfiguration>]
        #     Zones where the regional managed instance group will create and manage its instances.
        class DistributionPolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The distribution shape to which the group converges either proactively or on resize events (depending on the value set in updatePolicy.instanceRedistributionType).
          module TargetShape
            # A value indicating that the enum field is not set.
            UNDEFINED_TARGET_SHAPE = 0

            # The group picks zones for creating VM instances to fulfill the requested number of VMs within present resource constraints and to maximize utilization of unused zonal reservations. Recommended for batch workloads that do not require high availability.
            ANY = 64_972

            # The group creates all VM instances within a single zone. The zone is selected based on the present resource constraints and to maximize utilization of unused zonal reservations. Recommended for batch workloads with heavy interprocess communication.
            ANY_SINGLE_ZONE = 61_100_880

            # The group prioritizes acquisition of resources, scheduling VMs in zones where resources are available while distributing VMs as evenly as possible across selected zones to minimize the impact of zonal failure. Recommended for highly available serving workloads.
            BALANCED = 468_409_608

            # The group schedules VM instance creation and deletion to achieve and maintain an even number of managed instances across the selected zones. The distribution is even when the number of managed instances does not differ by more than 1 between any two zones. Recommended for highly available serving workloads.
            EVEN = 2_140_442
          end
        end

        # @!attribute [rw] zone
        #   @return [::String]
        #     The URL of the zone. The zone must exist in the region where the managed instance group is located.
        class DistributionPolicyZoneConfiguration
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A Duration represents a fixed-length span of time represented as a count of seconds and fractions of seconds at nanosecond resolution. It is independent of any calendar and concepts like "day" or "month". Range is approximately 10,000 years.
        # @!attribute [rw] nanos
        #   @return [::Integer]
        #     Span of time that's a fraction of a second at nanosecond resolution. Durations less than one second are represented with a 0 `seconds` field and a positive `nanos` field. Must be from 0 to 999,999,999 inclusive.
        # @!attribute [rw] seconds
        #   @return [::Integer]
        #     Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive. Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
        class Duration
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Projects.EnableXpnHost. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class EnableXpnHostProjectRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Projects.EnableXpnResource. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] projects_enable_xpn_resource_request_resource
        #   @return [::Google::Cloud::Compute::V1::ProjectsEnableXpnResourceRequest]
        #     The body resource for this request
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        class EnableXpnResourceProjectRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Errors that prevented the ResizeRequest to be fulfilled.
        # @!attribute [rw] errors
        #   @return [::Array<::Google::Cloud::Compute::V1::Errors>]
        #     [Output Only] The array of errors encountered while processing this operation.
        class Error
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] error_info
        #   @return [::Google::Cloud::Compute::V1::ErrorInfo]
        # @!attribute [rw] help
        #   @return [::Google::Cloud::Compute::V1::Help]
        # @!attribute [rw] localized_message
        #   @return [::Google::Cloud::Compute::V1::LocalizedMessage]
        # @!attribute [rw] quota_info
        #   @return [::Google::Cloud::Compute::V1::QuotaExceededInfo]
        class ErrorDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Describes the cause of the error with structured details. Example of an error when contacting the "pubsub.googleapis.com" API when it is not enabled: { "reason": "API_DISABLED" "domain": "googleapis.com" "metadata": { "resource": "projects/123", "service": "pubsub.googleapis.com" } } This response indicates that the pubsub.googleapis.com API is not enabled. Example of an error that is returned when attempting to create a Spanner instance in a region that is out of stock: { "reason": "STOCKOUT" "domain": "spanner.googleapis.com", "metadata": { "availableRegions": "us-central1,us-east2" } }
        # @!attribute [rw] domain
        #   @return [::String]
        #     The logical grouping to which the "reason" belongs. The error domain is typically the registered service name of the tool or product that generates the error. Example: "pubsub.googleapis.com". If the error is generated by some common infrastructure, the error domain must be a globally unique value that identifies the infrastructure. For Google API infrastructure, the error domain is "googleapis.com".
        # @!attribute [rw] metadatas
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Additional structured details about this error. Keys must match a regular expression of `a-z+` but should ideally be lowerCamelCase. Also, they must be limited to 64 characters in length. When identifying the current value of an exceeded limit, the units should be contained in the key, not the value. For example, rather than `{"instanceLimit": "100/request"}`, should be returned as, `{"instanceLimitPerRequest": "100"}`, if the client exceeds the number of instances that can be created in a single (batch) request.
        # @!attribute [rw] reason
        #   @return [::String]
        #     The reason of the error. This is a constant value that identifies the proximate cause of the error. Error reasons are unique within a particular domain of errors. This should be at most 63 characters and match a regular expression of `A-Z+[A-Z0-9]`, which represents UPPER_SNAKE_CASE.
        class ErrorInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class MetadatasEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # @!attribute [rw] code
        #   @return [::String]
        #     [Output Only] The error type identifier for this error.
        # @!attribute [rw] error_details
        #   @return [::Array<::Google::Cloud::Compute::V1::ErrorDetails>]
        #     [Output Only] An optional list of messages that contain the error details. There is a set of defined message types to use for providing details.The syntax depends on the error code. For example, QuotaExceededInfo will have details when the error code is QUOTA_EXCEEDED.
        # @!attribute [rw] location
        #   @return [::String]
        #     [Output Only] Indicates the field in the request that caused the error. This property is optional.
        # @!attribute [rw] message
        #   @return [::String]
        #     [Output Only] An optional, human-readable error message.
        class Errors
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] dest_range
        #   @return [::String]
        #     The destination range of the route.
        # @!attribute [rw] imported
        #   @return [::Boolean]
        #     True if the peering route has been imported from a peer. The actual import happens if the field networkPeering.importCustomRoutes is true for this network, and networkPeering.exportCustomRoutes is true for the peer network, and the import does not result in a route conflict.
        # @!attribute [rw] next_hop_region
        #   @return [::String]
        #     The region of peering route next hop, only applies to dynamic routes.
        # @!attribute [rw] priority
        #   @return [::Integer]
        #     The priority of the peering route.
        # @!attribute [rw] type
        #   @return [::String]
        #     The type of the peering route.
        #     Check the Type enum for the list of possible values.
        class ExchangedPeeringRoute
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The type of the peering route.
          module Type
            # A value indicating that the enum field is not set.
            UNDEFINED_TYPE = 0

            # For routes exported from local network.
            DYNAMIC_PEERING_ROUTE = 469_794_858

            # The peering route.
            STATIC_PEERING_ROUTE = 473_407_545

            # The peering route corresponding to subnetwork range.
            SUBNET_PEERING_ROUTE = 465_782_504
          end
        end

        # @!attribute [rw] id
        #   @return [::String]
        #     [Output Only] Unique identifier for the resource; defined by the server.
        # @!attribute [rw] items
        #   @return [::Array<::Google::Cloud::Compute::V1::ExchangedPeeringRoute>]
        #     A list of ExchangedPeeringRoute resources.
        # @!attribute [rw] kind
        #   @return [::String]
        #     [Output Only] Type of resource. Always compute#exchangedPeeringRoutesList for exchanged peering routes lists.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
        # @!attribute [rw] self_link
        #   @return [::String]
        #     [Output Only] Server-defined URL for this resource.
        # @!attribute [rw] warning
        #   @return [::Google::Cloud::Compute::V1::Warning]
        #     [Output Only] Informational warning message.
        class ExchangedPeeringRoutesList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Subnetworks.ExpandIpCidrRange. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] subnetwork
        #   @return [::String]
        #     Name of the Subnetwork resource to update.
        # @!attribute [rw] subnetworks_expand_ip_cidr_range_request_resource
        #   @return [::Google::Cloud::Compute::V1::SubnetworksExpandIpCidrRangeRequest]
        #     The body resource for this request
        class ExpandIpCidrRangeSubnetworkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        # @!attribute [rw] expression
        #   @return [::String]
        #     Textual representation of an expression in Common Expression Language syntax.
        # @!attribute [rw] location
        #   @return [::String]
        #     Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        # @!attribute [rw] title
        #   @return [::String]
        #     Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        class Expr
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents an external VPN gateway. External VPN gateway is the on-premises VPN gateway(s) or another cloud provider's VPN gateway that connects to your Google Cloud VPN gateway. To create a highly available VPN from Google Cloud Platform to your VPN gateway or another cloud provider's VPN gateway, you must create a external VPN gateway resource with information about the other gateway. For more information about using external VPN gateways, see Creating an HA VPN gateway and tunnel pair to a peer VPN.
        # @!attribute [rw] creation_timestamp
        #   @return [::String]
        #     [Output Only] Creation timestamp in RFC3339 text format.
        # @!attribute [rw] description
        #   @return [::String]
        #     An optional description of this resource. Provide this property when you create the resource.
        # @!attribute [rw] id
        #   @return [::Integer]
        #     [Output Only] The unique identifier for the resource. This identifier is defined by the server.
        # @!attribute [rw] interfaces
        #   @return [::Array<::Google::Cloud::Compute::V1::ExternalVpnGatewayInterface>]
        #     A list of interfaces for this external VPN gateway. If your peer-side gateway is an on-premises gateway and non-AWS cloud providers' gateway, at most two interfaces can be provided for an external VPN gateway. If your peer side is an AWS virtual private gateway, four interfaces should be provided for an external VPN gateway.
        # @!attribute [rw] kind
        #   @return [::String]
        #     [Output Only] Type of the resource. Always compute#externalVpnGateway for externalVpnGateways.
        # @!attribute [rw] label_fingerprint
        #   @return [::String]
        #     A fingerprint for the labels being applied to this ExternalVpnGateway, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an ExternalVpnGateway.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        # @!attribute [rw] redundancy_type
        #   @return [::String]
        #     Indicates the user-supplied redundancy type of this external VPN gateway.
        #     Check the RedundancyType enum for the list of possible values.
        # @!attribute [rw] self_link
        #   @return [::String]
        #     [Output Only] Server-defined URL for the resource.
        class ExternalVpnGateway
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Indicates the user-supplied redundancy type of this external VPN gateway.
          module RedundancyType
            # A value indicating that the enum field is not set.
            UNDEFINED_REDUNDANCY_TYPE = 0

            # The external VPN gateway has four public IP addresses; at the time of writing this API, the AWS virtual private gateway is an example which has four public IP addresses for high availability connections; there should be two VPN connections in the AWS virtual private gateway , each AWS VPN connection has two public IP addresses; please make sure to put two public IP addresses from one AWS VPN connection into interfaces 0 and 1 of this external VPN gateway, and put the other two public IP addresses from another AWS VPN connection into interfaces 2 and 3 of this external VPN gateway. When displaying highly available configuration status for the VPN tunnels connected to FOUR_IPS_REDUNDANCY external VPN gateway, Google will always detect whether interfaces 0 and 1 are connected on one interface of HA Cloud VPN gateway, and detect whether interfaces 2 and 3 are connected to another interface of the HA Cloud VPN gateway.
            FOUR_IPS_REDUNDANCY = 520_087_913

            # The external VPN gateway has only one public IP address which internally provide redundancy or failover.
            SINGLE_IP_INTERNALLY_REDUNDANT = 133_914_873

            # The external VPN gateway has two public IP addresses which are redundant with each other, the following two types of setup on your on-premises side would have this type of redundancy: (1) Two separate on-premises gateways, each with one public IP address, the two on-premises gateways are redundant with each other. (2) A single on-premise gateway with two public IP addresses that are redundant with eatch other.
            TWO_IPS_REDUNDANCY = 367_049_635
          end
        end

        # The interface for the external VPN gateway.
        # @!attribute [rw] id
        #   @return [::Integer]
        #     The numeric ID of this interface. The allowed input values for this id for different redundancy types of external VPN gateway: - SINGLE_IP_INTERNALLY_REDUNDANT - 0 - TWO_IPS_REDUNDANCY - 0, 1 - FOUR_IPS_REDUNDANCY - 0, 1, 2, 3
        # @!attribute [rw] ip_address
        #   @return [::String]
        #     IP address of the interface in the external VPN gateway. Only IPv4 is supported. This IP address can be either from your on-premise gateway or another Cloud provider's VPN gateway, it cannot be an IP address from Google Compute Engine.
        # @!attribute [rw] ipv6_address
        #   @return [::String]
        #     IPv6 address of the interface in the external VPN gateway. This IPv6 address can be either from your on-premise gateway or another Cloud provider's VPN gateway, it cannot be an IP address from Google Compute Engine. Must specify an IPv6 address (not IPV4-mapped) using any format described in RFC 4291 (e.g. 2001:db8:0:0:2d9:51:0:0). The output format is RFC 5952 format (e.g. 2001:db8::2d9:51:0:0).
        class ExternalVpnGatewayInterface
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response to the list request, and contains a list of externalVpnGateways.
        # @!attribute [rw] etag
        #   @return [::String]
        # @!attribute [rw] id
        #   @return [::String]
        #     [Output Only] Unique identifier for the resource; defined by the server.
        # @!attribute [rw] items
        #   @return [::Array<::Google::Cloud::Compute::V1::ExternalVpnGateway>]
        #     A list of ExternalVpnGateway resources.
        # @!attribute [rw] kind
        #   @return [::String]
        #     [Output Only] Type of resource. Always compute#externalVpnGatewayList for lists of externalVpnGateways.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
        # @!attribute [rw] self_link
        #   @return [::String]
        #     [Output Only] Server-defined URL for this resource.
        # @!attribute [rw] warning
        #   @return [::Google::Cloud::Compute::V1::Warning]
        #     [Output Only] Informational warning message.
        class ExternalVpnGatewayList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] content
        #   @return [::String]
        #     The raw content in the secure keys file.
        # @!attribute [rw] file_type
        #   @return [::String]
        #     The file type of source file.
        #     Check the FileType enum for the list of possible values.
        class FileContentBuffer
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The file type of source file.
          module FileType
            # A value indicating that the enum field is not set.
            UNDEFINED_FILE_TYPE = 0

            BIN = 65_767

            UNDEFINED = 137_851_184

            X509 = 2_674_086
          end
        end

        # Represents a Firewall Rule resource. Firewall rules allow or deny ingress traffic to, and egress traffic from your instances. For more information, read Firewall rules.
        # @!attribute [rw] allowed
        #   @return [::Array<::Google::Cloud::Compute::V1::Allowed>]
        #     The list of ALLOW rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a permitted connection.
        # @!attribute [rw] creation_timestamp
        #   @return [::String]
        #     [Output Only] Creation timestamp in RFC3339 text format.
        # @!attribute [rw] denied
        #   @return [::Array<::Google::Cloud::Compute::V1::Denied>]
        #     The list of DENY rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a denied connection.
        # @!attribute [rw] description
        #   @return [::String]
        #     An optional description of this resource. Provide this field when you create the resource.
        # @!attribute [rw] destination_ranges
        #   @return [::Array<::String>]
        #     If destination ranges are specified, the firewall rule applies only to traffic that has destination IP address in these ranges. These ranges must be expressed in CIDR format. Both IPv4 and IPv6 are supported.
        # @!attribute [rw] direction
        #   @return [::String]
        #     Direction of traffic to which this firewall applies, either `INGRESS` or `EGRESS`. The default is `INGRESS`. For `EGRESS` traffic, you cannot specify the sourceTags fields.
        #     Check the Direction enum for the list of possible values.
        # @!attribute [rw] disabled
        #   @return [::Boolean]
        #     Denotes whether the firewall rule is disabled. When set to true, the firewall rule is not enforced and the network behaves as if it did not exist. If this is unspecified, the firewall rule will be enabled.
        # @!attribute [rw] id
        #   @return [::Integer]
        #     [Output Only] The unique identifier for the resource. This identifier is defined by the server.
        # @!attribute [rw] kind
        #   @return [::String]
        #     [Output Only] Type of the resource. Always compute#firewall for firewall rules.
        # @!attribute [rw] log_config
        #   @return [::Google::Cloud::Compute::V1::FirewallLogConfig]
        #     This field denotes the logging options for a particular firewall rule. If logging is enabled, logs will be exported to Cloud Logging.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
        # @!attribute [rw] network
        #   @return [::String]
        #     URL of the network resource for this firewall rule. If not specified when creating a firewall rule, the default network is used: global/networks/default If you choose to specify this field, you can specify the network as a full or partial URL. For example, the following are all valid URLs: - https://www.googleapis.com/compute/v1/projects/myproject/global/networks/my-network - projects/myproject/global/networks/my-network - global/networks/default
        # @!attribute [rw] params
        #   @return [::Google::Cloud::Compute::V1::FirewallParams]
        #     Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
        # @!attribute [rw] priority
        #   @return [::Integer]
        #     Priority for this rule. This is an integer between `0` and `65535`, both inclusive. The default value is `1000`. Relative priorities determine which rule takes effect if multiple rules apply. Lower values indicate higher priority. For example, a rule with priority `0` has higher precedence than a rule with priority `1`. DENY rules take precedence over ALLOW rules if they have equal priority. Note that VPC networks have implied rules with a priority of `65535`. To avoid conflicts with the implied rules, use a priority number less than `65535`.
        # @!attribute [rw] self_link
        #   @return [::String]
        #     [Output Only] Server-defined URL for the resource.
        # @!attribute [rw] source_ranges
        #   @return [::Array<::String>]
        #     If source ranges are specified, the firewall rule applies only to traffic that has a source IP address in these ranges. These ranges must be expressed in CIDR format. One or both of sourceRanges and sourceTags may be set. If both fields are set, the rule applies to traffic that has a source IP address within sourceRanges OR a source IP from a resource with a matching tag listed in the sourceTags field. The connection does not need to match both fields for the rule to apply. Both IPv4 and IPv6 are supported.
        # @!attribute [rw] source_service_accounts
        #   @return [::Array<::String>]
        #     If source service accounts are specified, the firewall rules apply only to traffic originating from an instance with a service account in this list. Source service accounts cannot be used to control traffic to an instance's external IP address because service accounts are associated with an instance, not an IP address. sourceRanges can be set at the same time as sourceServiceAccounts. If both are set, the firewall applies to traffic that has a source IP address within the sourceRanges OR a source IP that belongs to an instance with service account listed in sourceServiceAccount. The connection does not need to match both fields for the firewall to apply. sourceServiceAccounts cannot be used at the same time as sourceTags or targetTags.
        # @!attribute [rw] source_tags
        #   @return [::Array<::String>]
        #     If source tags are specified, the firewall rule applies only to traffic with source IPs that match the primary network interfaces of VM instances that have the tag and are in the same VPC network. Source tags cannot be used to control traffic to an instance's external IP address, it only applies to traffic between instances in the same virtual network. Because tags are associated with instances, not IP addresses. One or both of sourceRanges and sourceTags may be set. If both fields are set, the firewall applies to traffic that has a source IP address within sourceRanges OR a source IP from a resource with a matching tag listed in the sourceTags field. The connection does not need to match both fields for the firewall to apply.
        # @!attribute [rw] target_service_accounts
        #   @return [::Array<::String>]
        #     A list of service accounts indicating sets of instances located in the network that may make network connections as specified in allowed[]. targetServiceAccounts cannot be used at the same time as targetTags or sourceTags. If neither targetServiceAccounts nor targetTags are specified, the firewall rule applies to all instances on the specified network.
        # @!attribute [rw] target_tags
        #   @return [::Array<::String>]
        #     A list of tags that controls which instances the firewall rule applies to. If targetTags are specified, then the firewall rule applies only to instances in the VPC network that have one of those tags. If no targetTags are specified, the firewall rule applies to all instances on the specified network.
        class Firewall
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Direction of traffic to which this firewall applies, either `INGRESS` or `EGRESS`. The default is `INGRESS`. For `EGRESS` traffic, you cannot specify the sourceTags fields.
          module Direction
            # A value indicating that the enum field is not set.
            UNDEFINED_DIRECTION = 0

            # Indicates that firewall should apply to outgoing traffic.
            EGRESS = 432_880_501

            # Indicates that firewall should apply to incoming traffic.
            INGRESS = 516_931_221
          end
        end

        # Contains a list of firewalls.
        # @!attribute [rw] id
        #   @return [::String]
        #     [Output Only] Unique identifier for the resource; defined by the server.
        # @!attribute [rw] items
        #   @return [::Array<::Google::Cloud::Compute::V1::Firewall>]
        #     A list of Firewall resources.
        # @!attribute [rw] kind
        #   @return [::String]
        #     [Output Only] Type of resource. Always compute#firewallList for lists of firewalls.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
        # @!attribute [rw] self_link
        #   @return [::String]
        #     [Output Only] Server-defined URL for this resource.
        # @!attribute [rw] warning
        #   @return [::Google::Cloud::Compute::V1::Warning]
        #     [Output Only] Informational warning message.
        class FirewallList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The available logging options for a firewall rule.
        # @!attribute [rw] enable
        #   @return [::Boolean]
        #     This field denotes whether to enable logging for a particular firewall rule.
        # @!attribute [rw] metadata
        #   @return [::String]
        #     This field can only be specified for a particular firewall rule if logging is enabled for that rule. This field denotes whether to include or exclude metadata for firewall logs.
        #     Check the Metadata enum for the list of possible values.
        class FirewallLogConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # This field can only be specified for a particular firewall rule if logging is enabled for that rule. This field denotes whether to include or exclude metadata for firewall logs.
          module Metadata
            # A value indicating that the enum field is not set.
            UNDEFINED_METADATA = 0

            EXCLUDE_ALL_METADATA = 334_519_954

            INCLUDE_ALL_METADATA = 164_619_908
          end
        end

        # Additional firewall parameters.
        # @!attribute [rw] resource_manager_tags
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Tag keys/values directly bound to this resource. Tag keys and values have the same definition as resource manager tags. The field is allowed for INSERT only. The keys/values to set on the resource should be specified in either ID { : } or Namespaced format { : }. For example the following are valid inputs: * \\{"tagKeys/333" : "tagValues/444", "tagKeys/123" : "tagValues/456"} * \\{"123/environment" : "production", "345/abc" : "xyz"} Note: * Invalid combinations of ID & namespaced format is not supported. For instance: \\{"123/environment" : "tagValues/444"} is invalid.
        class FirewallParams
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class ResourceManagerTagsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # @!attribute [rw] associations
        #   @return [::Array<::Google::Cloud::Compute::V1::FirewallPolicyAssociation>]
        #     A list of associations.
        # @!attribute [rw] kind
        #   @return [::String]
        #     [Output Only] Type of firewallPolicy associations. Always compute#FirewallPoliciesListAssociations for lists of firewallPolicy associations.
        class FirewallPoliciesListAssociationsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] firewall_policies
        #   @return [::Array<::Google::Cloud::Compute::V1::FirewallPolicy>]
        #     A list of firewall policies contained in this scope.
        # @!attribute [rw] warning
        #   @return [::Google::Cloud::Compute::V1::Warning]
        #     Informational warning which replaces the list of firewall policies when the list is empty.
        class FirewallPoliciesScopedList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a Firewall Policy resource.
        # @!attribute [rw] associations
        #   @return [::Array<::Google::Cloud::Compute::V1::FirewallPolicyAssociation>]
        #     A list of associations that belong to this firewall policy.
        # @!attribute [rw] creation_timestamp
        #   @return [::String]
        #     [Output Only] Creation timestamp in RFC3339 text format.
        # @!attribute [rw] description
        #   @return [::String]
        #     An optional description of this resource. Provide this property when you create the resource.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Deprecated, please use short name instead. User-provided name of the Organization firewall policy. The name should be unique in the organization in which the firewall policy is created. This field is not applicable to network firewall policies. This name must be set on creation and cannot be changed. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        # @!attribute [rw] fingerprint
        #   @return [::String]
        #     Specifies a fingerprint for this resource, which is essentially a hash of the metadata's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update metadata. You must always provide an up-to-date fingerprint hash in order to update or change metadata, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make get() request to the firewall policy.
        # @!attribute [rw] id
        #   @return [::Integer]
        #     [Output Only] The unique identifier for the resource. This identifier is defined by the server.
        # @!attribute [rw] kind
        #   @return [::String]
        #     [Output only] Type of the resource. Always compute#firewallPolicyfor firewall policies
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the resource. For Organization Firewall Policies it's a [Output Only] numeric ID allocated by Google Cloud which uniquely identifies the Organization Firewall Policy.
        # @!attribute [rw] packet_mirroring_rules
        #   @return [::Array<::Google::Cloud::Compute::V1::FirewallPolicyRule>]
        #     A list of packet mirroring rules that belong to this policy.
        # @!attribute [rw] parent
        #   @return [::String]
        #     [Output Only] The parent of the firewall policy. This field is not applicable to network firewall policies.
        # @!attribute [rw] region
        #   @return [::String]
        #     [Output Only] URL of the region where the regional firewall policy resides. This field is not applicable to global firewall policies. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
        # @!attribute [rw] rule_tuple_count
        #   @return [::Integer]
        #     [Output Only] Total count of all firewall policy rule tuples. A firewall policy can not exceed a set number of tuples.
        # @!attribute [rw] rules
        #   @return [::Array<::Google::Cloud::Compute::V1::FirewallPolicyRule>]
        #     A list of rules that belong to this policy. There must always be a default rule (rule with priority 2147483647 and match "*"). If no rules are provided when creating a firewall policy, a default rule with action "allow" will be added.
        # @!attribute [rw] self_link
        #   @return [::String]
        #     [Output Only] Server-defined URL for the resource.
        # @!attribute [rw] self_link_with_id
        #   @return [::String]
        #     [Output Only] Server-defined URL for this resource with the resource id.
        # @!attribute [rw] short_name
        #   @return [::String]
        #     User-provided name of the Organization firewall policy. The name should be unique in the organization in which the firewall policy is created. This field is not applicable to network firewall policies. This name must be set on creation and cannot be changed. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        class FirewallPolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] attachment_target
        #   @return [::String]
        #     The target that the firewall policy is attached to.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     [Output Only] Deprecated, please use short name instead. The display name of the firewall policy of the association.
        # @!attribute [rw] firewall_policy_id
        #   @return [::String]
        #     [Output Only] The firewall policy ID of the association.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name for an association.
        # @!attribute [rw] short_name
        #   @return [::String]
        #     [Output Only] The short name of the firewall policy of the association.
        class FirewallPolicyAssociation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] id
        #   @return [::String]
        #     [Output Only] Unique identifier for the resource; defined by the server.
        # @!attribute [rw] items
        #   @return [::Array<::Google::Cloud::Compute::V1::FirewallPolicy>]
        #     A list of FirewallPolicy resources.
        # @!attribute [rw] kind
        #   @return [::String]
        #     [Output Only] Type of resource. Always compute#firewallPolicyList for listsof FirewallPolicies
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
        # @!attribute [rw] warning
        #   @return [::Google::Cloud::Compute::V1::Warning]
        #     [Output Only] Informational warning message.
        class FirewallPolicyList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a rule that describes one or more match conditions along with the action to be taken when traffic matches this condition (allow or deny).
        # @!attribute [rw] action
        #   @return [::String]
        #     The Action to perform when the client connection triggers the rule. Valid actions for firewall rules are: "allow", "deny", "apply_security_profile_group" and "goto_next". Valid actions for packet mirroring rules are: "mirror", "do_not_mirror" and "goto_next".
        # @!attribute [rw] description
        #   @return [::String]
        #     An optional description for this resource.
        # @!attribute [rw] direction
        #   @return [::String]
        #     The direction in which this rule applies.
        #     Check the Direction enum for the list of possible values.
        # @!attribute [rw] disabled
        #   @return [::Boolean]
        #     Denotes whether the firewall policy rule is disabled. When set to true, the firewall policy rule is not enforced and traffic behaves as if it did not exist. If this is unspecified, the firewall policy rule will be enabled.
        # @!attribute [rw] enable_logging
        #   @return [::Boolean]
        #     Denotes whether to enable logging for a particular rule. If logging is enabled, logs will be exported to the configured export destination in Stackdriver. Logs may be exported to BigQuery or Pub/Sub. Note: you cannot enable logging on "goto_next" rules.
        # @!attribute [rw] kind
        #   @return [::String]
        #     [Output only] Type of the resource. Returns compute#firewallPolicyRule for firewall rules and compute#packetMirroringRule for packet mirroring rules.
        # @!attribute [rw] match
        #   @return [::Google::Cloud::Compute::V1::FirewallPolicyRuleMatcher]
        #     A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
        # @!attribute [rw] priority
        #   @return [::Integer]
        #     An integer indicating the priority of a rule in the list. The priority must be a positive value between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.
        # @!attribute [rw] rule_name
        #   @return [::String]
        #     An optional name for the rule. This field is not a unique identifier and can be updated.
        # @!attribute [rw] rule_tuple_count
        #   @return [::Integer]
        #     [Output Only] Calculation of the complexity of a single firewall policy rule.
        # @!attribute [rw] security_profile_group
        #   @return [::String]
        #     A fully-qualified URL of a SecurityProfile resource instance. Example: https://networksecurity.googleapis.com/v1/projects/\\{project}/locations/\\{location}/securityProfileGroups/my-security-profile-group Must be specified if action is one of 'apply_security_profile_group' or 'mirror'. Cannot be specified for other actions.
        # @!attribute [rw] target_resources
        #   @return [::Array<::String>]
        #     A list of network resource URLs to which this rule applies. This field allows you to control which network's VMs get this rule. If this field is left blank, all VMs within the organization will receive the rule.
        # @!attribute [rw] target_secure_tags
        #   @return [::Array<::Google::Cloud::Compute::V1::FirewallPolicyRuleSecureTag>]
        #     A list of secure tags that controls which instances the firewall rule applies to. If targetSecureTag are specified, then the firewall rule applies only to instances in the VPC network that have one of those EFFECTIVE secure tags, if all the target_secure_tag are in INEFFECTIVE state, then this rule will be ignored. targetSecureTag may not be set at the same time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are specified, the firewall rule applies to all instances on the specified network. Maximum number of target label tags allowed is 256.
        # @!attribute [rw] target_service_accounts
        #   @return [::Array<::String>]
        #     A list of service accounts indicating the sets of instances that are applied with this rule.
        # @!attribute [rw] tls_inspect
        #   @return [::Boolean]
        #     Boolean flag indicating if the traffic should be TLS decrypted. Can be set only if action = 'apply_security_profile_group' and cannot be set for other actions.
        class FirewallPolicyRule
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The direction in which this rule applies.
          module Direction
            # A value indicating that the enum field is not set.
            UNDEFINED_DIRECTION = 0

            EGRESS = 432_880_501

            INGRESS = 516_931_221
          end
        end

        # Represents a match condition that incoming traffic is evaluated against. Exactly one field must be specified.
        # @!attribute [rw] dest_address_groups
        #   @return [::Array<::String>]
        #     Address groups which should be matched against the traffic destination. Maximum number of destination address groups is 10.
        # @!attribute [rw] dest_fqdns
        #   @return [::Array<::String>]
        #     Fully Qualified Domain Name (FQDN) which should be matched against traffic destination. Maximum number of destination fqdn allowed is 100.
        # @!attribute [rw] dest_ip_ranges
        #   @return [::Array<::String>]
        #     CIDR IP address range. Maximum number of destination CIDR IP ranges allowed is 5000.
        # @!attribute [rw] dest_network_type
        #   @return [::String]
        #     Network type of the traffic destination. Allowed values are: - UNSPECIFIED - INTERNET - NON_INTERNET
        #     Check the DestNetworkType enum for the list of possible values.
        # @!attribute [rw] dest_region_codes
        #   @return [::Array<::String>]
        #     Region codes whose IP addresses will be used to match for destination of traffic. Should be specified as 2 letter country code defined as per ISO 3166 alpha-2 country codes. ex."US" Maximum number of dest region codes allowed is 5000.
        # @!attribute [rw] dest_threat_intelligences
        #   @return [::Array<::String>]
        #     Names of Network Threat Intelligence lists. The IPs in these lists will be matched against traffic destination.
        # @!attribute [rw] layer4_configs
        #   @return [::Array<::Google::Cloud::Compute::V1::FirewallPolicyRuleMatcherLayer4Config>]
        #     Pairs of IP protocols and ports that the rule should match.
        # @!attribute [rw] src_address_groups
        #   @return [::Array<::String>]
        #     Address groups which should be matched against the traffic source. Maximum number of source address groups is 10.
        # @!attribute [rw] src_fqdns
        #   @return [::Array<::String>]
        #     Fully Qualified Domain Name (FQDN) which should be matched against traffic source. Maximum number of source fqdn allowed is 100.
        # @!attribute [rw] src_ip_ranges
        #   @return [::Array<::String>]
        #     CIDR IP address range. Maximum number of source CIDR IP ranges allowed is 5000.
        # @!attribute [rw] src_network_type
        #   @return [::String]
        #     Network type of the traffic source. Allowed values are: - UNSPECIFIED - INTERNET - INTRA_VPC - NON_INTERNET - VPC_NETWORKS
        #     Check the SrcNetworkType enum for the list of possible values.
        # @!attribute [rw] src_networks
        #   @return [::Array<::String>]
        #     Networks of the traffic source. It can be either a full or partial url.
        # @!attribute [rw] src_region_codes
        #   @return [::Array<::String>]
        #     Region codes whose IP addresses will be used to match for source of traffic. Should be specified as 2 letter country code defined as per ISO 3166 alpha-2 country codes. ex."US" Maximum number of source region codes allowed is 5000.
        # @!attribute [rw] src_secure_tags
        #   @return [::Array<::Google::Cloud::Compute::V1::FirewallPolicyRuleSecureTag>]
        #     List of secure tag values, which should be matched at the source of the traffic. For INGRESS rule, if all the srcSecureTag are INEFFECTIVE, and there is no srcIpRange, this rule will be ignored. Maximum number of source tag values allowed is 256.
        # @!attribute [rw] src_threat_intelligences
        #   @return [::Array<::String>]
        #     Names of Network Threat Intelligence lists. The IPs in these lists will be matched against traffic source.
        class FirewallPolicyRuleMatcher
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Network type of the traffic destination. Allowed values are: - UNSPECIFIED - INTERNET - NON_INTERNET
          # Additional supported values which may be not listed in the enum directly due to technical reasons:
          # INTERNET
          # INTRA_VPC
          # NON_INTERNET
          # UNSPECIFIED
          # VPC_NETWORKS
          module DestNetworkType
            # A value indicating that the enum field is not set.
            UNDEFINED_DEST_NETWORK_TYPE = 0
          end

          # Network type of the traffic source. Allowed values are: - UNSPECIFIED - INTERNET - INTRA_VPC - NON_INTERNET - VPC_NETWORKS
          # Additional supported values which may be not listed in the enum directly due to technical reasons:
          # INTERNET
          # INTRA_VPC
          # NON_INTERNET
          # UNSPECIFIED
          # VPC_NETWORKS
          module SrcNetworkType
            # A value indicating that the enum field is not set.
            UNDEFINED_SRC_NETWORK_TYPE = 0
          end
        end

        # @!attribute [rw] ip_protocol
        #   @return [::String]
        #     The IP protocol to which this rule applies. The protocol type is required when creating a firewall rule. This value can either be one of the following well known protocol strings (tcp, udp, icmp, esp, ah, ipip, sctp), or the IP protocol number.
        # @!attribute [rw] ports
        #   @return [::Array<::String>]
        #     An optional list of ports to which this rule applies. This field is only applicable for UDP or TCP protocol. Each entry must be either an integer or a range. If not specified, this rule applies to connections through any port. Example inputs include: ["22"], ["80","443"], and ["12345-12349"].
        class FirewallPolicyRuleMatcherLayer4Config
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the secure tag, created with TagManager's TagValue API.
        # @!attribute [rw] state
        #   @return [::String]
        #     [Output Only] State of the secure tag, either `EFFECTIVE` or `INEFFECTIVE`. A secure tag is `INEFFECTIVE` when it is deleted or its network is deleted.
        #     Check the State enum for the list of possible values.
        class FirewallPolicyRuleSecureTag
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # [Output Only] State of the secure tag, either `EFFECTIVE` or `INEFFECTIVE`. A secure tag is `INEFFECTIVE` when it is deleted or its network is deleted.
          module State
            # A value indicating that the enum field is not set.
            UNDEFINED_STATE = 0

            EFFECTIVE = 244_201_863

            INEFFECTIVE = 304_458_242
          end
        end

        # Encapsulates numeric value that can be either absolute or relative.
        # @!attribute [rw] calculated
        #   @return [::Integer]
        #     [Output Only] Absolute value of VM instances calculated based on the specific mode. - If the value is fixed, then the calculated value is equal to the fixed value. - If the value is a percent, then the calculated value is percent/100 * targetSize. For example, the calculated value of a 80% of a managed instance group with 150 instances would be (80/100 * 150) = 120 VM instances. If there is a remainder, the number is rounded.
        # @!attribute [rw] fixed
        #   @return [::Integer]
        #     Specifies a fixed number of VM instances. This must be a positive integer.
        # @!attribute [rw] percent
        #   @return [::Integer]
        #     Specifies a percentage of instances between 0 to 100%, inclusive. For example, specify 80 for 80%.
        class FixedOrPercent
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a Forwarding Rule resource. Forwarding rule resources in Google Cloud can be either regional or global in scope: * [Global](https://cloud.google.com/compute/docs/reference/rest/v1/globalForwardingRules) * [Regional](https://cloud.google.com/compute/docs/reference/rest/v1/forwardingRules) A forwarding rule and its corresponding IP address represent the frontend configuration of a Google Cloud load balancer. Forwarding rules can also reference target instances and Cloud VPN Classic gateways (targetVpnGateway). For more information, read Forwarding rule concepts and Using protocol forwarding.
        # @!attribute [rw] I_p_address
        #   @return [::String]
        #     IP address for which this forwarding rule accepts traffic. When a client sends traffic to this IP address, the forwarding rule directs the traffic to the referenced target or backendService. While creating a forwarding rule, specifying an IPAddress is required under the following circumstances: - When the target is set to targetGrpcProxy and validateForProxyless is set to true, the IPAddress should be set to 0.0.0.0. - When the target is a Private Service Connect Google APIs bundle, you must specify an IPAddress. Otherwise, you can optionally specify an IP address that references an existing static (reserved) IP address resource. When omitted, Google Cloud assigns an ephemeral IP address. Use one of the following formats to specify an IP address while creating a forwarding rule: * IP address number, as in `100.1.2.3` * IPv6 address range, as in `2600:1234::/96` * Full resource URL, as in https://www.googleapis.com/compute/v1/projects/ project_id/regions/region/addresses/address-name * Partial URL or by name, as in: - projects/project_id/regions/region/addresses/address-name - regions/region/addresses/address-name - global/addresses/address-name - address-name The forwarding rule's target or backendService, and in most cases, also the loadBalancingScheme, determine the type of IP address that you can use. For detailed information, see [IP address specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications). When reading an IPAddress, the API always returns the IP address number.
        # @!attribute [rw] I_p_protocol
        #   @return [::String]
        #     The IP protocol to which this rule applies. For protocol forwarding, valid options are TCP, UDP, ESP, AH, SCTP, ICMP and L3_DEFAULT. The valid IP protocols are different for different load balancing products as described in [Load balancing features](https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends).
        #     Check the IPProtocolEnum enum for the list of possible values.
        # @!attribute [rw] all_ports
        #   @return [::Boolean]
        #     The ports, portRange, and allPorts fields are mutually exclusive. Only packets addressed to ports in the specified range will be forwarded to the backends configured with this forwarding rule. The allPorts field has the following limitations: - It requires that the forwarding rule IPProtocol be TCP, UDP, SCTP, or L3_DEFAULT. - It's applicable only to the following products: internal passthrough Network Load Balancers, backend service-based external passthrough Network Load Balancers, and internal and external protocol forwarding. - Set this field to true to allow packets addressed to any port or packets lacking destination port information (for example, UDP fragments after the first fragment) to be forwarded to the backends configured with this forwarding rule. The L3_DEFAULT protocol requires allPorts be set to true.
        # @!attribute [rw] allow_global_access
        #   @return [::Boolean]
        #     If set to true, clients can access the internal passthrough Network Load Balancers, the regional internal Application Load Balancer, and the regional internal proxy Network Load Balancer from all regions. If false, only allows access from the local region the load balancer is located at. Note that for INTERNAL_MANAGED forwarding rules, this field cannot be changed after the forwarding rule is created.
        # @!attribute [rw] allow_psc_global_access
        #   @return [::Boolean]
        #     This is used in PSC consumer ForwardingRule to control whether the PSC endpoint can be accessed from another region.
        # @!attribute [rw] backend_service
        #   @return [::String]
        #     Identifies the backend service to which the forwarding rule sends traffic. Required for internal and external passthrough Network Load Balancers; must be omitted for all other load balancer types.
        # @!attribute [rw] base_forwarding_rule
        #   @return [::String]
        #     [Output Only] The URL for the corresponding base forwarding rule. By base forwarding rule, we mean the forwarding rule that has the same IP address, protocol, and port settings with the current forwarding rule, but without sourceIPRanges specified. Always empty if the current forwarding rule does not have sourceIPRanges specified.
        # @!attribute [rw] creation_timestamp
        #   @return [::String]
        #     [Output Only] Creation timestamp in RFC3339 text format.
        # @!attribute [rw] description
        #   @return [::String]
        #     An optional description of this resource. Provide this property when you create the resource.
        # @!attribute [rw] external_managed_backend_bucket_migration_state
        #   @return [::String]
        #     Specifies the canary migration state for the backend buckets attached to this forwarding rule. Possible values are PREPARE, TEST_BY_PERCENTAGE, and TEST_ALL_TRAFFIC. To begin the migration from EXTERNAL to EXTERNAL_MANAGED, the state must be changed to PREPARE. The state must be changed to TEST_ALL_TRAFFIC before the loadBalancingScheme can be changed to EXTERNAL_MANAGED. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate traffic to backend buckets attached to this forwarding rule by percentage using externalManagedBackendBucketMigrationTestingPercentage. Rolling back a migration requires the states to be set in reverse order. So changing the scheme from EXTERNAL_MANAGED to EXTERNAL requires the state to be set to TEST_ALL_TRAFFIC at the same time. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate some traffic back to EXTERNAL or PREPARE can be used to migrate all traffic back to EXTERNAL.
        #     Check the ExternalManagedBackendBucketMigrationState enum for the list of possible values.
        # @!attribute [rw] external_managed_backend_bucket_migration_testing_percentage
        #   @return [::Float]
        #     Determines the fraction of requests to backend buckets that should be processed by the global external Application Load Balancer. The value of this field must be in the range [0, 100]. This value can only be set if the loadBalancingScheme in the BackendService is set to EXTERNAL (when using the classic Application Load Balancer) and the migration state is TEST_BY_PERCENTAGE.
        # @!attribute [rw] fingerprint
        #   @return [::String]
        #     Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a ForwardingRule. Include the fingerprint in patch request to ensure that you do not overwrite changes that were applied from another concurrent request. To see the latest fingerprint, make a get() request to retrieve a ForwardingRule.
        # @!attribute [rw] id
        #   @return [::Integer]
        #     [Output Only] The unique identifier for the resource. This identifier is defined by the server.
        # @!attribute [rw] ip_collection
        #   @return [::String]
        #     Resource reference of a PublicDelegatedPrefix. The PDP must be a sub-PDP in EXTERNAL_IPV6_FORWARDING_RULE_CREATION mode. Use one of the following formats to specify a sub-PDP when creating an IPv6 NetLB forwarding rule using BYOIP: Full resource URL, as in https://www.googleapis.com/compute/v1/projects/project_id/regions/region /publicDelegatedPrefixes/sub-pdp-name Partial URL, as in: - projects/project_id/regions/region/publicDelegatedPrefixes/sub-pdp-name - regions/region/publicDelegatedPrefixes/sub-pdp-name
        # @!attribute [rw] ip_version
        #   @return [::String]
        #     The IP Version that will be used by this forwarding rule. Valid options are IPV4 or IPV6.
        #     Check the IpVersion enum for the list of possible values.
        # @!attribute [rw] is_mirroring_collector
        #   @return [::Boolean]
        #     Indicates whether or not this load balancer can be used as a collector for packet mirroring. To prevent mirroring loops, instances behind this load balancer will not have their traffic mirrored even if a PacketMirroring rule applies to them. This can only be set to true for load balancers that have their loadBalancingScheme set to INTERNAL.
        # @!attribute [rw] kind
        #   @return [::String]
        #     [Output Only] Type of the resource. Always compute#forwardingRule for forwarding rule resources.
        # @!attribute [rw] label_fingerprint
        #   @return [::String]
        #     A fingerprint for the labels being applied to this resource, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a ForwardingRule.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
        # @!attribute [rw] load_balancing_scheme
        #   @return [::String]
        #     Specifies the forwarding rule type. For more information about forwarding rules, refer to Forwarding rule concepts.
        #     Check the LoadBalancingScheme enum for the list of possible values.
        # @!attribute [rw] metadata_filters
        #   @return [::Array<::Google::Cloud::Compute::V1::MetadataFilter>]
        #     Opaque filter criteria used by load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to load balancer, xDS clients present node metadata. When there is a match, the relevant configuration is made available to those proxies. Otherwise, all the resources (e.g. TargetHttpProxy, UrlMap) referenced by the ForwardingRule are not visible to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadataFilters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here will be applifed before those specified in the UrlMap that this ForwardingRule references. metadataFilters only applies to Loadbalancers that have their loadBalancingScheme set to INTERNAL_SELF_MANAGED.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash. For Private Service Connect forwarding rules that forward traffic to Google APIs, the forwarding rule name must be a 1-20 characters string with lowercase letters and numbers and must start with a letter.
        # @!attribute [rw] network
        #   @return [::String]
        #     This field is not used for global external load balancing. For internal passthrough Network Load Balancers, this field identifies the network that the load balanced IP should belong to for this forwarding rule. If the subnetwork is specified, the network of the subnetwork will be used. If neither subnetwork nor this field is specified, the default network will be used. For Private Service Connect forwarding rules that forward traffic to Google APIs, a network must be provided.
        # @!attribute [rw] network_tier
        #   @return [::String]
        #     This signifies the networking tier used for configuring this load balancer and can only take the following values: PREMIUM, STANDARD. For regional ForwardingRule, the valid values are PREMIUM and STANDARD. For GlobalForwardingRule, the valid value is PREMIUM. If this field is not specified, it is assumed to be PREMIUM. If IPAddress is specified, this value must be equal to the networkTier of the Address.
        #     Check the NetworkTier enum for the list of possible values.
        # @!attribute [rw] no_automate_dns_zone
        #   @return [::Boolean]
        #     This is used in PSC consumer ForwardingRule to control whether it should try to auto-generate a DNS zone or not. Non-PSC forwarding rules do not use this field. Once set, this field is not mutable.
        # @!attribute [rw] port_range
        #   @return [::String]
        #     The ports, portRange, and allPorts fields are mutually exclusive. Only packets addressed to ports in the specified range will be forwarded to the backends configured with this forwarding rule. The portRange field has the following limitations: - It requires that the forwarding rule IPProtocol be TCP, UDP, or SCTP, and - It's applicable only to the following products: external passthrough Network Load Balancers, internal and external proxy Network Load Balancers, internal and external Application Load Balancers, external protocol forwarding, and Classic VPN. - Some products have restrictions on what ports can be used. See port specifications for details. For external forwarding rules, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot have overlapping portRanges. For internal forwarding rules within the same VPC network, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot have overlapping portRanges. @pattern: \\d+(?:-\\d+)?
        # @!attribute [rw] ports
        #   @return [::Array<::String>]
        #     The ports, portRange, and allPorts fields are mutually exclusive. Only packets addressed to ports in the specified range will be forwarded to the backends configured with this forwarding rule. The ports field has the following limitations: - It requires that the forwarding rule IPProtocol be TCP, UDP, or SCTP, and - It's applicable only to the following products: internal passthrough Network Load Balancers, backend service-based external passthrough Network Load Balancers, and internal protocol forwarding. - You can specify a list of up to five ports by number, separated by commas. The ports can be contiguous or discontiguous. For external forwarding rules, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair if they share at least one port number. For internal forwarding rules within the same VPC network, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair if they share at least one port number. @pattern: \\d+(?:-\\d+)?
        # @!attribute [rw] psc_connection_id
        #   @return [::Integer]
        #     [Output Only] The PSC connection id of the PSC forwarding rule.
        # @!attribute [rw] psc_connection_status
        #   @return [::String]
        #     Check the PscConnectionStatus enum for the list of possible values.
        # @!attribute [rw] region
        #   @return [::String]
        #     [Output Only] URL of the region where the regional forwarding rule resides. This field is not applicable to global forwarding rules. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
        # @!attribute [rw] self_link
        #   @return [::String]
        #     [Output Only] Server-defined URL for the resource.
        # @!attribute [rw] self_link_with_id
        #   @return [::String]
        #     [Output Only] Server-defined URL for this resource with the resource id.
        # @!attribute [rw] service_directory_registrations
        #   @return [::Array<::Google::Cloud::Compute::V1::ForwardingRuleServiceDirectoryRegistration>]
        #     Service Directory resources to register this forwarding rule with. Currently, only supports a single Service Directory resource.
        # @!attribute [rw] service_label
        #   @return [::String]
        #     An optional prefix to the service name for this forwarding rule. If specified, the prefix is the first label of the fully qualified service name. The label must be 1-63 characters long, and comply with RFC1035. Specifically, the label must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash. This field is only used for internal load balancing.
        # @!attribute [rw] service_name
        #   @return [::String]
        #     [Output Only] The internal fully qualified service name for this forwarding rule. This field is only used for internal load balancing.
        # @!attribute [rw] source_ip_ranges
        #   @return [::Array<::String>]
        #     If not empty, this forwarding rule will only forward the traffic when the source IP address matches one of the IP addresses or CIDR ranges set here. Note that a forwarding rule can only have up to 64 source IP ranges, and this field can only be used with a regional forwarding rule whose scheme is EXTERNAL. Each source_ip_range entry should be either an IP address (for example, 1.2.3.4) or a CIDR range (for example, 1.2.3.0/24).
        # @!attribute [rw] subnetwork
        #   @return [::String]
        #     This field identifies the subnetwork that the load balanced IP should belong to for this forwarding rule, used with internal load balancers and external passthrough Network Load Balancers with IPv6. If the network specified is in auto subnet mode, this field is optional. However, a subnetwork must be specified if the network is in custom subnet mode or when creating external forwarding rule with IPv6.
        # @!attribute [rw] target
        #   @return [::String]
        #     The URL of the target resource to receive the matched traffic. For regional forwarding rules, this target must be in the same region as the forwarding rule. For global forwarding rules, this target must be a global load balancing resource. The forwarded traffic must be of a type appropriate to the target object. - For load balancers, see the "Target" column in [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications). - For Private Service Connect forwarding rules that forward traffic to Google APIs, provide the name of a supported Google API bundle: - vpc-sc - APIs that support VPC Service Controls. - all-apis - All supported Google APIs. - For Private Service Connect forwarding rules that forward traffic to managed services, the target must be a service attachment. The target is not mutable once set as a service attachment.
        class ForwardingRule
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Specifies the canary migration state for the backend buckets attached to this forwarding rule. Possible values are PREPARE, TEST_BY_PERCENTAGE, and TEST_ALL_TRAFFIC. To begin the migration from EXTERNAL to EXTERNAL_MANAGED, the state must be changed to PREPARE. The state must be changed to TEST_ALL_TRAFFIC before the loadBalancingScheme can be changed to EXTERNAL_MANAGED. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate traffic to backend buckets attached to this forwarding rule by percentage using externalManagedBackendBucketMigrationTestingPercentage. Rolling back a migration requires the states to be set in reverse order. So changing the scheme from EXTERNAL_MANAGED to EXTERNAL requires the state to be set to TEST_ALL_TRAFFIC at the same time. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate some traffic back to EXTERNAL or PREPARE can be used to migrate all traffic back to EXTERNAL.
          module ExternalManagedBackendBucketMigrationState
            # A value indicating that the enum field is not set.
            UNDEFINED_EXTERNAL_MANAGED_BACKEND_BUCKET_MIGRATION_STATE = 0

            PREPARE = 399_612_135

            TEST_ALL_TRAFFIC = 79_728_882

            TEST_BY_PERCENTAGE = 513_738_389
          end

          # The IP protocol to which this rule applies. For protocol forwarding, valid options are TCP, UDP, ESP, AH, SCTP, ICMP and L3_DEFAULT. The valid IP protocols are different for different load balancing products as described in [Load balancing features](https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends).
          module IPProtocolEnum
            # A value indicating that the enum field is not set.
            UNDEFINED_I_P_PROTOCOL_ENUM = 0

            AH = 2087

            ESP = 68_962

            ICMP = 2_241_597

            L3_DEFAULT = 48_151_369

            SCTP = 2_539_724

            TCP = 82_881

            UDP = 83_873
          end

          # The IP Version that will be used by this forwarding rule. Valid options are IPV4 or IPV6.
          module IpVersion
            # A value indicating that the enum field is not set.
            UNDEFINED_IP_VERSION = 0

            IPV4 = 2_254_341

            IPV6 = 2_254_343

            UNSPECIFIED_VERSION = 21_850_000
          end

          # Specifies the forwarding rule type. For more information about forwarding rules, refer to Forwarding rule concepts.
          module LoadBalancingScheme
            # A value indicating that the enum field is not set.
            UNDEFINED_LOAD_BALANCING_SCHEME = 0

            EXTERNAL = 35_607_499

            EXTERNAL_MANAGED = 512_006_923

            INTERNAL = 279_295_677

            INTERNAL_MANAGED = 37_350_397

            INTERNAL_SELF_MANAGED = 236_211_150

            INVALID = 530_283_991
          end

          # This signifies the networking tier used for configuring this load balancer and can only take the following values: PREMIUM, STANDARD. For regional ForwardingRule, the valid values are PREMIUM and STANDARD. For GlobalForwardingRule, the valid value is PREMIUM. If this field is not specified, it is assumed to be PREMIUM. If IPAddress is specified, this value must be equal to the networkTier of the Address.
          module NetworkTier
            # A value indicating that the enum field is not set.
            UNDEFINED_NETWORK_TIER = 0

            # Public internet quality with fixed bandwidth.
            FIXED_STANDARD = 310_464_328

            # High quality, Google-grade network tier, support for all networking products.
            PREMIUM = 399_530_551

            # Public internet quality, only limited support for other networking products.
            STANDARD = 484_642_493

            # (Output only) Temporary tier for FIXED_STANDARD when fixed standard tier is expired or not configured.
            STANDARD_OVERRIDES_FIXED_STANDARD = 465_847_234
          end

          module PscConnectionStatus
            # A value indicating that the enum field is not set.
            UNDEFINED_PSC_CONNECTION_STATUS = 0

            # The connection has been accepted by the producer.
            ACCEPTED = 246_714_279

            # The connection has been closed by the producer and will not serve traffic going forward.
            CLOSED = 380_163_436

            # The connection has been accepted by the producer, but the producer needs to take further action before the forwarding rule can serve traffic.
            NEEDS_ATTENTION = 344_491_452

            # The connection is pending acceptance by the producer.
            PENDING = 35_394_935

            # The connection has been rejected by the producer.
            REJECTED = 174_130_302

            STATUS_UNSPECIFIED = 42_133_066
          end
        end

        # @!attribute [rw] id
        #   @return [::String]
        #     [Output Only] Unique identifier for the resource; defined by the server.
        # @!attribute [rw] items
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Compute::V1::ForwardingRulesScopedList}]
        #     A list of ForwardingRulesScopedList resources.
        # @!attribute [rw] kind
        #   @return [::String]
        #     [Output Only] Type of resource. Always compute#forwardingRuleAggregatedList for lists of forwarding rules.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
        # @!attribute [rw] self_link
        #   @return [::String]
        #     [Output Only] Server-defined URL for this resource.
        # @!attribute [rw] unreachables
        #   @return [::Array<::String>]
        #     [Output Only] Unreachable resources.
        # @!attribute [rw] warning
        #   @return [::Google::Cloud::Compute::V1::Warning]
        #     [Output Only] Informational warning message.
        class ForwardingRuleAggregatedList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Compute::V1::ForwardingRulesScopedList]
          class ItemsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Contains a list of ForwardingRule resources.
        # @!attribute [rw] id
        #   @return [::String]
        #     [Output Only] Unique identifier for the resource; defined by the server.
        # @!attribute [rw] items
        #   @return [::Array<::Google::Cloud::Compute::V1::ForwardingRule>]
        #     A list of ForwardingRule resources.
        # @!attribute [rw] kind
        #   @return [::String]
        #     Type of resource.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
        # @!attribute [rw] self_link
        #   @return [::String]
        #     [Output Only] Server-defined URL for this resource.
        # @!attribute [rw] warning
        #   @return [::Google::Cloud::Compute::V1::Warning]
        #     [Output Only] Informational warning message.
        class ForwardingRuleList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] forwarding_rule
        #   @return [::String]
        class ForwardingRuleReference
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Describes the auto-registration of the forwarding rule to Service Directory. The region and project of the Service Directory resource generated from this registration will be the same as this forwarding rule.
        # @!attribute [rw] namespace
        #   @return [::String]
        #     Service Directory namespace to register the forwarding rule under.
        # @!attribute [rw] service
        #   @return [::String]
        #     Service Directory service to register the forwarding rule under.
        # @!attribute [rw] service_directory_region
        #   @return [::String]
        #     [Optional] Service Directory region to register this global forwarding rule under. Default to "us-central1". Only used for PSC for Google APIs. All PSC for Google APIs forwarding rules on the same network should use the same Service Directory region.
        class ForwardingRuleServiceDirectoryRegistration
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] forwarding_rules
        #   @return [::Array<::Google::Cloud::Compute::V1::ForwardingRule>]
        #     A list of forwarding rules contained in this scope.
        # @!attribute [rw] warning
        #   @return [::Google::Cloud::Compute::V1::Warning]
        #     Informational warning which replaces the list of forwarding rules when the list is empty.
        class ForwardingRulesScopedList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] grpc_service_name
        #   @return [::String]
        #     The gRPC service name for the health check. This field is optional. The value of grpc_service_name has the following meanings by convention: - Empty service_name means the overall status of all services at the backend. - Non-empty service_name means the health of that gRPC service, as defined by the owner of the service. The grpc_service_name can only be ASCII.
        # @!attribute [rw] port
        #   @return [::Integer]
        #     The TCP port number to which the health check prober sends packets. Valid values are 1 through 65535.
        # @!attribute [rw] port_name
        #   @return [::String]
        #     Not supported.
        # @!attribute [rw] port_specification
        #   @return [::String]
        #     Specifies how a port is selected for health checking. Can be one of the following values: USE_FIXED_PORT: Specifies a port number explicitly using the port field in the health check. Supported by backend services for passthrough load balancers and backend services for proxy load balancers. Not supported by target pools. The health check supports all backends supported by the backend service provided the backend can be health checked. For example, GCE_VM_IP network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends. USE_NAMED_PORT: Not supported. USE_SERVING_PORT: Provides an indirect method of specifying the health check port by referring to the backend service. Only supported by backend services for proxy load balancers. Not supported by target pools. Not supported by backend services for passthrough load balancers. Supports all backends that can be health checked; for example, GCE_VM_IP_PORT network endpoint groups and instance group backends. For GCE_VM_IP_PORT network endpoint group backends, the health check uses the port number specified for each endpoint in the network endpoint group. For instance group backends, the health check uses the port number determined by looking up the backend service's named port in the instance group's list of named ports.
        #     Check the PortSpecification enum for the list of possible values.
        class GRPCHealthCheck
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Specifies how a port is selected for health checking. Can be one of the following values: USE_FIXED_PORT: Specifies a port number explicitly using the port field in the health check. Supported by backend services for passthrough load balancers and backend services for proxy load balancers. Not supported by target pools. The health check supports all backends supported by the backend service provided the backend can be health checked. For example, GCE_VM_IP network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends. USE_NAMED_PORT: Not supported. USE_SERVING_PORT: Provides an indirect method of specifying the health check port by referring to the backend service. Only supported by backend services for proxy load balancers. Not supported by target pools. Not supported by backend services for passthrough load balancers. Supports all backends that can be health checked; for example, GCE_VM_IP_PORT network endpoint groups and instance group backends. For GCE_VM_IP_PORT network endpoint group backends, the health check uses the port number specified for each endpoint in the network endpoint group. For instance group backends, the health check uses the port number determined by looking up the backend service's named port in the instance group's list of named ports.
          module PortSpecification
            # A value indicating that the enum field is not set.
            UNDEFINED_PORT_SPECIFICATION = 0

            # The port number in the health check's port is used for health checking. Applies to network endpoint group and instance group backends.
            USE_FIXED_PORT = 190_235_748

            # Not supported.
            USE_NAMED_PORT = 349_300_671

            # For network endpoint group backends, the health check uses the port number specified on each endpoint in the network endpoint group. For instance group backends, the health check uses the port number specified for the backend service's named port defined in the instance group's named ports.
            USE_SERVING_PORT = 362_637_516
          end
        end

        # A request message for AcceleratorTypes.Get. See the method description for details.
        # @!attribute [rw] accelerator_type
        #   @return [::String]
        #     Name of the accelerator type to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone for this request.
        class GetAcceleratorTypeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Addresses.Get. See the method description for details.
        # @!attribute [rw] address
        #   @return [::String]
        #     Name of the address resource to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region for this request.
        class GetAddressRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for FirewallPolicies.GetAssociation. See the method description for details.
        # @!attribute [rw] firewall_policy
        #   @return [::String]
        #     Name of the firewall policy to which the queried rule belongs.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the association to get from the firewall policy.
        class GetAssociationFirewallPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for NetworkFirewallPolicies.GetAssociation. See the method description for details.
        # @!attribute [rw] firewall_policy
        #   @return [::String]
        #     Name of the firewall policy to which the queried association belongs.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the association to get from the firewall policy.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        class GetAssociationNetworkFirewallPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionNetworkFirewallPolicies.GetAssociation. See the method description for details.
        # @!attribute [rw] firewall_policy
        #   @return [::String]
        #     Name of the firewall policy to which the queried association belongs.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the association to get from the firewall policy.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        class GetAssociationRegionNetworkFirewallPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Autoscalers.Get. See the method description for details.
        # @!attribute [rw] autoscaler
        #   @return [::String]
        #     Name of the autoscaler to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] zone
        #   @return [::String]
        #     Name of the zone for this request.
        class GetAutoscalerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for BackendBuckets.Get. See the method description for details.
        # @!attribute [rw] backend_bucket
        #   @return [::String]
        #     Name of the BackendBucket resource to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        class GetBackendBucketRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for BackendServices.Get. See the method description for details.
        # @!attribute [rw] backend_service
        #   @return [::String]
        #     Name of the BackendService resource to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        class GetBackendServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Interconnects.GetDiagnostics. See the method description for details.
        # @!attribute [rw] interconnect
        #   @return [::String]
        #     Name of the interconnect resource to query.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        class GetDiagnosticsInterconnectRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Disks.Get. See the method description for details.
        # @!attribute [rw] disk
        #   @return [::String]
        #     Name of the persistent disk to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone for this request.
        class GetDiskRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for DiskTypes.Get. See the method description for details.
        # @!attribute [rw] disk_type
        #   @return [::String]
        #     Name of the disk type to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone for this request.
        class GetDiskTypeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Instances.GetEffectiveFirewalls. See the method description for details.
        # @!attribute [rw] instance
        #   @return [::String]
        #     Name of the instance scoping this request.
        # @!attribute [rw] network_interface
        #   @return [::String]
        #     The name of the network interface to get the effective firewalls.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone for this request.
        class GetEffectiveFirewallsInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Networks.GetEffectiveFirewalls. See the method description for details.
        # @!attribute [rw] network
        #   @return [::String]
        #     Name of the network for this request.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        class GetEffectiveFirewallsNetworkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionNetworkFirewallPolicies.GetEffectiveFirewalls. See the method description for details.
        # @!attribute [rw] network
        #   @return [::String]
        #     Network reference
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        class GetEffectiveFirewallsRegionNetworkFirewallPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for ExternalVpnGateways.Get. See the method description for details.
        # @!attribute [rw] external_vpn_gateway
        #   @return [::String]
        #     Name of the externalVpnGateway to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        class GetExternalVpnGatewayRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for FirewallPolicies.Get. See the method description for details.
        # @!attribute [rw] firewall_policy
        #   @return [::String]
        #     Name of the firewall policy to get.
        class GetFirewallPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Firewalls.Get. See the method description for details.
        # @!attribute [rw] firewall
        #   @return [::String]
        #     Name of the firewall rule to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        class GetFirewallRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for ForwardingRules.Get. See the method description for details.
        # @!attribute [rw] forwarding_rule
        #   @return [::String]
        #     Name of the ForwardingRule resource to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        class GetForwardingRuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Images.GetFromFamily. See the method description for details.
        # @!attribute [rw] family
        #   @return [::String]
        #     Name of the image family to search for.
        # @!attribute [rw] project
        #   @return [::String]
        #     The image project that the image belongs to. For example, to get a CentOS image, specify centos-cloud as the image project.
        class GetFromFamilyImageRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for GlobalAddresses.Get. See the method description for details.
        # @!attribute [rw] address
        #   @return [::String]
        #     Name of the address resource to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        class GetGlobalAddressRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for GlobalForwardingRules.Get. See the method description for details.
        # @!attribute [rw] forwarding_rule
        #   @return [::String]
        #     Name of the ForwardingRule resource to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        class GetGlobalForwardingRuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for GlobalNetworkEndpointGroups.Get. See the method description for details.
        # @!attribute [rw] network_endpoint_group
        #   @return [::String]
        #     The name of the network endpoint group. It should comply with RFC1035.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        class GetGlobalNetworkEndpointGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for GlobalOperations.Get. See the method description for details.
        # @!attribute [rw] operation
        #   @return [::String]
        #     Name of the Operations resource to return, or its unique numeric identifier.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        class GetGlobalOperationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for GlobalOrganizationOperations.Get. See the method description for details.
        # @!attribute [rw] operation
        #   @return [::String]
        #     Name of the Operations resource to return. Parent is derived from this field.
        # @!attribute [rw] parent_id
        #   @return [::String]
        #     Parent ID for this request. Not used. Parent is derived from resource_id.
        class GetGlobalOrganizationOperationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for GlobalPublicDelegatedPrefixes.Get. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] public_delegated_prefix
        #   @return [::String]
        #     Name of the PublicDelegatedPrefix resource to return.
        class GetGlobalPublicDelegatedPrefixeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Instances.GetGuestAttributes. See the method description for details.
        # @!attribute [rw] instance
        #   @return [::String]
        #     Name of the instance scoping this request.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] query_path
        #   @return [::String]
        #     Specifies the guest attributes path to be queried.
        # @!attribute [rw] variable_key
        #   @return [::String]
        #     Specifies the key for the guest attributes entry.
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone for this request.
        class GetGuestAttributesInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for BackendServices.GetHealth. See the method description for details.
        # @!attribute [rw] backend_service
        #   @return [::String]
        #     Name of the BackendService resource to which the queried instance belongs.
        # @!attribute [rw] project
        #   @return [::String]
        # @!attribute [rw] resource_group_reference_resource
        #   @return [::Google::Cloud::Compute::V1::ResourceGroupReference]
        #     The body resource for this request
        class GetHealthBackendServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for HealthChecks.Get. See the method description for details.
        # @!attribute [rw] health_check
        #   @return [::String]
        #     Name of the HealthCheck resource to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        class GetHealthCheckRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionBackendServices.GetHealth. See the method description for details.
        # @!attribute [rw] backend_service
        #   @return [::String]
        #     Name of the BackendService resource for which to get health.
        # @!attribute [rw] project
        #   @return [::String]
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        # @!attribute [rw] resource_group_reference_resource
        #   @return [::Google::Cloud::Compute::V1::ResourceGroupReference]
        #     The body resource for this request
        class GetHealthRegionBackendServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for TargetPools.GetHealth. See the method description for details.
        # @!attribute [rw] instance_reference_resource
        #   @return [::Google::Cloud::Compute::V1::InstanceReference]
        #     The body resource for this request
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        # @!attribute [rw] target_pool
        #   @return [::String]
        #     Name of the TargetPool resource to which the queried instance belongs.
        class GetHealthTargetPoolRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for BackendBuckets.GetIamPolicy. See the method description for details.
        # @!attribute [rw] options_requested_policy_version
        #   @return [::Integer]
        #     Requested IAM Policy version.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] resource
        #   @return [::String]
        #     Name or id of the resource for this request.
        class GetIamPolicyBackendBucketRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for BackendServices.GetIamPolicy. See the method description for details.
        # @!attribute [rw] options_requested_policy_version
        #   @return [::Integer]
        #     Requested IAM Policy version.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] resource
        #   @return [::String]
        #     Name or id of the resource for this request.
        class GetIamPolicyBackendServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Disks.GetIamPolicy. See the method description for details.
        # @!attribute [rw] options_requested_policy_version
        #   @return [::Integer]
        #     Requested IAM Policy version.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] resource
        #   @return [::String]
        #     Name or id of the resource for this request.
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone for this request.
        class GetIamPolicyDiskRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for FirewallPolicies.GetIamPolicy. See the method description for details.
        # @!attribute [rw] options_requested_policy_version
        #   @return [::Integer]
        #     Requested IAM Policy version.
        # @!attribute [rw] resource
        #   @return [::String]
        #     Name or id of the resource for this request.
        class GetIamPolicyFirewallPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Images.GetIamPolicy. See the method description for details.
        # @!attribute [rw] options_requested_policy_version
        #   @return [::Integer]
        #     Requested IAM Policy version.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] resource
        #   @return [::String]
        #     Name or id of the resource for this request.
        class GetIamPolicyImageRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Instances.GetIamPolicy. See the method description for details.
        # @!attribute [rw] options_requested_policy_version
        #   @return [::Integer]
        #     Requested IAM Policy version.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] resource
        #   @return [::String]
        #     Name or id of the resource for this request.
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone for this request.
        class GetIamPolicyInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for InstanceTemplates.GetIamPolicy. See the method description for details.
        # @!attribute [rw] options_requested_policy_version
        #   @return [::Integer]
        #     Requested IAM Policy version.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] resource
        #   @return [::String]
        #     Name or id of the resource for this request.
        class GetIamPolicyInstanceTemplateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for InstantSnapshots.GetIamPolicy. See the method description for details.
        # @!attribute [rw] options_requested_policy_version
        #   @return [::Integer]
        #     Requested IAM Policy version.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] resource
        #   @return [::String]
        #     Name or id of the resource for this request.
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone for this request.
        class GetIamPolicyInstantSnapshotRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for InterconnectAttachmentGroups.GetIamPolicy. See the method description for details.
        # @!attribute [rw] options_requested_policy_version
        #   @return [::Integer]
        #     Requested IAM Policy version.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] resource
        #   @return [::String]
        #     Name or id of the resource for this request.
        class GetIamPolicyInterconnectAttachmentGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for InterconnectGroups.GetIamPolicy. See the method description for details.
        # @!attribute [rw] options_requested_policy_version
        #   @return [::Integer]
        #     Requested IAM Policy version.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] resource
        #   @return [::String]
        #     Name or id of the resource for this request.
        class GetIamPolicyInterconnectGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Licenses.GetIamPolicy. See the method description for details.
        # @!attribute [rw] options_requested_policy_version
        #   @return [::Integer]
        #     Requested IAM Policy version.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] resource
        #   @return [::String]
        #     Name or id of the resource for this request.
        class GetIamPolicyLicenseRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for MachineImages.GetIamPolicy. See the method description for details.
        # @!attribute [rw] options_requested_policy_version
        #   @return [::Integer]
        #     Requested IAM Policy version.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] resource
        #   @return [::String]
        #     Name or id of the resource for this request.
        class GetIamPolicyMachineImageRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for NetworkAttachments.GetIamPolicy. See the method description for details.
        # @!attribute [rw] options_requested_policy_version
        #   @return [::Integer]
        #     Requested IAM Policy version.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     The name of the region for this request.
        # @!attribute [rw] resource
        #   @return [::String]
        #     Name or id of the resource for this request.
        class GetIamPolicyNetworkAttachmentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for NetworkFirewallPolicies.GetIamPolicy. See the method description for details.
        # @!attribute [rw] options_requested_policy_version
        #   @return [::Integer]
        #     Requested IAM Policy version.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] resource
        #   @return [::String]
        #     Name or id of the resource for this request.
        class GetIamPolicyNetworkFirewallPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for NodeGroups.GetIamPolicy. See the method description for details.
        # @!attribute [rw] options_requested_policy_version
        #   @return [::Integer]
        #     Requested IAM Policy version.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] resource
        #   @return [::String]
        #     Name or id of the resource for this request.
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone for this request.
        class GetIamPolicyNodeGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for NodeTemplates.GetIamPolicy. See the method description for details.
        # @!attribute [rw] options_requested_policy_version
        #   @return [::Integer]
        #     Requested IAM Policy version.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     The name of the region for this request.
        # @!attribute [rw] resource
        #   @return [::String]
        #     Name or id of the resource for this request.
        class GetIamPolicyNodeTemplateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionBackendServices.GetIamPolicy. See the method description for details.
        # @!attribute [rw] options_requested_policy_version
        #   @return [::Integer]
        #     Requested IAM Policy version.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     The name of the region for this request.
        # @!attribute [rw] resource
        #   @return [::String]
        #     Name or id of the resource for this request.
        class GetIamPolicyRegionBackendServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionDisks.GetIamPolicy. See the method description for details.
        # @!attribute [rw] options_requested_policy_version
        #   @return [::Integer]
        #     Requested IAM Policy version.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     The name of the region for this request.
        # @!attribute [rw] resource
        #   @return [::String]
        #     Name or id of the resource for this request.
        class GetIamPolicyRegionDiskRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionInstantSnapshots.GetIamPolicy. See the method description for details.
        # @!attribute [rw] options_requested_policy_version
        #   @return [::Integer]
        #     Requested IAM Policy version.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     The name of the region for this request.
        # @!attribute [rw] resource
        #   @return [::String]
        #     Name or id of the resource for this request.
        class GetIamPolicyRegionInstantSnapshotRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionNetworkFirewallPolicies.GetIamPolicy. See the method description for details.
        # @!attribute [rw] options_requested_policy_version
        #   @return [::Integer]
        #     Requested IAM Policy version.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     The name of the region for this request.
        # @!attribute [rw] resource
        #   @return [::String]
        #     Name or id of the resource for this request.
        class GetIamPolicyRegionNetworkFirewallPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Reservations.GetIamPolicy. See the method description for details.
        # @!attribute [rw] options_requested_policy_version
        #   @return [::Integer]
        #     Requested IAM Policy version.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] resource
        #   @return [::String]
        #     Name or id of the resource for this request.
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone for this request.
        class GetIamPolicyReservationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for ResourcePolicies.GetIamPolicy. See the method description for details.
        # @!attribute [rw] options_requested_policy_version
        #   @return [::Integer]
        #     Requested IAM Policy version.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     The name of the region for this request.
        # @!attribute [rw] resource
        #   @return [::String]
        #     Name or id of the resource for this request.
        class GetIamPolicyResourcePolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for ServiceAttachments.GetIamPolicy. See the method description for details.
        # @!attribute [rw] options_requested_policy_version
        #   @return [::Integer]
        #     Requested IAM Policy version.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     The name of the region for this request.
        # @!attribute [rw] resource
        #   @return [::String]
        #     Name or id of the resource for this request.
        class GetIamPolicyServiceAttachmentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Snapshots.GetIamPolicy. See the method description for details.
        # @!attribute [rw] options_requested_policy_version
        #   @return [::Integer]
        #     Requested IAM Policy version.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] resource
        #   @return [::String]
        #     Name or id of the resource for this request.
        class GetIamPolicySnapshotRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for StoragePools.GetIamPolicy. See the method description for details.
        # @!attribute [rw] options_requested_policy_version
        #   @return [::Integer]
        #     Requested IAM Policy version.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] resource
        #   @return [::String]
        #     Name or id of the resource for this request.
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone for this request.
        class GetIamPolicyStoragePoolRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Subnetworks.GetIamPolicy. See the method description for details.
        # @!attribute [rw] options_requested_policy_version
        #   @return [::Integer]
        #     Requested IAM Policy version.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     The name of the region for this request.
        # @!attribute [rw] resource
        #   @return [::String]
        #     Name or id of the resource for this request.
        class GetIamPolicySubnetworkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for ImageFamilyViews.Get. See the method description for details.
        # @!attribute [rw] family
        #   @return [::String]
        #     Name of the image family to search for.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone for this request.
        class GetImageFamilyViewRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Images.Get. See the method description for details.
        # @!attribute [rw] image
        #   @return [::String]
        #     Name of the image resource to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        class GetImageRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for InstanceGroupManagers.Get. See the method description for details.
        # @!attribute [rw] instance_group_manager
        #   @return [::String]
        #     The name of the managed instance group.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone where the managed instance group is located.
        class GetInstanceGroupManagerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for InstanceGroupManagerResizeRequests.Get. See the method description for details.
        # @!attribute [rw] instance_group_manager
        #   @return [::String]
        #     The name of the managed instance group. Name should conform to RFC1035 or be a resource ID.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] resize_request
        #   @return [::String]
        #     The name of the resize request. Name should conform to RFC1035 or be a resource ID.
        # @!attribute [rw] zone
        #   @return [::String]
        #     Name of the href="/compute/docs/regions-zones/#available">zone scoping this request. Name should conform to RFC1035.
        class GetInstanceGroupManagerResizeRequestRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for InstanceGroups.Get. See the method description for details.
        # @!attribute [rw] instance_group
        #   @return [::String]
        #     The name of the instance group.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone where the instance group is located.
        class GetInstanceGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Instances.Get. See the method description for details.
        # @!attribute [rw] instance
        #   @return [::String]
        #     Name of the instance resource to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone for this request.
        class GetInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for InstanceSettingsService.Get. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] zone
        #   @return [::String]
        #     Name of the zone for this request.
        class GetInstanceSettingRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for InstanceTemplates.Get. See the method description for details.
        # @!attribute [rw] instance_template
        #   @return [::String]
        #     The name of the instance template.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        class GetInstanceTemplateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for InstantSnapshots.Get. See the method description for details.
        # @!attribute [rw] instant_snapshot
        #   @return [::String]
        #     Name of the InstantSnapshot resource to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone for this request.
        class GetInstantSnapshotRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for InterconnectAttachmentGroups.Get. See the method description for details.
        # @!attribute [rw] interconnect_attachment_group
        #   @return [::String]
        #     Name of the InterconnectAttachmentGroup resource to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        class GetInterconnectAttachmentGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for InterconnectAttachments.Get. See the method description for details.
        # @!attribute [rw] interconnect_attachment
        #   @return [::String]
        #     Name of the interconnect attachment to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region for this request.
        class GetInterconnectAttachmentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for InterconnectGroups.Get. See the method description for details.
        # @!attribute [rw] interconnect_group
        #   @return [::String]
        #     Name of the InterconnectGroup resource to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        class GetInterconnectGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for InterconnectLocations.Get. See the method description for details.
        # @!attribute [rw] interconnect_location
        #   @return [::String]
        #     Name of the interconnect location to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        class GetInterconnectLocationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for InterconnectRemoteLocations.Get. See the method description for details.
        # @!attribute [rw] interconnect_remote_location
        #   @return [::String]
        #     Name of the interconnect remote location to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        class GetInterconnectRemoteLocationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Interconnects.Get. See the method description for details.
        # @!attribute [rw] interconnect
        #   @return [::String]
        #     Name of the interconnect to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        class GetInterconnectRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for LicenseCodes.Get. See the method description for details.
        # @!attribute [rw] license_code
        #   @return [::String]
        #     Number corresponding to the License code resource to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        class GetLicenseCodeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Licenses.Get. See the method description for details.
        # @!attribute [rw] license
        #   @return [::String]
        #     Name of the License resource to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        class GetLicenseRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for MachineImages.Get. See the method description for details.
        # @!attribute [rw] machine_image
        #   @return [::String]
        #     The name of the machine image.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        class GetMachineImageRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for MachineTypes.Get. See the method description for details.
        # @!attribute [rw] machine_type
        #   @return [::String]
        #     Name of the machine type to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone for this request.
        class GetMachineTypeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Interconnects.GetMacsecConfig. See the method description for details.
        # @!attribute [rw] interconnect
        #   @return [::String]
        #     Name of the interconnect resource to query.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        class GetMacsecConfigInterconnectRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Routers.GetNatIpInfo. See the method description for details.
        # @!attribute [rw] nat_name
        #   @return [::String]
        #     Name of the nat service to filter the NAT IP information. If it is omitted, all nats for this router will be returned. Name should conform to RFC1035.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region for this request.
        # @!attribute [rw] router
        #   @return [::String]
        #     Name of the Router resource to query for Nat IP information. The name should conform to RFC1035.
        class GetNatIpInfoRouterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Routers.GetNatMappingInfo. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] nat_name
        #   @return [::String]
        #     Name of the nat service to filter the Nat Mapping information. If it is omitted, all nats for this router will be returned. Name should conform to RFC1035.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region for this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        # @!attribute [rw] router
        #   @return [::String]
        #     Name of the Router resource to query for Nat Mapping information of VM endpoints.
        class GetNatMappingInfoRoutersRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for NetworkAttachments.Get. See the method description for details.
        # @!attribute [rw] network_attachment
        #   @return [::String]
        #     Name of the NetworkAttachment resource to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region of this request.
        class GetNetworkAttachmentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for NetworkEdgeSecurityServices.Get. See the method description for details.
        # @!attribute [rw] network_edge_security_service
        #   @return [::String]
        #     Name of the network edge security service to get.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        class GetNetworkEdgeSecurityServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for NetworkEndpointGroups.Get. See the method description for details.
        # @!attribute [rw] network_endpoint_group
        #   @return [::String]
        #     The name of the network endpoint group. It should comply with RFC1035.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone where the network endpoint group is located. It should comply with RFC1035.
        class GetNetworkEndpointGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for NetworkFirewallPolicies.Get. See the method description for details.
        # @!attribute [rw] firewall_policy
        #   @return [::String]
        #     Name of the firewall policy to get.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        class GetNetworkFirewallPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for NetworkProfiles.Get. See the method description for details.
        # @!attribute [rw] network_profile
        #   @return [::String]
        #     Name of the network profile to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        class GetNetworkProfileRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Networks.Get. See the method description for details.
        # @!attribute [rw] network
        #   @return [::String]
        #     Name of the network to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        class GetNetworkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for NodeGroups.Get. See the method description for details.
        # @!attribute [rw] node_group
        #   @return [::String]
        #     Name of the node group to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone for this request.
        class GetNodeGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for NodeTemplates.Get. See the method description for details.
        # @!attribute [rw] node_template
        #   @return [::String]
        #     Name of the node template to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     The name of the region for this request.
        class GetNodeTemplateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for NodeTypes.Get. See the method description for details.
        # @!attribute [rw] node_type
        #   @return [::String]
        #     Name of the node type to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone for this request.
        class GetNodeTypeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for InterconnectAttachmentGroups.GetOperationalStatus. See the method description for details.
        # @!attribute [rw] interconnect_attachment_group
        #   @return [::String]
        #     Name of the interconnectAttachmentGroup resource to query.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        class GetOperationalStatusInterconnectAttachmentGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for InterconnectGroups.GetOperationalStatus. See the method description for details.
        # @!attribute [rw] interconnect_group
        #   @return [::String]
        #     Name of the interconnectGroup resource to query.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        class GetOperationalStatusInterconnectGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for PacketMirrorings.Get. See the method description for details.
        # @!attribute [rw] packet_mirroring
        #   @return [::String]
        #     Name of the PacketMirroring resource to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region for this request.
        class GetPacketMirroringRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for NetworkFirewallPolicies.GetPacketMirroringRule. See the method description for details.
        # @!attribute [rw] firewall_policy
        #   @return [::String]
        #     Name of the firewall policy to which the queried rule belongs.
        # @!attribute [rw] priority
        #   @return [::Integer]
        #     The priority of the rule to get from the firewall policy.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        class GetPacketMirroringRuleNetworkFirewallPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Projects.Get. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        class GetProjectRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for PublicAdvertisedPrefixes.Get. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] public_advertised_prefix
        #   @return [::String]
        #     Name of the PublicAdvertisedPrefix resource to return.
        class GetPublicAdvertisedPrefixeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for PublicDelegatedPrefixes.Get. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] public_delegated_prefix
        #   @return [::String]
        #     Name of the PublicDelegatedPrefix resource to return.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region of this request.
        class GetPublicDelegatedPrefixeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionAutoscalers.Get. See the method description for details.
        # @!attribute [rw] autoscaler
        #   @return [::String]
        #     Name of the autoscaler to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        class GetRegionAutoscalerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionBackendServices.Get. See the method description for details.
        # @!attribute [rw] backend_service
        #   @return [::String]
        #     Name of the BackendService resource to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        class GetRegionBackendServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionCommitments.Get. See the method description for details.
        # @!attribute [rw] commitment
        #   @return [::String]
        #     Name of the commitment to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region for this request.
        class GetRegionCommitmentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionDisks.Get. See the method description for details.
        # @!attribute [rw] disk
        #   @return [::String]
        #     Name of the regional persistent disk to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region for this request.
        class GetRegionDiskRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionDiskTypes.Get. See the method description for details.
        # @!attribute [rw] disk_type
        #   @return [::String]
        #     Name of the disk type to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     The name of the region for this request.
        class GetRegionDiskTypeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionHealthChecks.Get. See the method description for details.
        # @!attribute [rw] health_check
        #   @return [::String]
        #     Name of the HealthCheck resource to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        class GetRegionHealthCheckRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionHealthCheckServices.Get. See the method description for details.
        # @!attribute [rw] health_check_service
        #   @return [::String]
        #     Name of the HealthCheckService to update. The name must be 1-63 characters long, and comply with RFC1035.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        class GetRegionHealthCheckServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionInstanceGroupManagers.Get. See the method description for details.
        # @!attribute [rw] instance_group_manager
        #   @return [::String]
        #     Name of the managed instance group to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        class GetRegionInstanceGroupManagerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionInstanceGroups.Get. See the method description for details.
        # @!attribute [rw] instance_group
        #   @return [::String]
        #     Name of the instance group resource to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        class GetRegionInstanceGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionInstanceTemplates.Get. See the method description for details.
        # @!attribute [rw] instance_template
        #   @return [::String]
        #     The name of the instance template.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     The name of the region for this request.
        class GetRegionInstanceTemplateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionInstantSnapshots.Get. See the method description for details.
        # @!attribute [rw] instant_snapshot
        #   @return [::String]
        #     Name of the InstantSnapshot resource to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     The name of the region for this request.
        class GetRegionInstantSnapshotRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionNetworkEndpointGroups.Get. See the method description for details.
        # @!attribute [rw] network_endpoint_group
        #   @return [::String]
        #     The name of the network endpoint group. It should comply with RFC1035.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     The name of the region where the network endpoint group is located. It should comply with RFC1035.
        class GetRegionNetworkEndpointGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionNetworkFirewallPolicies.Get. See the method description for details.
        # @!attribute [rw] firewall_policy
        #   @return [::String]
        #     Name of the firewall policy to get.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        class GetRegionNetworkFirewallPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionNotificationEndpoints.Get. See the method description for details.
        # @!attribute [rw] notification_endpoint
        #   @return [::String]
        #     Name of the NotificationEndpoint resource to return.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        class GetRegionNotificationEndpointRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionOperations.Get. See the method description for details.
        # @!attribute [rw] operation
        #   @return [::String]
        #     Name of the Operations resource to return, or its unique numeric identifier.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region for this request.
        class GetRegionOperationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Regions.Get. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region resource to return.
        class GetRegionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionSecurityPolicies.Get. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        # @!attribute [rw] security_policy
        #   @return [::String]
        #     Name of the security policy to get.
        class GetRegionSecurityPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionSslCertificates.Get. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        # @!attribute [rw] ssl_certificate
        #   @return [::String]
        #     Name of the SslCertificate resource to return.
        class GetRegionSslCertificateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionSslPolicies.Get. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        # @!attribute [rw] ssl_policy
        #   @return [::String]
        #     Name of the SSL policy to update. The name must be 1-63 characters long, and comply with RFC1035.
        class GetRegionSslPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionTargetHttpProxies.Get. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        # @!attribute [rw] target_http_proxy
        #   @return [::String]
        #     Name of the TargetHttpProxy resource to return.
        class GetRegionTargetHttpProxyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionTargetHttpsProxies.Get. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        # @!attribute [rw] target_https_proxy
        #   @return [::String]
        #     Name of the TargetHttpsProxy resource to return.
        class GetRegionTargetHttpsProxyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionTargetTcpProxies.Get. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        # @!attribute [rw] target_tcp_proxy
        #   @return [::String]
        #     Name of the TargetTcpProxy resource to return.
        class GetRegionTargetTcpProxyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionUrlMaps.Get. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        # @!attribute [rw] url_map
        #   @return [::String]
        #     Name of the UrlMap resource to return.
        class GetRegionUrlMapRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for ReservationBlocks.Get. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] reservation
        #   @return [::String]
        #     The name of the reservation. Name should conform to RFC1035 or be a resource ID.
        # @!attribute [rw] reservation_block
        #   @return [::String]
        #     The name of the reservation block. Name should conform to RFC1035 or be a resource ID.
        # @!attribute [rw] view
        #   @return [::String]
        #     View of the Block.
        #     Check the View enum for the list of possible values.
        # @!attribute [rw] zone
        #   @return [::String]
        #     Name of the zone for this request. Zone name should conform to RFC1035.
        class GetReservationBlockRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # View of the Block.
          module View
            # A value indicating that the enum field is not set.
            UNDEFINED_VIEW = 0

            # This view includes basic information about the reservation block
            BASIC = 62_970_894

            # The default / unset value. The API will default to the BASIC view.
            BLOCK_VIEW_UNSPECIFIED = 275_070_479

            # Includes detailed topology view.
            FULL = 2_169_487
          end
        end

        # A request message for Reservations.Get. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] reservation
        #   @return [::String]
        #     Name of the reservation to retrieve.
        # @!attribute [rw] zone
        #   @return [::String]
        #     Name of the zone for this request.
        class GetReservationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for ReservationSubBlocks.Get. See the method description for details.
        # @!attribute [rw] parent_name
        #   @return [::String]
        #     The name of the parent reservation and parent block. In the format of reservations/\\{reservation_name}/reservationBlocks/\\{reservation_block_name}
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] reservation_sub_block
        #   @return [::String]
        #     The name of the reservation subBlock. Name should conform to RFC1035 or be a resource ID.
        # @!attribute [rw] zone
        #   @return [::String]
        #     Name of the zone for this request. Zone name should conform to RFC1035.
        class GetReservationSubBlockRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for ResourcePolicies.Get. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region for this request.
        # @!attribute [rw] resource_policy
        #   @return [::String]
        #     Name of the resource policy to retrieve.
        class GetResourcePolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Routers.GetRoutePolicy. See the method description for details.
        # @!attribute [rw] policy
        #   @return [::String]
        #     The Policy name for this request. Name must conform to RFC1035
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region for this request.
        # @!attribute [rw] router
        #   @return [::String]
        #     Name of the Router resource to query for the route policy. The name should conform to RFC1035.
        class GetRoutePolicyRouterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Routes.Get. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] route
        #   @return [::String]
        #     Name of the Route resource to return.
        class GetRouteRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Routers.Get. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region for this request.
        # @!attribute [rw] router
        #   @return [::String]
        #     Name of the Router resource to return.
        class GetRouterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Routers.GetRouterStatus. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region for this request.
        # @!attribute [rw] router
        #   @return [::String]
        #     Name of the Router resource to query.
        class GetRouterStatusRouterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for FirewallPolicies.GetRule. See the method description for details.
        # @!attribute [rw] firewall_policy
        #   @return [::String]
        #     Name of the firewall policy to which the queried rule belongs.
        # @!attribute [rw] priority
        #   @return [::Integer]
        #     The priority of the rule to get from the firewall policy.
        class GetRuleFirewallPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for NetworkFirewallPolicies.GetRule. See the method description for details.
        # @!attribute [rw] firewall_policy
        #   @return [::String]
        #     Name of the firewall policy to which the queried rule belongs.
        # @!attribute [rw] priority
        #   @return [::Integer]
        #     The priority of the rule to get from the firewall policy.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        class GetRuleNetworkFirewallPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionNetworkFirewallPolicies.GetRule. See the method description for details.
        # @!attribute [rw] firewall_policy
        #   @return [::String]
        #     Name of the firewall policy to which the queried rule belongs.
        # @!attribute [rw] priority
        #   @return [::Integer]
        #     The priority of the rule to get from the firewall policy.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        class GetRuleRegionNetworkFirewallPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for RegionSecurityPolicies.GetRule. See the method description for details.
        # @!attribute [rw] priority
        #   @return [::Integer]
        #     The priority of the rule to get from the security policy.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        # @!attribute [rw] security_policy
        #   @return [::String]
        #     Name of the security policy to which the queried rule belongs.
        class GetRuleRegionSecurityPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for SecurityPolicies.GetRule. See the method description for details.
        # @!attribute [rw] priority
        #   @return [::Integer]
        #     The priority of the rule to get from the security policy.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] security_policy
        #   @return [::String]
        #     Name of the security policy to which the queried rule belongs.
        class GetRuleSecurityPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Instances.GetScreenshot. See the method description for details.
        # @!attribute [rw] instance
        #   @return [::String]
        #     Name of the instance scoping this request.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone for this request.
        class GetScreenshotInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for SecurityPolicies.Get. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] security_policy
        #   @return [::String]
        #     Name of the security policy to get.
        class GetSecurityPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Instances.GetSerialPortOutput. See the method description for details.
        # @!attribute [rw] instance
        #   @return [::String]
        #     Name of the instance for this request.
        # @!attribute [rw] port
        #   @return [::Integer]
        #     Specifies which COM or serial port to retrieve data from.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] start
        #   @return [::Integer]
        #     Specifies the starting byte position of the output to return. To start with the first byte of output to the specified port, omit this field or set it to `0`. If the output for that byte position is available, this field matches the `start` parameter sent with the request. If the amount of serial console output exceeds the size of the buffer (1 MB), the oldest output is discarded and is no longer available. If the requested start position refers to discarded output, the start position is adjusted to the oldest output still available, and the adjusted start position is returned as the `start` property value. You can also provide a negative start position, which translates to the most recent number of bytes written to the serial port. For example, -3 is interpreted as the most recent 3 bytes written to the serial console. Note that the negative start is bounded by the retained buffer size, and the returned serial console output will not exceed the max buffer size.
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone for this request.
        class GetSerialPortOutputInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for ServiceAttachments.Get. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region of this request.
        # @!attribute [rw] service_attachment
        #   @return [::String]
        #     Name of the ServiceAttachment resource to return.
        # @!attribute [rw] show_nat_ips
        #   @return [::Boolean]
        #     Indicates whether NAT IPs should be included in the response.
        class GetServiceAttachmentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Instances.GetShieldedInstanceIdentity. See the method description for details.
        # @!attribute [rw] instance
        #   @return [::String]
        #     Name or id of the instance scoping this request.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone for this request.
        class GetShieldedInstanceIdentityInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Snapshots.Get. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] snapshot
        #   @return [::String]
        #     Name of the Snapshot resource to return.
        class GetSnapshotRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for SnapshotSettingsService.Get. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        class GetSnapshotSettingRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for SslCertificates.Get. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] ssl_certificate
        #   @return [::String]
        #     Name of the SslCertificate resource to return.
        class GetSslCertificateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for SslPolicies.Get. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] ssl_policy
        #   @return [::String]
        #     Name of the SSL policy to update. The name must be 1-63 characters long, and comply with RFC1035.
        class GetSslPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for VpnGateways.GetStatus. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region for this request.
        # @!attribute [rw] vpn_gateway
        #   @return [::String]
        #     Name of the VPN gateway to return.
        class GetStatusVpnGatewayRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for StoragePools.Get. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] storage_pool
        #   @return [::String]
        #     Name of the storage pool to return.
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone for this request.
        class GetStoragePoolRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for StoragePoolTypes.Get. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] storage_pool_type
        #   @return [::String]
        #     Name of the storage pool type to return.
        # @!attribute [rw] zone
        #   @return [::String]
        #     The name of the zone for this request.
        class GetStoragePoolTypeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Subnetworks.Get. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        # @!attribute [rw] subnetwork
        #   @return [::String]
        #     Name of the Subnetwork resource to return.
        class GetSubnetworkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for TargetGrpcProxies.Get. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] target_grpc_proxy
        #   @return [::String]
        #     Name of the TargetGrpcProxy resource to return.
        class GetTargetGrpcProxyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for TargetHttpProxies.Get. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] target_http_proxy
        #   @return [::String]
        #     Name of the TargetHttpProxy resource to return.
        class GetTargetHttpProxyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for TargetHttpsProxies.Get. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] target_https_proxy
        #   @return [::String]
        #     Name of the TargetHttpsProxy resource to return.
        class GetTargetHttpsProxyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for TargetInstances.Get. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] target_instance
        #   @return [::String]
        #     Name of the TargetInstance resource to return.
        # @!attribute [rw] zone
        #   @return [::String]
        #     Name of the zone scoping this request.
        class GetTargetInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for TargetPools.Get. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region scoping this request.
        # @!attribute [rw] target_pool
        #   @return [::String]
        #     Name of the TargetPool resource to return.
        class GetTargetPoolRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for TargetSslProxies.Get. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] target_ssl_proxy
        #   @return [::String]
        #     Name of the TargetSslProxy resource to return.
        class GetTargetSslProxyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for TargetTcpProxies.Get. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] target_tcp_proxy
        #   @return [::String]
        #     Name of the TargetTcpProxy resource to return.
        class GetTargetTcpProxyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for TargetVpnGateways.Get. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region for this request.
        # @!attribute [rw] target_vpn_gateway
        #   @return [::String]
        #     Name of the target VPN gateway to return.
        class GetTargetVpnGatewayRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for UrlMaps.Get. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] url_map
        #   @return [::String]
        #     Name of the UrlMap resource to return.
        class GetUrlMapRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for VpnGateways.Get. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region for this request.
        # @!attribute [rw] vpn_gateway
        #   @return [::String]
        #     Name of the VPN gateway to return.
        class GetVpnGatewayRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for VpnTunnels.Get. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] region
        #   @return [::String]
        #     Name of the region for this request.
        # @!attribute [rw] vpn_tunnel
        #   @return [::String]
        #     Name of the VpnTunnel resource to return.
        class GetVpnTunnelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Projects.GetXpnHost. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        class GetXpnHostProjectRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Projects.GetXpnResources. See the method description for details.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
        class GetXpnResourcesProjectsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for ZoneOperations.Get. See the method description for details.
        # @!attribute [rw] operation
        #   @return [::String]
        #     Name of the Operations resource to return, or its unique numeric identifier.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] zone
        #   @return [::String]
        #     Name of the zone for this request.
        class GetZoneOperationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for Zones.Get. See the method description for details.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project ID for this request.
        # @!attribute [rw] zone
        #   @return [::String]
        #     Name of the zone resource to return.
        class GetZoneRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] description
        #   @return [::String]
        #     An optional destination address description if intended to be different from the source.
        # @!attribute [rw] destination_address
        #   @return [::String]
        #     The URL of the destination address to move to. This can be a full or partial URL. For example, the following are all valid URLs to a address: - https://www.googleapis.com/compute/v1/projects/project /global/addresses/address - projects/project/global/addresses/address Note that destination project must be different from the source project. So /global/addresses/address is not valid partial url.
        class GlobalAddressesMoveRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] network_endpoints
        #   @return [::Array<::Google::Cloud::Compute::V1::NetworkEndpoint>]
        #     The list of network endpoints to be attached.
        class GlobalNetworkEndpointGroupsAttachEndpointsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] network_endpoints
        #   @return [::Array<::Google::Cloud::Compute::V1::NetworkEndpoint>]
        #     The list of network endpoints to be detached.
        class GlobalNetworkEndpointGroupsDetachEndpointsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] bindings
        #   @return [::Array<::Google::Cloud::Compute::V1::Binding>]
        #     Flatten Policy to create a backward compatible wire-format. Deprecated. Use 'policy' to specify bindings.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Flatten Policy to create a backward compatible wire-format. Deprecated. Use 'policy' to specify the etag.
        # @!attribute [rw] policy
        #   @return [::Google::Cloud::Compute::V1::Policy]
        #     REQUIRED: The complete policy to be applied to the 'resource'. The size of the policy is limited to a few 10s of KB. An empty policy is in general a valid policy but certain services (like Projects) might reject them.
        class GlobalOrganizationSetPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] label_fingerprint
        #   @return [::String]
        #     The fingerprint of the previous set of labels for this resource, used to detect conflicts. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash when updating or changing labels, otherwise the request will fail with error 412 conditionNotMet. Make a get() request to the resource to get the latest fingerprint.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     A list of labels to apply for this resource. Each label must comply with the requirements for labels. For example, "webserver-frontend": "images". A label value can also be empty (e.g. "my-label": "").
        class GlobalSetLabelsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # @!attribute [rw] bindings
        #   @return [::Array<::Google::Cloud::Compute::V1::Binding>]
        #     Flatten Policy to create a backward compatible wire-format. Deprecated. Use 'policy' to specify bindings.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Flatten Policy to create a backward compatible wire-format. Deprecated. Use 'policy' to specify the etag.
        # @!attribute [rw] policy
        #   @return [::Google::Cloud::Compute::V1::Policy]
        #     REQUIRED: The complete policy to be applied to the 'resource'. The size of the policy is limited to a few 10s of KB. An empty policy is in general a valid policy but certain services (like Projects) might reject them.
        class GlobalSetPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Maintenance Info for ReservationBlocks.
        # @!attribute [rw] instance_maintenance_ongoing_count
        #   @return [::Integer]
        #     Describes number of instances that have ongoing maintenance.
        # @!attribute [rw] instance_maintenance_pending_count
        #   @return [::Integer]
        #     Describes number of instances that have pending maintenance.
        # @!attribute [rw] maintenance_ongoing_count
        #   @return [::Integer]
        #     Progress for ongoing maintenance for this group of VMs/hosts. Describes number of hosts in the block that have ongoing maintenance.
        # @!attribute [rw] maintenance_pending_count
        #   @return [::Integer]
        #     Progress for ongoing maintenance for this group of VMs/hosts. Describes number of hosts in the block that have pending maintenance.
        # @!attribute [rw] scheduling_type
        #   @return [::String]
        #     The type of maintenance for the reservation.
        #     Check the SchedulingType enum for the list of possible values.
        # @!attribute [rw] subblock_infra_maintenance_ongoing_count
        #   @return [::Integer]
        #     Describes number of subblock Infrastructure that has ongoing maintenance. Here, Subblock Infrastructure Maintenance pertains to upstream hardware contained in the Subblock that is necessary for a VM Family(e.g. NVLink Domains). Not all VM Families will support this field.
        # @!attribute [rw] subblock_infra_maintenance_pending_count
        #   @return [::Integer]
        #     Describes number of subblock Infrastructure that has pending maintenance. Here, Subblock Infrastructure Maintenance pertains to upstream hardware contained in the Subblock that is necessary for a VM Family (e.g. NVLink Domains). Not all VM Families will support this field.
        # @!attribute [rw] upcoming_group_maintenance
        #   @return [::Google::Cloud::Compute::V1::UpcomingMaintenance]
        #     Maintenance information on this group of VMs.
        class GroupMaintenanceInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The type of maintenance for the reservation.
          module SchedulingType
            # A value indicating that the enum field is not set.
            UNDEFINED_SCHEDULING_TYPE = 0

            # Maintenance on all reserved instances in the reservation is synchronized.
            GROUPED = 474_540_862

            # Unknown maintenance type.
            GROUP_MAINTENANCE_TYPE_UNSPECIFIED = 447_183_678

            # Maintenance is not synchronized for this reservation. Instead, each instance has its own maintenance window.
            INDEPENDENT = 127_011_674
          end
        end

        # A guest attributes entry.
        # @!attribute [rw] kind
        #   @return [::String]
        #     [Output Only] Type of the resource. Always compute#guestAttributes for guest attributes entry.
        # @!attribute [rw] query_path
        #   @return [::String]
        #     The path to be queried. This can be the default namespace ('') or a nested namespace ('\/') or a specified key ('\/\').
        # @!attribute [rw] query_value
        #   @return [::Google::Cloud::Compute::V1::GuestAttributesValue]
        #     [Output Only] The value of the requested queried path.
        # @!attribute [rw] self_link
        #   @return [::String]
        #     [Output Only] Server-defined URL for this resource.
        # @!attribute [rw] variable_key
        #   @return [::String]
        #     The key to search for.
        # @!attribute [rw] variable_value
        #   @return [::String]
        #     [Output Only] The value found for the requested key.
        class GuestAttributes
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A guest attributes namespace/key/value entry.
        # @!attribute [rw] key
        #   @return [::String]
        #     Key for the guest attribute entry.
        # @!attribute [rw] namespace
        #   @return [::String]
        #     Namespace for the guest attribute entry.
        # @!attribute [rw] value
        #   @return [::String]
        #     Value for the guest attribute entry.
        class GuestAttributesEntry
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Array of guest attribute namespace/key/value tuples.
        # @!attribute [rw] items
        #   @return [::Array<::Google::Cloud::Compute::V1::GuestAttributesEntry>]
        class GuestAttributesValue
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Guest OS features.
        # @!attribute [rw] type
        #   @return [::String]
        #     The ID of a supported feature. To add multiple values, use commas to separate values. Set to one or more of the following values: - VIRTIO_SCSI_MULTIQUEUE - WINDOWS - MULTI_IP_SUBNET - UEFI_COMPATIBLE - GVNIC - SEV_CAPABLE - SUSPEND_RESUME_COMPATIBLE - SEV_LIVE_MIGRATABLE_V2 - SEV_SNP_CAPABLE - TDX_CAPABLE - IDPF - SNP_SVSM_CAPABLE For more information, see Enabling guest operating system features.
        #     Check the Type enum for the list of possible values.
        class GuestOsFeature
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The ID of a supported feature. To add multiple values, use commas to separate values. Set to one or more of the following values: - VIRTIO_SCSI_MULTIQUEUE - WINDOWS - MULTI_IP_SUBNET - UEFI_COMPATIBLE - GVNIC - SEV_CAPABLE - SUSPEND_RESUME_COMPATIBLE - SEV_LIVE_MIGRATABLE_V2 - SEV_SNP_CAPABLE - TDX_CAPABLE - IDPF - SNP_SVSM_CAPABLE For more information, see Enabling guest operating system features.
          module Type
            # A value indicating that the enum field is not set.
            UNDEFINED_TYPE = 0

            BARE_METAL_LINUX_COMPATIBLE = 354_232_740

            FEATURE_TYPE_UNSPECIFIED = 531_767_259

            GVNIC = 68_209_305

            IDPF = 2_242_641

            MULTI_IP_SUBNET = 151_776_719

            SECURE_BOOT = 376_811_194

            SEV_CAPABLE = 87_083_793

            SEV_LIVE_MIGRATABLE = 392_039_820

            SEV_LIVE_MIGRATABLE_V2 = 168_551_983

            SEV_SNP_CAPABLE = 426_919

            SNP_SVSM_CAPABLE = 52_921_460

            TDX_CAPABLE = 240_446_133

            UEFI_COMPATIBLE = 195_865_408

            VIRTIO_SCSI_MULTIQUEUE = 201_597_069

            WINDOWS = 456_863_331
          end
        end

        # @!attribute [rw] host
        #   @return [::String]
        #     The value of the host header in the HTTP/2 health check request. If left empty (default value), the host header is set to the destination IP address to which health check packets are sent. The destination IP address depends on the type of load balancer. For details, see: https://cloud.google.com/load-balancing/docs/health-check-concepts#hc-packet-dest
        # @!attribute [rw] port
        #   @return [::Integer]
        #     The TCP port number to which the health check prober sends packets. The default value is 443. Valid values are 1 through 65535.
        # @!attribute [rw] port_name
        #   @return [::String]
        #     Not supported.
        # @!attribute [rw] port_specification
        #   @return [::String]
        #     Specifies how a port is selected for health checking. Can be one of the following values: USE_FIXED_PORT: Specifies a port number explicitly using the port field in the health check. Supported by backend services for passthrough load balancers and backend services for proxy load balancers. Not supported by target pools. The health check supports all backends supported by the backend service provided the backend can be health checked. For example, GCE_VM_IP network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends. USE_NAMED_PORT: Not supported. USE_SERVING_PORT: Provides an indirect method of specifying the health check port by referring to the backend service. Only supported by backend services for proxy load balancers. Not supported by target pools. Not supported by backend services for passthrough load balancers. Supports all backends that can be health checked; for example, GCE_VM_IP_PORT network endpoint groups and instance group backends. For GCE_VM_IP_PORT network endpoint group backends, the health check uses the port number specified for each endpoint in the network endpoint group. For instance group backends, the health check uses the port number determined by looking up the backend service's named port in the instance group's list of named ports.
        #     Check the PortSpecification enum for the list of possible values.
        # @!attribute [rw] proxy_header
        #   @return [::String]
        #     Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
        #     Check the ProxyHeader enum for the list of possible values.
        # @!attribute [rw] request_path
        #   @return [::String]
        #     The request path of the HTTP/2 health check request. The default value is /. Must comply with RFC3986.
        # @!attribute [rw] response
        #   @return [::String]
        #     Creates a content-based HTTP/2 health check. In addition to the required HTTP 200 (OK) status code, you can configure the health check to pass only when the backend sends this specific ASCII response string within the first 1024 bytes of the HTTP response body. For details, see: https://cloud.google.com/load-balancing/docs/health-check-concepts#criteria-protocol-http
        class HTTP2HealthCheck
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Specifies how a port is selected for health checking. Can be one of the following values: USE_FIXED_PORT: Specifies a port number explicitly using the port field in the health check. Supported by backend services for passthrough load balancers and backend services for proxy load balancers. Not supported by target pools. The health check supports all backends supported by the backend service provided the backend can be health checked. For example, GCE_VM_IP network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends. USE_NAMED_PORT: Not supported. USE_SERVING_PORT: Provides an indirect method of specifying the health check port by referring to the backend service. Only supported by backend services for proxy load balancers. Not supported by target pools. Not supported by backend services for passthrough load balancers. Supports all backends that can be health checked; for example, GCE_VM_IP_PORT network endpoint groups and instance group backends. For GCE_VM_IP_PORT network endpoint group backends, the health check uses the port number specified for each endpoint in the network endpoint group. For instance group backends, the health check uses the port number determined by looking up the backend service's named port in the instance group's list of named ports.
          module PortSpecification
            # A value indicating that the enum field is not set.
            UNDEFINED_PORT_SPECIFICATION = 0

            # The port number in the health check's port is used for health checking. Applies to network endpoint group and instance group backends.
            USE_FIXED_PORT = 190_235_748

            # Not supported.
            USE_NAMED_PORT = 349_300_671

            # For network endpoint group backends, the health check uses the port number specified on each endpoint in the network endpoint group. For instance group backends, the health check uses the port number specified for the backend service's named port defined in the instance group's named ports.
            USE_SERVING_PORT = 362_637_516
          end

          # Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
          module ProxyHeader
            # A value indicating that the enum field is not set.
            UNDEFINED_PROXY_HEADER = 0

            NONE = 2_402_104

            PROXY_V1 = 334_352_940
          end
        end

        # @!attribute [rw] host
        #   @return [::String]
        #     The value of the host header in the HTTP health check request. If left empty (default value), the host header is set to the destination IP address to which health check packets are sent. The destination IP address depends on the type of load balancer. For details, see: https://cloud.google.com/load-balancing/docs/health-check-concepts#hc-packet-dest
        # @!attribute [rw] port
        #   @return [::Integer]
        #     The TCP port number to which the health check prober sends packets. The default value is 80. Valid values are 1 through 65535.
        # @!attribute [rw] port_name
        #   @return [::String]
        #     Not supported.
        # @!attribute [rw] port_specification
        #   @return [::String]
        #     Specifies how a port is selected for health checking. Can be one of the following values: USE_FIXED_PORT: Specifies a port number explicitly using the port field in the health check. Supported by backend services for passthrough load balancers and backend services for proxy load balancers. Also supported in legacy HTTP health checks for target pools. The health check supports all backends supported by the backend service provided the backend can be health checked. For example, GCE_VM_IP network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends. USE_NAMED_PORT: Not supported. USE_SERVING_PORT: Provides an indirect method of specifying the health check port by referring to the backend service. Only supported by backend services for proxy load balancers. Not supported by target pools. Not supported by backend services for pass-through load balancers. Supports all backends that can be health checked; for example, GCE_VM_IP_PORT network endpoint groups and instance group backends. For GCE_VM_IP_PORT network endpoint group backends, the health check uses the port number specified for each endpoint in the network endpoint group. For instance group backends, the health check uses the port number determined by looking up the backend service's named port in the instance group's list of named ports.
        #     Check the PortSpecification enum for the list of possible values.
        # @!attribute [rw] proxy_header
        #   @return [::String]
        #     Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
        #     Check the ProxyHeader enum for the list of possible values.
        # @!attribute [rw] request_path
        #   @return [::String]
        #     The request path of the HTTP health check request. The default value is /. Must comply with RFC3986.
        # @!attribute [rw] response
        #   @return [::String]
        #     Creates a content-based HTTP health check. In addition to the required HTTP 200 (OK) status code, you can configure the health check to pass only when the backend sends this specific ASCII response string within the first 1024 bytes of the HTTP response body. For details, see: https://cloud.google.com/load-balancing/docs/health-check-concepts#criteria-protocol-http
        class HTTPHealthCheck
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Specifies how a port is selected for health checking. Can be one of the following values: USE_FIXED_PORT: Specifies a port number explicitly using the port field in the health check. Supported by backend services for passthrough load balancers and backend services for proxy load balancers. Also supported in legacy HTTP health checks for target pools. The health check supports all backends supported by the backend service provided the backend can be health checked. For example, GCE_VM_IP network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends. USE_NAMED_PORT: Not supported. USE_SERVING_PORT: Provides an indirect method of specifying the health check port by referring to the backend service. Only supported by backend services for proxy load balancers. Not supported by target pools. Not supported by backend services for pass-through load balancers. Supports all backends that can be health checked; for example, GCE_VM_IP_PORT network endpoint groups and instance group backends. For GCE_VM_IP_PORT network endpoint group backends, the health check uses the port number specified for each endpoint in the network endpoint group. For instance group backends, the health check uses the port number determined by looking up the backend service's named port in the instance group's list of named ports.
          module PortSpecification
            # A value indicating that the enum field is not set.
            UNDEFINED_PORT_SPECIFICATION = 0

            # The port number in the health check's port is used for health checking. Applies to network endpoint group and instance group backends.
            USE_FIXED_PORT = 190_235_748

            # Not supported.
            USE_NAMED_PORT = 349_300_671

            # For network endpoint group backends, the health check uses the port number specified on each endpoint in the network endpoint group. For instance group backends, the health check uses the port number specified for the backend service's named port defined in the instance group's named ports.
            USE_SERVING_PORT = 362_637_516
          end

          # Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
          module ProxyHeader
            # A value indicating that the enum field is not set.
            UNDEFINED_PROXY_HEADER = 0

            NONE = 2_402_104

            PROXY_V1 = 334_352_940
          end
        end

        # @!attribute [rw] host
        #   @return [::String]
        #     The value of the host header in the HTTPS health check request. If left empty (default value), the host header is set to the destination IP address to which health check packets are sent. The destination IP address depends on the type of load balancer. For details, see: https://cloud.google.com/load-balancing/docs/health-check-concepts#hc-packet-dest
        # @!attribute [rw] port
        #   @return [::Integer]
        #     The TCP port number to which the health check prober sends packets. The default value is 443. Valid values are 1 through 65535.
        # @!attribute [rw] port_name
        #   @return [::String]
        #     Not supported.
        # @!attribute [rw] port_specification
        #   @return [::String]
        #     Specifies how a port is selected for health checking. Can be one of the following values: USE_FIXED_PORT: Specifies a port number explicitly using the port field in the health check. Supported by backend services for passthrough load balancers and backend services for proxy load balancers. Not supported by target pools. The health check supports all backends supported by the backend service provided the backend can be health checked. For example, GCE_VM_IP network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends. USE_NAMED_PORT: Not supported. USE_SERVING_PORT: Provides an indirect method of specifying the health check port by referring to the backend service. Only supported by backend services for proxy load balancers. Not supported by target pools. Not supported by backend services for passthrough load balancers. Supports all backends that can be health checked; for example, GCE_VM_IP_PORT network endpoint groups and instance group backends. For GCE_VM_IP_PORT network endpoint group backends, the health check uses the port number specified for each endpoint in the network endpoint group. For instance group backends, the health check uses the port number determined by looking up the backend service's named port in the instance group's list of named ports.
        #     Check the PortSpecification enum for the list of possible values.
        # @!attribute [rw] proxy_header
        #   @return [::String]
        #     Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
        #     Check the ProxyHeader enum for the list of possible values.
        # @!attribute [rw] request_path
        #   @return [::String]
        #     The request path of the HTTPS health check request. The default value is /. Must comply with RFC3986.
        # @!attribute [rw] response
        #   @return [::String]
        #     Creates a content-based HTTPS health check. In addition to the required HTTP 200 (OK) status code, you can configure the health check to pass only when the backend sends this specific ASCII response string within the first 1024 bytes of the HTTP response body. For details, see: https://cloud.google.com/load-balancing/docs/health-check-concepts#criteria-protocol-http
        class HTTPSHealthCheck
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Specifies how a port is selected for health checking. Can be one of the following values: USE_FIXED_PORT: Specifies a port number explicitly using the port field in the health check. Supported by backend services for passthrough load balancers and backend services for proxy load balancers. Not supported by target pools. The health check supports all backends supported by the backend service provided the backend can be health checked. For example, GCE_VM_IP network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends. USE_NAMED_PORT: Not supported. USE_SERVING_PORT: Provides an indirect method of specifying the health check port by referring to the backend service. Only supported by backend services for proxy load balancers. Not supported by target pools. Not supported by backend services for passthrough load balancers. Supports all backends that can be health checked; for example, GCE_VM_IP_PORT network endpoint groups and instance group backends. For GCE_VM_IP_PORT network endpoint group backends, the health check uses the port number specified for each endpoint in the network endpoint group. For instance group backends, the health check uses the port number determined by looking up the backend service's named port in the instance group's list of named ports.
          module PortSpecification
            # A value indicating that the enum field is not set.
            UNDEFINED_PORT_SPECIFICATION = 0

            # The port number in the health check's port is used for health checking. Applies to network endpoint group and instance group backends.
            USE_FIXED_PORT = 190_235_748

            # Not supported.
            USE_NAMED_PORT = 349_300_671

            # For network endpoint group backends, the health check uses the port number specified on each endpoint in the network endpoint group. For instance group backends, the health check uses the port number specified for the backend service's named port defined in the instance group's named ports.
            USE_SERVING_PORT = 362_637_516
          end

          # Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
          module ProxyHeader
            # A value indicating that the enum field is not set.
            UNDEFINED_PROXY_HEADER = 0

            NONE = 2_402_104

            PROXY_V1 = 334_352_940
          end
        end

        # Represents a health check resource. Google Compute Engine has two health check resources: * [Regional](/compute/docs/reference/rest/v1/regionHealthChecks) * [Global](/compute/docs/reference/rest/v1/healthChecks) These health check resources can be used for load balancing and for autohealing VMs in a managed instance group (MIG). **Load balancing** Health check requirements vary depending on the type of load balancer. For details about the type of health check supported for each load balancer and corresponding backend type, see Health checks overview: Load balancer guide. **Autohealing in MIGs** The health checks that you use for autohealing VMs in a MIG can be either regional or global. For more information, see Set up an application health check and autohealing. For more information, see Health checks overview.
        # @!attribute [rw] check_interval_sec
        #   @return [::Integer]
        #     How often (in seconds) to send a health check. The default value is 5 seconds.
        # @!attribute [rw] creation_timestamp
        #   @return [::String]
        #     [Output Only] Creation timestamp in 3339 text format.
        # @!attribute [rw] description
        #   @return [::String]
        #     An optional description of this resource. Provide this property when you create the resource.
        # @!attribute [rw] grpc_health_check
        #   @return [::Google::Cloud::Compute::V1::GRPCHealthCheck]
        # @!attribute [rw] healthy_threshold
        #   @return [::Integer]
        #     A so-far unhealthy instance will be marked healthy after this many consecutive successes. The default value is 2.
        # @!attribute [rw] http2_health_check
        #   @return [::Google::Cloud::Compute::V1::HTTP2HealthCheck]
        # @!attribute [rw] http_health_check
        #   @return [::Google::Cloud::Compute::V1::HTTPHealthCheck]
        # @!attribute [rw] https_health_check
        #   @return [::Google::Cloud::Compute::V1::HTTPSHealthCheck]
        # @!attribute [rw] id
        #   @return [::Integer]
        #     [Output Only] The unique identifier for the resource. This identifier is defined by the server.
        # @!attribute [rw] kind
        #   @return [::String]
        #     Type of the resource.
        # @!attribute [rw] log_config
        #   @return [::Google::Cloud::Compute::V1::HealthCheckLogConfig]
        #     Configure logging on this health check.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. For example, a name that is 1-63 characters long, matches the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`, and otherwise complies with RFC1035. This regular expression describes a name where the first character is a lowercase letter, and all following characters are a dash, lowercase letter, or digit, except the last character, which isn't a dash.
        # @!attribute [rw] region
        #   @return [::String]
        #     [Output Only] Region where the health check resides. Not applicable to global health checks.
        # @!attribute [rw] self_link
        #   @return [::String]
        #     [Output Only] Server-defined URL for the resource.
        # @!attribute [rw] source_regions
        #   @return [::Array<::String>]
        #     The list of cloud regions from which health checks are performed. If any regions are specified, then exactly 3 regions should be specified. The region names must be valid names of Google Cloud regions. This can only be set for global health check. If this list is non-empty, then there are restrictions on what other health check fields are supported and what other resources can use this health check: - SSL, HTTP2, and GRPC protocols are not supported. - The TCP request field is not supported. - The proxyHeader field for HTTP, HTTPS, and TCP is not supported. - The checkIntervalSec field must be at least 30. - The health check cannot be used with BackendService nor with managed instance group auto-healing.
        # @!attribute [rw] ssl_health_check
        #   @return [::Google::Cloud::Compute::V1::SSLHealthCheck]
        # @!attribute [rw] tcp_health_check
        #   @return [::Google::Cloud::Compute::V1::TCPHealthCheck]
        # @!attribute [rw] timeout_sec
        #   @return [::Integer]
        #     How long (in seconds) to wait before claiming failure. The default value is 5 seconds. It is invalid for timeoutSec to have greater value than checkIntervalSec.
        # @!attribute [rw] type
        #   @return [::String]
        #     Specifies the type of the healthCheck, either TCP, SSL, HTTP, HTTPS, HTTP2 or GRPC. Exactly one of the protocol-specific health check fields must be specified, which must match type field.
        #     Check the Type enum for the list of possible values.
        # @!attribute [rw] unhealthy_threshold
        #   @return [::Integer]
        #     A so-far healthy instance will be marked unhealthy after this many consecutive failures. The default value is 2.
        class HealthCheck
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Specifies the type of the healthCheck, either TCP, SSL, HTTP, HTTPS, HTTP2 or GRPC. Exactly one of the protocol-specific health check fields must be specified, which must match type field.
          module Type
            # A value indicating that the enum field is not set.
            UNDEFINED_TYPE = 0

            GRPC = 2_196_510

            HTTP = 2_228_360

            HTTP2 = 69_079_210

            HTTPS = 69_079_243

            INVALID = 530_283_991

            SSL = 82_412

            TCP = 82_881
          end
        end

        # Contains a list of HealthCheck resources.
        # @!attribute [rw] id
        #   @return [::String]
        #     [Output Only] Unique identifier for the resource; defined by the server.
        # @!attribute [rw] items
        #   @return [::Array<::Google::Cloud::Compute::V1::HealthCheck>]
        #     A list of HealthCheck resources.
        # @!attribute [rw] kind
        #   @return [::String]
        #     Type of resource.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
        # @!attribute [rw] self_link
        #   @return [::String]
        #     [Output Only] Server-defined URL for this resource.
        # @!attribute [rw] warning
        #   @return [::Google::Cloud::Compute::V1::Warning]
        #     [Output Only] Informational warning message.
        class HealthCheckList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration of logging on a health check. If logging is enabled, logs will be exported to Stackdriver.
        # @!attribute [rw] enable
        #   @return [::Boolean]
        #     Indicates whether or not to export logs. This is false by default, which means no health check logging will be done.
        class HealthCheckLogConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A full or valid partial URL to a health check. For example, the following are valid URLs: - https://www.googleapis.com/compute/beta/projects/project-id/global/httpHealthChecks/health-check - projects/project-id/global/httpHealthChecks/health-check - global/httpHealthChecks/health-check
        # @!attribute [rw] health_check
        #   @return [::String]
        class HealthCheckReference
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a Health-Check as a Service resource.
        # @!attribute [rw] creation_timestamp
        #   @return [::String]
        #     [Output Only] Creation timestamp in RFC3339 text format.
        # @!attribute [rw] description
        #   @return [::String]
        #     An optional description of this resource. Provide this property when you create the resource.
        # @!attribute [rw] fingerprint
        #   @return [::String]
        #     Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a HealthCheckService. An up-to-date fingerprint must be provided in order to patch/update the HealthCheckService; Otherwise, the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve the HealthCheckService.
        # @!attribute [rw] health_checks
        #   @return [::Array<::String>]
        #     A list of URLs to the HealthCheck resources. Must have at least one HealthCheck, and not more than 10 for regional HealthCheckService, and not more than 1 for global HealthCheckService. HealthCheck resources must have portSpecification=USE_SERVING_PORT or portSpecification=USE_FIXED_PORT. For regional HealthCheckService, the HealthCheck must be regional and in the same region. For global HealthCheckService, HealthCheck must be global. Mix of regional and global HealthChecks is not supported. Multiple regional HealthChecks must belong to the same region. Regional HealthChecks must belong to the same region as zones of NetworkEndpointGroups. For global HealthCheckService using global INTERNET_IP_PORT NetworkEndpointGroups, the global HealthChecks must specify sourceRegions, and HealthChecks that specify sourceRegions can only be used with global INTERNET_IP_PORT NetworkEndpointGroups.
        # @!attribute [rw] health_status_aggregation_policy
        #   @return [::String]
        #     Optional. Policy for how the results from multiple health checks for the same endpoint are aggregated. Defaults to NO_AGGREGATION if unspecified. - NO_AGGREGATION. An EndpointHealth message is returned for each pair in the health check service. - AND. If any health check of an endpoint reports UNHEALTHY, then UNHEALTHY is the HealthState of the endpoint. If all health checks report HEALTHY, the HealthState of the endpoint is HEALTHY. . This is only allowed with regional HealthCheckService.
        #     Check the HealthStatusAggregationPolicy enum for the list of possible values.
        # @!attribute [rw] id
        #   @return [::Integer]
        #     [Output Only] The unique identifier for the resource. This identifier is defined by the server.
        # @!attribute [rw] kind
        #   @return [::String]
        #     [Output only] Type of the resource. Always compute#healthCheckServicefor health check services.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the resource. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        # @!attribute [rw] network_endpoint_groups
        #   @return [::Array<::String>]
        #     A list of URLs to the NetworkEndpointGroup resources. Must not have more than 100. For regional HealthCheckService, NEGs must be in zones in the region of the HealthCheckService. For global HealthCheckServices, the NetworkEndpointGroups must be global INTERNET_IP_PORT.
        # @!attribute [rw] notification_endpoints
        #   @return [::Array<::String>]
        #     A list of URLs to the NotificationEndpoint resources. Mu