# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/compute/v1/compute_pb"
require "google/cloud/compute/v1/instances/rest/service_stub"
require "google/cloud/compute/v1/zone_operations/rest"

module Google
  module Cloud
    module Compute
      module V1
        module Instances
          module Rest
            ##
            # REST client for the Instances service.
            #
            # The Instances API.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "compute.$UNIVERSE_DOMAIN$"

              # @private
              attr_reader :instances_stub

              ##
              # Configure the Instances Client class.
              #
              # See {::Google::Cloud::Compute::V1::Instances::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all Instances clients
              #   ::Google::Cloud::Compute::V1::Instances::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Compute", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.add_access_config.timeout = 600.0

                  default_config.rpcs.add_network_interface.timeout = 600.0

                  default_config.rpcs.add_resource_policies.timeout = 600.0

                  default_config.rpcs.aggregated_list.timeout = 600.0
                  default_config.rpcs.aggregated_list.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.attach_disk.timeout = 600.0

                  default_config.rpcs.bulk_insert.timeout = 600.0

                  default_config.rpcs.delete.timeout = 600.0

                  default_config.rpcs.delete_access_config.timeout = 600.0

                  default_config.rpcs.delete_network_interface.timeout = 600.0

                  default_config.rpcs.detach_disk.timeout = 600.0

                  default_config.rpcs.get.timeout = 600.0
                  default_config.rpcs.get.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.get_effective_firewalls.timeout = 600.0
                  default_config.rpcs.get_effective_firewalls.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.get_guest_attributes.timeout = 600.0
                  default_config.rpcs.get_guest_attributes.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.get_iam_policy.timeout = 600.0
                  default_config.rpcs.get_iam_policy.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.get_screenshot.timeout = 600.0
                  default_config.rpcs.get_screenshot.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.get_serial_port_output.timeout = 600.0
                  default_config.rpcs.get_serial_port_output.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.get_shielded_instance_identity.timeout = 600.0
                  default_config.rpcs.get_shielded_instance_identity.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.insert.timeout = 600.0

                  default_config.rpcs.list.timeout = 600.0
                  default_config.rpcs.list.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.list_referrers.timeout = 600.0
                  default_config.rpcs.list_referrers.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.perform_maintenance.timeout = 600.0

                  default_config.rpcs.remove_resource_policies.timeout = 600.0

                  default_config.rpcs.report_host_as_faulty.timeout = 600.0

                  default_config.rpcs.reset.timeout = 600.0

                  default_config.rpcs.resume.timeout = 600.0

                  default_config.rpcs.send_diagnostic_interrupt.timeout = 600.0

                  default_config.rpcs.set_deletion_protection.timeout = 600.0

                  default_config.rpcs.set_disk_auto_delete.timeout = 600.0

                  default_config.rpcs.set_iam_policy.timeout = 600.0

                  default_config.rpcs.set_labels.timeout = 600.0

                  default_config.rpcs.set_machine_resources.timeout = 600.0

                  default_config.rpcs.set_machine_type.timeout = 600.0

                  default_config.rpcs.set_metadata.timeout = 600.0

                  default_config.rpcs.set_min_cpu_platform.timeout = 600.0

                  default_config.rpcs.set_name.timeout = 600.0

                  default_config.rpcs.set_scheduling.timeout = 600.0

                  default_config.rpcs.set_security_policy.timeout = 600.0

                  default_config.rpcs.set_service_account.timeout = 600.0

                  default_config.rpcs.set_shielded_instance_integrity_policy.timeout = 600.0

                  default_config.rpcs.set_tags.timeout = 600.0

                  default_config.rpcs.simulate_maintenance_event.timeout = 600.0

                  default_config.rpcs.start.timeout = 600.0

                  default_config.rpcs.start_with_encryption_key.timeout = 600.0

                  default_config.rpcs.stop.timeout = 600.0

                  default_config.rpcs.suspend.timeout = 600.0

                  default_config.rpcs.test_iam_permissions.timeout = 600.0

                  default_config.rpcs.update.timeout = 600.0

                  default_config.rpcs.update_access_config.timeout = 600.0

                  default_config.rpcs.update_display_device.timeout = 600.0

                  default_config.rpcs.update_network_interface.timeout = 600.0

                  default_config.rpcs.update_shielded_instance_config.timeout = 600.0

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the Instances Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Compute::V1::Instances::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @instances_stub.universe_domain
              end

              ##
              # Create a new Instances REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Instances client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @zone_operations = ::Google::Cloud::Compute::V1::ZoneOperations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @instances_stub = ::Google::Cloud::Compute::V1::Instances::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @instances_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # Get the associated client for long-running operations via ZoneOperations.
              #
              # @return [::Google::Cloud::Compute::V1::ZoneOperations::Rest::Client]
              #
              attr_reader :zone_operations

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @instances_stub.logger
              end

              # Service calls

              ##
              # Adds an access config to an instance's network interface.
              #
              # @overload add_access_config(request, options = nil)
              #   Pass arguments to `add_access_config` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::AddAccessConfigInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::AddAccessConfigInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload add_access_config(access_config_resource: nil, instance: nil, network_interface: nil, project: nil, request_id: nil, zone: nil)
              #   Pass arguments to `add_access_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param access_config_resource [::Google::Cloud::Compute::V1::AccessConfig, ::Hash]
              #     The body resource for this request
              #   @param instance [::String]
              #     The instance name for this request.
              #   @param network_interface [::String]
              #     The name of the network interface to add to this instance.
              #   @param project [::String]
              #     Project ID for this request.
              #   @param request_id [::String]
              #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::GenericLRO::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::GenericLRO::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::AddAccessConfigInstanceRequest.new
              #
              #   # Call the add_access_config method.
              #   result = client.add_access_config request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Operation.
              #   p result
              #
              def add_access_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::AddAccessConfigInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.add_access_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.add_access_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.add_access_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.add_access_config request, options do |result, response|
                  result = ::Google::Cloud::Compute::V1::ZoneOperations::Rest::NonstandardLro.create_operation(
                    operation: result,
                    client: zone_operations,
                    request_values: {
                      "project" => request.project,
                      "zone" => request.zone
                    },
                    options: options
                  )
                  yield result, response if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Adds one dynamic network interface to an active instance.
              #
              # @overload add_network_interface(request, options = nil)
              #   Pass arguments to `add_network_interface` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::AddNetworkInterfaceInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::AddNetworkInterfaceInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload add_network_interface(instance: nil, network_interface_resource: nil, project: nil, request_id: nil, zone: nil)
              #   Pass arguments to `add_network_interface` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param instance [::String]
              #     The instance name for this request stored as resource_id. Name should conform to RFC1035 or be an unsigned long integer.
              #   @param network_interface_resource [::Google::Cloud::Compute::V1::NetworkInterface, ::Hash]
              #     The body resource for this request
              #   @param project [::String]
              #     Project ID for this request.
              #   @param request_id [::String]
              #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::GenericLRO::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::GenericLRO::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::AddNetworkInterfaceInstanceRequest.new
              #
              #   # Call the add_network_interface method.
              #   result = client.add_network_interface request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Operation.
              #   p result
              #
              def add_network_interface request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::AddNetworkInterfaceInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.add_network_interface.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.add_network_interface.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.add_network_interface.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.add_network_interface request, options do |result, response|
                  result = ::Google::Cloud::Compute::V1::ZoneOperations::Rest::NonstandardLro.create_operation(
                    operation: result,
                    client: zone_operations,
                    request_values: {
                      "project" => request.project,
                      "zone" => request.zone
                    },
                    options: options
                  )
                  yield result, response if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Adds existing resource policies to an instance. You can only add one policy right now which will be applied to this instance for scheduling live migrations.
              #
              # @overload add_resource_policies(request, options = nil)
              #   Pass arguments to `add_resource_policies` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::AddResourcePoliciesInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::AddResourcePoliciesInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload add_resource_policies(instance: nil, instances_add_resource_policies_request_resource: nil, project: nil, request_id: nil, zone: nil)
              #   Pass arguments to `add_resource_policies` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param instance [::String]
              #     The instance name for this request.
              #   @param instances_add_resource_policies_request_resource [::Google::Cloud::Compute::V1::InstancesAddResourcePoliciesRequest, ::Hash]
              #     The body resource for this request
              #   @param project [::String]
              #     Project ID for this request.
              #   @param request_id [::String]
              #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::GenericLRO::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::GenericLRO::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::AddResourcePoliciesInstanceRequest.new
              #
              #   # Call the add_resource_policies method.
              #   result = client.add_resource_policies request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Operation.
              #   p result
              #
              def add_resource_policies request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::AddResourcePoliciesInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.add_resource_policies.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.add_resource_policies.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.add_resource_policies.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.add_resource_policies request, options do |result, response|
                  result = ::Google::Cloud::Compute::V1::ZoneOperations::Rest::NonstandardLro.create_operation(
                    operation: result,
                    client: zone_operations,
                    request_values: {
                      "project" => request.project,
                      "zone" => request.zone
                    },
                    options: options
                  )
                  yield result, response if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Retrieves an aggregated list of all of the instances in your project across all regions and zones. The performance of this method degrades when a filter is specified on a project that has a very large number of instances. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
              #
              # @overload aggregated_list(request, options = nil)
              #   Pass arguments to `aggregated_list` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::AggregatedListInstancesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::AggregatedListInstancesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload aggregated_list(filter: nil, include_all_scopes: nil, max_results: nil, order_by: nil, page_token: nil, project: nil, return_partial_success: nil, service_project_number: nil)
              #   Pass arguments to `aggregated_list` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param filter [::String]
              #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
              #   @param include_all_scopes [::Boolean]
              #     Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
              #   @param max_results [::Integer]
              #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
              #   @param order_by [::String]
              #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
              #   @param page_token [::String]
              #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
              #   @param project [::String]
              #     Project ID for this request.
              #   @param return_partial_success [::Boolean]
              #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
              #   @param service_project_number [::Integer]
              #     The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::String, ::Google::Cloud::Compute::V1::InstancesScopedList>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::String, ::Google::Cloud::Compute::V1::InstancesScopedList>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::AggregatedListInstancesRequest.new
              #
              #   # Call the aggregated_list method.
              #   result = client.aggregated_list request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::InstanceAggregatedList.
              #   p result
              #
              def aggregated_list request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::AggregatedListInstancesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.aggregated_list.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.aggregated_list.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.aggregated_list.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.aggregated_list request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @instances_stub, :aggregated_list, "items", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Attaches an existing Disk resource to an instance. You must first create the disk before you can attach it. It is not possible to create and attach a disk at the same time. For more information, read Adding a persistent disk to your instance.
              #
              # @overload attach_disk(request, options = nil)
              #   Pass arguments to `attach_disk` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::AttachDiskInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::AttachDiskInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload attach_disk(attached_disk_resource: nil, force_attach: nil, instance: nil, project: nil, request_id: nil, zone: nil)
              #   Pass arguments to `attach_disk` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param attached_disk_resource [::Google::Cloud::Compute::V1::AttachedDisk, ::Hash]
              #     The body resource for this request
              #   @param force_attach [::Boolean]
              #     Whether to force attach the regional disk even if it's currently attached to another instance. If you try to force attach a zonal disk to an instance, you will receive an error.
              #   @param instance [::String]
              #     The instance name for this request.
              #   @param project [::String]
              #     Project ID for this request.
              #   @param request_id [::String]
              #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::GenericLRO::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::GenericLRO::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::AttachDiskInstanceRequest.new
              #
              #   # Call the attach_disk method.
              #   result = client.attach_disk request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Operation.
              #   p result
              #
              def attach_disk request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::AttachDiskInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.attach_disk.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.attach_disk.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.attach_disk.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.attach_disk request, options do |result, response|
                  result = ::Google::Cloud::Compute::V1::ZoneOperations::Rest::NonstandardLro.create_operation(
                    operation: result,
                    client: zone_operations,
                    request_values: {
                      "project" => request.project,
                      "zone" => request.zone
                    },
                    options: options
                  )
                  yield result, response if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates multiple instances. Count specifies the number of instances to create. For more information, see About bulk creation of VMs.
              #
              # @overload bulk_insert(request, options = nil)
              #   Pass arguments to `bulk_insert` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::BulkInsertInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::BulkInsertInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload bulk_insert(bulk_insert_instance_resource_resource: nil, project: nil, request_id: nil, zone: nil)
              #   Pass arguments to `bulk_insert` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param bulk_insert_instance_resource_resource [::Google::Cloud::Compute::V1::BulkInsertInstanceResource, ::Hash]
              #     The body resource for this request
              #   @param project [::String]
              #     Project ID for this request.
              #   @param request_id [::String]
              #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::GenericLRO::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::GenericLRO::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::BulkInsertInstanceRequest.new
              #
              #   # Call the bulk_insert method.
              #   result = client.bulk_insert request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Operation.
              #   p result
              #
              def bulk_insert request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::BulkInsertInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.bulk_insert.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.bulk_insert.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.bulk_insert.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.bulk_insert request, options do |result, response|
                  result = ::Google::Cloud::Compute::V1::ZoneOperations::Rest::NonstandardLro.create_operation(
                    operation: result,
                    client: zone_operations,
                    request_values: {
                      "project" => request.project,
                      "zone" => request.zone
                    },
                    options: options
                  )
                  yield result, response if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes the specified Instance resource. For more information, see Deleting an instance.
              #
              # @overload delete(request, options = nil)
              #   Pass arguments to `delete` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::DeleteInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::DeleteInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete(instance: nil, project: nil, request_id: nil, zone: nil)
              #   Pass arguments to `delete` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param instance [::String]
              #     Name of the instance resource to delete.
              #   @param project [::String]
              #     Project ID for this request.
              #   @param request_id [::String]
              #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::GenericLRO::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::GenericLRO::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::DeleteInstanceRequest.new
              #
              #   # Call the delete method.
              #   result = client.delete request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Operation.
              #   p result
              #
              def delete request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::DeleteInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.delete request, options do |result, response|
                  result = ::Google::Cloud::Compute::V1::ZoneOperations::Rest::NonstandardLro.create_operation(
                    operation: result,
                    client: zone_operations,
                    request_values: {
                      "project" => request.project,
                      "zone" => request.zone
                    },
                    options: options
                  )
                  yield result, response if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes an access config from an instance's network interface.
              #
              # @overload delete_access_config(request, options = nil)
              #   Pass arguments to `delete_access_config` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::DeleteAccessConfigInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::DeleteAccessConfigInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_access_config(access_config: nil, instance: nil, network_interface: nil, project: nil, request_id: nil, zone: nil)
              #   Pass arguments to `delete_access_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param access_config [::String]
              #     The name of the access config to delete.
              #   @param instance [::String]
              #     The instance name for this request.
              #   @param network_interface [::String]
              #     The name of the network interface.
              #   @param project [::String]
              #     Project ID for this request.
              #   @param request_id [::String]
              #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::GenericLRO::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::GenericLRO::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::DeleteAccessConfigInstanceRequest.new
              #
              #   # Call the delete_access_config method.
              #   result = client.delete_access_config request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Operation.
              #   p result
              #
              def delete_access_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::DeleteAccessConfigInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_access_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_access_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_access_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.delete_access_config request, options do |result, response|
                  result = ::Google::Cloud::Compute::V1::ZoneOperations::Rest::NonstandardLro.create_operation(
                    operation: result,
                    client: zone_operations,
                    request_values: {
                      "project" => request.project,
                      "zone" => request.zone
                    },
                    options: options
                  )
                  yield result, response if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes one dynamic network interface from an active instance. InstancesDeleteNetworkInterfaceRequest indicates: - instance from which to delete, using project+zone+resource_id fields; - dynamic network interface to be deleted, using network_interface_name field;
              #
              # @overload delete_network_interface(request, options = nil)
              #   Pass arguments to `delete_network_interface` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::DeleteNetworkInterfaceInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::DeleteNetworkInterfaceInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_network_interface(instance: nil, network_interface_name: nil, project: nil, request_id: nil, zone: nil)
              #   Pass arguments to `delete_network_interface` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param instance [::String]
              #     The instance name for this request stored as resource_id. Name should conform to RFC1035 or be an unsigned long integer.
              #   @param network_interface_name [::String]
              #     The name of the dynamic network interface to be deleted from the instance.
              #   @param project [::String]
              #     Project ID for this request.
              #   @param request_id [::String]
              #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::GenericLRO::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::GenericLRO::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::DeleteNetworkInterfaceInstanceRequest.new
              #
              #   # Call the delete_network_interface method.
              #   result = client.delete_network_interface request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Operation.
              #   p result
              #
              def delete_network_interface request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::DeleteNetworkInterfaceInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_network_interface.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_network_interface.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_network_interface.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.delete_network_interface request, options do |result, response|
                  result = ::Google::Cloud::Compute::V1::ZoneOperations::Rest::NonstandardLro.create_operation(
                    operation: result,
                    client: zone_operations,
                    request_values: {
                      "project" => request.project,
                      "zone" => request.zone
                    },
                    options: options
                  )
                  yield result, response if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Detaches a disk from an instance.
              #
              # @overload detach_disk(request, options = nil)
              #   Pass arguments to `detach_disk` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::DetachDiskInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::DetachDiskInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload detach_disk(device_name: nil, instance: nil, project: nil, request_id: nil, zone: nil)
              #   Pass arguments to `detach_disk` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param device_name [::String]
              #     The device name of the disk to detach. Make a get() request on the instance to view currently attached disks and device names.
              #   @param instance [::String]
              #     Instance name for this request.
              #   @param project [::String]
              #     Project ID for this request.
              #   @param request_id [::String]
              #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::GenericLRO::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::GenericLRO::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::DetachDiskInstanceRequest.new
              #
              #   # Call the detach_disk method.
              #   result = client.detach_disk request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Operation.
              #   p result
              #
              def detach_disk request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::DetachDiskInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.detach_disk.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.detach_disk.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.detach_disk.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.detach_disk request, options do |result, response|
                  result = ::Google::Cloud::Compute::V1::ZoneOperations::Rest::NonstandardLro.create_operation(
                    operation: result,
                    client: zone_operations,
                    request_values: {
                      "project" => request.project,
                      "zone" => request.zone
                    },
                    options: options
                  )
                  yield result, response if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the specified Instance resource.
              #
              # @overload get(request, options = nil)
              #   Pass arguments to `get` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::GetInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::GetInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get(instance: nil, project: nil, zone: nil)
              #   Pass arguments to `get` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param instance [::String]
              #     Name of the instance resource to return.
              #   @param project [::String]
              #     Project ID for this request.
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Compute::V1::Instance]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Compute::V1::Instance]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::GetInstanceRequest.new
              #
              #   # Call the get method.
              #   result = client.get request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Instance.
              #   p result
              #
              def get request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::GetInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.get request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns effective firewalls applied to an interface of the instance.
              #
              # @overload get_effective_firewalls(request, options = nil)
              #   Pass arguments to `get_effective_firewalls` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::GetEffectiveFirewallsInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::GetEffectiveFirewallsInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_effective_firewalls(instance: nil, network_interface: nil, project: nil, zone: nil)
              #   Pass arguments to `get_effective_firewalls` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param instance [::String]
              #     Name of the instance scoping this request.
              #   @param network_interface [::String]
              #     The name of the network interface to get the effective firewalls.
              #   @param project [::String]
              #     Project ID for this request.
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Compute::V1::InstancesGetEffectiveFirewallsResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Compute::V1::InstancesGetEffectiveFirewallsResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::GetEffectiveFirewallsInstanceRequest.new
              #
              #   # Call the get_effective_firewalls method.
              #   result = client.get_effective_firewalls request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::InstancesGetEffectiveFirewallsResponse.
              #   p result
              #
              def get_effective_firewalls request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::GetEffectiveFirewallsInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_effective_firewalls.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_effective_firewalls.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_effective_firewalls.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.get_effective_firewalls request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the specified guest attributes entry.
              #
              # @overload get_guest_attributes(request, options = nil)
              #   Pass arguments to `get_guest_attributes` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::GetGuestAttributesInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::GetGuestAttributesInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_guest_attributes(instance: nil, project: nil, query_path: nil, variable_key: nil, zone: nil)
              #   Pass arguments to `get_guest_attributes` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param instance [::String]
              #     Name of the instance scoping this request.
              #   @param project [::String]
              #     Project ID for this request.
              #   @param query_path [::String]
              #     Specifies the guest attributes path to be queried.
              #   @param variable_key [::String]
              #     Specifies the key for the guest attributes entry.
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Compute::V1::GuestAttributes]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Compute::V1::GuestAttributes]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::GetGuestAttributesInstanceRequest.new
              #
              #   # Call the get_guest_attributes method.
              #   result = client.get_guest_attributes request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::GuestAttributes.
              #   p result
              #
              def get_guest_attributes request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::GetGuestAttributesInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_guest_attributes.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_guest_attributes.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_guest_attributes.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.get_guest_attributes request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the access control policy for a resource. May be empty if no such policy or resource exists.
              #
              # @overload get_iam_policy(request, options = nil)
              #   Pass arguments to `get_iam_policy` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::GetIamPolicyInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::GetIamPolicyInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_iam_policy(options_requested_policy_version: nil, project: nil, resource: nil, zone: nil)
              #   Pass arguments to `get_iam_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param options_requested_policy_version [::Integer]
              #     Requested IAM Policy version.
              #   @param project [::String]
              #     Project ID for this request.
              #   @param resource [::String]
              #     Name or id of the resource for this request.
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Compute::V1::Policy]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Compute::V1::Policy]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::GetIamPolicyInstanceRequest.new
              #
              #   # Call the get_iam_policy method.
              #   result = client.get_iam_policy request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Policy.
              #   p result
              #
              def get_iam_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::GetIamPolicyInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_iam_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_iam_policy.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_iam_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.get_iam_policy request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the screenshot from the specified instance.
              #
              # @overload get_screenshot(request, options = nil)
              #   Pass arguments to `get_screenshot` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::GetScreenshotInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::GetScreenshotInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_screenshot(instance: nil, project: nil, zone: nil)
              #   Pass arguments to `get_screenshot` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param instance [::String]
              #     Name of the instance scoping this request.
              #   @param project [::String]
              #     Project ID for this request.
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Compute::V1::Screenshot]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Compute::V1::Screenshot]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::GetScreenshotInstanceRequest.new
              #
              #   # Call the get_screenshot method.
              #   result = client.get_screenshot request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Screenshot.
              #   p result
              #
              def get_screenshot request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::GetScreenshotInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_screenshot.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_screenshot.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_screenshot.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.get_screenshot request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the last 1 MB of serial port output from the specified instance.
              #
              # @overload get_serial_port_output(request, options = nil)
              #   Pass arguments to `get_serial_port_output` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::GetSerialPortOutputInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::GetSerialPortOutputInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_serial_port_output(instance: nil, port: nil, project: nil, start: nil, zone: nil)
              #   Pass arguments to `get_serial_port_output` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param instance [::String]
              #     Name of the instance for this request.
              #   @param port [::Integer]
              #     Specifies which COM or serial port to retrieve data from.
              #   @param project [::String]
              #     Project ID for this request.
              #   @param start [::Integer]
              #     Specifies the starting byte position of the output to return. To start with the first byte of output to the specified port, omit this field or set it to `0`. If the output for that byte position is available, this field matches the `start` parameter sent with the request. If the amount of serial console output exceeds the size of the buffer (1 MB), the oldest output is discarded and is no longer available. If the requested start position refers to discarded output, the start position is adjusted to the oldest output still available, and the adjusted start position is returned as the `start` property value. You can also provide a negative start position, which translates to the most recent number of bytes written to the serial port. For example, -3 is interpreted as the most recent 3 bytes written to the serial console. Note that the negative start is bounded by the retained buffer size, and the returned serial console output will not exceed the max buffer size.
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Compute::V1::SerialPortOutput]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Compute::V1::SerialPortOutput]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::GetSerialPortOutputInstanceRequest.new
              #
              #   # Call the get_serial_port_output method.
              #   result = client.get_serial_port_output request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::SerialPortOutput.
              #   p result
              #
              def get_serial_port_output request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::GetSerialPortOutputInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_serial_port_output.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_serial_port_output.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_serial_port_output.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.get_serial_port_output request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the Shielded Instance Identity of an instance
              #
              # @overload get_shielded_instance_identity(request, options = nil)
              #   Pass arguments to `get_shielded_instance_identity` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::GetShieldedInstanceIdentityInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::GetShieldedInstanceIdentityInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_shielded_instance_identity(instance: nil, project: nil, zone: nil)
              #   Pass arguments to `get_shielded_instance_identity` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param instance [::String]
              #     Name or id of the instance scoping this request.
              #   @param project [::String]
              #     Project ID for this request.
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Compute::V1::ShieldedInstanceIdentity]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Compute::V1::ShieldedInstanceIdentity]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::GetShieldedInstanceIdentityInstanceRequest.new
              #
              #   # Call the get_shielded_instance_identity method.
              #   result = client.get_shielded_instance_identity request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::ShieldedInstanceIdentity.
              #   p result
              #
              def get_shielded_instance_identity request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::GetShieldedInstanceIdentityInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_shielded_instance_identity.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_shielded_instance_identity.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_shielded_instance_identity.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.get_shielded_instance_identity request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates an instance resource in the specified project using the data included in the request.
              #
              # @overload insert(request, options = nil)
              #   Pass arguments to `insert` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::InsertInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::InsertInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload insert(instance_resource: nil, project: nil, request_id: nil, source_instance_template: nil, source_machine_image: nil, zone: nil)
              #   Pass arguments to `insert` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param instance_resource [::Google::Cloud::Compute::V1::Instance, ::Hash]
              #     The body resource for this request
              #   @param project [::String]
              #     Project ID for this request.
              #   @param request_id [::String]
              #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
              #   @param source_instance_template [::String]
              #     Specifies instance template to create the instance. This field is optional. It can be a full or partial URL. For example, the following are all valid URLs to an instance template: - https://www.googleapis.com/compute/v1/projects/project /global/instanceTemplates/instanceTemplate - projects/project/global/instanceTemplates/instanceTemplate - global/instanceTemplates/instanceTemplate
              #   @param source_machine_image [::String]
              #     Specifies the machine image to use to create the instance. This field is optional. It can be a full or partial URL. For example, the following are all valid URLs to a machine image: - https://www.googleapis.com/compute/v1/projects/project/global/global /machineImages/machineImage - projects/project/global/global/machineImages/machineImage - global/machineImages/machineImage
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::GenericLRO::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::GenericLRO::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::InsertInstanceRequest.new
              #
              #   # Call the insert method.
              #   result = client.insert request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Operation.
              #   p result
              #
              def insert request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::InsertInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.insert.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.insert.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.insert.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.insert request, options do |result, response|
                  result = ::Google::Cloud::Compute::V1::ZoneOperations::Rest::NonstandardLro.create_operation(
                    operation: result,
                    client: zone_operations,
                    request_values: {
                      "project" => request.project,
                      "zone" => request.zone
                    },
                    options: options
                  )
                  yield result, response if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Retrieves the list of instances contained within the specified zone.
              #
              # @overload list(request, options = nil)
              #   Pass arguments to `list` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::ListInstancesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::ListInstancesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list(filter: nil, max_results: nil, order_by: nil, page_token: nil, project: nil, return_partial_success: nil, zone: nil)
              #   Pass arguments to `list` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param filter [::String]
              #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
              #   @param max_results [::Integer]
              #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
              #   @param order_by [::String]
              #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
              #   @param page_token [::String]
              #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
              #   @param project [::String]
              #     Project ID for this request.
              #   @param return_partial_success [::Boolean]
              #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Compute::V1::Instance>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Compute::V1::Instance>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::ListInstancesRequest.new
              #
              #   # Call the list method.
              #   result = client.list request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::InstanceList.
              #   p result
              #
              def list request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::ListInstancesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.list request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @instances_stub, :list, "items", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Retrieves a list of resources that refer to the VM instance specified in the request. For example, if the VM instance is part of a managed or unmanaged instance group, the referrers list includes the instance group. For more information, read Viewing referrers to VM instances.
              #
              # @overload list_referrers(request, options = nil)
              #   Pass arguments to `list_referrers` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::ListReferrersInstancesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::ListReferrersInstancesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_referrers(filter: nil, instance: nil, max_results: nil, order_by: nil, page_token: nil, project: nil, return_partial_success: nil, zone: nil)
              #   Pass arguments to `list_referrers` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param filter [::String]
              #     A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
              #   @param instance [::String]
              #     Name of the target instance scoping this request, or '-' if the request should span over all instances in the container.
              #   @param max_results [::Integer]
              #     The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
              #   @param order_by [::String]
              #     Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
              #   @param page_token [::String]
              #     Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
              #   @param project [::String]
              #     Project ID for this request.
              #   @param return_partial_success [::Boolean]
              #     Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Compute::V1::Reference>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Compute::V1::Reference>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::ListReferrersInstancesRequest.new
              #
              #   # Call the list_referrers method.
              #   result = client.list_referrers request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::InstanceListReferrers.
              #   p result
              #
              def list_referrers request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::ListReferrersInstancesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_referrers.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_referrers.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_referrers.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.list_referrers request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @instances_stub, :list_referrers, "items", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Perform a manual maintenance on the instance.
              #
              # @overload perform_maintenance(request, options = nil)
              #   Pass arguments to `perform_maintenance` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::PerformMaintenanceInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::PerformMaintenanceInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload perform_maintenance(instance: nil, project: nil, request_id: nil, zone: nil)
              #   Pass arguments to `perform_maintenance` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param instance [::String]
              #     Name of the instance scoping this request.
              #   @param project [::String]
              #     Project ID for this request.
              #   @param request_id [::String]
              #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::GenericLRO::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::GenericLRO::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::PerformMaintenanceInstanceRequest.new
              #
              #   # Call the perform_maintenance method.
              #   result = client.perform_maintenance request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Operation.
              #   p result
              #
              def perform_maintenance request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::PerformMaintenanceInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.perform_maintenance.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.perform_maintenance.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.perform_maintenance.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.perform_maintenance request, options do |result, response|
                  result = ::Google::Cloud::Compute::V1::ZoneOperations::Rest::NonstandardLro.create_operation(
                    operation: result,
                    client: zone_operations,
                    request_values: {
                      "project" => request.project,
                      "zone" => request.zone
                    },
                    options: options
                  )
                  yield result, response if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Removes resource policies from an instance.
              #
              # @overload remove_resource_policies(request, options = nil)
              #   Pass arguments to `remove_resource_policies` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::RemoveResourcePoliciesInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::RemoveResourcePoliciesInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload remove_resource_policies(instance: nil, instances_remove_resource_policies_request_resource: nil, project: nil, request_id: nil, zone: nil)
              #   Pass arguments to `remove_resource_policies` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param instance [::String]
              #     The instance name for this request.
              #   @param instances_remove_resource_policies_request_resource [::Google::Cloud::Compute::V1::InstancesRemoveResourcePoliciesRequest, ::Hash]
              #     The body resource for this request
              #   @param project [::String]
              #     Project ID for this request.
              #   @param request_id [::String]
              #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::GenericLRO::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::GenericLRO::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::RemoveResourcePoliciesInstanceRequest.new
              #
              #   # Call the remove_resource_policies method.
              #   result = client.remove_resource_policies request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Operation.
              #   p result
              #
              def remove_resource_policies request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::RemoveResourcePoliciesInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.remove_resource_policies.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.remove_resource_policies.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.remove_resource_policies.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.remove_resource_policies request, options do |result, response|
                  result = ::Google::Cloud::Compute::V1::ZoneOperations::Rest::NonstandardLro.create_operation(
                    operation: result,
                    client: zone_operations,
                    request_values: {
                      "project" => request.project,
                      "zone" => request.zone
                    },
                    options: options
                  )
                  yield result, response if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Mark the host as faulty and try to restart the instance on a new host.
              #
              # @overload report_host_as_faulty(request, options = nil)
              #   Pass arguments to `report_host_as_faulty` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::ReportHostAsFaultyInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::ReportHostAsFaultyInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload report_host_as_faulty(instance: nil, instances_report_host_as_faulty_request_resource: nil, project: nil, request_id: nil, zone: nil)
              #   Pass arguments to `report_host_as_faulty` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param instance [::String]
              #     Name of the instance scoping this request.
              #   @param instances_report_host_as_faulty_request_resource [::Google::Cloud::Compute::V1::InstancesReportHostAsFaultyRequest, ::Hash]
              #     The body resource for this request
              #   @param project [::String]
              #     Project ID for this request.
              #   @param request_id [::String]
              #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::GenericLRO::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::GenericLRO::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::ReportHostAsFaultyInstanceRequest.new
              #
              #   # Call the report_host_as_faulty method.
              #   result = client.report_host_as_faulty request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Operation.
              #   p result
              #
              def report_host_as_faulty request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::ReportHostAsFaultyInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.report_host_as_faulty.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.report_host_as_faulty.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.report_host_as_faulty.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.report_host_as_faulty request, options do |result, response|
                  result = ::Google::Cloud::Compute::V1::ZoneOperations::Rest::NonstandardLro.create_operation(
                    operation: result,
                    client: zone_operations,
                    request_values: {
                      "project" => request.project,
                      "zone" => request.zone
                    },
                    options: options
                  )
                  yield result, response if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Performs a reset on the instance. This is a hard reset. The VM does not do a graceful shutdown. For more information, see Resetting an instance.
              #
              # @overload reset(request, options = nil)
              #   Pass arguments to `reset` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::ResetInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::ResetInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload reset(instance: nil, project: nil, request_id: nil, zone: nil)
              #   Pass arguments to `reset` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param instance [::String]
              #     Name of the instance scoping this request.
              #   @param project [::String]
              #     Project ID for this request.
              #   @param request_id [::String]
              #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::GenericLRO::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::GenericLRO::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::ResetInstanceRequest.new
              #
              #   # Call the reset method.
              #   result = client.reset request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Operation.
              #   p result
              #
              def reset request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::ResetInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.reset.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.reset.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.reset.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.reset request, options do |result, response|
                  result = ::Google::Cloud::Compute::V1::ZoneOperations::Rest::NonstandardLro.create_operation(
                    operation: result,
                    client: zone_operations,
                    request_values: {
                      "project" => request.project,
                      "zone" => request.zone
                    },
                    options: options
                  )
                  yield result, response if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Resumes an instance that was suspended using the instances().suspend method.
              #
              # @overload resume(request, options = nil)
              #   Pass arguments to `resume` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::ResumeInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::ResumeInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload resume(instance: nil, project: nil, request_id: nil, zone: nil)
              #   Pass arguments to `resume` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param instance [::String]
              #     Name of the instance resource to resume.
              #   @param project [::String]
              #     Project ID for this request.
              #   @param request_id [::String]
              #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::GenericLRO::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::GenericLRO::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::ResumeInstanceRequest.new
              #
              #   # Call the resume method.
              #   result = client.resume request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Operation.
              #   p result
              #
              def resume request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::ResumeInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.resume.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.resume.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.resume.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.resume request, options do |result, response|
                  result = ::Google::Cloud::Compute::V1::ZoneOperations::Rest::NonstandardLro.create_operation(
                    operation: result,
                    client: zone_operations,
                    request_values: {
                      "project" => request.project,
                      "zone" => request.zone
                    },
                    options: options
                  )
                  yield result, response if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Sends diagnostic interrupt to the instance.
              #
              # @overload send_diagnostic_interrupt(request, options = nil)
              #   Pass arguments to `send_diagnostic_interrupt` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::SendDiagnosticInterruptInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::SendDiagnosticInterruptInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload send_diagnostic_interrupt(instance: nil, project: nil, zone: nil)
              #   Pass arguments to `send_diagnostic_interrupt` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param instance [::String]
              #     Name of the instance scoping this request.
              #   @param project [::String]
              #     Project ID for this request.
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Compute::V1::SendDiagnosticInterruptInstanceResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Compute::V1::SendDiagnosticInterruptInstanceResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::SendDiagnosticInterruptInstanceRequest.new
              #
              #   # Call the send_diagnostic_interrupt method.
              #   result = client.send_diagnostic_interrupt request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::SendDiagnosticInterruptInstanceResponse.
              #   p result
              #
              def send_diagnostic_interrupt request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::SendDiagnosticInterruptInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.send_diagnostic_interrupt.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.send_diagnostic_interrupt.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.send_diagnostic_interrupt.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.send_diagnostic_interrupt request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Sets deletion protection on the instance.
              #
              # @overload set_deletion_protection(request, options = nil)
              #   Pass arguments to `set_deletion_protection` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::SetDeletionProtectionInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::SetDeletionProtectionInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload set_deletion_protection(deletion_protection: nil, project: nil, request_id: nil, resource: nil, zone: nil)
              #   Pass arguments to `set_deletion_protection` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param deletion_protection [::Boolean]
              #     Whether the resource should be protected against deletion.
              #   @param project [::String]
              #     Project ID for this request.
              #   @param request_id [::String]
              #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
              #   @param resource [::String]
              #     Name or id of the resource for this request.
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::GenericLRO::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::GenericLRO::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::SetDeletionProtectionInstanceRequest.new
              #
              #   # Call the set_deletion_protection method.
              #   result = client.set_deletion_protection request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Operation.
              #   p result
              #
              def set_deletion_protection request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::SetDeletionProtectionInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.set_deletion_protection.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.set_deletion_protection.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.set_deletion_protection.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.set_deletion_protection request, options do |result, response|
                  result = ::Google::Cloud::Compute::V1::ZoneOperations::Rest::NonstandardLro.create_operation(
                    operation: result,
                    client: zone_operations,
                    request_values: {
                      "project" => request.project,
                      "zone" => request.zone
                    },
                    options: options
                  )
                  yield result, response if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Sets the auto-delete flag for a disk attached to an instance.
              #
              # @overload set_disk_auto_delete(request, options = nil)
              #   Pass arguments to `set_disk_auto_delete` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::SetDiskAutoDeleteInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::SetDiskAutoDeleteInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload set_disk_auto_delete(auto_delete: nil, device_name: nil, instance: nil, project: nil, request_id: nil, zone: nil)
              #   Pass arguments to `set_disk_auto_delete` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param auto_delete [::Boolean]
              #     Whether to auto-delete the disk when the instance is deleted.
              #   @param device_name [::String]
              #     The device name of the disk to modify. Make a get() request on the instance to view currently attached disks and device names.
              #   @param instance [::String]
              #     The instance name for this request.
              #   @param project [::String]
              #     Project ID for this request.
              #   @param request_id [::String]
              #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::GenericLRO::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::GenericLRO::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::SetDiskAutoDeleteInstanceRequest.new
              #
              #   # Call the set_disk_auto_delete method.
              #   result = client.set_disk_auto_delete request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Operation.
              #   p result
              #
              def set_disk_auto_delete request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::SetDiskAutoDeleteInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.set_disk_auto_delete.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.set_disk_auto_delete.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.set_disk_auto_delete.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.set_disk_auto_delete request, options do |result, response|
                  result = ::Google::Cloud::Compute::V1::ZoneOperations::Rest::NonstandardLro.create_operation(
                    operation: result,
                    client: zone_operations,
                    request_values: {
                      "project" => request.project,
                      "zone" => request.zone
                    },
                    options: options
                  )
                  yield result, response if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Sets the access control policy on the specified resource. Replaces any existing policy.
              #
              # @overload set_iam_policy(request, options = nil)
              #   Pass arguments to `set_iam_policy` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::SetIamPolicyInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::SetIamPolicyInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload set_iam_policy(project: nil, resource: nil, zone: nil, zone_set_policy_request_resource: nil)
              #   Pass arguments to `set_iam_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param project [::String]
              #     Project ID for this request.
              #   @param resource [::String]
              #     Name or id of the resource for this request.
              #   @param zone [::String]
              #     The name of the zone for this request.
              #   @param zone_set_policy_request_resource [::Google::Cloud::Compute::V1::ZoneSetPolicyRequest, ::Hash]
              #     The body resource for this request
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Compute::V1::Policy]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Compute::V1::Policy]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::SetIamPolicyInstanceRequest.new
              #
              #   # Call the set_iam_policy method.
              #   result = client.set_iam_policy request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Policy.
              #   p result
              #
              def set_iam_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::SetIamPolicyInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.set_iam_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.set_iam_policy.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.set_iam_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.set_iam_policy request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Sets labels on an instance. To learn more about labels, read the Labeling Resources documentation.
              #
              # @overload set_labels(request, options = nil)
              #   Pass arguments to `set_labels` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::SetLabelsInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::SetLabelsInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload set_labels(instance: nil, instances_set_labels_request_resource: nil, project: nil, request_id: nil, zone: nil)
              #   Pass arguments to `set_labels` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param instance [::String]
              #     Name of the instance scoping this request.
              #   @param instances_set_labels_request_resource [::Google::Cloud::Compute::V1::InstancesSetLabelsRequest, ::Hash]
              #     The body resource for this request
              #   @param project [::String]
              #     Project ID for this request.
              #   @param request_id [::String]
              #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::GenericLRO::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::GenericLRO::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::SetLabelsInstanceRequest.new
              #
              #   # Call the set_labels method.
              #   result = client.set_labels request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Operation.
              #   p result
              #
              def set_labels request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::SetLabelsInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.set_labels.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.set_labels.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.set_labels.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.set_labels request, options do |result, response|
                  result = ::Google::Cloud::Compute::V1::ZoneOperations::Rest::NonstandardLro.create_operation(
                    operation: result,
                    client: zone_operations,
                    request_values: {
                      "project" => request.project,
                      "zone" => request.zone
                    },
                    options: options
                  )
                  yield result, response if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Changes the number and/or type of accelerator for a stopped instance to the values specified in the request.
              #
              # @overload set_machine_resources(request, options = nil)
              #   Pass arguments to `set_machine_resources` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::SetMachineResourcesInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::SetMachineResourcesInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload set_machine_resources(instance: nil, instances_set_machine_resources_request_resource: nil, project: nil, request_id: nil, zone: nil)
              #   Pass arguments to `set_machine_resources` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param instance [::String]
              #     Name of the instance scoping this request.
              #   @param instances_set_machine_resources_request_resource [::Google::Cloud::Compute::V1::InstancesSetMachineResourcesRequest, ::Hash]
              #     The body resource for this request
              #   @param project [::String]
              #     Project ID for this request.
              #   @param request_id [::String]
              #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::GenericLRO::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::GenericLRO::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::SetMachineResourcesInstanceRequest.new
              #
              #   # Call the set_machine_resources method.
              #   result = client.set_machine_resources request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Operation.
              #   p result
              #
              def set_machine_resources request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::SetMachineResourcesInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.set_machine_resources.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.set_machine_resources.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.set_machine_resources.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.set_machine_resources request, options do |result, response|
                  result = ::Google::Cloud::Compute::V1::ZoneOperations::Rest::NonstandardLro.create_operation(
                    operation: result,
                    client: zone_operations,
                    request_values: {
                      "project" => request.project,
                      "zone" => request.zone
                    },
                    options: options
                  )
                  yield result, response if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Changes the machine type for a stopped instance to the machine type specified in the request.
              #
              # @overload set_machine_type(request, options = nil)
              #   Pass arguments to `set_machine_type` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::SetMachineTypeInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::SetMachineTypeInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload set_machine_type(instance: nil, instances_set_machine_type_request_resource: nil, project: nil, request_id: nil, zone: nil)
              #   Pass arguments to `set_machine_type` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param instance [::String]
              #     Name of the instance scoping this request.
              #   @param instances_set_machine_type_request_resource [::Google::Cloud::Compute::V1::InstancesSetMachineTypeRequest, ::Hash]
              #     The body resource for this request
              #   @param project [::String]
              #     Project ID for this request.
              #   @param request_id [::String]
              #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::GenericLRO::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::GenericLRO::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::SetMachineTypeInstanceRequest.new
              #
              #   # Call the set_machine_type method.
              #   result = client.set_machine_type request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Operation.
              #   p result
              #
              def set_machine_type request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::SetMachineTypeInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.set_machine_type.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.set_machine_type.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.set_machine_type.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.set_machine_type request, options do |result, response|
                  result = ::Google::Cloud::Compute::V1::ZoneOperations::Rest::NonstandardLro.create_operation(
                    operation: result,
                    client: zone_operations,
                    request_values: {
                      "project" => request.project,
                      "zone" => request.zone
                    },
                    options: options
                  )
                  yield result, response if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Sets metadata for the specified instance to the data included in the request.
              #
              # @overload set_metadata(request, options = nil)
              #   Pass arguments to `set_metadata` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::SetMetadataInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::SetMetadataInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload set_metadata(instance: nil, metadata_resource: nil, project: nil, request_id: nil, zone: nil)
              #   Pass arguments to `set_metadata` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param instance [::String]
              #     Name of the instance scoping this request.
              #   @param metadata_resource [::Google::Cloud::Compute::V1::Metadata, ::Hash]
              #     The body resource for this request
              #   @param project [::String]
              #     Project ID for this request.
              #   @param request_id [::String]
              #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::GenericLRO::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::GenericLRO::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::SetMetadataInstanceRequest.new
              #
              #   # Call the set_metadata method.
              #   result = client.set_metadata request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Operation.
              #   p result
              #
              def set_metadata request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::SetMetadataInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.set_metadata.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.set_metadata.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.set_metadata.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.set_metadata request, options do |result, response|
                  result = ::Google::Cloud::Compute::V1::ZoneOperations::Rest::NonstandardLro.create_operation(
                    operation: result,
                    client: zone_operations,
                    request_values: {
                      "project" => request.project,
                      "zone" => request.zone
                    },
                    options: options
                  )
                  yield result, response if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Changes the minimum CPU platform that this instance should use. This method can only be called on a stopped instance. For more information, read Specifying a Minimum CPU Platform.
              #
              # @overload set_min_cpu_platform(request, options = nil)
              #   Pass arguments to `set_min_cpu_platform` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::SetMinCpuPlatformInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::SetMinCpuPlatformInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload set_min_cpu_platform(instance: nil, instances_set_min_cpu_platform_request_resource: nil, project: nil, request_id: nil, zone: nil)
              #   Pass arguments to `set_min_cpu_platform` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param instance [::String]
              #     Name of the instance scoping this request.
              #   @param instances_set_min_cpu_platform_request_resource [::Google::Cloud::Compute::V1::InstancesSetMinCpuPlatformRequest, ::Hash]
              #     The body resource for this request
              #   @param project [::String]
              #     Project ID for this request.
              #   @param request_id [::String]
              #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::GenericLRO::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::GenericLRO::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::SetMinCpuPlatformInstanceRequest.new
              #
              #   # Call the set_min_cpu_platform method.
              #   result = client.set_min_cpu_platform request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Operation.
              #   p result
              #
              def set_min_cpu_platform request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::SetMinCpuPlatformInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.set_min_cpu_platform.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.set_min_cpu_platform.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.set_min_cpu_platform.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.set_min_cpu_platform request, options do |result, response|
                  result = ::Google::Cloud::Compute::V1::ZoneOperations::Rest::NonstandardLro.create_operation(
                    operation: result,
                    client: zone_operations,
                    request_values: {
                      "project" => request.project,
                      "zone" => request.zone
                    },
                    options: options
                  )
                  yield result, response if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Sets name of an instance.
              #
              # @overload set_name(request, options = nil)
              #   Pass arguments to `set_name` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::SetNameInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::SetNameInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload set_name(instance: nil, instances_set_name_request_resource: nil, project: nil, request_id: nil, zone: nil)
              #   Pass arguments to `set_name` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param instance [::String]
              #     The instance name for this request.
              #   @param instances_set_name_request_resource [::Google::Cloud::Compute::V1::InstancesSetNameRequest, ::Hash]
              #     The body resource for this request
              #   @param project [::String]
              #     Project ID for this request.
              #   @param request_id [::String]
              #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::GenericLRO::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::GenericLRO::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::SetNameInstanceRequest.new
              #
              #   # Call the set_name method.
              #   result = client.set_name request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Operation.
              #   p result
              #
              def set_name request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::SetNameInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.set_name.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.set_name.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.set_name.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.set_name request, options do |result, response|
                  result = ::Google::Cloud::Compute::V1::ZoneOperations::Rest::NonstandardLro.create_operation(
                    operation: result,
                    client: zone_operations,
                    request_values: {
                      "project" => request.project,
                      "zone" => request.zone
                    },
                    options: options
                  )
                  yield result, response if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Sets an instance's scheduling options. You can only call this method on a stopped instance, that is, a VM instance that is in a `TERMINATED` state. See Instance Life Cycle for more information on the possible instance states. For more information about setting scheduling options for a VM, see Set VM host maintenance policy.
              #
              # @overload set_scheduling(request, options = nil)
              #   Pass arguments to `set_scheduling` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::SetSchedulingInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::SetSchedulingInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload set_scheduling(instance: nil, project: nil, request_id: nil, scheduling_resource: nil, zone: nil)
              #   Pass arguments to `set_scheduling` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param instance [::String]
              #     Instance name for this request.
              #   @param project [::String]
              #     Project ID for this request.
              #   @param request_id [::String]
              #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
              #   @param scheduling_resource [::Google::Cloud::Compute::V1::Scheduling, ::Hash]
              #     The body resource for this request
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::GenericLRO::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::GenericLRO::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::SetSchedulingInstanceRequest.new
              #
              #   # Call the set_scheduling method.
              #   result = client.set_scheduling request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Operation.
              #   p result
              #
              def set_scheduling request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::SetSchedulingInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.set_scheduling.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.set_scheduling.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.set_scheduling.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.set_scheduling request, options do |result, response|
                  result = ::Google::Cloud::Compute::V1::ZoneOperations::Rest::NonstandardLro.create_operation(
                    operation: result,
                    client: zone_operations,
                    request_values: {
                      "project" => request.project,
                      "zone" => request.zone
                    },
                    options: options
                  )
                  yield result, response if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Sets the Google Cloud Armor security policy for the specified instance. For more information, see Google Cloud Armor Overview
              #
              # @overload set_security_policy(request, options = nil)
              #   Pass arguments to `set_security_policy` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::SetSecurityPolicyInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::SetSecurityPolicyInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload set_security_policy(instance: nil, instances_set_security_policy_request_resource: nil, project: nil, request_id: nil, zone: nil)
              #   Pass arguments to `set_security_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param instance [::String]
              #     Name of the Instance resource to which the security policy should be set. The name should conform to RFC1035.
              #   @param instances_set_security_policy_request_resource [::Google::Cloud::Compute::V1::InstancesSetSecurityPolicyRequest, ::Hash]
              #     The body resource for this request
              #   @param project [::String]
              #     Project ID for this request.
              #   @param request_id [::String]
              #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
              #   @param zone [::String]
              #     Name of the zone scoping this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::GenericLRO::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::GenericLRO::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::SetSecurityPolicyInstanceRequest.new
              #
              #   # Call the set_security_policy method.
              #   result = client.set_security_policy request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Operation.
              #   p result
              #
              def set_security_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::SetSecurityPolicyInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.set_security_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.set_security_policy.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.set_security_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.set_security_policy request, options do |result, response|
                  result = ::Google::Cloud::Compute::V1::ZoneOperations::Rest::NonstandardLro.create_operation(
                    operation: result,
                    client: zone_operations,
                    request_values: {
                      "project" => request.project,
                      "zone" => request.zone
                    },
                    options: options
                  )
                  yield result, response if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Sets the service account on the instance. For more information, read Changing the service account and access scopes for an instance.
              #
              # @overload set_service_account(request, options = nil)
              #   Pass arguments to `set_service_account` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::SetServiceAccountInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::SetServiceAccountInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload set_service_account(instance: nil, instances_set_service_account_request_resource: nil, project: nil, request_id: nil, zone: nil)
              #   Pass arguments to `set_service_account` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param instance [::String]
              #     Name of the instance resource to start.
              #   @param instances_set_service_account_request_resource [::Google::Cloud::Compute::V1::InstancesSetServiceAccountRequest, ::Hash]
              #     The body resource for this request
              #   @param project [::String]
              #     Project ID for this request.
              #   @param request_id [::String]
              #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::GenericLRO::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::GenericLRO::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::SetServiceAccountInstanceRequest.new
              #
              #   # Call the set_service_account method.
              #   result = client.set_service_account request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Operation.
              #   p result
              #
              def set_service_account request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::SetServiceAccountInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.set_service_account.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.set_service_account.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.set_service_account.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.set_service_account request, options do |result, response|
                  result = ::Google::Cloud::Compute::V1::ZoneOperations::Rest::NonstandardLro.create_operation(
                    operation: result,
                    client: zone_operations,
                    request_values: {
                      "project" => request.project,
                      "zone" => request.zone
                    },
                    options: options
                  )
                  yield result, response if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Sets the Shielded Instance integrity policy for an instance. You can only use this method on a running instance. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
              #
              # @overload set_shielded_instance_integrity_policy(request, options = nil)
              #   Pass arguments to `set_shielded_instance_integrity_policy` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::SetShieldedInstanceIntegrityPolicyInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::SetShieldedInstanceIntegrityPolicyInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload set_shielded_instance_integrity_policy(instance: nil, project: nil, request_id: nil, shielded_instance_integrity_policy_resource: nil, zone: nil)
              #   Pass arguments to `set_shielded_instance_integrity_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param instance [::String]
              #     Name or id of the instance scoping this request.
              #   @param project [::String]
              #     Project ID for this request.
              #   @param request_id [::String]
              #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
              #   @param shielded_instance_integrity_policy_resource [::Google::Cloud::Compute::V1::ShieldedInstanceIntegrityPolicy, ::Hash]
              #     The body resource for this request
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::GenericLRO::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::GenericLRO::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::SetShieldedInstanceIntegrityPolicyInstanceRequest.new
              #
              #   # Call the set_shielded_instance_integrity_policy method.
              #   result = client.set_shielded_instance_integrity_policy request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Operation.
              #   p result
              #
              def set_shielded_instance_integrity_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::SetShieldedInstanceIntegrityPolicyInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.set_shielded_instance_integrity_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.set_shielded_instance_integrity_policy.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.set_shielded_instance_integrity_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.set_shielded_instance_integrity_policy request, options do |result, response|
                  result = ::Google::Cloud::Compute::V1::ZoneOperations::Rest::NonstandardLro.create_operation(
                    operation: result,
                    client: zone_operations,
                    request_values: {
                      "project" => request.project,
                      "zone" => request.zone
                    },
                    options: options
                  )
                  yield result, response if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Sets network tags for the specified instance to the data included in the request.
              #
              # @overload set_tags(request, options = nil)
              #   Pass arguments to `set_tags` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::SetTagsInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::SetTagsInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload set_tags(instance: nil, project: nil, request_id: nil, tags_resource: nil, zone: nil)
              #   Pass arguments to `set_tags` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param instance [::String]
              #     Name of the instance scoping this request.
              #   @param project [::String]
              #     Project ID for this request.
              #   @param request_id [::String]
              #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
              #   @param tags_resource [::Google::Cloud::Compute::V1::Tags, ::Hash]
              #     The body resource for this request
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::GenericLRO::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::GenericLRO::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::SetTagsInstanceRequest.new
              #
              #   # Call the set_tags method.
              #   result = client.set_tags request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Operation.
              #   p result
              #
              def set_tags request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::SetTagsInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.set_tags.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.set_tags.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.set_tags.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.set_tags request, options do |result, response|
                  result = ::Google::Cloud::Compute::V1::ZoneOperations::Rest::NonstandardLro.create_operation(
                    operation: result,
                    client: zone_operations,
                    request_values: {
                      "project" => request.project,
                      "zone" => request.zone
                    },
                    options: options
                  )
                  yield result, response if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Simulates a host maintenance event on a VM. For more information, see Simulate a host maintenance event.
              #
              # @overload simulate_maintenance_event(request, options = nil)
              #   Pass arguments to `simulate_maintenance_event` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::SimulateMaintenanceEventInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::SimulateMaintenanceEventInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload simulate_maintenance_event(instance: nil, project: nil, request_id: nil, with_extended_notifications: nil, zone: nil)
              #   Pass arguments to `simulate_maintenance_event` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param instance [::String]
              #     Name of the instance scoping this request.
              #   @param project [::String]
              #     Project ID for this request.
              #   @param request_id [::String]
              #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
              #   @param with_extended_notifications [::Boolean]
              #     Determines whether the customers receive notifications before migration. Only applicable to SF vms.
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::GenericLRO::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::GenericLRO::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::SimulateMaintenanceEventInstanceRequest.new
              #
              #   # Call the simulate_maintenance_event method.
              #   result = client.simulate_maintenance_event request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Operation.
              #   p result
              #
              def simulate_maintenance_event request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::SimulateMaintenanceEventInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.simulate_maintenance_event.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.simulate_maintenance_event.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.simulate_maintenance_event.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.simulate_maintenance_event request, options do |result, response|
                  result = ::Google::Cloud::Compute::V1::ZoneOperations::Rest::NonstandardLro.create_operation(
                    operation: result,
                    client: zone_operations,
                    request_values: {
                      "project" => request.project,
                      "zone" => request.zone
                    },
                    options: options
                  )
                  yield result, response if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Starts an instance that was stopped using the instances().stop method. For more information, see Restart an instance.
              #
              # @overload start(request, options = nil)
              #   Pass arguments to `start` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::StartInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::StartInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload start(instance: nil, project: nil, request_id: nil, zone: nil)
              #   Pass arguments to `start` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param instance [::String]
              #     Name of the instance resource to start.
              #   @param project [::String]
              #     Project ID for this request.
              #   @param request_id [::String]
              #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::GenericLRO::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::GenericLRO::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::StartInstanceRequest.new
              #
              #   # Call the start method.
              #   result = client.start request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Operation.
              #   p result
              #
              def start request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::StartInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.start.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.start.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.start.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.start request, options do |result, response|
                  result = ::Google::Cloud::Compute::V1::ZoneOperations::Rest::NonstandardLro.create_operation(
                    operation: result,
                    client: zone_operations,
                    request_values: {
                      "project" => request.project,
                      "zone" => request.zone
                    },
                    options: options
                  )
                  yield result, response if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Starts an instance that was stopped using the instances().stop method. For more information, see Restart an instance.
              #
              # @overload start_with_encryption_key(request, options = nil)
              #   Pass arguments to `start_with_encryption_key` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::StartWithEncryptionKeyInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::StartWithEncryptionKeyInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload start_with_encryption_key(instance: nil, instances_start_with_encryption_key_request_resource: nil, project: nil, request_id: nil, zone: nil)
              #   Pass arguments to `start_with_encryption_key` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param instance [::String]
              #     Name of the instance resource to start.
              #   @param instances_start_with_encryption_key_request_resource [::Google::Cloud::Compute::V1::InstancesStartWithEncryptionKeyRequest, ::Hash]
              #     The body resource for this request
              #   @param project [::String]
              #     Project ID for this request.
              #   @param request_id [::String]
              #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::GenericLRO::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::GenericLRO::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::StartWithEncryptionKeyInstanceRequest.new
              #
              #   # Call the start_with_encryption_key method.
              #   result = client.start_with_encryption_key request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Operation.
              #   p result
              #
              def start_with_encryption_key request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::StartWithEncryptionKeyInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.start_with_encryption_key.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.start_with_encryption_key.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.start_with_encryption_key.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.start_with_encryption_key request, options do |result, response|
                  result = ::Google::Cloud::Compute::V1::ZoneOperations::Rest::NonstandardLro.create_operation(
                    operation: result,
                    client: zone_operations,
                    request_values: {
                      "project" => request.project,
                      "zone" => request.zone
                    },
                    options: options
                  )
                  yield result, response if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Stops a running instance, shutting it down cleanly, and allows you to restart the instance at a later time. Stopped instances do not incur VM usage charges while they are stopped. However, resources that the VM is using, such as persistent disks and static IP addresses, will continue to be charged until they are deleted. For more information, see Stopping an instance.
              #
              # @overload stop(request, options = nil)
              #   Pass arguments to `stop` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::StopInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::StopInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload stop(discard_local_ssd: nil, instance: nil, project: nil, request_id: nil, zone: nil)
              #   Pass arguments to `stop` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param discard_local_ssd [::Boolean]
              #     This property is required if the instance has any attached Local SSD disks. If false, Local SSD data will be preserved when the instance is suspended. If true, the contents of any attached Local SSD disks will be discarded.
              #   @param instance [::String]
              #     Name of the instance resource to stop.
              #   @param project [::String]
              #     Project ID for this request.
              #   @param request_id [::String]
              #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::GenericLRO::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::GenericLRO::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::StopInstanceRequest.new
              #
              #   # Call the stop method.
              #   result = client.stop request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Operation.
              #   p result
              #
              def stop request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::StopInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.stop.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.stop.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.stop.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.stop request, options do |result, response|
                  result = ::Google::Cloud::Compute::V1::ZoneOperations::Rest::NonstandardLro.create_operation(
                    operation: result,
                    client: zone_operations,
                    request_values: {
                      "project" => request.project,
                      "zone" => request.zone
                    },
                    options: options
                  )
                  yield result, response if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # This method suspends a running instance, saving its state to persistent storage, and allows you to resume the instance at a later time. Suspended instances have no compute costs (cores or RAM), and incur only storage charges for the saved VM memory and localSSD data. Any charged resources the virtual machine was using, such as persistent disks and static IP addresses, will continue to be charged while the instance is suspended. For more information, see Suspending and resuming an instance.
              #
              # @overload suspend(request, options = nil)
              #   Pass arguments to `suspend` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::SuspendInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::SuspendInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload suspend(discard_local_ssd: nil, instance: nil, project: nil, request_id: nil, zone: nil)
              #   Pass arguments to `suspend` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param discard_local_ssd [::Boolean]
              #     This property is required if the instance has any attached Local SSD disks. If false, Local SSD data will be preserved when the instance is suspended. If true, the contents of any attached Local SSD disks will be discarded.
              #   @param instance [::String]
              #     Name of the instance resource to suspend.
              #   @param project [::String]
              #     Project ID for this request.
              #   @param request_id [::String]
              #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::GenericLRO::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::GenericLRO::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::SuspendInstanceRequest.new
              #
              #   # Call the suspend method.
              #   result = client.suspend request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Operation.
              #   p result
              #
              def suspend request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::SuspendInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.suspend.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.suspend.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.suspend.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.suspend request, options do |result, response|
                  result = ::Google::Cloud::Compute::V1::ZoneOperations::Rest::NonstandardLro.create_operation(
                    operation: result,
                    client: zone_operations,
                    request_values: {
                      "project" => request.project,
                      "zone" => request.zone
                    },
                    options: options
                  )
                  yield result, response if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns permissions that a caller has on the specified resource.
              #
              # @overload test_iam_permissions(request, options = nil)
              #   Pass arguments to `test_iam_permissions` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::TestIamPermissionsInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::TestIamPermissionsInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload test_iam_permissions(project: nil, resource: nil, test_permissions_request_resource: nil, zone: nil)
              #   Pass arguments to `test_iam_permissions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param project [::String]
              #     Project ID for this request.
              #   @param resource [::String]
              #     Name or id of the resource for this request.
              #   @param test_permissions_request_resource [::Google::Cloud::Compute::V1::TestPermissionsRequest, ::Hash]
              #     The body resource for this request
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Compute::V1::TestPermissionsResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Compute::V1::TestPermissionsResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::TestIamPermissionsInstanceRequest.new
              #
              #   # Call the test_iam_permissions method.
              #   result = client.test_iam_permissions request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::TestPermissionsResponse.
              #   p result
              #
              def test_iam_permissions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::TestIamPermissionsInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.test_iam_permissions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.test_iam_permissions.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.test_iam_permissions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.test_iam_permissions request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates an instance only if the necessary resources are available. This method can update only a specific set of instance properties. See Updating a running instance for a list of updatable instance properties.
              #
              # @overload update(request, options = nil)
              #   Pass arguments to `update` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::UpdateInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::UpdateInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update(instance: nil, instance_resource: nil, minimal_action: nil, most_disruptive_allowed_action: nil, project: nil, request_id: nil, zone: nil)
              #   Pass arguments to `update` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param instance [::String]
              #     Name of the instance resource to update.
              #   @param instance_resource [::Google::Cloud::Compute::V1::Instance, ::Hash]
              #     The body resource for this request
              #   @param minimal_action [::String]
              #     Specifies the action to take when updating an instance even if the updated properties do not require it. If not specified, then Compute Engine acts based on the minimum action that the updated properties require.
              #     Check the MinimalAction enum for the list of possible values.
              #   @param most_disruptive_allowed_action [::String]
              #     Specifies the most disruptive action that can be taken on the instance as part of the update. Compute Engine returns an error if the instance properties require a more disruptive action as part of the instance update. Valid options from lowest to highest are NO_EFFECT, REFRESH, and RESTART.
              #     Check the MostDisruptiveAllowedAction enum for the list of possible values.
              #   @param project [::String]
              #     Project ID for this request.
              #   @param request_id [::String]
              #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::GenericLRO::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::GenericLRO::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::UpdateInstanceRequest.new
              #
              #   # Call the update method.
              #   result = client.update request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Operation.
              #   p result
              #
              def update request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::UpdateInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.update request, options do |result, response|
                  result = ::Google::Cloud::Compute::V1::ZoneOperations::Rest::NonstandardLro.create_operation(
                    operation: result,
                    client: zone_operations,
                    request_values: {
                      "project" => request.project,
                      "zone" => request.zone
                    },
                    options: options
                  )
                  yield result, response if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the specified access config from an instance's network interface with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
              #
              # @overload update_access_config(request, options = nil)
              #   Pass arguments to `update_access_config` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::UpdateAccessConfigInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::UpdateAccessConfigInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_access_config(access_config_resource: nil, instance: nil, network_interface: nil, project: nil, request_id: nil, zone: nil)
              #   Pass arguments to `update_access_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param access_config_resource [::Google::Cloud::Compute::V1::AccessConfig, ::Hash]
              #     The body resource for this request
              #   @param instance [::String]
              #     The instance name for this request.
              #   @param network_interface [::String]
              #     The name of the network interface where the access config is attached.
              #   @param project [::String]
              #     Project ID for this request.
              #   @param request_id [::String]
              #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::GenericLRO::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::GenericLRO::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::UpdateAccessConfigInstanceRequest.new
              #
              #   # Call the update_access_config method.
              #   result = client.update_access_config request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Operation.
              #   p result
              #
              def update_access_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::UpdateAccessConfigInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_access_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_access_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_access_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.update_access_config request, options do |result, response|
                  result = ::Google::Cloud::Compute::V1::ZoneOperations::Rest::NonstandardLro.create_operation(
                    operation: result,
                    client: zone_operations,
                    request_values: {
                      "project" => request.project,
                      "zone" => request.zone
                    },
                    options: options
                  )
                  yield result, response if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the Display config for a VM instance. You can only use this method on a stopped VM instance. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
              #
              # @overload update_display_device(request, options = nil)
              #   Pass arguments to `update_display_device` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::UpdateDisplayDeviceInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::UpdateDisplayDeviceInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_display_device(display_device_resource: nil, instance: nil, project: nil, request_id: nil, zone: nil)
              #   Pass arguments to `update_display_device` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param display_device_resource [::Google::Cloud::Compute::V1::DisplayDevice, ::Hash]
              #     The body resource for this request
              #   @param instance [::String]
              #     Name of the instance scoping this request.
              #   @param project [::String]
              #     Project ID for this request.
              #   @param request_id [::String]
              #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::GenericLRO::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::GenericLRO::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::UpdateDisplayDeviceInstanceRequest.new
              #
              #   # Call the update_display_device method.
              #   result = client.update_display_device request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Operation.
              #   p result
              #
              def update_display_device request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::UpdateDisplayDeviceInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_display_device.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_display_device.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_display_device.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.update_display_device request, options do |result, response|
                  result = ::Google::Cloud::Compute::V1::ZoneOperations::Rest::NonstandardLro.create_operation(
                    operation: result,
                    client: zone_operations,
                    request_values: {
                      "project" => request.project,
                      "zone" => request.zone
                    },
                    options: options
                  )
                  yield result, response if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates an instance's network interface. This method can only update an interface's alias IP range and attached network. See Modifying alias IP ranges for an existing instance for instructions on changing alias IP ranges. See Migrating a VM between networks for instructions on migrating an interface. This method follows PATCH semantics.
              #
              # @overload update_network_interface(request, options = nil)
              #   Pass arguments to `update_network_interface` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::UpdateNetworkInterfaceInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::UpdateNetworkInterfaceInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_network_interface(instance: nil, network_interface: nil, network_interface_resource: nil, project: nil, request_id: nil, zone: nil)
              #   Pass arguments to `update_network_interface` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param instance [::String]
              #     The instance name for this request.
              #   @param network_interface [::String]
              #     The name of the network interface to update.
              #   @param network_interface_resource [::Google::Cloud::Compute::V1::NetworkInterface, ::Hash]
              #     The body resource for this request
              #   @param project [::String]
              #     Project ID for this request.
              #   @param request_id [::String]
              #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::GenericLRO::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::GenericLRO::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::UpdateNetworkInterfaceInstanceRequest.new
              #
              #   # Call the update_network_interface method.
              #   result = client.update_network_interface request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Operation.
              #   p result
              #
              def update_network_interface request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::UpdateNetworkInterfaceInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_network_interface.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_network_interface.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_network_interface.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.update_network_interface request, options do |result, response|
                  result = ::Google::Cloud::Compute::V1::ZoneOperations::Rest::NonstandardLro.create_operation(
                    operation: result,
                    client: zone_operations,
                    request_values: {
                      "project" => request.project,
                      "zone" => request.zone
                    },
                    options: options
                  )
                  yield result, response if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the Shielded Instance config for an instance. You can only use this method on a stopped instance. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
              #
              # @overload update_shielded_instance_config(request, options = nil)
              #   Pass arguments to `update_shielded_instance_config` via a request object, either of type
              #   {::Google::Cloud::Compute::V1::UpdateShieldedInstanceConfigInstanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Compute::V1::UpdateShieldedInstanceConfigInstanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_shielded_instance_config(instance: nil, project: nil, request_id: nil, shielded_instance_config_resource: nil, zone: nil)
              #   Pass arguments to `update_shielded_instance_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param instance [::String]
              #     Name or id of the instance scoping this request.
              #   @param project [::String]
              #     Project ID for this request.
              #   @param request_id [::String]
              #     An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
              #   @param shielded_instance_config_resource [::Google::Cloud::Compute::V1::ShieldedInstanceConfig, ::Hash]
              #     The body resource for this request
              #   @param zone [::String]
              #     The name of the zone for this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::GenericLRO::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::GenericLRO::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/compute/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Compute::V1::Instances::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Compute::V1::UpdateShieldedInstanceConfigInstanceRequest.new
              #
              #   # Call the update_shielded_instance_config method.
              #   result = client.update_shielded_instance_config request
              #
              #   # The returned object is of type Google::Cloud::Compute::V1::Operation.
              #   p result
              #
              def update_shielded_instance_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Compute::V1::UpdateShieldedInstanceConfigInstanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_shielded_instance_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Compute::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_shielded_instance_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_shielded_instance_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @instances_stub.update_shielded_instance_config request, options do |result, response|
                  result = ::Google::Cloud::Compute::V1::ZoneOperations::Rest::NonstandardLro.create_operation(
                    operation: result,
                    client: zone_operations,
                    request_values: {
                      "project" => request.project,
                      "zone" => request.zone
                    },
                    options: options
                  )
                  yield result, response if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the Instances REST API.
              #
              # This class represents the configuration for Instances REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Compute::V1::Instances::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # add_access_config to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Compute::V1::Instances::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.add_access_config.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Compute::V1::Instances::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.add_access_config.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "compute.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the Instances API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `add_access_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :add_access_config
                  ##
                  # RPC-specific configuration for `add_network_interface`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :add_network_interface
                  ##
                  # RPC-specific configuration for `add_resource_policies`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :add_resource_policies
                  ##
                  # RPC-specific configuration for `aggregated_list`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :aggregated_list
                  ##
                  # RPC-specific configuration for `attach_disk`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :attach_disk
                  ##
                  # RPC-specific configuration for `bulk_insert`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :bulk_insert
                  ##
                  # RPC-specific configuration for `delete`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete
                  ##
                  # RPC-specific configuration for `delete_access_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_access_config
                  ##
                  # RPC-specific configuration for `delete_network_interface`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_network_interface
                  ##
                  # RPC-specific configuration for `detach_disk`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :detach_disk
                  ##
                  # RPC-specific configuration for `get`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get
                  ##
                  # RPC-specific configuration for `get_effective_firewalls`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_effective_firewalls
                  ##
                  # RPC-specific configuration for `get_guest_attributes`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_guest_attributes
                  ##
                  # RPC-specific configuration for `get_iam_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_iam_policy
                  ##
                  # RPC-specific configuration for `get_screenshot`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_screenshot
                  ##
                  # RPC-specific configuration for `get_serial_port_output`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_serial_port_output
                  ##
                  # RPC-specific configuration for `get_shielded_instance_identity`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_shielded_instance_identity
                  ##
                  # RPC-specific configuration for `insert`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :insert
                  ##
                  # RPC-specific configuration for `list`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list
                  ##
                  # RPC-specific configuration for `list_referrers`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_referrers
                  ##
                  # RPC-specific configuration for `perform_maintenance`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :perform_maintenance
                  ##
                  # RPC-specific configuration for `remove_resource_policies`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :remove_resource_policies
                  ##
                  # RPC-specific configuration for `report_host_as_faulty`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :report_host_as_faulty
                  ##
                  # RPC-specific configuration for `reset`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :reset
                  ##
                  # RPC-specific configuration for `resume`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :resume
                  ##
                  # RPC-specific configuration for `send_diagnostic_interrupt`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :send_diagnostic_interrupt
                  ##
                  # RPC-specific configuration for `set_deletion_protection`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :set_deletion_protection
                  ##
                  # RPC-specific configuration for `set_disk_auto_delete`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :set_disk_auto_delete
                  ##
                  # RPC-specific configuration for `set_iam_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :set_iam_policy
                  ##
                  # RPC-specific configuration for `set_labels`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :set_labels
                  ##
                  # RPC-specific configuration for `set_machine_resources`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :set_machine_resources
                  ##
                  # RPC-specific configuration for `set_machine_type`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :set_machine_type
                  ##
                  # RPC-specific configuration for `set_metadata`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :set_metadata
                  ##
                  # RPC-specific configuration for `set_min_cpu_platform`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :set_min_cpu_platform
                  ##
                  # RPC-specific configuration for `set_name`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :set_name
                  ##
                  # RPC-specific configuration for `set_scheduling`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :set_scheduling
                  ##
                  # RPC-specific configuration for `set_security_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :set_security_policy
                  ##
                  # RPC-specific configuration for `set_service_account`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :set_service_account
                  ##
                  # RPC-specific configuration for `set_shielded_instance_integrity_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :set_shielded_instance_integrity_policy
                  ##
                  # RPC-specific configuration for `set_tags`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :set_tags
                  ##
                  # RPC-specific configuration for `simulate_maintenance_event`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :simulate_maintenance_event
                  ##
                  # RPC-specific configuration for `start`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :start
                  ##
                  # RPC-specific configuration for `start_with_encryption_key`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :start_with_encryption_key
                  ##
                  # RPC-specific configuration for `stop`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :stop
                  ##
                  # RPC-specific configuration for `suspend`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :suspend
                  ##
                  # RPC-specific configuration for `test_iam_permissions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :test_iam_permissions
                  ##
                  # RPC-specific configuration for `update`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update
                  ##
                  # RPC-specific configuration for `update_access_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_access_config
                  ##
                  # RPC-specific configuration for `update_display_device`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_display_device
                  ##
                  # RPC-specific configuration for `update_network_interface`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_network_interface
                  ##
                  # RPC-specific configuration for `update_shielded_instance_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_shielded_instance_config

                  # @private
                  def initialize parent_rpcs = nil
                    add_access_config_config = parent_rpcs.add_access_config if parent_rpcs.respond_to? :add_access_config
                    @add_access_config = ::Gapic::Config::Method.new add_access_config_config
                    add_network_interface_config = parent_rpcs.add_network_interface if parent_rpcs.respond_to? :add_network_interface
                    @add_network_interface = ::Gapic::Config::Method.new add_network_interface_config
                    add_resource_policies_config = parent_rpcs.add_resource_policies if parent_rpcs.respond_to? :add_resource_policies
                    @add_resource_policies = ::Gapic::Config::Method.new add_resource_policies_config
                    aggregated_list_config = parent_rpcs.aggregated_list if parent_rpcs.respond_to? :aggregated_list
                    @aggregated_list = ::Gapic::Config::Method.new aggregated_list_config
                    attach_disk_config = parent_rpcs.attach_disk if parent_rpcs.respond_to? :attach_disk
                    @attach_disk = ::Gapic::Config::Method.new attach_disk_config
                    bulk_insert_config = parent_rpcs.bulk_insert if parent_rpcs.respond_to? :bulk_insert
                    @bulk_insert = ::Gapic::Config::Method.new bulk_insert_config
                    delete_config = parent_rpcs.delete if parent_rpcs.respond_to? :delete
                    @delete = ::Gapic::Config::Method.new delete_config
                    delete_access_config_config = parent_rpcs.delete_access_config if parent_rpcs.respond_to? :delete_access_config
                    @delete_access_config = ::Gapic::Config::Method.new delete_access_config_config
                    delete_network_interface_config = parent_rpcs.delete_network_interface if parent_rpcs.respond_to? :delete_network_interface
                    @delete_network_interface = ::Gapic::Config::Method.new delete_network_interface_config
                    detach_disk_config = parent_rpcs.detach_disk if parent_rpcs.respond_to? :detach_disk
                    @detach_disk = ::Gapic::Config::Method.new detach_disk_config
                    get_config = parent_rpcs.get if parent_rpcs.respond_to? :get
                    @get = ::Gapic::Config::Method.new get_config
                    get_effective_firewalls_config = parent_rpcs.get_effective_firewalls if parent_rpcs.respond_to? :get_effective_firewalls
                    @get_effective_firewalls = ::Gapic::Config::Method.new get_effective_firewalls_config
                    get_guest_attributes_config = parent_rpcs.get_guest_attributes if parent_rpcs.respond_to? :get_guest_attributes
                    @get_guest_attributes = ::Gapic::Config::Method.new get_guest_attributes_config
                    get_iam_policy_config = parent_rpcs.get_iam_policy if parent_rpcs.respond_to? :get_iam_policy
                    @get_iam_policy = ::Gapic::Config::Method.new get_iam_policy_config
                    get_screenshot_config = parent_rpcs.get_screenshot if parent_rpcs.respond_to? :get_screenshot
                    @get_screenshot = ::Gapic::Config::Method.new get_screenshot_config
                    get_serial_port_output_config = parent_rpcs.get_serial_port_output if parent_rpcs.respond_to? :get_serial_port_output
                    @get_serial_port_output = ::Gapic::Config::Method.new get_serial_port_output_config
                    get_shielded_instance_identity_config = parent_rpcs.get_shielded_instance_identity if parent_rpcs.respond_to? :get_shielded_instance_identity
                    @get_shielded_instance_identity = ::Gapic::Config::Method.new get_shielded_instance_identity_config
                    insert_config = parent_rpcs.insert if parent_rpcs.respond_to? :insert
                    @insert = ::Gapic::Config::Method.new insert_config
                    list_config = parent_rpcs.list if parent_rpcs.respond_to? :list
                    @list = ::Gapic::Config::Method.new list_config
                    list_referrers_config = parent_rpcs.list_referrers if parent_rpcs.respond_to? :list_referrers
                    @list_referrers = ::Gapic::Config::Method.new list_referrers_config
                    perform_maintenance_config = parent_rpcs.perform_maintenance if parent_rpcs.respond_to? :perform_maintenance
                    @perform_maintenance = ::Gapic::Config::Method.new perform_maintenance_config
                    remove_resource_policies_config = parent_rpcs.remove_resource_policies if parent_rpcs.respond_to? :remove_resource_policies
                    @remove_resource_policies = ::Gapic::Config::Method.new remove_resource_policies_config
                    report_host_as_faulty_config = parent_rpcs.report_host_as_faulty if parent_rpcs.respond_to? :report_host_as_faulty
                    @report_host_as_faulty = ::Gapic::Config::Method.new report_host_as_faulty_config
                    reset_config = parent_rpcs.reset if parent_rpcs.respond_to? :reset
                    @reset = ::Gapic::Config::Method.new reset_config
                    resume_config = parent_rpcs.resume if parent_rpcs.respond_to? :resume
                    @resume = ::Gapic::Config::Method.new resume_config
                    send_diagnostic_interrupt_config = parent_rpcs.send_diagnostic_interrupt if parent_rpcs.respond_to? :send_diagnostic_interrupt
                    @send_diagnostic_interrupt = ::Gapic::Config::Method.new send_diagnostic_interrupt_config
                    set_deletion_protection_config = parent_rpcs.set_deletion_protection if parent_rpcs.respond_to? :set_deletion_protection
                    @set_deletion_protection = ::Gapic::Config::Method.new set_deletion_protection_config
                    set_disk_auto_delete_config = parent_rpcs.set_disk_auto_delete if parent_rpcs.respond_to? :set_disk_auto_delete
                    @set_disk_auto_delete = ::Gapic::Config::Method.new set_disk_auto_delete_config
                    set_iam_policy_config = parent_rpcs.set_iam_policy if parent_rpcs.respond_to? :set_iam_policy
                    @set_iam_policy = ::Gapic::Config::Method.new set_iam_policy_config
                    set_labels_config = parent_rpcs.set_labels if parent_rpcs.respond_to? :set_labels
                    @set_labels = ::Gapic::Config::Method.new set_labels_config
                    set_machine_resources_config = parent_rpcs.set_machine_resources if parent_rpcs.respond_to? :set_machine_resources
                    @set_machine_resources = ::Gapic::Config::Method.new set_machine_resources_config
                    set_machine_type_config = parent_rpcs.set_machine_type if parent_rpcs.respond_to? :set_machine_type
                    @set_machine_type = ::Gapic::Config::Method.new set_machine_type_config
                    set_metadata_config = parent_rpcs.set_metadata if parent_rpcs.respond_to? :set_metadata
                    @set_metadata = ::Gapic::Config::Method.new set_metadata_config
                    set_min_cpu_platform_config = parent_rpcs.set_min_cpu_platform if parent_rpcs.respond_to? :set_min_cpu_platform
                    @set_min_cpu_platform = ::Gapic::Config::Method.new set_min_cpu_platform_config
                    set_name_config = parent_rpcs.set_name if parent_rpcs.respond_to? :set_name
                    @set_name = ::Gapic::Config::Method.new set_name_config
                    set_scheduling_config = parent_rpcs.set_scheduling if parent_rpcs.respond_to? :set_scheduling
                    @set_scheduling = ::Gapic::Config::Method.new set_scheduling_config
                    set_security_policy_config = parent_rpcs.set_security_policy if parent_rpcs.respond_to? :set_security_policy
                    @set_security_policy = ::Gapic::Config::Method.new set_security_policy_config
                    set_service_account_config = parent_rpcs.set_service_account if parent_rpcs.respond_to? :set_service_account
                    @set_service_account = ::Gapic::Config::Method.new set_service_account_config
                    set_shielded_instance_integrity_policy_config = parent_rpcs.set_shielded_instance_integrity_policy if parent_rpcs.respond_to? :set_shielded_instance_integrity_policy
                    @set_shielded_instance_integrity_policy = ::Gapic::Config::Method.new set_shielded_instance_integrity_policy_config
                    set_tags_config = parent_rpcs.set_tags if parent_rpcs.respond_to? :set_tags
                    @set_tags = ::Gapic::Config::Method.new set_tags_config
                    simulate_maintenance_event_config = parent_rpcs.simulate_maintenance_event if parent_rpcs.respond_to? :simulate_maintenance_event
                    @simulate_maintenance_event = ::Gapic::Config::Method.new simulate_maintenance_event_config
                    start_config = parent_rpcs.start if parent_rpcs.respond_to? :start
                    @start = ::Gapic::Config::Method.new start_config
                    start_with_encryption_key_config = parent_rpcs.start_with_encryption_key if parent_rpcs.respond_to? :start_with_encryption_key
                    @start_with_encryption_key = ::Gapic::Config::Method.new start_with_encryption_key_config
                    stop_config = parent_rpcs.stop if parent_rpcs.respond_to? :stop
                    @stop = ::Gapic::Config::Method.new stop_config
                    suspend_config = parent_rpcs.suspend if parent_rpcs.respond_to? :suspend
                    @suspend = ::Gapic::Config::Method.new suspend_config
                    test_iam_permissions_config = parent_rpcs.test_iam_permissions if parent_rpcs.respond_to? :test_iam_permissions
                    @test_iam_permissions = ::Gapic::Config::Method.new test_iam_permissions_config
                    update_config = parent_rpcs.update if parent_rpcs.respond_to? :update
                    @update = ::Gapic::Config::Method.new update_config
                    update_access_config_config = parent_rpcs.update_access_config if parent_rpcs.respond_to? :update_access_config
                    @update_access_config = ::Gapic::Config::Method.new update_access_config_config
                    update_display_device_config = parent_rpcs.update_display_device if parent_rpcs.respond_to? :update_display_device
                    @update_display_device = ::Gapic::Config::Method.new update_display_device_config
                    update_network_interface_config = parent_rpcs.update_network_interface if parent_rpcs.respond_to? :update_network_interface
                    @update_network_interface = ::Gapic::Config::Method.new update_network_interface_config
                    update_shielded_instance_config_config = parent_rpcs.update_shielded_instance_config if parent_rpcs.respond_to? :update_shielded_instance_config
                    @update_shielded_instance_config = ::Gapic::Config::Method.new update_shielded_instance_config_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
