# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/commerce/consumer/procurement/v1/license_management_service_pb"
require "google/cloud/commerce/consumer/procurement/v1/license_management_service/rest"


class ::Google::Cloud::Commerce::Consumer::Procurement::V1::LicenseManagementService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_get_license_pool
    # Create test objects.
    client_result = ::Google::Cloud::Commerce::Consumer::Procurement::V1::LicensePool.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_license_pool_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Commerce::Consumer::Procurement::V1::LicenseManagementService::Rest::ServiceStub.stub :transcode_get_license_pool_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_license_pool_client_stub do
        # Create client
        client = ::Google::Cloud::Commerce::Consumer::Procurement::V1::LicenseManagementService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_license_pool({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_license_pool name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_license_pool ::Google::Cloud::Commerce::Consumer::Procurement::V1::GetLicensePoolRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_license_pool({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_license_pool(::Google::Cloud::Commerce::Consumer::Procurement::V1::GetLicensePoolRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_license_pool_client_stub.call_count
      end
    end
  end

  def test_update_license_pool
    # Create test objects.
    client_result = ::Google::Cloud::Commerce::Consumer::Procurement::V1::LicensePool.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    license_pool = {}
    update_mask = {}

    update_license_pool_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Commerce::Consumer::Procurement::V1::LicenseManagementService::Rest::ServiceStub.stub :transcode_update_license_pool_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_license_pool_client_stub do
        # Create client
        client = ::Google::Cloud::Commerce::Consumer::Procurement::V1::LicenseManagementService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_license_pool({ license_pool: license_pool, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_license_pool license_pool: license_pool, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_license_pool ::Google::Cloud::Commerce::Consumer::Procurement::V1::UpdateLicensePoolRequest.new(license_pool: license_pool, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_license_pool({ license_pool: license_pool, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_license_pool(::Google::Cloud::Commerce::Consumer::Procurement::V1::UpdateLicensePoolRequest.new(license_pool: license_pool, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_license_pool_client_stub.call_count
      end
    end
  end

  def test_assign
    # Create test objects.
    client_result = ::Google::Cloud::Commerce::Consumer::Procurement::V1::AssignResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    usernames = ["hello world"]

    assign_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Commerce::Consumer::Procurement::V1::LicenseManagementService::Rest::ServiceStub.stub :transcode_assign_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, assign_client_stub do
        # Create client
        client = ::Google::Cloud::Commerce::Consumer::Procurement::V1::LicenseManagementService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.assign({ parent: parent, usernames: usernames }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.assign parent: parent, usernames: usernames do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.assign ::Google::Cloud::Commerce::Consumer::Procurement::V1::AssignRequest.new(parent: parent, usernames: usernames) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.assign({ parent: parent, usernames: usernames }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.assign(::Google::Cloud::Commerce::Consumer::Procurement::V1::AssignRequest.new(parent: parent, usernames: usernames), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, assign_client_stub.call_count
      end
    end
  end

  def test_unassign
    # Create test objects.
    client_result = ::Google::Cloud::Commerce::Consumer::Procurement::V1::UnassignResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    usernames = ["hello world"]

    unassign_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Commerce::Consumer::Procurement::V1::LicenseManagementService::Rest::ServiceStub.stub :transcode_unassign_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, unassign_client_stub do
        # Create client
        client = ::Google::Cloud::Commerce::Consumer::Procurement::V1::LicenseManagementService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.unassign({ parent: parent, usernames: usernames }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.unassign parent: parent, usernames: usernames do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.unassign ::Google::Cloud::Commerce::Consumer::Procurement::V1::UnassignRequest.new(parent: parent, usernames: usernames) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.unassign({ parent: parent, usernames: usernames }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.unassign(::Google::Cloud::Commerce::Consumer::Procurement::V1::UnassignRequest.new(parent: parent, usernames: usernames), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, unassign_client_stub.call_count
      end
    end
  end

  def test_enumerate_licensed_users
    # Create test objects.
    client_result = ::Google::Cloud::Commerce::Consumer::Procurement::V1::EnumerateLicensedUsersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    enumerate_licensed_users_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Commerce::Consumer::Procurement::V1::LicenseManagementService::Rest::ServiceStub.stub :transcode_enumerate_licensed_users_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, enumerate_licensed_users_client_stub do
        # Create client
        client = ::Google::Cloud::Commerce::Consumer::Procurement::V1::LicenseManagementService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.enumerate_licensed_users({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.enumerate_licensed_users parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.enumerate_licensed_users ::Google::Cloud::Commerce::Consumer::Procurement::V1::EnumerateLicensedUsersRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.enumerate_licensed_users({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.enumerate_licensed_users(::Google::Cloud::Commerce::Consumer::Procurement::V1::EnumerateLicensedUsersRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, enumerate_licensed_users_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Commerce::Consumer::Procurement::V1::LicenseManagementService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Commerce::Consumer::Procurement::V1::LicenseManagementService::Rest::Client::Configuration, config
  end
end
