# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/commerce/consumer/procurement/v1/procurement_service_pb"
require "google/cloud/commerce/consumer/procurement/v1/consumer_procurement_service"

class ::Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_place_order
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    display_name = "hello world"
    line_item_info = [{}]
    request_id = "hello world"

    place_order_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :place_order, name
      assert_kind_of ::Google::Cloud::Commerce::Consumer::Procurement::V1::PlaceOrderRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["display_name"]
      assert_kind_of ::Google::Cloud::Commerce::Consumer::Procurement::V1::LineItemInfo, request["line_item_info"].first
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, place_order_client_stub do
      # Create client
      client = ::Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.place_order({ parent: parent, display_name: display_name, line_item_info: line_item_info, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.place_order parent: parent, display_name: display_name, line_item_info: line_item_info, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.place_order ::Google::Cloud::Commerce::Consumer::Procurement::V1::PlaceOrderRequest.new(parent: parent, display_name: display_name, line_item_info: line_item_info, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.place_order({ parent: parent, display_name: display_name, line_item_info: line_item_info, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.place_order(::Google::Cloud::Commerce::Consumer::Procurement::V1::PlaceOrderRequest.new(parent: parent, display_name: display_name, line_item_info: line_item_info, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, place_order_client_stub.call_rpc_count
    end
  end

  def test_get_order
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Commerce::Consumer::Procurement::V1::Order.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_order_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_order, name
      assert_kind_of ::Google::Cloud::Commerce::Consumer::Procurement::V1::GetOrderRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_order_client_stub do
      # Create client
      client = ::Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_order({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_order name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_order ::Google::Cloud::Commerce::Consumer::Procurement::V1::GetOrderRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_order({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_order(::Google::Cloud::Commerce::Consumer::Procurement::V1::GetOrderRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_order_client_stub.call_rpc_count
    end
  end

  def test_list_orders
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Commerce::Consumer::Procurement::V1::ListOrdersResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_orders_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_orders, name
      assert_kind_of ::Google::Cloud::Commerce::Consumer::Procurement::V1::ListOrdersRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_orders_client_stub do
      # Create client
      client = ::Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_orders({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_orders parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_orders ::Google::Cloud::Commerce::Consumer::Procurement::V1::ListOrdersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_orders({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_orders(::Google::Cloud::Commerce::Consumer::Procurement::V1::ListOrdersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_orders_client_stub.call_rpc_count
    end
  end

  def test_modify_order
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    modifications = [{}]
    display_name = "hello world"
    etag = "hello world"

    modify_order_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :modify_order, name
      assert_kind_of ::Google::Cloud::Commerce::Consumer::Procurement::V1::ModifyOrderRequest, request
      assert_equal "hello world", request["name"]
      assert_kind_of ::Google::Cloud::Commerce::Consumer::Procurement::V1::ModifyOrderRequest::Modification, request["modifications"].first
      assert_equal "hello world", request["display_name"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, modify_order_client_stub do
      # Create client
      client = ::Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.modify_order({ name: name, modifications: modifications, display_name: display_name, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.modify_order name: name, modifications: modifications, display_name: display_name, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.modify_order ::Google::Cloud::Commerce::Consumer::Procurement::V1::ModifyOrderRequest.new(name: name, modifications: modifications, display_name: display_name, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.modify_order({ name: name, modifications: modifications, display_name: display_name, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.modify_order(::Google::Cloud::Commerce::Consumer::Procurement::V1::ModifyOrderRequest.new(name: name, modifications: modifications, display_name: display_name, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, modify_order_client_stub.call_rpc_count
    end
  end

  def test_cancel_order
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"
    cancellation_policy = :CANCELLATION_POLICY_UNSPECIFIED

    cancel_order_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :cancel_order, name
      assert_kind_of ::Google::Cloud::Commerce::Consumer::Procurement::V1::CancelOrderRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["etag"]
      assert_equal :CANCELLATION_POLICY_UNSPECIFIED, request["cancellation_policy"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, cancel_order_client_stub do
      # Create client
      client = ::Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.cancel_order({ name: name, etag: etag, cancellation_policy: cancellation_policy }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.cancel_order name: name, etag: etag, cancellation_policy: cancellation_policy do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.cancel_order ::Google::Cloud::Commerce::Consumer::Procurement::V1::CancelOrderRequest.new(name: name, etag: etag, cancellation_policy: cancellation_policy) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.cancel_order({ name: name, etag: etag, cancellation_policy: cancellation_policy }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.cancel_order(::Google::Cloud::Commerce::Consumer::Procurement::V1::CancelOrderRequest.new(name: name, etag: etag, cancellation_policy: cancellation_policy), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, cancel_order_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::Operations, client.operations_client
  end
end
