# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/commerce/consumer/procurement/v1/procurement_service_pb"
require "google/cloud/commerce/consumer/procurement/v1/consumer_procurement_service/rest"


class ::Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_place_order
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    display_name = "hello world"
    line_item_info = [{}]
    request_id = "hello world"

    place_order_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::Rest::ServiceStub.stub :transcode_place_order_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, place_order_client_stub do
        # Create client
        client = ::Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.place_order({ parent: parent, display_name: display_name, line_item_info: line_item_info, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.place_order parent: parent, display_name: display_name, line_item_info: line_item_info, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.place_order ::Google::Cloud::Commerce::Consumer::Procurement::V1::PlaceOrderRequest.new(parent: parent, display_name: display_name, line_item_info: line_item_info, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.place_order({ parent: parent, display_name: display_name, line_item_info: line_item_info, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.place_order(::Google::Cloud::Commerce::Consumer::Procurement::V1::PlaceOrderRequest.new(parent: parent, display_name: display_name, line_item_info: line_item_info, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, place_order_client_stub.call_count
      end
    end
  end

  def test_get_order
    # Create test objects.
    client_result = ::Google::Cloud::Commerce::Consumer::Procurement::V1::Order.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_order_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::Rest::ServiceStub.stub :transcode_get_order_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_order_client_stub do
        # Create client
        client = ::Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_order({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_order name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_order ::Google::Cloud::Commerce::Consumer::Procurement::V1::GetOrderRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_order({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_order(::Google::Cloud::Commerce::Consumer::Procurement::V1::GetOrderRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_order_client_stub.call_count
      end
    end
  end

  def test_list_orders
    # Create test objects.
    client_result = ::Google::Cloud::Commerce::Consumer::Procurement::V1::ListOrdersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_orders_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::Rest::ServiceStub.stub :transcode_list_orders_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_orders_client_stub do
        # Create client
        client = ::Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_orders({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_orders parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_orders ::Google::Cloud::Commerce::Consumer::Procurement::V1::ListOrdersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_orders({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_orders(::Google::Cloud::Commerce::Consumer::Procurement::V1::ListOrdersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_orders_client_stub.call_count
      end
    end
  end

  def test_modify_order
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    modifications = [{}]
    display_name = "hello world"
    etag = "hello world"

    modify_order_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::Rest::ServiceStub.stub :transcode_modify_order_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, modify_order_client_stub do
        # Create client
        client = ::Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.modify_order({ name: name, modifications: modifications, display_name: display_name, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.modify_order name: name, modifications: modifications, display_name: display_name, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.modify_order ::Google::Cloud::Commerce::Consumer::Procurement::V1::ModifyOrderRequest.new(name: name, modifications: modifications, display_name: display_name, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.modify_order({ name: name, modifications: modifications, display_name: display_name, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.modify_order(::Google::Cloud::Commerce::Consumer::Procurement::V1::ModifyOrderRequest.new(name: name, modifications: modifications, display_name: display_name, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, modify_order_client_stub.call_count
      end
    end
  end

  def test_cancel_order
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"
    cancellation_policy = :CANCELLATION_POLICY_UNSPECIFIED

    cancel_order_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::Rest::ServiceStub.stub :transcode_cancel_order_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, cancel_order_client_stub do
        # Create client
        client = ::Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.cancel_order({ name: name, etag: etag, cancellation_policy: cancellation_policy }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.cancel_order name: name, etag: etag, cancellation_policy: cancellation_policy do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.cancel_order ::Google::Cloud::Commerce::Consumer::Procurement::V1::CancelOrderRequest.new(name: name, etag: etag, cancellation_policy: cancellation_policy) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.cancel_order({ name: name, etag: etag, cancellation_policy: cancellation_policy }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.cancel_order(::Google::Cloud::Commerce::Consumer::Procurement::V1::CancelOrderRequest.new(name: name, etag: etag, cancellation_policy: cancellation_policy), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, cancel_order_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::Rest::Client::Configuration, config
  end
end
