# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Commerce
      module Consumer
        module Procurement
          module V1
            # Represents a purchase made by a customer on Cloud Marketplace.
            # Creating an order makes sure that both the Google backend systems
            # as well as external service provider's systems (if needed) allow use of
            # purchased products and ensures the appropriate billing events occur.
            #
            # An Order can be made against one Product with multiple add-ons (optional) or
            # one Quote which might reference multiple products.
            #
            # Customers typically choose a price plan for each Product purchased when
            # they create an order and can change their plan later, if the product allows.
            # @!attribute [r] name
            #   @return [::String]
            #     Output only. The resource name of the order.
            #     Has the form
            #     `billingAccounts/{billing_account}/orders/{order}`.
            # @!attribute [rw] display_name
            #   @return [::String]
            #     Required. The user-specified name of the order.
            # @!attribute [r] line_items
            #   @return [::Array<::Google::Cloud::Commerce::Consumer::Procurement::V1::LineItem>]
            #     Output only. The items being purchased.
            # @!attribute [r] cancelled_line_items
            #   @return [::Array<::Google::Cloud::Commerce::Consumer::Procurement::V1::LineItem>]
            #     Output only. Line items that were cancelled.
            # @!attribute [r] create_time
            #   @return [::Google::Protobuf::Timestamp]
            #     Output only. The creation timestamp.
            # @!attribute [r] update_time
            #   @return [::Google::Protobuf::Timestamp]
            #     Output only. The last update timestamp.
            # @!attribute [rw] etag
            #   @return [::String]
            #     The weak etag of the order.
            class Order
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # A single item within an order.
            # @!attribute [r] line_item_id
            #   @return [::String]
            #     Output only. Line item ID.
            # @!attribute [r] line_item_info
            #   @return [::Google::Cloud::Commerce::Consumer::Procurement::V1::LineItemInfo]
            #     Output only. Current state and information of this item. It tells what,
            #     e.g. which offer, is currently effective.
            # @!attribute [r] pending_change
            #   @return [::Google::Cloud::Commerce::Consumer::Procurement::V1::LineItemChange]
            #     Output only. A change made on the item which is pending and not yet
            #     effective. Absence of this field indicates the line item is not undergoing
            #     a change.
            # @!attribute [r] change_history
            #   @return [::Array<::Google::Cloud::Commerce::Consumer::Procurement::V1::LineItemChange>]
            #     Output only. Changes made on the item that are not pending anymore which
            #     might be because they already took effect, were reverted by the customer,
            #     or were rejected by the partner. No more operations are allowed on these
            #     changes.
            class LineItem
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # A change made on a line item.
            # @!attribute [r] change_id
            #   @return [::String]
            #     Output only. Change ID.
            #     All changes made within one order update operation have the same change_id.
            # @!attribute [rw] change_type
            #   @return [::Google::Cloud::Commerce::Consumer::Procurement::V1::LineItemChangeType]
            #     Required. Type of the change to make.
            # @!attribute [r] old_line_item_info
            #   @return [::Google::Cloud::Commerce::Consumer::Procurement::V1::LineItemInfo]
            #     Output only. Line item info before the change.
            # @!attribute [rw] new_line_item_info
            #   @return [::Google::Cloud::Commerce::Consumer::Procurement::V1::LineItemInfo]
            #     Line item info after the change.
            # @!attribute [r] change_state
            #   @return [::Google::Cloud::Commerce::Consumer::Procurement::V1::LineItemChangeState]
            #     Output only. State of the change.
            # @!attribute [r] state_reason
            #   @return [::String]
            #     Output only. Provider-supplied message explaining the LineItemChange's
            #     state. Mainly used to communicate progress and ETA for provisioning in the
            #     case of `PENDING_APPROVAL`, and to explain why the change request was
            #     denied or canceled in the case of `REJECTED` and `CANCELED` states.
            # @!attribute [r] change_state_reason_type
            #   @return [::Google::Cloud::Commerce::Consumer::Procurement::V1::LineItemChangeStateReasonType]
            #     Output only. Predefined enum types for why this line item change is in
            #     current state. For example, a line item change's state could be
            #     `LINE_ITEM_CHANGE_STATE_COMPLETED` because of end-of-term expiration,
            #     immediate cancellation initiated by the user, or system-initiated
            #     cancellation.
            # @!attribute [r] change_effective_time
            #   @return [::Google::Protobuf::Timestamp]
            #     Output only. A time at which the change became or will become (in case of
            #     pending change) effective.
            # @!attribute [r] create_time
            #   @return [::Google::Protobuf::Timestamp]
            #     Output only. The time when change was initiated.
            # @!attribute [r] update_time
            #   @return [::Google::Protobuf::Timestamp]
            #     Output only. The time when change was updated, e.g. approved/rejected by
            #     partners or cancelled by the user.
            class LineItemChange
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Line item information.
            # @!attribute [rw] offer
            #   @return [::String]
            #     Optional. The name of the offer can have either of these formats:
            #     'billingAccounts/\\{billing_account}/offers/\\{offer}',
            #     or 'services/\\{service}/standardOffers/\\{offer}'.
            # @!attribute [rw] parameters
            #   @return [::Array<::Google::Cloud::Commerce::Consumer::Procurement::V1::Parameter>]
            #     Optional. User-provided parameters.
            # @!attribute [r] subscription
            #   @return [::Google::Cloud::Commerce::Consumer::Procurement::V1::Subscription]
            #     Output only. Information about the subscription created, if applicable.
            class LineItemInfo
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # User-provided Parameters.
            # @!attribute [rw] name
            #   @return [::String]
            #     Name of the parameter.
            # @!attribute [rw] value
            #   @return [::Google::Cloud::Commerce::Consumer::Procurement::V1::Parameter::Value]
            #     Value of parameter.
            class Parameter
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # @!attribute [rw] int64_value
              #   @return [::Integer]
              #     Represents an int64 value.
              #
              #     Note: The following fields are mutually exclusive: `int64_value`, `string_value`, `double_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
              # @!attribute [rw] string_value
              #   @return [::String]
              #     Represents a string value.
              #
              #     Note: The following fields are mutually exclusive: `string_value`, `int64_value`, `double_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
              # @!attribute [rw] double_value
              #   @return [::Float]
              #     Represents a double value.
              #
              #     Note: The following fields are mutually exclusive: `double_value`, `int64_value`, `string_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
              class Value
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end
            end

            # Subscription information.
            # @!attribute [rw] start_time
            #   @return [::Google::Protobuf::Timestamp]
            #     The timestamp when the subscription begins, if applicable.
            # @!attribute [rw] end_time
            #   @return [::Google::Protobuf::Timestamp]
            #     The timestamp when the subscription ends, if applicable.
            # @!attribute [rw] auto_renewal_enabled
            #   @return [::Boolean]
            #     Whether auto renewal is enabled by user choice on current subscription.
            #     This field indicates order/subscription status after pending plan change is
            #     cancelled or rejected.
            class Subscription
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Type of a line item change.
            module LineItemChangeType
              # Sentinel value. Do not use.
              LINE_ITEM_CHANGE_TYPE_UNSPECIFIED = 0

              # The change is to create a new line item.
              LINE_ITEM_CHANGE_TYPE_CREATE = 1

              # The change is to update an existing line item.
              LINE_ITEM_CHANGE_TYPE_UPDATE = 2

              # The change is to cancel an existing line item.
              LINE_ITEM_CHANGE_TYPE_CANCEL = 3

              # The change is to revert a cancellation.
              LINE_ITEM_CHANGE_TYPE_REVERT_CANCELLATION = 4
            end

            # State of a change.
            module LineItemChangeState
              # Sentinel value. Do not use.
              LINE_ITEM_CHANGE_STATE_UNSPECIFIED = 0

              # Change is in this state when a change is initiated and waiting for partner
              # approval. This state is only applicable for pending change.
              LINE_ITEM_CHANGE_STATE_PENDING_APPROVAL = 1

              # Change is in this state after it's approved by the partner or auto-approved
              # but before it takes effect. The change can be overwritten or cancelled
              # depending on the new line item info property (pending Private Offer change
              # cannot be cancelled and can only be overwritten by another Private Offer).
              # This state is only applicable for pending change.
              LINE_ITEM_CHANGE_STATE_APPROVED = 2

              # Change is in this state after it's been activated. This state is only
              # applicable for change in history.
              LINE_ITEM_CHANGE_STATE_COMPLETED = 3

              # Change is in this state if it was rejected by the partner. This state is
              # only applicable for change in history.
              LINE_ITEM_CHANGE_STATE_REJECTED = 4

              # Change is in this state if it was abandoned by the user. This state is only
              # applicable for change in history.
              LINE_ITEM_CHANGE_STATE_ABANDONED = 5

              # Change is in this state if it's currently being provisioned downstream. The
              # change can't be overwritten or cancelled when it's in this state. This
              # state is only applicable for pending change.
              LINE_ITEM_CHANGE_STATE_ACTIVATING = 6
            end

            # Predefined types for line item change state reason.
            module LineItemChangeStateReasonType
              # Default value, indicating there's no predefined type for change state
              # reason.
              LINE_ITEM_CHANGE_STATE_REASON_TYPE_UNSPECIFIED = 0

              # Change is in current state due to term expiration.
              LINE_ITEM_CHANGE_STATE_REASON_TYPE_EXPIRED = 1

              # Change is in current state due to user-initiated cancellation.
              LINE_ITEM_CHANGE_STATE_REASON_TYPE_USER_CANCELLED = 2

              # Change is in current state due to system-initiated cancellation.
              LINE_ITEM_CHANGE_STATE_REASON_TYPE_SYSTEM_CANCELLED = 3
            end
          end
        end
      end
    end
  end
end
