# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Commerce
      module Consumer
        module Procurement
          module V1
            # Assignment protocol for a license pool.
            # @!attribute [rw] manual_assignment_type
            #   @return [::Google::Cloud::Commerce::Consumer::Procurement::V1::AssignmentProtocol::ManualAssignmentType]
            #     Allow manual assignments triggered by administrative operations only.
            #
            #     Note: The following fields are mutually exclusive: `manual_assignment_type`, `auto_assignment_type`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] auto_assignment_type
            #   @return [::Google::Cloud::Commerce::Consumer::Procurement::V1::AssignmentProtocol::AutoAssignmentType]
            #     Allow automatic assignments triggered by data plane operations.
            #
            #     Note: The following fields are mutually exclusive: `auto_assignment_type`, `manual_assignment_type`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            class AssignmentProtocol
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Allow manual assignments triggered by administrative operations only.
              class ManualAssignmentType
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end

              # Configuration for automatic assignments handled by data plane operations.
              # @!attribute [rw] inactive_license_ttl
              #   @return [::Google::Protobuf::Duration]
              #     Optional. The time to live for an inactive license. After this time has
              #     passed, the license will be automatically unassigned from the user. Must
              #     be at least 7 days, if set. If unset, the license will never expire.
              class AutoAssignmentType
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end
            end

            # A license pool represents a pool of licenses that can be assigned to users.
            # @!attribute [rw] name
            #   @return [::String]
            #     Identifier. Format:
            #     `billingAccounts/{billing_account}/orders/{order}/licensePool`
            # @!attribute [rw] license_assignment_protocol
            #   @return [::Google::Cloud::Commerce::Consumer::Procurement::V1::AssignmentProtocol]
            #     Required. Assignment protocol for the license pool.
            # @!attribute [r] available_license_count
            #   @return [::Integer]
            #     Output only. Licenses count that are available to be assigned.
            # @!attribute [r] total_license_count
            #   @return [::Integer]
            #     Output only. Total number of licenses in the pool.
            class LicensePool
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Request message for getting a license pool.
            # @!attribute [rw] name
            #   @return [::String]
            #     Required. The name of the license pool to get.
            #     Format: `billingAccounts/{billing_account}/orders/{order}/licensePool`
            class GetLicensePoolRequest
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Request message for updating a license pool.
            # @!attribute [rw] license_pool
            #   @return [::Google::Cloud::Commerce::Consumer::Procurement::V1::LicensePool]
            #     Required. The license pool to update.
            #
            #     The license pool's name field is used to identify the license pool to
            #     update. Format:
            #     `billingAccounts/{billing_account}/orders/{order}/licensePool`.
            # @!attribute [rw] update_mask
            #   @return [::Google::Protobuf::FieldMask]
            #     Required. The list of fields to update.
            class UpdateLicensePoolRequest
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Request message for
            # {::Google::Cloud::Commerce::Consumer::Procurement::V1::LicenseManagementService::Client#assign LicenseManagementService.Assign}.
            # @!attribute [rw] parent
            #   @return [::String]
            #     Required. License pool name.
            # @!attribute [rw] usernames
            #   @return [::Array<::String>]
            #     Required. Username.
            #     Format: `name@domain.com`.
            class AssignRequest
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Response message for
            # {::Google::Cloud::Commerce::Consumer::Procurement::V1::LicenseManagementService::Client#assign LicenseManagementService.Assign}.
            class AssignResponse
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Request message for
            # {::Google::Cloud::Commerce::Consumer::Procurement::V1::LicenseManagementService::Client#unassign LicenseManagementService.Unassign}.
            # @!attribute [rw] parent
            #   @return [::String]
            #     Required. License pool name.
            # @!attribute [rw] usernames
            #   @return [::Array<::String>]
            #     Required. Username.
            #     Format: `name@domain.com`.
            class UnassignRequest
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Response message for
            # {::Google::Cloud::Commerce::Consumer::Procurement::V1::LicenseManagementService::Client#unassign LicenseManagementService.Unassign}.
            class UnassignResponse
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Request message for
            # {::Google::Cloud::Commerce::Consumer::Procurement::V1::LicenseManagementService::Client#enumerate_licensed_users LicenseManagementService.EnumerateLicensedUsers}.
            # @!attribute [rw] parent
            #   @return [::String]
            #     Required. License pool name.
            # @!attribute [rw] page_size
            #   @return [::Integer]
            #     Optional. The maximum number of users to return. The service may return
            #     fewer than this value.
            # @!attribute [rw] page_token
            #   @return [::String]
            #     Optional. A page token, received from a previous `EnumerateLicensedUsers`
            #     call. Provide this to retrieve the subsequent page.
            class EnumerateLicensedUsersRequest
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # A licensed user.
            # @!attribute [rw] username
            #   @return [::String]
            #     Username.
            #     Format: `name@domain.com`.
            # @!attribute [r] assign_time
            #   @return [::Google::Protobuf::Timestamp]
            #     Output only. Timestamp when the license was assigned.
            # @!attribute [r] recent_usage_time
            #   @return [::Google::Protobuf::Timestamp]
            #     Output only. Timestamp when the license was recently used. This may not be
            #     the most recent usage time, and will be updated regularly (within 24
            #     hours).
            class LicensedUser
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Response message for
            # {::Google::Cloud::Commerce::Consumer::Procurement::V1::LicenseManagementService::Client#enumerate_licensed_users LicenseManagementService.EnumerateLicensedUsers}.
            # @!attribute [rw] licensed_users
            #   @return [::Array<::Google::Cloud::Commerce::Consumer::Procurement::V1::LicensedUser>]
            #     The list of licensed users.
            # @!attribute [rw] next_page_token
            #   @return [::String]
            #     A token that can be sent as `page_token` to retrieve the next page.
            #     If this field is omitted, there are no subsequent pages.
            class EnumerateLicensedUsersResponse
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end
      end
    end
  end
end
