# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/cloud/commerce/consumer/procurement/v1/procurement_service.proto for package 'Google.Cloud.Commerce.Consumer.Procurement.V1'
# Original file comments:
# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/cloud/commerce/consumer/procurement/v1/procurement_service_pb'

module Google
  module Cloud
    module Commerce
      module Consumer
        module Procurement
          module V1
            module ConsumerProcurementService
              # ConsumerProcurementService allows customers to make purchases of products
              # served by the Cloud Commerce platform.
              #
              #
              # When purchases are made, the
              # [ConsumerProcurementService][google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementService]
              # programs the appropriate backends, including both Google's own
              # infrastructure, as well as third-party systems, and to enable billing setup
              # for charging for the procured item.
              #
              class Service

                include ::GRPC::GenericService

                self.marshal_class_method = :encode
                self.unmarshal_class_method = :decode
                self.service_name = 'google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementService'

                # Creates a new [Order][google.cloud.commerce.consumer.procurement.v1.Order].
                #
                # This API only supports GCP spend-based committed use
                # discounts specified by GCP documentation.
                #
                # The returned long-running operation is in-progress until the backend
                # completes the creation of the resource. Once completed, the order is
                # in
                # [OrderState.ORDER_STATE_ACTIVE][google.cloud.commerce.consumer.procurement.v1.OrderState.ORDER_STATE_ACTIVE].
                # In case of failure, the order resource will be removed.
                rpc :PlaceOrder, ::Google::Cloud::Commerce::Consumer::Procurement::V1::PlaceOrderRequest, ::Google::Longrunning::Operation
                # Returns the requested
                # [Order][google.cloud.commerce.consumer.procurement.v1.Order] resource.
                rpc :GetOrder, ::Google::Cloud::Commerce::Consumer::Procurement::V1::GetOrderRequest, ::Google::Cloud::Commerce::Consumer::Procurement::V1::Order
                # Lists [Order][google.cloud.commerce.consumer.procurement.v1.Order]
                # resources that the user has access to, within the scope of the parent
                # resource.
                rpc :ListOrders, ::Google::Cloud::Commerce::Consumer::Procurement::V1::ListOrdersRequest, ::Google::Cloud::Commerce::Consumer::Procurement::V1::ListOrdersResponse
                # Modifies an existing
                # [Order][google.cloud.commerce.consumer.procurement.v1.Order] resource.
                rpc :ModifyOrder, ::Google::Cloud::Commerce::Consumer::Procurement::V1::ModifyOrderRequest, ::Google::Longrunning::Operation
                # Cancels an existing
                # [Order][google.cloud.commerce.consumer.procurement.v1.Order]. Every product
                # procured in the Order will be cancelled.
                rpc :CancelOrder, ::Google::Cloud::Commerce::Consumer::Procurement::V1::CancelOrderRequest, ::Google::Longrunning::Operation
              end

              Stub = Service.rpc_stub_class
            end
          end
        end
      end
    end
  end
end
