# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/commerce/consumer/procurement/v1/license_management_service_pb"

module Google
  module Cloud
    module Commerce
      module Consumer
        module Procurement
          module V1
            module LicenseManagementService
              module Rest
                ##
                # REST service stub for the LicenseManagementService service.
                # Service stub contains baseline method implementations
                # including transcoding, making the REST call, and deserialing the response.
                #
                class ServiceStub
                  # @private
                  def initialize endpoint:, endpoint_template:, universe_domain:, credentials:, logger:
                    # These require statements are intentionally placed here to initialize
                    # the REST modules only when it's required.
                    require "gapic/rest"

                    @client_stub = ::Gapic::Rest::ClientStub.new endpoint: endpoint,
                                                                 endpoint_template: endpoint_template,
                                                                 universe_domain: universe_domain,
                                                                 credentials: credentials,
                                                                 numeric_enums: true,
                                                                 service_name: self.class,
                                                                 raise_faraday_errors: false,
                                                                 logger: logger
                  end

                  ##
                  # The effective universe domain
                  #
                  # @return [String]
                  #
                  def universe_domain
                    @client_stub.universe_domain
                  end

                  ##
                  # The effective endpoint
                  #
                  # @return [String]
                  #
                  def endpoint
                    @client_stub.endpoint
                  end

                  ##
                  # The logger used for request/response debug logging.
                  #
                  # @return [Logger]
                  #
                  def logger stub: false
                    stub ? @client_stub.stub_logger : @client_stub.logger
                  end

                  ##
                  # Baseline implementation for the get_license_pool REST call
                  #
                  # @param request_pb [::Google::Cloud::Commerce::Consumer::Procurement::V1::GetLicensePoolRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Commerce::Consumer::Procurement::V1::LicensePool]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Commerce::Consumer::Procurement::V1::LicensePool]
                  #   A result object deserialized from the server's reply
                  def get_license_pool request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_get_license_pool_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "get_license_pool",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Commerce::Consumer::Procurement::V1::LicensePool.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the update_license_pool REST call
                  #
                  # @param request_pb [::Google::Cloud::Commerce::Consumer::Procurement::V1::UpdateLicensePoolRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Commerce::Consumer::Procurement::V1::LicensePool]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Commerce::Consumer::Procurement::V1::LicensePool]
                  #   A result object deserialized from the server's reply
                  def update_license_pool request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_update_license_pool_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "update_license_pool",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Commerce::Consumer::Procurement::V1::LicensePool.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the assign REST call
                  #
                  # @param request_pb [::Google::Cloud::Commerce::Consumer::Procurement::V1::AssignRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Commerce::Consumer::Procurement::V1::AssignResponse]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Commerce::Consumer::Procurement::V1::AssignResponse]
                  #   A result object deserialized from the server's reply
                  def assign request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_assign_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "assign",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Commerce::Consumer::Procurement::V1::AssignResponse.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the unassign REST call
                  #
                  # @param request_pb [::Google::Cloud::Commerce::Consumer::Procurement::V1::UnassignRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Commerce::Consumer::Procurement::V1::UnassignResponse]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Commerce::Consumer::Procurement::V1::UnassignResponse]
                  #   A result object deserialized from the server's reply
                  def unassign request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_unassign_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "unassign",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Commerce::Consumer::Procurement::V1::UnassignResponse.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the enumerate_licensed_users REST call
                  #
                  # @param request_pb [::Google::Cloud::Commerce::Consumer::Procurement::V1::EnumerateLicensedUsersRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Commerce::Consumer::Procurement::V1::EnumerateLicensedUsersResponse]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Commerce::Consumer::Procurement::V1::EnumerateLicensedUsersResponse]
                  #   A result object deserialized from the server's reply
                  def enumerate_licensed_users request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_enumerate_licensed_users_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "enumerate_licensed_users",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Commerce::Consumer::Procurement::V1::EnumerateLicensedUsersResponse.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the get_license_pool REST call
                  #
                  # @param request_pb [::Google::Cloud::Commerce::Consumer::Procurement::V1::GetLicensePoolRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_get_license_pool_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :get,
                                                              uri_template: "/v1/{name}",
                                                              matches: [
                                                                ["name", %r{^billingAccounts/[^/]+/orders/[^/]+/licensePool/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the update_license_pool REST call
                  #
                  # @param request_pb [::Google::Cloud::Commerce::Consumer::Procurement::V1::UpdateLicensePoolRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_update_license_pool_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :patch,
                                                              uri_template: "/v1/{license_pool.name}",
                                                              body: "license_pool",
                                                              matches: [
                                                                ["license_pool.name", %r{^billingAccounts/[^/]+/orders/[^/]+/licensePool/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the assign REST call
                  #
                  # @param request_pb [::Google::Cloud::Commerce::Consumer::Procurement::V1::AssignRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_assign_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :post,
                                                              uri_template: "/v1/{parent}:assign",
                                                              body: "*",
                                                              matches: [
                                                                ["parent", %r{^billingAccounts/[^/]+/orders/[^/]+/licensePool/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the unassign REST call
                  #
                  # @param request_pb [::Google::Cloud::Commerce::Consumer::Procurement::V1::UnassignRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_unassign_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :post,
                                                              uri_template: "/v1/{parent}:unassign",
                                                              body: "*",
                                                              matches: [
                                                                ["parent", %r{^billingAccounts/[^/]+/orders/[^/]+/licensePool/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the enumerate_licensed_users REST call
                  #
                  # @param request_pb [::Google::Cloud::Commerce::Consumer::Procurement::V1::EnumerateLicensedUsersRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_enumerate_licensed_users_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :get,
                                                              uri_template: "/v1/{parent}:enumerateLicensedUsers",
                                                              matches: [
                                                                ["parent", %r{^billingAccounts/[^/]+/orders/[^/]+/licensePool/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
