# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/commerce/consumer/procurement/v1/license_management_service_pb"
require "google/cloud/commerce/consumer/procurement/v1/license_management_service/rest/service_stub"

module Google
  module Cloud
    module Commerce
      module Consumer
        module Procurement
          module V1
            module LicenseManagementService
              module Rest
                ##
                # REST client for the LicenseManagementService service.
                #
                # Service for managing licenses.
                #
                class Client
                  # @private
                  API_VERSION = ""

                  # @private
                  DEFAULT_ENDPOINT_TEMPLATE = "cloudcommerceconsumerprocurement.$UNIVERSE_DOMAIN$"

                  include Paths

                  # @private
                  attr_reader :license_management_service_stub

                  ##
                  # Configure the LicenseManagementService Client class.
                  #
                  # See {::Google::Cloud::Commerce::Consumer::Procurement::V1::LicenseManagementService::Rest::Client::Configuration}
                  # for a description of the configuration fields.
                  #
                  # @example
                  #
                  #   # Modify the configuration for all LicenseManagementService clients
                  #   ::Google::Cloud::Commerce::Consumer::Procurement::V1::LicenseManagementService::Rest::Client.configure do |config|
                  #     config.timeout = 10.0
                  #   end
                  #
                  # @yield [config] Configure the Client client.
                  # @yieldparam config [Client::Configuration]
                  #
                  # @return [Client::Configuration]
                  #
                  def self.configure
                    @configure ||= begin
                      namespace = ["Google", "Cloud", "Commerce", "Consumer", "Procurement", "V1"]
                      parent_config = while namespace.any?
                                        parent_name = namespace.join "::"
                                        parent_const = const_get parent_name
                                        break parent_const.configure if parent_const.respond_to? :configure
                                        namespace.pop
                                      end
                      default_config = Client::Configuration.new parent_config

                      default_config
                    end
                    yield @configure if block_given?
                    @configure
                  end

                  ##
                  # Configure the LicenseManagementService Client instance.
                  #
                  # The configuration is set to the derived mode, meaning that values can be changed,
                  # but structural changes (adding new fields, etc.) are not allowed. Structural changes
                  # should be made on {Client.configure}.
                  #
                  # See {::Google::Cloud::Commerce::Consumer::Procurement::V1::LicenseManagementService::Rest::Client::Configuration}
                  # for a description of the configuration fields.
                  #
                  # @yield [config] Configure the Client client.
                  # @yieldparam config [Client::Configuration]
                  #
                  # @return [Client::Configuration]
                  #
                  def configure
                    yield @config if block_given?
                    @config
                  end

                  ##
                  # The effective universe domain
                  #
                  # @return [String]
                  #
                  def universe_domain
                    @license_management_service_stub.universe_domain
                  end

                  ##
                  # Create a new LicenseManagementService REST client object.
                  #
                  # @example
                  #
                  #   # Create a client using the default configuration
                  #   client = ::Google::Cloud::Commerce::Consumer::Procurement::V1::LicenseManagementService::Rest::Client.new
                  #
                  #   # Create a client using a custom configuration
                  #   client = ::Google::Cloud::Commerce::Consumer::Procurement::V1::LicenseManagementService::Rest::Client.new do |config|
                  #     config.timeout = 10.0
                  #   end
                  #
                  # @yield [config] Configure the LicenseManagementService client.
                  # @yieldparam config [Client::Configuration]
                  #
                  def initialize
                    # Create the configuration object
                    @config = Configuration.new Client.configure

                    # Yield the configuration if needed
                    yield @config if block_given?

                    # Create credentials
                    credentials = @config.credentials
                    # Use self-signed JWT if the endpoint is unchanged from default,
                    # but only if the default endpoint does not have a region prefix.
                    enable_self_signed_jwt = @config.endpoint.nil? ||
                                             (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                             !@config.endpoint.split(".").first.include?("-"))
                    credentials ||= Credentials.default scope: @config.scope,
                                                        enable_self_signed_jwt: enable_self_signed_jwt
                    if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                      credentials = Credentials.new credentials, scope: @config.scope
                    end

                    @quota_project_id = @config.quota_project
                    @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                    @license_management_service_stub = ::Google::Cloud::Commerce::Consumer::Procurement::V1::LicenseManagementService::Rest::ServiceStub.new(
                      endpoint: @config.endpoint,
                      endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                      universe_domain: @config.universe_domain,
                      credentials: credentials,
                      logger: @config.logger
                    )

                    @license_management_service_stub.logger(stub: true)&.info do |entry|
                      entry.set_system_name
                      entry.set_service
                      entry.message = "Created client for #{entry.service}"
                      entry.set_credentials_fields credentials
                      entry.set "customEndpoint", @config.endpoint if @config.endpoint
                      entry.set "defaultTimeout", @config.timeout if @config.timeout
                      entry.set "quotaProject", @quota_project_id if @quota_project_id
                    end
                  end

                  ##
                  # The logger used for request/response debug logging.
                  #
                  # @return [Logger]
                  #
                  def logger
                    @license_management_service_stub.logger
                  end

                  # Service calls

                  ##
                  # Gets the license pool.
                  #
                  # @overload get_license_pool(request, options = nil)
                  #   Pass arguments to `get_license_pool` via a request object, either of type
                  #   {::Google::Cloud::Commerce::Consumer::Procurement::V1::GetLicensePoolRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Commerce::Consumer::Procurement::V1::GetLicensePoolRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload get_license_pool(name: nil)
                  #   Pass arguments to `get_license_pool` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param name [::String]
                  #     Required. The name of the license pool to get.
                  #     Format: `billingAccounts/{billing_account}/orders/{order}/licensePool`
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Commerce::Consumer::Procurement::V1::LicensePool]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Commerce::Consumer::Procurement::V1::LicensePool]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/commerce/consumer/procurement/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Commerce::Consumer::Procurement::V1::LicenseManagementService::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Commerce::Consumer::Procurement::V1::GetLicensePoolRequest.new
                  #
                  #   # Call the get_license_pool method.
                  #   result = client.get_license_pool request
                  #
                  #   # The returned object is of type Google::Cloud::Commerce::Consumer::Procurement::V1::LicensePool.
                  #   p result
                  #
                  def get_license_pool request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Commerce::Consumer::Procurement::V1::GetLicensePoolRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.get_license_pool.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Commerce::Consumer::Procurement::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.get_license_pool.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.get_license_pool.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @license_management_service_stub.get_license_pool request, options do |result, operation|
                      yield result, operation if block_given?
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Updates the license pool if one exists for this Order.
                  #
                  # @overload update_license_pool(request, options = nil)
                  #   Pass arguments to `update_license_pool` via a request object, either of type
                  #   {::Google::Cloud::Commerce::Consumer::Procurement::V1::UpdateLicensePoolRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Commerce::Consumer::Procurement::V1::UpdateLicensePoolRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload update_license_pool(license_pool: nil, update_mask: nil)
                  #   Pass arguments to `update_license_pool` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param license_pool [::Google::Cloud::Commerce::Consumer::Procurement::V1::LicensePool, ::Hash]
                  #     Required. The license pool to update.
                  #
                  #     The license pool's name field is used to identify the license pool to
                  #     update. Format:
                  #     `billingAccounts/{billing_account}/orders/{order}/licensePool`.
                  #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
                  #     Required. The list of fields to update.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Commerce::Consumer::Procurement::V1::LicensePool]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Commerce::Consumer::Procurement::V1::LicensePool]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/commerce/consumer/procurement/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Commerce::Consumer::Procurement::V1::LicenseManagementService::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Commerce::Consumer::Procurement::V1::UpdateLicensePoolRequest.new
                  #
                  #   # Call the update_license_pool method.
                  #   result = client.update_license_pool request
                  #
                  #   # The returned object is of type Google::Cloud::Commerce::Consumer::Procurement::V1::LicensePool.
                  #   p result
                  #
                  def update_license_pool request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Commerce::Consumer::Procurement::V1::UpdateLicensePoolRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.update_license_pool.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Commerce::Consumer::Procurement::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.update_license_pool.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.update_license_pool.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @license_management_service_stub.update_license_pool request, options do |result, operation|
                      yield result, operation if block_given?
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Assigns a license to a user.
                  #
                  # @overload assign(request, options = nil)
                  #   Pass arguments to `assign` via a request object, either of type
                  #   {::Google::Cloud::Commerce::Consumer::Procurement::V1::AssignRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Commerce::Consumer::Procurement::V1::AssignRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload assign(parent: nil, usernames: nil)
                  #   Pass arguments to `assign` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param parent [::String]
                  #     Required. License pool name.
                  #   @param usernames [::Array<::String>]
                  #     Required. Username.
                  #     Format: `name@domain.com`.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Commerce::Consumer::Procurement::V1::AssignResponse]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Commerce::Consumer::Procurement::V1::AssignResponse]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/commerce/consumer/procurement/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Commerce::Consumer::Procurement::V1::LicenseManagementService::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Commerce::Consumer::Procurement::V1::AssignRequest.new
                  #
                  #   # Call the assign method.
                  #   result = client.assign request
                  #
                  #   # The returned object is of type Google::Cloud::Commerce::Consumer::Procurement::V1::AssignResponse.
                  #   p result
                  #
                  def assign request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Commerce::Consumer::Procurement::V1::AssignRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.assign.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Commerce::Consumer::Procurement::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.assign.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.assign.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @license_management_service_stub.assign request, options do |result, operation|
                      yield result, operation if block_given?
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Unassigns a license from a user.
                  #
                  # @overload unassign(request, options = nil)
                  #   Pass arguments to `unassign` via a request object, either of type
                  #   {::Google::Cloud::Commerce::Consumer::Procurement::V1::UnassignRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Commerce::Consumer::Procurement::V1::UnassignRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload unassign(parent: nil, usernames: nil)
                  #   Pass arguments to `unassign` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param parent [::String]
                  #     Required. License pool name.
                  #   @param usernames [::Array<::String>]
                  #     Required. Username.
                  #     Format: `name@domain.com`.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Commerce::Consumer::Procurement::V1::UnassignResponse]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Commerce::Consumer::Procurement::V1::UnassignResponse]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/commerce/consumer/procurement/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Commerce::Consumer::Procurement::V1::LicenseManagementService::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Commerce::Consumer::Procurement::V1::UnassignRequest.new
                  #
                  #   # Call the unassign method.
                  #   result = client.unassign request
                  #
                  #   # The returned object is of type Google::Cloud::Commerce::Consumer::Procurement::V1::UnassignResponse.
                  #   p result
                  #
                  def unassign request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Commerce::Consumer::Procurement::V1::UnassignRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.unassign.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Commerce::Consumer::Procurement::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.unassign.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.unassign.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @license_management_service_stub.unassign request, options do |result, operation|
                      yield result, operation if block_given?
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Enumerates all users assigned a license.
                  #
                  # @overload enumerate_licensed_users(request, options = nil)
                  #   Pass arguments to `enumerate_licensed_users` via a request object, either of type
                  #   {::Google::Cloud::Commerce::Consumer::Procurement::V1::EnumerateLicensedUsersRequest} or an equivalent Hash.
                  #
                  #   @param request [::Google::Cloud::Commerce::Consumer::Procurement::V1::EnumerateLicensedUsersRequest, ::Hash]
                  #     A request object representing the call parameters. Required. To specify no
                  #     parameters, or to keep all the default parameter values, pass an empty Hash.
                  #   @param options [::Gapic::CallOptions, ::Hash]
                  #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @overload enumerate_licensed_users(parent: nil, page_size: nil, page_token: nil)
                  #   Pass arguments to `enumerate_licensed_users` via keyword arguments. Note that at
                  #   least one keyword argument is required. To specify no parameters, or to keep all
                  #   the default parameter values, pass an empty Hash as a request object (see above).
                  #
                  #   @param parent [::String]
                  #     Required. License pool name.
                  #   @param page_size [::Integer]
                  #     Optional. The maximum number of users to return. The service may return
                  #     fewer than this value.
                  #   @param page_token [::String]
                  #     Optional. A page token, received from a previous `EnumerateLicensedUsers`
                  #     call. Provide this to retrieve the subsequent page.
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Commerce::Consumer::Procurement::V1::LicensedUser>]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Commerce::Consumer::Procurement::V1::LicensedUser>]
                  #
                  # @raise [::Google::Cloud::Error] if the REST call is aborted.
                  #
                  # @example Basic example
                  #   require "google/cloud/commerce/consumer/procurement/v1"
                  #
                  #   # Create a client object. The client can be reused for multiple calls.
                  #   client = Google::Cloud::Commerce::Consumer::Procurement::V1::LicenseManagementService::Rest::Client.new
                  #
                  #   # Create a request. To set request fields, pass in keyword arguments.
                  #   request = Google::Cloud::Commerce::Consumer::Procurement::V1::EnumerateLicensedUsersRequest.new
                  #
                  #   # Call the enumerate_licensed_users method.
                  #   result = client.enumerate_licensed_users request
                  #
                  #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                  #   # over elements, and API calls will be issued to fetch pages as needed.
                  #   result.each do |item|
                  #     # Each element is of type ::Google::Cloud::Commerce::Consumer::Procurement::V1::LicensedUser.
                  #     p item
                  #   end
                  #
                  def enumerate_licensed_users request, options = nil
                    raise ::ArgumentError, "request must be provided" if request.nil?

                    request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Commerce::Consumer::Procurement::V1::EnumerateLicensedUsersRequest

                    # Converts hash and nil to an options object
                    options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                    # Customize the options with defaults
                    call_metadata = @config.rpcs.enumerate_licensed_users.metadata.to_h

                    # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                    call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                      lib_name: @config.lib_name, lib_version: @config.lib_version,
                      gapic_version: ::Google::Cloud::Commerce::Consumer::Procurement::V1::VERSION,
                      transports_version_send: [:rest]

                    call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                    call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                    options.apply_defaults timeout:      @config.rpcs.enumerate_licensed_users.timeout,
                                           metadata:     call_metadata,
                                           retry_policy: @config.rpcs.enumerate_licensed_users.retry_policy

                    options.apply_defaults timeout:      @config.timeout,
                                           metadata:     @config.metadata,
                                           retry_policy: @config.retry_policy

                    @license_management_service_stub.enumerate_licensed_users request, options do |result, operation|
                      result = ::Gapic::Rest::PagedEnumerable.new @license_management_service_stub, :enumerate_licensed_users, "licensed_users", request, result, options
                      yield result, operation if block_given?
                      throw :response, result
                    end
                  rescue ::Gapic::Rest::Error => e
                    raise ::Google::Cloud::Error.from_error(e)
                  end

                  ##
                  # Configuration class for the LicenseManagementService REST API.
                  #
                  # This class represents the configuration for LicenseManagementService REST,
                  # providing control over timeouts, retry behavior, logging, transport
                  # parameters, and other low-level controls. Certain parameters can also be
                  # applied individually to specific RPCs. See
                  # {::Google::Cloud::Commerce::Consumer::Procurement::V1::LicenseManagementService::Rest::Client::Configuration::Rpcs}
                  # for a list of RPCs that can be configured independently.
                  #
                  # Configuration can be applied globally to all clients, or to a single client
                  # on construction.
                  #
                  # @example
                  #
                  #   # Modify the global config, setting the timeout for
                  #   # get_license_pool to 20 seconds,
                  #   # and all remaining timeouts to 10 seconds.
                  #   ::Google::Cloud::Commerce::Consumer::Procurement::V1::LicenseManagementService::Rest::Client.configure do |config|
                  #     config.timeout = 10.0
                  #     config.rpcs.get_license_pool.timeout = 20.0
                  #   end
                  #
                  #   # Apply the above configuration only to a new client.
                  #   client = ::Google::Cloud::Commerce::Consumer::Procurement::V1::LicenseManagementService::Rest::Client.new do |config|
                  #     config.timeout = 10.0
                  #     config.rpcs.get_license_pool.timeout = 20.0
                  #   end
                  #
                  # @!attribute [rw] endpoint
                  #   A custom service endpoint, as a hostname or hostname:port. The default is
                  #   nil, indicating to use the default endpoint in the current universe domain.
                  #   @return [::String,nil]
                  # @!attribute [rw] credentials
                  #   Credentials to send with calls. You may provide any of the following types:
                  #    *  (`String`) The path to a service account key file in JSON format
                  #    *  (`Hash`) A service account key as a Hash
                  #    *  (`Google::Auth::Credentials`) A googleauth credentials object
                  #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
                  #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
                  #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
                  #    *  (`nil`) indicating no credentials
                  #
                  #   Warning: If you accept a credential configuration (JSON file or Hash) from an
                  #   external source for authentication to Google Cloud, you must validate it before
                  #   providing it to a Google API client library. Providing an unvalidated credential
                  #   configuration to Google APIs can compromise the security of your systems and data.
                  #   For more information, refer to [Validate credential configurations from external
                  #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
                  #   @return [::Object]
                  # @!attribute [rw] scope
                  #   The OAuth scopes
                  #   @return [::Array<::String>]
                  # @!attribute [rw] lib_name
                  #   The library name as recorded in instrumentation and logging
                  #   @return [::String]
                  # @!attribute [rw] lib_version
                  #   The library version as recorded in instrumentation and logging
                  #   @return [::String]
                  # @!attribute [rw] timeout
                  #   The call timeout in seconds.
                  #   @return [::Numeric]
                  # @!attribute [rw] metadata
                  #   Additional headers to be sent with the call.
                  #   @return [::Hash{::Symbol=>::String}]
                  # @!attribute [rw] retry_policy
                  #   The retry policy. The value is a hash with the following keys:
                  #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                  #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                  #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                  #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                  #       trigger a retry.
                  #   @return [::Hash]
                  # @!attribute [rw] quota_project
                  #   A separate project against which to charge quota.
                  #   @return [::String]
                  # @!attribute [rw] universe_domain
                  #   The universe domain within which to make requests. This determines the
                  #   default endpoint URL. The default value of nil uses the environment
                  #   universe (usually the default "googleapis.com" universe).
                  #   @return [::String,nil]
                  # @!attribute [rw] logger
                  #   A custom logger to use for request/response debug logging, or the value
                  #   `:default` (the default) to construct a default logger, or `nil` to
                  #   explicitly disable logging.
                  #   @return [::Logger,:default,nil]
                  #
                  class Configuration
                    extend ::Gapic::Config

                    # @private
                    # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                    DEFAULT_ENDPOINT = "cloudcommerceconsumerprocurement.googleapis.com"

                    config_attr :endpoint,      nil, ::String, nil
                    config_attr :credentials,   nil do |value|
                      allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                      allowed.any? { |klass| klass === value }
                    end
                    config_attr :scope,         nil, ::String, ::Array, nil
                    config_attr :lib_name,      nil, ::String, nil
                    config_attr :lib_version,   nil, ::String, nil
                    config_attr :timeout,       nil, ::Numeric, nil
                    config_attr :metadata,      nil, ::Hash, nil
                    config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                    config_attr :quota_project, nil, ::String, nil
                    config_attr :universe_domain, nil, ::String, nil
                    config_attr :logger, :default, ::Logger, nil, :default

                    # @private
                    def initialize parent_config = nil
                      @parent_config = parent_config unless parent_config.nil?

                      yield self if block_given?
                    end

                    ##
                    # Configurations for individual RPCs
                    # @return [Rpcs]
                    #
                    def rpcs
                      @rpcs ||= begin
                        parent_rpcs = nil
                        parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                        Rpcs.new parent_rpcs
                      end
                    end

                    ##
                    # Configuration RPC class for the LicenseManagementService API.
                    #
                    # Includes fields providing the configuration for each RPC in this service.
                    # Each configuration object is of type `Gapic::Config::Method` and includes
                    # the following configuration fields:
                    #
                    #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                    #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                    #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                    #     include the following keys:
                    #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                    #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                    #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                    #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                    #         trigger a retry.
                    #
                    class Rpcs
                      ##
                      # RPC-specific configuration for `get_license_pool`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :get_license_pool
                      ##
                      # RPC-specific configuration for `update_license_pool`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :update_license_pool
                      ##
                      # RPC-specific configuration for `assign`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :assign
                      ##
                      # RPC-specific configuration for `unassign`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :unassign
                      ##
                      # RPC-specific configuration for `enumerate_licensed_users`
                      # @return [::Gapic::Config::Method]
                      #
                      attr_reader :enumerate_licensed_users

                      # @private
                      def initialize parent_rpcs = nil
                        get_license_pool_config = parent_rpcs.get_license_pool if parent_rpcs.respond_to? :get_license_pool
                        @get_license_pool = ::Gapic::Config::Method.new get_license_pool_config
                        update_license_pool_config = parent_rpcs.update_license_pool if parent_rpcs.respond_to? :update_license_pool
                        @update_license_pool = ::Gapic::Config::Method.new update_license_pool_config
                        assign_config = parent_rpcs.assign if parent_rpcs.respond_to? :assign
                        @assign = ::Gapic::Config::Method.new assign_config
                        unassign_config = parent_rpcs.unassign if parent_rpcs.respond_to? :unassign
                        @unassign = ::Gapic::Config::Method.new unassign_config
                        enumerate_licensed_users_config = parent_rpcs.enumerate_licensed_users if parent_rpcs.respond_to? :enumerate_licensed_users
                        @enumerate_licensed_users = ::Gapic::Config::Method.new enumerate_licensed_users_config

                        yield self if block_given?
                      end
                    end
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
