# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Commerce
      module Consumer
        module Procurement
          module V1
            module LicenseManagementService
              # Path helper methods for the LicenseManagementService API.
              module Paths
                ##
                # Create a fully-qualified LicensePool resource string.
                #
                # The resource will be in the following format:
                #
                # `billingAccounts/{billing_account}/orders/{order}/licensePool`
                #
                # @param billing_account [String]
                # @param order [String]
                #
                # @return [::String]
                def license_pool_path billing_account:, order:
                  raise ::ArgumentError, "billing_account cannot contain /" if billing_account.to_s.include? "/"

                  "billingAccounts/#{billing_account}/orders/#{order}/licensePool"
                end

                extend self
              end
            end
          end
        end
      end
    end
  end
end
