# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/commerce/consumer/procurement/v1/procurement_service_pb"

module Google
  module Cloud
    module Commerce
      module Consumer
        module Procurement
          module V1
            module ConsumerProcurementService
              module Rest
                ##
                # REST service stub for the ConsumerProcurementService service.
                # Service stub contains baseline method implementations
                # including transcoding, making the REST call, and deserialing the response.
                #
                class ServiceStub
                  # @private
                  def initialize endpoint:, endpoint_template:, universe_domain:, credentials:, logger:
                    # These require statements are intentionally placed here to initialize
                    # the REST modules only when it's required.
                    require "gapic/rest"

                    @client_stub = ::Gapic::Rest::ClientStub.new endpoint: endpoint,
                                                                 endpoint_template: endpoint_template,
                                                                 universe_domain: universe_domain,
                                                                 credentials: credentials,
                                                                 numeric_enums: true,
                                                                 service_name: self.class,
                                                                 raise_faraday_errors: false,
                                                                 logger: logger
                  end

                  ##
                  # The effective universe domain
                  #
                  # @return [String]
                  #
                  def universe_domain
                    @client_stub.universe_domain
                  end

                  ##
                  # The effective endpoint
                  #
                  # @return [String]
                  #
                  def endpoint
                    @client_stub.endpoint
                  end

                  ##
                  # The logger used for request/response debug logging.
                  #
                  # @return [Logger]
                  #
                  def logger stub: false
                    stub ? @client_stub.stub_logger : @client_stub.logger
                  end

                  ##
                  # Baseline implementation for the place_order REST call
                  #
                  # @param request_pb [::Google::Cloud::Commerce::Consumer::Procurement::V1::PlaceOrderRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Longrunning::Operation]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Longrunning::Operation]
                  #   A result object deserialized from the server's reply
                  def place_order request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_place_order_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "place_order",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Longrunning::Operation.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the get_order REST call
                  #
                  # @param request_pb [::Google::Cloud::Commerce::Consumer::Procurement::V1::GetOrderRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Commerce::Consumer::Procurement::V1::Order]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Commerce::Consumer::Procurement::V1::Order]
                  #   A result object deserialized from the server's reply
                  def get_order request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_get_order_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "get_order",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Commerce::Consumer::Procurement::V1::Order.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the list_orders REST call
                  #
                  # @param request_pb [::Google::Cloud::Commerce::Consumer::Procurement::V1::ListOrdersRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Cloud::Commerce::Consumer::Procurement::V1::ListOrdersResponse]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Cloud::Commerce::Consumer::Procurement::V1::ListOrdersResponse]
                  #   A result object deserialized from the server's reply
                  def list_orders request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_list_orders_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "list_orders",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Cloud::Commerce::Consumer::Procurement::V1::ListOrdersResponse.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the modify_order REST call
                  #
                  # @param request_pb [::Google::Cloud::Commerce::Consumer::Procurement::V1::ModifyOrderRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Longrunning::Operation]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Longrunning::Operation]
                  #   A result object deserialized from the server's reply
                  def modify_order request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_modify_order_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "modify_order",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Longrunning::Operation.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # Baseline implementation for the cancel_order REST call
                  #
                  # @param request_pb [::Google::Cloud::Commerce::Consumer::Procurement::V1::CancelOrderRequest]
                  #   A request object representing the call parameters. Required.
                  # @param options [::Gapic::CallOptions]
                  #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                  #
                  # @yield [result, operation] Access the result along with the TransportOperation object
                  # @yieldparam result [::Google::Longrunning::Operation]
                  # @yieldparam operation [::Gapic::Rest::TransportOperation]
                  #
                  # @return [::Google::Longrunning::Operation]
                  #   A result object deserialized from the server's reply
                  def cancel_order request_pb, options = nil
                    raise ::ArgumentError, "request must be provided" if request_pb.nil?

                    verb, uri, query_string_params, body = ServiceStub.transcode_cancel_order_request request_pb
                    query_string_params = if query_string_params.any?
                                            query_string_params.to_h { |p| p.split "=", 2 }
                                          else
                                            {}
                                          end

                    response = @client_stub.make_http_request(
                      verb,
                      uri: uri,
                      body: body || "",
                      params: query_string_params,
                      method_name: "cancel_order",
                      options: options
                    )
                    operation = ::Gapic::Rest::TransportOperation.new response
                    result = ::Google::Longrunning::Operation.decode_json response.body, ignore_unknown_fields: true
                    catch :response do
                      yield result, operation if block_given?
                      result
                    end
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the place_order REST call
                  #
                  # @param request_pb [::Google::Cloud::Commerce::Consumer::Procurement::V1::PlaceOrderRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_place_order_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :post,
                                                              uri_template: "/v1/{parent}/orders:place",
                                                              body: "*",
                                                              matches: [
                                                                ["parent", %r{^billingAccounts/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the get_order REST call
                  #
                  # @param request_pb [::Google::Cloud::Commerce::Consumer::Procurement::V1::GetOrderRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_get_order_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :get,
                                                              uri_template: "/v1/{name}",
                                                              matches: [
                                                                ["name", %r{^billingAccounts/[^/]+/orders/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the list_orders REST call
                  #
                  # @param request_pb [::Google::Cloud::Commerce::Consumer::Procurement::V1::ListOrdersRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_list_orders_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :get,
                                                              uri_template: "/v1/{parent}/orders",
                                                              matches: [
                                                                ["parent", %r{^billingAccounts/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the modify_order REST call
                  #
                  # @param request_pb [::Google::Cloud::Commerce::Consumer::Procurement::V1::ModifyOrderRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_modify_order_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :post,
                                                              uri_template: "/v1/{name}:modify",
                                                              body: "*",
                                                              matches: [
                                                                ["name", %r{^billingAccounts/[^/]+/orders/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end

                  ##
                  # @private
                  #
                  # GRPC transcoding helper method for the cancel_order REST call
                  #
                  # @param request_pb [::Google::Cloud::Commerce::Consumer::Procurement::V1::CancelOrderRequest]
                  #   A request object representing the call parameters. Required.
                  # @return [Array(String, [String, nil], Hash{String => String})]
                  #   Uri, Body, Query string parameters
                  def self.transcode_cancel_order_request request_pb
                    transcoder = Gapic::Rest::GrpcTranscoder.new
                                                            .with_bindings(
                                                              uri_method: :post,
                                                              uri_template: "/v1/{name}:cancel",
                                                              body: "*",
                                                              matches: [
                                                                ["name", %r{^billingAccounts/[^/]+/orders/[^/]+/?$}, false]
                                                              ]
                                                            )
                    transcoder.transcode request_pb
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
