# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/commerce/consumer/procurement/v1/procurement_service_pb"

module Google
  module Cloud
    module Commerce
      module Consumer
        module Procurement
          module V1
            module ConsumerProcurementService
              ##
              # Client for the ConsumerProcurementService service.
              #
              # ConsumerProcurementService allows customers to make purchases of products
              # served by the Cloud Commerce platform.
              #
              #
              # When purchases are made, the
              # {::Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::Client ConsumerProcurementService}
              # programs the appropriate backends, including both Google's own
              # infrastructure, as well as third-party systems, and to enable billing setup
              # for charging for the procured item.
              #
              class Client
                # @private
                API_VERSION = ""

                # @private
                DEFAULT_ENDPOINT_TEMPLATE = "cloudcommerceconsumerprocurement.$UNIVERSE_DOMAIN$"

                include Paths

                # @private
                attr_reader :consumer_procurement_service_stub

                ##
                # Configure the ConsumerProcurementService Client class.
                #
                # See {::Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::Client::Configuration}
                # for a description of the configuration fields.
                #
                # @example
                #
                #   # Modify the configuration for all ConsumerProcurementService clients
                #   ::Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::Client.configure do |config|
                #     config.timeout = 10.0
                #   end
                #
                # @yield [config] Configure the Client client.
                # @yieldparam config [Client::Configuration]
                #
                # @return [Client::Configuration]
                #
                def self.configure
                  @configure ||= begin
                    namespace = ["Google", "Cloud", "Commerce", "Consumer", "Procurement", "V1"]
                    parent_config = while namespace.any?
                                      parent_name = namespace.join "::"
                                      parent_const = const_get parent_name
                                      break parent_const.configure if parent_const.respond_to? :configure
                                      namespace.pop
                                    end
                    default_config = Client::Configuration.new parent_config

                    default_config.rpcs.place_order.timeout = 60.0

                    default_config.rpcs.get_order.timeout = 60.0
                    default_config.rpcs.get_order.retry_policy = {
                      initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config.rpcs.list_orders.timeout = 60.0
                    default_config.rpcs.list_orders.retry_policy = {
                      initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config
                  end
                  yield @configure if block_given?
                  @configure
                end

                ##
                # Configure the ConsumerProcurementService Client instance.
                #
                # The configuration is set to the derived mode, meaning that values can be changed,
                # but structural changes (adding new fields, etc.) are not allowed. Structural changes
                # should be made on {Client.configure}.
                #
                # See {::Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::Client::Configuration}
                # for a description of the configuration fields.
                #
                # @yield [config] Configure the Client client.
                # @yieldparam config [Client::Configuration]
                #
                # @return [Client::Configuration]
                #
                def configure
                  yield @config if block_given?
                  @config
                end

                ##
                # The effective universe domain
                #
                # @return [String]
                #
                def universe_domain
                  @consumer_procurement_service_stub.universe_domain
                end

                ##
                # Create a new ConsumerProcurementService client object.
                #
                # @example
                #
                #   # Create a client using the default configuration
                #   client = ::Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::Client.new
                #
                #   # Create a client using a custom configuration
                #   client = ::Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::Client.new do |config|
                #     config.timeout = 10.0
                #   end
                #
                # @yield [config] Configure the ConsumerProcurementService client.
                # @yieldparam config [Client::Configuration]
                #
                def initialize
                  # These require statements are intentionally placed here to initialize
                  # the gRPC module only when it's required.
                  # See https://github.com/googleapis/toolkit/issues/446
                  require "gapic/grpc"
                  require "google/cloud/commerce/consumer/procurement/v1/procurement_service_services_pb"

                  # Create the configuration object
                  @config = Configuration.new Client.configure

                  # Yield the configuration if needed
                  yield @config if block_given?

                  # Create credentials
                  credentials = @config.credentials
                  # Use self-signed JWT if the endpoint is unchanged from default,
                  # but only if the default endpoint does not have a region prefix.
                  enable_self_signed_jwt = @config.endpoint.nil? ||
                                           (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                           !@config.endpoint.split(".").first.include?("-"))
                  credentials ||= Credentials.default scope: @config.scope,
                                                      enable_self_signed_jwt: enable_self_signed_jwt
                  if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                    credentials = Credentials.new credentials, scope: @config.scope
                  end
                  @quota_project_id = @config.quota_project
                  @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                  @operations_client = Operations.new do |config|
                    config.credentials = credentials
                    config.quota_project = @quota_project_id
                    config.endpoint = @config.endpoint
                    config.universe_domain = @config.universe_domain
                  end

                  @consumer_procurement_service_stub = ::Gapic::ServiceStub.new(
                    ::Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::Stub,
                    credentials: credentials,
                    endpoint: @config.endpoint,
                    endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                    universe_domain: @config.universe_domain,
                    channel_args: @config.channel_args,
                    interceptors: @config.interceptors,
                    channel_pool_config: @config.channel_pool,
                    logger: @config.logger
                  )

                  @consumer_procurement_service_stub.stub_logger&.info do |entry|
                    entry.set_system_name
                    entry.set_service
                    entry.message = "Created client for #{entry.service}"
                    entry.set_credentials_fields credentials
                    entry.set "customEndpoint", @config.endpoint if @config.endpoint
                    entry.set "defaultTimeout", @config.timeout if @config.timeout
                    entry.set "quotaProject", @quota_project_id if @quota_project_id
                  end
                end

                ##
                # Get the associated client for long-running operations.
                #
                # @return [::Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::Operations]
                #
                attr_reader :operations_client

                ##
                # The logger used for request/response debug logging.
                #
                # @return [Logger]
                #
                def logger
                  @consumer_procurement_service_stub.logger
                end

                # Service calls

                ##
                # Creates a new {::Google::Cloud::Commerce::Consumer::Procurement::V1::Order Order}.
                #
                # This API only supports GCP spend-based committed use
                # discounts specified by GCP documentation.
                #
                # The returned long-running operation is in-progress until the backend
                # completes the creation of the resource. Once completed, the order is
                # in
                # [OrderState.ORDER_STATE_ACTIVE][google.cloud.commerce.consumer.procurement.v1.OrderState.ORDER_STATE_ACTIVE].
                # In case of failure, the order resource will be removed.
                #
                # @overload place_order(request, options = nil)
                #   Pass arguments to `place_order` via a request object, either of type
                #   {::Google::Cloud::Commerce::Consumer::Procurement::V1::PlaceOrderRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Commerce::Consumer::Procurement::V1::PlaceOrderRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
                #
                # @overload place_order(parent: nil, display_name: nil, line_item_info: nil, request_id: nil)
                #   Pass arguments to `place_order` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The resource name of the parent resource.
                #     This field has the form  `billingAccounts/{billing-account-id}`.
                #   @param display_name [::String]
                #     Required. The user-specified name of the order being placed.
                #   @param line_item_info [::Array<::Google::Cloud::Commerce::Consumer::Procurement::V1::LineItemInfo, ::Hash>]
                #     Optional. Places order for offer. Required when an offer-based order is
                #     being placed.
                #   @param request_id [::String]
                #     Optional. A unique identifier for this request.
                #     The server will ignore subsequent requests that provide a duplicate request
                #     ID for at least 24 hours after the first request.
                #
                #     The request ID must be a valid
                #     [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format).
                #
                # @yield [response, operation] Access the result along with the RPC operation
                # @yieldparam response [::Gapic::Operation]
                # @yieldparam operation [::GRPC::ActiveCall::Operation]
                #
                # @return [::Gapic::Operation]
                #
                # @raise [::Google::Cloud::Error] if the RPC is aborted.
                #
                # @example Basic example
                #   require "google/cloud/commerce/consumer/procurement/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Commerce::Consumer::Procurement::V1::PlaceOrderRequest.new
                #
                #   # Call the place_order method.
                #   result = client.place_order request
                #
                #   # The returned object is of type Gapic::Operation. You can use it to
                #   # check the status of an operation, cancel it, or wait for results.
                #   # Here is how to wait for a response.
                #   result.wait_until_done! timeout: 60
                #   if result.response?
                #     p result.response
                #   else
                #     puts "No response received."
                #   end
                #
                def place_order request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Commerce::Consumer::Procurement::V1::PlaceOrderRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  metadata = @config.rpcs.place_order.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Commerce::Consumer::Procurement::V1::VERSION
                  metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  header_params = {}
                  if request.parent
                    header_params["parent"] = request.parent
                  end

                  request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                  metadata[:"x-goog-request-params"] ||= request_params_header

                  options.apply_defaults timeout:      @config.rpcs.place_order.timeout,
                                         metadata:     metadata,
                                         retry_policy: @config.rpcs.place_order.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @consumer_procurement_service_stub.call_rpc :place_order, request, options: options do |response, operation|
                    response = ::Gapic::Operation.new response, @operations_client, options: options
                    yield response, operation if block_given?
                    throw :response, response
                  end
                rescue ::GRPC::BadStatus => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Returns the requested
                # {::Google::Cloud::Commerce::Consumer::Procurement::V1::Order Order} resource.
                #
                # @overload get_order(request, options = nil)
                #   Pass arguments to `get_order` via a request object, either of type
                #   {::Google::Cloud::Commerce::Consumer::Procurement::V1::GetOrderRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Commerce::Consumer::Procurement::V1::GetOrderRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
                #
                # @overload get_order(name: nil)
                #   Pass arguments to `get_order` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The name of the order to retrieve.
                #
                # @yield [response, operation] Access the result along with the RPC operation
                # @yieldparam response [::Google::Cloud::Commerce::Consumer::Procurement::V1::Order]
                # @yieldparam operation [::GRPC::ActiveCall::Operation]
                #
                # @return [::Google::Cloud::Commerce::Consumer::Procurement::V1::Order]
                #
                # @raise [::Google::Cloud::Error] if the RPC is aborted.
                #
                # @example Basic example
                #   require "google/cloud/commerce/consumer/procurement/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Commerce::Consumer::Procurement::V1::GetOrderRequest.new
                #
                #   # Call the get_order method.
                #   result = client.get_order request
                #
                #   # The returned object is of type Google::Cloud::Commerce::Consumer::Procurement::V1::Order.
                #   p result
                #
                def get_order request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Commerce::Consumer::Procurement::V1::GetOrderRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  metadata = @config.rpcs.get_order.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Commerce::Consumer::Procurement::V1::VERSION
                  metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  header_params = {}
                  if request.name
                    header_params["name"] = request.name
                  end

                  request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                  metadata[:"x-goog-request-params"] ||= request_params_header

                  options.apply_defaults timeout:      @config.rpcs.get_order.timeout,
                                         metadata:     metadata,
                                         retry_policy: @config.rpcs.get_order.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @consumer_procurement_service_stub.call_rpc :get_order, request, options: options do |response, operation|
                    yield response, operation if block_given?
                  end
                rescue ::GRPC::BadStatus => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Lists {::Google::Cloud::Commerce::Consumer::Procurement::V1::Order Order}
                # resources that the user has access to, within the scope of the parent
                # resource.
                #
                # @overload list_orders(request, options = nil)
                #   Pass arguments to `list_orders` via a request object, either of type
                #   {::Google::Cloud::Commerce::Consumer::Procurement::V1::ListOrdersRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Commerce::Consumer::Procurement::V1::ListOrdersRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
                #
                # @overload list_orders(parent: nil, page_size: nil, page_token: nil, filter: nil)
                #   Pass arguments to `list_orders` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The parent resource to query for orders.
                #     This field has the form `billingAccounts/{billing-account-id}`.
                #   @param page_size [::Integer]
                #     The maximum number of entries requested.
                #     The default page size is 25 and the maximum page size is 200.
                #   @param page_token [::String]
                #     The token for fetching the next page.
                #   @param filter [::String]
                #     Filter that you can use to limit the list request.
                #
                #     A query string that can match a selected set of attributes
                #     with string values. For example, `display_name=abc`.
                #     Supported query attributes are
                #
                #     * `display_name`
                #
                #
                #     If the query contains special characters other than letters,
                #     underscore, or digits, the phrase must be quoted with double quotes. For
                #     example, `display_name="foo:bar"`, where the display name needs to be
                #     quoted because it contains special character colon.
                #
                #     Queries can be combined with `OR`, and `NOT` to form more complex queries.
                #     You can also group them to force a desired evaluation order.
                #     For example, `display_name=abc OR display_name=def`.
                #
                # @yield [response, operation] Access the result along with the RPC operation
                # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Commerce::Consumer::Procurement::V1::Order>]
                # @yieldparam operation [::GRPC::ActiveCall::Operation]
                #
                # @return [::Gapic::PagedEnumerable<::Google::Cloud::Commerce::Consumer::Procurement::V1::Order>]
                #
                # @raise [::Google::Cloud::Error] if the RPC is aborted.
                #
                # @example Basic example
                #   require "google/cloud/commerce/consumer/procurement/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Commerce::Consumer::Procurement::V1::ListOrdersRequest.new
                #
                #   # Call the list_orders method.
                #   result = client.list_orders request
                #
                #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                #   # over elements, and API calls will be issued to fetch pages as needed.
                #   result.each do |item|
                #     # Each element is of type ::Google::Cloud::Commerce::Consumer::Procurement::V1::Order.
                #     p item
                #   end
                #
                def list_orders request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Commerce::Consumer::Procurement::V1::ListOrdersRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  metadata = @config.rpcs.list_orders.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Commerce::Consumer::Procurement::V1::VERSION
                  metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  header_params = {}
                  if request.parent
                    header_params["parent"] = request.parent
                  end

                  request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                  metadata[:"x-goog-request-params"] ||= request_params_header

                  options.apply_defaults timeout:      @config.rpcs.list_orders.timeout,
                                         metadata:     metadata,
                                         retry_policy: @config.rpcs.list_orders.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @consumer_procurement_service_stub.call_rpc :list_orders, request, options: options do |response, operation|
                    response = ::Gapic::PagedEnumerable.new @consumer_procurement_service_stub, :list_orders, request, response, operation, options
                    yield response, operation if block_given?
                    throw :response, response
                  end
                rescue ::GRPC::BadStatus => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Modifies an existing
                # {::Google::Cloud::Commerce::Consumer::Procurement::V1::Order Order} resource.
                #
                # @overload modify_order(request, options = nil)
                #   Pass arguments to `modify_order` via a request object, either of type
                #   {::Google::Cloud::Commerce::Consumer::Procurement::V1::ModifyOrderRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Commerce::Consumer::Procurement::V1::ModifyOrderRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
                #
                # @overload modify_order(name: nil, modifications: nil, display_name: nil, etag: nil)
                #   Pass arguments to `modify_order` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. Name of the order to update.
                #   @param modifications [::Array<::Google::Cloud::Commerce::Consumer::Procurement::V1::ModifyOrderRequest::Modification, ::Hash>]
                #     Optional. Modifications for an existing Order created by an Offer.
                #     Required when Offer based Order is being modified, except for when going
                #     from an offer to a public plan.
                #   @param display_name [::String]
                #     Optional. Updated display name of the order, leave as empty if you do not
                #     want to update current display name.
                #   @param etag [::String]
                #     Optional. The weak etag, which can be optionally populated, of the order
                #     that this modify request is based on. Validation checking will only happen
                #     if the invoker supplies this field.
                #
                # @yield [response, operation] Access the result along with the RPC operation
                # @yieldparam response [::Gapic::Operation]
                # @yieldparam operation [::GRPC::ActiveCall::Operation]
                #
                # @return [::Gapic::Operation]
                #
                # @raise [::Google::Cloud::Error] if the RPC is aborted.
                #
                # @example Basic example
                #   require "google/cloud/commerce/consumer/procurement/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Commerce::Consumer::Procurement::V1::ModifyOrderRequest.new
                #
                #   # Call the modify_order method.
                #   result = client.modify_order request
                #
                #   # The returned object is of type Gapic::Operation. You can use it to
                #   # check the status of an operation, cancel it, or wait for results.
                #   # Here is how to wait for a response.
                #   result.wait_until_done! timeout: 60
                #   if result.response?
                #     p result.response
                #   else
                #     puts "No response received."
                #   end
                #
                def modify_order request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Commerce::Consumer::Procurement::V1::ModifyOrderRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  metadata = @config.rpcs.modify_order.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Commerce::Consumer::Procurement::V1::VERSION
                  metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  header_params = {}
                  if request.name
                    header_params["name"] = request.name
                  end

                  request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                  metadata[:"x-goog-request-params"] ||= request_params_header

                  options.apply_defaults timeout:      @config.rpcs.modify_order.timeout,
                                         metadata:     metadata,
                                         retry_policy: @config.rpcs.modify_order.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @consumer_procurement_service_stub.call_rpc :modify_order, request, options: options do |response, operation|
                    response = ::Gapic::Operation.new response, @operations_client, options: options
                    yield response, operation if block_given?
                    throw :response, response
                  end
                rescue ::GRPC::BadStatus => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Cancels an existing
                # {::Google::Cloud::Commerce::Consumer::Procurement::V1::Order Order}. Every product
                # procured in the Order will be cancelled.
                #
                # @overload cancel_order(request, options = nil)
                #   Pass arguments to `cancel_order` via a request object, either of type
                #   {::Google::Cloud::Commerce::Consumer::Procurement::V1::CancelOrderRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Commerce::Consumer::Procurement::V1::CancelOrderRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
                #
                # @overload cancel_order(name: nil, etag: nil, cancellation_policy: nil)
                #   Pass arguments to `cancel_order` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The resource name of the order.
                #   @param etag [::String]
                #     Optional. The weak etag, which can be optionally populated, of the order
                #     that this cancel request is based on. Validation checking will only happen
                #     if the invoker supplies this field.
                #   @param cancellation_policy [::Google::Cloud::Commerce::Consumer::Procurement::V1::CancelOrderRequest::CancellationPolicy]
                #     Optional. Cancellation policy of this request.
                #
                # @yield [response, operation] Access the result along with the RPC operation
                # @yieldparam response [::Gapic::Operation]
                # @yieldparam operation [::GRPC::ActiveCall::Operation]
                #
                # @return [::Gapic::Operation]
                #
                # @raise [::Google::Cloud::Error] if the RPC is aborted.
                #
                # @example Basic example
                #   require "google/cloud/commerce/consumer/procurement/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Commerce::Consumer::Procurement::V1::CancelOrderRequest.new
                #
                #   # Call the cancel_order method.
                #   result = client.cancel_order request
                #
                #   # The returned object is of type Gapic::Operation. You can use it to
                #   # check the status of an operation, cancel it, or wait for results.
                #   # Here is how to wait for a response.
                #   result.wait_until_done! timeout: 60
                #   if result.response?
                #     p result.response
                #   else
                #     puts "No response received."
                #   end
                #
                def cancel_order request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Commerce::Consumer::Procurement::V1::CancelOrderRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  metadata = @config.rpcs.cancel_order.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Commerce::Consumer::Procurement::V1::VERSION
                  metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  header_params = {}
                  if request.name
                    header_params["name"] = request.name
                  end

                  request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                  metadata[:"x-goog-request-params"] ||= request_params_header

                  options.apply_defaults timeout:      @config.rpcs.cancel_order.timeout,
                                         metadata:     metadata,
                                         retry_policy: @config.rpcs.cancel_order.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @consumer_procurement_service_stub.call_rpc :cancel_order, request, options: options do |response, operation|
                    response = ::Gapic::Operation.new response, @operations_client, options: options
                    yield response, operation if block_given?
                    throw :response, response
                  end
                rescue ::GRPC::BadStatus => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Configuration class for the ConsumerProcurementService API.
                #
                # This class represents the configuration for ConsumerProcurementService,
                # providing control over timeouts, retry behavior, logging, transport
                # parameters, and other low-level controls. Certain parameters can also be
                # applied individually to specific RPCs. See
                # {::Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::Client::Configuration::Rpcs}
                # for a list of RPCs that can be configured independently.
                #
                # Configuration can be applied globally to all clients, or to a single client
                # on construction.
                #
                # @example
                #
                #   # Modify the global config, setting the timeout for
                #   # place_order to 20 seconds,
                #   # and all remaining timeouts to 10 seconds.
                #   ::Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::Client.configure do |config|
                #     config.timeout = 10.0
                #     config.rpcs.place_order.timeout = 20.0
                #   end
                #
                #   # Apply the above configuration only to a new client.
                #   client = ::Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::Client.new do |config|
                #     config.timeout = 10.0
                #     config.rpcs.place_order.timeout = 20.0
                #   end
                #
                # @!attribute [rw] endpoint
                #   A custom service endpoint, as a hostname or hostname:port. The default is
                #   nil, indicating to use the default endpoint in the current universe domain.
                #   @return [::String,nil]
                # @!attribute [rw] credentials
                #   Credentials to send with calls. You may provide any of the following types:
                #    *  (`Google::Auth::Credentials`) A googleauth credentials object
                #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
                #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
                #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
                #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
                #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
                #    *  (`nil`) indicating no credentials
                #
                #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
                #     is deprecated. Providing an unvalidated credential configuration to
                #     Google APIs can compromise the security of your systems and data.
                #
                #   @example
                #
                #     # The recommended way to provide credentials is to use the `make_creds` method
                #     # on the appropriate credentials class for your environment.
                #
                #     require "googleauth"
                #
                #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
                #       json_key_io: ::File.open("/path/to/keyfile.json")
                #     )
                #
                #     client = ::Google::Cloud::Commerce::Consumer::Procurement::V1::ConsumerProcurementService::Client.new do |config|
                #       config.credentials = credentials
                #     end
                #
                #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
                #   external source for authentication to Google Cloud, you must validate it before
                #   providing it to a Google API client library. Providing an unvalidated credential
                #   configuration to Google APIs can compromise the security of your systems and data.
                #   For more information, refer to [Validate credential configurations from external
                #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
                #   @return [::Object]
                # @!attribute [rw] scope
                #   The OAuth scopes
                #   @return [::Array<::String>]
                # @!attribute [rw] lib_name
                #   The library name as recorded in instrumentation and logging
                #   @return [::String]
                # @!attribute [rw] lib_version
                #   The library version as recorded in instrumentation and logging
                #   @return [::String]
                # @!attribute [rw] channel_args
                #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
                #   `GRPC::Core::Channel` object is provided as the credential.
                #   @return [::Hash]
                # @!attribute [rw] interceptors
                #   An array of interceptors that are run before calls are executed.
                #   @return [::Array<::GRPC::ClientInterceptor>]
                # @!attribute [rw] timeout
                #   The call timeout in seconds.
                #   @return [::Numeric]
                # @!attribute [rw] metadata
                #   Additional gRPC headers to be sent with the call.
                #   @return [::Hash{::Symbol=>::String}]
                # @!attribute [rw] retry_policy
                #   The retry policy. The value is a hash with the following keys:
                #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #       trigger a retry.
                #   @return [::Hash]
                # @!attribute [rw] quota_project
                #   A separate project against which to charge quota.
                #   @return [::String]
                # @!attribute [rw] universe_domain
                #   The universe domain within which to make requests. This determines the
                #   default endpoint URL. The default value of nil uses the environment
                #   universe (usually the default "googleapis.com" universe).
                #   @return [::String,nil]
                # @!attribute [rw] logger
                #   A custom logger to use for request/response debug logging, or the value
                #   `:default` (the default) to construct a default logger, or `nil` to
                #   explicitly disable logging.
                #   @return [::Logger,:default,nil]
                #
                class Configuration
                  extend ::Gapic::Config

                  # @private
                  # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                  DEFAULT_ENDPOINT = "cloudcommerceconsumerprocurement.googleapis.com"

                  config_attr :endpoint,      nil, ::String, nil
                  config_attr :credentials,   nil do |value|
                    allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                    allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                    allowed.any? { |klass| klass === value }
                  end
                  config_attr :scope,         nil, ::String, ::Array, nil
                  config_attr :lib_name,      nil, ::String, nil
                  config_attr :lib_version,   nil, ::String, nil
                  config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
                  config_attr :interceptors,  nil, ::Array, nil
                  config_attr :timeout,       nil, ::Numeric, nil
                  config_attr :metadata,      nil, ::Hash, nil
                  config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                  config_attr :quota_project, nil, ::String, nil
                  config_attr :universe_domain, nil, ::String, nil
                  config_attr :logger, :default, ::Logger, nil, :default

                  # @private
                  def initialize parent_config = nil
                    @parent_config = parent_config unless parent_config.nil?

                    yield self if block_given?
                  end

                  ##
                  # Configurations for individual RPCs
                  # @return [Rpcs]
                  #
                  def rpcs
                    @rpcs ||= begin
                      parent_rpcs = nil
                      parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                      Rpcs.new parent_rpcs
                    end
                  end

                  ##
                  # Configuration for the channel pool
                  # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
                  #
                  def channel_pool
                    @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
                  end

                  ##
                  # Configuration RPC class for the ConsumerProcurementService API.
                  #
                  # Includes fields providing the configuration for each RPC in this service.
                  # Each configuration object is of type `Gapic::Config::Method` and includes
                  # the following configuration fields:
                  #
                  #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                  #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
                  #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                  #     include the following keys:
                  #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                  #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                  #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                  #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                  #         trigger a retry.
                  #
                  class Rpcs
                    ##
                    # RPC-specific configuration for `place_order`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :place_order
                    ##
                    # RPC-specific configuration for `get_order`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :get_order
                    ##
                    # RPC-specific configuration for `list_orders`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :list_orders
                    ##
                    # RPC-specific configuration for `modify_order`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :modify_order
                    ##
                    # RPC-specific configuration for `cancel_order`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :cancel_order

                    # @private
                    def initialize parent_rpcs = nil
                      place_order_config = parent_rpcs.place_order if parent_rpcs.respond_to? :place_order
                      @place_order = ::Gapic::Config::Method.new place_order_config
                      get_order_config = parent_rpcs.get_order if parent_rpcs.respond_to? :get_order
                      @get_order = ::Gapic::Config::Method.new get_order_config
                      list_orders_config = parent_rpcs.list_orders if parent_rpcs.respond_to? :list_orders
                      @list_orders = ::Gapic::Config::Method.new list_orders_config
                      modify_order_config = parent_rpcs.modify_order if parent_rpcs.respond_to? :modify_order
                      @modify_order = ::Gapic::Config::Method.new modify_order_config
                      cancel_order_config = parent_rpcs.cancel_order if parent_rpcs.respond_to? :cancel_order
                      @cancel_order = ::Gapic::Config::Method.new cancel_order_config

                      yield self if block_given?
                    end
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
