# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "google/cloud/cloud_security_compliance"
require "gapic/common"
require "gapic/grpc"
require "gapic/rest"

class Google::Cloud::CloudSecurityCompliance::ClientConstructionMinitest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_audit_grpc
    skip unless Google::Cloud::CloudSecurityCompliance.audit_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::CloudSecurityCompliance.audit transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::CloudSecurityCompliance::V1::Audit::Client, client
    end
  end

  def test_audit_rest
    skip unless Google::Cloud::CloudSecurityCompliance.audit_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::CloudSecurityCompliance.audit transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::CloudSecurityCompliance::V1::Audit::Rest::Client, client
    end
  end

  def test_cm_enrollment_service_grpc
    skip unless Google::Cloud::CloudSecurityCompliance.cm_enrollment_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::CloudSecurityCompliance.cm_enrollment_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::CloudSecurityCompliance::V1::CmEnrollmentService::Client, client
    end
  end

  def test_cm_enrollment_service_rest
    skip unless Google::Cloud::CloudSecurityCompliance.cm_enrollment_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::CloudSecurityCompliance.cm_enrollment_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::CloudSecurityCompliance::V1::CmEnrollmentService::Rest::Client, client
    end
  end

  def test_config_grpc
    skip unless Google::Cloud::CloudSecurityCompliance.config_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::CloudSecurityCompliance.config transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::CloudSecurityCompliance::V1::Config::Client, client
    end
  end

  def test_config_rest
    skip unless Google::Cloud::CloudSecurityCompliance.config_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::CloudSecurityCompliance.config transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::CloudSecurityCompliance::V1::Config::Rest::Client, client
    end
  end

  def test_deployment_grpc
    skip unless Google::Cloud::CloudSecurityCompliance.deployment_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::CloudSecurityCompliance.deployment transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::CloudSecurityCompliance::V1::Deployment::Client, client
    end
  end

  def test_deployment_rest
    skip unless Google::Cloud::CloudSecurityCompliance.deployment_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::CloudSecurityCompliance.deployment transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::CloudSecurityCompliance::V1::Deployment::Rest::Client, client
    end
  end

  def test_monitoring_grpc
    skip unless Google::Cloud::CloudSecurityCompliance.monitoring_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::CloudSecurityCompliance.monitoring transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::CloudSecurityCompliance::V1::Monitoring::Client, client
    end
  end

  def test_monitoring_rest
    skip unless Google::Cloud::CloudSecurityCompliance.monitoring_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::CloudSecurityCompliance.monitoring transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::CloudSecurityCompliance::V1::Monitoring::Rest::Client, client
    end
  end
end
