# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/cloudsecuritycompliance/v1/monitoring_pb"
require "google/cloud/cloud_security_compliance/v1/monitoring"

class ::Google::Cloud::CloudSecurityCompliance::V1::Monitoring::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_framework_compliance_summaries
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CloudSecurityCompliance::V1::ListFrameworkComplianceSummariesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_framework_compliance_summaries_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_framework_compliance_summaries, name
      assert_kind_of ::Google::Cloud::CloudSecurityCompliance::V1::ListFrameworkComplianceSummariesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_framework_compliance_summaries_client_stub do
      # Create client
      client = ::Google::Cloud::CloudSecurityCompliance::V1::Monitoring::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_framework_compliance_summaries({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_framework_compliance_summaries parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_framework_compliance_summaries ::Google::Cloud::CloudSecurityCompliance::V1::ListFrameworkComplianceSummariesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_framework_compliance_summaries({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_framework_compliance_summaries(::Google::Cloud::CloudSecurityCompliance::V1::ListFrameworkComplianceSummariesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_framework_compliance_summaries_client_stub.call_rpc_count
    end
  end

  def test_list_finding_summaries
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CloudSecurityCompliance::V1::ListFindingSummariesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    end_time = {}

    list_finding_summaries_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_finding_summaries, name
      assert_kind_of ::Google::Cloud::CloudSecurityCompliance::V1::ListFindingSummariesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Timestamp), request["end_time"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_finding_summaries_client_stub do
      # Create client
      client = ::Google::Cloud::CloudSecurityCompliance::V1::Monitoring::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_finding_summaries({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, end_time: end_time }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_finding_summaries parent: parent, page_size: page_size, page_token: page_token, filter: filter, end_time: end_time do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_finding_summaries ::Google::Cloud::CloudSecurityCompliance::V1::ListFindingSummariesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, end_time: end_time) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_finding_summaries({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, end_time: end_time }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_finding_summaries(::Google::Cloud::CloudSecurityCompliance::V1::ListFindingSummariesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, end_time: end_time), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_finding_summaries_client_stub.call_rpc_count
    end
  end

  def test_fetch_framework_compliance_report
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CloudSecurityCompliance::V1::FrameworkComplianceReport.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    end_time = {}

    fetch_framework_compliance_report_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :fetch_framework_compliance_report, name
      assert_kind_of ::Google::Cloud::CloudSecurityCompliance::V1::FetchFrameworkComplianceReportRequest, request
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Timestamp), request["end_time"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, fetch_framework_compliance_report_client_stub do
      # Create client
      client = ::Google::Cloud::CloudSecurityCompliance::V1::Monitoring::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.fetch_framework_compliance_report({ name: name, end_time: end_time }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.fetch_framework_compliance_report name: name, end_time: end_time do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.fetch_framework_compliance_report ::Google::Cloud::CloudSecurityCompliance::V1::FetchFrameworkComplianceReportRequest.new(name: name, end_time: end_time) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.fetch_framework_compliance_report({ name: name, end_time: end_time }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.fetch_framework_compliance_report(::Google::Cloud::CloudSecurityCompliance::V1::FetchFrameworkComplianceReportRequest.new(name: name, end_time: end_time), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, fetch_framework_compliance_report_client_stub.call_rpc_count
    end
  end

  def test_list_control_compliance_summaries
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CloudSecurityCompliance::V1::ListControlComplianceSummariesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    end_time = {}
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_control_compliance_summaries_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_control_compliance_summaries, name
      assert_kind_of ::Google::Cloud::CloudSecurityCompliance::V1::ListControlComplianceSummariesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Timestamp), request["end_time"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_control_compliance_summaries_client_stub do
      # Create client
      client = ::Google::Cloud::CloudSecurityCompliance::V1::Monitoring::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_control_compliance_summaries({ parent: parent, end_time: end_time, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_control_compliance_summaries parent: parent, end_time: end_time, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_control_compliance_summaries ::Google::Cloud::CloudSecurityCompliance::V1::ListControlComplianceSummariesRequest.new(parent: parent, end_time: end_time, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_control_compliance_summaries({ parent: parent, end_time: end_time, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_control_compliance_summaries(::Google::Cloud::CloudSecurityCompliance::V1::ListControlComplianceSummariesRequest.new(parent: parent, end_time: end_time, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_control_compliance_summaries_client_stub.call_rpc_count
    end
  end

  def test_aggregate_framework_compliance_report
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CloudSecurityCompliance::V1::AggregateFrameworkComplianceReportResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    interval = {}
    filter = "hello world"

    aggregate_framework_compliance_report_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :aggregate_framework_compliance_report, name
      assert_kind_of ::Google::Cloud::CloudSecurityCompliance::V1::AggregateFrameworkComplianceReportRequest, request
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Type::Interval), request["interval"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, aggregate_framework_compliance_report_client_stub do
      # Create client
      client = ::Google::Cloud::CloudSecurityCompliance::V1::Monitoring::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.aggregate_framework_compliance_report({ name: name, interval: interval, filter: filter }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.aggregate_framework_compliance_report name: name, interval: interval, filter: filter do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.aggregate_framework_compliance_report ::Google::Cloud::CloudSecurityCompliance::V1::AggregateFrameworkComplianceReportRequest.new(name: name, interval: interval, filter: filter) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.aggregate_framework_compliance_report({ name: name, interval: interval, filter: filter }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.aggregate_framework_compliance_report(::Google::Cloud::CloudSecurityCompliance::V1::AggregateFrameworkComplianceReportRequest.new(name: name, interval: interval, filter: filter), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, aggregate_framework_compliance_report_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::CloudSecurityCompliance::V1::Monitoring::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::CloudSecurityCompliance::V1::Monitoring::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::CloudSecurityCompliance::V1::Monitoring::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::CloudSecurityCompliance::V1::Monitoring::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
