# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/cloudsecuritycompliance/v1/deployment_pb"
require "google/cloud/cloud_security_compliance/v1/deployment"

class ::Google::Cloud::CloudSecurityCompliance::V1::Deployment::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_framework_deployment
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    framework_deployment_id = "hello world"
    framework_deployment = {}

    create_framework_deployment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_framework_deployment, name
      assert_kind_of ::Google::Cloud::CloudSecurityCompliance::V1::CreateFrameworkDeploymentRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["framework_deployment_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::CloudSecurityCompliance::V1::FrameworkDeployment), request["framework_deployment"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_framework_deployment_client_stub do
      # Create client
      client = ::Google::Cloud::CloudSecurityCompliance::V1::Deployment::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_framework_deployment({ parent: parent, framework_deployment_id: framework_deployment_id, framework_deployment: framework_deployment }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_framework_deployment parent: parent, framework_deployment_id: framework_deployment_id, framework_deployment: framework_deployment do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_framework_deployment ::Google::Cloud::CloudSecurityCompliance::V1::CreateFrameworkDeploymentRequest.new(parent: parent, framework_deployment_id: framework_deployment_id, framework_deployment: framework_deployment) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_framework_deployment({ parent: parent, framework_deployment_id: framework_deployment_id, framework_deployment: framework_deployment }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_framework_deployment(::Google::Cloud::CloudSecurityCompliance::V1::CreateFrameworkDeploymentRequest.new(parent: parent, framework_deployment_id: framework_deployment_id, framework_deployment: framework_deployment), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_framework_deployment_client_stub.call_rpc_count
    end
  end

  def test_delete_framework_deployment
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_framework_deployment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_framework_deployment, name
      assert_kind_of ::Google::Cloud::CloudSecurityCompliance::V1::DeleteFrameworkDeploymentRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_framework_deployment_client_stub do
      # Create client
      client = ::Google::Cloud::CloudSecurityCompliance::V1::Deployment::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_framework_deployment({ name: name, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_framework_deployment name: name, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_framework_deployment ::Google::Cloud::CloudSecurityCompliance::V1::DeleteFrameworkDeploymentRequest.new(name: name, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_framework_deployment({ name: name, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_framework_deployment(::Google::Cloud::CloudSecurityCompliance::V1::DeleteFrameworkDeploymentRequest.new(name: name, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_framework_deployment_client_stub.call_rpc_count
    end
  end

  def test_get_framework_deployment
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CloudSecurityCompliance::V1::FrameworkDeployment.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_framework_deployment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_framework_deployment, name
      assert_kind_of ::Google::Cloud::CloudSecurityCompliance::V1::GetFrameworkDeploymentRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_framework_deployment_client_stub do
      # Create client
      client = ::Google::Cloud::CloudSecurityCompliance::V1::Deployment::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_framework_deployment({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_framework_deployment name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_framework_deployment ::Google::Cloud::CloudSecurityCompliance::V1::GetFrameworkDeploymentRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_framework_deployment({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_framework_deployment(::Google::Cloud::CloudSecurityCompliance::V1::GetFrameworkDeploymentRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_framework_deployment_client_stub.call_rpc_count
    end
  end

  def test_list_framework_deployments
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CloudSecurityCompliance::V1::ListFrameworkDeploymentsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_framework_deployments_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_framework_deployments, name
      assert_kind_of ::Google::Cloud::CloudSecurityCompliance::V1::ListFrameworkDeploymentsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_framework_deployments_client_stub do
      # Create client
      client = ::Google::Cloud::CloudSecurityCompliance::V1::Deployment::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_framework_deployments({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_framework_deployments parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_framework_deployments ::Google::Cloud::CloudSecurityCompliance::V1::ListFrameworkDeploymentsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_framework_deployments({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_framework_deployments(::Google::Cloud::CloudSecurityCompliance::V1::ListFrameworkDeploymentsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_framework_deployments_client_stub.call_rpc_count
    end
  end

  def test_get_cloud_control_deployment
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CloudSecurityCompliance::V1::CloudControlDeployment.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_cloud_control_deployment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_cloud_control_deployment, name
      assert_kind_of ::Google::Cloud::CloudSecurityCompliance::V1::GetCloudControlDeploymentRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_cloud_control_deployment_client_stub do
      # Create client
      client = ::Google::Cloud::CloudSecurityCompliance::V1::Deployment::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_cloud_control_deployment({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_cloud_control_deployment name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_cloud_control_deployment ::Google::Cloud::CloudSecurityCompliance::V1::GetCloudControlDeploymentRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_cloud_control_deployment({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_cloud_control_deployment(::Google::Cloud::CloudSecurityCompliance::V1::GetCloudControlDeploymentRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_cloud_control_deployment_client_stub.call_rpc_count
    end
  end

  def test_list_cloud_control_deployments
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CloudSecurityCompliance::V1::ListCloudControlDeploymentsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_cloud_control_deployments_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_cloud_control_deployments, name
      assert_kind_of ::Google::Cloud::CloudSecurityCompliance::V1::ListCloudControlDeploymentsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_cloud_control_deployments_client_stub do
      # Create client
      client = ::Google::Cloud::CloudSecurityCompliance::V1::Deployment::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_cloud_control_deployments({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_cloud_control_deployments parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_cloud_control_deployments ::Google::Cloud::CloudSecurityCompliance::V1::ListCloudControlDeploymentsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_cloud_control_deployments({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_cloud_control_deployments(::Google::Cloud::CloudSecurityCompliance::V1::ListCloudControlDeploymentsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_cloud_control_deployments_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::CloudSecurityCompliance::V1::Deployment::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::CloudSecurityCompliance::V1::Deployment::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::CloudSecurityCompliance::V1::Deployment::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::CloudSecurityCompliance::V1::Deployment::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::CloudSecurityCompliance::V1::Deployment::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::CloudSecurityCompliance::V1::Deployment::Operations, client.operations_client
  end
end
