# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/cloudsecuritycompliance/v1/config_pb"
require "google/cloud/cloud_security_compliance/v1/config"

class ::Google::Cloud::CloudSecurityCompliance::V1::Config::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_frameworks
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CloudSecurityCompliance::V1::ListFrameworksResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_frameworks_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_frameworks, name
      assert_kind_of ::Google::Cloud::CloudSecurityCompliance::V1::ListFrameworksRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_frameworks_client_stub do
      # Create client
      client = ::Google::Cloud::CloudSecurityCompliance::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_frameworks({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_frameworks parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_frameworks ::Google::Cloud::CloudSecurityCompliance::V1::ListFrameworksRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_frameworks({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_frameworks(::Google::Cloud::CloudSecurityCompliance::V1::ListFrameworksRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_frameworks_client_stub.call_rpc_count
    end
  end

  def test_get_framework
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CloudSecurityCompliance::V1::Framework.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    major_revision_id = 42

    get_framework_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_framework, name
      assert_kind_of ::Google::Cloud::CloudSecurityCompliance::V1::GetFrameworkRequest, request
      assert_equal "hello world", request["name"]
      assert_equal 42, request["major_revision_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_framework_client_stub do
      # Create client
      client = ::Google::Cloud::CloudSecurityCompliance::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_framework({ name: name, major_revision_id: major_revision_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_framework name: name, major_revision_id: major_revision_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_framework ::Google::Cloud::CloudSecurityCompliance::V1::GetFrameworkRequest.new(name: name, major_revision_id: major_revision_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_framework({ name: name, major_revision_id: major_revision_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_framework(::Google::Cloud::CloudSecurityCompliance::V1::GetFrameworkRequest.new(name: name, major_revision_id: major_revision_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_framework_client_stub.call_rpc_count
    end
  end

  def test_create_framework
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CloudSecurityCompliance::V1::Framework.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    framework_id = "hello world"
    framework = {}

    create_framework_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_framework, name
      assert_kind_of ::Google::Cloud::CloudSecurityCompliance::V1::CreateFrameworkRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["framework_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::CloudSecurityCompliance::V1::Framework), request["framework"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_framework_client_stub do
      # Create client
      client = ::Google::Cloud::CloudSecurityCompliance::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_framework({ parent: parent, framework_id: framework_id, framework: framework }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_framework parent: parent, framework_id: framework_id, framework: framework do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_framework ::Google::Cloud::CloudSecurityCompliance::V1::CreateFrameworkRequest.new(parent: parent, framework_id: framework_id, framework: framework) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_framework({ parent: parent, framework_id: framework_id, framework: framework }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_framework(::Google::Cloud::CloudSecurityCompliance::V1::CreateFrameworkRequest.new(parent: parent, framework_id: framework_id, framework: framework), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_framework_client_stub.call_rpc_count
    end
  end

  def test_update_framework
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CloudSecurityCompliance::V1::Framework.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    framework = {}
    major_revision_id = 42

    update_framework_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_framework, name
      assert_kind_of ::Google::Cloud::CloudSecurityCompliance::V1::UpdateFrameworkRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::CloudSecurityCompliance::V1::Framework), request["framework"]
      assert_equal 42, request["major_revision_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_framework_client_stub do
      # Create client
      client = ::Google::Cloud::CloudSecurityCompliance::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_framework({ update_mask: update_mask, framework: framework, major_revision_id: major_revision_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_framework update_mask: update_mask, framework: framework, major_revision_id: major_revision_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_framework ::Google::Cloud::CloudSecurityCompliance::V1::UpdateFrameworkRequest.new(update_mask: update_mask, framework: framework, major_revision_id: major_revision_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_framework({ update_mask: update_mask, framework: framework, major_revision_id: major_revision_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_framework(::Google::Cloud::CloudSecurityCompliance::V1::UpdateFrameworkRequest.new(update_mask: update_mask, framework: framework, major_revision_id: major_revision_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_framework_client_stub.call_rpc_count
    end
  end

  def test_delete_framework
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_framework_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_framework, name
      assert_kind_of ::Google::Cloud::CloudSecurityCompliance::V1::DeleteFrameworkRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_framework_client_stub do
      # Create client
      client = ::Google::Cloud::CloudSecurityCompliance::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_framework({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_framework name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_framework ::Google::Cloud::CloudSecurityCompliance::V1::DeleteFrameworkRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_framework({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_framework(::Google::Cloud::CloudSecurityCompliance::V1::DeleteFrameworkRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_framework_client_stub.call_rpc_count
    end
  end

  def test_list_cloud_controls
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CloudSecurityCompliance::V1::ListCloudControlsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_cloud_controls_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_cloud_controls, name
      assert_kind_of ::Google::Cloud::CloudSecurityCompliance::V1::ListCloudControlsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_cloud_controls_client_stub do
      # Create client
      client = ::Google::Cloud::CloudSecurityCompliance::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_cloud_controls({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_cloud_controls parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_cloud_controls ::Google::Cloud::CloudSecurityCompliance::V1::ListCloudControlsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_cloud_controls({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_cloud_controls(::Google::Cloud::CloudSecurityCompliance::V1::ListCloudControlsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_cloud_controls_client_stub.call_rpc_count
    end
  end

  def test_get_cloud_control
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CloudSecurityCompliance::V1::CloudControl.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    major_revision_id = 42

    get_cloud_control_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_cloud_control, name
      assert_kind_of ::Google::Cloud::CloudSecurityCompliance::V1::GetCloudControlRequest, request
      assert_equal "hello world", request["name"]
      assert_equal 42, request["major_revision_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_cloud_control_client_stub do
      # Create client
      client = ::Google::Cloud::CloudSecurityCompliance::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_cloud_control({ name: name, major_revision_id: major_revision_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_cloud_control name: name, major_revision_id: major_revision_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_cloud_control ::Google::Cloud::CloudSecurityCompliance::V1::GetCloudControlRequest.new(name: name, major_revision_id: major_revision_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_cloud_control({ name: name, major_revision_id: major_revision_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_cloud_control(::Google::Cloud::CloudSecurityCompliance::V1::GetCloudControlRequest.new(name: name, major_revision_id: major_revision_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_cloud_control_client_stub.call_rpc_count
    end
  end

  def test_create_cloud_control
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CloudSecurityCompliance::V1::CloudControl.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    cloud_control_id = "hello world"
    cloud_control = {}

    create_cloud_control_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_cloud_control, name
      assert_kind_of ::Google::Cloud::CloudSecurityCompliance::V1::CreateCloudControlRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["cloud_control_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::CloudSecurityCompliance::V1::CloudControl), request["cloud_control"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_cloud_control_client_stub do
      # Create client
      client = ::Google::Cloud::CloudSecurityCompliance::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_cloud_control({ parent: parent, cloud_control_id: cloud_control_id, cloud_control: cloud_control }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_cloud_control parent: parent, cloud_control_id: cloud_control_id, cloud_control: cloud_control do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_cloud_control ::Google::Cloud::CloudSecurityCompliance::V1::CreateCloudControlRequest.new(parent: parent, cloud_control_id: cloud_control_id, cloud_control: cloud_control) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_cloud_control({ parent: parent, cloud_control_id: cloud_control_id, cloud_control: cloud_control }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_cloud_control(::Google::Cloud::CloudSecurityCompliance::V1::CreateCloudControlRequest.new(parent: parent, cloud_control_id: cloud_control_id, cloud_control: cloud_control), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_cloud_control_client_stub.call_rpc_count
    end
  end

  def test_update_cloud_control
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CloudSecurityCompliance::V1::CloudControl.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    cloud_control = {}

    update_cloud_control_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_cloud_control, name
      assert_kind_of ::Google::Cloud::CloudSecurityCompliance::V1::UpdateCloudControlRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::CloudSecurityCompliance::V1::CloudControl), request["cloud_control"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_cloud_control_client_stub do
      # Create client
      client = ::Google::Cloud::CloudSecurityCompliance::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_cloud_control({ update_mask: update_mask, cloud_control: cloud_control }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_cloud_control update_mask: update_mask, cloud_control: cloud_control do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_cloud_control ::Google::Cloud::CloudSecurityCompliance::V1::UpdateCloudControlRequest.new(update_mask: update_mask, cloud_control: cloud_control) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_cloud_control({ update_mask: update_mask, cloud_control: cloud_control }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_cloud_control(::Google::Cloud::CloudSecurityCompliance::V1::UpdateCloudControlRequest.new(update_mask: update_mask, cloud_control: cloud_control), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_cloud_control_client_stub.call_rpc_count
    end
  end

  def test_delete_cloud_control
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_cloud_control_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_cloud_control, name
      assert_kind_of ::Google::Cloud::CloudSecurityCompliance::V1::DeleteCloudControlRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_cloud_control_client_stub do
      # Create client
      client = ::Google::Cloud::CloudSecurityCompliance::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_cloud_control({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_cloud_control name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_cloud_control ::Google::Cloud::CloudSecurityCompliance::V1::DeleteCloudControlRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_cloud_control({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_cloud_control(::Google::Cloud::CloudSecurityCompliance::V1::DeleteCloudControlRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_cloud_control_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::CloudSecurityCompliance::V1::Config::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::CloudSecurityCompliance::V1::Config::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::CloudSecurityCompliance::V1::Config::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::CloudSecurityCompliance::V1::Config::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
