# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module CloudSecurityCompliance
      module V1
        # The request message for
        # {::Google::Cloud::CloudSecurityCompliance::V1::ListFrameworkComplianceSummariesRequest ListFrameworkComplianceSummariesRequest}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent scope for the framework compliance summary.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The requested page size. The server might return fewer items than
        #     requested. If unspecified, the server picks an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token that identifies the page of results that the server
        #     should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. The filtering results.
        class ListFrameworkComplianceSummariesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response message for
        # {::Google::Cloud::CloudSecurityCompliance::V1::ListFrameworkComplianceSummariesResponse ListFrameworkComplianceSummariesResponse}.
        # @!attribute [rw] framework_compliance_summaries
        #   @return [::Array<::Google::Cloud::CloudSecurityCompliance::V1::FrameworkComplianceSummary>]
        #     The list of framework compliance summaries.
        # @!attribute [r] next_page_token
        #   @return [::String]
        #     Output only. The token to retrieve the next page of results.
        class ListFrameworkComplianceSummariesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response message for [GetFrameworkComplianceReport][].
        # @!attribute [rw] framework
        #   @return [::String]
        #     The name of the framework.
        # @!attribute [rw] framework_description
        #   @return [::String]
        #     The description of the framework.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The last updated time of the report.
        # @!attribute [rw] control_assessment_details
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::ControlAssessmentDetails]
        #     The control assessment details of the framework.
        # @!attribute [rw] framework_type
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::Framework::FrameworkType]
        #     The type of framework.
        # @!attribute [rw] supported_cloud_providers
        #   @return [::Array<::Google::Cloud::CloudSecurityCompliance::V1::CloudProvider>]
        #     The list of cloud providers supported by the framework.
        # @!attribute [rw] framework_categories
        #   @return [::Array<::Google::Cloud::CloudSecurityCompliance::V1::FrameworkCategory>]
        #     The list of framework categories supported.
        # @!attribute [rw] framework_display_name
        #   @return [::String]
        #     Optional. The display name for the framework.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the framework compliance report.
        # @!attribute [rw] major_revision_id
        #   @return [::Integer]
        #     The latest major revision ID of the framework.
        # @!attribute [rw] minor_revision_id
        #   @return [::Integer]
        #     The latest minor revision ID of the latest major revision of the framework.
        # @!attribute [rw] target_resource_details
        #   @return [::Array<::Google::Cloud::CloudSecurityCompliance::V1::TargetResourceDetails>]
        #     The target resource details of the framework.
        class FrameworkComplianceReport
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for [FetchFrameworkComplianceReport][].
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the framework compliance report to retrieve.
        # @!attribute [rw] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. The end time of the report.
        class FetchFrameworkComplianceReportRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for [ListFindingSummaries][].
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent scope for the framework overview page.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The requested page size. The server might return fewer items than
        #      requested. If unspecified, the server picks an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token that identifies the page of results that the server
        #     should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. The filtering results.
        # @!attribute [rw] end_time
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. The end time of the finding summary.
        class ListFindingSummariesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response message for [ListFindingSummaries][].
        # @!attribute [rw] finding_summaries
        #   @return [::Array<::Google::Cloud::CloudSecurityCompliance::V1::FindingSummary>]
        #     List of finding summary by category.
        # @!attribute [r] next_page_token
        #   @return [::String]
        #     Output only. The token to retrieve the next page of results.
        class ListFindingSummariesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for [ListControlComplianceSummaries][].
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent scope for the framework overview page.
        # @!attribute [rw] end_time
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. The end time of the control compliance summary.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The requested page size. The server might return fewer items than
        #     requested. If unspecified, the server picks an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token that identifies the page of results that the server
        #     should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. The filtering results.
        class ListControlComplianceSummariesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response message for [ListControlComplianceSummaries][].
        # @!attribute [rw] control_compliance_summaries
        #   @return [::Array<::Google::Cloud::CloudSecurityCompliance::V1::ControlComplianceSummary>]
        #     The list of control compliance details.
        # @!attribute [r] next_page_token
        #   @return [::String]
        #     Output only. The token to retrieve the next page of results.
        class ListControlComplianceSummariesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for [AggregateFrameworkComplianceReport][].
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the aggregated compliance report over time to
        #     retrieve.
        #
        #     The supported format is:
        #     `organizations/{organization_id}/locations/{location}/frameworkComplianceReports/{framework_compliance_report}`
        # @!attribute [rw] interval
        #   @return [::Google::Type::Interval]
        #     Optional. The start and end time range for the aggregated compliance
        #     report.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. The filtering results.
        class AggregateFrameworkComplianceReportRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response message for [AggregateFrameworkComplianceReport][].
        # @!attribute [rw] aggregated_compliance_reports
        #   @return [::Array<::Google::Cloud::CloudSecurityCompliance::V1::AggregatedComplianceReport>]
        #     The list of aggregated compliance reports.
        class AggregateFrameworkComplianceReportResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The details for a control assessment.
        # @!attribute [rw] passing_controls
        #   @return [::Integer]
        #     The number of controls that are passing or not assessed.
        # @!attribute [rw] failing_controls
        #   @return [::Integer]
        #     The number of controls that are failing.
        # @!attribute [rw] assessed_passing_controls
        #   @return [::Integer]
        #     The number of controls that were assessed and are passing.
        # @!attribute [rw] not_assessed_controls
        #   @return [::Integer]
        #     The number of controls that aren't assessed because they require manual
        #     review.
        class ControlAssessmentDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The details for a framework compliance summary.
        # @!attribute [rw] framework
        #   @return [::String]
        #     The name of the framework.
        # @!attribute [rw] control_assessment_details
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::ControlAssessmentDetails]
        #     The control assessment details of the framework.
        # @!attribute [rw] framework_type
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::Framework::FrameworkType]
        #     The type of framework.
        # @!attribute [rw] supported_cloud_providers
        #   @return [::Array<::Google::Cloud::CloudSecurityCompliance::V1::CloudProvider>]
        #     The list of cloud providers supported by the framework.
        # @!attribute [rw] framework_categories
        #   @return [::Array<::Google::Cloud::CloudSecurityCompliance::V1::FrameworkCategory>]
        #     The list of framework categories supported by the framework.
        # @!attribute [rw] framework_display_name
        #   @return [::String]
        #     Optional. The display name for the framework.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the framework compliance summary.
        # @!attribute [rw] major_revision_id
        #   @return [::Integer]
        #     The major revision ID of the framework.
        # @!attribute [rw] minor_revision_id
        #   @return [::Integer]
        #     The minor revision ID of the framework.
        # @!attribute [rw] target_resource_details
        #   @return [::Array<::Google::Cloud::CloudSecurityCompliance::V1::TargetResourceDetails>]
        #     The target resource details for the framework.
        class FrameworkComplianceSummary
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The details for a finding.
        # @!attribute [rw] finding_category
        #   @return [::String]
        #     The category of the finding.
        # @!attribute [rw] finding_class
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::FindingClass]
        #     The class of the finding.
        # @!attribute [rw] severity
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::Severity]
        #     The severity of the finding.
        # @!attribute [rw] finding_count
        #   @return [::Integer]
        #     The count of the finding.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The last updated time of the finding.
        # @!attribute [rw] related_frameworks
        #   @return [::Array<::String>]
        #     Optional. The list of compliance frameworks that the finding belongs to.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the finding summary.
        class FindingSummary
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The details for control compliance.
        # @!attribute [rw] control
        #   @return [::String]
        #     The name of the control.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     The display name of the control.
        # @!attribute [rw] description
        #   @return [::String]
        #     The description of the control.
        # @!attribute [r] overall_evaluation_state
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::EvaluationState]
        #     Output only. The overall evaluation status of the control.
        # @!attribute [rw] total_findings_count
        #   @return [::Integer]
        #     The total number of findings for the control.
        # @!attribute [rw] compliance_frameworks
        #   @return [::Array<::String>]
        #     The list of compliance frameworks that the control belongs to.
        # @!attribute [rw] similar_controls
        #   @return [::Array<::Google::Cloud::CloudSecurityCompliance::V1::SimilarControls>]
        #     The list of similar controls.
        # @!attribute [rw] cloud_control_reports
        #   @return [::Array<::Google::Cloud::CloudSecurityCompliance::V1::CloudControlReport>]
        #     The list of cloud control reports.
        # @!attribute [rw] control_responsibility_type
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::RegulatoryControlResponsibilityType]
        #     The responsibility type for the control.
        # @!attribute [rw] is_fake_control
        #   @return [::Boolean]
        #     Whether the control is a fake control. Fake controls are created
        #     and mapped to cloud controls that don't belong to a control group.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the control compliance summary.
        class ControlComplianceSummary
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The cloud control report.
        # @!attribute [rw] manual_cloud_control_assessment_details
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::ManualCloudControlAssessmentDetails]
        #     The details of a manual cloud control assessment.
        #
        #     Note: The following fields are mutually exclusive: `manual_cloud_control_assessment_details`, `cloud_control_assessment_details`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] cloud_control_assessment_details
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::CloudControlAssessmentDetails]
        #     The details of a cloud control assessment.
        #
        #     Note: The following fields are mutually exclusive: `cloud_control_assessment_details`, `manual_cloud_control_assessment_details`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] cloud_control
        #   @return [::String]
        #     The name of the cloud control.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     The display name of the cloud control.
        # @!attribute [rw] description
        #   @return [::String]
        #     The description of the cloud control.
        # @!attribute [rw] categories
        #   @return [::Array<::String>]
        #     The list of categories for the cloud control.
        # @!attribute [rw] similar_controls
        #   @return [::Array<::Google::Cloud::CloudSecurityCompliance::V1::SimilarControls>]
        #     The list of similar controls.
        # @!attribute [rw] cloud_control_type
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::CloudControl::Type]
        #     The type of the cloud control.
        # @!attribute [rw] finding_category
        #   @return [::String]
        #     The category of the finding.
        # @!attribute [rw] rules
        #   @return [::Array<::Google::Cloud::CloudSecurityCompliance::V1::Rule>]
        #     The list of rules that correspond to the cloud control.
        # @!attribute [rw] finding_severity
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::Severity]
        #     The severity of the finding.
        # @!attribute [rw] enforcement_mode
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::EnforcementMode]
        #     The enforcement mode of the cloud control.
        # @!attribute [rw] cloud_control_deployment
        #   @return [::String]
        #     The name of the cloud control deployment.
        # @!attribute [rw] major_revision_id
        #   @return [::Integer]
        #     The major revision ID of the cloud control.
        # @!attribute [rw] minor_revision_id
        #   @return [::Integer]
        #     The minor revision ID of the cloud control.
        # @!attribute [rw] framework_major_revision_ids
        #   @return [::Array<::Integer>]
        #     The major revision IDs of the frameworks that the cloud control belongs to.
        class CloudControlReport
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The details for a manual cloud control assessment.
        # @!attribute [rw] manual_cloud_control_guide
        #   @return [::Array<::String>]
        #     The guide for assessing a cloud control manually.
        class ManualCloudControlAssessmentDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The cloud control assessment details for non-manual cloud controls.
        # @!attribute [rw] findings_count
        #   @return [::Integer]
        #     The number of findings for the cloud control.
        # @!attribute [r] evaluation_state
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::EvaluationState]
        #     Output only. The evaluation status of the cloud control.
        class CloudControlAssessmentDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The similar controls.
        # @!attribute [rw] framework
        #   @return [::String]
        #     The name of the framework.
        # @!attribute [rw] control_id
        #   @return [::String]
        #     The ID of the control.
        class SimilarControls
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The aggregated compliance report.
        # @!attribute [rw] control_assessment_details
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::ControlAssessmentDetails]
        #     The control assessment details of the framework.
        # @!attribute [rw] report_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The report time of the aggregated compliance report.
        class AggregatedComplianceReport
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The details for a target resource.
        # @!attribute [rw] framework_deployment
        #   @return [::String]
        #     The framework deployment name for the target resource.
        #
        #     For example,
        #     `organizations/{organization_id}/locations/{location}/frameworkDeployments/{framework_deployment_id}`
        # @!attribute [rw] target_resource_display_name
        #   @return [::String]
        #     The display name of the target resource. For example, `google.com`,
        #     `staging-project`, or `development-folder`.
        # @!attribute [rw] target_resource
        #   @return [::String]
        #     The target resource. For example, `organizations/1234567890`,
        #     `projects/1234567890`, or `folders/1234567890`.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The create time of the target resource.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The update time of the target resource.
        # @!attribute [rw] major_revision_id
        #   @return [::Integer]
        #     The major revision ID of the framework for the target resource.
        # @!attribute [rw] minor_revision_id
        #   @return [::Integer]
        #     The minor revision ID of the framework for the target resource.
        class TargetResourceDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The evaluation state of the control.
        module EvaluationState
          # Default value. This value is unused.
          EVALUATION_STATE_UNSPECIFIED = 0

          # The control is passing.
          EVALUATION_STATE_PASSED = 1

          # The control is failing.
          EVALUATION_STATE_FAILED = 2

          # The control is not assessed.
          EVALUATION_STATE_NOT_ASSESSED = 3
        end

        # A finding is a record of assessment data like security, risk, health, or
        # privacy.
        module FindingClass
          # Default value. This value is unused.
          FINDING_CLASS_UNSPECIFIED = 0

          # The activity is unwanted or malicious.
          THREAT = 1

          # A potential weakness in software that increases risk to
          # confidentiality, integrity, and availability.
          VULNERABILITY = 2

          # A potential weakness in a cloud resource or asset configuration that
          # increases risk.
          MISCONFIGURATION = 3

          # A security observation that is for informational purposes.
          OBSERVATION = 4

          # An error that prevents Security Command Center from functioning properly.
          SCC_ERROR = 5

          # A potential security risk that's due to a change in the security
          # posture.
          POSTURE_VIOLATION = 6

          # A combination of security issues that represent a more severe
          # security problem when taken together.
          TOXIC_COMBINATION = 7

          # A potential security risk to data assets that contain sensitive
          # data.
          SENSITIVE_DATA_RISK = 8

          # A resource or resource group where high risk attack paths
          # converge, based on attack path simulations (APS).
          CHOKEPOINT = 9
        end
      end
    end
  end
end
