# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module CloudSecurityCompliance
      module V1
        # Framework deployments represent the assignment of a framework to a target
        # resource. Supported target resources are organizations, folders, and
        # projects.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the framework deployment, in the format
        #     `organizations/{organization}/locations/{location}/frameworkDeployments/{framework_deployment_id}`.
        #     The only supported location is `global`.
        # @!attribute [rw] target_resource_config
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::TargetResourceConfig]
        #     Required. The details of the target resource that you want to deploy the
        #     framework to. You can specify an existing resource, or create a new one.
        # @!attribute [r] computed_target_resource
        #   @return [::String]
        #     Output only. The target resource to deploy the framework to, in one  the
        #     following formats:
        #
        #     - `organizations/{organizationID}`
        #     - `folders/{folderID}`
        #     - `projects/{projectID}`
        # @!attribute [rw] framework
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::FrameworkReference]
        #     Required. A reference to the framework that you're deploying.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. A user-provided description of the framework deployment.
        # @!attribute [rw] cloud_control_metadata
        #   @return [::Array<::Google::Cloud::CloudSecurityCompliance::V1::CloudControlMetadata>]
        #     Required. The deployment mode and parameters for each of the cloud controls
        #     in the framework. Every cloud control in the framework includes metadata.
        # @!attribute [r] deployment_state
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::DeploymentState]
        #     Output only. The state for the framework deployment.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which the resource was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which the resource last updated.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. To prevent concurrent updates from overwriting each other, always
        #     provide the `etag` when you update a framework deployment. You can also
        #     provide the `etag` when you delete a framework deployment, to help
        #     ensure that you're deleting the intended version of the
        #     framework deployment.
        # @!attribute [r] target_resource_display_name
        #   @return [::String]
        #     Output only. The display name of the target resource.
        # @!attribute [r] cloud_control_deployment_references
        #   @return [::Array<::Google::Cloud::CloudSecurityCompliance::V1::CloudControlDeploymentReference>]
        #     Output only. The references to the cloud control deployments. The reference
        #     includes all the cloud control deployments that are in the framework or in
        #     a cloud control group.
        #
        #     For example, if a framework deployment deploys two
        #     cloud controls, `cc-deployment-1` and `cc-deployment-2`, then the
        #     references are:
        #
        #     ```
        #     {
        #      cloud_control_deployment_reference: {
        #        cloud_control_deployment:
        #        "organizations/\\{organization}/locations/\\{location}/cloudControlDeployments/cc-deployment-1"
        #      },
        #      cloud_control_deployment_reference: {
        #       cloud_control_deployment:
        #       "organizations/\\{organization}/locations/\\{location}/cloudControlDeployments/cc-deployment-2"
        #      }
        #     ```
        class FrameworkDeployment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A cloud control deployment represents the deployment of a particular cloud
        # control on a target resource. Supported target resources are
        # `organizations/{organizationID}`, `folders/{folderID}`, and
        # `projects/{projectID}`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name for the cloud control deployment, in the format
        #     `organizations/{organization}/locations/{location}/cloudControlDeployments/{cloud_control_deployment_id}`.
        #     The only supported location is `global`.
        # @!attribute [rw] target_resource_config
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::TargetResourceConfig]
        #     Required. The details of the target resource that the cloud control is
        #     deployed You can use an existing target resource or create a new target.
        # @!attribute [r] target_resource
        #   @return [::String]
        #     Output only. The resource that the cloud control is deployed on, in one of
        #     the following formats:
        #
        #     - `organizations/{organizationID}`
        #     - `folders/{folderID}`
        #     - `projects/{projectID}`
        # @!attribute [rw] cloud_control_metadata
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::CloudControlMetadata]
        #     Required. The deployment mode and parameters for the cloud control.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. A friendly description for the cloud control deployment.
        # @!attribute [r] deployment_state
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::DeploymentState]
        #     Output only. The state of the cloud control deployment.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the resource was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the resource was last updated.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. To prevent concurrent updates from overwriting each other,
        #     provide the `etag` when you update a cloud control deployment. You can also
        #     provide the `etag` when you delete a cloud control deployment to help
        #     ensure that you're deleting the intended version of the
        #     deployment.
        # @!attribute [r] parameter_substituted_cloud_control
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::CloudControl]
        #     Output only. The cloud control after the given parameters are substituted.
        # @!attribute [r] framework_deployment_references
        #   @return [::Array<::Google::Cloud::CloudSecurityCompliance::V1::FrameworkDeploymentReference>]
        #     Output only. The references to the framework deployments that this cloud
        #     control deployment is part of. A cloud control deployment can be part of
        #     multiple framework deployments.
        # @!attribute [r] target_resource_display_name
        #   @return [::String]
        #     Output only. The display name of the target resource.
        class CloudControlDeployment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The name of the target resource or the configuration that's required to
        # create a new target resource.
        # @!attribute [rw] existing_target_resource
        #   @return [::String]
        #     Optional. The resource hierarchy node, in one of the following formats:
        #
        #     - `organizations/{organizationID}`
        #     - `folders/{folderID}`
        #     - `projects/{projectID}`
        #
        #     Note: The following fields are mutually exclusive: `existing_target_resource`, `target_resource_creation_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] target_resource_creation_config
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::TargetResourceCreationConfig]
        #     Optional. The details that are required to create a resource and use
        #     that resource as the target resource for deployment.
        #
        #     Note: The following fields are mutually exclusive: `target_resource_creation_config`, `existing_target_resource`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class TargetResourceConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The configuration that's required to create a target resource.
        # @!attribute [rw] folder_creation_config
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::FolderCreationConfig]
        #     Optional. The configuration that's required to create a folder.
        #
        #     Note: The following fields are mutually exclusive: `folder_creation_config`, `project_creation_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] project_creation_config
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::ProjectCreationConfig]
        #     Optional. The configuration that's required to create a project.
        #
        #     Note: The following fields are mutually exclusive: `project_creation_config`, `folder_creation_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class TargetResourceCreationConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The configuration that's required to create a folder to be used
        # as the target resource for a deployment.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent of the folder, in the format
        #     `organizations/{organizationID}` or `folders/{folderID}`.
        # @!attribute [rw] folder_display_name
        #   @return [::String]
        #     Required. The display name of the folder.
        class FolderCreationConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The configuration that's required to create a project to be used
        # as the target resource of a deployment.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent of the project, in the format
        #     `organizations/{organizationID}` or `folders/{folderID}`.
        # @!attribute [rw] project_display_name
        #   @return [::String]
        #     Required. The display name of the project.
        # @!attribute [rw] billing_account_id
        #   @return [::String]
        #     Required. The billing account ID for the project.
        class ProjectCreationConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The enforcement mode and parameters of a cloud
        # control deployment.
        # @!attribute [rw] cloud_control_details
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::CloudControlDetails]
        #     Required. The cloud control name and parameters.
        # @!attribute [rw] enforcement_mode
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::EnforcementMode]
        #     Required. The enforcement mode of the cloud control.
        class CloudControlMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for [CreateFrameworkDeployment][].
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of the framework deployment in the format
        #     `organizations/{organization}/locations/{location}`.
        #     Only the global location is supported.
        # @!attribute [rw] framework_deployment_id
        #   @return [::String]
        #     Optional. An identifier for the framework deployment that's unique in scope
        #     of the parent. If you don't specify a value, then a random UUID is
        #     generated.
        # @!attribute [rw] framework_deployment
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::FrameworkDeployment]
        #     Required. The framework deployment that you're creating.
        class CreateFrameworkDeploymentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for [DeleteFrameworkDeployment][].
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the framework deployment that you want to delete,
        #     in the format
        #     `organizations/{organization}/locations/{location}/frameworkDeployments/{framework_deployment_id}`.
        #     The only supported location is `global`.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. An opaque identifier for the current version of the resource.
        #
        #     If you provide this value, then it must match the existing value. If the
        #     values don't match, then the request fails with an
        #     [`ABORTED`][google.rpc.Code.ABORTED] error.
        #
        #     If you omit this value, then the resource is deleted regardless of its
        #     current `etag` value.
        class DeleteFrameworkDeploymentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for [GetFrameworkDeployment][].
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the framework deployment, in the format
        #     `organizations/{organization}/locations/{location}/frameworkDeployments/{framework_deployment_id}`.
        #     The only supported location is `global`.
        class GetFrameworkDeploymentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for [ListFrameworkDeployments][].
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of the framework deployment, in the format
        #     `organizations/{organization}/locations/{location}`.
        #     The only supported location is `global`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The requested page size. The server might return fewer items than
        #     requested.
        #     If unspecified, the server picks an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token that identifies a page of results the server should
        #     return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. The filter to be applied on the resource, as defined by
        #     [AIP-160: Filtering](https://google.aip.dev/160).
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. The sort order for the results. The following values are
        #     supported:
        #
        #     * `name`
        #     * `name desc`
        #
        #     If you do not specify a value, then the results are not sorted.
        class ListFrameworkDeploymentsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response message for [ListFrameworkDeployments][].
        # @!attribute [rw] framework_deployments
        #   @return [::Array<::Google::Cloud::CloudSecurityCompliance::V1::FrameworkDeployment>]
        #     The list of framework deployments.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that identifies the next page of results that the server
        #     should return.
        class ListFrameworkDeploymentsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for [GetCloudControlDeployment][].
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name for the cloud control deployment, in the format
        #     `organizations/{organization}/locations/{location}/cloudControlDeployments/{cloud_control_deployment_id}`.
        #     The only supported location is `global`.
        class GetCloudControlDeploymentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for [ListCloudControlDeployments][].
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource for the cloud control deployment, in the
        #     format `organizations/{organization}/locations/{location}`. The only
        #     supported location is `global`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The requested page size. The server might return fewer items than
        #     you requested.
        #     If unspecified, the server picks an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token that identifies the page of results that the server
        #     should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. The filter to apply on the resource, as defined by
        #     [AIP-160: Filtering](https://google.aip.dev/160).
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. The sort order for the results. The following values are
        #     supported:
        #
        #     * `name`
        #     * `name desc`
        #
        #     If you do not specify a value, then the results are not sorted.
        class ListCloudControlDeploymentsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response message for [ListCloudControlDeployments][].
        # @!attribute [rw] cloud_control_deployments
        #   @return [::Array<::Google::Cloud::CloudSecurityCompliance::V1::CloudControlDeployment>]
        #     The list of cloud control deployments.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that identifies the next page of results that the server
        #     should return.
        class ListCloudControlDeploymentsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The reference to a cloud control deployment.
        # @!attribute [r] cloud_control_deployment
        #   @return [::String]
        #     Output only. The name of the CloudControlDeployment. The format is
        #     `organizations/{org}/locations/{location}/cloudControlDeployments/{cloud_control_deployment_id}`.
        #     The only supported location is `global`.
        class CloudControlDeploymentReference
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The reference to a framework deployment.
        # @!attribute [r] framework_deployment
        #   @return [::String]
        #     Output only. The name of the framework deployment, in the format
        #     `organizations/{org}/locations/{location}/frameworkDeployments/{framework_deployment_id}`.
        #     The only supported location is `global`.
        # @!attribute [rw] framework_reference
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::FrameworkReference]
        #     Optional. The reference to the framework that this deployment is for.
        #     For example:
        #
        #     ```
        #     {
        #       framework:
        #       "organizations/\\{org}/locations/\\{location}/frameworks/\\{framework}",
        #       major_revision_id: 1
        #     }
        #     ```
        #
        #     The only supported location is `global`.
        # @!attribute [rw] framework_display_name
        #   @return [::String]
        #     Optional. The display name of the framework that this framework deployment
        #     is for.
        class FrameworkDeploymentReference
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The state of the deployment resource.
        module DeploymentState
          # Default value. This value is unused.
          DEPLOYMENT_STATE_UNSPECIFIED = 0

          # Validating the deployment.
          DEPLOYMENT_STATE_VALIDATING = 1

          # Deployment is being created.
          DEPLOYMENT_STATE_CREATING = 2

          # Deployment is being deleted.
          DEPLOYMENT_STATE_DELETING = 3

          # Deployment has failed. All the changes made by the deployment were
          # successfully rolled back. You can retry or delete a deployment that's
          # in this state.
          DEPLOYMENT_STATE_FAILED = 4

          # Deployment is successful and ready to use.
          DEPLOYMENT_STATE_READY = 5

          # Deployment is partially deployed. All the cloud controls weren't deployed
          # successfully. Retrying the operation resumes from the first failed
          # step.
          DEPLOYMENT_STATE_PARTIALLY_DEPLOYED = 6

          # Deployment is partially deleted. All the cloud control deployments weren't
          # deleted successfully. Retrying the operation resumes from the first
          # failed step.
          DEPLOYMENT_STATE_PARTIALLY_DELETED = 7
        end
      end
    end
  end
end
