# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module CloudSecurityCompliance
      module V1
        # The request message for [UpdateCmEnrollment][].
        # @!attribute [rw] cm_enrollment
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::CmEnrollment]
        #     Required. The Compliance Manager enrollment to update.
        #     The `name` field is used to identify the settings that you want to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. The list of fields that you want to update.
        class UpdateCmEnrollmentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for [CalculateEffectiveCmEnrollment][].
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Compliance Manager enrollment to calculate.
        #
        #     Supported formats are the following:
        #
        #     * `organizations/{organization_id}/locations/{location}/cmEnrollment`
        #     * `folders/{folder_id}/locations/{location}/cmEnrollment`
        #     * `projects/{project_id}/locations/{location}/cmEnrollment`
        class CalculateEffectiveCmEnrollmentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The settings for Compliance Manager at a specific resource scope.=
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the Compliance Manager enrollment.
        #
        #     Supported formats are the following:
        #
        #     * `organizations/{organization_id}/locations/{location}/cmEnrollment`
        #     * `folders/{folder_id}/locations/{location}/cmEnrollment`
        #     * `projects/{project_id}/locations/{location}/cmEnrollment`
        # @!attribute [rw] enrolled
        #   @return [::Boolean]
        #     Optional. Whether the resource is enrolled in Compliance Manager.
        #     This setting is inherited by all descendants.
        # @!attribute [rw] audit_config
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::AuditConfig]
        #     Optional. The audit configuration for Compliance Manager.
        #     If set at a scope, this configuration overrides any inherited audit
        #     configuration.
        class CmEnrollment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response message for [CalculateEffectiveCmEnrollment][].
        # @!attribute [rw] cm_enrollment
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::CmEnrollment]
        #     The effective Compliance Manager enrollment for the resource.
        class CalculateEffectiveCmEnrollmentResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The audit configuration for Compliance Manager.
        # @!attribute [rw] destinations
        #   @return [::Array<::Google::Cloud::CloudSecurityCompliance::V1::AuditConfig::CmEligibleDestination>]
        #     Required. The list of destinations that can be selected for uploading audit
        #     reports to.
        class AuditConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The destination details where audit reports are
          # uploaded.
          # @!attribute [rw] gcs_bucket
          #   @return [::String]
          #     The Cloud Storage bucket where audit reports and evidences can be
          #     uploaded. The format is `gs://{bucket_name}`.
          class CmEligibleDestination
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
