# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module CloudSecurityCompliance
      module V1
        # The request message for [GenerateFrameworkAuditScopeReport][].
        # @!attribute [rw] scope
        #   @return [::String]
        #     Required. The organization, folder or project for the audit report.
        #
        #     Supported formats are the following:
        #
        #     * `projects/{project_id}/locations/{location}`
        #     * `folders/{folder_id}/locations/{location}`
        #     * `organizations/{organization_id}/locations/{location}`
        # @!attribute [rw] report_format
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::GenerateFrameworkAuditScopeReportRequest::Format]
        #     Required. The format that the scope report bytes is returned in.
        # @!attribute [rw] compliance_framework
        #   @return [::String]
        #     Required. The compliance framework that the scope report is generated for.
        class GenerateFrameworkAuditScopeReportRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The set of options for the audit scope report format.
          module Format
            # Default value. This value is unused.
            FORMAT_UNSPECIFIED = 0

            # The report format is the Open Document Format (ODF).
            ODF = 1
          end
        end

        # The response message for [GenerateFrameworkAuditScopeReport][].
        # @!attribute [rw] scope_report_contents
        #   @return [::String]
        #     The audit scope report content in byte format.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the audit report, in the format that was
        #     given in the request.
        # @!attribute [rw] compliance_framework
        #   @return [::String]
        #     Required. The compliance framework that the audit scope report is generated
        #     for.
        class GenerateFrameworkAuditScopeReportResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Additional information for an audit operation.
        # @!attribute [r] total_count
        #   @return [::Integer]
        #     Output only. The total number of checks.
        # @!attribute [r] compliant_count
        #   @return [::Integer]
        #     Output only. The number of compliant checks.
        # @!attribute [r] violation_count
        #   @return [::Integer]
        #     Output only. The number of checks with violations.
        # @!attribute [r] manual_review_needed_count
        #   @return [::Integer]
        #     Output only. The number of checks with "manual review needed" status.
        # @!attribute [r] error_count
        #   @return [::Integer]
        #     Output only. The number of checks that can't be performed due to errors.
        class ReportSummary
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for [CreateFrameworkAudit][].
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where this framework audit is created.
        #
        #     Supported formats are the following:
        #
        #     * `organizations/{organization_id}/locations/{location}`
        #     * `folders/{folder_id}/locations/{location}`
        #     * `projects/{project_id}/locations/{location}`
        # @!attribute [rw] framework_audit_id
        #   @return [::String]
        #     Optional. The ID to use for the framework audit. The ID becomes the final
        #     component of the framework audit's full resource name.
        #
        #     The ID must be between 4-63 characters, and valid characters
        #     are `\[a-z][0-9]-\`.
        # @!attribute [rw] framework_audit
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::FrameworkAudit]
        #     Required. The framework audit to create.
        class CreateFrameworkAuditRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A destination for the framework audit.
        # @!attribute [rw] bucket
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::BucketDestination]
        #     The Cloud Storage bucket destination.
        class FrameworkAuditDestination
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A Cloud Storage bucket destination.
        # @!attribute [rw] bucket_uri
        #   @return [::String]
        #     Required. The URI of the Cloud Storage bucket.
        # @!attribute [rw] framework_audit_format
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::BucketDestination::Format]
        #     Optional. The format of the framework audit.
        class BucketDestination
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The set of options for the framework audit format.
          module Format
            # Default value. This value is unused.
            FORMAT_UNSPECIFIED = 0

            # The format for the framework audit report is Open Document.
            ODF = 1
          end
        end

        # A framework audit.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Identifier. The name of the framework audit.
        # @!attribute [r] framework_audit_id
        #   @return [::String]
        #     Output only. The ID of the framework audit.
        # @!attribute [r] compliance_framework
        #   @return [::String]
        #     Output only. The compliance framework used for the audit.
        # @!attribute [r] scope
        #   @return [::String]
        #     Output only. The scope of the audit.
        # @!attribute [rw] framework_audit_destination
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::FrameworkAuditDestination]
        #     Required. The destination for the audit reports.
        # @!attribute [r] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time that the audit started.
        # @!attribute [r] finish_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time that the audit finished.
        # @!attribute [r] compliance_state
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::ComplianceState]
        #     Output only. The overall compliance state of the audit.
        # @!attribute [r] report_summary
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::ReportSummary]
        #     Output only. The summary of the report.
        # @!attribute [rw] cloud_control_group_audit_details
        #   @return [::Array<::Google::Cloud::CloudSecurityCompliance::V1::CloudControlGroupAuditDetails>]
        #     Optional. The details for the cloud control groups within this audit.
        # @!attribute [rw] cloud_control_audit_details
        #   @return [::Array<::Google::Cloud::CloudSecurityCompliance::V1::CloudControlAuditDetails>]
        #     Optional. The details for the cloud controls within this audit.
        # @!attribute [r] operation_id
        #   @return [::String]
        #     Output only. The ID of the long-running operation.
        # @!attribute [r] state
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::FrameworkAudit::State]
        #     Output only. The framework audit state of the audit.
        class FrameworkAudit
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The state of the framework audit.
          module State
            # Default value. This value is unused.
            STATE_UNSPECIFIED = 0

            # The audit is scheduled.
            SCHEDULED = 1

            # The audit is running.
            RUNNING = 2

            # The audit results are being uploaded.
            UPLOADING = 3

            # The audit failed.
            FAILED = 4

            # The audit completed successfully.
            SUCCEEDED = 5
          end
        end

        # The request message for [ListFrameworkAudits][].
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where the framework audits are listed.
        #
        #     Supported formats are the following:
        #
        #     * `organizations/{organization_id}/locations/{location}`
        #     * `folders/{folder_id}/locations/{location}`
        #     * `projects/{project_id}/locations/{location}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of framework audits to return. The service
        #     might return fewer audits than this value. If unspecified, a maximum of 10
        #     framework audits are returned. The maximum value is 50; values above 50 are
        #     limited to 50.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The `next_page_token` value that's returned from a previous list
        #     request, if any.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. The filters to apply to the framework audits.
        #     Supported filters are `compliance_framework`, `compliance_state`,
        #     `create_time,` and `framework_audit_name`. If the filter is invalid, an
        #     invalid argument error is returned.
        #     For syntax details, see [AIP-160][https://google.aip.dev/160].
        class ListFrameworkAuditsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response message for [ListFrameworkAudits][].
        # @!attribute [rw] framework_audits
        #   @return [::Array<::Google::Cloud::CloudSecurityCompliance::V1::FrameworkAudit>]
        #     The framework audits.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which you can send as the `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListFrameworkAuditsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for [GetFrameworkAudit][].
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the framework audit to retrieve.
        #
        #     Supported formats are the following:
        #
        #     * `organizations/{organization_id}/locations/{location}/frameworkAudits/{frameworkAuditName}`
        #     * `folders/{folder_id}/locations/{location}/frameworkAudits/{frameworkAuditName}`
        #     * `projects/{project_id}/locations/{location}/frameworkAudits/{frameworkAuditName}`
        class GetFrameworkAuditRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The details for a cloud control group.
        # @!attribute [r] cloud_control_group_id
        #   @return [::String]
        #     Output only. The ID of the cloud control group.
        # @!attribute [r] display_name
        #   @return [::String]
        #     Output only. The display name of the cloud control group.
        # @!attribute [r] description
        #   @return [::String]
        #     Output only. The description of the cloud control group.
        # @!attribute [r] responsibility_type
        #   @return [::String]
        #     Output only. The responsibility type.
        # @!attribute [r] google_responsibility_description
        #   @return [::String]
        #     Output only. The description of Google's responsibility.
        # @!attribute [r] google_responsibility_implementation
        #   @return [::String]
        #     Output only. The implementation of Google's responsibility.
        # @!attribute [r] customer_responsibility_description
        #   @return [::String]
        #     Output only. The description of your responsibility.
        # @!attribute [r] customer_responsibility_implementation
        #   @return [::String]
        #     Output only. The implementation of your responsibility.
        # @!attribute [r] compliance_state
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::ComplianceState]
        #     Output only. The compliance state of the control group.
        # @!attribute [r] control_id
        #   @return [::String]
        #     Output only. The ID of the regulatory control.
        # @!attribute [r] control_family
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::ControlFamily]
        #     Output only. The control family.
        # @!attribute [r] cloud_control_details
        #   @return [::Array<::Google::Cloud::CloudSecurityCompliance::V1::CloudControlAuditDetails>]
        #     Output only. The details for the cloud controls within this group.
        # @!attribute [r] report_summary
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::ReportSummary]
        #     Output only. The summary of the report.
        class CloudControlGroupAuditDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The details for a finding.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The name of the finding.
        # @!attribute [r] compliance_state
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::ComplianceState]
        #     Output only. The compliance state of the finding.
        # @!attribute [r] observation
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::ObservationDetails]
        #     Output only. The observation details for the finding.
        # @!attribute [r] evidence
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::EvidenceDetails]
        #     Output only. The evidence details for the finding.
        class FindingDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The observation details for a finding.
        # @!attribute [r] current_value
        #   @return [::String]
        #     Output only. The current value.
        # @!attribute [rw] expected_value
        #   @return [::String]
        #     Optional. The expected value.
        # @!attribute [r] guidance
        #   @return [::String]
        #     Output only. Any guidance for the observation.
        class ObservationDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The evidence details for a finding.
        # @!attribute [r] resource
        #   @return [::String]
        #     Output only. The resource identifier.
        # @!attribute [r] service
        #   @return [::String]
        #     Output only. The service identifier.
        # @!attribute [r] evidence_path
        #   @return [::String]
        #     Output only. The path to the evidence.
        class EvidenceDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The details for a cloud control audit.
        # @!attribute [r] cloud_control
        #   @return [::String]
        #     Output only. The name of the cloud control.
        # @!attribute [r] cloud_control_id
        #   @return [::String]
        #     Output only. The ID of the cloud control.
        # @!attribute [r] cloud_control_description
        #   @return [::String]
        #     Output only. The description of the cloud control.
        # @!attribute [r] compliance_state
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::ComplianceState]
        #     Output only. The overall status of the findings for the control.
        # @!attribute [r] report_summary
        #   @return [::Google::Cloud::CloudSecurityCompliance::V1::ReportSummary]
        #     Output only. The summary of the report.
        # @!attribute [r] findings
        #   @return [::Array<::Google::Cloud::CloudSecurityCompliance::V1::FindingDetails>]
        #     Output only. The findings for the control.
        class CloudControlAuditDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The state of compliance after evaluation is complete.
        module ComplianceState
          # Default value. This value is unused.
          COMPLIANCE_STATE_UNSPECIFIED = 0

          # The resource is compliant.
          COMPLIANT = 1

          # The resource has a violation.
          VIOLATION = 2

          # The resource requires manual review from you.
          MANUAL_REVIEW_NEEDED = 3

          # An error occurred while computing the resource status.
          ERROR = 4

          # The resource can't be audited.
          AUDIT_NOT_SUPPORTED = 5
        end
      end
    end
  end
end
