# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/cloud/cloudsecuritycompliance/v1/config.proto for package 'Google.Cloud.CloudSecurityCompliance.V1'
# Original file comments:
# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/cloud/cloudsecuritycompliance/v1/config_pb'

module Google
  module Cloud
    module CloudSecurityCompliance
      module V1
        module Config
          # Config Service manages compliance frameworks, cloud controls, and their
          # configurations.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.cloud.cloudsecuritycompliance.v1.Config'

            # Lists the frameworks (both built-in and custom) that are available within
            # the parent resource. The latest major version of each framework is
            # returned.
            # This method supports pagination.
            rpc :ListFrameworks, ::Google::Cloud::CloudSecurityCompliance::V1::ListFrameworksRequest, ::Google::Cloud::CloudSecurityCompliance::V1::ListFrameworksResponse
            # Gets details about a framework.
            # This method retrieves the latest major version of the framework.
            #
            # To retrieve a specific major version, include `major_revision_id` in
            # the request.
            rpc :GetFramework, ::Google::Cloud::CloudSecurityCompliance::V1::GetFrameworkRequest, ::Google::Cloud::CloudSecurityCompliance::V1::Framework
            # Creates a custom framework in a given parent resource.
            # You can't create built-in frameworks because those are managed by
            # Google.
            rpc :CreateFramework, ::Google::Cloud::CloudSecurityCompliance::V1::CreateFrameworkRequest, ::Google::Cloud::CloudSecurityCompliance::V1::Framework
            # Updates a custom framework.
            # This method allows for partial updates of a framework. Use the
            # `update_mask` to specify which fields to update. Consider the following:
            #
            # - If you provide an `update_mask`, only the fields that are specified
            # in the mask are updated.
            # - If you don't provide an `update_mask`, all the fields that are present
            # in the request's `framework` body are used to overwrite the existing
            # resource.
            #
            # You can only update frameworks with the `CUSTOM` type.
            # A successful update creates a new version of the framework.
            rpc :UpdateFramework, ::Google::Cloud::CloudSecurityCompliance::V1::UpdateFrameworkRequest, ::Google::Cloud::CloudSecurityCompliance::V1::Framework
            # Deletes a custom framework, including all its major and
            # minor revisions. Consider the following:
            #
            # - You can't delete built-in frameworks. You can only delete frameworks
            #   with type `CUSTOM`.
            # - You can't delete frameworks that are deployed to a resource.
            # - You can't restore a deleted framework. This action is permanent.
            rpc :DeleteFramework, ::Google::Cloud::CloudSecurityCompliance::V1::DeleteFrameworkRequest, ::Google::Protobuf::Empty
            # Lists the cloud controls (both built-in and custom) that are available
            # in a given parent resource. The latest major version of each cloud control
            # is returned.
            # This method supports pagination.
            rpc :ListCloudControls, ::Google::Cloud::CloudSecurityCompliance::V1::ListCloudControlsRequest, ::Google::Cloud::CloudSecurityCompliance::V1::ListCloudControlsResponse
            # Gets details about a cloud control.
            # This method retrieves the latest major version of a cloud control that
            # you identify by name.
            #
            # By default, the latest major version of the cloud control is returned.
            # To retrieve a specific major version, include `major_revision_id` in
            # the request.
            rpc :GetCloudControl, ::Google::Cloud::CloudSecurityCompliance::V1::GetCloudControlRequest, ::Google::Cloud::CloudSecurityCompliance::V1::CloudControl
            # Creates a custom cloud control in a given parent
            # resource.
            # You can't create built-in cloud controls because those are managed by
            # Google.
            rpc :CreateCloudControl, ::Google::Cloud::CloudSecurityCompliance::V1::CreateCloudControlRequest, ::Google::Cloud::CloudSecurityCompliance::V1::CloudControl
            # Updates a custom cloud control.
            # This method allows for partial updates of a cloud control. Use the
            # `update_mask` to specify which fields to update. Consider the following:
            #
            # - If you provide an `update_mask`, only the fields that are specified
            # in the mask are updated.
            # - If you don't provide an `update_mask`, all the fields that are present
            # in the request's `cloud_control` body are used to overwrite the existing
            # resource.
            #
            # You can only update cloud controls with the `CUSTOM` type.
            # A successful update creates a new version of the cloud control.
            rpc :UpdateCloudControl, ::Google::Cloud::CloudSecurityCompliance::V1::UpdateCloudControlRequest, ::Google::Cloud::CloudSecurityCompliance::V1::CloudControl
            # Deletes a custom cloud control, including all its
            # major and minor revisions. Consider the following:
            #
            # - You can't delete built-in cloud controls. You can only delete cloud
            #   controls with type `CUSTOM`.
            # - You can't delete cloud controls if any of the versions are referenced
            #   by a framework.
            # - You can't restore a deleted cloud control. This action is permanent.
            rpc :DeleteCloudControl, ::Google::Cloud::CloudSecurityCompliance::V1::DeleteCloudControlRequest, ::Google::Protobuf::Empty
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
