# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/cloudsecuritycompliance/v1/deployment_pb"
require "google/cloud/cloud_security_compliance/v1/deployment/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Cloud
    module CloudSecurityCompliance
      module V1
        module Deployment
          module Rest
            ##
            # REST client for the Deployment service.
            #
            # Deployment service allows users to manage deployments of Frameworks and
            # Cloud Controls on a target resource.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "cloudsecuritycompliance.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :deployment_stub

              ##
              # Configure the Deployment Client class.
              #
              # See {::Google::Cloud::CloudSecurityCompliance::V1::Deployment::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all Deployment clients
              #   ::Google::Cloud::CloudSecurityCompliance::V1::Deployment::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "CloudSecurityCompliance", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.create_framework_deployment.timeout = 60.0

                  default_config.rpcs.delete_framework_deployment.timeout = 60.0

                  default_config.rpcs.get_framework_deployment.timeout = 60.0
                  default_config.rpcs.get_framework_deployment.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_framework_deployments.timeout = 60.0
                  default_config.rpcs.list_framework_deployments.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_cloud_control_deployment.timeout = 60.0
                  default_config.rpcs.get_cloud_control_deployment.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_cloud_control_deployments.timeout = 60.0
                  default_config.rpcs.list_cloud_control_deployments.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the Deployment Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::CloudSecurityCompliance::V1::Deployment::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @deployment_stub.universe_domain
              end

              ##
              # Create a new Deployment REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::CloudSecurityCompliance::V1::Deployment::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::CloudSecurityCompliance::V1::Deployment::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Deployment client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::CloudSecurityCompliance::V1::Deployment::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @deployment_stub = ::Google::Cloud::CloudSecurityCompliance::V1::Deployment::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @deployment_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @deployment_stub.endpoint
                  config.universe_domain = @deployment_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @deployment_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::CloudSecurityCompliance::V1::Deployment::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @deployment_stub.logger
              end

              # Service calls

              ##
              # Creates a framework deployment in a given parent resource. A
              # framework deployment lets you assign a particular framework version to an
              # organization, folder, or project so that you can control and monitor
              # those resources using the framework's cloud controls.
              #
              # @overload create_framework_deployment(request, options = nil)
              #   Pass arguments to `create_framework_deployment` via a request object, either of type
              #   {::Google::Cloud::CloudSecurityCompliance::V1::CreateFrameworkDeploymentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::CloudSecurityCompliance::V1::CreateFrameworkDeploymentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_framework_deployment(parent: nil, framework_deployment_id: nil, framework_deployment: nil)
              #   Pass arguments to `create_framework_deployment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource of the framework deployment in the format
              #     `organizations/{organization}/locations/{location}`.
              #     Only the global location is supported.
              #   @param framework_deployment_id [::String]
              #     Optional. An identifier for the framework deployment that's unique in scope
              #     of the parent. If you don't specify a value, then a random UUID is
              #     generated.
              #   @param framework_deployment [::Google::Cloud::CloudSecurityCompliance::V1::FrameworkDeployment, ::Hash]
              #     Required. The framework deployment that you're creating.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/cloud_security_compliance/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::CloudSecurityCompliance::V1::Deployment::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::CloudSecurityCompliance::V1::CreateFrameworkDeploymentRequest.new
              #
              #   # Call the create_framework_deployment method.
              #   result = client.create_framework_deployment request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_framework_deployment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudSecurityCompliance::V1::CreateFrameworkDeploymentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_framework_deployment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::CloudSecurityCompliance::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_framework_deployment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_framework_deployment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @deployment_stub.create_framework_deployment request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a framework deployment.
              #
              # @overload delete_framework_deployment(request, options = nil)
              #   Pass arguments to `delete_framework_deployment` via a request object, either of type
              #   {::Google::Cloud::CloudSecurityCompliance::V1::DeleteFrameworkDeploymentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::CloudSecurityCompliance::V1::DeleteFrameworkDeploymentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_framework_deployment(name: nil, etag: nil)
              #   Pass arguments to `delete_framework_deployment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the framework deployment that you want to delete,
              #     in the format
              #     `organizations/{organization}/locations/{location}/frameworkDeployments/{framework_deployment_id}`.
              #     The only supported location is `global`.
              #   @param etag [::String]
              #     Optional. An opaque identifier for the current version of the resource.
              #
              #     If you provide this value, then it must match the existing value. If the
              #     values don't match, then the request fails with an
              #     [`ABORTED`][google.rpc.Code.ABORTED] error.
              #
              #     If you omit this value, then the resource is deleted regardless of its
              #     current `etag` value.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/cloud_security_compliance/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::CloudSecurityCompliance::V1::Deployment::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::CloudSecurityCompliance::V1::DeleteFrameworkDeploymentRequest.new
              #
              #   # Call the delete_framework_deployment method.
              #   result = client.delete_framework_deployment request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_framework_deployment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudSecurityCompliance::V1::DeleteFrameworkDeploymentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_framework_deployment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::CloudSecurityCompliance::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_framework_deployment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_framework_deployment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @deployment_stub.delete_framework_deployment request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details about a framework deployment.
              #
              # @overload get_framework_deployment(request, options = nil)
              #   Pass arguments to `get_framework_deployment` via a request object, either of type
              #   {::Google::Cloud::CloudSecurityCompliance::V1::GetFrameworkDeploymentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::CloudSecurityCompliance::V1::GetFrameworkDeploymentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_framework_deployment(name: nil)
              #   Pass arguments to `get_framework_deployment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the framework deployment, in the format
              #     `organizations/{organization}/locations/{location}/frameworkDeployments/{framework_deployment_id}`.
              #     The only supported location is `global`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::CloudSecurityCompliance::V1::FrameworkDeployment]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::CloudSecurityCompliance::V1::FrameworkDeployment]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/cloud_security_compliance/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::CloudSecurityCompliance::V1::Deployment::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::CloudSecurityCompliance::V1::GetFrameworkDeploymentRequest.new
              #
              #   # Call the get_framework_deployment method.
              #   result = client.get_framework_deployment request
              #
              #   # The returned object is of type Google::Cloud::CloudSecurityCompliance::V1::FrameworkDeployment.
              #   p result
              #
              def get_framework_deployment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudSecurityCompliance::V1::GetFrameworkDeploymentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_framework_deployment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::CloudSecurityCompliance::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_framework_deployment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_framework_deployment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @deployment_stub.get_framework_deployment request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists the framework deployments in a given parent resource.
              #
              # @overload list_framework_deployments(request, options = nil)
              #   Pass arguments to `list_framework_deployments` via a request object, either of type
              #   {::Google::Cloud::CloudSecurityCompliance::V1::ListFrameworkDeploymentsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::CloudSecurityCompliance::V1::ListFrameworkDeploymentsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_framework_deployments(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_framework_deployments` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource of the framework deployment, in the format
              #     `organizations/{organization}/locations/{location}`.
              #     The only supported location is `global`.
              #   @param page_size [::Integer]
              #     Optional. The requested page size. The server might return fewer items than
              #     requested.
              #     If unspecified, the server picks an appropriate default.
              #   @param page_token [::String]
              #     Optional. A token that identifies a page of results the server should
              #     return.
              #   @param filter [::String]
              #     Optional. The filter to be applied on the resource, as defined by
              #     [AIP-160: Filtering](https://google.aip.dev/160).
              #   @param order_by [::String]
              #     Optional. The sort order for the results. The following values are
              #     supported:
              #
              #     * `name`
              #     * `name desc`
              #
              #     If you do not specify a value, then the results are not sorted.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::CloudSecurityCompliance::V1::FrameworkDeployment>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::CloudSecurityCompliance::V1::FrameworkDeployment>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/cloud_security_compliance/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::CloudSecurityCompliance::V1::Deployment::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::CloudSecurityCompliance::V1::ListFrameworkDeploymentsRequest.new
              #
              #   # Call the list_framework_deployments method.
              #   result = client.list_framework_deployments request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::CloudSecurityCompliance::V1::FrameworkDeployment.
              #     p item
              #   end
              #
              def list_framework_deployments request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudSecurityCompliance::V1::ListFrameworkDeploymentsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_framework_deployments.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::CloudSecurityCompliance::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_framework_deployments.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_framework_deployments.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @deployment_stub.list_framework_deployments request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @deployment_stub, :list_framework_deployments, "framework_deployments", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details about a cloud control deployment.
              #
              # @overload get_cloud_control_deployment(request, options = nil)
              #   Pass arguments to `get_cloud_control_deployment` via a request object, either of type
              #   {::Google::Cloud::CloudSecurityCompliance::V1::GetCloudControlDeploymentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::CloudSecurityCompliance::V1::GetCloudControlDeploymentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_cloud_control_deployment(name: nil)
              #   Pass arguments to `get_cloud_control_deployment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name for the cloud control deployment, in the format
              #     `organizations/{organization}/locations/{location}/cloudControlDeployments/{cloud_control_deployment_id}`.
              #     The only supported location is `global`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::CloudSecurityCompliance::V1::CloudControlDeployment]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::CloudSecurityCompliance::V1::CloudControlDeployment]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/cloud_security_compliance/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::CloudSecurityCompliance::V1::Deployment::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::CloudSecurityCompliance::V1::GetCloudControlDeploymentRequest.new
              #
              #   # Call the get_cloud_control_deployment method.
              #   result = client.get_cloud_control_deployment request
              #
              #   # The returned object is of type Google::Cloud::CloudSecurityCompliance::V1::CloudControlDeployment.
              #   p result
              #
              def get_cloud_control_deployment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudSecurityCompliance::V1::GetCloudControlDeploymentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_cloud_control_deployment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::CloudSecurityCompliance::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_cloud_control_deployment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_cloud_control_deployment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @deployment_stub.get_cloud_control_deployment request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists the cloud conrol deployments in a given parent resource.
              #
              # @overload list_cloud_control_deployments(request, options = nil)
              #   Pass arguments to `list_cloud_control_deployments` via a request object, either of type
              #   {::Google::Cloud::CloudSecurityCompliance::V1::ListCloudControlDeploymentsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::CloudSecurityCompliance::V1::ListCloudControlDeploymentsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_cloud_control_deployments(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_cloud_control_deployments` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource for the cloud control deployment, in the
              #     format `organizations/{organization}/locations/{location}`. The only
              #     supported location is `global`.
              #   @param page_size [::Integer]
              #     Optional. The requested page size. The server might return fewer items than
              #     you requested.
              #     If unspecified, the server picks an appropriate default.
              #   @param page_token [::String]
              #     Optional. A token that identifies the page of results that the server
              #     should return.
              #   @param filter [::String]
              #     Optional. The filter to apply on the resource, as defined by
              #     [AIP-160: Filtering](https://google.aip.dev/160).
              #   @param order_by [::String]
              #     Optional. The sort order for the results. The following values are
              #     supported:
              #
              #     * `name`
              #     * `name desc`
              #
              #     If you do not specify a value, then the results are not sorted.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::CloudSecurityCompliance::V1::CloudControlDeployment>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::CloudSecurityCompliance::V1::CloudControlDeployment>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/cloud_security_compliance/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::CloudSecurityCompliance::V1::Deployment::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::CloudSecurityCompliance::V1::ListCloudControlDeploymentsRequest.new
              #
              #   # Call the list_cloud_control_deployments method.
              #   result = client.list_cloud_control_deployments request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::CloudSecurityCompliance::V1::CloudControlDeployment.
              #     p item
              #   end
              #
              def list_cloud_control_deployments request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudSecurityCompliance::V1::ListCloudControlDeploymentsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_cloud_control_deployments.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::CloudSecurityCompliance::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_cloud_control_deployments.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_cloud_control_deployments.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @deployment_stub.list_cloud_control_deployments request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @deployment_stub, :list_cloud_control_deployments, "cloud_control_deployments", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the Deployment REST API.
              #
              # This class represents the configuration for Deployment REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::CloudSecurityCompliance::V1::Deployment::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # create_framework_deployment to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::CloudSecurityCompliance::V1::Deployment::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_framework_deployment.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::CloudSecurityCompliance::V1::Deployment::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_framework_deployment.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "cloudsecuritycompliance.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the Deployment API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `create_framework_deployment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_framework_deployment
                  ##
                  # RPC-specific configuration for `delete_framework_deployment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_framework_deployment
                  ##
                  # RPC-specific configuration for `get_framework_deployment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_framework_deployment
                  ##
                  # RPC-specific configuration for `list_framework_deployments`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_framework_deployments
                  ##
                  # RPC-specific configuration for `get_cloud_control_deployment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_cloud_control_deployment
                  ##
                  # RPC-specific configuration for `list_cloud_control_deployments`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_cloud_control_deployments

                  # @private
                  def initialize parent_rpcs = nil
                    create_framework_deployment_config = parent_rpcs.create_framework_deployment if parent_rpcs.respond_to? :create_framework_deployment
                    @create_framework_deployment = ::Gapic::Config::Method.new create_framework_deployment_config
                    delete_framework_deployment_config = parent_rpcs.delete_framework_deployment if parent_rpcs.respond_to? :delete_framework_deployment
                    @delete_framework_deployment = ::Gapic::Config::Method.new delete_framework_deployment_config
                    get_framework_deployment_config = parent_rpcs.get_framework_deployment if parent_rpcs.respond_to? :get_framework_deployment
                    @get_framework_deployment = ::Gapic::Config::Method.new get_framework_deployment_config
                    list_framework_deployments_config = parent_rpcs.list_framework_deployments if parent_rpcs.respond_to? :list_framework_deployments
                    @list_framework_deployments = ::Gapic::Config::Method.new list_framework_deployments_config
                    get_cloud_control_deployment_config = parent_rpcs.get_cloud_control_deployment if parent_rpcs.respond_to? :get_cloud_control_deployment
                    @get_cloud_control_deployment = ::Gapic::Config::Method.new get_cloud_control_deployment_config
                    list_cloud_control_deployments_config = parent_rpcs.list_cloud_control_deployments if parent_rpcs.respond_to? :list_cloud_control_deployments
                    @list_cloud_control_deployments = ::Gapic::Config::Method.new list_cloud_control_deployments_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
