# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/cloudsecuritycompliance/v1/config_pb"
require "google/cloud/cloud_security_compliance/v1/config/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Cloud
    module CloudSecurityCompliance
      module V1
        module Config
          module Rest
            ##
            # REST client for the Config service.
            #
            # Config Service manages compliance frameworks, cloud controls, and their
            # configurations.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "cloudsecuritycompliance.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :config_stub

              ##
              # Configure the Config Client class.
              #
              # See {::Google::Cloud::CloudSecurityCompliance::V1::Config::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all Config clients
              #   ::Google::Cloud::CloudSecurityCompliance::V1::Config::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "CloudSecurityCompliance", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.list_frameworks.timeout = 60.0
                  default_config.rpcs.list_frameworks.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_framework.timeout = 60.0
                  default_config.rpcs.get_framework.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.create_framework.timeout = 60.0

                  default_config.rpcs.update_framework.timeout = 60.0

                  default_config.rpcs.delete_framework.timeout = 60.0

                  default_config.rpcs.list_cloud_controls.timeout = 60.0
                  default_config.rpcs.list_cloud_controls.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_cloud_control.timeout = 60.0
                  default_config.rpcs.get_cloud_control.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.create_cloud_control.timeout = 60.0

                  default_config.rpcs.update_cloud_control.timeout = 60.0

                  default_config.rpcs.delete_cloud_control.timeout = 60.0

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the Config Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::CloudSecurityCompliance::V1::Config::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @config_stub.universe_domain
              end

              ##
              # Create a new Config REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::CloudSecurityCompliance::V1::Config::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::CloudSecurityCompliance::V1::Config::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Config client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @config_stub = ::Google::Cloud::CloudSecurityCompliance::V1::Config::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @config_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config_stub.endpoint
                  config.universe_domain = @config_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @config_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @config_stub.logger
              end

              # Service calls

              ##
              # Lists the frameworks (both built-in and custom) that are available within
              # the parent resource. The latest major version of each framework is
              # returned.
              # This method supports pagination.
              #
              # @overload list_frameworks(request, options = nil)
              #   Pass arguments to `list_frameworks` via a request object, either of type
              #   {::Google::Cloud::CloudSecurityCompliance::V1::ListFrameworksRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::CloudSecurityCompliance::V1::ListFrameworksRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_frameworks(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_frameworks` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource name, in the format
              #     `organizations/{organization}/locations/{location}`.
              #     The only supported location is `global`.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of frameworks to return. The default value is
              #     `500`.
              #
              #     If you exceed the maximum value of `1000`, then the service uses the
              #     maximum value.
              #   @param page_token [::String]
              #     Optional. A pagination token returned from a previous request to list
              #     frameworks. Provide this token to retrieve the next page of results.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::CloudSecurityCompliance::V1::Framework>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::CloudSecurityCompliance::V1::Framework>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/cloud_security_compliance/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::CloudSecurityCompliance::V1::Config::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::CloudSecurityCompliance::V1::ListFrameworksRequest.new
              #
              #   # Call the list_frameworks method.
              #   result = client.list_frameworks request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::CloudSecurityCompliance::V1::Framework.
              #     p item
              #   end
              #
              def list_frameworks request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudSecurityCompliance::V1::ListFrameworksRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_frameworks.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::CloudSecurityCompliance::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_frameworks.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_frameworks.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @config_stub.list_frameworks request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @config_stub, :list_frameworks, "frameworks", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details about a framework.
              # This method retrieves the latest major version of the framework.
              #
              # To retrieve a specific major version, include `major_revision_id` in
              # the request.
              #
              # @overload get_framework(request, options = nil)
              #   Pass arguments to `get_framework` via a request object, either of type
              #   {::Google::Cloud::CloudSecurityCompliance::V1::GetFrameworkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::CloudSecurityCompliance::V1::GetFrameworkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_framework(name: nil, major_revision_id: nil)
              #   Pass arguments to `get_framework` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the framework to retrieve, in the format
              #     `organizations/{organization}/locations/{location}/frameworks/{framework_id}`
              #     The only supported location is `global`.
              #   @param major_revision_id [::Integer]
              #     Optional. The framework major version to retrieve. If not specified, the
              #     most recently updated `revision_id` is retrieved.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::CloudSecurityCompliance::V1::Framework]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::CloudSecurityCompliance::V1::Framework]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/cloud_security_compliance/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::CloudSecurityCompliance::V1::Config::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::CloudSecurityCompliance::V1::GetFrameworkRequest.new
              #
              #   # Call the get_framework method.
              #   result = client.get_framework request
              #
              #   # The returned object is of type Google::Cloud::CloudSecurityCompliance::V1::Framework.
              #   p result
              #
              def get_framework request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudSecurityCompliance::V1::GetFrameworkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_framework.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::CloudSecurityCompliance::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_framework.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_framework.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @config_stub.get_framework request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a custom framework in a given parent resource.
              # You can't create built-in frameworks because those are managed by
              # Google.
              #
              # @overload create_framework(request, options = nil)
              #   Pass arguments to `create_framework` via a request object, either of type
              #   {::Google::Cloud::CloudSecurityCompliance::V1::CreateFrameworkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::CloudSecurityCompliance::V1::CreateFrameworkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_framework(parent: nil, framework_id: nil, framework: nil)
              #   Pass arguments to `create_framework` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource name, in the format
              #     `organizations/{organization}/locations/{location}`.
              #     The only supported location is `global`.
              #   @param framework_id [::String]
              #     Required. The identifier (ID) of the framework. The ID is not the full name
              #     of the framework; it's the last part of the full name of the framework.
              #   @param framework [::Google::Cloud::CloudSecurityCompliance::V1::Framework, ::Hash]
              #     Required. The resource being created.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::CloudSecurityCompliance::V1::Framework]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::CloudSecurityCompliance::V1::Framework]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/cloud_security_compliance/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::CloudSecurityCompliance::V1::Config::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::CloudSecurityCompliance::V1::CreateFrameworkRequest.new
              #
              #   # Call the create_framework method.
              #   result = client.create_framework request
              #
              #   # The returned object is of type Google::Cloud::CloudSecurityCompliance::V1::Framework.
              #   p result
              #
              def create_framework request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudSecurityCompliance::V1::CreateFrameworkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_framework.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::CloudSecurityCompliance::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_framework.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_framework.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @config_stub.create_framework request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a custom framework.
              # This method allows for partial updates of a framework. Use the
              # `update_mask` to specify which fields to update. Consider the following:
              #
              # - If you provide an `update_mask`, only the fields that are specified
              # in the mask are updated.
              # - If you don't provide an `update_mask`, all the fields that are present
              # in the request's `framework` body are used to overwrite the existing
              # resource.
              #
              # You can only update frameworks with the `CUSTOM` type.
              # A successful update creates a new version of the framework.
              #
              # @overload update_framework(request, options = nil)
              #   Pass arguments to `update_framework` via a request object, either of type
              #   {::Google::Cloud::CloudSecurityCompliance::V1::UpdateFrameworkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::CloudSecurityCompliance::V1::UpdateFrameworkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_framework(update_mask: nil, framework: nil, major_revision_id: nil)
              #   Pass arguments to `update_framework` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. A field mask is used to specify the fields to be overwritten in
              #     the framework resource by the update. The fields specified in the
              #     `update_mask` are relative to the resource, not the full request. A field
              #     is overwritten if it is in the mask. If you don't provide a mask then all
              #     fields present in the request will be overwritten.
              #   @param framework [::Google::Cloud::CloudSecurityCompliance::V1::Framework, ::Hash]
              #     Required. The resource that is being updated.
              #   @param major_revision_id [::Integer]
              #     Optional. The major version ID of the framework to update.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::CloudSecurityCompliance::V1::Framework]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::CloudSecurityCompliance::V1::Framework]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/cloud_security_compliance/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::CloudSecurityCompliance::V1::Config::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::CloudSecurityCompliance::V1::UpdateFrameworkRequest.new
              #
              #   # Call the update_framework method.
              #   result = client.update_framework request
              #
              #   # The returned object is of type Google::Cloud::CloudSecurityCompliance::V1::Framework.
              #   p result
              #
              def update_framework request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudSecurityCompliance::V1::UpdateFrameworkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_framework.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::CloudSecurityCompliance::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_framework.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_framework.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @config_stub.update_framework request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a custom framework, including all its major and
              # minor revisions. Consider the following:
              #
              # - You can't delete built-in frameworks. You can only delete frameworks
              #   with type `CUSTOM`.
              # - You can't delete frameworks that are deployed to a resource.
              # - You can't restore a deleted framework. This action is permanent.
              #
              # @overload delete_framework(request, options = nil)
              #   Pass arguments to `delete_framework` via a request object, either of type
              #   {::Google::Cloud::CloudSecurityCompliance::V1::DeleteFrameworkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::CloudSecurityCompliance::V1::DeleteFrameworkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_framework(name: nil)
              #   Pass arguments to `delete_framework` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the resource, in the format
              #     `organizations/{organization}/locations/{location}/frameworks/{framework}`.
              #     The only supported location is `global`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/cloud_security_compliance/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::CloudSecurityCompliance::V1::Config::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::CloudSecurityCompliance::V1::DeleteFrameworkRequest.new
              #
              #   # Call the delete_framework method.
              #   result = client.delete_framework request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_framework request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudSecurityCompliance::V1::DeleteFrameworkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_framework.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::CloudSecurityCompliance::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_framework.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_framework.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @config_stub.delete_framework request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists the cloud controls (both built-in and custom) that are available
              # in a given parent resource. The latest major version of each cloud control
              # is returned.
              # This method supports pagination.
              #
              # @overload list_cloud_controls(request, options = nil)
              #   Pass arguments to `list_cloud_controls` via a request object, either of type
              #   {::Google::Cloud::CloudSecurityCompliance::V1::ListCloudControlsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::CloudSecurityCompliance::V1::ListCloudControlsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_cloud_controls(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_cloud_controls` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource name, in the format
              #     `organizations/{organization}/locations/{location}`.
              #     The only supported location is `global`.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of cloud controls to return. The default value
              #     is `500`.
              #
              #     If you exceed the maximum value of `1000`, then the service uses the
              #     maximum value.
              #   @param page_token [::String]
              #     Optional. A pagination token that's returned from a previous request to
              #     list cloud controls. Provide this token to retrieve the next page of
              #     results.
              #
              #     When paginating, the parent that you provide to the
              #     {::Google::Cloud::CloudSecurityCompliance::V1::Config::Rest::Client#list_cloud_controls ListCloudControls}
              #     request must match the call that provided the page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::CloudSecurityCompliance::V1::CloudControl>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::CloudSecurityCompliance::V1::CloudControl>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/cloud_security_compliance/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::CloudSecurityCompliance::V1::Config::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::CloudSecurityCompliance::V1::ListCloudControlsRequest.new
              #
              #   # Call the list_cloud_controls method.
              #   result = client.list_cloud_controls request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::CloudSecurityCompliance::V1::CloudControl.
              #     p item
              #   end
              #
              def list_cloud_controls request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudSecurityCompliance::V1::ListCloudControlsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_cloud_controls.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::CloudSecurityCompliance::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_cloud_controls.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_cloud_controls.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @config_stub.list_cloud_controls request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @config_stub, :list_cloud_controls, "cloud_controls", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details about a cloud control.
              # This method retrieves the latest major version of a cloud control that
              # you identify by name.
              #
              # By default, the latest major version of the cloud control is returned.
              # To retrieve a specific major version, include `major_revision_id` in
              # the request.
              #
              # @overload get_cloud_control(request, options = nil)
              #   Pass arguments to `get_cloud_control` via a request object, either of type
              #   {::Google::Cloud::CloudSecurityCompliance::V1::GetCloudControlRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::CloudSecurityCompliance::V1::GetCloudControlRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_cloud_control(name: nil, major_revision_id: nil)
              #   Pass arguments to `get_cloud_control` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the cloud control to retrieve, in the format
              #     `organizations/{organization}/locations/{location}/cloudControls/{cloud_control}`.
              #     The only supported location is `global`.
              #   @param major_revision_id [::Integer]
              #     Optional. The major version of the cloud control to retrieve. If not
              #     specified, the most recently updated `revision_id` is retrieved.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::CloudSecurityCompliance::V1::CloudControl]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::CloudSecurityCompliance::V1::CloudControl]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/cloud_security_compliance/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::CloudSecurityCompliance::V1::Config::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::CloudSecurityCompliance::V1::GetCloudControlRequest.new
              #
              #   # Call the get_cloud_control method.
              #   result = client.get_cloud_control request
              #
              #   # The returned object is of type Google::Cloud::CloudSecurityCompliance::V1::CloudControl.
              #   p result
              #
              def get_cloud_control request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudSecurityCompliance::V1::GetCloudControlRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_cloud_control.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::CloudSecurityCompliance::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_cloud_control.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_cloud_control.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @config_stub.get_cloud_control request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a custom cloud control in a given parent
              # resource.
              # You can't create built-in cloud controls because those are managed by
              # Google.
              #
              # @overload create_cloud_control(request, options = nil)
              #   Pass arguments to `create_cloud_control` via a request object, either of type
              #   {::Google::Cloud::CloudSecurityCompliance::V1::CreateCloudControlRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::CloudSecurityCompliance::V1::CreateCloudControlRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_cloud_control(parent: nil, cloud_control_id: nil, cloud_control: nil)
              #   Pass arguments to `create_cloud_control` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource name, in the format
              #     `organizations/{organization}/locations/{location}`.
              #     The only supported location is `global`.
              #   @param cloud_control_id [::String]
              #     Required. The identifier for the cloud control, which is the last segment
              #     of the cloud control name. The format is
              #     `^[a-zA-Z][a-zA-Z0-9-]{0,61}[a-zA-Z0-9]$`.
              #   @param cloud_control [::Google::Cloud::CloudSecurityCompliance::V1::CloudControl, ::Hash]
              #     Required. The cloud control that's being created.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::CloudSecurityCompliance::V1::CloudControl]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::CloudSecurityCompliance::V1::CloudControl]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/cloud_security_compliance/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::CloudSecurityCompliance::V1::Config::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::CloudSecurityCompliance::V1::CreateCloudControlRequest.new
              #
              #   # Call the create_cloud_control method.
              #   result = client.create_cloud_control request
              #
              #   # The returned object is of type Google::Cloud::CloudSecurityCompliance::V1::CloudControl.
              #   p result
              #
              def create_cloud_control request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudSecurityCompliance::V1::CreateCloudControlRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_cloud_control.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::CloudSecurityCompliance::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_cloud_control.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_cloud_control.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @config_stub.create_cloud_control request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a custom cloud control.
              # This method allows for partial updates of a cloud control. Use the
              # `update_mask` to specify which fields to update. Consider the following:
              #
              # - If you provide an `update_mask`, only the fields that are specified
              # in the mask are updated.
              # - If you don't provide an `update_mask`, all the fields that are present
              # in the request's `cloud_control` body are used to overwrite the existing
              # resource.
              #
              # You can only update cloud controls with the `CUSTOM` type.
              # A successful update creates a new version of the cloud control.
              #
              # @overload update_cloud_control(request, options = nil)
              #   Pass arguments to `update_cloud_control` via a request object, either of type
              #   {::Google::Cloud::CloudSecurityCompliance::V1::UpdateCloudControlRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::CloudSecurityCompliance::V1::UpdateCloudControlRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_cloud_control(update_mask: nil, cloud_control: nil)
              #   Pass arguments to `update_cloud_control` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. Use a field mask to specify the fields to be overwritten in the
              #     cloud control during the update.
              #     The fields that you specify in the `update_mask` are relative to the
              #     cloud control, not the full request. A field is overwritten if it is in
              #     the mask. If you don't provide a mask, all fields in the request
              #     are updated.
              #
              #     You can update the following fields:
              #
              #     - Display name
              #     - Description
              #     - Parameters
              #     - Rules
              #     - Parameter specification
              #   @param cloud_control [::Google::Cloud::CloudSecurityCompliance::V1::CloudControl, ::Hash]
              #     Required. The cloud control that you're updating.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::CloudSecurityCompliance::V1::CloudControl]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::CloudSecurityCompliance::V1::CloudControl]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/cloud_security_compliance/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::CloudSecurityCompliance::V1::Config::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::CloudSecurityCompliance::V1::UpdateCloudControlRequest.new
              #
              #   # Call the update_cloud_control method.
              #   result = client.update_cloud_control request
              #
              #   # The returned object is of type Google::Cloud::CloudSecurityCompliance::V1::CloudControl.
              #   p result
              #
              def update_cloud_control request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudSecurityCompliance::V1::UpdateCloudControlRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_cloud_control.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::CloudSecurityCompliance::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_cloud_control.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_cloud_control.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @config_stub.update_cloud_control request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a custom cloud control, including all its
              # major and minor revisions. Consider the following:
              #
              # - You can't delete built-in cloud controls. You can only delete cloud
              #   controls with type `CUSTOM`.
              # - You can't delete cloud controls if any of the versions are referenced
              #   by a framework.
              # - You can't restore a deleted cloud control. This action is permanent.
              #
              # @overload delete_cloud_control(request, options = nil)
              #   Pass arguments to `delete_cloud_control` via a request object, either of type
              #   {::Google::Cloud::CloudSecurityCompliance::V1::DeleteCloudControlRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::CloudSecurityCompliance::V1::DeleteCloudControlRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_cloud_control(name: nil)
              #   Pass arguments to `delete_cloud_control` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the cloud control to delete, in the format
              #     `organizations/{organization}/locations/{location}/CloudControls/{CloudControl}`.
              #     The only supported location is `global`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/cloud_security_compliance/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::CloudSecurityCompliance::V1::Config::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::CloudSecurityCompliance::V1::DeleteCloudControlRequest.new
              #
              #   # Call the delete_cloud_control method.
              #   result = client.delete_cloud_control request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_cloud_control request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudSecurityCompliance::V1::DeleteCloudControlRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_cloud_control.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::CloudSecurityCompliance::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_cloud_control.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_cloud_control.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @config_stub.delete_cloud_control request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the Config REST API.
              #
              # This class represents the configuration for Config REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::CloudSecurityCompliance::V1::Config::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # list_frameworks to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::CloudSecurityCompliance::V1::Config::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_frameworks.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::CloudSecurityCompliance::V1::Config::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_frameworks.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "cloudsecuritycompliance.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the Config API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `list_frameworks`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_frameworks
                  ##
                  # RPC-specific configuration for `get_framework`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_framework
                  ##
                  # RPC-specific configuration for `create_framework`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_framework
                  ##
                  # RPC-specific configuration for `update_framework`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_framework
                  ##
                  # RPC-specific configuration for `delete_framework`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_framework
                  ##
                  # RPC-specific configuration for `list_cloud_controls`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_cloud_controls
                  ##
                  # RPC-specific configuration for `get_cloud_control`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_cloud_control
                  ##
                  # RPC-specific configuration for `create_cloud_control`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_cloud_control
                  ##
                  # RPC-specific configuration for `update_cloud_control`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_cloud_control
                  ##
                  # RPC-specific configuration for `delete_cloud_control`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_cloud_control

                  # @private
                  def initialize parent_rpcs = nil
                    list_frameworks_config = parent_rpcs.list_frameworks if parent_rpcs.respond_to? :list_frameworks
                    @list_frameworks = ::Gapic::Config::Method.new list_frameworks_config
                    get_framework_config = parent_rpcs.get_framework if parent_rpcs.respond_to? :get_framework
                    @get_framework = ::Gapic::Config::Method.new get_framework_config
                    create_framework_config = parent_rpcs.create_framework if parent_rpcs.respond_to? :create_framework
                    @create_framework = ::Gapic::Config::Method.new create_framework_config
                    update_framework_config = parent_rpcs.update_framework if parent_rpcs.respond_to? :update_framework
                    @update_framework = ::Gapic::Config::Method.new update_framework_config
                    delete_framework_config = parent_rpcs.delete_framework if parent_rpcs.respond_to? :delete_framework
                    @delete_framework = ::Gapic::Config::Method.new delete_framework_config
                    list_cloud_controls_config = parent_rpcs.list_cloud_controls if parent_rpcs.respond_to? :list_cloud_controls
                    @list_cloud_controls = ::Gapic::Config::Method.new list_cloud_controls_config
                    get_cloud_control_config = parent_rpcs.get_cloud_control if parent_rpcs.respond_to? :get_cloud_control
                    @get_cloud_control = ::Gapic::Config::Method.new get_cloud_control_config
                    create_cloud_control_config = parent_rpcs.create_cloud_control if parent_rpcs.respond_to? :create_cloud_control
                    @create_cloud_control = ::Gapic::Config::Method.new create_cloud_control_config
                    update_cloud_control_config = parent_rpcs.update_cloud_control if parent_rpcs.respond_to? :update_cloud_control
                    @update_cloud_control = ::Gapic::Config::Method.new update_cloud_control_config
                    delete_cloud_control_config = parent_rpcs.delete_cloud_control if parent_rpcs.respond_to? :delete_cloud_control
                    @delete_cloud_control = ::Gapic::Config::Method.new delete_cloud_control_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
