# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module CloudSecurityCompliance
      module V1
        module CmEnrollmentService
          # Path helper methods for the CmEnrollmentService API.
          module Paths
            ##
            # Create a fully-qualified CmEnrollment resource string.
            #
            # @overload cm_enrollment_path(organization:, location:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/locations/{location}/cmEnrollment`
            #
            #   @param organization [String]
            #   @param location [String]
            #
            # @overload cm_enrollment_path(project:, location:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/cmEnrollment`
            #
            #   @param project [String]
            #   @param location [String]
            #
            # @return [::String]
            def cm_enrollment_path **args
              resources = {
                "location:organization" => (proc do |organization:, location:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"

                  "organizations/#{organization}/locations/#{location}/cmEnrollment"
                end),
                "location:project" => (proc do |project:, location:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/cmEnrollment"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            extend self
          end
        end
      end
    end
  end
end
