# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module CloudSecurityCompliance
      module V1
        module Audit
          # Path helper methods for the Audit API.
          module Paths
            ##
            # Create a fully-qualified FrameworkAudit resource string.
            #
            # @overload framework_audit_path(project:, location:, framework_audit:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/frameworkAudits/{framework_audit}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param framework_audit [String]
            #
            # @overload framework_audit_path(organization:, location:, framework_audit:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/locations/{location}/frameworkAudits/{framework_audit}`
            #
            #   @param organization [String]
            #   @param location [String]
            #   @param framework_audit [String]
            #
            # @return [::String]
            def framework_audit_path **args
              resources = {
                "framework_audit:location:project" => (proc do |project:, location:, framework_audit:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/frameworkAudits/#{framework_audit}"
                end),
                "framework_audit:location:organization" => (proc do |organization:, location:, framework_audit:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "organizations/#{organization}/locations/#{location}/frameworkAudits/#{framework_audit}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified OrganizationLocation resource string.
            #
            # The resource will be in the following format:
            #
            # `organizations/{organization}/locations/{location}`
            #
            # @param organization [String]
            # @param location [String]
            #
            # @return [::String]
            def organization_location_path organization:, location:
              raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"

              "organizations/#{organization}/locations/#{location}"
            end

            extend self
          end
        end
      end
    end
  end
end
