# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module CloudQuotas
      module V1beta
        # Request for getting QuotaAdjusterSettings
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the `quotaAdjusterSettings` configuration. Only a single
        #     setting per project is supported.
        class GetQuotaAdjusterSettingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for updating QuotaAdjusterSettings
        # @!attribute [rw] quota_adjuster_settings
        #   @return [::Google::Cloud::CloudQuotas::V1beta::QuotaAdjusterSettings]
        #     Required. The QuotaAdjusterSettings to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. The list of fields to update.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set to true, checks the syntax of the request but doesn't
        #     update the quota adjuster settings value. Note that although a request can
        #     be valid, that doesn't guarantee that the request will be fulfilled.
        class UpdateQuotaAdjusterSettingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The QuotaAdjusterSettings resource defines the settings for the Quota
        # Adjuster.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Name of the config would be of the format:
        #       projects/PROJECT_NUMBER/locations/global/quotaAdjusterSettings
        #       folders/FOLDER_NUMBER/locations/global/quotaAdjusterSettings
        #       organizations/ORGANIZATION_NUMBER/locations/global/quotaAdjusterSettings
        # @!attribute [rw] enablement
        #   @return [::Google::Cloud::CloudQuotas::V1beta::QuotaAdjusterSettings::Enablement]
        #     Optional. The configured value of the enablement at the given resource.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the QuotaAdjusterSettings resource was last
        #     updated.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. The current ETag of the QuotaAdjusterSettings. If an ETag is
        #     provided on update and does not match the current server's ETag in the
        #     QuotaAdjusterSettings, the request is blocked and returns an ABORTED error.
        #     See https://google.aip.dev/134#etags for more details on ETags.
        # @!attribute [rw] inherited
        #   @return [::Boolean]
        #     Optional. Indicates whether the setting is inherited or explicitly
        #     specified.
        # @!attribute [r] inherited_from
        #   @return [::String]
        #     Output only. The resource container from which the setting is inherited.
        #     This refers to the  nearest ancestor with enablement set (either ENABLED or
        #     DISABLED). The value can be an organizations/\\{organization_id},
        #     folders/\\{folder_id}, or can be 'default' if no ancestor exists with
        #     enablement set. The value will be empty when enablement is directly set on
        #     this container.
        class QuotaAdjusterSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The enablement status of the quota adjuster.
          module Enablement
            # The quota adjuster is in an unknown state.
            ENABLEMENT_UNSPECIFIED = 0

            # The quota adjuster is enabled.
            ENABLED = 2

            # The quota adjuster is disabled.
            DISABLED = 3
          end
        end
      end
    end
  end
end
