# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module CloudQuotas
      module V1beta
        module QuotaAdjusterSettingsManager
          # Path helper methods for the QuotaAdjusterSettingsManager API.
          module Paths
            ##
            # Create a fully-qualified QuotaAdjusterSettings resource string.
            #
            # @overload quota_adjuster_settings_path(project:, location:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/quotaAdjusterSettings`
            #
            #   @param project [String]
            #   @param location [String]
            #
            # @overload quota_adjuster_settings_path(organization:, location:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/locations/{location}/quotaAdjusterSettings`
            #
            #   @param organization [String]
            #   @param location [String]
            #
            # @overload quota_adjuster_settings_path(folder:, location:)
            #   The resource will be in the following format:
            #
            #   `folders/{folder}/locations/{location}/quotaAdjusterSettings`
            #
            #   @param folder [String]
            #   @param location [String]
            #
            # @return [::String]
            def quota_adjuster_settings_path **args
              resources = {
                "location:project" => (proc do |project:, location:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/quotaAdjusterSettings"
                end),
                "location:organization" => (proc do |organization:, location:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"

                  "organizations/#{organization}/locations/#{location}/quotaAdjusterSettings"
                end),
                "folder:location" => (proc do |folder:, location:|
                  raise ::ArgumentError, "folder cannot contain /" if folder.to_s.include? "/"

                  "folders/#{folder}/locations/#{location}/quotaAdjusterSettings"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            extend self
          end
        end
      end
    end
  end
end
