# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/common"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/cloud_quotas/v1beta/version"

require "google/cloud/cloud_quotas/v1beta/quota_adjuster_settings_manager/credentials"
require "google/cloud/cloud_quotas/v1beta/quota_adjuster_settings_manager/paths"
require "google/cloud/cloud_quotas/v1beta/quota_adjuster_settings_manager/client"
require "google/cloud/cloud_quotas/v1beta/quota_adjuster_settings_manager/rest"

module Google
  module Cloud
    module CloudQuotas
      module V1beta
        ##
        # The Quotas Adjuster Settings API is an infrastructure service for Google
        #  Cloud that lets service consumers view and update their quota adjuster
        #  settings.
        #
        # - Update quota adjuster settings.
        # - Get the name of the configurations.
        #
        # @example Load this service and instantiate a gRPC client
        #
        #     require "google/cloud/cloud_quotas/v1beta/quota_adjuster_settings_manager"
        #     client = ::Google::Cloud::CloudQuotas::V1beta::QuotaAdjusterSettingsManager::Client.new
        #
        # @example Load this service and instantiate a REST client
        #
        #     require "google/cloud/cloud_quotas/v1beta/quota_adjuster_settings_manager/rest"
        #     client = ::Google::Cloud::CloudQuotas::V1beta::QuotaAdjusterSettingsManager::Rest::Client.new
        #
        module QuotaAdjusterSettingsManager
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "quota_adjuster_settings_manager", "helpers.rb"
require "google/cloud/cloud_quotas/v1beta/quota_adjuster_settings_manager/helpers" if ::File.file? helper_path
