# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module CloudQuotas
      module V1beta
        module CloudQuotas
          # Path helper methods for the CloudQuotas API.
          module Paths
            ##
            # Create a fully-qualified Location resource string.
            #
            # @overload location_path(project:, location:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}`
            #
            #   @param project [String]
            #   @param location [String]
            #
            # @overload location_path(folder:, location:)
            #   The resource will be in the following format:
            #
            #   `folders/{folder}/locations/{location}`
            #
            #   @param folder [String]
            #   @param location [String]
            #
            # @overload location_path(organization:, location:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/locations/{location}`
            #
            #   @param organization [String]
            #   @param location [String]
            #
            # @return [::String]
            def location_path **args
              resources = {
                "location:project" => (proc do |project:, location:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

                  "projects/#{project}/locations/#{location}"
                end),
                "folder:location" => (proc do |folder:, location:|
                  raise ::ArgumentError, "folder cannot contain /" if folder.to_s.include? "/"

                  "folders/#{folder}/locations/#{location}"
                end),
                "location:organization" => (proc do |organization:, location:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"

                  "organizations/#{organization}/locations/#{location}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified QuotaInfo resource string.
            #
            # @overload quota_info_path(project:, location:, service:, quota_info:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/services/{service}/quotaInfos/{quota_info}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param service [String]
            #   @param quota_info [String]
            #
            # @overload quota_info_path(folder:, location:, service:, quota_info:)
            #   The resource will be in the following format:
            #
            #   `folders/{folder}/locations/{location}/services/{service}/quotaInfos/{quota_info}`
            #
            #   @param folder [String]
            #   @param location [String]
            #   @param service [String]
            #   @param quota_info [String]
            #
            # @overload quota_info_path(organization:, location:, service:, quota_info:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/locations/{location}/services/{service}/quotaInfos/{quota_info}`
            #
            #   @param organization [String]
            #   @param location [String]
            #   @param service [String]
            #   @param quota_info [String]
            #
            # @return [::String]
            def quota_info_path **args
              resources = {
                "location:project:quota_info:service" => (proc do |project:, location:, service:, quota_info:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                  raise ::ArgumentError, "service cannot contain /" if service.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/services/#{service}/quotaInfos/#{quota_info}"
                end),
                "folder:location:quota_info:service" => (proc do |folder:, location:, service:, quota_info:|
                  raise ::ArgumentError, "folder cannot contain /" if folder.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                  raise ::ArgumentError, "service cannot contain /" if service.to_s.include? "/"

                  "folders/#{folder}/locations/#{location}/services/#{service}/quotaInfos/#{quota_info}"
                end),
                "location:organization:quota_info:service" => (proc do |organization:, location:, service:, quota_info:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                  raise ::ArgumentError, "service cannot contain /" if service.to_s.include? "/"

                  "organizations/#{organization}/locations/#{location}/services/#{service}/quotaInfos/#{quota_info}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified QuotaPreference resource string.
            #
            # @overload quota_preference_path(project:, location:, quota_preference:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/quotaPreferences/{quota_preference}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param quota_preference [String]
            #
            # @overload quota_preference_path(folder:, location:, quota_preference:)
            #   The resource will be in the following format:
            #
            #   `folders/{folder}/locations/{location}/quotaPreferences/{quota_preference}`
            #
            #   @param folder [String]
            #   @param location [String]
            #   @param quota_preference [String]
            #
            # @overload quota_preference_path(organization:, location:, quota_preference:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/locations/{location}/quotaPreferences/{quota_preference}`
            #
            #   @param organization [String]
            #   @param location [String]
            #   @param quota_preference [String]
            #
            # @return [::String]
            def quota_preference_path **args
              resources = {
                "location:project:quota_preference" => (proc do |project:, location:, quota_preference:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/quotaPreferences/#{quota_preference}"
                end),
                "folder:location:quota_preference" => (proc do |folder:, location:, quota_preference:|
                  raise ::ArgumentError, "folder cannot contain /" if folder.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "folders/#{folder}/locations/#{location}/quotaPreferences/#{quota_preference}"
                end),
                "location:organization:quota_preference" => (proc do |organization:, location:, quota_preference:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "organizations/#{organization}/locations/#{location}/quotaPreferences/#{quota_preference}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified Service resource string.
            #
            # @overload service_path(project:, location:, service:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/services/{service}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param service [String]
            #
            # @overload service_path(folder:, location:, service:)
            #   The resource will be in the following format:
            #
            #   `folders/{folder}/locations/{location}/services/{service}`
            #
            #   @param folder [String]
            #   @param location [String]
            #   @param service [String]
            #
            # @overload service_path(organization:, location:, service:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/locations/{location}/services/{service}`
            #
            #   @param organization [String]
            #   @param location [String]
            #   @param service [String]
            #
            # @return [::String]
            def service_path **args
              resources = {
                "location:project:service" => (proc do |project:, location:, service:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/services/#{service}"
                end),
                "folder:location:service" => (proc do |folder:, location:, service:|
                  raise ::ArgumentError, "folder cannot contain /" if folder.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "folders/#{folder}/locations/#{location}/services/#{service}"
                end),
                "location:organization:service" => (proc do |organization:, location:, service:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "organizations/#{organization}/locations/#{location}/services/#{service}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            extend self
          end
        end
      end
    end
  end
end
