# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/api/cloudquotas/v1beta/cloudquotas_pb"

module Google
  module Cloud
    module CloudQuotas
      module V1beta
        module CloudQuotas
          ##
          # Client for the CloudQuotas service.
          #
          # The Cloud Quotas API is an infrastructure service for Google Cloud that lets
          # service consumers list and manage their resource usage limits.
          #
          # - List/Get the metadata and current status of the quotas for a service.
          # - Create/Update quota preferencess that declare the preferred quota values.
          # - Check the status of a quota preference request.
          # - List/Get pending and historical quota preference.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "cloudquotas.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :cloud_quotas_stub

            ##
            # Configure the CloudQuotas Client class.
            #
            # See {::Google::Cloud::CloudQuotas::V1beta::CloudQuotas::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all CloudQuotas clients
            #   ::Google::Cloud::CloudQuotas::V1beta::CloudQuotas::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "CloudQuotas", "V1beta"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.list_quota_infos.timeout = 60.0
                default_config.rpcs.list_quota_infos.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_quota_info.timeout = 60.0
                default_config.rpcs.get_quota_info.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_quota_preferences.timeout = 60.0
                default_config.rpcs.list_quota_preferences.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_quota_preference.timeout = 60.0
                default_config.rpcs.get_quota_preference.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_quota_preference.timeout = 60.0
                default_config.rpcs.create_quota_preference.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.update_quota_preference.timeout = 60.0
                default_config.rpcs.update_quota_preference.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the CloudQuotas Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::CloudQuotas::V1beta::CloudQuotas::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @cloud_quotas_stub.universe_domain
            end

            ##
            # Create a new CloudQuotas client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::CloudQuotas::V1beta::CloudQuotas::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::CloudQuotas::V1beta::CloudQuotas::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the CloudQuotas client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/api/cloudquotas/v1beta/cloudquotas_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @cloud_quotas_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::CloudQuotas::V1beta::CloudQuotas::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @cloud_quotas_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end
            end

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @cloud_quotas_stub.logger
            end

            # Service calls

            ##
            # Lists QuotaInfos of all quotas for a given project, folder or organization.
            #
            # @overload list_quota_infos(request, options = nil)
            #   Pass arguments to `list_quota_infos` via a request object, either of type
            #   {::Google::Cloud::CloudQuotas::V1beta::ListQuotaInfosRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudQuotas::V1beta::ListQuotaInfosRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_quota_infos(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_quota_infos` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Parent value of QuotaInfo resources.
            #     Listing across different resource containers (such as 'projects/-') is not
            #     allowed.
            #
            #     Example names:
            #     `projects/123/locations/global/services/compute.googleapis.com`
            #     `folders/234/locations/global/services/compute.googleapis.com`
            #     `organizations/345/locations/global/services/compute.googleapis.com`
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer items than
            #     requested. If unspecified, server will pick an appropriate default.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results the server should return.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::CloudQuotas::V1beta::QuotaInfo>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::CloudQuotas::V1beta::QuotaInfo>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_quotas/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudQuotas::V1beta::CloudQuotas::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudQuotas::V1beta::ListQuotaInfosRequest.new
            #
            #   # Call the list_quota_infos method.
            #   result = client.list_quota_infos request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::CloudQuotas::V1beta::QuotaInfo.
            #     p item
            #   end
            #
            def list_quota_infos request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudQuotas::V1beta::ListQuotaInfosRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_quota_infos.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudQuotas::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_quota_infos.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_quota_infos.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cloud_quotas_stub.call_rpc :list_quota_infos, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @cloud_quotas_stub, :list_quota_infos, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieve the QuotaInfo of a quota for a project, folder or organization.
            #
            # @overload get_quota_info(request, options = nil)
            #   Pass arguments to `get_quota_info` via a request object, either of type
            #   {::Google::Cloud::CloudQuotas::V1beta::GetQuotaInfoRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudQuotas::V1beta::GetQuotaInfoRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_quota_info(name: nil)
            #   Pass arguments to `get_quota_info` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the quota info.
            #
            #     An example name:
            #     `projects/123/locations/global/services/compute.googleapis.com/quotaInfos/CpusPerProjectPerRegion`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::CloudQuotas::V1beta::QuotaInfo]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::CloudQuotas::V1beta::QuotaInfo]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_quotas/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudQuotas::V1beta::CloudQuotas::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudQuotas::V1beta::GetQuotaInfoRequest.new
            #
            #   # Call the get_quota_info method.
            #   result = client.get_quota_info request
            #
            #   # The returned object is of type Google::Cloud::CloudQuotas::V1beta::QuotaInfo.
            #   p result
            #
            def get_quota_info request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudQuotas::V1beta::GetQuotaInfoRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_quota_info.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudQuotas::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_quota_info.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_quota_info.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cloud_quotas_stub.call_rpc :get_quota_info, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists QuotaPreferences in a given project, folder or organization.
            #
            # @overload list_quota_preferences(request, options = nil)
            #   Pass arguments to `list_quota_preferences` via a request object, either of type
            #   {::Google::Cloud::CloudQuotas::V1beta::ListQuotaPreferencesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudQuotas::V1beta::ListQuotaPreferencesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_quota_preferences(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_quota_preferences` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Parent value of QuotaPreference resources.
            #     Listing across different resource containers (such as 'projects/-') is not
            #     allowed.
            #
            #     When the value starts with 'folders' or 'organizations', it lists the
            #     QuotaPreferences for org quotas in the container. It does not list the
            #     QuotaPreferences in the descendant projects of the container.
            #
            #     Example parents:
            #     `projects/123/locations/global`
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer items than
            #     requested. If unspecified, server will pick an appropriate default.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results the server should return.
            #   @param filter [::String]
            #     Optional. Filter result QuotaPreferences by their state, type,
            #     create/update time range.
            #
            #     Example filters:
            #     `reconciling=true AND request_type=CLOUD_CONSOLE`,
            #     `reconciling=true OR creation_time>2022-12-03T10:30:00`
            #   @param order_by [::String]
            #     Optional. How to order of the results. By default, the results are ordered
            #     by create time.
            #
            #     Example orders:
            #     `quota_id`,
            #     `service, create_time`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::CloudQuotas::V1beta::QuotaPreference>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::CloudQuotas::V1beta::QuotaPreference>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_quotas/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudQuotas::V1beta::CloudQuotas::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudQuotas::V1beta::ListQuotaPreferencesRequest.new
            #
            #   # Call the list_quota_preferences method.
            #   result = client.list_quota_preferences request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::CloudQuotas::V1beta::QuotaPreference.
            #     p item
            #   end
            #
            def list_quota_preferences request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudQuotas::V1beta::ListQuotaPreferencesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_quota_preferences.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudQuotas::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_quota_preferences.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_quota_preferences.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cloud_quotas_stub.call_rpc :list_quota_preferences, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @cloud_quotas_stub, :list_quota_preferences, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single QuotaPreference.
            #
            # @overload get_quota_preference(request, options = nil)
            #   Pass arguments to `get_quota_preference` via a request object, either of type
            #   {::Google::Cloud::CloudQuotas::V1beta::GetQuotaPreferenceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudQuotas::V1beta::GetQuotaPreferenceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_quota_preference(name: nil)
            #   Pass arguments to `get_quota_preference` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the resource
            #
            #     Example name:
            #     `projects/123/locations/global/quota_preferences/my-config-for-us-east1`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::CloudQuotas::V1beta::QuotaPreference]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::CloudQuotas::V1beta::QuotaPreference]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_quotas/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudQuotas::V1beta::CloudQuotas::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudQuotas::V1beta::GetQuotaPreferenceRequest.new
            #
            #   # Call the get_quota_preference method.
            #   result = client.get_quota_preference request
            #
            #   # The returned object is of type Google::Cloud::CloudQuotas::V1beta::QuotaPreference.
            #   p result
            #
            def get_quota_preference request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudQuotas::V1beta::GetQuotaPreferenceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_quota_preference.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudQuotas::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_quota_preference.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_quota_preference.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cloud_quotas_stub.call_rpc :get_quota_preference, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new QuotaPreference that declares the desired value for a quota.
            #
            # @overload create_quota_preference(request, options = nil)
            #   Pass arguments to `create_quota_preference` via a request object, either of type
            #   {::Google::Cloud::CloudQuotas::V1beta::CreateQuotaPreferenceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudQuotas::V1beta::CreateQuotaPreferenceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_quota_preference(parent: nil, quota_preference_id: nil, quota_preference: nil, ignore_safety_checks: nil)
            #   Pass arguments to `create_quota_preference` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Value for parent.
            #
            #     Example:
            #     `projects/123/locations/global`
            #   @param quota_preference_id [::String]
            #     Optional. Id of the requesting object, must be unique under its parent.
            #     If client does not set this field, the service will generate one.
            #   @param quota_preference [::Google::Cloud::CloudQuotas::V1beta::QuotaPreference, ::Hash]
            #     Required. The resource being created
            #   @param ignore_safety_checks [::Array<::Google::Cloud::CloudQuotas::V1beta::QuotaSafetyCheck>]
            #     The list of quota safety checks to be ignored.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::CloudQuotas::V1beta::QuotaPreference]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::CloudQuotas::V1beta::QuotaPreference]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_quotas/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudQuotas::V1beta::CloudQuotas::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudQuotas::V1beta::CreateQuotaPreferenceRequest.new
            #
            #   # Call the create_quota_preference method.
            #   result = client.create_quota_preference request
            #
            #   # The returned object is of type Google::Cloud::CloudQuotas::V1beta::QuotaPreference.
            #   p result
            #
            def create_quota_preference request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudQuotas::V1beta::CreateQuotaPreferenceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_quota_preference.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudQuotas::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_quota_preference.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_quota_preference.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cloud_quotas_stub.call_rpc :create_quota_preference, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of a single QuotaPreference. It can updates the
            # config in any states, not just the ones pending approval.
            #
            # @overload update_quota_preference(request, options = nil)
            #   Pass arguments to `update_quota_preference` via a request object, either of type
            #   {::Google::Cloud::CloudQuotas::V1beta::UpdateQuotaPreferenceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudQuotas::V1beta::UpdateQuotaPreferenceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_quota_preference(update_mask: nil, quota_preference: nil, allow_missing: nil, validate_only: nil, ignore_safety_checks: nil)
            #   Pass arguments to `update_quota_preference` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. Field mask is used to specify the fields to be overwritten in the
            #     QuotaPreference resource by the update.
            #     The fields specified in the update_mask are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then all fields will be overwritten.
            #   @param quota_preference [::Google::Cloud::CloudQuotas::V1beta::QuotaPreference, ::Hash]
            #     Required. The resource being updated
            #   @param allow_missing [::Boolean]
            #     Optional. If set to true, and the quota preference is not found, a new one
            #     will be created. In this situation, `update_mask` is ignored.
            #   @param validate_only [::Boolean]
            #     Optional. If set to true, validate the request, but do not actually update.
            #     Note that a request being valid does not mean that the request is
            #     guaranteed to be fulfilled.
            #   @param ignore_safety_checks [::Array<::Google::Cloud::CloudQuotas::V1beta::QuotaSafetyCheck>]
            #     The list of quota safety checks to be ignored.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::CloudQuotas::V1beta::QuotaPreference]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::CloudQuotas::V1beta::QuotaPreference]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_quotas/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudQuotas::V1beta::CloudQuotas::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudQuotas::V1beta::UpdateQuotaPreferenceRequest.new
            #
            #   # Call the update_quota_preference method.
            #   result = client.update_quota_preference request
            #
            #   # The returned object is of type Google::Cloud::CloudQuotas::V1beta::QuotaPreference.
            #   p result
            #
            def update_quota_preference request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudQuotas::V1beta::UpdateQuotaPreferenceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_quota_preference.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudQuotas::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.quota_preference&.name
                header_params["quota_preference.name"] = request.quota_preference.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_quota_preference.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_quota_preference.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cloud_quotas_stub.call_rpc :update_quota_preference, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the CloudQuotas API.
            #
            # This class represents the configuration for CloudQuotas,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::CloudQuotas::V1beta::CloudQuotas::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # list_quota_infos to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::CloudQuotas::V1beta::CloudQuotas::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_quota_infos.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::CloudQuotas::V1beta::CloudQuotas::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_quota_infos.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::CloudQuotas::V1beta::CloudQuotas::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "cloudquotas.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the CloudQuotas API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `list_quota_infos`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_quota_infos
                ##
                # RPC-specific configuration for `get_quota_info`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_quota_info
                ##
                # RPC-specific configuration for `list_quota_preferences`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_quota_preferences
                ##
                # RPC-specific configuration for `get_quota_preference`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_quota_preference
                ##
                # RPC-specific configuration for `create_quota_preference`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_quota_preference
                ##
                # RPC-specific configuration for `update_quota_preference`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_quota_preference

                # @private
                def initialize parent_rpcs = nil
                  list_quota_infos_config = parent_rpcs.list_quota_infos if parent_rpcs.respond_to? :list_quota_infos
                  @list_quota_infos = ::Gapic::Config::Method.new list_quota_infos_config
                  get_quota_info_config = parent_rpcs.get_quota_info if parent_rpcs.respond_to? :get_quota_info
                  @get_quota_info = ::Gapic::Config::Method.new get_quota_info_config
                  list_quota_preferences_config = parent_rpcs.list_quota_preferences if parent_rpcs.respond_to? :list_quota_preferences
                  @list_quota_preferences = ::Gapic::Config::Method.new list_quota_preferences_config
                  get_quota_preference_config = parent_rpcs.get_quota_preference if parent_rpcs.respond_to? :get_quota_preference
                  @get_quota_preference = ::Gapic::Config::Method.new get_quota_preference_config
                  create_quota_preference_config = parent_rpcs.create_quota_preference if parent_rpcs.respond_to? :create_quota_preference
                  @create_quota_preference = ::Gapic::Config::Method.new create_quota_preference_config
                  update_quota_preference_config = parent_rpcs.update_quota_preference if parent_rpcs.respond_to? :update_quota_preference
                  @update_quota_preference = ::Gapic::Config::Method.new update_quota_preference_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
