# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/api/cloudquotas/v1/cloudquotas_pb"
require "google/cloud/cloud_quotas/v1/cloud_quotas/rest"


class ::Google::Cloud::CloudQuotas::V1::CloudQuotas::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_quota_infos
    # Create test objects.
    client_result = ::Google::Cloud::CloudQuotas::V1::ListQuotaInfosResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_quota_infos_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CloudQuotas::V1::CloudQuotas::Rest::ServiceStub.stub :transcode_list_quota_infos_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_quota_infos_client_stub do
        # Create client
        client = ::Google::Cloud::CloudQuotas::V1::CloudQuotas::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_quota_infos({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_quota_infos parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_quota_infos ::Google::Cloud::CloudQuotas::V1::ListQuotaInfosRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_quota_infos({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_quota_infos(::Google::Cloud::CloudQuotas::V1::ListQuotaInfosRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_quota_infos_client_stub.call_count
      end
    end
  end

  def test_get_quota_info
    # Create test objects.
    client_result = ::Google::Cloud::CloudQuotas::V1::QuotaInfo.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_quota_info_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CloudQuotas::V1::CloudQuotas::Rest::ServiceStub.stub :transcode_get_quota_info_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_quota_info_client_stub do
        # Create client
        client = ::Google::Cloud::CloudQuotas::V1::CloudQuotas::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_quota_info({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_quota_info name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_quota_info ::Google::Cloud::CloudQuotas::V1::GetQuotaInfoRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_quota_info({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_quota_info(::Google::Cloud::CloudQuotas::V1::GetQuotaInfoRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_quota_info_client_stub.call_count
      end
    end
  end

  def test_list_quota_preferences
    # Create test objects.
    client_result = ::Google::Cloud::CloudQuotas::V1::ListQuotaPreferencesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_quota_preferences_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CloudQuotas::V1::CloudQuotas::Rest::ServiceStub.stub :transcode_list_quota_preferences_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_quota_preferences_client_stub do
        # Create client
        client = ::Google::Cloud::CloudQuotas::V1::CloudQuotas::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_quota_preferences({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_quota_preferences parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_quota_preferences ::Google::Cloud::CloudQuotas::V1::ListQuotaPreferencesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_quota_preferences({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_quota_preferences(::Google::Cloud::CloudQuotas::V1::ListQuotaPreferencesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_quota_preferences_client_stub.call_count
      end
    end
  end

  def test_get_quota_preference
    # Create test objects.
    client_result = ::Google::Cloud::CloudQuotas::V1::QuotaPreference.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_quota_preference_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CloudQuotas::V1::CloudQuotas::Rest::ServiceStub.stub :transcode_get_quota_preference_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_quota_preference_client_stub do
        # Create client
        client = ::Google::Cloud::CloudQuotas::V1::CloudQuotas::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_quota_preference({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_quota_preference name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_quota_preference ::Google::Cloud::CloudQuotas::V1::GetQuotaPreferenceRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_quota_preference({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_quota_preference(::Google::Cloud::CloudQuotas::V1::GetQuotaPreferenceRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_quota_preference_client_stub.call_count
      end
    end
  end

  def test_create_quota_preference
    # Create test objects.
    client_result = ::Google::Cloud::CloudQuotas::V1::QuotaPreference.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    quota_preference_id = "hello world"
    quota_preference = {}
    ignore_safety_checks = [:QUOTA_SAFETY_CHECK_UNSPECIFIED]

    create_quota_preference_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CloudQuotas::V1::CloudQuotas::Rest::ServiceStub.stub :transcode_create_quota_preference_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_quota_preference_client_stub do
        # Create client
        client = ::Google::Cloud::CloudQuotas::V1::CloudQuotas::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_quota_preference({ parent: parent, quota_preference_id: quota_preference_id, quota_preference: quota_preference, ignore_safety_checks: ignore_safety_checks }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_quota_preference parent: parent, quota_preference_id: quota_preference_id, quota_preference: quota_preference, ignore_safety_checks: ignore_safety_checks do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_quota_preference ::Google::Cloud::CloudQuotas::V1::CreateQuotaPreferenceRequest.new(parent: parent, quota_preference_id: quota_preference_id, quota_preference: quota_preference, ignore_safety_checks: ignore_safety_checks) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_quota_preference({ parent: parent, quota_preference_id: quota_preference_id, quota_preference: quota_preference, ignore_safety_checks: ignore_safety_checks }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_quota_preference(::Google::Cloud::CloudQuotas::V1::CreateQuotaPreferenceRequest.new(parent: parent, quota_preference_id: quota_preference_id, quota_preference: quota_preference, ignore_safety_checks: ignore_safety_checks), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_quota_preference_client_stub.call_count
      end
    end
  end

  def test_update_quota_preference
    # Create test objects.
    client_result = ::Google::Cloud::CloudQuotas::V1::QuotaPreference.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    quota_preference = {}
    allow_missing = true
    validate_only = true
    ignore_safety_checks = [:QUOTA_SAFETY_CHECK_UNSPECIFIED]

    update_quota_preference_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CloudQuotas::V1::CloudQuotas::Rest::ServiceStub.stub :transcode_update_quota_preference_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_quota_preference_client_stub do
        # Create client
        client = ::Google::Cloud::CloudQuotas::V1::CloudQuotas::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_quota_preference({ update_mask: update_mask, quota_preference: quota_preference, allow_missing: allow_missing, validate_only: validate_only, ignore_safety_checks: ignore_safety_checks }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_quota_preference update_mask: update_mask, quota_preference: quota_preference, allow_missing: allow_missing, validate_only: validate_only, ignore_safety_checks: ignore_safety_checks do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_quota_preference ::Google::Cloud::CloudQuotas::V1::UpdateQuotaPreferenceRequest.new(update_mask: update_mask, quota_preference: quota_preference, allow_missing: allow_missing, validate_only: validate_only, ignore_safety_checks: ignore_safety_checks) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_quota_preference({ update_mask: update_mask, quota_preference: quota_preference, allow_missing: allow_missing, validate_only: validate_only, ignore_safety_checks: ignore_safety_checks }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_quota_preference(::Google::Cloud::CloudQuotas::V1::UpdateQuotaPreferenceRequest.new(update_mask: update_mask, quota_preference: quota_preference, allow_missing: allow_missing, validate_only: validate_only, ignore_safety_checks: ignore_safety_checks), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_quota_preference_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::CloudQuotas::V1::CloudQuotas::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::CloudQuotas::V1::CloudQuotas::Rest::Client::Configuration, config
  end
end
