# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module CloudQuotas
      module V1
        # QuotaInfo represents information about a particular quota for a given
        # project, folder or organization.
        # @!attribute [rw] name
        #   @return [::String]
        #     Resource name of this QuotaInfo.
        #     The ID component following "locations/" must be "global".
        #     Example:
        #     `projects/123/locations/global/services/compute.googleapis.com/quotaInfos/CpusPerProjectPerRegion`
        # @!attribute [rw] quota_id
        #   @return [::String]
        #     The id of the quota, which is unquie within the service.
        #     Example: `CpusPerProjectPerRegion`
        # @!attribute [rw] metric
        #   @return [::String]
        #     The metric of the quota. It specifies the resources consumption the quota
        #     is defined for.
        #     Example: `compute.googleapis.com/cpus`
        # @!attribute [rw] service
        #   @return [::String]
        #     The name of the service in which the quota is defined.
        #     Example: `compute.googleapis.com`
        # @!attribute [rw] is_precise
        #   @return [::Boolean]
        #     Whether this is a precise quota. A precise quota is tracked with absolute
        #     precision. In contrast, an imprecise quota is not tracked with precision.
        # @!attribute [rw] refresh_interval
        #   @return [::String]
        #     The reset time interval for the quota. Refresh interval applies to rate
        #     quota only.
        #     Example: "minute" for per minute, "day" for per day, or "10 seconds" for
        #     every 10 seconds.
        # @!attribute [rw] container_type
        #   @return [::Google::Cloud::CloudQuotas::V1::QuotaInfo::ContainerType]
        #     The container type of the QuotaInfo.
        # @!attribute [rw] dimensions
        #   @return [::Array<::String>]
        #     The dimensions the quota is defined on.
        # @!attribute [rw] metric_display_name
        #   @return [::String]
        #     The display name of the quota metric
        # @!attribute [rw] quota_display_name
        #   @return [::String]
        #     The display name of the quota.
        # @!attribute [rw] metric_unit
        #   @return [::String]
        #     The unit in which the metric value is reported, e.g., "MByte".
        # @!attribute [rw] quota_increase_eligibility
        #   @return [::Google::Cloud::CloudQuotas::V1::QuotaIncreaseEligibility]
        #     Whether it is eligible to request a higher quota value for this quota.
        # @!attribute [rw] is_fixed
        #   @return [::Boolean]
        #     Whether the quota value is fixed or adjustable
        # @!attribute [rw] dimensions_infos
        #   @return [::Array<::Google::Cloud::CloudQuotas::V1::DimensionsInfo>]
        #     The collection of dimensions info ordered by their dimensions from more
        #     specific ones to less specific ones.
        # @!attribute [rw] is_concurrent
        #   @return [::Boolean]
        #     Whether the quota is a concurrent quota. Concurrent quotas are enforced
        #     on the total number of concurrent operations in flight at any given time.
        # @!attribute [rw] service_request_quota_uri
        #   @return [::String]
        #     URI to the page where users can request more quota for the cloud
        #     service—for example,
        #     https://console.cloud.google.com/iam-admin/quotas.
        class QuotaInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The enumeration of the types of a cloud resource container.
          module ContainerType
            # Unspecified container type.
            CONTAINER_TYPE_UNSPECIFIED = 0

            # consumer project
            PROJECT = 1

            # folder
            FOLDER = 2

            # organization
            ORGANIZATION = 3
          end
        end

        # Eligibility information regarding requesting increase adjustment of a quota.
        # @!attribute [rw] is_eligible
        #   @return [::Boolean]
        #     Whether a higher quota value can be requested for the quota.
        # @!attribute [rw] ineligibility_reason
        #   @return [::Google::Cloud::CloudQuotas::V1::QuotaIncreaseEligibility::IneligibilityReason]
        #     The reason of why it is ineligible to request increased value of the quota.
        #     If the is_eligible field is true, it defaults to
        #     INELIGIBILITY_REASON_UNSPECIFIED.
        class QuotaIncreaseEligibility
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The enumeration of reasons when it is ineligible to request increase
          # adjustment.
          module IneligibilityReason
            # Default value when is_eligible is true.
            INELIGIBILITY_REASON_UNSPECIFIED = 0

            # The container is not linked with a valid billing account.
            NO_VALID_BILLING_ACCOUNT = 1

            # Quota increase is not supported for the quota.
            NOT_SUPPORTED = 3

            # There is not enough usage history to determine the eligibility.
            NOT_ENOUGH_USAGE_HISTORY = 4

            # Other reasons.
            OTHER = 2
          end
        end

        # QuotaPreference represents the preferred quota configuration specified for
        # a project, folder or organization. There is only one QuotaPreference
        # resource for a quota value targeting a unique set of dimensions.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required except in the CREATE requests.
        #     The resource name of the quota preference.
        #     The ID component following "locations/" must be "global".
        #     Example:
        #     `projects/123/locations/global/quotaPreferences/my-config-for-us-east1`
        # @!attribute [rw] dimensions
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Immutable. The dimensions that this quota preference applies to. The key of
        #     the map entry is the name of a dimension, such as "region", "zone",
        #     "network_id", and the value of the map entry is the dimension value.
        #
        #     If a dimension is missing from the map of dimensions, the quota preference
        #     applies to all the dimension values except for those that have other quota
        #     preferences configured for the specific value.
        #
        #     NOTE: QuotaPreferences can only be applied across all values of "user" and
        #     "resource" dimension. Do not set values for "user" or "resource" in the
        #     dimension map.
        #
        #     Example: \\{"provider", "Foo Inc"} where "provider" is a service specific
        #     dimension.
        # @!attribute [rw] quota_config
        #   @return [::Google::Cloud::CloudQuotas::V1::QuotaConfig]
        #     Required. Preferred quota configuration.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. The current etag of the quota preference. If an etag is provided
        #     on update and does not match the current server's etag of the quota
        #     preference, the request will be blocked and an ABORTED error will be
        #     returned. See https://google.aip.dev/134#etags for more details on etags.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Create time stamp
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Update time stamp
        # @!attribute [rw] service
        #   @return [::String]
        #     Required. The name of the service to which the quota preference is applied.
        # @!attribute [rw] quota_id
        #   @return [::String]
        #     Required. The id of the quota to which the quota preference is applied. A
        #     quota name is unique in the service. Example: `CpusPerProjectPerRegion`
        # @!attribute [r] reconciling
        #   @return [::Boolean]
        #     Output only. Is the quota preference pending Google Cloud approval and
        #     fulfillment.
        # @!attribute [rw] justification
        #   @return [::String]
        #     The reason / justification for this quota preference.
        # @!attribute [rw] contact_email
        #   @return [::String]
        #     Input only. An email address that can be used to contact the the user, in
        #     case Google Cloud needs more information to make a decision before
        #     additional quota can be granted.
        #
        #     When requesting a quota increase, the email address is required.
        #     When requesting a quota decrease, the email address is optional.
        #     For example, the email address is optional when the
        #     `QuotaConfig.preferred_value` is smaller than the
        #     `QuotaDetails.reset_value`.
        class QuotaPreference
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class DimensionsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The preferred quota configuration.
        # @!attribute [rw] preferred_value
        #   @return [::Integer]
        #     Required. The preferred value. Must be greater than or equal to -1. If set
        #     to -1, it means the value is "unlimited".
        # @!attribute [r] state_detail
        #   @return [::String]
        #     Output only. Optional details about the state of this quota preference.
        # @!attribute [r] granted_value
        #   @return [::Google::Protobuf::Int64Value]
        #     Output only. Granted quota value.
        # @!attribute [r] trace_id
        #   @return [::String]
        #     Output only. The trace id that the Google Cloud uses to provision the
        #     requested quota. This trace id may be used by the client to contact Cloud
        #     support to track the state of a quota preference request. The trace id is
        #     only produced for increase requests and is unique for each request. The
        #     quota decrease requests do not have a trace id.
        # @!attribute [rw] annotations
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. The annotations map for clients to store small amounts of
        #     arbitrary data. Do not put PII or other sensitive information here. See
        #     https://google.aip.dev/128#annotations
        # @!attribute [r] request_origin
        #   @return [::Google::Cloud::CloudQuotas::V1::QuotaConfig::Origin]
        #     Output only. The origin of the quota preference request.
        class QuotaConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AnnotationsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The enumeration of the origins of quota preference requests.
          module Origin
            # The unspecified value.
            ORIGIN_UNSPECIFIED = 0

            # Created through Cloud Console.
            CLOUD_CONSOLE = 1

            # Generated by automatic quota adjustment.
            AUTO_ADJUSTER = 2
          end
        end

        # The detailed quota information such as effective quota value for a
        # combination of dimensions.
        # @!attribute [rw] dimensions
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     The map of dimensions for this dimensions info. The key of a map entry
        #     is "region", "zone" or the name of a service specific dimension, and the
        #     value of a map entry is the value of the dimension.  If a dimension does
        #     not appear in the map of dimensions, the dimensions info applies to all
        #     the dimension values except for those that have another DimenisonInfo
        #     instance configured for the specific value.
        #     Example: \\{"provider" : "Foo Inc"} where "provider" is a service specific
        #     dimension of a quota.
        # @!attribute [rw] details
        #   @return [::Google::Cloud::CloudQuotas::V1::QuotaDetails]
        #     Quota details for the specified dimensions.
        # @!attribute [rw] applicable_locations
        #   @return [::Array<::String>]
        #     The applicable regions or zones of this dimensions info. The field will be
        #     set to ['global'] for quotas that are not per region or per zone.
        #     Otherwise, it will be set to the list of locations this dimension info is
        #     applicable to.
        class DimensionsInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class DimensionsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The quota details for a map of dimensions.
        # @!attribute [rw] value
        #   @return [::Integer]
        #     The value currently in effect and being enforced.
        # @!attribute [rw] rollout_info
        #   @return [::Google::Cloud::CloudQuotas::V1::RolloutInfo]
        #     Rollout information of this quota.
        #     This field is present only if the effective limit will change due to the
        #     ongoing rollout of the service config.
        class QuotaDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # [Output only] Rollout information of a quota.
        # @!attribute [rw] ongoing_rollout
        #   @return [::Boolean]
        #     Whether there is an ongoing rollout for a quota or not.
        class RolloutInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Enumerations of quota safety checks.
        module QuotaSafetyCheck
          # Unspecified quota safety check.
          QUOTA_SAFETY_CHECK_UNSPECIFIED = 0

          # Validates that a quota mutation would not cause the consumer's effective
          # limit to be lower than the consumer's quota usage.
          QUOTA_DECREASE_BELOW_USAGE = 1

          # Validates that a quota mutation would not cause the consumer's effective
          # limit to decrease by more than 10 percent.
          QUOTA_DECREASE_PERCENTAGE_TOO_HIGH = 2
        end
      end
    end
  end
end
