# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/clouddms/v1/clouddms_pb"
require "google/cloud/cloud_dms/v1/data_migration_service"

class ::Google::Cloud::CloudDMS::V1::DataMigrationService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_migration_jobs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CloudDMS::V1::ListMigrationJobsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_migration_jobs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_migration_jobs, name
      assert_kind_of ::Google::Cloud::CloudDMS::V1::ListMigrationJobsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_migration_jobs_client_stub do
      # Create client
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_migration_jobs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_migration_jobs parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_migration_jobs ::Google::Cloud::CloudDMS::V1::ListMigrationJobsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_migration_jobs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_migration_jobs(::Google::Cloud::CloudDMS::V1::ListMigrationJobsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_migration_jobs_client_stub.call_rpc_count
    end
  end

  def test_get_migration_job
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CloudDMS::V1::MigrationJob.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_migration_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_migration_job, name
      assert_kind_of ::Google::Cloud::CloudDMS::V1::GetMigrationJobRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_migration_job_client_stub do
      # Create client
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_migration_job({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_migration_job name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_migration_job ::Google::Cloud::CloudDMS::V1::GetMigrationJobRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_migration_job({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_migration_job(::Google::Cloud::CloudDMS::V1::GetMigrationJobRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_migration_job_client_stub.call_rpc_count
    end
  end

  def test_create_migration_job
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    migration_job_id = "hello world"
    migration_job = {}
    request_id = "hello world"

    create_migration_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_migration_job, name
      assert_kind_of ::Google::Cloud::CloudDMS::V1::CreateMigrationJobRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["migration_job_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::CloudDMS::V1::MigrationJob), request["migration_job"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_migration_job_client_stub do
      # Create client
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_migration_job({ parent: parent, migration_job_id: migration_job_id, migration_job: migration_job, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_migration_job parent: parent, migration_job_id: migration_job_id, migration_job: migration_job, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_migration_job ::Google::Cloud::CloudDMS::V1::CreateMigrationJobRequest.new(parent: parent, migration_job_id: migration_job_id, migration_job: migration_job, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_migration_job({ parent: parent, migration_job_id: migration_job_id, migration_job: migration_job, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_migration_job(::Google::Cloud::CloudDMS::V1::CreateMigrationJobRequest.new(parent: parent, migration_job_id: migration_job_id, migration_job: migration_job, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_migration_job_client_stub.call_rpc_count
    end
  end

  def test_update_migration_job
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    migration_job = {}
    request_id = "hello world"

    update_migration_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_migration_job, name
      assert_kind_of ::Google::Cloud::CloudDMS::V1::UpdateMigrationJobRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::CloudDMS::V1::MigrationJob), request["migration_job"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_migration_job_client_stub do
      # Create client
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_migration_job({ update_mask: update_mask, migration_job: migration_job, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_migration_job update_mask: update_mask, migration_job: migration_job, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_migration_job ::Google::Cloud::CloudDMS::V1::UpdateMigrationJobRequest.new(update_mask: update_mask, migration_job: migration_job, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_migration_job({ update_mask: update_mask, migration_job: migration_job, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_migration_job(::Google::Cloud::CloudDMS::V1::UpdateMigrationJobRequest.new(update_mask: update_mask, migration_job: migration_job, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_migration_job_client_stub.call_rpc_count
    end
  end

  def test_delete_migration_job
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    force = true

    delete_migration_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_migration_job, name
      assert_kind_of ::Google::Cloud::CloudDMS::V1::DeleteMigrationJobRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_migration_job_client_stub do
      # Create client
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_migration_job({ name: name, request_id: request_id, force: force }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_migration_job name: name, request_id: request_id, force: force do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_migration_job ::Google::Cloud::CloudDMS::V1::DeleteMigrationJobRequest.new(name: name, request_id: request_id, force: force) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_migration_job({ name: name, request_id: request_id, force: force }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_migration_job(::Google::Cloud::CloudDMS::V1::DeleteMigrationJobRequest.new(name: name, request_id: request_id, force: force), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_migration_job_client_stub.call_rpc_count
    end
  end

  def test_start_migration_job
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    skip_validation = true

    start_migration_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :start_migration_job, name
      assert_kind_of ::Google::Cloud::CloudDMS::V1::StartMigrationJobRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["skip_validation"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, start_migration_job_client_stub do
      # Create client
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.start_migration_job({ name: name, skip_validation: skip_validation }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.start_migration_job name: name, skip_validation: skip_validation do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.start_migration_job ::Google::Cloud::CloudDMS::V1::StartMigrationJobRequest.new(name: name, skip_validation: skip_validation) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.start_migration_job({ name: name, skip_validation: skip_validation }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.start_migration_job(::Google::Cloud::CloudDMS::V1::StartMigrationJobRequest.new(name: name, skip_validation: skip_validation), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, start_migration_job_client_stub.call_rpc_count
    end
  end

  def test_stop_migration_job
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    stop_migration_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :stop_migration_job, name
      assert_kind_of ::Google::Cloud::CloudDMS::V1::StopMigrationJobRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, stop_migration_job_client_stub do
      # Create client
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.stop_migration_job({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.stop_migration_job name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.stop_migration_job ::Google::Cloud::CloudDMS::V1::StopMigrationJobRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.stop_migration_job({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.stop_migration_job(::Google::Cloud::CloudDMS::V1::StopMigrationJobRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, stop_migration_job_client_stub.call_rpc_count
    end
  end

  def test_resume_migration_job
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    resume_migration_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :resume_migration_job, name
      assert_kind_of ::Google::Cloud::CloudDMS::V1::ResumeMigrationJobRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, resume_migration_job_client_stub do
      # Create client
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.resume_migration_job({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.resume_migration_job name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.resume_migration_job ::Google::Cloud::CloudDMS::V1::ResumeMigrationJobRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.resume_migration_job({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.resume_migration_job(::Google::Cloud::CloudDMS::V1::ResumeMigrationJobRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, resume_migration_job_client_stub.call_rpc_count
    end
  end

  def test_promote_migration_job
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    promote_migration_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :promote_migration_job, name
      assert_kind_of ::Google::Cloud::CloudDMS::V1::PromoteMigrationJobRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, promote_migration_job_client_stub do
      # Create client
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.promote_migration_job({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.promote_migration_job name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.promote_migration_job ::Google::Cloud::CloudDMS::V1::PromoteMigrationJobRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.promote_migration_job({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.promote_migration_job(::Google::Cloud::CloudDMS::V1::PromoteMigrationJobRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, promote_migration_job_client_stub.call_rpc_count
    end
  end

  def test_verify_migration_job
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    update_mask = {}
    migration_job = {}

    verify_migration_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :verify_migration_job, name
      assert_kind_of ::Google::Cloud::CloudDMS::V1::VerifyMigrationJobRequest, request
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::CloudDMS::V1::MigrationJob), request["migration_job"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, verify_migration_job_client_stub do
      # Create client
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.verify_migration_job({ name: name, update_mask: update_mask, migration_job: migration_job }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.verify_migration_job name: name, update_mask: update_mask, migration_job: migration_job do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.verify_migration_job ::Google::Cloud::CloudDMS::V1::VerifyMigrationJobRequest.new(name: name, update_mask: update_mask, migration_job: migration_job) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.verify_migration_job({ name: name, update_mask: update_mask, migration_job: migration_job }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.verify_migration_job(::Google::Cloud::CloudDMS::V1::VerifyMigrationJobRequest.new(name: name, update_mask: update_mask, migration_job: migration_job), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, verify_migration_job_client_stub.call_rpc_count
    end
  end

  def test_restart_migration_job
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    skip_validation = true

    restart_migration_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :restart_migration_job, name
      assert_kind_of ::Google::Cloud::CloudDMS::V1::RestartMigrationJobRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["skip_validation"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, restart_migration_job_client_stub do
      # Create client
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.restart_migration_job({ name: name, skip_validation: skip_validation }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.restart_migration_job name: name, skip_validation: skip_validation do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.restart_migration_job ::Google::Cloud::CloudDMS::V1::RestartMigrationJobRequest.new(name: name, skip_validation: skip_validation) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.restart_migration_job({ name: name, skip_validation: skip_validation }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.restart_migration_job(::Google::Cloud::CloudDMS::V1::RestartMigrationJobRequest.new(name: name, skip_validation: skip_validation), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, restart_migration_job_client_stub.call_rpc_count
    end
  end

  def test_generate_ssh_script
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CloudDMS::V1::SshScript.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    migration_job = "hello world"
    vm = "hello world"
    vm_creation_config = {}
    vm_port = 42

    generate_ssh_script_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :generate_ssh_script, name
      assert_kind_of ::Google::Cloud::CloudDMS::V1::GenerateSshScriptRequest, request
      assert_equal "hello world", request["migration_job"]
      assert_equal "hello world", request["vm"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::CloudDMS::V1::VmCreationConfig), request["vm_creation_config"]
      assert_equal :vm_creation_config, request.vm_config
      assert_equal 42, request["vm_port"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, generate_ssh_script_client_stub do
      # Create client
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.generate_ssh_script({ migration_job: migration_job, vm: vm, vm_creation_config: vm_creation_config, vm_port: vm_port }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.generate_ssh_script migration_job: migration_job, vm: vm, vm_creation_config: vm_creation_config, vm_port: vm_port do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.generate_ssh_script ::Google::Cloud::CloudDMS::V1::GenerateSshScriptRequest.new(migration_job: migration_job, vm: vm, vm_creation_config: vm_creation_config, vm_port: vm_port) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.generate_ssh_script({ migration_job: migration_job, vm: vm, vm_creation_config: vm_creation_config, vm_port: vm_port }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.generate_ssh_script(::Google::Cloud::CloudDMS::V1::GenerateSshScriptRequest.new(migration_job: migration_job, vm: vm, vm_creation_config: vm_creation_config, vm_port: vm_port), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, generate_ssh_script_client_stub.call_rpc_count
    end
  end

  def test_generate_tcp_proxy_script
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CloudDMS::V1::TcpProxyScript.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    migration_job = "hello world"
    vm_name = "hello world"
    vm_machine_type = "hello world"
    vm_zone = "hello world"
    vm_subnet = "hello world"

    generate_tcp_proxy_script_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :generate_tcp_proxy_script, name
      assert_kind_of ::Google::Cloud::CloudDMS::V1::GenerateTcpProxyScriptRequest, request
      assert_equal "hello world", request["migration_job"]
      assert_equal "hello world", request["vm_name"]
      assert_equal "hello world", request["vm_machine_type"]
      assert_equal "hello world", request["vm_zone"]
      assert_equal "hello world", request["vm_subnet"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, generate_tcp_proxy_script_client_stub do
      # Create client
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.generate_tcp_proxy_script({ migration_job: migration_job, vm_name: vm_name, vm_machine_type: vm_machine_type, vm_zone: vm_zone, vm_subnet: vm_subnet }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.generate_tcp_proxy_script migration_job: migration_job, vm_name: vm_name, vm_machine_type: vm_machine_type, vm_zone: vm_zone, vm_subnet: vm_subnet do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.generate_tcp_proxy_script ::Google::Cloud::CloudDMS::V1::GenerateTcpProxyScriptRequest.new(migration_job: migration_job, vm_name: vm_name, vm_machine_type: vm_machine_type, vm_zone: vm_zone, vm_subnet: vm_subnet) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.generate_tcp_proxy_script({ migration_job: migration_job, vm_name: vm_name, vm_machine_type: vm_machine_type, vm_zone: vm_zone, vm_subnet: vm_subnet }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.generate_tcp_proxy_script(::Google::Cloud::CloudDMS::V1::GenerateTcpProxyScriptRequest.new(migration_job: migration_job, vm_name: vm_name, vm_machine_type: vm_machine_type, vm_zone: vm_zone, vm_subnet: vm_subnet), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, generate_tcp_proxy_script_client_stub.call_rpc_count
    end
  end

  def test_list_connection_profiles
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CloudDMS::V1::ListConnectionProfilesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_connection_profiles_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_connection_profiles, name
      assert_kind_of ::Google::Cloud::CloudDMS::V1::ListConnectionProfilesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_connection_profiles_client_stub do
      # Create client
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_connection_profiles({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_connection_profiles parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_connection_profiles ::Google::Cloud::CloudDMS::V1::ListConnectionProfilesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_connection_profiles({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_connection_profiles(::Google::Cloud::CloudDMS::V1::ListConnectionProfilesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_connection_profiles_client_stub.call_rpc_count
    end
  end

  def test_get_connection_profile
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CloudDMS::V1::ConnectionProfile.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_connection_profile_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_connection_profile, name
      assert_kind_of ::Google::Cloud::CloudDMS::V1::GetConnectionProfileRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_connection_profile_client_stub do
      # Create client
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_connection_profile({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_connection_profile name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_connection_profile ::Google::Cloud::CloudDMS::V1::GetConnectionProfileRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_connection_profile({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_connection_profile(::Google::Cloud::CloudDMS::V1::GetConnectionProfileRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_connection_profile_client_stub.call_rpc_count
    end
  end

  def test_create_connection_profile
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    connection_profile_id = "hello world"
    connection_profile = {}
    request_id = "hello world"
    validate_only = true
    skip_validation = true

    create_connection_profile_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_connection_profile, name
      assert_kind_of ::Google::Cloud::CloudDMS::V1::CreateConnectionProfileRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["connection_profile_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::CloudDMS::V1::ConnectionProfile), request["connection_profile"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      assert_equal true, request["skip_validation"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_connection_profile_client_stub do
      # Create client
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_connection_profile({ parent: parent, connection_profile_id: connection_profile_id, connection_profile: connection_profile, request_id: request_id, validate_only: validate_only, skip_validation: skip_validation }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_connection_profile parent: parent, connection_profile_id: connection_profile_id, connection_profile: connection_profile, request_id: request_id, validate_only: validate_only, skip_validation: skip_validation do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_connection_profile ::Google::Cloud::CloudDMS::V1::CreateConnectionProfileRequest.new(parent: parent, connection_profile_id: connection_profile_id, connection_profile: connection_profile, request_id: request_id, validate_only: validate_only, skip_validation: skip_validation) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_connection_profile({ parent: parent, connection_profile_id: connection_profile_id, connection_profile: connection_profile, request_id: request_id, validate_only: validate_only, skip_validation: skip_validation }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_connection_profile(::Google::Cloud::CloudDMS::V1::CreateConnectionProfileRequest.new(parent: parent, connection_profile_id: connection_profile_id, connection_profile: connection_profile, request_id: request_id, validate_only: validate_only, skip_validation: skip_validation), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_connection_profile_client_stub.call_rpc_count
    end
  end

  def test_update_connection_profile
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    connection_profile = {}
    request_id = "hello world"
    validate_only = true
    skip_validation = true

    update_connection_profile_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_connection_profile, name
      assert_kind_of ::Google::Cloud::CloudDMS::V1::UpdateConnectionProfileRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::CloudDMS::V1::ConnectionProfile), request["connection_profile"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      assert_equal true, request["skip_validation"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_connection_profile_client_stub do
      # Create client
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_connection_profile({ update_mask: update_mask, connection_profile: connection_profile, request_id: request_id, validate_only: validate_only, skip_validation: skip_validation }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_connection_profile update_mask: update_mask, connection_profile: connection_profile, request_id: request_id, validate_only: validate_only, skip_validation: skip_validation do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_connection_profile ::Google::Cloud::CloudDMS::V1::UpdateConnectionProfileRequest.new(update_mask: update_mask, connection_profile: connection_profile, request_id: request_id, validate_only: validate_only, skip_validation: skip_validation) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_connection_profile({ update_mask: update_mask, connection_profile: connection_profile, request_id: request_id, validate_only: validate_only, skip_validation: skip_validation }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_connection_profile(::Google::Cloud::CloudDMS::V1::UpdateConnectionProfileRequest.new(update_mask: update_mask, connection_profile: connection_profile, request_id: request_id, validate_only: validate_only, skip_validation: skip_validation), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_connection_profile_client_stub.call_rpc_count
    end
  end

  def test_delete_connection_profile
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    force = true

    delete_connection_profile_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_connection_profile, name
      assert_kind_of ::Google::Cloud::CloudDMS::V1::DeleteConnectionProfileRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_connection_profile_client_stub do
      # Create client
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_connection_profile({ name: name, request_id: request_id, force: force }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_connection_profile name: name, request_id: request_id, force: force do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_connection_profile ::Google::Cloud::CloudDMS::V1::DeleteConnectionProfileRequest.new(name: name, request_id: request_id, force: force) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_connection_profile({ name: name, request_id: request_id, force: force }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_connection_profile(::Google::Cloud::CloudDMS::V1::DeleteConnectionProfileRequest.new(name: name, request_id: request_id, force: force), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_connection_profile_client_stub.call_rpc_count
    end
  end

  def test_create_private_connection
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    private_connection_id = "hello world"
    private_connection = {}
    request_id = "hello world"
    skip_validation = true

    create_private_connection_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_private_connection, name
      assert_kind_of ::Google::Cloud::CloudDMS::V1::CreatePrivateConnectionRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["private_connection_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::CloudDMS::V1::PrivateConnection), request["private_connection"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["skip_validation"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_private_connection_client_stub do
      # Create client
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_private_connection({ parent: parent, private_connection_id: private_connection_id, private_connection: private_connection, request_id: request_id, skip_validation: skip_validation }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_private_connection parent: parent, private_connection_id: private_connection_id, private_connection: private_connection, request_id: request_id, skip_validation: skip_validation do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_private_connection ::Google::Cloud::CloudDMS::V1::CreatePrivateConnectionRequest.new(parent: parent, private_connection_id: private_connection_id, private_connection: private_connection, request_id: request_id, skip_validation: skip_validation) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_private_connection({ parent: parent, private_connection_id: private_connection_id, private_connection: private_connection, request_id: request_id, skip_validation: skip_validation }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_private_connection(::Google::Cloud::CloudDMS::V1::CreatePrivateConnectionRequest.new(parent: parent, private_connection_id: private_connection_id, private_connection: private_connection, request_id: request_id, skip_validation: skip_validation), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_private_connection_client_stub.call_rpc_count
    end
  end

  def test_get_private_connection
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CloudDMS::V1::PrivateConnection.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_private_connection_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_private_connection, name
      assert_kind_of ::Google::Cloud::CloudDMS::V1::GetPrivateConnectionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_private_connection_client_stub do
      # Create client
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_private_connection({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_private_connection name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_private_connection ::Google::Cloud::CloudDMS::V1::GetPrivateConnectionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_private_connection({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_private_connection(::Google::Cloud::CloudDMS::V1::GetPrivateConnectionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_private_connection_client_stub.call_rpc_count
    end
  end

  def test_list_private_connections
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CloudDMS::V1::ListPrivateConnectionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_private_connections_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_private_connections, name
      assert_kind_of ::Google::Cloud::CloudDMS::V1::ListPrivateConnectionsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_private_connections_client_stub do
      # Create client
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_private_connections({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_private_connections parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_private_connections ::Google::Cloud::CloudDMS::V1::ListPrivateConnectionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_private_connections({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_private_connections(::Google::Cloud::CloudDMS::V1::ListPrivateConnectionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_private_connections_client_stub.call_rpc_count
    end
  end

  def test_delete_private_connection
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_private_connection_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_private_connection, name
      assert_kind_of ::Google::Cloud::CloudDMS::V1::DeletePrivateConnectionRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_private_connection_client_stub do
      # Create client
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_private_connection({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_private_connection name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_private_connection ::Google::Cloud::CloudDMS::V1::DeletePrivateConnectionRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_private_connection({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_private_connection(::Google::Cloud::CloudDMS::V1::DeletePrivateConnectionRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_private_connection_client_stub.call_rpc_count
    end
  end

  def test_get_conversion_workspace
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CloudDMS::V1::ConversionWorkspace.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_conversion_workspace_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_conversion_workspace, name
      assert_kind_of ::Google::Cloud::CloudDMS::V1::GetConversionWorkspaceRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_conversion_workspace_client_stub do
      # Create client
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_conversion_workspace({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_conversion_workspace name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_conversion_workspace ::Google::Cloud::CloudDMS::V1::GetConversionWorkspaceRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_conversion_workspace({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_conversion_workspace(::Google::Cloud::CloudDMS::V1::GetConversionWorkspaceRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_conversion_workspace_client_stub.call_rpc_count
    end
  end

  def test_list_conversion_workspaces
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CloudDMS::V1::ListConversionWorkspacesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_conversion_workspaces_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_conversion_workspaces, name
      assert_kind_of ::Google::Cloud::CloudDMS::V1::ListConversionWorkspacesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_conversion_workspaces_client_stub do
      # Create client
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_conversion_workspaces({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_conversion_workspaces parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_conversion_workspaces ::Google::Cloud::CloudDMS::V1::ListConversionWorkspacesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_conversion_workspaces({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_conversion_workspaces(::Google::Cloud::CloudDMS::V1::ListConversionWorkspacesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_conversion_workspaces_client_stub.call_rpc_count
    end
  end

  def test_create_conversion_workspace
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    conversion_workspace_id = "hello world"
    conversion_workspace = {}
    request_id = "hello world"

    create_conversion_workspace_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_conversion_workspace, name
      assert_kind_of ::Google::Cloud::CloudDMS::V1::CreateConversionWorkspaceRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["conversion_workspace_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::CloudDMS::V1::ConversionWorkspace), request["conversion_workspace"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_conversion_workspace_client_stub do
      # Create client
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_conversion_workspace({ parent: parent, conversion_workspace_id: conversion_workspace_id, conversion_workspace: conversion_workspace, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_conversion_workspace parent: parent, conversion_workspace_id: conversion_workspace_id, conversion_workspace: conversion_workspace, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_conversion_workspace ::Google::Cloud::CloudDMS::V1::CreateConversionWorkspaceRequest.new(parent: parent, conversion_workspace_id: conversion_workspace_id, conversion_workspace: conversion_workspace, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_conversion_workspace({ parent: parent, conversion_workspace_id: conversion_workspace_id, conversion_workspace: conversion_workspace, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_conversion_workspace(::Google::Cloud::CloudDMS::V1::CreateConversionWorkspaceRequest.new(parent: parent, conversion_workspace_id: conversion_workspace_id, conversion_workspace: conversion_workspace, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_conversion_workspace_client_stub.call_rpc_count
    end
  end

  def test_update_conversion_workspace
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    conversion_workspace = {}
    request_id = "hello world"

    update_conversion_workspace_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_conversion_workspace, name
      assert_kind_of ::Google::Cloud::CloudDMS::V1::UpdateConversionWorkspaceRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::CloudDMS::V1::ConversionWorkspace), request["conversion_workspace"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_conversion_workspace_client_stub do
      # Create client
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_conversion_workspace({ update_mask: update_mask, conversion_workspace: conversion_workspace, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_conversion_workspace update_mask: update_mask, conversion_workspace: conversion_workspace, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_conversion_workspace ::Google::Cloud::CloudDMS::V1::UpdateConversionWorkspaceRequest.new(update_mask: update_mask, conversion_workspace: conversion_workspace, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_conversion_workspace({ update_mask: update_mask, conversion_workspace: conversion_workspace, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_conversion_workspace(::Google::Cloud::CloudDMS::V1::UpdateConversionWorkspaceRequest.new(update_mask: update_mask, conversion_workspace: conversion_workspace, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_conversion_workspace_client_stub.call_rpc_count
    end
  end

  def test_delete_conversion_workspace
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    force = true

    delete_conversion_workspace_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_conversion_workspace, name
      assert_kind_of ::Google::Cloud::CloudDMS::V1::DeleteConversionWorkspaceRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_conversion_workspace_client_stub do
      # Create client
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_conversion_workspace({ name: name, request_id: request_id, force: force }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_conversion_workspace name: name, request_id: request_id, force: force do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_conversion_workspace ::Google::Cloud::CloudDMS::V1::DeleteConversionWorkspaceRequest.new(name: name, request_id: request_id, force: force) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_conversion_workspace({ name: name, request_id: request_id, force: force }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_conversion_workspace(::Google::Cloud::CloudDMS::V1::DeleteConversionWorkspaceRequest.new(name: name, request_id: request_id, force: force), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_conversion_workspace_client_stub.call_rpc_count
    end
  end

  def test_create_mapping_rule
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CloudDMS::V1::MappingRule.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    mapping_rule_id = "hello world"
    mapping_rule = {}
    request_id = "hello world"

    create_mapping_rule_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_mapping_rule, name
      assert_kind_of ::Google::Cloud::CloudDMS::V1::CreateMappingRuleRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["mapping_rule_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::CloudDMS::V1::MappingRule), request["mapping_rule"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_mapping_rule_client_stub do
      # Create client
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_mapping_rule({ parent: parent, mapping_rule_id: mapping_rule_id, mapping_rule: mapping_rule, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_mapping_rule parent: parent, mapping_rule_id: mapping_rule_id, mapping_rule: mapping_rule, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_mapping_rule ::Google::Cloud::CloudDMS::V1::CreateMappingRuleRequest.new(parent: parent, mapping_rule_id: mapping_rule_id, mapping_rule: mapping_rule, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_mapping_rule({ parent: parent, mapping_rule_id: mapping_rule_id, mapping_rule: mapping_rule, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_mapping_rule(::Google::Cloud::CloudDMS::V1::CreateMappingRuleRequest.new(parent: parent, mapping_rule_id: mapping_rule_id, mapping_rule: mapping_rule, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_mapping_rule_client_stub.call_rpc_count
    end
  end

  def test_delete_mapping_rule
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_mapping_rule_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_mapping_rule, name
      assert_kind_of ::Google::Cloud::CloudDMS::V1::DeleteMappingRuleRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_mapping_rule_client_stub do
      # Create client
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_mapping_rule({ name: name, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_mapping_rule name: name, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_mapping_rule ::Google::Cloud::CloudDMS::V1::DeleteMappingRuleRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_mapping_rule({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_mapping_rule(::Google::Cloud::CloudDMS::V1::DeleteMappingRuleRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_mapping_rule_client_stub.call_rpc_count
    end
  end

  def test_list_mapping_rules
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CloudDMS::V1::ListMappingRulesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_mapping_rules_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_mapping_rules, name
      assert_kind_of ::Google::Cloud::CloudDMS::V1::ListMappingRulesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_mapping_rules_client_stub do
      # Create client
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_mapping_rules({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_mapping_rules parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_mapping_rules ::Google::Cloud::CloudDMS::V1::ListMappingRulesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_mapping_rules({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_mapping_rules(::Google::Cloud::CloudDMS::V1::ListMappingRulesRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_mapping_rules_client_stub.call_rpc_count
    end
  end

  def test_get_mapping_rule
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CloudDMS::V1::MappingRule.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_mapping_rule_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_mapping_rule, name
      assert_kind_of ::Google::Cloud::CloudDMS::V1::GetMappingRuleRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_mapping_rule_client_stub do
      # Create client
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_mapping_rule({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_mapping_rule name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_mapping_rule ::Google::Cloud::CloudDMS::V1::GetMappingRuleRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_mapping_rule({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_mapping_rule(::Google::Cloud::CloudDMS::V1::GetMappingRuleRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_mapping_rule_client_stub.call_rpc_count
    end
  end

  def test_seed_conversion_workspace
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    auto_commit = true
    source_connection_profile = "hello world"

    seed_conversion_workspace_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :seed_conversion_workspace, name
      assert_kind_of ::Google::Cloud::CloudDMS::V1::SeedConversionWorkspaceRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["auto_commit"]
      assert_equal "hello world", request["source_connection_profile"]
      assert_equal :source_connection_profile, request.seed_from
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, seed_conversion_workspace_client_stub do
      # Create client
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.seed_conversion_workspace({ name: name, auto_commit: auto_commit, source_connection_profile: source_connection_profile }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.seed_conversion_workspace name: name, auto_commit: auto_commit, source_connection_profile: source_connection_profile do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.seed_conversion_workspace ::Google::Cloud::CloudDMS::V1::SeedConversionWorkspaceRequest.new(name: name, auto_commit: auto_commit, source_connection_profile: source_connection_profile) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.seed_conversion_workspace({ name: name, auto_commit: auto_commit, source_connection_profile: source_connection_profile }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.seed_conversion_workspace(::Google::Cloud::CloudDMS::V1::SeedConversionWorkspaceRequest.new(name: name, auto_commit: auto_commit, source_connection_profile: source_connection_profile), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, seed_conversion_workspace_client_stub.call_rpc_count
    end
  end

  def test_import_mapping_rules
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    rules_format = :IMPORT_RULES_FILE_FORMAT_UNSPECIFIED
    rules_files = [{}]
    auto_commit = true

    import_mapping_rules_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :import_mapping_rules, name
      assert_kind_of ::Google::Cloud::CloudDMS::V1::ImportMappingRulesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal :IMPORT_RULES_FILE_FORMAT_UNSPECIFIED, request["rules_format"]
      assert_kind_of ::Google::Cloud::CloudDMS::V1::ImportMappingRulesRequest::RulesFile, request["rules_files"].first
      assert_equal true, request["auto_commit"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, import_mapping_rules_client_stub do
      # Create client
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.import_mapping_rules({ parent: parent, rules_format: rules_format, rules_files: rules_files, auto_commit: auto_commit }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.import_mapping_rules parent: parent, rules_format: rules_format, rules_files: rules_files, auto_commit: auto_commit do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.import_mapping_rules ::Google::Cloud::CloudDMS::V1::ImportMappingRulesRequest.new(parent: parent, rules_format: rules_format, rules_files: rules_files, auto_commit: auto_commit) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.import_mapping_rules({ parent: parent, rules_format: rules_format, rules_files: rules_files, auto_commit: auto_commit }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.import_mapping_rules(::Google::Cloud::CloudDMS::V1::ImportMappingRulesRequest.new(parent: parent, rules_format: rules_format, rules_files: rules_files, auto_commit: auto_commit), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, import_mapping_rules_client_stub.call_rpc_count
    end
  end

  def test_convert_conversion_workspace
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    auto_commit = true
    filter = "hello world"
    convert_full_path = true

    convert_conversion_workspace_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :convert_conversion_workspace, name
      assert_kind_of ::Google::Cloud::CloudDMS::V1::ConvertConversionWorkspaceRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["auto_commit"]
      assert_equal "hello world", request["filter"]
      assert_equal true, request["convert_full_path"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, convert_conversion_workspace_client_stub do
      # Create client
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.convert_conversion_workspace({ name: name, auto_commit: auto_commit, filter: filter, convert_full_path: convert_full_path }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.convert_conversion_workspace name: name, auto_commit: auto_commit, filter: filter, convert_full_path: convert_full_path do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.convert_conversion_workspace ::Google::Cloud::CloudDMS::V1::ConvertConversionWorkspaceRequest.new(name: name, auto_commit: auto_commit, filter: filter, convert_full_path: convert_full_path) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.convert_conversion_workspace({ name: name, auto_commit: auto_commit, filter: filter, convert_full_path: convert_full_path }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.convert_conversion_workspace(::Google::Cloud::CloudDMS::V1::ConvertConversionWorkspaceRequest.new(name: name, auto_commit: auto_commit, filter: filter, convert_full_path: convert_full_path), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, convert_conversion_workspace_client_stub.call_rpc_count
    end
  end

  def test_commit_conversion_workspace
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    commit_name = "hello world"

    commit_conversion_workspace_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :commit_conversion_workspace, name
      assert_kind_of ::Google::Cloud::CloudDMS::V1::CommitConversionWorkspaceRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["commit_name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, commit_conversion_workspace_client_stub do
      # Create client
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.commit_conversion_workspace({ name: name, commit_name: commit_name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.commit_conversion_workspace name: name, commit_name: commit_name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.commit_conversion_workspace ::Google::Cloud::CloudDMS::V1::CommitConversionWorkspaceRequest.new(name: name, commit_name: commit_name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.commit_conversion_workspace({ name: name, commit_name: commit_name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.commit_conversion_workspace(::Google::Cloud::CloudDMS::V1::CommitConversionWorkspaceRequest.new(name: name, commit_name: commit_name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, commit_conversion_workspace_client_stub.call_rpc_count
    end
  end

  def test_rollback_conversion_workspace
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    rollback_conversion_workspace_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :rollback_conversion_workspace, name
      assert_kind_of ::Google::Cloud::CloudDMS::V1::RollbackConversionWorkspaceRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, rollback_conversion_workspace_client_stub do
      # Create client
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.rollback_conversion_workspace({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.rollback_conversion_workspace name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.rollback_conversion_workspace ::Google::Cloud::CloudDMS::V1::RollbackConversionWorkspaceRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.rollback_conversion_workspace({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.rollback_conversion_workspace(::Google::Cloud::CloudDMS::V1::RollbackConversionWorkspaceRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, rollback_conversion_workspace_client_stub.call_rpc_count
    end
  end

  def test_apply_conversion_workspace
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    filter = "hello world"
    dry_run = true
    auto_commit = true
    connection_profile = "hello world"

    apply_conversion_workspace_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :apply_conversion_workspace, name
      assert_kind_of ::Google::Cloud::CloudDMS::V1::ApplyConversionWorkspaceRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["filter"]
      assert_equal true, request["dry_run"]
      assert_equal true, request["auto_commit"]
      assert_equal "hello world", request["connection_profile"]
      assert_equal :connection_profile, request.destination
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, apply_conversion_workspace_client_stub do
      # Create client
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.apply_conversion_workspace({ name: name, filter: filter, dry_run: dry_run, auto_commit: auto_commit, connection_profile: connection_profile }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.apply_conversion_workspace name: name, filter: filter, dry_run: dry_run, auto_commit: auto_commit, connection_profile: connection_profile do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.apply_conversion_workspace ::Google::Cloud::CloudDMS::V1::ApplyConversionWorkspaceRequest.new(name: name, filter: filter, dry_run: dry_run, auto_commit: auto_commit, connection_profile: connection_profile) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.apply_conversion_workspace({ name: name, filter: filter, dry_run: dry_run, auto_commit: auto_commit, connection_profile: connection_profile }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.apply_conversion_workspace(::Google::Cloud::CloudDMS::V1::ApplyConversionWorkspaceRequest.new(name: name, filter: filter, dry_run: dry_run, auto_commit: auto_commit, connection_profile: connection_profile), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, apply_conversion_workspace_client_stub.call_rpc_count
    end
  end

  def test_describe_database_entities
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CloudDMS::V1::DescribeDatabaseEntitiesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    conversion_workspace = "hello world"
    page_size = 42
    page_token = "hello world"
    tree = :DB_TREE_TYPE_UNSPECIFIED
    uncommitted = true
    commit_id = "hello world"
    filter = "hello world"
    view = :DATABASE_ENTITY_VIEW_UNSPECIFIED

    describe_database_entities_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :describe_database_entities, name
      assert_kind_of ::Google::Cloud::CloudDMS::V1::DescribeDatabaseEntitiesRequest, request
      assert_equal "hello world", request["conversion_workspace"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal :DB_TREE_TYPE_UNSPECIFIED, request["tree"]
      assert_equal true, request["uncommitted"]
      assert_equal "hello world", request["commit_id"]
      assert_equal "hello world", request["filter"]
      assert_equal :DATABASE_ENTITY_VIEW_UNSPECIFIED, request["view"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, describe_database_entities_client_stub do
      # Create client
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.describe_database_entities({ conversion_workspace: conversion_workspace, page_size: page_size, page_token: page_token, tree: tree, uncommitted: uncommitted, commit_id: commit_id, filter: filter, view: view }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.describe_database_entities conversion_workspace: conversion_workspace, page_size: page_size, page_token: page_token, tree: tree, uncommitted: uncommitted, commit_id: commit_id, filter: filter, view: view do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.describe_database_entities ::Google::Cloud::CloudDMS::V1::DescribeDatabaseEntitiesRequest.new(conversion_workspace: conversion_workspace, page_size: page_size, page_token: page_token, tree: tree, uncommitted: uncommitted, commit_id: commit_id, filter: filter, view: view) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.describe_database_entities({ conversion_workspace: conversion_workspace, page_size: page_size, page_token: page_token, tree: tree, uncommitted: uncommitted, commit_id: commit_id, filter: filter, view: view }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.describe_database_entities(::Google::Cloud::CloudDMS::V1::DescribeDatabaseEntitiesRequest.new(conversion_workspace: conversion_workspace, page_size: page_size, page_token: page_token, tree: tree, uncommitted: uncommitted, commit_id: commit_id, filter: filter, view: view), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, describe_database_entities_client_stub.call_rpc_count
    end
  end

  def test_search_background_jobs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CloudDMS::V1::SearchBackgroundJobsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    conversion_workspace = "hello world"
    return_most_recent_per_job_type = true
    max_size = 42
    completed_until_time = {}

    search_background_jobs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :search_background_jobs, name
      assert_kind_of ::Google::Cloud::CloudDMS::V1::SearchBackgroundJobsRequest, request
      assert_equal "hello world", request["conversion_workspace"]
      assert_equal true, request["return_most_recent_per_job_type"]
      assert_equal 42, request["max_size"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Timestamp), request["completed_until_time"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, search_background_jobs_client_stub do
      # Create client
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.search_background_jobs({ conversion_workspace: conversion_workspace, return_most_recent_per_job_type: return_most_recent_per_job_type, max_size: max_size, completed_until_time: completed_until_time }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.search_background_jobs conversion_workspace: conversion_workspace, return_most_recent_per_job_type: return_most_recent_per_job_type, max_size: max_size, completed_until_time: completed_until_time do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.search_background_jobs ::Google::Cloud::CloudDMS::V1::SearchBackgroundJobsRequest.new(conversion_workspace: conversion_workspace, return_most_recent_per_job_type: return_most_recent_per_job_type, max_size: max_size, completed_until_time: completed_until_time) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.search_background_jobs({ conversion_workspace: conversion_workspace, return_most_recent_per_job_type: return_most_recent_per_job_type, max_size: max_size, completed_until_time: completed_until_time }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.search_background_jobs(::Google::Cloud::CloudDMS::V1::SearchBackgroundJobsRequest.new(conversion_workspace: conversion_workspace, return_most_recent_per_job_type: return_most_recent_per_job_type, max_size: max_size, completed_until_time: completed_until_time), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, search_background_jobs_client_stub.call_rpc_count
    end
  end

  def test_describe_conversion_workspace_revisions
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CloudDMS::V1::DescribeConversionWorkspaceRevisionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    conversion_workspace = "hello world"
    commit_id = "hello world"

    describe_conversion_workspace_revisions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :describe_conversion_workspace_revisions, name
      assert_kind_of ::Google::Cloud::CloudDMS::V1::DescribeConversionWorkspaceRevisionsRequest, request
      assert_equal "hello world", request["conversion_workspace"]
      assert_equal "hello world", request["commit_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, describe_conversion_workspace_revisions_client_stub do
      # Create client
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.describe_conversion_workspace_revisions({ conversion_workspace: conversion_workspace, commit_id: commit_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.describe_conversion_workspace_revisions conversion_workspace: conversion_workspace, commit_id: commit_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.describe_conversion_workspace_revisions ::Google::Cloud::CloudDMS::V1::DescribeConversionWorkspaceRevisionsRequest.new(conversion_workspace: conversion_workspace, commit_id: commit_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.describe_conversion_workspace_revisions({ conversion_workspace: conversion_workspace, commit_id: commit_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.describe_conversion_workspace_revisions(::Google::Cloud::CloudDMS::V1::DescribeConversionWorkspaceRevisionsRequest.new(conversion_workspace: conversion_workspace, commit_id: commit_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, describe_conversion_workspace_revisions_client_stub.call_rpc_count
    end
  end

  def test_fetch_static_ips
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CloudDMS::V1::FetchStaticIpsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    page_size = 42
    page_token = "hello world"

    fetch_static_ips_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :fetch_static_ips, name
      assert_kind_of ::Google::Cloud::CloudDMS::V1::FetchStaticIpsRequest, request
      assert_equal "hello world", request["name"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, fetch_static_ips_client_stub do
      # Create client
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.fetch_static_ips({ name: name, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.fetch_static_ips name: name, page_size: page_size, page_token: page_token do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.fetch_static_ips ::Google::Cloud::CloudDMS::V1::FetchStaticIpsRequest.new(name: name, page_size: page_size, page_token: page_token) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.fetch_static_ips({ name: name, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.fetch_static_ips(::Google::Cloud::CloudDMS::V1::FetchStaticIpsRequest.new(name: name, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, fetch_static_ips_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::CloudDMS::V1::DataMigrationService::Operations, client.operations_client
  end
end
