# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/cloud_dms/v1/data_migration_service"

class ::Google::Cloud::CloudDMS::V1::DataMigrationService::ClientPathsTest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end
  
    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_connection_profile_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.connection_profile_path project: "value0", location: "value1", connection_profile: "value2"
      assert_equal "projects/value0/locations/value1/connectionProfiles/value2", path
    end
  end

  def test_conversion_workspace_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.conversion_workspace_path project: "value0", location: "value1", conversion_workspace: "value2"
      assert_equal "projects/value0/locations/value1/conversionWorkspaces/value2", path
    end
  end

  def test_location_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.location_path project: "value0", location: "value1"
      assert_equal "projects/value0/locations/value1", path
    end
  end

  def test_mapping_rule_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.mapping_rule_path project: "value0", location: "value1", conversion_workspace: "value2", mapping_rule: "value3"
      assert_equal "projects/value0/locations/value1/conversionWorkspaces/value2/mappingRules/value3", path
    end
  end

  def test_migration_job_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.migration_job_path project: "value0", location: "value1", migration_job: "value2"
      assert_equal "projects/value0/locations/value1/migrationJobs/value2", path
    end
  end

  def test_networks_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.networks_path project: "value0", network: "value1"
      assert_equal "projects/value0/global/networks/value1", path
    end
  end

  def test_private_connection_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.private_connection_path project: "value0", location: "value1", private_connection: "value2"
      assert_equal "projects/value0/locations/value1/privateConnections/value2", path
    end
  end
end
