# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module CloudDMS
      module V1
        # The type and version of a source or destination database.
        # @!attribute [rw] engine
        #   @return [::Google::Cloud::CloudDMS::V1::DatabaseEngine]
        #     Required. Engine type.
        # @!attribute [rw] version
        #   @return [::String]
        #     Required. Engine named version, for example 12.c.1.
        class DatabaseEngineInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The main conversion workspace resource entity.
        # @!attribute [rw] name
        #   @return [::String]
        #     Full name of the workspace resource, in the form of:
        #     projects/\\{project}/locations/\\{location}/conversionWorkspaces/\\{conversion_workspace}.
        # @!attribute [rw] source
        #   @return [::Google::Cloud::CloudDMS::V1::DatabaseEngineInfo]
        #     Required. The source engine details.
        # @!attribute [rw] destination
        #   @return [::Google::Cloud::CloudDMS::V1::DatabaseEngineInfo]
        #     Required. The destination engine details.
        # @!attribute [rw] global_settings
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. A generic list of settings for the workspace.
        #     The settings are database pair dependant and can indicate default behavior
        #     for the mapping rules engine or turn on or off specific features.
        #     Such examples can be: convert_foreign_key_to_interleave=true,
        #     skip_triggers=false, ignore_non_table_synonyms=true
        # @!attribute [r] has_uncommitted_changes
        #   @return [::Boolean]
        #     Output only. Whether the workspace has uncommitted changes (changes which
        #     were made after the workspace was committed).
        # @!attribute [r] latest_commit_id
        #   @return [::String]
        #     Output only. The latest commit ID.
        # @!attribute [r] latest_commit_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the workspace was committed.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the workspace resource was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the workspace resource was last updated.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. The display name for the workspace.
        class ConversionWorkspace
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class GlobalSettingsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Execution log of a background job.
        # @!attribute [rw] id
        #   @return [::String]
        #     The background job log entry ID.
        # @!attribute [rw] job_type
        #   @return [::Google::Cloud::CloudDMS::V1::BackgroundJobType]
        #     The type of job that was executed.
        # @!attribute [rw] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The timestamp when the background job was started.
        # @!attribute [rw] finish_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The timestamp when the background job was finished.
        # @!attribute [r] completion_state
        #   @return [::Google::Cloud::CloudDMS::V1::BackgroundJobLogEntry::JobCompletionState]
        #     Output only. Job completion state, i.e. the final state after the job
        #     completed.
        # @!attribute [r] completion_comment
        #   @return [::String]
        #     Output only. Job completion comment, such as how many entities were seeded,
        #     how many warnings were found during conversion, and similar information.
        # @!attribute [r] request_autocommit
        #   @return [::Boolean]
        #     Output only. Whether the client requested the conversion workspace to be
        #     committed after a successful completion of the job.
        # @!attribute [r] seed_job_details
        #   @return [::Google::Cloud::CloudDMS::V1::BackgroundJobLogEntry::SeedJobDetails]
        #     Output only. Seed job details.
        #
        #     Note: The following fields are mutually exclusive: `seed_job_details`, `import_rules_job_details`, `convert_job_details`, `apply_job_details`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] import_rules_job_details
        #   @return [::Google::Cloud::CloudDMS::V1::BackgroundJobLogEntry::ImportRulesJobDetails]
        #     Output only. Import rules job details.
        #
        #     Note: The following fields are mutually exclusive: `import_rules_job_details`, `seed_job_details`, `convert_job_details`, `apply_job_details`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] convert_job_details
        #   @return [::Google::Cloud::CloudDMS::V1::BackgroundJobLogEntry::ConvertJobDetails]
        #     Output only. Convert job details.
        #
        #     Note: The following fields are mutually exclusive: `convert_job_details`, `seed_job_details`, `import_rules_job_details`, `apply_job_details`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] apply_job_details
        #   @return [::Google::Cloud::CloudDMS::V1::BackgroundJobLogEntry::ApplyJobDetails]
        #     Output only. Apply job details.
        #
        #     Note: The following fields are mutually exclusive: `apply_job_details`, `seed_job_details`, `import_rules_job_details`, `convert_job_details`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class BackgroundJobLogEntry
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Details regarding a Seed background job.
          # @!attribute [r] connection_profile
          #   @return [::String]
          #     Output only. The connection profile which was used for the seed job.
          class SeedJobDetails
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Details regarding an Import Rules background job.
          # @!attribute [r] files
          #   @return [::Array<::String>]
          #     Output only. File names used for the import rules job.
          # @!attribute [r] file_format
          #   @return [::Google::Cloud::CloudDMS::V1::ImportRulesFileFormat]
          #     Output only. The requested file format.
          class ImportRulesJobDetails
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Details regarding a Convert background job.
          # @!attribute [r] filter
          #   @return [::String]
          #     Output only. AIP-160 based filter used to specify the entities to convert
          class ConvertJobDetails
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Details regarding an Apply background job.
          # @!attribute [r] connection_profile
          #   @return [::String]
          #     Output only. The connection profile which was used for the apply job.
          # @!attribute [r] filter
          #   @return [::String]
          #     Output only. AIP-160 based filter used to specify the entities to apply
          class ApplyJobDetails
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Final state after a job completes.
          module JobCompletionState
            # The status is not specified. This state is used when job is not yet
            # finished.
            JOB_COMPLETION_STATE_UNSPECIFIED = 0

            # Success.
            SUCCEEDED = 1

            # Error.
            FAILED = 2
          end
        end

        # A filter defining the entities that a mapping rule should be applied to.
        # When more than one field is specified, the rule is applied only to
        # entities which match all the fields.
        # @!attribute [rw] parent_entity
        #   @return [::String]
        #     Optional. The rule should be applied to entities whose parent entity
        #     (fully qualified name) matches the given value.
        #     For example, if the rule applies to a table entity, the expected value
        #     should be a schema (schema). If the rule applies to a column or index
        #     entity, the expected value can be either a schema (schema) or a table
        #     (schema.table)
        # @!attribute [rw] entity_name_prefix
        #   @return [::String]
        #     Optional. The rule should be applied to entities whose non-qualified name
        #     starts with the given prefix.
        # @!attribute [rw] entity_name_suffix
        #   @return [::String]
        #     Optional. The rule should be applied to entities whose non-qualified name
        #     ends with the given suffix.
        # @!attribute [rw] entity_name_contains
        #   @return [::String]
        #     Optional. The rule should be applied to entities whose non-qualified name
        #     contains the given string.
        # @!attribute [rw] entities
        #   @return [::Array<::String>]
        #     Optional. The rule should be applied to specific entities defined by their
        #     fully qualified names.
        class MappingRuleFilter
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Definition of a transformation that is to be applied to a group of entities
        # in the source schema. Several such transformations can be applied to an
        # entity sequentially to define the corresponding entity in the target schema.
        # @!attribute [rw] name
        #   @return [::String]
        #     Full name of the mapping rule resource, in the form of:
        #     projects/\\{project}/locations/\\{location}/conversionWorkspaces/\\{set}/mappingRule/\\{rule}.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. A human readable name
        # @!attribute [rw] state
        #   @return [::Google::Cloud::CloudDMS::V1::MappingRule::State]
        #     Optional. The mapping rule state
        # @!attribute [rw] rule_scope
        #   @return [::Google::Cloud::CloudDMS::V1::DatabaseEntityType]
        #     Required. The rule scope
        # @!attribute [rw] filter
        #   @return [::Google::Cloud::CloudDMS::V1::MappingRuleFilter]
        #     Required. The rule filter
        # @!attribute [rw] rule_order
        #   @return [::Integer]
        #     Required. The order in which the rule is applied. Lower order rules are
        #     applied before higher value rules so they may end up being overridden.
        # @!attribute [r] revision_id
        #   @return [::String]
        #     Output only. The revision ID of the mapping rule.
        #     A new revision is committed whenever the mapping rule is changed in any
        #     way. The format is an 8-character hexadecimal string.
        # @!attribute [r] revision_create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp that the revision was created.
        # @!attribute [rw] single_entity_rename
        #   @return [::Google::Cloud::CloudDMS::V1::SingleEntityRename]
        #     Optional. Rule to specify how a single entity should be renamed.
        #
        #     Note: The following fields are mutually exclusive: `single_entity_rename`, `multi_entity_rename`, `entity_move`, `single_column_change`, `multi_column_data_type_change`, `conditional_column_set_value`, `convert_rowid_column`, `set_table_primary_key`, `single_package_change`, `source_sql_change`, `filter_table_columns`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] multi_entity_rename
        #   @return [::Google::Cloud::CloudDMS::V1::MultiEntityRename]
        #     Optional. Rule to specify how multiple entities should be renamed.
        #
        #     Note: The following fields are mutually exclusive: `multi_entity_rename`, `single_entity_rename`, `entity_move`, `single_column_change`, `multi_column_data_type_change`, `conditional_column_set_value`, `convert_rowid_column`, `set_table_primary_key`, `single_package_change`, `source_sql_change`, `filter_table_columns`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] entity_move
        #   @return [::Google::Cloud::CloudDMS::V1::EntityMove]
        #     Optional. Rule to specify how multiple entities should be relocated into
        #     a different schema.
        #
        #     Note: The following fields are mutually exclusive: `entity_move`, `single_entity_rename`, `multi_entity_rename`, `single_column_change`, `multi_column_data_type_change`, `conditional_column_set_value`, `convert_rowid_column`, `set_table_primary_key`, `single_package_change`, `source_sql_change`, `filter_table_columns`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] single_column_change
        #   @return [::Google::Cloud::CloudDMS::V1::SingleColumnChange]
        #     Optional. Rule to specify how a single column is converted.
        #
        #     Note: The following fields are mutually exclusive: `single_column_change`, `single_entity_rename`, `multi_entity_rename`, `entity_move`, `multi_column_data_type_change`, `conditional_column_set_value`, `convert_rowid_column`, `set_table_primary_key`, `single_package_change`, `source_sql_change`, `filter_table_columns`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] multi_column_data_type_change
        #   @return [::Google::Cloud::CloudDMS::V1::MultiColumnDatatypeChange]
        #     Optional. Rule to specify how multiple columns should be converted to a
        #     different data type.
        #
        #     Note: The following fields are mutually exclusive: `multi_column_data_type_change`, `single_entity_rename`, `multi_entity_rename`, `entity_move`, `single_column_change`, `conditional_column_set_value`, `convert_rowid_column`, `set_table_primary_key`, `single_package_change`, `source_sql_change`, `filter_table_columns`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] conditional_column_set_value
        #   @return [::Google::Cloud::CloudDMS::V1::ConditionalColumnSetValue]
        #     Optional. Rule to specify how the data contained in a column should be
        #     transformed (such as trimmed, rounded, etc) provided that the data meets
        #     certain criteria.
        #
        #     Note: The following fields are mutually exclusive: `conditional_column_set_value`, `single_entity_rename`, `multi_entity_rename`, `entity_move`, `single_column_change`, `multi_column_data_type_change`, `convert_rowid_column`, `set_table_primary_key`, `single_package_change`, `source_sql_change`, `filter_table_columns`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] convert_rowid_column
        #   @return [::Google::Cloud::CloudDMS::V1::ConvertRowIdToColumn]
        #     Optional. Rule to specify how multiple tables should be converted with an
        #     additional rowid column.
        #
        #     Note: The following fields are mutually exclusive: `convert_rowid_column`, `single_entity_rename`, `multi_entity_rename`, `entity_move`, `single_column_change`, `multi_column_data_type_change`, `conditional_column_set_value`, `set_table_primary_key`, `single_package_change`, `source_sql_change`, `filter_table_columns`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] set_table_primary_key
        #   @return [::Google::Cloud::CloudDMS::V1::SetTablePrimaryKey]
        #     Optional. Rule to specify the primary key for a table
        #
        #     Note: The following fields are mutually exclusive: `set_table_primary_key`, `single_entity_rename`, `multi_entity_rename`, `entity_move`, `single_column_change`, `multi_column_data_type_change`, `conditional_column_set_value`, `convert_rowid_column`, `single_package_change`, `source_sql_change`, `filter_table_columns`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] single_package_change
        #   @return [::Google::Cloud::CloudDMS::V1::SinglePackageChange]
        #     Optional. Rule to specify how a single package is converted.
        #
        #     Note: The following fields are mutually exclusive: `single_package_change`, `single_entity_rename`, `multi_entity_rename`, `entity_move`, `single_column_change`, `multi_column_data_type_change`, `conditional_column_set_value`, `convert_rowid_column`, `set_table_primary_key`, `source_sql_change`, `filter_table_columns`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] source_sql_change
        #   @return [::Google::Cloud::CloudDMS::V1::SourceSqlChange]
        #     Optional. Rule to change the sql code for an entity, for example,
        #     function, procedure.
        #
        #     Note: The following fields are mutually exclusive: `source_sql_change`, `single_entity_rename`, `multi_entity_rename`, `entity_move`, `single_column_change`, `multi_column_data_type_change`, `conditional_column_set_value`, `convert_rowid_column`, `set_table_primary_key`, `single_package_change`, `filter_table_columns`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] filter_table_columns
        #   @return [::Google::Cloud::CloudDMS::V1::FilterTableColumns]
        #     Optional. Rule to specify the list of columns to include or exclude from
        #     a table.
        #
        #     Note: The following fields are mutually exclusive: `filter_table_columns`, `single_entity_rename`, `multi_entity_rename`, `entity_move`, `single_column_change`, `multi_column_data_type_change`, `conditional_column_set_value`, `convert_rowid_column`, `set_table_primary_key`, `single_package_change`, `source_sql_change`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class MappingRule
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The current mapping rule state such as enabled, disabled or deleted.
          module State
            # The state of the mapping rule is unknown.
            STATE_UNSPECIFIED = 0

            # The rule is enabled.
            ENABLED = 1

            # The rule is disabled.
            DISABLED = 2

            # The rule is logically deleted.
            DELETED = 3
          end
        end

        # Options to configure rule type SingleEntityRename.
        # The rule is used to rename an entity.
        #
        # The rule filter field can refer to only one entity.
        #
        # The rule scope can be one of: Database, Schema, Table, Column, Constraint,
        # Index, View, Function, Stored Procedure, Materialized View, Sequence, UDT,
        # Synonym
        # @!attribute [rw] new_name
        #   @return [::String]
        #     Required. The new name of the destination entity
        class SingleEntityRename
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Options to configure rule type MultiEntityRename.
        # The rule is used to rename multiple entities.
        #
        # The rule filter field can refer to one or more entities.
        #
        # The rule scope can be one of: Database, Schema, Table, Column, Constraint,
        # Index, View, Function, Stored Procedure, Materialized View, Sequence, UDT
        # @!attribute [rw] new_name_pattern
        #   @return [::String]
        #     Optional. The pattern used to generate the new entity's name. This pattern
        #     must include the characters '\\{name}', which will be replaced with the name
        #     of the original entity. For example, the pattern 't_\\{name}' for an entity
        #     name jobs would be converted to 't_jobs'.
        #
        #     If unspecified, the default value for this field is '\\{name}'
        # @!attribute [rw] source_name_transformation
        #   @return [::Google::Cloud::CloudDMS::V1::EntityNameTransformation]
        #     Optional. Additional transformation that can be done on the source entity
        #     name before it is being used by the new_name_pattern, for example lower
        #     case. If no transformation is desired, use NO_TRANSFORMATION
        class MultiEntityRename
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Options to configure rule type EntityMove.
        # The rule is used to move an entity to a new schema.
        #
        # The rule filter field can refer to one or more entities.
        #
        # The rule scope can be one of: Table, Column, Constraint, Index, View,
        # Function, Stored Procedure, Materialized View, Sequence, UDT
        # @!attribute [rw] new_schema
        #   @return [::String]
        #     Required. The new schema
        class EntityMove
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Options to configure rule type SingleColumnChange.
        # The rule is used to change the properties of a column.
        #
        # The rule filter field can refer to one entity.
        #
        # The rule scope can be one of: Column.
        #
        # When using this rule, if a field is not specified than the destination
        # column's configuration will be the same as the one in the source column..
        # @!attribute [rw] data_type
        #   @return [::String]
        #     Optional. Column data type name.
        # @!attribute [rw] charset
        #   @return [::String]
        #     Optional. Charset override - instead of table level charset.
        # @!attribute [rw] collation
        #   @return [::String]
        #     Optional. Collation override - instead of table level collation.
        # @!attribute [rw] length
        #   @return [::Integer]
        #     Optional. Column length - e.g. 50 as in varchar (50) - when relevant.
        # @!attribute [rw] precision
        #   @return [::Integer]
        #     Optional. Column precision - e.g. 8 as in double (8,2) - when relevant.
        # @!attribute [rw] scale
        #   @return [::Integer]
        #     Optional. Column scale - e.g. 2 as in double (8,2) - when relevant.
        # @!attribute [rw] fractional_seconds_precision
        #   @return [::Integer]
        #     Optional. Column fractional seconds precision - e.g. 2 as in timestamp (2)
        #     - when relevant.
        # @!attribute [rw] array
        #   @return [::Boolean]
        #     Optional. Is the column of array type.
        # @!attribute [rw] array_length
        #   @return [::Integer]
        #     Optional. The length of the array, only relevant if the column type is an
        #     array.
        # @!attribute [rw] nullable
        #   @return [::Boolean]
        #     Optional. Is the column nullable.
        # @!attribute [rw] auto_generated
        #   @return [::Boolean]
        #     Optional. Is the column auto-generated/identity.
        # @!attribute [rw] udt
        #   @return [::Boolean]
        #     Optional. Is the column a UDT (User-defined Type).
        # @!attribute [rw] custom_features
        #   @return [::Google::Protobuf::Struct]
        #     Optional. Custom engine specific features.
        # @!attribute [rw] set_values
        #   @return [::Array<::String>]
        #     Optional. Specifies the list of values allowed in the column.
        # @!attribute [rw] comment
        #   @return [::String]
        #     Optional. Comment associated with the column.
        class SingleColumnChange
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Options to configure rule type MultiColumnDatatypeChange.
        # The rule is used to change the data type and associated properties of
        # multiple columns at once.
        #
        # The rule filter field can refer to one or more entities.
        #
        # The rule scope can be one of:Column.
        #
        # This rule requires additional filters to be specified beyond the basic rule
        # filter field, which is the source data type, but the rule supports additional
        # filtering capabilities such as the minimum and maximum field length. All
        # additional filters which are specified are required to be met in order for
        # the rule to be applied (logical AND between the fields).
        # @!attribute [rw] source_data_type_filter
        #   @return [::String]
        #     Required. Filter on source data type.
        # @!attribute [rw] source_text_filter
        #   @return [::Google::Cloud::CloudDMS::V1::SourceTextFilter]
        #     Optional. Filter for text-based data types like varchar.
        #
        #     Note: The following fields are mutually exclusive: `source_text_filter`, `source_numeric_filter`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] source_numeric_filter
        #   @return [::Google::Cloud::CloudDMS::V1::SourceNumericFilter]
        #     Optional. Filter for fixed point number data types such as
        #     NUMERIC/NUMBER.
        #
        #     Note: The following fields are mutually exclusive: `source_numeric_filter`, `source_text_filter`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] new_data_type
        #   @return [::String]
        #     Required. New data type.
        # @!attribute [rw] override_length
        #   @return [::Integer]
        #     Optional. Column length - e.g. varchar (50) - if not specified and relevant
        #     uses the source column length.
        # @!attribute [rw] override_scale
        #   @return [::Integer]
        #     Optional. Column scale - when relevant - if not specified and relevant
        #     uses the source column scale.
        # @!attribute [rw] override_precision
        #   @return [::Integer]
        #     Optional. Column precision - when relevant - if not specified and relevant
        #     uses the source column precision.
        # @!attribute [rw] override_fractional_seconds_precision
        #   @return [::Integer]
        #     Optional. Column fractional seconds precision - used only for timestamp
        #     based datatypes - if not specified and relevant uses the source column
        #     fractional seconds precision.
        # @!attribute [rw] custom_features
        #   @return [::Google::Protobuf::Struct]
        #     Optional. Custom engine specific features.
        class MultiColumnDatatypeChange
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Filter for text-based data types like varchar.
        # @!attribute [rw] source_min_length_filter
        #   @return [::Integer]
        #     Optional. The filter will match columns with length greater than or equal
        #     to this number.
        # @!attribute [rw] source_max_length_filter
        #   @return [::Integer]
        #     Optional. The filter will match columns with length smaller than or equal
        #     to this number.
        class SourceTextFilter
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Filter for fixed point number data types such as NUMERIC/NUMBER
        # @!attribute [rw] source_min_scale_filter
        #   @return [::Integer]
        #     Optional. The filter will match columns with scale greater than or equal to
        #     this number.
        # @!attribute [rw] source_max_scale_filter
        #   @return [::Integer]
        #     Optional. The filter will match columns with scale smaller than or equal to
        #     this number.
        # @!attribute [rw] source_min_precision_filter
        #   @return [::Integer]
        #     Optional. The filter will match columns with precision greater than or
        #     equal to this number.
        # @!attribute [rw] source_max_precision_filter
        #   @return [::Integer]
        #     Optional. The filter will match columns with precision smaller than or
        #     equal to this number.
        # @!attribute [rw] numeric_filter_option
        #   @return [::Google::Cloud::CloudDMS::V1::NumericFilterOption]
        #     Required. Enum to set the option defining the datatypes numeric filter has
        #     to be applied to
        class SourceNumericFilter
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Options to configure rule type ConditionalColumnSetValue.
        # The rule is used to transform the data which is being replicated/migrated.
        #
        # The rule filter field can refer to one or more entities.
        #
        # The rule scope can be one of: Column.
        # @!attribute [rw] source_text_filter
        #   @return [::Google::Cloud::CloudDMS::V1::SourceTextFilter]
        #     Optional. Optional filter on source column length. Used for text based
        #     data types like varchar.
        #
        #     Note: The following fields are mutually exclusive: `source_text_filter`, `source_numeric_filter`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] source_numeric_filter
        #   @return [::Google::Cloud::CloudDMS::V1::SourceNumericFilter]
        #     Optional. Optional filter on source column precision and scale. Used for
        #     fixed point numbers such as NUMERIC/NUMBER data types.
        #
        #     Note: The following fields are mutually exclusive: `source_numeric_filter`, `source_text_filter`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] value_transformation
        #   @return [::Google::Cloud::CloudDMS::V1::ValueTransformation]
        #     Required. Description of data transformation during migration.
        # @!attribute [rw] custom_features
        #   @return [::Google::Protobuf::Struct]
        #     Optional. Custom engine specific features.
        class ConditionalColumnSetValue
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Description of data transformation during migration as part of the
        # ConditionalColumnSetValue.
        # @!attribute [rw] is_null
        #   @return [::Google::Protobuf::Empty]
        #     Optional. Value is null
        #
        #     Note: The following fields are mutually exclusive: `is_null`, `value_list`, `int_comparison`, `double_comparison`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] value_list
        #   @return [::Google::Cloud::CloudDMS::V1::ValueListFilter]
        #     Optional. Value is found in the specified list.
        #
        #     Note: The following fields are mutually exclusive: `value_list`, `is_null`, `int_comparison`, `double_comparison`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] int_comparison
        #   @return [::Google::Cloud::CloudDMS::V1::IntComparisonFilter]
        #     Optional. Filter on relation between source value and compare value of
        #     type integer.
        #
        #     Note: The following fields are mutually exclusive: `int_comparison`, `is_null`, `value_list`, `double_comparison`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] double_comparison
        #   @return [::Google::Cloud::CloudDMS::V1::DoubleComparisonFilter]
        #     Optional. Filter on relation between source value and compare value of
        #     type double.
        #
        #     Note: The following fields are mutually exclusive: `double_comparison`, `is_null`, `value_list`, `int_comparison`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] assign_null
        #   @return [::Google::Protobuf::Empty]
        #     Optional. Set to null
        #
        #     Note: The following fields are mutually exclusive: `assign_null`, `assign_specific_value`, `assign_min_value`, `assign_max_value`, `round_scale`, `apply_hash`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] assign_specific_value
        #   @return [::Google::Cloud::CloudDMS::V1::AssignSpecificValue]
        #     Optional. Set to a specific value (value is converted to fit the target
        #     data type)
        #
        #     Note: The following fields are mutually exclusive: `assign_specific_value`, `assign_null`, `assign_min_value`, `assign_max_value`, `round_scale`, `apply_hash`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] assign_min_value
        #   @return [::Google::Protobuf::Empty]
        #     Optional. Set to min_value - if integer or numeric, will use
        #     int.minvalue, etc
        #
        #     Note: The following fields are mutually exclusive: `assign_min_value`, `assign_null`, `assign_specific_value`, `assign_max_value`, `round_scale`, `apply_hash`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] assign_max_value
        #   @return [::Google::Protobuf::Empty]
        #     Optional. Set to max_value - if integer or numeric, will use
        #     int.maxvalue, etc
        #
        #     Note: The following fields are mutually exclusive: `assign_max_value`, `assign_null`, `assign_specific_value`, `assign_min_value`, `round_scale`, `apply_hash`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] round_scale
        #   @return [::Google::Cloud::CloudDMS::V1::RoundToScale]
        #     Optional. Allows the data to change scale
        #
        #     Note: The following fields are mutually exclusive: `round_scale`, `assign_null`, `assign_specific_value`, `assign_min_value`, `assign_max_value`, `apply_hash`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] apply_hash
        #   @return [::Google::Cloud::CloudDMS::V1::ApplyHash]
        #     Optional. Applies a hash function on the data
        #
        #     Note: The following fields are mutually exclusive: `apply_hash`, `assign_null`, `assign_specific_value`, `assign_min_value`, `assign_max_value`, `round_scale`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class ValueTransformation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Options to configure rule type ConvertROWIDToColumn.
        # The rule is used to add column rowid to destination tables based on an Oracle
        # rowid function/property.
        #
        # The rule filter field can refer to one or more entities.
        #
        # The rule scope can be one of: Table.
        #
        # This rule requires additional filter to be specified beyond the basic rule
        # filter field, which is whether or not to work on tables which already have a
        # primary key defined.
        # @!attribute [rw] only_if_no_primary_key
        #   @return [::Boolean]
        #     Required. Only work on tables without primary key defined
        class ConvertRowIdToColumn
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Options to configure rule type SetTablePrimaryKey.
        # The rule is used to specify the columns and name to configure/alter the
        # primary key of a table.
        #
        # The rule filter field can refer to one entity.
        #
        # The rule scope can be one of: Table.
        # @!attribute [rw] primary_key_columns
        #   @return [::Array<::String>]
        #     Required. List of column names for the primary key
        # @!attribute [rw] primary_key
        #   @return [::String]
        #     Optional. Name for the primary key
        class SetTablePrimaryKey
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Options to configure rule type SinglePackageChange.
        # The rule is used to alter the sql code for a package entities.
        #
        # The rule filter field can refer to one entity.
        #
        # The rule scope can be: Package
        # @!attribute [rw] package_description
        #   @return [::String]
        #     Optional. Sql code for package description
        # @!attribute [rw] package_body
        #   @return [::String]
        #     Optional. Sql code for package body
        class SinglePackageChange
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Options to configure rule type SourceSqlChange.
        # The rule is used to alter the sql code for database entities.
        #
        # The rule filter field can refer to one entity.
        #
        # The rule scope can be: StoredProcedure, Function, Trigger, View
        # @!attribute [rw] sql_code
        #   @return [::String]
        #     Required. Sql code for source (stored procedure, function, trigger or view)
        class SourceSqlChange
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Options to configure rule type FilterTableColumns.
        # The rule is used to filter the list of columns to include or exclude from a
        # table.
        #
        # The rule filter field can refer to one entity.
        #
        # The rule scope can be: Table
        #
        # Only one of the two lists can be specified for the rule.
        # @!attribute [rw] include_columns
        #   @return [::Array<::String>]
        #     Optional. List of columns to be included for a particular table.
        # @!attribute [rw] exclude_columns
        #   @return [::Array<::String>]
        #     Optional. List of columns to be excluded for a particular table.
        class FilterTableColumns
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A list of values to filter by in ConditionalColumnSetValue
        # @!attribute [rw] value_present_list
        #   @return [::Google::Cloud::CloudDMS::V1::ValuePresentInList]
        #     Required. Indicates whether the filter matches rows with values that are
        #     present in the list or those with values not present in it.
        # @!attribute [rw] values
        #   @return [::Array<::String>]
        #     Required. The list to be used to filter by
        # @!attribute [rw] ignore_case
        #   @return [::Boolean]
        #     Required. Whether to ignore case when filtering by values. Defaults to
        #     false
        class ValueListFilter
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Filter based on relation between source value and compare value of type
        # integer in ConditionalColumnSetValue
        # @!attribute [rw] value_comparison
        #   @return [::Google::Cloud::CloudDMS::V1::ValueComparison]
        #     Required. Relation between source value and compare value
        # @!attribute [rw] value
        #   @return [::Integer]
        #     Required. Integer compare value to be used
        class IntComparisonFilter
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Filter based on relation between source
        # value and compare value of type double in ConditionalColumnSetValue
        # @!attribute [rw] value_comparison
        #   @return [::Google::Cloud::CloudDMS::V1::ValueComparison]
        #     Required. Relation between source value and compare value
        # @!attribute [rw] value
        #   @return [::Float]
        #     Required. Double compare value to be used
        class DoubleComparisonFilter
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Set to a specific value (value is converted to fit the target data type)
        # @!attribute [rw] value
        #   @return [::String]
        #     Required. Specific value to be assigned
        class AssignSpecificValue
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Apply a hash function on the value.
        # @!attribute [rw] uuid_from_bytes
        #   @return [::Google::Protobuf::Empty]
        #     Optional. Generate UUID from the data's byte array
        class ApplyHash
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # This allows the data to change scale, for example if the source is 2 digits
        # after the decimal point, specify round to scale value = 2. If for example the
        # value needs to be converted to an integer, use round to scale value = 0.
        # @!attribute [rw] scale
        #   @return [::Integer]
        #     Required. Scale value to be used
        class RoundToScale
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The base entity type for all the database related entities.
        # The message contains the entity name, the name of its parent, the entity
        # type, and the specific details per entity type.
        # @!attribute [rw] short_name
        #   @return [::String]
        #     The short name (e.g. table name) of the entity.
        # @!attribute [rw] parent_entity
        #   @return [::String]
        #     The full name of the parent entity (e.g. schema name).
        # @!attribute [rw] tree
        #   @return [::Google::Cloud::CloudDMS::V1::DatabaseEntity::TreeType]
        #     The type of tree the entity belongs to.
        # @!attribute [rw] entity_type
        #   @return [::Google::Cloud::CloudDMS::V1::DatabaseEntityType]
        #     The type of the database entity (table, view, index, ...).
        # @!attribute [rw] mappings
        #   @return [::Array<::Google::Cloud::CloudDMS::V1::EntityMapping>]
        #     Details about entity mappings.
        #     For source tree entities, this holds the draft entities which were
        #     generated by the mapping rules.
        #     For draft tree entities, this holds the source entities which were
        #     converted to form the draft entity.
        #     Destination entities will have no mapping details.
        # @!attribute [rw] entity_ddl
        #   @return [::Array<::Google::Cloud::CloudDMS::V1::EntityDdl>]
        #     Details about the entity DDL script. Multiple DDL scripts are provided for
        #     child entities such as a table entity will have one DDL for the table with
        #     additional DDLs for each index, constraint and such.
        # @!attribute [rw] issues
        #   @return [::Array<::Google::Cloud::CloudDMS::V1::EntityIssue>]
        #     Details about the various issues found for the entity.
        # @!attribute [rw] database
        #   @return [::Google::Cloud::CloudDMS::V1::DatabaseInstanceEntity]
        #     Database.
        #
        #     Note: The following fields are mutually exclusive: `database`, `schema`, `table`, `view`, `sequence`, `stored_procedure`, `database_function`, `synonym`, `database_package`, `udt`, `materialized_view`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] schema
        #   @return [::Google::Cloud::CloudDMS::V1::SchemaEntity]
        #     Schema.
        #
        #     Note: The following fields are mutually exclusive: `schema`, `database`, `table`, `view`, `sequence`, `stored_procedure`, `database_function`, `synonym`, `database_package`, `udt`, `materialized_view`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] table
        #   @return [::Google::Cloud::CloudDMS::V1::TableEntity]
        #     Table.
        #
        #     Note: The following fields are mutually exclusive: `table`, `database`, `schema`, `view`, `sequence`, `stored_procedure`, `database_function`, `synonym`, `database_package`, `udt`, `materialized_view`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] view
        #   @return [::Google::Cloud::CloudDMS::V1::ViewEntity]
        #     View.
        #
        #     Note: The following fields are mutually exclusive: `view`, `database`, `schema`, `table`, `sequence`, `stored_procedure`, `database_function`, `synonym`, `database_package`, `udt`, `materialized_view`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] sequence
        #   @return [::Google::Cloud::CloudDMS::V1::SequenceEntity]
        #     Sequence.
        #
        #     Note: The following fields are mutually exclusive: `sequence`, `database`, `schema`, `table`, `view`, `stored_procedure`, `database_function`, `synonym`, `database_package`, `udt`, `materialized_view`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] stored_procedure
        #   @return [::Google::Cloud::CloudDMS::V1::StoredProcedureEntity]
        #     Stored procedure.
        #
        #     Note: The following fields are mutually exclusive: `stored_procedure`, `database`, `schema`, `table`, `view`, `sequence`, `database_function`, `synonym`, `database_package`, `udt`, `materialized_view`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] database_function
        #   @return [::Google::Cloud::CloudDMS::V1::FunctionEntity]
        #     Function.
        #
        #     Note: The following fields are mutually exclusive: `database_function`, `database`, `schema`, `table`, `view`, `sequence`, `stored_procedure`, `synonym`, `database_package`, `udt`, `materialized_view`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] synonym
        #   @return [::Google::Cloud::CloudDMS::V1::SynonymEntity]
        #     Synonym.
        #
        #     Note: The following fields are mutually exclusive: `synonym`, `database`, `schema`, `table`, `view`, `sequence`, `stored_procedure`, `database_function`, `database_package`, `udt`, `materialized_view`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] database_package
        #   @return [::Google::Cloud::CloudDMS::V1::PackageEntity]
        #     Package.
        #
        #     Note: The following fields are mutually exclusive: `database_package`, `database`, `schema`, `table`, `view`, `sequence`, `stored_procedure`, `database_function`, `synonym`, `udt`, `materialized_view`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] udt
        #   @return [::Google::Cloud::CloudDMS::V1::UDTEntity]
        #     UDT.
        #
        #     Note: The following fields are mutually exclusive: `udt`, `database`, `schema`, `table`, `view`, `sequence`, `stored_procedure`, `database_function`, `synonym`, `database_package`, `materialized_view`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] materialized_view
        #   @return [::Google::Cloud::CloudDMS::V1::MaterializedViewEntity]
        #     Materialized view.
        #
        #     Note: The following fields are mutually exclusive: `materialized_view`, `database`, `schema`, `table`, `view`, `sequence`, `stored_procedure`, `database_function`, `synonym`, `database_package`, `udt`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class DatabaseEntity
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The type of database entities tree.
          module TreeType
            # Tree type unspecified.
            TREE_TYPE_UNSPECIFIED = 0

            # Tree of entities loaded from a source database.
            SOURCE = 1

            # Tree of entities converted from the source tree using the mapping rules.
            DRAFT = 2

            # Tree of entities observed on the destination database.
            DESTINATION = 3
          end
        end

        # DatabaseInstance acts as a parent entity to other database entities.
        # @!attribute [rw] custom_features
        #   @return [::Google::Protobuf::Struct]
        #     Custom engine specific features.
        class DatabaseInstanceEntity
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Schema typically has no parent entity, but can have a parent entity
        # DatabaseInstance (for database engines which support it).  For some database
        # engines, the terms  schema and user can be used interchangeably when they
        # refer to a namespace or a collection of other database entities. Can store
        # additional information which is schema specific.
        # @!attribute [rw] custom_features
        #   @return [::Google::Protobuf::Struct]
        #     Custom engine specific features.
        class SchemaEntity
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Table's parent is a schema.
        # @!attribute [rw] columns
        #   @return [::Array<::Google::Cloud::CloudDMS::V1::ColumnEntity>]
        #     Table columns.
        # @!attribute [rw] constraints
        #   @return [::Array<::Google::Cloud::CloudDMS::V1::ConstraintEntity>]
        #     Table constraints.
        # @!attribute [rw] indices
        #   @return [::Array<::Google::Cloud::CloudDMS::V1::IndexEntity>]
        #     Table indices.
        # @!attribute [rw] triggers
        #   @return [::Array<::Google::Cloud::CloudDMS::V1::TriggerEntity>]
        #     Table triggers.
        # @!attribute [rw] custom_features
        #   @return [::Google::Protobuf::Struct]
        #     Custom engine specific features.
        # @!attribute [rw] comment
        #   @return [::String]
        #     Comment associated with the table.
        class TableEntity
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Column is not used as an independent entity, it is retrieved as part of a
        # Table entity.
        # @!attribute [rw] name
        #   @return [::String]
        #     Column name.
        # @!attribute [rw] data_type
        #   @return [::String]
        #     Column data type.
        # @!attribute [rw] charset
        #   @return [::String]
        #     Charset override - instead of table level charset.
        # @!attribute [rw] collation
        #   @return [::String]
        #     Collation override - instead of table level collation.
        # @!attribute [rw] length
        #   @return [::Integer]
        #     Column length - e.g. varchar (50).
        # @!attribute [rw] precision
        #   @return [::Integer]
        #     Column precision - when relevant.
        # @!attribute [rw] scale
        #   @return [::Integer]
        #     Column scale - when relevant.
        # @!attribute [rw] fractional_seconds_precision
        #   @return [::Integer]
        #     Column fractional second precision - used for timestamp based datatypes.
        # @!attribute [rw] array
        #   @return [::Boolean]
        #     Is the column of array type.
        # @!attribute [rw] array_length
        #   @return [::Integer]
        #     If the column is array, of which length.
        # @!attribute [rw] nullable
        #   @return [::Boolean]
        #     Is the column nullable.
        # @!attribute [rw] auto_generated
        #   @return [::Boolean]
        #     Is the column auto-generated/identity.
        # @!attribute [rw] udt
        #   @return [::Boolean]
        #     Is the column a UDT.
        # @!attribute [rw] custom_features
        #   @return [::Google::Protobuf::Struct]
        #     Custom engine specific features.
        # @!attribute [rw] set_values
        #   @return [::Array<::String>]
        #     Specifies the list of values allowed in the column.
        #     Only used for set data type.
        # @!attribute [rw] comment
        #   @return [::String]
        #     Comment associated with the column.
        # @!attribute [rw] ordinal_position
        #   @return [::Integer]
        #     Column order in the table.
        # @!attribute [rw] default_value
        #   @return [::String]
        #     Default value of the column.
        class ColumnEntity
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Constraint is not used as an independent entity, it is retrieved
        # as part of another entity such as Table or View.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the table constraint.
        # @!attribute [rw] type
        #   @return [::String]
        #     Type of constraint, for example unique, primary key, foreign key (currently
        #     only primary key is supported).
        # @!attribute [rw] table_columns
        #   @return [::Array<::String>]
        #     Table columns used as part of the Constraint, for example primary key
        #     constraint should list the columns which constitutes the key.
        # @!attribute [rw] custom_features
        #   @return [::Google::Protobuf::Struct]
        #     Custom engine specific features.
        # @!attribute [rw] reference_columns
        #   @return [::Array<::String>]
        #     Reference columns which may be associated with the constraint. For example,
        #     if the constraint is a FOREIGN_KEY, this represents the list of full names
        #     of referenced columns by the foreign key.
        # @!attribute [rw] reference_table
        #   @return [::String]
        #     Reference table which may be associated with the constraint. For example,
        #     if the constraint is a FOREIGN_KEY, this represents the list of full name
        #     of the referenced table by the foreign key.
        # @!attribute [rw] table_name
        #   @return [::String]
        #     Table which is associated with the constraint. In case the constraint
        #     is defined on a table, this field is left empty as this information is
        #     stored in parent_name. However, if constraint is defined on a view, this
        #     field stores the table name on which the view is defined.
        class ConstraintEntity
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Index is not used as an independent entity, it is retrieved as part of a
        # Table entity.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the index.
        # @!attribute [rw] type
        #   @return [::String]
        #     Type of index, for example B-TREE.
        # @!attribute [rw] table_columns
        #   @return [::Array<::String>]
        #     Table columns used as part of the Index, for example B-TREE index should
        #     list the columns which constitutes the index.
        # @!attribute [rw] unique
        #   @return [::Boolean]
        #     Boolean value indicating whether the index is unique.
        # @!attribute [rw] custom_features
        #   @return [::Google::Protobuf::Struct]
        #     Custom engine specific features.
        class IndexEntity
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Trigger is not used as an independent entity, it is retrieved as part of a
        # Table entity.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the trigger.
        # @!attribute [rw] triggering_events
        #   @return [::Array<::String>]
        #     The DML, DDL, or database events that fire the trigger, for example
        #     INSERT, UPDATE.
        # @!attribute [rw] trigger_type
        #   @return [::String]
        #     Indicates when the trigger fires, for example BEFORE STATEMENT, AFTER EACH
        #     ROW.
        # @!attribute [rw] sql_code
        #   @return [::String]
        #     The SQL code which creates the trigger.
        # @!attribute [rw] custom_features
        #   @return [::Google::Protobuf::Struct]
        #     Custom engine specific features.
        class TriggerEntity
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # View's parent is a schema.
        # @!attribute [rw] sql_code
        #   @return [::String]
        #     The SQL code which creates the view.
        # @!attribute [rw] custom_features
        #   @return [::Google::Protobuf::Struct]
        #     Custom engine specific features.
        # @!attribute [rw] constraints
        #   @return [::Array<::Google::Cloud::CloudDMS::V1::ConstraintEntity>]
        #     View constraints.
        class ViewEntity
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Sequence's parent is a schema.
        # @!attribute [rw] increment
        #   @return [::Integer]
        #     Increment value for the sequence.
        # @!attribute [rw] start_value
        #   @return [::String]
        #     Start number for the sequence represented as bytes to accommodate large.
        #     numbers
        # @!attribute [rw] max_value
        #   @return [::String]
        #     Maximum number for the sequence represented as bytes to accommodate large.
        #     numbers
        # @!attribute [rw] min_value
        #   @return [::String]
        #     Minimum number for the sequence represented as bytes to accommodate large.
        #     numbers
        # @!attribute [rw] cycle
        #   @return [::Boolean]
        #     Indicates whether the sequence value should cycle through.
        # @!attribute [rw] cache
        #   @return [::Integer]
        #     Indicates number of entries to cache / precreate.
        # @!attribute [rw] custom_features
        #   @return [::Google::Protobuf::Struct]
        #     Custom engine specific features.
        class SequenceEntity
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Stored procedure's parent is a schema.
        # @!attribute [rw] sql_code
        #   @return [::String]
        #     The SQL code which creates the stored procedure.
        # @!attribute [rw] custom_features
        #   @return [::Google::Protobuf::Struct]
        #     Custom engine specific features.
        class StoredProcedureEntity
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Function's parent is a schema.
        # @!attribute [rw] sql_code
        #   @return [::String]
        #     The SQL code which creates the function.
        # @!attribute [rw] custom_features
        #   @return [::Google::Protobuf::Struct]
        #     Custom engine specific features.
        class FunctionEntity
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # MaterializedView's parent is a schema.
        # @!attribute [rw] sql_code
        #   @return [::String]
        #     The SQL code which creates the view.
        # @!attribute [rw] custom_features
        #   @return [::Google::Protobuf::Struct]
        #     Custom engine specific features.
        class MaterializedViewEntity
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Synonym's parent is a schema.
        # @!attribute [rw] source_entity
        #   @return [::String]
        #     The name of the entity for which the synonym is being created (the source).
        # @!attribute [rw] source_type
        #   @return [::Google::Cloud::CloudDMS::V1::DatabaseEntityType]
        #     The type of the entity for which the synonym is being created
        #     (usually a table or a sequence).
        # @!attribute [rw] custom_features
        #   @return [::Google::Protobuf::Struct]
        #     Custom engine specific features.
        class SynonymEntity
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Package's parent is a schema.
        # @!attribute [rw] package_sql_code
        #   @return [::String]
        #     The SQL code which creates the package.
        # @!attribute [rw] package_body
        #   @return [::String]
        #     The SQL code which creates the package body. If the package specification
        #     has cursors or subprograms, then the package body is mandatory.
        # @!attribute [rw] custom_features
        #   @return [::Google::Protobuf::Struct]
        #     Custom engine specific features.
        class PackageEntity
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # UDT's parent is a schema.
        # @!attribute [rw] udt_sql_code
        #   @return [::String]
        #     The SQL code which creates the udt.
        # @!attribute [rw] udt_body
        #   @return [::String]
        #     The SQL code which creates the udt body.
        # @!attribute [rw] custom_features
        #   @return [::Google::Protobuf::Struct]
        #     Custom engine specific features.
        class UDTEntity
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details of the mappings of a database entity.
        # @!attribute [rw] source_entity
        #   @return [::String]
        #     Source entity full name.
        #     The source entity can also be a column, index or constraint using the
        #     same naming notation schema.table.column.
        # @!attribute [rw] draft_entity
        #   @return [::String]
        #     Target entity full name.
        #     The draft entity can also include a column, index or constraint using the
        #     same naming notation schema.table.column.
        # @!attribute [rw] source_type
        #   @return [::Google::Cloud::CloudDMS::V1::DatabaseEntityType]
        #     Type of source entity.
        # @!attribute [rw] draft_type
        #   @return [::Google::Cloud::CloudDMS::V1::DatabaseEntityType]
        #     Type of draft entity.
        # @!attribute [rw] mapping_log
        #   @return [::Array<::Google::Cloud::CloudDMS::V1::EntityMappingLogEntry>]
        #     Entity mapping log entries.
        #     Multiple rules can be effective and contribute changes to a converted
        #     entity, such as a rule can handle the entity name, another rule can handle
        #     an entity type. In addition, rules which did not change the entity are also
        #     logged along with the reason preventing them to do so.
        class EntityMapping
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A single record of a rule which was used for a mapping.
        # @!attribute [rw] rule_id
        #   @return [::String]
        #     Which rule caused this log entry.
        # @!attribute [rw] rule_revision_id
        #   @return [::String]
        #     Rule revision ID.
        # @!attribute [rw] mapping_comment
        #   @return [::String]
        #     Comment.
        class EntityMappingLogEntry
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A single DDL statement for a specific entity
        # @!attribute [rw] ddl_type
        #   @return [::String]
        #     Type of DDL (Create, Alter).
        # @!attribute [rw] entity
        #   @return [::String]
        #     The name of the database entity the ddl refers to.
        # @!attribute [rw] ddl
        #   @return [::String]
        #     The actual ddl code.
        # @!attribute [rw] entity_type
        #   @return [::Google::Cloud::CloudDMS::V1::DatabaseEntityType]
        #     The entity type (if the DDL is for a sub entity).
        # @!attribute [rw] issue_id
        #   @return [::Array<::String>]
        #     EntityIssues found for this ddl.
        class EntityDdl
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Issue related to the entity.
        # @!attribute [rw] id
        #   @return [::String]
        #     Unique Issue ID.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::CloudDMS::V1::EntityIssue::IssueType]
        #     The type of the issue.
        # @!attribute [rw] severity
        #   @return [::Google::Cloud::CloudDMS::V1::EntityIssue::IssueSeverity]
        #     Severity of the issue
        # @!attribute [rw] message
        #   @return [::String]
        #     Issue detailed message
        # @!attribute [rw] code
        #   @return [::String]
        #     Error/Warning code
        # @!attribute [rw] ddl
        #   @return [::String]
        #     The ddl which caused the issue, if relevant.
        # @!attribute [rw] position
        #   @return [::Google::Cloud::CloudDMS::V1::EntityIssue::Position]
        #     The position of the issue found, if relevant.
        # @!attribute [rw] entity_type
        #   @return [::Google::Cloud::CloudDMS::V1::DatabaseEntityType]
        #     The entity type (if the DDL is for a sub entity).
        class EntityIssue
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Issue position.
          # @!attribute [rw] line
          #   @return [::Integer]
          #     Issue line number
          # @!attribute [rw] column
          #   @return [::Integer]
          #     Issue column number
          # @!attribute [rw] offset
          #   @return [::Integer]
          #     Issue offset
          # @!attribute [rw] length
          #   @return [::Integer]
          #     Issue length
          class Position
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Type of issue.
          module IssueType
            # Unspecified issue type.
            ISSUE_TYPE_UNSPECIFIED = 0

            # Issue originated from the DDL
            ISSUE_TYPE_DDL = 1

            # Issue originated during the apply process
            ISSUE_TYPE_APPLY = 2

            # Issue originated during the convert process
            ISSUE_TYPE_CONVERT = 3
          end

          # Severity of issue.
          module IssueSeverity
            # Unspecified issue severity
            ISSUE_SEVERITY_UNSPECIFIED = 0

            # Info
            ISSUE_SEVERITY_INFO = 1

            # Warning
            ISSUE_SEVERITY_WARNING = 2

            # Error
            ISSUE_SEVERITY_ERROR = 3
          end
        end

        # Enum used by ValueListFilter to indicate whether the source value is in the
        # supplied list
        module ValuePresentInList
          # Value present in list unspecified
          VALUE_PRESENT_IN_LIST_UNSPECIFIED = 0

          # If the source value is in the supplied list at value_list
          VALUE_PRESENT_IN_LIST_IF_VALUE_LIST = 1

          # If the source value is not in the supplied list at value_list
          VALUE_PRESENT_IN_LIST_IF_VALUE_NOT_LIST = 2
        end

        # The type of database entities supported,
        module DatabaseEntityType
          # Unspecified database entity type.
          DATABASE_ENTITY_TYPE_UNSPECIFIED = 0

          # Schema.
          DATABASE_ENTITY_TYPE_SCHEMA = 1

          # Table.
          DATABASE_ENTITY_TYPE_TABLE = 2

          # Column.
          DATABASE_ENTITY_TYPE_COLUMN = 3

          # Constraint.
          DATABASE_ENTITY_TYPE_CONSTRAINT = 4

          # Index.
          DATABASE_ENTITY_TYPE_INDEX = 5

          # Trigger.
          DATABASE_ENTITY_TYPE_TRIGGER = 6

          # View.
          DATABASE_ENTITY_TYPE_VIEW = 7

          # Sequence.
          DATABASE_ENTITY_TYPE_SEQUENCE = 8

          # Stored Procedure.
          DATABASE_ENTITY_TYPE_STORED_PROCEDURE = 9

          # Function.
          DATABASE_ENTITY_TYPE_FUNCTION = 10

          # Synonym.
          DATABASE_ENTITY_TYPE_SYNONYM = 11

          # Package.
          DATABASE_ENTITY_TYPE_DATABASE_PACKAGE = 12

          # UDT.
          DATABASE_ENTITY_TYPE_UDT = 13

          # Materialized View.
          DATABASE_ENTITY_TYPE_MATERIALIZED_VIEW = 14

          # Database.
          DATABASE_ENTITY_TYPE_DATABASE = 15
        end

        # Entity Name Transformation Types
        module EntityNameTransformation
          # Entity name transformation unspecified.
          ENTITY_NAME_TRANSFORMATION_UNSPECIFIED = 0

          # No transformation.
          ENTITY_NAME_TRANSFORMATION_NO_TRANSFORMATION = 1

          # Transform to lower case.
          ENTITY_NAME_TRANSFORMATION_LOWER_CASE = 2

          # Transform to upper case.
          ENTITY_NAME_TRANSFORMATION_UPPER_CASE = 3

          # Transform to capitalized case.
          ENTITY_NAME_TRANSFORMATION_CAPITALIZED_CASE = 4
        end

        # The types of jobs that can be executed in the background.
        module BackgroundJobType
          # Unspecified background job type.
          BACKGROUND_JOB_TYPE_UNSPECIFIED = 0

          # Job to seed from the source database.
          BACKGROUND_JOB_TYPE_SOURCE_SEED = 1

          # Job to convert the source database into a draft of the destination
          # database.
          BACKGROUND_JOB_TYPE_CONVERT = 2

          # Job to apply the draft tree onto the destination.
          BACKGROUND_JOB_TYPE_APPLY_DESTINATION = 3

          # Job to import and convert mapping rules from an external source such as an
          # ora2pg config file.
          BACKGROUND_JOB_TYPE_IMPORT_RULES_FILE = 5
        end

        # The format for the import rules file.
        module ImportRulesFileFormat
          # Unspecified rules format.
          IMPORT_RULES_FILE_FORMAT_UNSPECIFIED = 0

          # HarbourBridge session file.
          IMPORT_RULES_FILE_FORMAT_HARBOUR_BRIDGE_SESSION_FILE = 1

          # Ora2Pg configuration file.
          IMPORT_RULES_FILE_FORMAT_ORATOPG_CONFIG_FILE = 2
        end

        # Enum used by IntComparisonFilter and DoubleComparisonFilter to indicate the
        # relation between source value and compare value.
        module ValueComparison
          # Value comparison unspecified.
          VALUE_COMPARISON_UNSPECIFIED = 0

          # Value is smaller than the Compare value.
          VALUE_COMPARISON_IF_VALUE_SMALLER_THAN = 1

          # Value is smaller or equal than the Compare value.
          VALUE_COMPARISON_IF_VALUE_SMALLER_EQUAL_THAN = 2

          # Value is larger than the Compare value.
          VALUE_COMPARISON_IF_VALUE_LARGER_THAN = 3

          # Value is larger or equal than the Compare value.
          VALUE_COMPARISON_IF_VALUE_LARGER_EQUAL_THAN = 4
        end

        # Specifies the columns on which numeric filter needs to be applied.
        module NumericFilterOption
          # Numeric filter option unspecified
          NUMERIC_FILTER_OPTION_UNSPECIFIED = 0

          # Numeric filter option that matches all numeric columns.
          NUMERIC_FILTER_OPTION_ALL = 1

          # Numeric filter option that matches columns having numeric datatypes with
          # specified precision and scale within the limited range of filter.
          NUMERIC_FILTER_OPTION_LIMIT = 2

          # Numeric filter option that matches only the numeric columns with no
          # precision and scale specified.
          NUMERIC_FILTER_OPTION_LIMITLESS = 3
        end
      end
    end
  end
end
