# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module CloudDMS
      module V1
        # SSL configuration information.
        # @!attribute [r] type
        #   @return [::Google::Cloud::CloudDMS::V1::SslConfig::SslType]
        #     Output only. The ssl config type according to 'client_key',
        #     'client_certificate' and 'ca_certificate'.
        # @!attribute [rw] client_key
        #   @return [::String]
        #     Input only. The unencrypted PKCS#1 or PKCS#8 PEM-encoded private key
        #     associated with the Client Certificate. If this field is used then the
        #     'client_certificate' field is mandatory.
        # @!attribute [rw] client_certificate
        #   @return [::String]
        #     Input only. The x509 PEM-encoded certificate that will be used by the
        #     replica to authenticate against the source database server.If this field is
        #     used then the 'client_key' field is mandatory.
        # @!attribute [rw] ca_certificate
        #   @return [::String]
        #     Required. Input only. The x509 PEM-encoded certificate of the CA that
        #     signed the source database server's certificate. The replica will use this
        #     certificate to verify it's connecting to the right host.
        class SslConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Specifies The kind of ssl configuration used.
          module SslType
            # Unspecified.
            SSL_TYPE_UNSPECIFIED = 0

            # Only 'ca_certificate' specified.
            SERVER_ONLY = 1

            # Both server ('ca_certificate'), and client ('client_key',
            # 'client_certificate') specified.
            SERVER_CLIENT = 2
          end
        end

        # Specifies connection parameters required specifically for MySQL databases.
        # @!attribute [rw] host
        #   @return [::String]
        #     Required. The IP or hostname of the source MySQL database.
        # @!attribute [rw] port
        #   @return [::Integer]
        #     Required. The network port of the source MySQL database.
        # @!attribute [rw] username
        #   @return [::String]
        #     Required. The username that Database Migration Service will use to connect
        #     to the database. The value is encrypted when stored in Database Migration
        #     Service.
        # @!attribute [rw] password
        #   @return [::String]
        #     Required. Input only. The password for the user that Database Migration
        #     Service will be using to connect to the database. This field is not
        #     returned on request, and the value is encrypted when stored in Database
        #     Migration Service.
        # @!attribute [r] password_set
        #   @return [::Boolean]
        #     Output only. Indicates If this connection profile password is stored.
        # @!attribute [rw] ssl
        #   @return [::Google::Cloud::CloudDMS::V1::SslConfig]
        #     SSL configuration for the destination to connect to the source database.
        # @!attribute [rw] cloud_sql_id
        #   @return [::String]
        #     If the source is a Cloud SQL database, use this field to
        #     provide the Cloud SQL instance ID of the source.
        class MySqlConnectionProfile
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Specifies connection parameters required specifically for PostgreSQL
        # databases.
        # @!attribute [rw] host
        #   @return [::String]
        #     Required. The IP or hostname of the source PostgreSQL database.
        # @!attribute [rw] port
        #   @return [::Integer]
        #     Required. The network port of the source PostgreSQL database.
        # @!attribute [rw] username
        #   @return [::String]
        #     Required. The username that Database Migration Service will use to connect
        #     to the database. The value is encrypted when stored in Database Migration
        #     Service.
        # @!attribute [rw] password
        #   @return [::String]
        #     Required. Input only. The password for the user that Database Migration
        #     Service will be using to connect to the database. This field is not
        #     returned on request, and the value is encrypted when stored in Database
        #     Migration Service.
        # @!attribute [r] password_set
        #   @return [::Boolean]
        #     Output only. Indicates If this connection profile password is stored.
        # @!attribute [rw] ssl
        #   @return [::Google::Cloud::CloudDMS::V1::SslConfig]
        #     SSL configuration for the destination to connect to the source database.
        # @!attribute [rw] cloud_sql_id
        #   @return [::String]
        #     If the source is a Cloud SQL database, use this field to
        #     provide the Cloud SQL instance ID of the source.
        # @!attribute [r] network_architecture
        #   @return [::Google::Cloud::CloudDMS::V1::NetworkArchitecture]
        #     Output only. If the source is a Cloud SQL database, this field indicates
        #     the network architecture it's associated with.
        # @!attribute [rw] static_ip_connectivity
        #   @return [::Google::Cloud::CloudDMS::V1::StaticIpConnectivity]
        #     Static ip connectivity data (default, no additional details needed).
        #
        #     Note: The following fields are mutually exclusive: `static_ip_connectivity`, `private_service_connect_connectivity`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] private_service_connect_connectivity
        #   @return [::Google::Cloud::CloudDMS::V1::PrivateServiceConnectConnectivity]
        #     Private service connect connectivity.
        #
        #     Note: The following fields are mutually exclusive: `private_service_connect_connectivity`, `static_ip_connectivity`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class PostgreSqlConnectionProfile
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Specifies connection parameters required specifically for Oracle
        # databases.
        # @!attribute [rw] host
        #   @return [::String]
        #     Required. The IP or hostname of the source Oracle database.
        # @!attribute [rw] port
        #   @return [::Integer]
        #     Required. The network port of the source Oracle database.
        # @!attribute [rw] username
        #   @return [::String]
        #     Required. The username that Database Migration Service will use to connect
        #     to the database. The value is encrypted when stored in Database Migration
        #     Service.
        # @!attribute [rw] password
        #   @return [::String]
        #     Required. Input only. The password for the user that Database Migration
        #     Service will be using to connect to the database. This field is not
        #     returned on request, and the value is encrypted when stored in Database
        #     Migration Service.
        # @!attribute [r] password_set
        #   @return [::Boolean]
        #     Output only. Indicates whether a new password is included in the request.
        # @!attribute [rw] database_service
        #   @return [::String]
        #     Required. Database service for the Oracle connection.
        # @!attribute [rw] ssl
        #   @return [::Google::Cloud::CloudDMS::V1::SslConfig]
        #     SSL configuration for the connection to the source Oracle database.
        #
        #      * Only `SERVER_ONLY` configuration is supported for Oracle SSL.
        #      * SSL is supported for Oracle versions 12 and above.
        # @!attribute [rw] static_service_ip_connectivity
        #   @return [::Google::Cloud::CloudDMS::V1::StaticServiceIpConnectivity]
        #     Static Service IP connectivity.
        #
        #     Note: The following fields are mutually exclusive: `static_service_ip_connectivity`, `forward_ssh_connectivity`, `private_connectivity`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] forward_ssh_connectivity
        #   @return [::Google::Cloud::CloudDMS::V1::ForwardSshTunnelConnectivity]
        #     Forward SSH tunnel connectivity.
        #
        #     Note: The following fields are mutually exclusive: `forward_ssh_connectivity`, `static_service_ip_connectivity`, `private_connectivity`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] private_connectivity
        #   @return [::Google::Cloud::CloudDMS::V1::PrivateConnectivity]
        #     Private connectivity.
        #
        #     Note: The following fields are mutually exclusive: `private_connectivity`, `static_service_ip_connectivity`, `forward_ssh_connectivity`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class OracleConnectionProfile
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Specifies required connection parameters, and, optionally, the parameters
        # required to create a Cloud SQL destination database instance.
        # @!attribute [r] cloud_sql_id
        #   @return [::String]
        #     Output only. The Cloud SQL instance ID that this connection profile is
        #     associated with.
        # @!attribute [rw] settings
        #   @return [::Google::Cloud::CloudDMS::V1::CloudSqlSettings]
        #     Immutable. Metadata used to create the destination Cloud SQL database.
        # @!attribute [r] private_ip
        #   @return [::String]
        #     Output only. The Cloud SQL database instance's private IP.
        # @!attribute [r] public_ip
        #   @return [::String]
        #     Output only. The Cloud SQL database instance's public IP.
        # @!attribute [r] additional_public_ip
        #   @return [::String]
        #     Output only. The Cloud SQL database instance's additional (outgoing) public
        #     IP. Used when the Cloud SQL database availability type is REGIONAL (i.e.
        #     multiple zones / highly available).
        class CloudSqlConnectionProfile
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Specifies required connection parameters, and the parameters
        # required to create an AlloyDB destination cluster.
        # @!attribute [rw] cluster_id
        #   @return [::String]
        #     Required. The AlloyDB cluster ID that this connection profile is associated
        #     with.
        # @!attribute [rw] settings
        #   @return [::Google::Cloud::CloudDMS::V1::AlloyDbSettings]
        #     Immutable. Metadata used to create the destination AlloyDB cluster.
        class AlloyDbConnectionProfile
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An entry for an Access Control list.
        # @!attribute [rw] value
        #   @return [::String]
        #     The allowlisted value for the access control list.
        # @!attribute [rw] expire_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time when this access control entry expires in
        #     [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example:
        #     `2012-11-15T16:19:00.094Z`.
        #
        #     Note: The following fields are mutually exclusive: `expire_time`, `ttl`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] ttl
        #   @return [::Google::Protobuf::Duration]
        #     Input only. The time-to-leave of this access control entry.
        #
        #     Note: The following fields are mutually exclusive: `ttl`, `expire_time`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] label
        #   @return [::String]
        #     A label to identify this entry.
        class SqlAclEntry
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # IP Management configuration.
        # @!attribute [rw] enable_ipv4
        #   @return [::Google::Protobuf::BoolValue]
        #     Whether the instance should be assigned an IPv4 address or not.
        # @!attribute [rw] private_network
        #   @return [::String]
        #     The resource link for the VPC network from which the Cloud SQL instance is
        #     accessible for private IP. For example,
        #     `projects/myProject/global/networks/default`. This setting can
        #     be updated, but it cannot be removed after it is set.
        # @!attribute [rw] allocated_ip_range
        #   @return [::String]
        #     Optional. The name of the allocated IP address range for the private IP
        #     Cloud SQL instance. This name refers to an already allocated IP range
        #     address. If set, the instance IP address will be created in the allocated
        #     range. Note that this IP address range can't be modified after the instance
        #     is created. If you change the VPC when configuring connectivity settings
        #     for the migration job, this field is not relevant.
        # @!attribute [rw] require_ssl
        #   @return [::Google::Protobuf::BoolValue]
        #     Whether SSL connections over IP should be enforced or not.
        # @!attribute [rw] authorized_networks
        #   @return [::Array<::Google::Cloud::CloudDMS::V1::SqlAclEntry>]
        #     The list of external networks that are allowed to connect to the instance
        #     using the IP. See
        #     https://en.wikipedia.org/wiki/CIDR_notation#CIDR_notation, also known as
        #     'slash' notation (e.g. `192.168.100.0/24`).
        class SqlIpConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Settings for creating a Cloud SQL database instance.
        # @!attribute [rw] database_version
        #   @return [::Google::Cloud::CloudDMS::V1::CloudSqlSettings::SqlDatabaseVersion]
        #     The database engine type and version.
        # @!attribute [rw] user_labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     The resource labels for a Cloud SQL instance to use to annotate any related
        #     underlying resources such as Compute Engine VMs.
        #     An object containing a list of "key": "value" pairs.
        #
        #     Example: `{ "name": "wrench", "mass": "18kg", "count": "3" }`.
        # @!attribute [rw] tier
        #   @return [::String]
        #     The tier (or machine type) for this instance, for example:
        #     `db-n1-standard-1` (MySQL instances) or
        #     `db-custom-1-3840` (PostgreSQL instances).
        #     For more information, see
        #     [Cloud SQL Instance
        #     Settings](https://cloud.google.com/sql/docs/mysql/instance-settings).
        # @!attribute [rw] storage_auto_resize_limit
        #   @return [::Google::Protobuf::Int64Value]
        #     The maximum size to which storage capacity can be automatically increased.
        #     The default value is 0, which specifies that there is no limit.
        # @!attribute [rw] activation_policy
        #   @return [::Google::Cloud::CloudDMS::V1::CloudSqlSettings::SqlActivationPolicy]
        #     The activation policy specifies when the instance is activated; it is
        #     applicable only when the instance state is 'RUNNABLE'. Valid values:
        #
        #     'ALWAYS': The instance is on, and remains so even in
        #     the absence of connection requests.
        #
        #     `NEVER`: The instance is off; it is not activated, even if a
        #     connection request arrives.
        # @!attribute [rw] ip_config
        #   @return [::Google::Cloud::CloudDMS::V1::SqlIpConfig]
        #     The settings for IP Management. This allows to enable or disable the
        #     instance IP and manage which external networks can connect to the instance.
        #     The IPv4 address cannot be disabled.
        # @!attribute [rw] auto_storage_increase
        #   @return [::Google::Protobuf::BoolValue]
        #     [default: ON] If you enable this setting, Cloud SQL checks your available
        #     storage every 30 seconds. If the available storage falls below a threshold
        #     size, Cloud SQL automatically adds additional storage capacity. If the
        #     available storage repeatedly falls below the threshold size, Cloud SQL
        #     continues to add storage until it reaches the maximum of 30 TB.
        # @!attribute [rw] database_flags
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     The database flags passed to the Cloud SQL instance at startup.
        #     An object containing a list of "key": value pairs.
        #     Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        # @!attribute [rw] data_disk_type
        #   @return [::Google::Cloud::CloudDMS::V1::CloudSqlSettings::SqlDataDiskType]
        #     The type of storage: `PD_SSD` (default) or `PD_HDD`.
        # @!attribute [rw] data_disk_size_gb
        #   @return [::Google::Protobuf::Int64Value]
        #     The storage capacity available to the database, in GB.
        #     The minimum (and default) size is 10GB.
        # @!attribute [rw] zone
        #   @return [::String]
        #     The Google Cloud Platform zone where your Cloud SQL database instance is
        #     located.
        # @!attribute [rw] secondary_zone
        #   @return [::String]
        #     Optional. The Google Cloud Platform zone where the failover Cloud SQL
        #     database instance is located. Used when the Cloud SQL database availability
        #     type is REGIONAL (i.e. multiple zones / highly available).
        # @!attribute [rw] source_id
        #   @return [::String]
        #     The Database Migration Service source connection profile ID,
        #     in the format:
        #     `projects/my_project_name/locations/us-central1/connectionProfiles/connection_profile_ID`
        # @!attribute [rw] root_password
        #   @return [::String]
        #     Input only. Initial root password.
        # @!attribute [r] root_password_set
        #   @return [::Boolean]
        #     Output only. Indicates If this connection profile root password is stored.
        # @!attribute [rw] collation
        #   @return [::String]
        #     The Cloud SQL default instance level collation.
        # @!attribute [rw] cmek_key_name
        #   @return [::String]
        #     The KMS key name used for the csql instance.
        # @!attribute [rw] availability_type
        #   @return [::Google::Cloud::CloudDMS::V1::CloudSqlSettings::SqlAvailabilityType]
        #     Optional. Availability type. Potential values:
        #     *  `ZONAL`: The instance serves data from only one zone. Outages in that
        #     zone affect data availability.
        #     *  `REGIONAL`: The instance can serve data from more than one zone in a
        #     region (it is highly available).
        # @!attribute [rw] edition
        #   @return [::Google::Cloud::CloudDMS::V1::CloudSqlSettings::Edition]
        #     Optional. The edition of the given Cloud SQL instance.
        class CloudSqlSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class UserLabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class DatabaseFlagsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Specifies when the instance should be activated.
          module SqlActivationPolicy
            # unspecified policy.
            SQL_ACTIVATION_POLICY_UNSPECIFIED = 0

            # The instance is always up and running.
            ALWAYS = 1

            # The instance should never spin up.
            NEVER = 2
          end

          # The storage options for Cloud SQL databases.
          module SqlDataDiskType
            # Unspecified.
            SQL_DATA_DISK_TYPE_UNSPECIFIED = 0

            # SSD disk.
            PD_SSD = 1

            # HDD disk.
            PD_HDD = 2
          end

          # The database engine type and version.
          module SqlDatabaseVersion
            # Unspecified version.
            SQL_DATABASE_VERSION_UNSPECIFIED = 0

            # MySQL 5.6.
            MYSQL_5_6 = 1

            # MySQL 5.7.
            MYSQL_5_7 = 2

            # PostgreSQL 9.6.
            POSTGRES_9_6 = 3

            # PostgreSQL 11.
            POSTGRES_11 = 4

            # PostgreSQL 10.
            POSTGRES_10 = 5

            # MySQL 8.0.
            MYSQL_8_0 = 6

            # PostgreSQL 12.
            POSTGRES_12 = 7

            # PostgreSQL 13.
            POSTGRES_13 = 8

            # PostgreSQL 14.
            POSTGRES_14 = 17

            # PostgreSQL 15.
            POSTGRES_15 = 18
          end

          # The availability type of the given Cloud SQL instance.
          module SqlAvailabilityType
            # This is an unknown Availability type.
            SQL_AVAILABILITY_TYPE_UNSPECIFIED = 0

            # Zonal availablility instance.
            ZONAL = 1

            # Regional availability instance.
            REGIONAL = 2
          end

          # The edition of the given Cloud SQL instance.
          # Can be ENTERPRISE or ENTERPRISE_PLUS.
          module Edition
            # The instance did not specify the edition.
            EDITION_UNSPECIFIED = 0

            # The instance is an enterprise edition.
            ENTERPRISE = 2

            # The instance is an enterprise plus edition.
            ENTERPRISE_PLUS = 3
          end
        end

        # Settings for creating an AlloyDB cluster.
        # @!attribute [rw] initial_user
        #   @return [::Google::Cloud::CloudDMS::V1::AlloyDbSettings::UserPassword]
        #     Required. Input only. Initial user to setup during cluster creation.
        #     Required.
        # @!attribute [rw] vpc_network
        #   @return [::String]
        #     Required. The resource link for the VPC network in which cluster resources
        #     are created and from which they are accessible via Private IP. The network
        #     must belong to the same project as the cluster. It is specified in the
        #     form: "projects/\\{project_number}/global/networks/\\{network_id}". This is
        #     required to create a cluster.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels for the AlloyDB cluster created by DMS. An object containing a list
        #     of 'key', 'value' pairs.
        # @!attribute [rw] primary_instance_settings
        #   @return [::Google::Cloud::CloudDMS::V1::AlloyDbSettings::PrimaryInstanceSettings]
        # @!attribute [rw] encryption_config
        #   @return [::Google::Cloud::CloudDMS::V1::AlloyDbSettings::EncryptionConfig]
        #     Optional. The encryption config can be specified to encrypt the data disks
        #     and other persistent data resources of a cluster with a
        #     customer-managed encryption key (CMEK). When this field is not
        #     specified, the cluster will then use default encryption scheme to
        #     protect the user data.
        class AlloyDbSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The username/password for a database user. Used for specifying initial
          # users at cluster creation time.
          # @!attribute [rw] user
          #   @return [::String]
          #     The database username.
          # @!attribute [rw] password
          #   @return [::String]
          #     The initial password for the user.
          # @!attribute [r] password_set
          #   @return [::Boolean]
          #     Output only. Indicates if the initial_user.password field has been set.
          class UserPassword
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Settings for the cluster's primary instance
          # @!attribute [rw] id
          #   @return [::String]
          #     Required. The ID of the AlloyDB primary instance. The ID must satisfy the
          #     regex expression "[a-z0-9-]+".
          # @!attribute [rw] machine_config
          #   @return [::Google::Cloud::CloudDMS::V1::AlloyDbSettings::PrimaryInstanceSettings::MachineConfig]
          #     Configuration for the machines that host the underlying
          #     database engine.
          # @!attribute [rw] database_flags
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Database flags to pass to AlloyDB when DMS is creating the AlloyDB
          #     cluster and instances. See the AlloyDB documentation for how these can be
          #     used.
          # @!attribute [rw] labels
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Labels for the AlloyDB primary instance created by DMS. An object
          #     containing a list of 'key', 'value' pairs.
          # @!attribute [r] private_ip
          #   @return [::String]
          #     Output only. The private IP address for the Instance.
          #     This is the connection endpoint for an end-user application.
          class PrimaryInstanceSettings
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # MachineConfig describes the configuration of a machine.
            # @!attribute [rw] cpu_count
            #   @return [::Integer]
            #     The number of CPU's in the VM instance.
            class MachineConfig
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class DatabaseFlagsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class LabelsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # EncryptionConfig describes the encryption config of a cluster that is
          # encrypted with a CMEK (customer-managed encryption key).
          # @!attribute [rw] kms_key_name
          #   @return [::String]
          #     The fully-qualified resource name of the KMS key.
          #     Each Cloud KMS key is regionalized and has the following format:
          #     projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME]
          class EncryptionConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The source database will allow incoming connections from the public IP of the
        # destination database. You can retrieve the public IP of the Cloud SQL
        # instance from the Cloud SQL console or using Cloud SQL APIs. No additional
        # configuration is required.
        class StaticIpConnectivity
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # [Private Service Connect
        # connectivity](https://cloud.google.com/vpc/docs/private-service-connect#service-attachments)
        # @!attribute [rw] service_attachment
        #   @return [::String]
        #     Required. A service attachment that exposes a database, and has the
        #     following format:
        #     projects/\\{project}/regions/\\{region}/serviceAttachments/\\{service_attachment_name}
        class PrivateServiceConnectConnectivity
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The details needed to configure a reverse SSH tunnel between the source and
        # destination databases. These details will be used when calling the
        # generateSshScript method (see
        # https://cloud.google.com/database-migration/docs/reference/rest/v1/projects.locations.migrationJobs/generateSshScript)
        # to produce the script that will help set up the reverse SSH tunnel, and to
        # set up the VPC peering between the Cloud SQL private network and the VPC.
        # @!attribute [rw] vm_ip
        #   @return [::String]
        #     Required. The IP of the virtual machine (Compute Engine) used as the
        #     bastion server for the SSH tunnel.
        # @!attribute [rw] vm_port
        #   @return [::Integer]
        #     Required. The forwarding port of the virtual machine (Compute Engine) used
        #     as the bastion server for the SSH tunnel.
        # @!attribute [rw] vm
        #   @return [::String]
        #     The name of the virtual machine (Compute Engine) used as the bastion server
        #     for the SSH tunnel.
        # @!attribute [rw] vpc
        #   @return [::String]
        #     The name of the VPC to peer with the Cloud SQL private network.
        class ReverseSshConnectivity
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The details of the VPC where the source database is located in Google Cloud.
        # We will use this information to set up the VPC peering connection between
        # Cloud SQL and this VPC.
        # @!attribute [rw] vpc
        #   @return [::String]
        #     The name of the VPC network to peer with the Cloud SQL private network.
        class VpcPeeringConnectivity
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Forward SSH Tunnel connectivity.
        # @!attribute [rw] hostname
        #   @return [::String]
        #     Required. Hostname for the SSH tunnel.
        # @!attribute [rw] username
        #   @return [::String]
        #     Required. Username for the SSH tunnel.
        # @!attribute [rw] port
        #   @return [::Integer]
        #     Port for the SSH tunnel, default value is 22.
        # @!attribute [rw] password
        #   @return [::String]
        #     Input only. SSH password.
        #
        #     Note: The following fields are mutually exclusive: `password`, `private_key`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] private_key
        #   @return [::String]
        #     Input only. SSH private key.
        #
        #     Note: The following fields are mutually exclusive: `private_key`, `password`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class ForwardSshTunnelConnectivity
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Static IP address connectivity configured on service project.
        class StaticServiceIpConnectivity
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Private Connectivity.
        # @!attribute [rw] private_connection
        #   @return [::String]
        #     Required. The resource name (URI) of the private connection.
        class PrivateConnectivity
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A message defining the database engine and provider.
        # @!attribute [rw] provider
        #   @return [::Google::Cloud::CloudDMS::V1::DatabaseProvider]
        #     The database provider.
        # @!attribute [rw] engine
        #   @return [::Google::Cloud::CloudDMS::V1::DatabaseEngine]
        #     The database engine.
        class DatabaseType
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a Database Migration Service migration job object.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name (URI) of this migration job resource, in the form of:
        #     projects/\\{project}/locations/\\{location}/migrationJobs/\\{migrationJob}.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the migration job resource was created.
        #     A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
        #     Example: "2014-10-02T15:01:23.045123456Z".
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the migration job resource was last
        #     updated. A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
        #     Example: "2014-10-02T15:01:23.045123456Z".
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     The resource labels for migration job to use to annotate any related
        #     underlying resources such as Compute Engine VMs. An object containing a
        #     list of "key": "value" pairs.
        #
        #     Example: `{ "name": "wrench", "mass": "1.3kg", "count": "3" }`.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     The migration job display name.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::CloudDMS::V1::MigrationJob::State]
        #     The current migration job state.
        # @!attribute [r] phase
        #   @return [::Google::Cloud::CloudDMS::V1::MigrationJob::Phase]
        #     Output only. The current migration job phase.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::CloudDMS::V1::MigrationJob::Type]
        #     Required. The migration job type.
        # @!attribute [rw] dump_path
        #   @return [::String]
        #     The path to the dump file in Google Cloud Storage,
        #     in the format: (gs://[BUCKET_NAME]/[OBJECT_NAME]).
        #     This field and the "dump_flags" field are mutually exclusive.
        # @!attribute [rw] dump_flags
        #   @return [::Google::Cloud::CloudDMS::V1::MigrationJob::DumpFlags]
        #     The initial dump flags.
        #     This field and the "dump_path" field are mutually exclusive.
        # @!attribute [rw] source
        #   @return [::String]
        #     Required. The resource name (URI) of the source connection profile.
        # @!attribute [rw] destination
        #   @return [::String]
        #     Required. The resource name (URI) of the destination connection profile.
        # @!attribute [rw] reverse_ssh_connectivity
        #   @return [::Google::Cloud::CloudDMS::V1::ReverseSshConnectivity]
        #     The details needed to communicate to the source over Reverse SSH
        #     tunnel connectivity.
        #
        #     Note: The following fields are mutually exclusive: `reverse_ssh_connectivity`, `vpc_peering_connectivity`, `static_ip_connectivity`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] vpc_peering_connectivity
        #   @return [::Google::Cloud::CloudDMS::V1::VpcPeeringConnectivity]
        #     The details of the VPC network that the source database is located in.
        #
        #     Note: The following fields are mutually exclusive: `vpc_peering_connectivity`, `reverse_ssh_connectivity`, `static_ip_connectivity`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] static_ip_connectivity
        #   @return [::Google::Cloud::CloudDMS::V1::StaticIpConnectivity]
        #     static ip connectivity data (default, no additional details needed).
        #
        #     Note: The following fields are mutually exclusive: `static_ip_connectivity`, `reverse_ssh_connectivity`, `vpc_peering_connectivity`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] duration
        #   @return [::Google::Protobuf::Duration]
        #     Output only. The duration of the migration job (in seconds). A duration in
        #     seconds with up to nine fractional digits, terminated by 's'. Example:
        #     "3.5s".
        # @!attribute [r] error
        #   @return [::Google::Rpc::Status]
        #     Output only. The error details in case of state FAILED.
        # @!attribute [rw] source_database
        #   @return [::Google::Cloud::CloudDMS::V1::DatabaseType]
        #     The database engine type and provider of the source.
        # @!attribute [rw] destination_database
        #   @return [::Google::Cloud::CloudDMS::V1::DatabaseType]
        #     The database engine type and provider of the destination.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. If the migration job is completed, the time when it was
        #     completed.
        # @!attribute [rw] conversion_workspace
        #   @return [::Google::Cloud::CloudDMS::V1::ConversionWorkspaceInfo]
        #     The conversion workspace used by the migration.
        # @!attribute [rw] filter
        #   @return [::String]
        #     This field can be used to select the entities to migrate as part of
        #     the migration job. It uses AIP-160 notation to select a subset of the
        #     entities configured on the associated conversion-workspace. This field
        #     should not be set on migration-jobs that are not associated with a
        #     conversion workspace.
        # @!attribute [rw] cmek_key_name
        #   @return [::String]
        #     The CMEK (customer-managed encryption key) fully qualified key name used
        #     for the migration job.
        #     This field supports all migration jobs types except for:
        #     * Mysql to Mysql (use the cmek field in the cloudsql connection profile
        #     instead).
        #     * PostrgeSQL to PostgreSQL (use the cmek field in the cloudsql
        #     connection profile instead).
        #     * PostgreSQL to AlloyDB (use the kms_key_name field in the alloydb
        #     connection profile instead).
        #     Each Cloud CMEK key has the following format:
        #     projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME]
        # @!attribute [rw] performance_config
        #   @return [::Google::Cloud::CloudDMS::V1::MigrationJob::PerformanceConfig]
        #     Optional. Data dump parallelism settings used by the migration.
        #     Currently applicable only for MySQL to Cloud SQL for MySQL migrations only.
        class MigrationJob
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Dump flag definition.
          # @!attribute [rw] name
          #   @return [::String]
          #     The name of the flag
          # @!attribute [rw] value
          #   @return [::String]
          #     The value of the flag.
          class DumpFlag
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Dump flags definition.
          # @!attribute [rw] dump_flags
          #   @return [::Array<::Google::Cloud::CloudDMS::V1::MigrationJob::DumpFlag>]
          #     The flags for the initial dump.
          class DumpFlags
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Performance configuration definition.
          # @!attribute [rw] dump_parallel_level
          #   @return [::Google::Cloud::CloudDMS::V1::MigrationJob::PerformanceConfig::DumpParallelLevel]
          #     Initial dump parallelism level.
          class PerformanceConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Describes the parallelism level during initial dump.
            module DumpParallelLevel
              # Unknown dump parallel level. Will be defaulted to OPTIMAL.
              DUMP_PARALLEL_LEVEL_UNSPECIFIED = 0

              # Minimal parallel level.
              MIN = 1

              # Optimal parallel level.
              OPTIMAL = 2

              # Maximum parallel level.
              MAX = 3
            end
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The current migration job states.
          module State
            # The state of the migration job is unknown.
            STATE_UNSPECIFIED = 0

            # The migration job is down for maintenance.
            MAINTENANCE = 1

            # The migration job is in draft mode and no resources are created.
            DRAFT = 2

            # The migration job is being created.
            CREATING = 3

            # The migration job is created and not started.
            NOT_STARTED = 4

            # The migration job is running.
            RUNNING = 5

            # The migration job failed.
            FAILED = 6

            # The migration job has been completed.
            COMPLETED = 7

            # The migration job is being deleted.
            DELETING = 8

            # The migration job is being stopped.
            STOPPING = 9

            # The migration job is currently stopped.
            STOPPED = 10

            # The migration job has been deleted.
            DELETED = 11

            # The migration job is being updated.
            UPDATING = 12

            # The migration job is starting.
            STARTING = 13

            # The migration job is restarting.
            RESTARTING = 14

            # The migration job is resuming.
            RESUMING = 15
          end

          # The current migration job phase.
          module Phase
            # The phase of the migration job is unknown.
            PHASE_UNSPECIFIED = 0

            # The migration job is in the full dump phase.
            FULL_DUMP = 1

            # The migration job is CDC phase.
            CDC = 2

            # The migration job is running the promote phase.
            PROMOTE_IN_PROGRESS = 3

            # Only RDS flow - waiting for source writes to stop
            WAITING_FOR_SOURCE_WRITES_TO_STOP = 4

            # Only RDS flow - the sources writes stopped, waiting for dump to begin
            PREPARING_THE_DUMP = 5
          end

          # The type of migration job (one-time or continuous).
          module Type
            # The type of the migration job is unknown.
            TYPE_UNSPECIFIED = 0

            # The migration job is a one time migration.
            ONE_TIME = 1

            # The migration job is a continuous migration.
            CONTINUOUS = 2
          end
        end

        # A conversion workspace's version.
        # @!attribute [rw] name
        #   @return [::String]
        #     The resource name (URI) of the conversion workspace.
        # @!attribute [rw] commit_id
        #   @return [::String]
        #     The commit ID of the conversion workspace.
        class ConversionWorkspaceInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A connection profile definition.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of this connection profile resource in the form of
        #     projects/\\{project}/locations/\\{location}/connectionProfiles/\\{connectionProfile}.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the resource was created.
        #     A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
        #     Example: "2014-10-02T15:01:23.045123456Z".
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the resource was last updated.
        #     A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
        #     Example: "2014-10-02T15:01:23.045123456Z".
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     The resource labels for connection profile to use to annotate any related
        #     underlying resources such as Compute Engine VMs. An object containing a
        #     list of "key": "value" pairs.
        #
        #     Example: `{ "name": "wrench", "mass": "1.3kg", "count": "3" }`.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::CloudDMS::V1::ConnectionProfile::State]
        #     The current connection profile state (e.g. DRAFT, READY, or FAILED).
        # @!attribute [rw] display_name
        #   @return [::String]
        #     The connection profile display name.
        # @!attribute [rw] mysql
        #   @return [::Google::Cloud::CloudDMS::V1::MySqlConnectionProfile]
        #     A MySQL database connection profile.
        #
        #     Note: The following fields are mutually exclusive: `mysql`, `postgresql`, `oracle`, `cloudsql`, `alloydb`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] postgresql
        #   @return [::Google::Cloud::CloudDMS::V1::PostgreSqlConnectionProfile]
        #     A PostgreSQL database connection profile.
        #
        #     Note: The following fields are mutually exclusive: `postgresql`, `mysql`, `oracle`, `cloudsql`, `alloydb`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] oracle
        #   @return [::Google::Cloud::CloudDMS::V1::OracleConnectionProfile]
        #     An Oracle database connection profile.
        #
        #     Note: The following fields are mutually exclusive: `oracle`, `mysql`, `postgresql`, `cloudsql`, `alloydb`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] cloudsql
        #   @return [::Google::Cloud::CloudDMS::V1::CloudSqlConnectionProfile]
        #     A CloudSQL database connection profile.
        #
        #     Note: The following fields are mutually exclusive: `cloudsql`, `mysql`, `postgresql`, `oracle`, `alloydb`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] alloydb
        #   @return [::Google::Cloud::CloudDMS::V1::AlloyDbConnectionProfile]
        #     An AlloyDB cluster connection profile.
        #
        #     Note: The following fields are mutually exclusive: `alloydb`, `mysql`, `postgresql`, `oracle`, `cloudsql`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] error
        #   @return [::Google::Rpc::Status]
        #     Output only. The error details in case of state FAILED.
        # @!attribute [rw] provider
        #   @return [::Google::Cloud::CloudDMS::V1::DatabaseProvider]
        #     The database provider.
        class ConnectionProfile
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The current connection profile state (e.g. DRAFT, READY, or FAILED).
          module State
            # The state of the connection profile is unknown.
            STATE_UNSPECIFIED = 0

            # The connection profile is in draft mode and fully editable.
            DRAFT = 1

            # The connection profile is being created.
            CREATING = 2

            # The connection profile is ready.
            READY = 3

            # The connection profile is being updated.
            UPDATING = 4

            # The connection profile is being deleted.
            DELETING = 5

            # The connection profile has been deleted.
            DELETED = 6

            # The last action on the connection profile failed.
            FAILED = 7
          end
        end

        # Error message of a verification Migration job.
        # @!attribute [r] error_code
        #   @return [::Google::Cloud::CloudDMS::V1::MigrationJobVerificationError::ErrorCode]
        #     Output only. An instance of ErrorCode specifying the error that occurred.
        # @!attribute [r] error_message
        #   @return [::String]
        #     Output only. A formatted message with further details about the error and a
        #     CTA.
        # @!attribute [r] error_detail_message
        #   @return [::String]
        #     Output only. A specific detailed error message, if supplied by the engine.
        class MigrationJobVerificationError
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A general error code describing the type of error that occurred.
          module ErrorCode
            # An unknown error occurred
            ERROR_CODE_UNSPECIFIED = 0

            # We failed to connect to one of the connection profile.
            CONNECTION_FAILURE = 1

            # We failed to authenticate to one of the connection profile.
            AUTHENTICATION_FAILURE = 2

            # One of the involved connection profiles has an invalid configuration.
            INVALID_CONNECTION_PROFILE_CONFIG = 3

            # The versions of the source and the destination are incompatible.
            VERSION_INCOMPATIBILITY = 4

            # The types of the source and the destination are incompatible.
            CONNECTION_PROFILE_TYPES_INCOMPATIBILITY = 5

            # No pglogical extension installed on databases, applicable for postgres.
            NO_PGLOGICAL_INSTALLED = 7

            # pglogical node already exists on databases, applicable for postgres.
            PGLOGICAL_NODE_ALREADY_EXISTS = 8

            # The value of parameter wal_level is not set to logical.
            INVALID_WAL_LEVEL = 9

            # The value of parameter shared_preload_libraries does not include
            # pglogical.
            INVALID_SHARED_PRELOAD_LIBRARY = 10

            # The value of parameter max_replication_slots is not sufficient.
            INSUFFICIENT_MAX_REPLICATION_SLOTS = 11

            # The value of parameter max_wal_senders is not sufficient.
            INSUFFICIENT_MAX_WAL_SENDERS = 12

            # The value of parameter max_worker_processes is not sufficient.
            INSUFFICIENT_MAX_WORKER_PROCESSES = 13

            # Extensions installed are either not supported or having unsupported
            # versions.
            UNSUPPORTED_EXTENSIONS = 14

            # Unsupported migration type.
            UNSUPPORTED_MIGRATION_TYPE = 15

            # Invalid RDS logical replication.
            INVALID_RDS_LOGICAL_REPLICATION = 16

            # The gtid_mode is not supported, applicable for MySQL.
            UNSUPPORTED_GTID_MODE = 17

            # The table definition is not support due to missing primary key or replica
            # identity.
            UNSUPPORTED_TABLE_DEFINITION = 18

            # The definer is not supported.
            UNSUPPORTED_DEFINER = 19

            # Migration is already running at the time of restart request.
            CANT_RESTART_RUNNING_MIGRATION = 21

            # The source already has a replication setup.
            SOURCE_ALREADY_SETUP = 23

            # The source has tables with limited support.
            # E.g. PostgreSQL tables without primary keys.
            TABLES_WITH_LIMITED_SUPPORT = 24

            # The source uses an unsupported locale.
            UNSUPPORTED_DATABASE_LOCALE = 25

            # The source uses an unsupported Foreign Data Wrapper configuration.
            UNSUPPORTED_DATABASE_FDW_CONFIG = 26

            # There was an underlying RDBMS error.
            ERROR_RDBMS = 27

            # The source DB size in Bytes exceeds a certain threshold. The migration
            # might require an increase of quota, or might not be supported.
            SOURCE_SIZE_EXCEEDS_THRESHOLD = 28

            # The destination DB contains existing databases that are conflicting with
            # those in the source DB.
            EXISTING_CONFLICTING_DATABASES = 29

            # Insufficient privilege to enable the parallelism configuration.
            PARALLEL_IMPORT_INSUFFICIENT_PRIVILEGE = 30
          end
        end

        # The PrivateConnection resource is used to establish private connectivity
        # with the customer's network.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the resource.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The create time of the resource.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The last update time of the resource.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     The resource labels for private connections to use to annotate any related
        #     underlying resources such as Compute Engine VMs. An object containing a
        #     list of "key": "value" pairs.
        #
        #     Example: `{ "name": "wrench", "mass": "1.3kg", "count": "3" }`.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     The private connection display name.
        # @!attribute [r] state
        #   @return [::Google::Cloud::CloudDMS::V1::PrivateConnection::State]
        #     Output only. The state of the private connection.
        # @!attribute [r] error
        #   @return [::Google::Rpc::Status]
        #     Output only. The error details in case of state FAILED.
        # @!attribute [rw] vpc_peering_config
        #   @return [::Google::Cloud::CloudDMS::V1::VpcPeeringConfig]
        #     VPC peering configuration.
        class PrivateConnection
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Private Connection state.
          module State
            STATE_UNSPECIFIED = 0

            # The private connection is in creation state - creating resources.
            CREATING = 1

            # The private connection has been created with all of its resources.
            CREATED = 2

            # The private connection creation has failed.
            FAILED = 3

            # The private connection is being deleted.
            DELETING = 4

            # Delete request has failed, resource is in invalid state.
            FAILED_TO_DELETE = 5

            # The private connection has been deleted.
            DELETED = 6
          end
        end

        # The VPC peering configuration is used to create VPC peering with the
        # consumer's VPC.
        # @!attribute [rw] vpc_name
        #   @return [::String]
        #     Required. Fully qualified name of the VPC that Database Migration Service
        #     will peer to.
        # @!attribute [rw] subnet
        #   @return [::String]
        #     Required. A free subnet for peering. (CIDR of /29)
        class VpcPeeringConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        module NetworkArchitecture
          NETWORK_ARCHITECTURE_UNSPECIFIED = 0

          # Instance is in Cloud SQL's old producer network architecture.
          NETWORK_ARCHITECTURE_OLD_CSQL_PRODUCER = 1

          # Instance is in Cloud SQL's new producer network architecture.
          NETWORK_ARCHITECTURE_NEW_CSQL_PRODUCER = 2
        end

        # The database engine types.
        module DatabaseEngine
          # The source database engine of the migration job is unknown.
          DATABASE_ENGINE_UNSPECIFIED = 0

          # The source engine is MySQL.
          MYSQL = 1

          # The source engine is PostgreSQL.
          POSTGRESQL = 2

          # The source engine is Oracle.
          ORACLE = 4
        end

        # The database providers.
        module DatabaseProvider
          # The database provider is unknown.
          DATABASE_PROVIDER_UNSPECIFIED = 0

          # CloudSQL runs the database.
          CLOUDSQL = 1

          # RDS runs the database.
          RDS = 2

          # Amazon Aurora.
          AURORA = 3

          # AlloyDB.
          ALLOYDB = 4
        end
      end
    end
  end
end
