# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module CloudDMS
      module V1
        # Retrieves a list of all migration jobs in a given project and location.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent which owns this collection of migrationJobs.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of migration jobs to return. The service may return
        #     fewer than this value. If unspecified, at most 50 migration jobs will be
        #     returned. The maximum value is 1000; values above 1000 are coerced to
        #     1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The nextPageToken value received in the previous call to
        #     migrationJobs.list, used in the subsequent request to retrieve the next
        #     page of results. On first call this should be left blank. When paginating,
        #     all other parameters provided to migrationJobs.list must match the call
        #     that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters migration jobs listed in the response.
        #     The expression must specify the field name, a comparison operator, and the
        #     value that you want to use for filtering. The value must be a string,
        #     a number, or a boolean. The comparison operator must be
        #     either =, !=, >, or <. For example, list migration jobs created this year
        #     by specifying **createTime %gt; 2020-01-01T00:00:00.000000000Z.**
        #     You can also filter nested fields. For example, you could specify
        #     **reverseSshConnectivity.vmIp = "1.2.3.4"** to select all migration
        #     jobs connecting through the specific SSH tunnel bastion.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sort the results based on the migration job name.
        #     Valid values are: "name", "name asc", and "name desc".
        class ListMigrationJobsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for 'ListMigrationJobs' request.
        # @!attribute [rw] migration_jobs
        #   @return [::Array<::Google::Cloud::CloudDMS::V1::MigrationJob>]
        #     The list of migration jobs objects.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListMigrationJobsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'GetMigrationJob' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the migration job resource to get.
        class GetMigrationJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message to create a new Database Migration Service migration job
        # in the specified project and region.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent which owns this collection of migration jobs.
        # @!attribute [rw] migration_job_id
        #   @return [::String]
        #     Required. The ID of the instance to create.
        # @!attribute [rw] migration_job
        #   @return [::Google::Cloud::CloudDMS::V1::MigrationJob]
        #     Required. Represents a [migration
        #     job](https://cloud.google.com/database-migration/docs/reference/rest/v1/projects.locations.migrationJobs)
        #     object.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A unique ID used to identify the request. If the server receives
        #     two requests with the same ID, then the second request is ignored.
        #
        #     It is recommended to always set this value to a UUID.
        #
        #     The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
        #     (_), and hyphens (-). The maximum length is 40 characters.
        class CreateMigrationJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'UpdateMigrationJob' request.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten by the
        #     update in the conversion workspace resource.
        # @!attribute [rw] migration_job
        #   @return [::Google::Cloud::CloudDMS::V1::MigrationJob]
        #     Required. The migration job parameters to update.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     A unique ID used to identify the request. If the server receives two
        #     requests with the same ID, then the second request is ignored.
        #
        #     It is recommended to always set this value to a UUID.
        #
        #     The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
        #     (_), and hyphens (-). The maximum length is 40 characters.
        class UpdateMigrationJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'DeleteMigrationJob' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the migration job resource to delete.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     A unique ID used to identify the request. If the server receives two
        #     requests with the same ID, then the second request is ignored.
        #
        #     It is recommended to always set this value to a UUID.
        #
        #     The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
        #     (_), and hyphens (-). The maximum length is 40 characters.
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     The destination CloudSQL connection profile is always deleted with the
        #     migration job. In case of force delete, the destination CloudSQL replica
        #     database is also deleted.
        class DeleteMigrationJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'StartMigrationJob' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the migration job resource to start.
        # @!attribute [rw] skip_validation
        #   @return [::Boolean]
        #     Optional. Start the migration job without running prior configuration
        #     verification. Defaults to `false`.
        class StartMigrationJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'StopMigrationJob' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the migration job resource to stop.
        class StopMigrationJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'ResumeMigrationJob' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the migration job resource to resume.
        class ResumeMigrationJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'PromoteMigrationJob' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the migration job resource to promote.
        class PromoteMigrationJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'VerifyMigrationJob' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the migration job resource to verify.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to specify the changed fields to be verified.
        #     It will not update the migration job.
        # @!attribute [rw] migration_job
        #   @return [::Google::Cloud::CloudDMS::V1::MigrationJob]
        #     Optional. The changed migration job parameters to verify.
        #     It will not update the migration job.
        class VerifyMigrationJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'RestartMigrationJob' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the migration job resource to restart.
        # @!attribute [rw] skip_validation
        #   @return [::Boolean]
        #     Optional. Restart the migration job without running prior configuration
        #     verification. Defaults to `false`.
        class RestartMigrationJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'GenerateSshScript' request.
        # @!attribute [rw] migration_job
        #   @return [::String]
        #     Name of the migration job resource to generate the SSH script.
        # @!attribute [rw] vm
        #   @return [::String]
        #     Required. Bastion VM Instance name to use or to create.
        # @!attribute [rw] vm_creation_config
        #   @return [::Google::Cloud::CloudDMS::V1::VmCreationConfig]
        #     The VM creation configuration
        #
        #     Note: The following fields are mutually exclusive: `vm_creation_config`, `vm_selection_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] vm_selection_config
        #   @return [::Google::Cloud::CloudDMS::V1::VmSelectionConfig]
        #     The VM selection configuration
        #
        #     Note: The following fields are mutually exclusive: `vm_selection_config`, `vm_creation_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] vm_port
        #   @return [::Integer]
        #     The port that will be open on the bastion host.
        class GenerateSshScriptRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # VM creation configuration message
        # @!attribute [rw] vm_machine_type
        #   @return [::String]
        #     Required. VM instance machine type to create.
        # @!attribute [rw] vm_zone
        #   @return [::String]
        #     The Google Cloud Platform zone to create the VM in.
        # @!attribute [rw] subnet
        #   @return [::String]
        #     The subnet name the vm needs to be created in.
        class VmCreationConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # VM selection configuration message
        # @!attribute [rw] vm_zone
        #   @return [::String]
        #     Required. The Google Cloud Platform zone the VM is located.
        class VmSelectionConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for 'GenerateSshScript' request.
        # @!attribute [rw] script
        #   @return [::String]
        #     The ssh configuration script.
        class SshScript
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'GenerateTcpProxyScript' request.
        # @!attribute [rw] migration_job
        #   @return [::String]
        #     Name of the migration job resource to generate the TCP Proxy script.
        # @!attribute [rw] vm_name
        #   @return [::String]
        #     Required. The name of the Compute instance that will host the proxy.
        # @!attribute [rw] vm_machine_type
        #   @return [::String]
        #     Required. The type of the Compute instance that will host the proxy.
        # @!attribute [rw] vm_zone
        #   @return [::String]
        #     Optional. The Google Cloud Platform zone to create the VM in. The fully
        #     qualified name of the zone must be specified, including the region name,
        #     for example "us-central1-b". If not specified, uses the "-b" zone of the
        #     destination Connection Profile's region.
        # @!attribute [rw] vm_subnet
        #   @return [::String]
        #     Required. The name of the subnet the Compute instance will use for private
        #     connectivity. Must be supplied in the form of
        #     projects/\\{project}/regions/\\{region}/subnetworks/\\{subnetwork}.
        #     Note: the region for the subnet must match the Compute instance region.
        class GenerateTcpProxyScriptRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for 'GenerateTcpProxyScript' request.
        # @!attribute [rw] script
        #   @return [::String]
        #     The TCP Proxy configuration script.
        class TcpProxyScript
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'ListConnectionProfiles' request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent which owns this collection of connection profiles.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of connection profiles to return. The service may return
        #     fewer than this value. If unspecified, at most 50 connection profiles will
        #     be returned. The maximum value is 1000; values above 1000 are coerced
        #     to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListConnectionProfiles` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListConnectionProfiles`
        #     must match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters connection profiles listed in the
        #     response. The expression must specify the field name, a comparison
        #     operator, and the value that you want to use for filtering. The value must
        #     be a string, a number, or a boolean. The comparison operator must be either
        #     =, !=, >, or <. For example, list connection profiles created this year by
        #     specifying **createTime %gt; 2020-01-01T00:00:00.000000000Z**. You can
        #     also filter nested fields. For example, you could specify **mySql.username
        #     = %lt;my_username%gt;** to list all connection profiles configured to
        #     connect with a specific username.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     A comma-separated list of fields to order results according to.
        class ListConnectionProfilesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for 'ListConnectionProfiles' request.
        # @!attribute [rw] connection_profiles
        #   @return [::Array<::Google::Cloud::CloudDMS::V1::ConnectionProfile>]
        #     The response list of connection profiles.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListConnectionProfilesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'GetConnectionProfile' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the connection profile resource to get.
        class GetConnectionProfileRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'CreateConnectionProfile' request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent which owns this collection of connection profiles.
        # @!attribute [rw] connection_profile_id
        #   @return [::String]
        #     Required. The connection profile identifier.
        # @!attribute [rw] connection_profile
        #   @return [::Google::Cloud::CloudDMS::V1::ConnectionProfile]
        #     Required. The create request body including the connection profile data
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A unique ID used to identify the request. If the server receives
        #     two requests with the same ID, then the second request is ignored.
        #
        #     It is recommended to always set this value to a UUID.
        #
        #     The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
        #     (_), and hyphens (-). The maximum length is 40 characters.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. Only validate the connection profile, but don't create any
        #     resources. The default is false. Only supported for Oracle connection
        #     profiles.
        # @!attribute [rw] skip_validation
        #   @return [::Boolean]
        #     Optional. Create the connection profile without validating it.
        #     The default is false.
        #     Only supported for Oracle connection profiles.
        class CreateConnectionProfileRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'UpdateConnectionProfile' request.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten by the
        #     update in the conversion workspace resource.
        # @!attribute [rw] connection_profile
        #   @return [::Google::Cloud::CloudDMS::V1::ConnectionProfile]
        #     Required. The connection profile parameters to update.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A unique ID used to identify the request. If the server receives
        #     two requests with the same ID, then the second request is ignored.
        #
        #     It is recommended to always set this value to a UUID.
        #
        #     The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
        #     (_), and hyphens (-). The maximum length is 40 characters.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. Only validate the connection profile, but don't update any
        #     resources. The default is false. Only supported for Oracle connection
        #     profiles.
        # @!attribute [rw] skip_validation
        #   @return [::Boolean]
        #     Optional. Update the connection profile without validating it.
        #     The default is false.
        #     Only supported for Oracle connection profiles.
        class UpdateConnectionProfileRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'DeleteConnectionProfile' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the connection profile resource to delete.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     A unique ID used to identify the request. If the server receives two
        #     requests with the same ID, then the second request is ignored.
        #
        #     It is recommended to always set this value to a UUID.
        #
        #     The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
        #     (_), and hyphens (-). The maximum length is 40 characters.
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     In case of force delete, the CloudSQL replica database is also deleted
        #     (only for CloudSQL connection profile).
        class DeleteConnectionProfileRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message to create a new private connection in the specified project
        # and region.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent that owns the collection of PrivateConnections.
        # @!attribute [rw] private_connection_id
        #   @return [::String]
        #     Required. The private connection identifier.
        # @!attribute [rw] private_connection
        #   @return [::Google::Cloud::CloudDMS::V1::PrivateConnection]
        #     Required. The private connection resource to create.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A unique ID used to identify the request. If the server receives
        #     two requests with the same ID, then the second request is ignored.
        #
        #     It is recommended to always set this value to a UUID.
        #
        #     The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
        #     (_), and hyphens (-). The maximum length is 40 characters.
        # @!attribute [rw] skip_validation
        #   @return [::Boolean]
        #     Optional. If set to true, will skip validations.
        class CreatePrivateConnectionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message to retrieve a list of private connections in a given project
        # and location.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent that owns the collection of private connections.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Maximum number of private connections to return.
        #     If unspecified, at most 50 private connections that are returned.
        #     The maximum value is 1000; values above 1000 are coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Page token received from a previous `ListPrivateConnections` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `ListPrivateConnections` must match the call that provided the page
        #     token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters private connections listed in the
        #     response. The expression must specify the field name, a comparison
        #     operator, and the value that you want to use for filtering. The value must
        #     be a string, a number, or a boolean. The comparison operator must be either
        #     =, !=, >, or <. For example, list private connections created this year by
        #     specifying **createTime %gt; 2021-01-01T00:00:00.000000000Z**.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Order by fields for the result.
        class ListPrivateConnectionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for 'ListPrivateConnections' request.
        # @!attribute [rw] private_connections
        #   @return [::Array<::Google::Cloud::CloudDMS::V1::PrivateConnection>]
        #     List of private connections.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListPrivateConnectionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message to delete a private connection.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the private connection to delete.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A unique ID used to identify the request. If the server receives
        #     two requests with the same ID, then the second request is ignored.
        #
        #     It is recommended to always set this value to a UUID.
        #
        #     The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
        #     (_), and hyphens (-). The maximum length is 40 characters.
        class DeletePrivateConnectionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message to get a private connection resource.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the private connection to get.
        class GetPrivateConnectionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the metadata of the long-running operation.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [r] target
        #   @return [::String]
        #     Output only. Server-defined resource path for the target of the operation.
        # @!attribute [r] verb
        #   @return [::String]
        #     Output only. Name of the verb executed by the operation.
        # @!attribute [r] status_message
        #   @return [::String]
        #     Output only. Human-readable status of the operation, if any.
        # @!attribute [r] requested_cancellation
        #   @return [::Boolean]
        #     Output only. Identifies whether the user has requested cancellation
        #     of the operation. Operations that have successfully been cancelled
        #     have
        #     {::Google::Longrunning::Operation#error google.longrunning.Operation.error}
        #     value with a {::Google::Rpc::Status#code google.rpc.Status.code} of 1,
        #     corresponding to `Code.CANCELLED`.
        # @!attribute [r] api_version
        #   @return [::String]
        #     Output only. API version used to start the operation.
        class OperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Retrieve a list of all conversion workspaces in a given project and location.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent which owns this collection of conversion workspaces.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of conversion workspaces to return. The service may
        #     return fewer than this value. If unspecified, at most 50 sets are returned.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The nextPageToken value received in the previous call to
        #     conversionWorkspaces.list, used in the subsequent request to retrieve the
        #     next page of results. On first call this should be left blank. When
        #     paginating, all other parameters provided to conversionWorkspaces.list must
        #     match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters conversion workspaces listed in the
        #     response. The expression must specify the field name, a comparison
        #     operator, and the value that you want to use for filtering. The value must
        #     be a string, a number, or a boolean. The comparison operator must be either
        #     =, !=, >, or <. For example, list conversion workspaces created this year
        #     by specifying **createTime %gt; 2020-01-01T00:00:00.000000000Z.** You can
        #     also filter nested fields. For example, you could specify
        #     **source.version = "12.c.1"** to select all conversion workspaces with
        #     source database version equal to 12.c.1.
        class ListConversionWorkspacesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for 'ListConversionWorkspaces' request.
        # @!attribute [rw] conversion_workspaces
        #   @return [::Array<::Google::Cloud::CloudDMS::V1::ConversionWorkspace>]
        #     The list of conversion workspace objects.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListConversionWorkspacesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'GetConversionWorkspace' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the conversion workspace resource to get.
        class GetConversionWorkspaceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message to create a new Conversion Workspace
        # in the specified project and region.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent which owns this collection of conversion workspaces.
        # @!attribute [rw] conversion_workspace_id
        #   @return [::String]
        #     Required. The ID of the conversion workspace to create.
        # @!attribute [rw] conversion_workspace
        #   @return [::Google::Cloud::CloudDMS::V1::ConversionWorkspace]
        #     Required. Represents a conversion workspace object.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     A unique ID used to identify the request. If the server receives two
        #     requests with the same ID, then the second request is ignored.
        #
        #     It is recommended to always set this value to a UUID.
        #
        #     The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
        #     (_), and hyphens (-). The maximum length is 40 characters.
        class CreateConversionWorkspaceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'UpdateConversionWorkspace' request.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten by the
        #     update in the conversion workspace resource.
        # @!attribute [rw] conversion_workspace
        #   @return [::Google::Cloud::CloudDMS::V1::ConversionWorkspace]
        #     Required. The conversion workspace parameters to update.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     A unique ID used to identify the request. If the server receives two
        #     requests with the same ID, then the second request is ignored.
        #
        #     It is recommended to always set this value to a UUID.
        #
        #     The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
        #     (_), and hyphens (-). The maximum length is 40 characters.
        class UpdateConversionWorkspaceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'DeleteConversionWorkspace' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the conversion workspace resource to delete.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     A unique ID used to identify the request. If the server receives two
        #     requests with the same ID, then the second request is ignored.
        #
        #     It is recommended to always set this value to a UUID.
        #
        #     The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
        #     (_), and hyphens (-). The maximum length is 40 characters.
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Force delete the conversion workspace, even if there's a running migration
        #     that is using the workspace.
        class DeleteConversionWorkspaceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'CommitConversionWorkspace' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the conversion workspace resource to commit.
        # @!attribute [rw] commit_name
        #   @return [::String]
        #     Optional. Optional name of the commit.
        class CommitConversionWorkspaceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'RollbackConversionWorkspace' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the conversion workspace resource to roll back to.
        class RollbackConversionWorkspaceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'ApplyConversionWorkspace' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the conversion workspace resource for which to apply
        #     the draft tree. Must be in the form of:
        #      projects/\\{project}/locations/\\{location}/conversionWorkspaces/\\{conversion_workspace}.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filter which entities to apply. Leaving this field empty will apply all of
        #     the entities. Supports Google AIP 160 based filtering.
        # @!attribute [rw] dry_run
        #   @return [::Boolean]
        #     Optional. Only validates the apply process, but doesn't change the
        #     destination database. Only works for PostgreSQL destination connection
        #     profile.
        # @!attribute [rw] auto_commit
        #   @return [::Boolean]
        #     Optional. Specifies whether the conversion workspace is to be committed
        #     automatically after the apply.
        # @!attribute [rw] connection_profile
        #   @return [::String]
        #     Optional. Fully qualified (Uri) name of the destination connection
        #     profile.
        class ApplyConversionWorkspaceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Retrieve a list of all mapping rules in a given conversion workspace.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Name of the conversion workspace resource whose mapping rules are
        #     listed in the form of:
        #     projects/\\{project}/locations/\\{location}/conversionWorkspaces/\\{conversion_workspace}.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of rules to return. The service may return
        #     fewer than this value.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The nextPageToken value received in the previous call to
        #     mappingRules.list, used in the subsequent request to retrieve the next
        #     page of results. On first call this should be left blank. When paginating,
        #     all other parameters provided to mappingRules.list must match the call
        #     that provided the page token.
        class ListMappingRulesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for 'ListMappingRulesRequest' request.
        # @!attribute [rw] mapping_rules
        #   @return [::Array<::Google::Cloud::CloudDMS::V1::MappingRule>]
        #     The list of conversion workspace mapping rules.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListMappingRulesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'GetMappingRule' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the mapping rule resource to get.
        #     Example: conversionWorkspaces/123/mappingRules/rule123
        #
        #     In order to retrieve a previous revision of the mapping rule, also provide
        #     the revision ID.
        #     Example:
        #     conversionWorkspace/123/mappingRules/rule123@c7cfa2a8c7cfa2a8c7cfa2a8c7cfa2a8
        class GetMappingRuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'SeedConversionWorkspace' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the conversion workspace resource to seed with new database
        #     structure, in the form of:
        #     projects/\\{project}/locations/\\{location}/conversionWorkspaces/\\{conversion_workspace}.
        # @!attribute [rw] auto_commit
        #   @return [::Boolean]
        #     Should the conversion workspace be committed automatically after the
        #     seed operation.
        # @!attribute [rw] source_connection_profile
        #   @return [::String]
        #     Optional. Fully qualified (Uri) name of the source connection profile.
        #
        #     Note: The following fields are mutually exclusive: `source_connection_profile`, `destination_connection_profile`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] destination_connection_profile
        #   @return [::String]
        #     Optional. Fully qualified (Uri) name of the destination connection
        #     profile.
        #
        #     Note: The following fields are mutually exclusive: `destination_connection_profile`, `source_connection_profile`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class SeedConversionWorkspaceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'ConvertConversionWorkspace' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the conversion workspace resource to convert in the form of:
        #     projects/\\{project}/locations/\\{location}/conversionWorkspaces/\\{conversion_workspace}.
        # @!attribute [rw] auto_commit
        #   @return [::Boolean]
        #     Optional. Specifies whether the conversion workspace is to be committed
        #     automatically after the conversion.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter the entities to convert. Leaving this field empty will
        #     convert all of the entities. Supports Google AIP-160 style filtering.
        # @!attribute [rw] convert_full_path
        #   @return [::Boolean]
        #     Optional. Automatically convert the full entity path for each entity
        #     specified by the filter. For example, if the filter specifies a table, that
        #     table schema (and database if there is one) will also be converted.
        class ConvertConversionWorkspaceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'ImportMappingRules' request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Name of the conversion workspace resource to import the rules to
        #     in the form of:
        #     projects/\\{project}/locations/\\{location}/conversionWorkspaces/\\{conversion_workspace}.
        # @!attribute [rw] rules_format
        #   @return [::Google::Cloud::CloudDMS::V1::ImportRulesFileFormat]
        #     Required. The format of the rules content file.
        # @!attribute [rw] rules_files
        #   @return [::Array<::Google::Cloud::CloudDMS::V1::ImportMappingRulesRequest::RulesFile>]
        #     Required. One or more rules files.
        # @!attribute [rw] auto_commit
        #   @return [::Boolean]
        #     Required. Should the conversion workspace be committed automatically after
        #     the import operation.
        class ImportMappingRulesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Details of a single rules file.
          # @!attribute [rw] rules_source_filename
          #   @return [::String]
          #     Required. The filename of the rules that needs to be converted. The
          #     filename is used mainly so that future logs of the import rules job
          #     contain it, and can therefore be searched by it.
          # @!attribute [rw] rules_content
          #   @return [::String]
          #     Required. The text content of the rules that needs to be converted.
          class RulesFile
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request message for 'DescribeDatabaseEntities' request.
        # @!attribute [rw] conversion_workspace
        #   @return [::String]
        #     Required. Name of the conversion workspace resource whose database entities
        #     are described. Must be in the form of:
        #     projects/\\{project}/locations/\\{location}/conversionWorkspaces/\\{conversion_workspace}.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of entities to return. The service may return
        #     fewer entities than the value specifies.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The nextPageToken value received in the previous call to
        #     conversionWorkspace.describeDatabaseEntities, used in the subsequent
        #     request to retrieve the next page of results. On first call this should be
        #     left blank. When paginating, all other parameters provided to
        #     conversionWorkspace.describeDatabaseEntities must match the call that
        #     provided the page token.
        # @!attribute [rw] tree
        #   @return [::Google::Cloud::CloudDMS::V1::DescribeDatabaseEntitiesRequest::DBTreeType]
        #     Required. The tree to fetch.
        # @!attribute [rw] uncommitted
        #   @return [::Boolean]
        #     Optional. Whether to retrieve the latest committed version of the entities
        #     or the latest version. This field is ignored if a specific commit_id is
        #     specified.
        # @!attribute [rw] commit_id
        #   @return [::String]
        #     Optional. Request a specific commit ID. If not specified, the entities from
        #     the latest commit are returned.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter the returned entities based on AIP-160 standard.
        # @!attribute [rw] view
        #   @return [::Google::Cloud::CloudDMS::V1::DatabaseEntityView]
        #     Optional. Results view based on AIP-157
        class DescribeDatabaseEntitiesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The type of a tree to return
          module DBTreeType
            # Unspecified tree type.
            DB_TREE_TYPE_UNSPECIFIED = 0

            # The source database tree.
            SOURCE_TREE = 1

            # The draft database tree.
            DRAFT_TREE = 2

            # The destination database tree.
            DESTINATION_TREE = 3
          end
        end

        # Response message for 'DescribeDatabaseEntities' request.
        # @!attribute [rw] database_entities
        #   @return [::Array<::Google::Cloud::CloudDMS::V1::DatabaseEntity>]
        #     The list of database entities for the conversion workspace.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class DescribeDatabaseEntitiesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'SearchBackgroundJobs' request.
        # @!attribute [rw] conversion_workspace
        #   @return [::String]
        #     Required. Name of the conversion workspace resource whose jobs are listed,
        #     in the form of:
        #     projects/\\{project}/locations/\\{location}/conversionWorkspaces/\\{conversion_workspace}.
        # @!attribute [rw] return_most_recent_per_job_type
        #   @return [::Boolean]
        #     Optional. Whether or not to return just the most recent job per job type,
        # @!attribute [rw] max_size
        #   @return [::Integer]
        #     Optional. The maximum number of jobs to return. The service may return
        #     fewer than this value. If unspecified, at most 100 jobs are
        #     returned. The maximum value is 100; values above 100 are coerced to
        #     100.
        # @!attribute [rw] completed_until_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. If provided, only returns jobs that completed until (not
        #     including) the given timestamp.
        class SearchBackgroundJobsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for 'SearchBackgroundJobs' request.
        # @!attribute [rw] jobs
        #   @return [::Array<::Google::Cloud::CloudDMS::V1::BackgroundJobLogEntry>]
        #     The list of conversion workspace mapping rules.
        class SearchBackgroundJobsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'DescribeConversionWorkspaceRevisions' request.
        # @!attribute [rw] conversion_workspace
        #   @return [::String]
        #     Required. Name of the conversion workspace resource whose revisions are
        #     listed. Must be in the form of:
        #     projects/\\{project}/locations/\\{location}/conversionWorkspaces/\\{conversion_workspace}.
        # @!attribute [rw] commit_id
        #   @return [::String]
        #     Optional. Optional filter to request a specific commit ID.
        class DescribeConversionWorkspaceRevisionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for 'DescribeConversionWorkspaceRevisions' request.
        # @!attribute [rw] revisions
        #   @return [::Array<::Google::Cloud::CloudDMS::V1::ConversionWorkspace>]
        #     The list of conversion workspace revisions.
        class DescribeConversionWorkspaceRevisionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'CreateMappingRule' command.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent which owns this collection of mapping rules.
        # @!attribute [rw] mapping_rule_id
        #   @return [::String]
        #     Required. The ID of the rule to create.
        # @!attribute [rw] mapping_rule
        #   @return [::Google::Cloud::CloudDMS::V1::MappingRule]
        #     Required. Represents a [mapping rule]
        #     (https://cloud.google.com/database-migration/reference/rest/v1/projects.locations.mappingRules)
        #     object.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     A unique ID used to identify the request. If the server receives two
        #     requests with the same ID, then the second request is ignored.
        #
        #     It is recommended to always set this value to a UUID.
        #
        #     The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
        #     (_), and hyphens (-). The maximum length is 40 characters.
        class CreateMappingRuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'DeleteMappingRule' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the mapping rule resource to delete.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A unique ID used to identify the request. If the server receives
        #     two requests with the same ID, then the second request is ignored.
        #
        #     It is recommended to always set this value to a UUID.
        #
        #     The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
        #     (_), and hyphens (-). The maximum length is 40 characters.
        class DeleteMappingRuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'FetchStaticIps' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name for the location for which static IPs should be
        #     returned. Must be in the format `projects/*/locations/*`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Maximum number of IPs to return.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `FetchStaticIps` call.
        class FetchStaticIpsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for a 'FetchStaticIps' request.
        # @!attribute [rw] static_ips
        #   @return [::Array<::String>]
        #     List of static IPs.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class FetchStaticIpsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # AIP-157 Partial Response view for Database Entity.
        module DatabaseEntityView
          # Unspecified view. Defaults to basic view.
          DATABASE_ENTITY_VIEW_UNSPECIFIED = 0

          # Default view. Does not return DDLs or Issues.
          DATABASE_ENTITY_VIEW_BASIC = 1

          # Return full entity details including mappings, ddl and issues.
          DATABASE_ENTITY_VIEW_FULL = 2

          # Top-most (Database, Schema) nodes which are returned contains summary
          # details for their decendents such as the number of entities per type and
          # issues rollups. When this view is used, only a single page of result is
          # returned and the page_size property of the request is ignored. The
          # returned page will only include the top-most node types.
          DATABASE_ENTITY_VIEW_ROOT_SUMMARY = 3
        end
      end
    end
  end
end
