# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/clouddms/v1/clouddms_pb"
require "google/cloud/location"
require "google/iam/v1"

module Google
  module Cloud
    module CloudDMS
      module V1
        module DataMigrationService
          ##
          # Client for the DataMigrationService service.
          #
          # Database Migration service
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "datamigration.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :data_migration_service_stub

            ##
            # Configure the DataMigrationService Client class.
            #
            # See {::Google::Cloud::CloudDMS::V1::DataMigrationService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all DataMigrationService clients
            #   ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "CloudDMS", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.timeout = 60.0
                default_config.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_migration_jobs.timeout = 60.0

                default_config.rpcs.get_migration_job.timeout = 60.0

                default_config.rpcs.create_migration_job.timeout = 60.0

                default_config.rpcs.update_migration_job.timeout = 60.0

                default_config.rpcs.delete_migration_job.timeout = 60.0

                default_config.rpcs.start_migration_job.timeout = 60.0

                default_config.rpcs.stop_migration_job.timeout = 60.0

                default_config.rpcs.resume_migration_job.timeout = 60.0

                default_config.rpcs.promote_migration_job.timeout = 60.0

                default_config.rpcs.verify_migration_job.timeout = 60.0

                default_config.rpcs.restart_migration_job.timeout = 60.0

                default_config.rpcs.generate_ssh_script.timeout = 60.0

                default_config.rpcs.list_connection_profiles.timeout = 60.0

                default_config.rpcs.get_connection_profile.timeout = 60.0

                default_config.rpcs.create_connection_profile.timeout = 60.0

                default_config.rpcs.update_connection_profile.timeout = 60.0

                default_config.rpcs.delete_connection_profile.timeout = 60.0

                default_config.rpcs.create_private_connection.timeout = 60.0

                default_config.rpcs.get_private_connection.timeout = 60.0

                default_config.rpcs.list_private_connections.timeout = 60.0

                default_config.rpcs.delete_private_connection.timeout = 60.0

                default_config.rpcs.get_conversion_workspace.timeout = 60.0

                default_config.rpcs.list_conversion_workspaces.timeout = 60.0

                default_config.rpcs.create_conversion_workspace.timeout = 60.0

                default_config.rpcs.update_conversion_workspace.timeout = 60.0

                default_config.rpcs.delete_conversion_workspace.timeout = 60.0

                default_config.rpcs.seed_conversion_workspace.timeout = 60.0

                default_config.rpcs.import_mapping_rules.timeout = 60.0

                default_config.rpcs.convert_conversion_workspace.timeout = 60.0

                default_config.rpcs.commit_conversion_workspace.timeout = 60.0

                default_config.rpcs.rollback_conversion_workspace.timeout = 60.0

                default_config.rpcs.apply_conversion_workspace.timeout = 60.0

                default_config.rpcs.describe_database_entities.timeout = 60.0

                default_config.rpcs.search_background_jobs.timeout = 60.0

                default_config.rpcs.describe_conversion_workspace_revisions.timeout = 60.0

                default_config.rpcs.fetch_static_ips.timeout = 60.0

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the DataMigrationService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::CloudDMS::V1::DataMigrationService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @data_migration_service_stub.universe_domain
            end

            ##
            # Create a new DataMigrationService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the DataMigrationService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/clouddms/v1/clouddms_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @data_migration_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::CloudDMS::V1::DataMigrationService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @data_migration_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @data_migration_service_stub.endpoint
                config.universe_domain = @data_migration_service_stub.universe_domain
                config.logger = @data_migration_service_stub.logger if config.respond_to? :logger=
              end

              @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @data_migration_service_stub.endpoint
                config.universe_domain = @data_migration_service_stub.universe_domain
                config.logger = @data_migration_service_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::CloudDMS::V1::DataMigrationService::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # Get the associated client for mix-in of the IAMPolicy.
            #
            # @return [Google::Iam::V1::IAMPolicy::Client]
            #
            attr_reader :iam_policy_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @data_migration_service_stub.logger
            end

            # Service calls

            ##
            # Lists migration jobs in a given project and location.
            #
            # @overload list_migration_jobs(request, options = nil)
            #   Pass arguments to `list_migration_jobs` via a request object, either of type
            #   {::Google::Cloud::CloudDMS::V1::ListMigrationJobsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudDMS::V1::ListMigrationJobsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_migration_jobs(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_migration_jobs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent which owns this collection of migrationJobs.
            #   @param page_size [::Integer]
            #     The maximum number of migration jobs to return. The service may return
            #     fewer than this value. If unspecified, at most 50 migration jobs will be
            #     returned. The maximum value is 1000; values above 1000 are coerced to
            #     1000.
            #   @param page_token [::String]
            #     The nextPageToken value received in the previous call to
            #     migrationJobs.list, used in the subsequent request to retrieve the next
            #     page of results. On first call this should be left blank. When paginating,
            #     all other parameters provided to migrationJobs.list must match the call
            #     that provided the page token.
            #   @param filter [::String]
            #     A filter expression that filters migration jobs listed in the response.
            #     The expression must specify the field name, a comparison operator, and the
            #     value that you want to use for filtering. The value must be a string,
            #     a number, or a boolean. The comparison operator must be
            #     either =, !=, >, or <. For example, list migration jobs created this year
            #     by specifying **createTime %gt; 2020-01-01T00:00:00.000000000Z.**
            #     You can also filter nested fields. For example, you could specify
            #     **reverseSshConnectivity.vmIp = "1.2.3.4"** to select all migration
            #     jobs connecting through the specific SSH tunnel bastion.
            #   @param order_by [::String]
            #     Sort the results based on the migration job name.
            #     Valid values are: "name", "name asc", and "name desc".
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::CloudDMS::V1::MigrationJob>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::CloudDMS::V1::MigrationJob>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_dms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudDMS::V1::ListMigrationJobsRequest.new
            #
            #   # Call the list_migration_jobs method.
            #   result = client.list_migration_jobs request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::CloudDMS::V1::MigrationJob.
            #     p item
            #   end
            #
            def list_migration_jobs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudDMS::V1::ListMigrationJobsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_migration_jobs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudDMS::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_migration_jobs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_migration_jobs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_migration_service_stub.call_rpc :list_migration_jobs, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @data_migration_service_stub, :list_migration_jobs, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single migration job.
            #
            # @overload get_migration_job(request, options = nil)
            #   Pass arguments to `get_migration_job` via a request object, either of type
            #   {::Google::Cloud::CloudDMS::V1::GetMigrationJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudDMS::V1::GetMigrationJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_migration_job(name: nil)
            #   Pass arguments to `get_migration_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the migration job resource to get.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::CloudDMS::V1::MigrationJob]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::CloudDMS::V1::MigrationJob]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_dms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudDMS::V1::GetMigrationJobRequest.new
            #
            #   # Call the get_migration_job method.
            #   result = client.get_migration_job request
            #
            #   # The returned object is of type Google::Cloud::CloudDMS::V1::MigrationJob.
            #   p result
            #
            def get_migration_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudDMS::V1::GetMigrationJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_migration_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudDMS::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_migration_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_migration_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_migration_service_stub.call_rpc :get_migration_job, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new migration job in a given project and location.
            #
            # @overload create_migration_job(request, options = nil)
            #   Pass arguments to `create_migration_job` via a request object, either of type
            #   {::Google::Cloud::CloudDMS::V1::CreateMigrationJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudDMS::V1::CreateMigrationJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_migration_job(parent: nil, migration_job_id: nil, migration_job: nil, request_id: nil)
            #   Pass arguments to `create_migration_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent which owns this collection of migration jobs.
            #   @param migration_job_id [::String]
            #     Required. The ID of the instance to create.
            #   @param migration_job [::Google::Cloud::CloudDMS::V1::MigrationJob, ::Hash]
            #     Required. Represents a [migration
            #     job](https://cloud.google.com/database-migration/docs/reference/rest/v1/projects.locations.migrationJobs)
            #     object.
            #   @param request_id [::String]
            #     Optional. A unique ID used to identify the request. If the server receives
            #     two requests with the same ID, then the second request is ignored.
            #
            #     It is recommended to always set this value to a UUID.
            #
            #     The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
            #     (_), and hyphens (-). The maximum length is 40 characters.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_dms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudDMS::V1::CreateMigrationJobRequest.new
            #
            #   # Call the create_migration_job method.
            #   result = client.create_migration_job request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_migration_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudDMS::V1::CreateMigrationJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_migration_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudDMS::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_migration_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_migration_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_migration_service_stub.call_rpc :create_migration_job, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of a single migration job.
            #
            # @overload update_migration_job(request, options = nil)
            #   Pass arguments to `update_migration_job` via a request object, either of type
            #   {::Google::Cloud::CloudDMS::V1::UpdateMigrationJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudDMS::V1::UpdateMigrationJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_migration_job(update_mask: nil, migration_job: nil, request_id: nil)
            #   Pass arguments to `update_migration_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Field mask is used to specify the fields to be overwritten by the
            #     update in the conversion workspace resource.
            #   @param migration_job [::Google::Cloud::CloudDMS::V1::MigrationJob, ::Hash]
            #     Required. The migration job parameters to update.
            #   @param request_id [::String]
            #     A unique ID used to identify the request. If the server receives two
            #     requests with the same ID, then the second request is ignored.
            #
            #     It is recommended to always set this value to a UUID.
            #
            #     The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
            #     (_), and hyphens (-). The maximum length is 40 characters.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_dms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudDMS::V1::UpdateMigrationJobRequest.new
            #
            #   # Call the update_migration_job method.
            #   result = client.update_migration_job request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_migration_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudDMS::V1::UpdateMigrationJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_migration_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudDMS::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.migration_job&.name
                header_params["migration_job.name"] = request.migration_job.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_migration_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_migration_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_migration_service_stub.call_rpc :update_migration_job, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single migration job.
            #
            # @overload delete_migration_job(request, options = nil)
            #   Pass arguments to `delete_migration_job` via a request object, either of type
            #   {::Google::Cloud::CloudDMS::V1::DeleteMigrationJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudDMS::V1::DeleteMigrationJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_migration_job(name: nil, request_id: nil, force: nil)
            #   Pass arguments to `delete_migration_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the migration job resource to delete.
            #   @param request_id [::String]
            #     A unique ID used to identify the request. If the server receives two
            #     requests with the same ID, then the second request is ignored.
            #
            #     It is recommended to always set this value to a UUID.
            #
            #     The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
            #     (_), and hyphens (-). The maximum length is 40 characters.
            #   @param force [::Boolean]
            #     The destination CloudSQL connection profile is always deleted with the
            #     migration job. In case of force delete, the destination CloudSQL replica
            #     database is also deleted.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_dms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudDMS::V1::DeleteMigrationJobRequest.new
            #
            #   # Call the delete_migration_job method.
            #   result = client.delete_migration_job request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_migration_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudDMS::V1::DeleteMigrationJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_migration_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudDMS::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_migration_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_migration_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_migration_service_stub.call_rpc :delete_migration_job, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Start an already created migration job.
            #
            # @overload start_migration_job(request, options = nil)
            #   Pass arguments to `start_migration_job` via a request object, either of type
            #   {::Google::Cloud::CloudDMS::V1::StartMigrationJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudDMS::V1::StartMigrationJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload start_migration_job(name: nil, skip_validation: nil)
            #   Pass arguments to `start_migration_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Name of the migration job resource to start.
            #   @param skip_validation [::Boolean]
            #     Optional. Start the migration job without running prior configuration
            #     verification. Defaults to `false`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_dms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudDMS::V1::StartMigrationJobRequest.new
            #
            #   # Call the start_migration_job method.
            #   result = client.start_migration_job request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def start_migration_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudDMS::V1::StartMigrationJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.start_migration_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudDMS::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.start_migration_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.start_migration_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_migration_service_stub.call_rpc :start_migration_job, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Stops a running migration job.
            #
            # @overload stop_migration_job(request, options = nil)
            #   Pass arguments to `stop_migration_job` via a request object, either of type
            #   {::Google::Cloud::CloudDMS::V1::StopMigrationJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudDMS::V1::StopMigrationJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload stop_migration_job(name: nil)
            #   Pass arguments to `stop_migration_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Name of the migration job resource to stop.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_dms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudDMS::V1::StopMigrationJobRequest.new
            #
            #   # Call the stop_migration_job method.
            #   result = client.stop_migration_job request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def stop_migration_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudDMS::V1::StopMigrationJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.stop_migration_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudDMS::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.stop_migration_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.stop_migration_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_migration_service_stub.call_rpc :stop_migration_job, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Resume a migration job that is currently stopped and is resumable (was
            # stopped during CDC phase).
            #
            # @overload resume_migration_job(request, options = nil)
            #   Pass arguments to `resume_migration_job` via a request object, either of type
            #   {::Google::Cloud::CloudDMS::V1::ResumeMigrationJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudDMS::V1::ResumeMigrationJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload resume_migration_job(name: nil)
            #   Pass arguments to `resume_migration_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Name of the migration job resource to resume.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_dms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudDMS::V1::ResumeMigrationJobRequest.new
            #
            #   # Call the resume_migration_job method.
            #   result = client.resume_migration_job request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def resume_migration_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudDMS::V1::ResumeMigrationJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.resume_migration_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudDMS::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.resume_migration_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.resume_migration_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_migration_service_stub.call_rpc :resume_migration_job, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Promote a migration job, stopping replication to the destination and
            # promoting the destination to be a standalone database.
            #
            # @overload promote_migration_job(request, options = nil)
            #   Pass arguments to `promote_migration_job` via a request object, either of type
            #   {::Google::Cloud::CloudDMS::V1::PromoteMigrationJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudDMS::V1::PromoteMigrationJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload promote_migration_job(name: nil)
            #   Pass arguments to `promote_migration_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Name of the migration job resource to promote.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_dms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudDMS::V1::PromoteMigrationJobRequest.new
            #
            #   # Call the promote_migration_job method.
            #   result = client.promote_migration_job request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def promote_migration_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudDMS::V1::PromoteMigrationJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.promote_migration_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudDMS::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.promote_migration_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.promote_migration_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_migration_service_stub.call_rpc :promote_migration_job, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Verify a migration job, making sure the destination can reach the source
            # and that all configuration and prerequisites are met.
            #
            # @overload verify_migration_job(request, options = nil)
            #   Pass arguments to `verify_migration_job` via a request object, either of type
            #   {::Google::Cloud::CloudDMS::V1::VerifyMigrationJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudDMS::V1::VerifyMigrationJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload verify_migration_job(name: nil, update_mask: nil, migration_job: nil)
            #   Pass arguments to `verify_migration_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Name of the migration job resource to verify.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. Field mask is used to specify the changed fields to be verified.
            #     It will not update the migration job.
            #   @param migration_job [::Google::Cloud::CloudDMS::V1::MigrationJob, ::Hash]
            #     Optional. The changed migration job parameters to verify.
            #     It will not update the migration job.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_dms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudDMS::V1::VerifyMigrationJobRequest.new
            #
            #   # Call the verify_migration_job method.
            #   result = client.verify_migration_job request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def verify_migration_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudDMS::V1::VerifyMigrationJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.verify_migration_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudDMS::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.verify_migration_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.verify_migration_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_migration_service_stub.call_rpc :verify_migration_job, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Restart a stopped or failed migration job, resetting the destination
            # instance to its original state and starting the migration process from
            # scratch.
            #
            # @overload restart_migration_job(request, options = nil)
            #   Pass arguments to `restart_migration_job` via a request object, either of type
            #   {::Google::Cloud::CloudDMS::V1::RestartMigrationJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudDMS::V1::RestartMigrationJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload restart_migration_job(name: nil, skip_validation: nil)
            #   Pass arguments to `restart_migration_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Name of the migration job resource to restart.
            #   @param skip_validation [::Boolean]
            #     Optional. Restart the migration job without running prior configuration
            #     verification. Defaults to `false`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_dms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudDMS::V1::RestartMigrationJobRequest.new
            #
            #   # Call the restart_migration_job method.
            #   result = client.restart_migration_job request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def restart_migration_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudDMS::V1::RestartMigrationJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.restart_migration_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudDMS::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.restart_migration_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.restart_migration_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_migration_service_stub.call_rpc :restart_migration_job, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Generate a SSH configuration script to configure the reverse SSH
            # connectivity.
            #
            # @overload generate_ssh_script(request, options = nil)
            #   Pass arguments to `generate_ssh_script` via a request object, either of type
            #   {::Google::Cloud::CloudDMS::V1::GenerateSshScriptRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudDMS::V1::GenerateSshScriptRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload generate_ssh_script(migration_job: nil, vm: nil, vm_creation_config: nil, vm_selection_config: nil, vm_port: nil)
            #   Pass arguments to `generate_ssh_script` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param migration_job [::String]
            #     Name of the migration job resource to generate the SSH script.
            #   @param vm [::String]
            #     Required. Bastion VM Instance name to use or to create.
            #   @param vm_creation_config [::Google::Cloud::CloudDMS::V1::VmCreationConfig, ::Hash]
            #     The VM creation configuration
            #
            #     Note: The following parameters are mutually exclusive: `vm_creation_config`, `vm_selection_config`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param vm_selection_config [::Google::Cloud::CloudDMS::V1::VmSelectionConfig, ::Hash]
            #     The VM selection configuration
            #
            #     Note: The following parameters are mutually exclusive: `vm_selection_config`, `vm_creation_config`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param vm_port [::Integer]
            #     The port that will be open on the bastion host.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::CloudDMS::V1::SshScript]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::CloudDMS::V1::SshScript]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_dms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudDMS::V1::GenerateSshScriptRequest.new
            #
            #   # Call the generate_ssh_script method.
            #   result = client.generate_ssh_script request
            #
            #   # The returned object is of type Google::Cloud::CloudDMS::V1::SshScript.
            #   p result
            #
            def generate_ssh_script request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudDMS::V1::GenerateSshScriptRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.generate_ssh_script.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudDMS::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.migration_job
                header_params["migration_job"] = request.migration_job
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.generate_ssh_script.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.generate_ssh_script.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_migration_service_stub.call_rpc :generate_ssh_script, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Generate a TCP Proxy configuration script to configure a cloud-hosted VM
            # running a TCP Proxy.
            #
            # @overload generate_tcp_proxy_script(request, options = nil)
            #   Pass arguments to `generate_tcp_proxy_script` via a request object, either of type
            #   {::Google::Cloud::CloudDMS::V1::GenerateTcpProxyScriptRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudDMS::V1::GenerateTcpProxyScriptRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload generate_tcp_proxy_script(migration_job: nil, vm_name: nil, vm_machine_type: nil, vm_zone: nil, vm_subnet: nil)
            #   Pass arguments to `generate_tcp_proxy_script` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param migration_job [::String]
            #     Name of the migration job resource to generate the TCP Proxy script.
            #   @param vm_name [::String]
            #     Required. The name of the Compute instance that will host the proxy.
            #   @param vm_machine_type [::String]
            #     Required. The type of the Compute instance that will host the proxy.
            #   @param vm_zone [::String]
            #     Optional. The Google Cloud Platform zone to create the VM in. The fully
            #     qualified name of the zone must be specified, including the region name,
            #     for example "us-central1-b". If not specified, uses the "-b" zone of the
            #     destination Connection Profile's region.
            #   @param vm_subnet [::String]
            #     Required. The name of the subnet the Compute instance will use for private
            #     connectivity. Must be supplied in the form of
            #     projects/\\{project}/regions/\\{region}/subnetworks/\\{subnetwork}.
            #     Note: the region for the subnet must match the Compute instance region.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::CloudDMS::V1::TcpProxyScript]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::CloudDMS::V1::TcpProxyScript]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_dms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudDMS::V1::GenerateTcpProxyScriptRequest.new
            #
            #   # Call the generate_tcp_proxy_script method.
            #   result = client.generate_tcp_proxy_script request
            #
            #   # The returned object is of type Google::Cloud::CloudDMS::V1::TcpProxyScript.
            #   p result
            #
            def generate_tcp_proxy_script request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudDMS::V1::GenerateTcpProxyScriptRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.generate_tcp_proxy_script.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudDMS::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.migration_job
                header_params["migration_job"] = request.migration_job
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.generate_tcp_proxy_script.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.generate_tcp_proxy_script.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_migration_service_stub.call_rpc :generate_tcp_proxy_script, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieves a list of all connection profiles in a given project and
            # location.
            #
            # @overload list_connection_profiles(request, options = nil)
            #   Pass arguments to `list_connection_profiles` via a request object, either of type
            #   {::Google::Cloud::CloudDMS::V1::ListConnectionProfilesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudDMS::V1::ListConnectionProfilesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_connection_profiles(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_connection_profiles` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent which owns this collection of connection profiles.
            #   @param page_size [::Integer]
            #     The maximum number of connection profiles to return. The service may return
            #     fewer than this value. If unspecified, at most 50 connection profiles will
            #     be returned. The maximum value is 1000; values above 1000 are coerced
            #     to 1000.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListConnectionProfiles` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to `ListConnectionProfiles`
            #     must match the call that provided the page token.
            #   @param filter [::String]
            #     A filter expression that filters connection profiles listed in the
            #     response. The expression must specify the field name, a comparison
            #     operator, and the value that you want to use for filtering. The value must
            #     be a string, a number, or a boolean. The comparison operator must be either
            #     =, !=, >, or <. For example, list connection profiles created this year by
            #     specifying **createTime %gt; 2020-01-01T00:00:00.000000000Z**. You can
            #     also filter nested fields. For example, you could specify **mySql.username
            #     = %lt;my_username%gt;** to list all connection profiles configured to
            #     connect with a specific username.
            #   @param order_by [::String]
            #     A comma-separated list of fields to order results according to.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::CloudDMS::V1::ConnectionProfile>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::CloudDMS::V1::ConnectionProfile>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_dms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudDMS::V1::ListConnectionProfilesRequest.new
            #
            #   # Call the list_connection_profiles method.
            #   result = client.list_connection_profiles request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::CloudDMS::V1::ConnectionProfile.
            #     p item
            #   end
            #
            def list_connection_profiles request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudDMS::V1::ListConnectionProfilesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_connection_profiles.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudDMS::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_connection_profiles.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_connection_profiles.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_migration_service_stub.call_rpc :list_connection_profiles, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @data_migration_service_stub, :list_connection_profiles, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single connection profile.
            #
            # @overload get_connection_profile(request, options = nil)
            #   Pass arguments to `get_connection_profile` via a request object, either of type
            #   {::Google::Cloud::CloudDMS::V1::GetConnectionProfileRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudDMS::V1::GetConnectionProfileRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_connection_profile(name: nil)
            #   Pass arguments to `get_connection_profile` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the connection profile resource to get.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::CloudDMS::V1::ConnectionProfile]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::CloudDMS::V1::ConnectionProfile]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_dms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudDMS::V1::GetConnectionProfileRequest.new
            #
            #   # Call the get_connection_profile method.
            #   result = client.get_connection_profile request
            #
            #   # The returned object is of type Google::Cloud::CloudDMS::V1::ConnectionProfile.
            #   p result
            #
            def get_connection_profile request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudDMS::V1::GetConnectionProfileRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_connection_profile.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudDMS::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_connection_profile.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_connection_profile.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_migration_service_stub.call_rpc :get_connection_profile, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new connection profile in a given project and location.
            #
            # @overload create_connection_profile(request, options = nil)
            #   Pass arguments to `create_connection_profile` via a request object, either of type
            #   {::Google::Cloud::CloudDMS::V1::CreateConnectionProfileRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudDMS::V1::CreateConnectionProfileRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_connection_profile(parent: nil, connection_profile_id: nil, connection_profile: nil, request_id: nil, validate_only: nil, skip_validation: nil)
            #   Pass arguments to `create_connection_profile` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent which owns this collection of connection profiles.
            #   @param connection_profile_id [::String]
            #     Required. The connection profile identifier.
            #   @param connection_profile [::Google::Cloud::CloudDMS::V1::ConnectionProfile, ::Hash]
            #     Required. The create request body including the connection profile data
            #   @param request_id [::String]
            #     Optional. A unique ID used to identify the request. If the server receives
            #     two requests with the same ID, then the second request is ignored.
            #
            #     It is recommended to always set this value to a UUID.
            #
            #     The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
            #     (_), and hyphens (-). The maximum length is 40 characters.
            #   @param validate_only [::Boolean]
            #     Optional. Only validate the connection profile, but don't create any
            #     resources. The default is false. Only supported for Oracle connection
            #     profiles.
            #   @param skip_validation [::Boolean]
            #     Optional. Create the connection profile without validating it.
            #     The default is false.
            #     Only supported for Oracle connection profiles.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_dms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudDMS::V1::CreateConnectionProfileRequest.new
            #
            #   # Call the create_connection_profile method.
            #   result = client.create_connection_profile request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_connection_profile request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudDMS::V1::CreateConnectionProfileRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_connection_profile.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudDMS::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_connection_profile.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_connection_profile.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_migration_service_stub.call_rpc :create_connection_profile, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Update the configuration of a single connection profile.
            #
            # @overload update_connection_profile(request, options = nil)
            #   Pass arguments to `update_connection_profile` via a request object, either of type
            #   {::Google::Cloud::CloudDMS::V1::UpdateConnectionProfileRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudDMS::V1::UpdateConnectionProfileRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_connection_profile(update_mask: nil, connection_profile: nil, request_id: nil, validate_only: nil, skip_validation: nil)
            #   Pass arguments to `update_connection_profile` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Field mask is used to specify the fields to be overwritten by the
            #     update in the conversion workspace resource.
            #   @param connection_profile [::Google::Cloud::CloudDMS::V1::ConnectionProfile, ::Hash]
            #     Required. The connection profile parameters to update.
            #   @param request_id [::String]
            #     Optional. A unique ID used to identify the request. If the server receives
            #     two requests with the same ID, then the second request is ignored.
            #
            #     It is recommended to always set this value to a UUID.
            #
            #     The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
            #     (_), and hyphens (-). The maximum length is 40 characters.
            #   @param validate_only [::Boolean]
            #     Optional. Only validate the connection profile, but don't update any
            #     resources. The default is false. Only supported for Oracle connection
            #     profiles.
            #   @param skip_validation [::Boolean]
            #     Optional. Update the connection profile without validating it.
            #     The default is false.
            #     Only supported for Oracle connection profiles.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_dms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudDMS::V1::UpdateConnectionProfileRequest.new
            #
            #   # Call the update_connection_profile method.
            #   result = client.update_connection_profile request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_connection_profile request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudDMS::V1::UpdateConnectionProfileRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_connection_profile.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudDMS::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.connection_profile&.name
                header_params["connection_profile.name"] = request.connection_profile.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_connection_profile.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_connection_profile.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_migration_service_stub.call_rpc :update_connection_profile, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single Database Migration Service connection profile.
            # A connection profile can only be deleted if it is not in use by any
            # active migration jobs.
            #
            # @overload delete_connection_profile(request, options = nil)
            #   Pass arguments to `delete_connection_profile` via a request object, either of type
            #   {::Google::Cloud::CloudDMS::V1::DeleteConnectionProfileRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudDMS::V1::DeleteConnectionProfileRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_connection_profile(name: nil, request_id: nil, force: nil)
            #   Pass arguments to `delete_connection_profile` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the connection profile resource to delete.
            #   @param request_id [::String]
            #     A unique ID used to identify the request. If the server receives two
            #     requests with the same ID, then the second request is ignored.
            #
            #     It is recommended to always set this value to a UUID.
            #
            #     The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
            #     (_), and hyphens (-). The maximum length is 40 characters.
            #   @param force [::Boolean]
            #     In case of force delete, the CloudSQL replica database is also deleted
            #     (only for CloudSQL connection profile).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_dms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudDMS::V1::DeleteConnectionProfileRequest.new
            #
            #   # Call the delete_connection_profile method.
            #   result = client.delete_connection_profile request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_connection_profile request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudDMS::V1::DeleteConnectionProfileRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_connection_profile.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudDMS::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_connection_profile.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_connection_profile.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_migration_service_stub.call_rpc :delete_connection_profile, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new private connection in a given project and location.
            #
            # @overload create_private_connection(request, options = nil)
            #   Pass arguments to `create_private_connection` via a request object, either of type
            #   {::Google::Cloud::CloudDMS::V1::CreatePrivateConnectionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudDMS::V1::CreatePrivateConnectionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_private_connection(parent: nil, private_connection_id: nil, private_connection: nil, request_id: nil, skip_validation: nil)
            #   Pass arguments to `create_private_connection` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent that owns the collection of PrivateConnections.
            #   @param private_connection_id [::String]
            #     Required. The private connection identifier.
            #   @param private_connection [::Google::Cloud::CloudDMS::V1::PrivateConnection, ::Hash]
            #     Required. The private connection resource to create.
            #   @param request_id [::String]
            #     Optional. A unique ID used to identify the request. If the server receives
            #     two requests with the same ID, then the second request is ignored.
            #
            #     It is recommended to always set this value to a UUID.
            #
            #     The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
            #     (_), and hyphens (-). The maximum length is 40 characters.
            #   @param skip_validation [::Boolean]
            #     Optional. If set to true, will skip validations.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_dms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudDMS::V1::CreatePrivateConnectionRequest.new
            #
            #   # Call the create_private_connection method.
            #   result = client.create_private_connection request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_private_connection request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudDMS::V1::CreatePrivateConnectionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_private_connection.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudDMS::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_private_connection.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_private_connection.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_migration_service_stub.call_rpc :create_private_connection, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single private connection.
            #
            # @overload get_private_connection(request, options = nil)
            #   Pass arguments to `get_private_connection` via a request object, either of type
            #   {::Google::Cloud::CloudDMS::V1::GetPrivateConnectionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudDMS::V1::GetPrivateConnectionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_private_connection(name: nil)
            #   Pass arguments to `get_private_connection` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the private connection to get.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::CloudDMS::V1::PrivateConnection]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::CloudDMS::V1::PrivateConnection]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_dms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudDMS::V1::GetPrivateConnectionRequest.new
            #
            #   # Call the get_private_connection method.
            #   result = client.get_private_connection request
            #
            #   # The returned object is of type Google::Cloud::CloudDMS::V1::PrivateConnection.
            #   p result
            #
            def get_private_connection request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudDMS::V1::GetPrivateConnectionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_private_connection.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudDMS::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_private_connection.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_private_connection.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_migration_service_stub.call_rpc :get_private_connection, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieves a list of private connections in a given project and location.
            #
            # @overload list_private_connections(request, options = nil)
            #   Pass arguments to `list_private_connections` via a request object, either of type
            #   {::Google::Cloud::CloudDMS::V1::ListPrivateConnectionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudDMS::V1::ListPrivateConnectionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_private_connections(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_private_connections` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent that owns the collection of private connections.
            #   @param page_size [::Integer]
            #     Maximum number of private connections to return.
            #     If unspecified, at most 50 private connections that are returned.
            #     The maximum value is 1000; values above 1000 are coerced to 1000.
            #   @param page_token [::String]
            #     Page token received from a previous `ListPrivateConnections` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     `ListPrivateConnections` must match the call that provided the page
            #     token.
            #   @param filter [::String]
            #     A filter expression that filters private connections listed in the
            #     response. The expression must specify the field name, a comparison
            #     operator, and the value that you want to use for filtering. The value must
            #     be a string, a number, or a boolean. The comparison operator must be either
            #     =, !=, >, or <. For example, list private connections created this year by
            #     specifying **createTime %gt; 2021-01-01T00:00:00.000000000Z**.
            #   @param order_by [::String]
            #     Order by fields for the result.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::CloudDMS::V1::PrivateConnection>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::CloudDMS::V1::PrivateConnection>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_dms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudDMS::V1::ListPrivateConnectionsRequest.new
            #
            #   # Call the list_private_connections method.
            #   result = client.list_private_connections request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::CloudDMS::V1::PrivateConnection.
            #     p item
            #   end
            #
            def list_private_connections request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudDMS::V1::ListPrivateConnectionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_private_connections.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudDMS::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_private_connections.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_private_connections.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_migration_service_stub.call_rpc :list_private_connections, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @data_migration_service_stub, :list_private_connections, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single Database Migration Service private connection.
            #
            # @overload delete_private_connection(request, options = nil)
            #   Pass arguments to `delete_private_connection` via a request object, either of type
            #   {::Google::Cloud::CloudDMS::V1::DeletePrivateConnectionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudDMS::V1::DeletePrivateConnectionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_private_connection(name: nil, request_id: nil)
            #   Pass arguments to `delete_private_connection` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the private connection to delete.
            #   @param request_id [::String]
            #     Optional. A unique ID used to identify the request. If the server receives
            #     two requests with the same ID, then the second request is ignored.
            #
            #     It is recommended to always set this value to a UUID.
            #
            #     The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
            #     (_), and hyphens (-). The maximum length is 40 characters.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_dms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudDMS::V1::DeletePrivateConnectionRequest.new
            #
            #   # Call the delete_private_connection method.
            #   result = client.delete_private_connection request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_private_connection request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudDMS::V1::DeletePrivateConnectionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_private_connection.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudDMS::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_private_connection.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_private_connection.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_migration_service_stub.call_rpc :delete_private_connection, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single conversion workspace.
            #
            # @overload get_conversion_workspace(request, options = nil)
            #   Pass arguments to `get_conversion_workspace` via a request object, either of type
            #   {::Google::Cloud::CloudDMS::V1::GetConversionWorkspaceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudDMS::V1::GetConversionWorkspaceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_conversion_workspace(name: nil)
            #   Pass arguments to `get_conversion_workspace` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the conversion workspace resource to get.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::CloudDMS::V1::ConversionWorkspace]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::CloudDMS::V1::ConversionWorkspace]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_dms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudDMS::V1::GetConversionWorkspaceRequest.new
            #
            #   # Call the get_conversion_workspace method.
            #   result = client.get_conversion_workspace request
            #
            #   # The returned object is of type Google::Cloud::CloudDMS::V1::ConversionWorkspace.
            #   p result
            #
            def get_conversion_workspace request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudDMS::V1::GetConversionWorkspaceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_conversion_workspace.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudDMS::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_conversion_workspace.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_conversion_workspace.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_migration_service_stub.call_rpc :get_conversion_workspace, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists conversion workspaces in a given project and location.
            #
            # @overload list_conversion_workspaces(request, options = nil)
            #   Pass arguments to `list_conversion_workspaces` via a request object, either of type
            #   {::Google::Cloud::CloudDMS::V1::ListConversionWorkspacesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudDMS::V1::ListConversionWorkspacesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_conversion_workspaces(parent: nil, page_size: nil, page_token: nil, filter: nil)
            #   Pass arguments to `list_conversion_workspaces` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent which owns this collection of conversion workspaces.
            #   @param page_size [::Integer]
            #     The maximum number of conversion workspaces to return. The service may
            #     return fewer than this value. If unspecified, at most 50 sets are returned.
            #   @param page_token [::String]
            #     The nextPageToken value received in the previous call to
            #     conversionWorkspaces.list, used in the subsequent request to retrieve the
            #     next page of results. On first call this should be left blank. When
            #     paginating, all other parameters provided to conversionWorkspaces.list must
            #     match the call that provided the page token.
            #   @param filter [::String]
            #     A filter expression that filters conversion workspaces listed in the
            #     response. The expression must specify the field name, a comparison
            #     operator, and the value that you want to use for filtering. The value must
            #     be a string, a number, or a boolean. The comparison operator must be either
            #     =, !=, >, or <. For example, list conversion workspaces created this year
            #     by specifying **createTime %gt; 2020-01-01T00:00:00.000000000Z.** You can
            #     also filter nested fields. For example, you could specify
            #     **source.version = "12.c.1"** to select all conversion workspaces with
            #     source database version equal to 12.c.1.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::CloudDMS::V1::ConversionWorkspace>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::CloudDMS::V1::ConversionWorkspace>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_dms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudDMS::V1::ListConversionWorkspacesRequest.new
            #
            #   # Call the list_conversion_workspaces method.
            #   result = client.list_conversion_workspaces request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::CloudDMS::V1::ConversionWorkspace.
            #     p item
            #   end
            #
            def list_conversion_workspaces request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudDMS::V1::ListConversionWorkspacesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_conversion_workspaces.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudDMS::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_conversion_workspaces.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_conversion_workspaces.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_migration_service_stub.call_rpc :list_conversion_workspaces, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @data_migration_service_stub, :list_conversion_workspaces, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new conversion workspace in a given project and location.
            #
            # @overload create_conversion_workspace(request, options = nil)
            #   Pass arguments to `create_conversion_workspace` via a request object, either of type
            #   {::Google::Cloud::CloudDMS::V1::CreateConversionWorkspaceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudDMS::V1::CreateConversionWorkspaceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_conversion_workspace(parent: nil, conversion_workspace_id: nil, conversion_workspace: nil, request_id: nil)
            #   Pass arguments to `create_conversion_workspace` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent which owns this collection of conversion workspaces.
            #   @param conversion_workspace_id [::String]
            #     Required. The ID of the conversion workspace to create.
            #   @param conversion_workspace [::Google::Cloud::CloudDMS::V1::ConversionWorkspace, ::Hash]
            #     Required. Represents a conversion workspace object.
            #   @param request_id [::String]
            #     A unique ID used to identify the request. If the server receives two
            #     requests with the same ID, then the second request is ignored.
            #
            #     It is recommended to always set this value to a UUID.
            #
            #     The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
            #     (_), and hyphens (-). The maximum length is 40 characters.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_dms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudDMS::V1::CreateConversionWorkspaceRequest.new
            #
            #   # Call the create_conversion_workspace method.
            #   result = client.create_conversion_workspace request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_conversion_workspace request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudDMS::V1::CreateConversionWorkspaceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_conversion_workspace.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudDMS::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_conversion_workspace.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_conversion_workspace.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_migration_service_stub.call_rpc :create_conversion_workspace, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of a single conversion workspace.
            #
            # @overload update_conversion_workspace(request, options = nil)
            #   Pass arguments to `update_conversion_workspace` via a request object, either of type
            #   {::Google::Cloud::CloudDMS::V1::UpdateConversionWorkspaceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudDMS::V1::UpdateConversionWorkspaceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_conversion_workspace(update_mask: nil, conversion_workspace: nil, request_id: nil)
            #   Pass arguments to `update_conversion_workspace` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Field mask is used to specify the fields to be overwritten by the
            #     update in the conversion workspace resource.
            #   @param conversion_workspace [::Google::Cloud::CloudDMS::V1::ConversionWorkspace, ::Hash]
            #     Required. The conversion workspace parameters to update.
            #   @param request_id [::String]
            #     A unique ID used to identify the request. If the server receives two
            #     requests with the same ID, then the second request is ignored.
            #
            #     It is recommended to always set this value to a UUID.
            #
            #     The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
            #     (_), and hyphens (-). The maximum length is 40 characters.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_dms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudDMS::V1::UpdateConversionWorkspaceRequest.new
            #
            #   # Call the update_conversion_workspace method.
            #   result = client.update_conversion_workspace request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_conversion_workspace request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudDMS::V1::UpdateConversionWorkspaceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_conversion_workspace.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudDMS::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.conversion_workspace&.name
                header_params["conversion_workspace.name"] = request.conversion_workspace.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_conversion_workspace.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_conversion_workspace.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_migration_service_stub.call_rpc :update_conversion_workspace, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single conversion workspace.
            #
            # @overload delete_conversion_workspace(request, options = nil)
            #   Pass arguments to `delete_conversion_workspace` via a request object, either of type
            #   {::Google::Cloud::CloudDMS::V1::DeleteConversionWorkspaceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudDMS::V1::DeleteConversionWorkspaceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_conversion_workspace(name: nil, request_id: nil, force: nil)
            #   Pass arguments to `delete_conversion_workspace` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the conversion workspace resource to delete.
            #   @param request_id [::String]
            #     A unique ID used to identify the request. If the server receives two
            #     requests with the same ID, then the second request is ignored.
            #
            #     It is recommended to always set this value to a UUID.
            #
            #     The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
            #     (_), and hyphens (-). The maximum length is 40 characters.
            #   @param force [::Boolean]
            #     Force delete the conversion workspace, even if there's a running migration
            #     that is using the workspace.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_dms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudDMS::V1::DeleteConversionWorkspaceRequest.new
            #
            #   # Call the delete_conversion_workspace method.
            #   result = client.delete_conversion_workspace request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_conversion_workspace request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudDMS::V1::DeleteConversionWorkspaceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_conversion_workspace.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudDMS::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_conversion_workspace.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_conversion_workspace.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_migration_service_stub.call_rpc :delete_conversion_workspace, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new mapping rule for a given conversion workspace.
            #
            # @overload create_mapping_rule(request, options = nil)
            #   Pass arguments to `create_mapping_rule` via a request object, either of type
            #   {::Google::Cloud::CloudDMS::V1::CreateMappingRuleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudDMS::V1::CreateMappingRuleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_mapping_rule(parent: nil, mapping_rule_id: nil, mapping_rule: nil, request_id: nil)
            #   Pass arguments to `create_mapping_rule` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent which owns this collection of mapping rules.
            #   @param mapping_rule_id [::String]
            #     Required. The ID of the rule to create.
            #   @param mapping_rule [::Google::Cloud::CloudDMS::V1::MappingRule, ::Hash]
            #     Required. Represents a [mapping rule]
            #     (https://cloud.google.com/database-migration/reference/rest/v1/projects.locations.mappingRules)
            #     object.
            #   @param request_id [::String]
            #     A unique ID used to identify the request. If the server receives two
            #     requests with the same ID, then the second request is ignored.
            #
            #     It is recommended to always set this value to a UUID.
            #
            #     The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
            #     (_), and hyphens (-). The maximum length is 40 characters.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::CloudDMS::V1::MappingRule]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::CloudDMS::V1::MappingRule]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_dms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudDMS::V1::CreateMappingRuleRequest.new
            #
            #   # Call the create_mapping_rule method.
            #   result = client.create_mapping_rule request
            #
            #   # The returned object is of type Google::Cloud::CloudDMS::V1::MappingRule.
            #   p result
            #
            def create_mapping_rule request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudDMS::V1::CreateMappingRuleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_mapping_rule.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudDMS::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_mapping_rule.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_mapping_rule.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_migration_service_stub.call_rpc :create_mapping_rule, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single mapping rule.
            #
            # @overload delete_mapping_rule(request, options = nil)
            #   Pass arguments to `delete_mapping_rule` via a request object, either of type
            #   {::Google::Cloud::CloudDMS::V1::DeleteMappingRuleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudDMS::V1::DeleteMappingRuleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_mapping_rule(name: nil, request_id: nil)
            #   Pass arguments to `delete_mapping_rule` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the mapping rule resource to delete.
            #   @param request_id [::String]
            #     Optional. A unique ID used to identify the request. If the server receives
            #     two requests with the same ID, then the second request is ignored.
            #
            #     It is recommended to always set this value to a UUID.
            #
            #     The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
            #     (_), and hyphens (-). The maximum length is 40 characters.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_dms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudDMS::V1::DeleteMappingRuleRequest.new
            #
            #   # Call the delete_mapping_rule method.
            #   result = client.delete_mapping_rule request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_mapping_rule request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudDMS::V1::DeleteMappingRuleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_mapping_rule.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudDMS::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_mapping_rule.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_mapping_rule.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_migration_service_stub.call_rpc :delete_mapping_rule, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists the mapping rules for a specific conversion workspace.
            #
            # @overload list_mapping_rules(request, options = nil)
            #   Pass arguments to `list_mapping_rules` via a request object, either of type
            #   {::Google::Cloud::CloudDMS::V1::ListMappingRulesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudDMS::V1::ListMappingRulesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_mapping_rules(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_mapping_rules` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Name of the conversion workspace resource whose mapping rules are
            #     listed in the form of:
            #     projects/\\{project}/locations/\\{location}/conversionWorkspaces/\\{conversion_workspace}.
            #   @param page_size [::Integer]
            #     The maximum number of rules to return. The service may return
            #     fewer than this value.
            #   @param page_token [::String]
            #     The nextPageToken value received in the previous call to
            #     mappingRules.list, used in the subsequent request to retrieve the next
            #     page of results. On first call this should be left blank. When paginating,
            #     all other parameters provided to mappingRules.list must match the call
            #     that provided the page token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::CloudDMS::V1::MappingRule>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::CloudDMS::V1::MappingRule>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_dms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudDMS::V1::ListMappingRulesRequest.new
            #
            #   # Call the list_mapping_rules method.
            #   result = client.list_mapping_rules request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::CloudDMS::V1::MappingRule.
            #     p item
            #   end
            #
            def list_mapping_rules request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudDMS::V1::ListMappingRulesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_mapping_rules.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudDMS::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_mapping_rules.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_mapping_rules.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_migration_service_stub.call_rpc :list_mapping_rules, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @data_migration_service_stub, :list_mapping_rules, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets the details of a mapping rule.
            #
            # @overload get_mapping_rule(request, options = nil)
            #   Pass arguments to `get_mapping_rule` via a request object, either of type
            #   {::Google::Cloud::CloudDMS::V1::GetMappingRuleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudDMS::V1::GetMappingRuleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_mapping_rule(name: nil)
            #   Pass arguments to `get_mapping_rule` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the mapping rule resource to get.
            #     Example: conversionWorkspaces/123/mappingRules/rule123
            #
            #     In order to retrieve a previous revision of the mapping rule, also provide
            #     the revision ID.
            #     Example:
            #     conversionWorkspace/123/mappingRules/rule123@c7cfa2a8c7cfa2a8c7cfa2a8c7cfa2a8
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::CloudDMS::V1::MappingRule]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::CloudDMS::V1::MappingRule]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_dms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudDMS::V1::GetMappingRuleRequest.new
            #
            #   # Call the get_mapping_rule method.
            #   result = client.get_mapping_rule request
            #
            #   # The returned object is of type Google::Cloud::CloudDMS::V1::MappingRule.
            #   p result
            #
            def get_mapping_rule request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudDMS::V1::GetMappingRuleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_mapping_rule.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudDMS::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_mapping_rule.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_mapping_rule.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_migration_service_stub.call_rpc :get_mapping_rule, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Imports a snapshot of the source database into the
            # conversion workspace.
            #
            # @overload seed_conversion_workspace(request, options = nil)
            #   Pass arguments to `seed_conversion_workspace` via a request object, either of type
            #   {::Google::Cloud::CloudDMS::V1::SeedConversionWorkspaceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudDMS::V1::SeedConversionWorkspaceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload seed_conversion_workspace(name: nil, auto_commit: nil, source_connection_profile: nil, destination_connection_profile: nil)
            #   Pass arguments to `seed_conversion_workspace` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Name of the conversion workspace resource to seed with new database
            #     structure, in the form of:
            #     projects/\\{project}/locations/\\{location}/conversionWorkspaces/\\{conversion_workspace}.
            #   @param auto_commit [::Boolean]
            #     Should the conversion workspace be committed automatically after the
            #     seed operation.
            #   @param source_connection_profile [::String]
            #     Optional. Fully qualified (Uri) name of the source connection profile.
            #
            #     Note: The following parameters are mutually exclusive: `source_connection_profile`, `destination_connection_profile`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param destination_connection_profile [::String]
            #     Optional. Fully qualified (Uri) name of the destination connection
            #     profile.
            #
            #     Note: The following parameters are mutually exclusive: `destination_connection_profile`, `source_connection_profile`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_dms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudDMS::V1::SeedConversionWorkspaceRequest.new
            #
            #   # Call the seed_conversion_workspace method.
            #   result = client.seed_conversion_workspace request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def seed_conversion_workspace request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudDMS::V1::SeedConversionWorkspaceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.seed_conversion_workspace.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudDMS::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.seed_conversion_workspace.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.seed_conversion_workspace.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_migration_service_stub.call_rpc :seed_conversion_workspace, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Imports the mapping rules for a given conversion workspace.
            # Supports various formats of external rules files.
            #
            # @overload import_mapping_rules(request, options = nil)
            #   Pass arguments to `import_mapping_rules` via a request object, either of type
            #   {::Google::Cloud::CloudDMS::V1::ImportMappingRulesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudDMS::V1::ImportMappingRulesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload import_mapping_rules(parent: nil, rules_format: nil, rules_files: nil, auto_commit: nil)
            #   Pass arguments to `import_mapping_rules` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Name of the conversion workspace resource to import the rules to
            #     in the form of:
            #     projects/\\{project}/locations/\\{location}/conversionWorkspaces/\\{conversion_workspace}.
            #   @param rules_format [::Google::Cloud::CloudDMS::V1::ImportRulesFileFormat]
            #     Required. The format of the rules content file.
            #   @param rules_files [::Array<::Google::Cloud::CloudDMS::V1::ImportMappingRulesRequest::RulesFile, ::Hash>]
            #     Required. One or more rules files.
            #   @param auto_commit [::Boolean]
            #     Required. Should the conversion workspace be committed automatically after
            #     the import operation.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_dms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudDMS::V1::ImportMappingRulesRequest.new
            #
            #   # Call the import_mapping_rules method.
            #   result = client.import_mapping_rules request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def import_mapping_rules request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudDMS::V1::ImportMappingRulesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.import_mapping_rules.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudDMS::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.import_mapping_rules.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.import_mapping_rules.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_migration_service_stub.call_rpc :import_mapping_rules, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a draft tree schema for the destination database.
            #
            # @overload convert_conversion_workspace(request, options = nil)
            #   Pass arguments to `convert_conversion_workspace` via a request object, either of type
            #   {::Google::Cloud::CloudDMS::V1::ConvertConversionWorkspaceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudDMS::V1::ConvertConversionWorkspaceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload convert_conversion_workspace(name: nil, auto_commit: nil, filter: nil, convert_full_path: nil)
            #   Pass arguments to `convert_conversion_workspace` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Name of the conversion workspace resource to convert in the form of:
            #     projects/\\{project}/locations/\\{location}/conversionWorkspaces/\\{conversion_workspace}.
            #   @param auto_commit [::Boolean]
            #     Optional. Specifies whether the conversion workspace is to be committed
            #     automatically after the conversion.
            #   @param filter [::String]
            #     Optional. Filter the entities to convert. Leaving this field empty will
            #     convert all of the entities. Supports Google AIP-160 style filtering.
            #   @param convert_full_path [::Boolean]
            #     Optional. Automatically convert the full entity path for each entity
            #     specified by the filter. For example, if the filter specifies a table, that
            #     table schema (and database if there is one) will also be converted.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_dms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudDMS::V1::ConvertConversionWorkspaceRequest.new
            #
            #   # Call the convert_conversion_workspace method.
            #   result = client.convert_conversion_workspace request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def convert_conversion_workspace request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudDMS::V1::ConvertConversionWorkspaceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.convert_conversion_workspace.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudDMS::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.convert_conversion_workspace.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.convert_conversion_workspace.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_migration_service_stub.call_rpc :convert_conversion_workspace, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Marks all the data in the conversion workspace as committed.
            #
            # @overload commit_conversion_workspace(request, options = nil)
            #   Pass arguments to `commit_conversion_workspace` via a request object, either of type
            #   {::Google::Cloud::CloudDMS::V1::CommitConversionWorkspaceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudDMS::V1::CommitConversionWorkspaceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload commit_conversion_workspace(name: nil, commit_name: nil)
            #   Pass arguments to `commit_conversion_workspace` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the conversion workspace resource to commit.
            #   @param commit_name [::String]
            #     Optional. Optional name of the commit.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_dms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudDMS::V1::CommitConversionWorkspaceRequest.new
            #
            #   # Call the commit_conversion_workspace method.
            #   result = client.commit_conversion_workspace request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def commit_conversion_workspace request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudDMS::V1::CommitConversionWorkspaceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.commit_conversion_workspace.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudDMS::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.commit_conversion_workspace.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.commit_conversion_workspace.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_migration_service_stub.call_rpc :commit_conversion_workspace, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Rolls back a conversion workspace to the last committed snapshot.
            #
            # @overload rollback_conversion_workspace(request, options = nil)
            #   Pass arguments to `rollback_conversion_workspace` via a request object, either of type
            #   {::Google::Cloud::CloudDMS::V1::RollbackConversionWorkspaceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudDMS::V1::RollbackConversionWorkspaceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload rollback_conversion_workspace(name: nil)
            #   Pass arguments to `rollback_conversion_workspace` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the conversion workspace resource to roll back to.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_dms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudDMS::V1::RollbackConversionWorkspaceRequest.new
            #
            #   # Call the rollback_conversion_workspace method.
            #   result = client.rollback_conversion_workspace request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def rollback_conversion_workspace request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudDMS::V1::RollbackConversionWorkspaceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.rollback_conversion_workspace.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudDMS::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.rollback_conversion_workspace.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.rollback_conversion_workspace.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_migration_service_stub.call_rpc :rollback_conversion_workspace, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Applies draft tree onto a specific destination database.
            #
            # @overload apply_conversion_workspace(request, options = nil)
            #   Pass arguments to `apply_conversion_workspace` via a request object, either of type
            #   {::Google::Cloud::CloudDMS::V1::ApplyConversionWorkspaceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudDMS::V1::ApplyConversionWorkspaceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload apply_conversion_workspace(name: nil, filter: nil, dry_run: nil, auto_commit: nil, connection_profile: nil)
            #   Pass arguments to `apply_conversion_workspace` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the conversion workspace resource for which to apply
            #     the draft tree. Must be in the form of:
            #      projects/\\{project}/locations/\\{location}/conversionWorkspaces/\\{conversion_workspace}.
            #   @param filter [::String]
            #     Filter which entities to apply. Leaving this field empty will apply all of
            #     the entities. Supports Google AIP 160 based filtering.
            #   @param dry_run [::Boolean]
            #     Optional. Only validates the apply process, but doesn't change the
            #     destination database. Only works for PostgreSQL destination connection
            #     profile.
            #   @param auto_commit [::Boolean]
            #     Optional. Specifies whether the conversion workspace is to be committed
            #     automatically after the apply.
            #   @param connection_profile [::String]
            #     Optional. Fully qualified (Uri) name of the destination connection
            #     profile.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_dms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudDMS::V1::ApplyConversionWorkspaceRequest.new
            #
            #   # Call the apply_conversion_workspace method.
            #   result = client.apply_conversion_workspace request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def apply_conversion_workspace request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudDMS::V1::ApplyConversionWorkspaceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.apply_conversion_workspace.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudDMS::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.apply_conversion_workspace.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.apply_conversion_workspace.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_migration_service_stub.call_rpc :apply_conversion_workspace, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Describes the database entities tree for a specific conversion workspace
            # and a specific tree type.
            #
            # Database entities are not resources like conversion workspaces or mapping
            # rules, and they can't be created, updated or deleted. Instead, they are
            # simple data objects describing the structure of the client database.
            #
            # @overload describe_database_entities(request, options = nil)
            #   Pass arguments to `describe_database_entities` via a request object, either of type
            #   {::Google::Cloud::CloudDMS::V1::DescribeDatabaseEntitiesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudDMS::V1::DescribeDatabaseEntitiesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload describe_database_entities(conversion_workspace: nil, page_size: nil, page_token: nil, tree: nil, uncommitted: nil, commit_id: nil, filter: nil, view: nil)
            #   Pass arguments to `describe_database_entities` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param conversion_workspace [::String]
            #     Required. Name of the conversion workspace resource whose database entities
            #     are described. Must be in the form of:
            #     projects/\\{project}/locations/\\{location}/conversionWorkspaces/\\{conversion_workspace}.
            #   @param page_size [::Integer]
            #     Optional. The maximum number of entities to return. The service may return
            #     fewer entities than the value specifies.
            #   @param page_token [::String]
            #     Optional. The nextPageToken value received in the previous call to
            #     conversionWorkspace.describeDatabaseEntities, used in the subsequent
            #     request to retrieve the next page of results. On first call this should be
            #     left blank. When paginating, all other parameters provided to
            #     conversionWorkspace.describeDatabaseEntities must match the call that
            #     provided the page token.
            #   @param tree [::Google::Cloud::CloudDMS::V1::DescribeDatabaseEntitiesRequest::DBTreeType]
            #     Required. The tree to fetch.
            #   @param uncommitted [::Boolean]
            #     Optional. Whether to retrieve the latest committed version of the entities
            #     or the latest version. This field is ignored if a specific commit_id is
            #     specified.
            #   @param commit_id [::String]
            #     Optional. Request a specific commit ID. If not specified, the entities from
            #     the latest commit are returned.
            #   @param filter [::String]
            #     Optional. Filter the returned entities based on AIP-160 standard.
            #   @param view [::Google::Cloud::CloudDMS::V1::DatabaseEntityView]
            #     Optional. Results view based on AIP-157
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::CloudDMS::V1::DatabaseEntity>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::CloudDMS::V1::DatabaseEntity>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_dms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudDMS::V1::DescribeDatabaseEntitiesRequest.new
            #
            #   # Call the describe_database_entities method.
            #   result = client.describe_database_entities request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::CloudDMS::V1::DatabaseEntity.
            #     p item
            #   end
            #
            def describe_database_entities request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudDMS::V1::DescribeDatabaseEntitiesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.describe_database_entities.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudDMS::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.conversion_workspace
                header_params["conversion_workspace"] = request.conversion_workspace
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.describe_database_entities.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.describe_database_entities.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_migration_service_stub.call_rpc :describe_database_entities, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @data_migration_service_stub, :describe_database_entities, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Searches/lists the background jobs for a specific
            # conversion workspace.
            #
            # The background jobs are not resources like conversion workspaces or
            # mapping rules, and they can't be created, updated or deleted.
            # Instead, they are a way to expose the data plane jobs log.
            #
            # @overload search_background_jobs(request, options = nil)
            #   Pass arguments to `search_background_jobs` via a request object, either of type
            #   {::Google::Cloud::CloudDMS::V1::SearchBackgroundJobsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudDMS::V1::SearchBackgroundJobsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload search_background_jobs(conversion_workspace: nil, return_most_recent_per_job_type: nil, max_size: nil, completed_until_time: nil)
            #   Pass arguments to `search_background_jobs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param conversion_workspace [::String]
            #     Required. Name of the conversion workspace resource whose jobs are listed,
            #     in the form of:
            #     projects/\\{project}/locations/\\{location}/conversionWorkspaces/\\{conversion_workspace}.
            #   @param return_most_recent_per_job_type [::Boolean]
            #     Optional. Whether or not to return just the most recent job per job type,
            #   @param max_size [::Integer]
            #     Optional. The maximum number of jobs to return. The service may return
            #     fewer than this value. If unspecified, at most 100 jobs are
            #     returned. The maximum value is 100; values above 100 are coerced to
            #     100.
            #   @param completed_until_time [::Google::Protobuf::Timestamp, ::Hash]
            #     Optional. If provided, only returns jobs that completed until (not
            #     including) the given timestamp.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::CloudDMS::V1::SearchBackgroundJobsResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::CloudDMS::V1::SearchBackgroundJobsResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_dms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudDMS::V1::SearchBackgroundJobsRequest.new
            #
            #   # Call the search_background_jobs method.
            #   result = client.search_background_jobs request
            #
            #   # The returned object is of type Google::Cloud::CloudDMS::V1::SearchBackgroundJobsResponse.
            #   p result
            #
            def search_background_jobs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudDMS::V1::SearchBackgroundJobsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.search_background_jobs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudDMS::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.conversion_workspace
                header_params["conversion_workspace"] = request.conversion_workspace
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.search_background_jobs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.search_background_jobs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_migration_service_stub.call_rpc :search_background_jobs, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieves a list of committed revisions of a specific conversion
            # workspace.
            #
            # @overload describe_conversion_workspace_revisions(request, options = nil)
            #   Pass arguments to `describe_conversion_workspace_revisions` via a request object, either of type
            #   {::Google::Cloud::CloudDMS::V1::DescribeConversionWorkspaceRevisionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudDMS::V1::DescribeConversionWorkspaceRevisionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload describe_conversion_workspace_revisions(conversion_workspace: nil, commit_id: nil)
            #   Pass arguments to `describe_conversion_workspace_revisions` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param conversion_workspace [::String]
            #     Required. Name of the conversion workspace resource whose revisions are
            #     listed. Must be in the form of:
            #     projects/\\{project}/locations/\\{location}/conversionWorkspaces/\\{conversion_workspace}.
            #   @param commit_id [::String]
            #     Optional. Optional filter to request a specific commit ID.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::CloudDMS::V1::DescribeConversionWorkspaceRevisionsResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::CloudDMS::V1::DescribeConversionWorkspaceRevisionsResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_dms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudDMS::V1::DescribeConversionWorkspaceRevisionsRequest.new
            #
            #   # Call the describe_conversion_workspace_revisions method.
            #   result = client.describe_conversion_workspace_revisions request
            #
            #   # The returned object is of type Google::Cloud::CloudDMS::V1::DescribeConversionWorkspaceRevisionsResponse.
            #   p result
            #
            def describe_conversion_workspace_revisions request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudDMS::V1::DescribeConversionWorkspaceRevisionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.describe_conversion_workspace_revisions.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudDMS::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.conversion_workspace
                header_params["conversion_workspace"] = request.conversion_workspace
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.describe_conversion_workspace_revisions.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.describe_conversion_workspace_revisions.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_migration_service_stub.call_rpc :describe_conversion_workspace_revisions, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Fetches a set of static IP addresses that need to be allowlisted by the
            # customer when using the static-IP connectivity method.
            #
            # @overload fetch_static_ips(request, options = nil)
            #   Pass arguments to `fetch_static_ips` via a request object, either of type
            #   {::Google::Cloud::CloudDMS::V1::FetchStaticIpsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CloudDMS::V1::FetchStaticIpsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload fetch_static_ips(name: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `fetch_static_ips` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name for the location for which static IPs should be
            #     returned. Must be in the format `projects/*/locations/*`.
            #   @param page_size [::Integer]
            #     Maximum number of IPs to return.
            #   @param page_token [::String]
            #     A page token, received from a previous `FetchStaticIps` call.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::CloudDMS::V1::FetchStaticIpsResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::CloudDMS::V1::FetchStaticIpsResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/cloud_dms/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CloudDMS::V1::FetchStaticIpsRequest.new
            #
            #   # Call the fetch_static_ips method.
            #   result = client.fetch_static_ips request
            #
            #   # The returned object is of type Google::Cloud::CloudDMS::V1::FetchStaticIpsResponse.
            #   p result
            #
            def fetch_static_ips request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudDMS::V1::FetchStaticIpsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.fetch_static_ips.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CloudDMS::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.fetch_static_ips.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.fetch_static_ips.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_migration_service_stub.call_rpc :fetch_static_ips, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the DataMigrationService API.
            #
            # This class represents the configuration for DataMigrationService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::CloudDMS::V1::DataMigrationService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # list_migration_jobs to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_migration_jobs.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_migration_jobs.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::CloudDMS::V1::DataMigrationService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "datamigration.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the DataMigrationService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `list_migration_jobs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_migration_jobs
                ##
                # RPC-specific configuration for `get_migration_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_migration_job
                ##
                # RPC-specific configuration for `create_migration_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_migration_job
                ##
                # RPC-specific configuration for `update_migration_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_migration_job
                ##
                # RPC-specific configuration for `delete_migration_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_migration_job
                ##
                # RPC-specific configuration for `start_migration_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :start_migration_job
                ##
                # RPC-specific configuration for `stop_migration_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :stop_migration_job
                ##
                # RPC-specific configuration for `resume_migration_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :resume_migration_job
                ##
                # RPC-specific configuration for `promote_migration_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :promote_migration_job
                ##
                # RPC-specific configuration for `verify_migration_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :verify_migration_job
                ##
                # RPC-specific configuration for `restart_migration_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :restart_migration_job
                ##
                # RPC-specific configuration for `generate_ssh_script`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :generate_ssh_script
                ##
                # RPC-specific configuration for `generate_tcp_proxy_script`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :generate_tcp_proxy_script
                ##
                # RPC-specific configuration for `list_connection_profiles`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_connection_profiles
                ##
                # RPC-specific configuration for `get_connection_profile`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_connection_profile
                ##
                # RPC-specific configuration for `create_connection_profile`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_connection_profile
                ##
                # RPC-specific configuration for `update_connection_profile`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_connection_profile
                ##
                # RPC-specific configuration for `delete_connection_profile`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_connection_profile
                ##
                # RPC-specific configuration for `create_private_connection`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_private_connection
                ##
                # RPC-specific configuration for `get_private_connection`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_private_connection
                ##
                # RPC-specific configuration for `list_private_connections`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_private_connections
                ##
                # RPC-specific configuration for `delete_private_connection`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_private_connection
                ##
                # RPC-specific configuration for `get_conversion_workspace`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_conversion_workspace
                ##
                # RPC-specific configuration for `list_conversion_workspaces`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_conversion_workspaces
                ##
                # RPC-specific configuration for `create_conversion_workspace`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_conversion_workspace
                ##
                # RPC-specific configuration for `update_conversion_workspace`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_conversion_workspace
                ##
                # RPC-specific configuration for `delete_conversion_workspace`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_conversion_workspace
                ##
                # RPC-specific configuration for `create_mapping_rule`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_mapping_rule
                ##
                # RPC-specific configuration for `delete_mapping_rule`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_mapping_rule
                ##
                # RPC-specific configuration for `list_mapping_rules`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_mapping_rules
                ##
                # RPC-specific configuration for `get_mapping_rule`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_mapping_rule
                ##
                # RPC-specific configuration for `seed_conversion_workspace`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :seed_conversion_workspace
                ##
                # RPC-specific configuration for `import_mapping_rules`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :import_mapping_rules
                ##
                # RPC-specific configuration for `convert_conversion_workspace`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :convert_conversion_workspace
                ##
                # RPC-specific configuration for `commit_conversion_workspace`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :commit_conversion_workspace
                ##
                # RPC-specific configuration for `rollback_conversion_workspace`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :rollback_conversion_workspace
                ##
                # RPC-specific configuration for `apply_conversion_workspace`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :apply_conversion_workspace
                ##
                # RPC-specific configuration for `describe_database_entities`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :describe_database_entities
                ##
                # RPC-specific configuration for `search_background_jobs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :search_background_jobs
                ##
                # RPC-specific configuration for `describe_conversion_workspace_revisions`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :describe_conversion_workspace_revisions
                ##
                # RPC-specific configuration for `fetch_static_ips`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :fetch_static_ips

                # @private
                def initialize parent_rpcs = nil
                  list_migration_jobs_config = parent_rpcs.list_migration_jobs if parent_rpcs.respond_to? :list_migration_jobs
                  @list_migration_jobs = ::Gapic::Config::Method.new list_migration_jobs_config
                  get_migration_job_config = parent_rpcs.get_migration_job if parent_rpcs.respond_to? :get_migration_job
                  @get_migration_job = ::Gapic::Config::Method.new get_migration_job_config
                  create_migration_job_config = parent_rpcs.create_migration_job if parent_rpcs.respond_to? :create_migration_job
                  @create_migration_job = ::Gapic::Config::Method.new create_migration_job_config
                  update_migration_job_config = parent_rpcs.update_migration_job if parent_rpcs.respond_to? :update_migration_job
                  @update_migration_job = ::Gapic::Config::Method.new update_migration_job_config
                  delete_migration_job_config = parent_rpcs.delete_migration_job if parent_rpcs.respond_to? :delete_migration_job
                  @delete_migration_job = ::Gapic::Config::Method.new delete_migration_job_config
                  start_migration_job_config = parent_rpcs.start_migration_job if parent_rpcs.respond_to? :start_migration_job
                  @start_migration_job = ::Gapic::Config::Method.new start_migration_job_config
                  stop_migration_job_config = parent_rpcs.stop_migration_job if parent_rpcs.respond_to? :stop_migration_job
                  @stop_migration_job = ::Gapic::Config::Method.new stop_migration_job_config
                  resume_migration_job_config = parent_rpcs.resume_migration_job if parent_rpcs.respond_to? :resume_migration_job
                  @resume_migration_job = ::Gapic::Config::Method.new resume_migration_job_config
                  promote_migration_job_config = parent_rpcs.promote_migration_job if parent_rpcs.respond_to? :promote_migration_job
                  @promote_migration_job = ::Gapic::Config::Method.new promote_migration_job_config
                  verify_migration_job_config = parent_rpcs.verify_migration_job if parent_rpcs.respond_to? :verify_migration_job
                  @verify_migration_job = ::Gapic::Config::Method.new verify_migration_job_config
                  restart_migration_job_config = parent_rpcs.restart_migration_job if parent_rpcs.respond_to? :restart_migration_job
                  @restart_migration_job = ::Gapic::Config::Method.new restart_migration_job_config
                  generate_ssh_script_config = parent_rpcs.generate_ssh_script if parent_rpcs.respond_to? :generate_ssh_script
                  @generate_ssh_script = ::Gapic::Config::Method.new generate_ssh_script_config
                  generate_tcp_proxy_script_config = parent_rpcs.generate_tcp_proxy_script if parent_rpcs.respond_to? :generate_tcp_proxy_script
                  @generate_tcp_proxy_script = ::Gapic::Config::Method.new generate_tcp_proxy_script_config
                  list_connection_profiles_config = parent_rpcs.list_connection_profiles if parent_rpcs.respond_to? :list_connection_profiles
                  @list_connection_profiles = ::Gapic::Config::Method.new list_connection_profiles_config
                  get_connection_profile_config = parent_rpcs.get_connection_profile if parent_rpcs.respond_to? :get_connection_profile
                  @get_connection_profile = ::Gapic::Config::Method.new get_connection_profile_config
                  create_connection_profile_config = parent_rpcs.create_connection_profile if parent_rpcs.respond_to? :create_connection_profile
                  @create_connection_profile = ::Gapic::Config::Method.new create_connection_profile_config
                  update_connection_profile_config = parent_rpcs.update_connection_profile if parent_rpcs.respond_to? :update_connection_profile
                  @update_connection_profile = ::Gapic::Config::Method.new update_connection_profile_config
                  delete_connection_profile_config = parent_rpcs.delete_connection_profile if parent_rpcs.respond_to? :delete_connection_profile
                  @delete_connection_profile = ::Gapic::Config::Method.new delete_connection_profile_config
                  create_private_connection_config = parent_rpcs.create_private_connection if parent_rpcs.respond_to? :create_private_connection
                  @create_private_connection = ::Gapic::Config::Method.new create_private_connection_config
                  get_private_connection_config = parent_rpcs.get_private_connection if parent_rpcs.respond_to? :get_private_connection
                  @get_private_connection = ::Gapic::Config::Method.new get_private_connection_config
                  list_private_connections_config = parent_rpcs.list_private_connections if parent_rpcs.respond_to? :list_private_connections
                  @list_private_connections = ::Gapic::Config::Method.new list_private_connections_config
                  delete_private_connection_config = parent_rpcs.delete_private_connection if parent_rpcs.respond_to? :delete_private_connection
                  @delete_private_connection = ::Gapic::Config::Method.new delete_private_connection_config
                  get_conversion_workspace_config = parent_rpcs.get_conversion_workspace if parent_rpcs.respond_to? :get_conversion_workspace
                  @get_conversion_workspace = ::Gapic::Config::Method.new get_conversion_workspace_config
                  list_conversion_workspaces_config = parent_rpcs.list_conversion_workspaces if parent_rpcs.respond_to? :list_conversion_workspaces
                  @list_conversion_workspaces = ::Gapic::Config::Method.new list_conversion_workspaces_config
                  create_conversion_workspace_config = parent_rpcs.create_conversion_workspace if parent_rpcs.respond_to? :create_conversion_workspace
                  @create_conversion_workspace = ::Gapic::Config::Method.new create_conversion_workspace_config
                  update_conversion_workspace_config = parent_rpcs.update_conversion_workspace if parent_rpcs.respond_to? :update_conversion_workspace
                  @update_conversion_workspace = ::Gapic::Config::Method.new update_conversion_workspace_config
                  delete_conversion_workspace_config = parent_rpcs.delete_conversion_workspace if parent_rpcs.respond_to? :delete_conversion_workspace
                  @delete_conversion_workspace = ::Gapic::Config::Method.new delete_conversion_workspace_config
                  create_mapping_rule_config = parent_rpcs.create_mapping_rule if parent_rpcs.respond_to? :create_mapping_rule
                  @create_mapping_rule = ::Gapic::Config::Method.new create_mapping_rule_config
                  delete_mapping_rule_config = parent_rpcs.delete_mapping_rule if parent_rpcs.respond_to? :delete_mapping_rule
                  @delete_mapping_rule = ::Gapic::Config::Method.new delete_mapping_rule_config
                  list_mapping_rules_config = parent_rpcs.list_mapping_rules if parent_rpcs.respond_to? :list_mapping_rules
                  @list_mapping_rules = ::Gapic::Config::Method.new list_mapping_rules_config
                  get_mapping_rule_config = parent_rpcs.get_mapping_rule if parent_rpcs.respond_to? :get_mapping_rule
                  @get_mapping_rule = ::Gapic::Config::Method.new get_mapping_rule_config
                  seed_conversion_workspace_config = parent_rpcs.seed_conversion_workspace if parent_rpcs.respond_to? :seed_conversion_workspace
                  @seed_conversion_workspace = ::Gapic::Config::Method.new seed_conversion_workspace_config
                  import_mapping_rules_config = parent_rpcs.import_mapping_rules if parent_rpcs.respond_to? :import_mapping_rules
                  @import_mapping_rules = ::Gapic::Config::Method.new import_mapping_rules_config
                  convert_conversion_workspace_config = parent_rpcs.convert_conversion_workspace if parent_rpcs.respond_to? :convert_conversion_workspace
                  @convert_conversion_workspace = ::Gapic::Config::Method.new convert_conversion_workspace_config
                  commit_conversion_workspace_config = parent_rpcs.commit_conversion_workspace if parent_rpcs.respond_to? :commit_conversion_workspace
                  @commit_conversion_workspace = ::Gapic::Config::Method.new commit_conversion_workspace_config
                  rollback_conversion_workspace_config = parent_rpcs.rollback_conversion_workspace if parent_rpcs.respond_to? :rollback_conversion_workspace
                  @rollback_conversion_workspace = ::Gapic::Config::Method.new rollback_conversion_workspace_config
                  apply_conversion_workspace_config = parent_rpcs.apply_conversion_workspace if parent_rpcs.respond_to? :apply_conversion_workspace
                  @apply_conversion_workspace = ::Gapic::Config::Method.new apply_conversion_workspace_config
                  describe_database_entities_config = parent_rpcs.describe_database_entities if parent_rpcs.respond_to? :describe_database_entities
                  @describe_database_entities = ::Gapic::Config::Method.new describe_database_entities_config
                  search_background_jobs_config = parent_rpcs.search_background_jobs if parent_rpcs.respond_to? :search_background_jobs
                  @search_background_jobs = ::Gapic::Config::Method.new search_background_jobs_config
                  describe_conversion_workspace_revisions_config = parent_rpcs.describe_conversion_workspace_revisions if parent_rpcs.respond_to? :describe_conversion_workspace_revisions
                  @describe_conversion_workspace_revisions = ::Gapic::Config::Method.new describe_conversion_workspace_revisions_config
                  fetch_static_ips_config = parent_rpcs.fetch_static_ips if parent_rpcs.respond_to? :fetch_static_ips
                  @fetch_static_ips = ::Gapic::Config::Method.new fetch_static_ips_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
