# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/cloudcontrolspartner/v1beta/monitoring_pb"
require "google/cloud/cloud_controls_partner/v1beta/cloud_controls_partner_monitoring"

class ::Google::Cloud::CloudControlsPartner::V1beta::CloudControlsPartnerMonitoring::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_violations
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CloudControlsPartner::V1beta::ListViolationsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"
    interval = {}

    list_violations_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_violations, name
      assert_kind_of ::Google::Cloud::CloudControlsPartner::V1beta::ListViolationsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Type::Interval), request["interval"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_violations_client_stub do
      # Create client
      client = ::Google::Cloud::CloudControlsPartner::V1beta::CloudControlsPartnerMonitoring::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_violations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, interval: interval }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_violations parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, interval: interval do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_violations ::Google::Cloud::CloudControlsPartner::V1beta::ListViolationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, interval: interval) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_violations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, interval: interval }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_violations(::Google::Cloud::CloudControlsPartner::V1beta::ListViolationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, interval: interval), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_violations_client_stub.call_rpc_count
    end
  end

  def test_get_violation
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CloudControlsPartner::V1beta::Violation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_violation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_violation, name
      assert_kind_of ::Google::Cloud::CloudControlsPartner::V1beta::GetViolationRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_violation_client_stub do
      # Create client
      client = ::Google::Cloud::CloudControlsPartner::V1beta::CloudControlsPartnerMonitoring::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_violation({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_violation name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_violation ::Google::Cloud::CloudControlsPartner::V1beta::GetViolationRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_violation({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_violation(::Google::Cloud::CloudControlsPartner::V1beta::GetViolationRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_violation_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::CloudControlsPartner::V1beta::CloudControlsPartnerMonitoring::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::CloudControlsPartner::V1beta::CloudControlsPartnerMonitoring::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::CloudControlsPartner::V1beta::CloudControlsPartnerMonitoring::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::CloudControlsPartner::V1beta::CloudControlsPartnerMonitoring::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
