# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/cloudcontrolspartner/v1beta/core_pb"
require "google/cloud/cloud_controls_partner/v1beta/cloud_controls_partner_core/rest"


class ::Google::Cloud::CloudControlsPartner::V1beta::CloudControlsPartnerCore::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_get_workload
    # Create test objects.
    client_result = ::Google::Cloud::CloudControlsPartner::V1beta::Workload.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_workload_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CloudControlsPartner::V1beta::CloudControlsPartnerCore::Rest::ServiceStub.stub :transcode_get_workload_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_workload_client_stub do
        # Create client
        client = ::Google::Cloud::CloudControlsPartner::V1beta::CloudControlsPartnerCore::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_workload({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_workload name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_workload ::Google::Cloud::CloudControlsPartner::V1beta::GetWorkloadRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_workload({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_workload(::Google::Cloud::CloudControlsPartner::V1beta::GetWorkloadRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_workload_client_stub.call_count
      end
    end
  end

  def test_list_workloads
    # Create test objects.
    client_result = ::Google::Cloud::CloudControlsPartner::V1beta::ListWorkloadsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_workloads_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CloudControlsPartner::V1beta::CloudControlsPartnerCore::Rest::ServiceStub.stub :transcode_list_workloads_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_workloads_client_stub do
        # Create client
        client = ::Google::Cloud::CloudControlsPartner::V1beta::CloudControlsPartnerCore::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_workloads({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_workloads parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_workloads ::Google::Cloud::CloudControlsPartner::V1beta::ListWorkloadsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_workloads({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_workloads(::Google::Cloud::CloudControlsPartner::V1beta::ListWorkloadsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_workloads_client_stub.call_count
      end
    end
  end

  def test_get_customer
    # Create test objects.
    client_result = ::Google::Cloud::CloudControlsPartner::V1beta::Customer.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_customer_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CloudControlsPartner::V1beta::CloudControlsPartnerCore::Rest::ServiceStub.stub :transcode_get_customer_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_customer_client_stub do
        # Create client
        client = ::Google::Cloud::CloudControlsPartner::V1beta::CloudControlsPartnerCore::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_customer({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_customer name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_customer ::Google::Cloud::CloudControlsPartner::V1beta::GetCustomerRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_customer({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_customer(::Google::Cloud::CloudControlsPartner::V1beta::GetCustomerRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_customer_client_stub.call_count
      end
    end
  end

  def test_list_customers
    # Create test objects.
    client_result = ::Google::Cloud::CloudControlsPartner::V1beta::ListCustomersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_customers_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CloudControlsPartner::V1beta::CloudControlsPartnerCore::Rest::ServiceStub.stub :transcode_list_customers_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_customers_client_stub do
        # Create client
        client = ::Google::Cloud::CloudControlsPartner::V1beta::CloudControlsPartnerCore::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_customers({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_customers parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_customers ::Google::Cloud::CloudControlsPartner::V1beta::ListCustomersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_customers({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_customers(::Google::Cloud::CloudControlsPartner::V1beta::ListCustomersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_customers_client_stub.call_count
      end
    end
  end

  def test_get_ekm_connections
    # Create test objects.
    client_result = ::Google::Cloud::CloudControlsPartner::V1beta::EkmConnections.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_ekm_connections_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CloudControlsPartner::V1beta::CloudControlsPartnerCore::Rest::ServiceStub.stub :transcode_get_ekm_connections_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_ekm_connections_client_stub do
        # Create client
        client = ::Google::Cloud::CloudControlsPartner::V1beta::CloudControlsPartnerCore::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_ekm_connections({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_ekm_connections name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_ekm_connections ::Google::Cloud::CloudControlsPartner::V1beta::GetEkmConnectionsRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_ekm_connections({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_ekm_connections(::Google::Cloud::CloudControlsPartner::V1beta::GetEkmConnectionsRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_ekm_connections_client_stub.call_count
      end
    end
  end

  def test_get_partner_permissions
    # Create test objects.
    client_result = ::Google::Cloud::CloudControlsPartner::V1beta::PartnerPermissions.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_partner_permissions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CloudControlsPartner::V1beta::CloudControlsPartnerCore::Rest::ServiceStub.stub :transcode_get_partner_permissions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_partner_permissions_client_stub do
        # Create client
        client = ::Google::Cloud::CloudControlsPartner::V1beta::CloudControlsPartnerCore::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_partner_permissions({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_partner_permissions name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_partner_permissions ::Google::Cloud::CloudControlsPartner::V1beta::GetPartnerPermissionsRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_partner_permissions({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_partner_permissions(::Google::Cloud::CloudControlsPartner::V1beta::GetPartnerPermissionsRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_partner_permissions_client_stub.call_count
      end
    end
  end

  def test_list_access_approval_requests
    # Create test objects.
    client_result = ::Google::Cloud::CloudControlsPartner::V1beta::ListAccessApprovalRequestsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_access_approval_requests_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CloudControlsPartner::V1beta::CloudControlsPartnerCore::Rest::ServiceStub.stub :transcode_list_access_approval_requests_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_access_approval_requests_client_stub do
        # Create client
        client = ::Google::Cloud::CloudControlsPartner::V1beta::CloudControlsPartnerCore::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_access_approval_requests({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_access_approval_requests parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_access_approval_requests ::Google::Cloud::CloudControlsPartner::V1beta::ListAccessApprovalRequestsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_access_approval_requests({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_access_approval_requests(::Google::Cloud::CloudControlsPartner::V1beta::ListAccessApprovalRequestsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_access_approval_requests_client_stub.call_count
      end
    end
  end

  def test_get_partner
    # Create test objects.
    client_result = ::Google::Cloud::CloudControlsPartner::V1beta::Partner.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_partner_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CloudControlsPartner::V1beta::CloudControlsPartnerCore::Rest::ServiceStub.stub :transcode_get_partner_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_partner_client_stub do
        # Create client
        client = ::Google::Cloud::CloudControlsPartner::V1beta::CloudControlsPartnerCore::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_partner({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_partner name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_partner ::Google::Cloud::CloudControlsPartner::V1beta::GetPartnerRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_partner({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_partner(::Google::Cloud::CloudControlsPartner::V1beta::GetPartnerRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_partner_client_stub.call_count
      end
    end
  end

  def test_create_customer
    # Create test objects.
    client_result = ::Google::Cloud::CloudControlsPartner::V1beta::Customer.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    customer = {}
    customer_id = "hello world"

    create_customer_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CloudControlsPartner::V1beta::CloudControlsPartnerCore::Rest::ServiceStub.stub :transcode_create_customer_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_customer_client_stub do
        # Create client
        client = ::Google::Cloud::CloudControlsPartner::V1beta::CloudControlsPartnerCore::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_customer({ parent: parent, customer: customer, customer_id: customer_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_customer parent: parent, customer: customer, customer_id: customer_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_customer ::Google::Cloud::CloudControlsPartner::V1beta::CreateCustomerRequest.new(parent: parent, customer: customer, customer_id: customer_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_customer({ parent: parent, customer: customer, customer_id: customer_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_customer(::Google::Cloud::CloudControlsPartner::V1beta::CreateCustomerRequest.new(parent: parent, customer: customer, customer_id: customer_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_customer_client_stub.call_count
      end
    end
  end

  def test_update_customer
    # Create test objects.
    client_result = ::Google::Cloud::CloudControlsPartner::V1beta::Customer.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    customer = {}
    update_mask = {}

    update_customer_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CloudControlsPartner::V1beta::CloudControlsPartnerCore::Rest::ServiceStub.stub :transcode_update_customer_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_customer_client_stub do
        # Create client
        client = ::Google::Cloud::CloudControlsPartner::V1beta::CloudControlsPartnerCore::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_customer({ customer: customer, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_customer customer: customer, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_customer ::Google::Cloud::CloudControlsPartner::V1beta::UpdateCustomerRequest.new(customer: customer, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_customer({ customer: customer, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_customer(::Google::Cloud::CloudControlsPartner::V1beta::UpdateCustomerRequest.new(customer: customer, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_customer_client_stub.call_count
      end
    end
  end

  def test_delete_customer
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_customer_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CloudControlsPartner::V1beta::CloudControlsPartnerCore::Rest::ServiceStub.stub :transcode_delete_customer_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_customer_client_stub do
        # Create client
        client = ::Google::Cloud::CloudControlsPartner::V1beta::CloudControlsPartnerCore::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_customer({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_customer name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_customer ::Google::Cloud::CloudControlsPartner::V1beta::DeleteCustomerRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_customer({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_customer(::Google::Cloud::CloudControlsPartner::V1beta::DeleteCustomerRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_customer_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::CloudControlsPartner::V1beta::CloudControlsPartnerCore::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::CloudControlsPartner::V1beta::CloudControlsPartnerCore::Rest::Client::Configuration, config
  end
end
