# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module CloudControlsPartner
      module V1beta
        # Message describing Partner resource
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of the partner.
        #     Format: `organizations/{organization}/locations/{location}/partner`
        #     Example: "organizations/123456/locations/us-central1/partner"
        # @!attribute [rw] skus
        #   @return [::Array<::Google::Cloud::CloudControlsPartner::V1beta::Sku>]
        #     List of SKUs the partner is offering
        # @!attribute [rw] ekm_solutions
        #   @return [::Array<::Google::Cloud::CloudControlsPartner::V1beta::EkmMetadata>]
        #     List of Google Cloud supported EKM partners supported by the partner
        # @!attribute [rw] operated_cloud_regions
        #   @return [::Array<::String>]
        #     List of Google Cloud regions that the partner sells services to customers.
        #     Valid Google Cloud regions found here:
        #     https://cloud.google.com/compute/docs/regions-zones
        # @!attribute [rw] partner_project_id
        #   @return [::String]
        #     Google Cloud project ID in the partner's Google Cloud organization for
        #     receiving enhanced Logs for Partners.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time the resource was created
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The last time the resource was updated
        class Partner
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for getting a Partner
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Format:
        #     `organizations/{organization}/locations/{location}/partner`
        class GetPartnerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the SKU a partner owns inside Google Cloud to sell to customers.
        # @!attribute [rw] id
        #   @return [::String]
        #     Argentum product SKU, that is associated with the partner offerings to
        #     customers used by Syntro for billing purposes. SKUs can represent resold
        #     Google products or support services.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Display name of the product identified by the SKU. A partner may want to
        #     show partner branded names for their offerings such as local sovereign
        #     cloud solutions.
        class Sku
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Holds information needed by Mudbray to use partner EKMs for workloads.
        # @!attribute [rw] ekm_solution
        #   @return [::Google::Cloud::CloudControlsPartner::V1beta::EkmMetadata::EkmSolution]
        #     The Cloud EKM partner.
        # @!attribute [rw] ekm_endpoint_uri
        #   @return [::String]
        #     Endpoint for sending requests to the EKM for key provisioning during
        #     Assured Workload creation.
        class EkmMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Represents Google Cloud supported external key management partners
          # [Google Cloud EKM partners
          # docs](https://cloud.google.com/kms/docs/ekm#supported_partners).
          module EkmSolution
            # Unspecified EKM solution
            EKM_SOLUTION_UNSPECIFIED = 0

            # EKM Partner Fortanix
            FORTANIX = 1

            # EKM Partner FutureX
            FUTUREX = 2

            # EKM Partner Thales
            THALES = 3

            # This enum value is never used.
            VIRTRU = 4
          end
        end
      end
    end
  end
end
