# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module CloudControlsPartner
      module V1beta
        # The EKM connections associated with a workload
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Format:
        #     `organizations/{organization}/locations/{location}/customers/{customer}/workloads/{workload}/ekmConnections`
        # @!attribute [rw] ekm_connections
        #   @return [::Array<::Google::Cloud::CloudControlsPartner::V1beta::EkmConnection>]
        #     The EKM connections associated with the workload
        class EkmConnections
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for getting the EKM connections associated with a workload
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Format:
        #     `organizations/{organization}/locations/{location}/customers/{customer}/workloads/{workload}/ekmConnections`
        class GetEkmConnectionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details about the EKM connection
        # @!attribute [rw] connection_name
        #   @return [::String]
        #     Resource name of the EKM connection in the format:
        #     projects/\\{project}/locations/\\{location}/ekmConnections/\\{ekm_connection}
        # @!attribute [r] connection_state
        #   @return [::Google::Cloud::CloudControlsPartner::V1beta::EkmConnection::ConnectionState]
        #     Output only. The connection state
        # @!attribute [rw] connection_error
        #   @return [::Google::Cloud::CloudControlsPartner::V1beta::EkmConnection::ConnectionError]
        #     The connection error that occurred if any
        class EkmConnection
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Information around the error that occurred if the connection state is
          # anything other than available or unspecified
          # @!attribute [rw] error_domain
          #   @return [::String]
          #     The error domain for the error
          # @!attribute [rw] error_message
          #   @return [::String]
          #     The error message for the error
          class ConnectionError
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The EKM connection state.
          module ConnectionState
            # Unspecified EKM connection state
            CONNECTION_STATE_UNSPECIFIED = 0

            # Available EKM connection state
            AVAILABLE = 1

            # Not available EKM connection state
            NOT_AVAILABLE = 2

            # Error EKM connection state
            ERROR = 3

            # Permission denied EKM connection state
            PERMISSION_DENIED = 4
          end
        end
      end
    end
  end
end
