# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module CloudControlsPartner
      module V1
        # Contains metadata around the [Workload
        # resource](https://cloud.google.com/assured-workloads/docs/reference/rest/Shared.Types/Workload)
        # in the Assured Workloads API.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Format:
        #     `organizations/{organization}/locations/{location}/customers/{customer}/workloads/{workload}`
        # @!attribute [r] folder_id
        #   @return [::Integer]
        #     Output only. Folder id this workload is associated with
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time the resource was created.
        # @!attribute [r] folder
        #   @return [::String]
        #     Output only. The name of container folder of the assured workload
        # @!attribute [rw] workload_onboarding_state
        #   @return [::Google::Cloud::CloudControlsPartner::V1::WorkloadOnboardingState]
        #     Container for workload onboarding steps.
        # @!attribute [rw] is_onboarded
        #   @return [::Boolean]
        #     Indicates whether a workload is fully onboarded.
        # @!attribute [rw] key_management_project_id
        #   @return [::String]
        #     The project id of the key management project for the workload
        # @!attribute [rw] location
        #   @return [::String]
        #     The Google Cloud location of the workload
        # @!attribute [rw] partner
        #   @return [::Google::Cloud::CloudControlsPartner::V1::Workload::Partner]
        #     Partner associated with this workload.
        class Workload
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Supported Assured Workloads Partners.
          module Partner
            # Unknown Partner.
            PARTNER_UNSPECIFIED = 0

            # Enum representing S3NS (Thales) partner.
            PARTNER_LOCAL_CONTROLS_BY_S3NS = 1

            # Enum representing T_SYSTEM (TSI) partner.
            PARTNER_SOVEREIGN_CONTROLS_BY_T_SYSTEMS = 2

            # Enum representing SIA_MINSAIT (Indra) partner.
            PARTNER_SOVEREIGN_CONTROLS_BY_SIA_MINSAIT = 3

            # Enum representing PSN (TIM) partner.
            PARTNER_SOVEREIGN_CONTROLS_BY_PSN = 4

            # Enum representing CNTXT (Kingdom of Saudi Arabia) partner.
            PARTNER_SOVEREIGN_CONTROLS_BY_CNTXT = 6

            # Enum representing CNXT (Kingdom of Saudi Arabia) partner offering without
            # EKM provisioning.
            PARTNER_SOVEREIGN_CONTROLS_BY_CNTXT_NO_EKM = 7
          end
        end

        # Request to list customer workloads.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent resource
        #     Format:
        #     `organizations/{organization}/locations/{location}/customers/{customer}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of workloads to return. The service may return fewer
        #     than this value. If unspecified, at most 500 workloads will be returned.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListWorkloads` call.
        #     Provide this to retrieve the subsequent page.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Hint for how to order the results.
        class ListWorkloadsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for list customer workloads requests.
        # @!attribute [rw] workloads
        #   @return [::Array<::Google::Cloud::CloudControlsPartner::V1::Workload>]
        #     List of customer workloads
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListWorkloadsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for getting a customer workload.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Format:
        #     `organizations/{organization}/locations/{location}/customers/{customer}/workloads/{workload}`
        class GetWorkloadRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Container for workload onboarding steps.
        # @!attribute [rw] onboarding_steps
        #   @return [::Array<::Google::Cloud::CloudControlsPartner::V1::WorkloadOnboardingStep>]
        #     List of workload onboarding steps.
        class WorkloadOnboardingState
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Container for workload onboarding information.
        # @!attribute [rw] step
        #   @return [::Google::Cloud::CloudControlsPartner::V1::WorkloadOnboardingStep::Step]
        #     The onboarding step.
        # @!attribute [rw] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The starting time of the onboarding step.
        # @!attribute [rw] completion_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The completion time of the onboarding step.
        # @!attribute [r] completion_state
        #   @return [::Google::Cloud::CloudControlsPartner::V1::CompletionState]
        #     Output only. The completion state of the onboarding step.
        class WorkloadOnboardingStep
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Enum for possible onboarding steps.
          module Step
            # Unspecified step.
            STEP_UNSPECIFIED = 0

            # EKM Provisioned step.
            EKM_PROVISIONED = 1

            # Signed Access Approval step.
            SIGNED_ACCESS_APPROVAL_CONFIGURED = 2
          end
        end
      end
    end
  end
end
