# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module CloudControlsPartner
      module V1
        # Details about the Access request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Format:
        #     `organizations/{organization}/locations/{location}/customers/{customer}/workloads/{workload}/accessApprovalRequests/{access_approval_request}`
        # @!attribute [rw] request_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time at which approval was requested.
        # @!attribute [rw] requested_reason
        #   @return [::Google::Cloud::CloudControlsPartner::V1::AccessReason]
        #     The justification for which approval is being requested.
        # @!attribute [rw] requested_expiration_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The requested expiration for the approval. If the request is approved,
        #     access will be granted from the time of approval until the expiration time.
        class AccessApprovalRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for getting the access requests associated with a workload.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent resource
        #     Format:
        #     `organizations/{organization}/locations/{location}/customers/{customer}/workloads/{workload}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of access requests to return. The service may
        #     return fewer than this value. If unspecified, at most 500 access requests
        #     will be returned.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous
        #     `ListAccessApprovalRequests` call. Provide this to retrieve the subsequent
        #     page.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Hint for how to order the results.
        class ListAccessApprovalRequestsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for list access requests.
        # @!attribute [rw] access_approval_requests
        #   @return [::Array<::Google::Cloud::CloudControlsPartner::V1::AccessApprovalRequest>]
        #     List of access approval requests
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListAccessApprovalRequestsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Reason for the access.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::CloudControlsPartner::V1::AccessReason::Type]
        #     Type of access justification.
        # @!attribute [rw] detail
        #   @return [::String]
        #     More detail about certain reason types. See comments for each type above.
        class AccessReason
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Type of access justification.
          module Type
            # Default value for proto, shouldn't be used.
            TYPE_UNSPECIFIED = 0

            # Customer made a request or raised an issue that required the principal to
            # access customer data. `detail` is of the form ("#####" is the issue ID):
            #
            # - "Feedback Report: #####"
            # - "Case Number: #####"
            # - "Case ID: #####"
            # - "E-PIN Reference: #####"
            # - "Google-#####"
            # - "T-#####"
            CUSTOMER_INITIATED_SUPPORT = 1

            # The principal accessed customer data in order to diagnose or resolve a
            # suspected issue in services. Often this access is used to confirm that
            # customers are not affected by a suspected service issue or to remediate a
            # reversible system issue.
            GOOGLE_INITIATED_SERVICE = 2

            # Google initiated service for security, fraud, abuse, or compliance
            # purposes.
            GOOGLE_INITIATED_REVIEW = 3

            # The principal was compelled to access customer data in order to respond
            # to a legal third party data request or process, including legal processes
            # from customers themselves.
            THIRD_PARTY_DATA_REQUEST = 4

            # The principal accessed customer data in order to diagnose or resolve a
            # suspected issue in services or a known outage.
            GOOGLE_RESPONSE_TO_PRODUCTION_ALERT = 5

            # Similar to 'GOOGLE_INITIATED_SERVICE' or 'GOOGLE_INITIATED_REVIEW', but
            # with universe agnostic naming. The principal accessed customer data in
            # order to diagnose or resolve a suspected issue in services or a known
            # outage, or for security, fraud, abuse, or compliance review purposes.
            CLOUD_INITIATED_ACCESS = 6
          end
        end
      end
    end
  end
end
