# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/cloudcontrolspartner/v1/core_pb"
require "google/cloud/cloud_controls_partner/v1/cloud_controls_partner_core/rest/service_stub"

module Google
  module Cloud
    module CloudControlsPartner
      module V1
        module CloudControlsPartnerCore
          module Rest
            ##
            # REST client for the CloudControlsPartnerCore service.
            #
            # Service describing handlers for resources
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "cloudcontrolspartner.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :cloud_controls_partner_core_stub

              ##
              # Configure the CloudControlsPartnerCore Client class.
              #
              # See {::Google::Cloud::CloudControlsPartner::V1::CloudControlsPartnerCore::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all CloudControlsPartnerCore clients
              #   ::Google::Cloud::CloudControlsPartner::V1::CloudControlsPartnerCore::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "CloudControlsPartner", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.get_workload.timeout = 60.0
                  default_config.rpcs.get_workload.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_workloads.timeout = 60.0
                  default_config.rpcs.list_workloads.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_customer.timeout = 60.0
                  default_config.rpcs.get_customer.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_customers.timeout = 60.0
                  default_config.rpcs.list_customers.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_ekm_connections.timeout = 60.0
                  default_config.rpcs.get_ekm_connections.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_partner_permissions.timeout = 60.0
                  default_config.rpcs.get_partner_permissions.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_access_approval_requests.timeout = 60.0
                  default_config.rpcs.list_access_approval_requests.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the CloudControlsPartnerCore Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::CloudControlsPartner::V1::CloudControlsPartnerCore::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @cloud_controls_partner_core_stub.universe_domain
              end

              ##
              # Create a new CloudControlsPartnerCore REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::CloudControlsPartner::V1::CloudControlsPartnerCore::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::CloudControlsPartner::V1::CloudControlsPartnerCore::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the CloudControlsPartnerCore client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @cloud_controls_partner_core_stub = ::Google::Cloud::CloudControlsPartner::V1::CloudControlsPartnerCore::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @cloud_controls_partner_core_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @cloud_controls_partner_core_stub.logger
              end

              # Service calls

              ##
              # Gets details of a single workload
              #
              # @overload get_workload(request, options = nil)
              #   Pass arguments to `get_workload` via a request object, either of type
              #   {::Google::Cloud::CloudControlsPartner::V1::GetWorkloadRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::CloudControlsPartner::V1::GetWorkloadRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_workload(name: nil)
              #   Pass arguments to `get_workload` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Format:
              #     `organizations/{organization}/locations/{location}/customers/{customer}/workloads/{workload}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::CloudControlsPartner::V1::Workload]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::CloudControlsPartner::V1::Workload]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/cloud_controls_partner/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::CloudControlsPartner::V1::CloudControlsPartnerCore::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::CloudControlsPartner::V1::GetWorkloadRequest.new
              #
              #   # Call the get_workload method.
              #   result = client.get_workload request
              #
              #   # The returned object is of type Google::Cloud::CloudControlsPartner::V1::Workload.
              #   p result
              #
              def get_workload request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudControlsPartner::V1::GetWorkloadRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_workload.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::CloudControlsPartner::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_workload.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_workload.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_controls_partner_core_stub.get_workload request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists customer workloads for a given customer org id
              #
              # @overload list_workloads(request, options = nil)
              #   Pass arguments to `list_workloads` via a request object, either of type
              #   {::Google::Cloud::CloudControlsPartner::V1::ListWorkloadsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::CloudControlsPartner::V1::ListWorkloadsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_workloads(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_workloads` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent resource
              #     Format:
              #     `organizations/{organization}/locations/{location}/customers/{customer}`
              #   @param page_size [::Integer]
              #     The maximum number of workloads to return. The service may return fewer
              #     than this value. If unspecified, at most 500 workloads will be returned.
              #   @param page_token [::String]
              #     A page token, received from a previous `ListWorkloads` call.
              #     Provide this to retrieve the subsequent page.
              #   @param filter [::String]
              #     Optional. Filtering results.
              #   @param order_by [::String]
              #     Optional. Hint for how to order the results.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::CloudControlsPartner::V1::Workload>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::CloudControlsPartner::V1::Workload>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/cloud_controls_partner/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::CloudControlsPartner::V1::CloudControlsPartnerCore::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::CloudControlsPartner::V1::ListWorkloadsRequest.new
              #
              #   # Call the list_workloads method.
              #   result = client.list_workloads request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::CloudControlsPartner::V1::Workload.
              #     p item
              #   end
              #
              def list_workloads request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudControlsPartner::V1::ListWorkloadsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_workloads.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::CloudControlsPartner::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_workloads.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_workloads.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_controls_partner_core_stub.list_workloads request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @cloud_controls_partner_core_stub, :list_workloads, "workloads", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single customer
              #
              # @overload get_customer(request, options = nil)
              #   Pass arguments to `get_customer` via a request object, either of type
              #   {::Google::Cloud::CloudControlsPartner::V1::GetCustomerRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::CloudControlsPartner::V1::GetCustomerRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_customer(name: nil)
              #   Pass arguments to `get_customer` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Format:
              #     `organizations/{organization}/locations/{location}/customers/{customer}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::CloudControlsPartner::V1::Customer]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::CloudControlsPartner::V1::Customer]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/cloud_controls_partner/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::CloudControlsPartner::V1::CloudControlsPartnerCore::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::CloudControlsPartner::V1::GetCustomerRequest.new
              #
              #   # Call the get_customer method.
              #   result = client.get_customer request
              #
              #   # The returned object is of type Google::Cloud::CloudControlsPartner::V1::Customer.
              #   p result
              #
              def get_customer request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudControlsPartner::V1::GetCustomerRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_customer.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::CloudControlsPartner::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_customer.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_customer.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_controls_partner_core_stub.get_customer request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists customers of a partner identified by its Google Cloud organization ID
              #
              # @overload list_customers(request, options = nil)
              #   Pass arguments to `list_customers` via a request object, either of type
              #   {::Google::Cloud::CloudControlsPartner::V1::ListCustomersRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::CloudControlsPartner::V1::ListCustomersRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_customers(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_customers` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent resource
              #     Format: `organizations/{organization}/locations/{location}`
              #   @param page_size [::Integer]
              #     The maximum number of Customers to return. The service may return fewer
              #     than this value. If unspecified, at most 500 Customers will be returned.
              #   @param page_token [::String]
              #     A page token, received from a previous `ListCustomers` call.
              #     Provide this to retrieve the subsequent page.
              #   @param filter [::String]
              #     Optional. Filtering results
              #   @param order_by [::String]
              #     Optional. Hint for how to order the results
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::CloudControlsPartner::V1::Customer>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::CloudControlsPartner::V1::Customer>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/cloud_controls_partner/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::CloudControlsPartner::V1::CloudControlsPartnerCore::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::CloudControlsPartner::V1::ListCustomersRequest.new
              #
              #   # Call the list_customers method.
              #   result = client.list_customers request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::CloudControlsPartner::V1::Customer.
              #     p item
              #   end
              #
              def list_customers request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudControlsPartner::V1::ListCustomersRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_customers.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::CloudControlsPartner::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_customers.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_customers.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_controls_partner_core_stub.list_customers request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @cloud_controls_partner_core_stub, :list_customers, "customers", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the EKM connections associated with a workload
              #
              # @overload get_ekm_connections(request, options = nil)
              #   Pass arguments to `get_ekm_connections` via a request object, either of type
              #   {::Google::Cloud::CloudControlsPartner::V1::GetEkmConnectionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::CloudControlsPartner::V1::GetEkmConnectionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_ekm_connections(name: nil)
              #   Pass arguments to `get_ekm_connections` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Format:
              #     `organizations/{organization}/locations/{location}/customers/{customer}/workloads/{workload}/ekmConnections`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::CloudControlsPartner::V1::EkmConnections]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::CloudControlsPartner::V1::EkmConnections]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/cloud_controls_partner/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::CloudControlsPartner::V1::CloudControlsPartnerCore::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::CloudControlsPartner::V1::GetEkmConnectionsRequest.new
              #
              #   # Call the get_ekm_connections method.
              #   result = client.get_ekm_connections request
              #
              #   # The returned object is of type Google::Cloud::CloudControlsPartner::V1::EkmConnections.
              #   p result
              #
              def get_ekm_connections request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudControlsPartner::V1::GetEkmConnectionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_ekm_connections.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::CloudControlsPartner::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_ekm_connections.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_ekm_connections.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_controls_partner_core_stub.get_ekm_connections request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the partner permissions granted for a workload
              #
              # @overload get_partner_permissions(request, options = nil)
              #   Pass arguments to `get_partner_permissions` via a request object, either of type
              #   {::Google::Cloud::CloudControlsPartner::V1::GetPartnerPermissionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::CloudControlsPartner::V1::GetPartnerPermissionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_partner_permissions(name: nil)
              #   Pass arguments to `get_partner_permissions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource to get in the format:
              #     `organizations/{organization}/locations/{location}/customers/{customer}/workloads/{workload}/partnerPermissions`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::CloudControlsPartner::V1::PartnerPermissions]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::CloudControlsPartner::V1::PartnerPermissions]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/cloud_controls_partner/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::CloudControlsPartner::V1::CloudControlsPartnerCore::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::CloudControlsPartner::V1::GetPartnerPermissionsRequest.new
              #
              #   # Call the get_partner_permissions method.
              #   result = client.get_partner_permissions request
              #
              #   # The returned object is of type Google::Cloud::CloudControlsPartner::V1::PartnerPermissions.
              #   p result
              #
              def get_partner_permissions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudControlsPartner::V1::GetPartnerPermissionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_partner_permissions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::CloudControlsPartner::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_partner_permissions.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_partner_permissions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_controls_partner_core_stub.get_partner_permissions request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deprecated: Only returns access approval requests directly associated with
              # an assured workload folder.
              #
              # @overload list_access_approval_requests(request, options = nil)
              #   Pass arguments to `list_access_approval_requests` via a request object, either of type
              #   {::Google::Cloud::CloudControlsPartner::V1::ListAccessApprovalRequestsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::CloudControlsPartner::V1::ListAccessApprovalRequestsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_access_approval_requests(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_access_approval_requests` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent resource
              #     Format:
              #     `organizations/{organization}/locations/{location}/customers/{customer}/workloads/{workload}`
              #   @param page_size [::Integer]
              #     Optional. The maximum number of access requests to return. The service may
              #     return fewer than this value. If unspecified, at most 500 access requests
              #     will be returned.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous
              #     `ListAccessApprovalRequests` call. Provide this to retrieve the subsequent
              #     page.
              #   @param filter [::String]
              #     Optional. Filtering results.
              #   @param order_by [::String]
              #     Optional. Hint for how to order the results.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::CloudControlsPartner::V1::AccessApprovalRequest>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::CloudControlsPartner::V1::AccessApprovalRequest>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/cloud_controls_partner/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::CloudControlsPartner::V1::CloudControlsPartnerCore::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::CloudControlsPartner::V1::ListAccessApprovalRequestsRequest.new
              #
              #   # Call the list_access_approval_requests method.
              #   result = client.list_access_approval_requests request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::CloudControlsPartner::V1::AccessApprovalRequest.
              #     p item
              #   end
              #
              def list_access_approval_requests request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudControlsPartner::V1::ListAccessApprovalRequestsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_access_approval_requests.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::CloudControlsPartner::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_access_approval_requests.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_access_approval_requests.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_controls_partner_core_stub.list_access_approval_requests request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @cloud_controls_partner_core_stub, :list_access_approval_requests, "access_approval_requests", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get details of a Partner.
              #
              # @overload get_partner(request, options = nil)
              #   Pass arguments to `get_partner` via a request object, either of type
              #   {::Google::Cloud::CloudControlsPartner::V1::GetPartnerRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::CloudControlsPartner::V1::GetPartnerRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_partner(name: nil)
              #   Pass arguments to `get_partner` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Format:
              #     `organizations/{organization}/locations/{location}/partner`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::CloudControlsPartner::V1::Partner]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::CloudControlsPartner::V1::Partner]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/cloud_controls_partner/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::CloudControlsPartner::V1::CloudControlsPartnerCore::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::CloudControlsPartner::V1::GetPartnerRequest.new
              #
              #   # Call the get_partner method.
              #   result = client.get_partner request
              #
              #   # The returned object is of type Google::Cloud::CloudControlsPartner::V1::Partner.
              #   p result
              #
              def get_partner request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudControlsPartner::V1::GetPartnerRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_partner.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::CloudControlsPartner::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_partner.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_partner.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_controls_partner_core_stub.get_partner request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new customer.
              #
              # @overload create_customer(request, options = nil)
              #   Pass arguments to `create_customer` via a request object, either of type
              #   {::Google::Cloud::CloudControlsPartner::V1::CreateCustomerRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::CloudControlsPartner::V1::CreateCustomerRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_customer(parent: nil, customer: nil, customer_id: nil)
              #   Pass arguments to `create_customer` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent resource
              #     Format: `organizations/{organization}/locations/{location}`
              #   @param customer [::Google::Cloud::CloudControlsPartner::V1::Customer, ::Hash]
              #     Required. The customer to create.
              #   @param customer_id [::String]
              #     Required. The customer id to use for the customer, which will become the
              #     final component of the customer's resource name. The specified value must
              #     be a valid Google cloud organization id.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::CloudControlsPartner::V1::Customer]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::CloudControlsPartner::V1::Customer]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/cloud_controls_partner/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::CloudControlsPartner::V1::CloudControlsPartnerCore::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::CloudControlsPartner::V1::CreateCustomerRequest.new
              #
              #   # Call the create_customer method.
              #   result = client.create_customer request
              #
              #   # The returned object is of type Google::Cloud::CloudControlsPartner::V1::Customer.
              #   p result
              #
              def create_customer request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudControlsPartner::V1::CreateCustomerRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_customer.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::CloudControlsPartner::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_customer.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_customer.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_controls_partner_core_stub.create_customer request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Update details of a single customer
              #
              # @overload update_customer(request, options = nil)
              #   Pass arguments to `update_customer` via a request object, either of type
              #   {::Google::Cloud::CloudControlsPartner::V1::UpdateCustomerRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::CloudControlsPartner::V1::UpdateCustomerRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_customer(customer: nil, update_mask: nil)
              #   Pass arguments to `update_customer` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param customer [::Google::Cloud::CloudControlsPartner::V1::Customer, ::Hash]
              #     Required. The customer to update
              #     Format:
              #     `organizations/{organization}/locations/{location}/customers/{customer}`
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. The list of fields to update
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::CloudControlsPartner::V1::Customer]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::CloudControlsPartner::V1::Customer]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/cloud_controls_partner/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::CloudControlsPartner::V1::CloudControlsPartnerCore::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::CloudControlsPartner::V1::UpdateCustomerRequest.new
              #
              #   # Call the update_customer method.
              #   result = client.update_customer request
              #
              #   # The returned object is of type Google::Cloud::CloudControlsPartner::V1::Customer.
              #   p result
              #
              def update_customer request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudControlsPartner::V1::UpdateCustomerRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_customer.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::CloudControlsPartner::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_customer.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_customer.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_controls_partner_core_stub.update_customer request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Delete details of a single customer
              #
              # @overload delete_customer(request, options = nil)
              #   Pass arguments to `delete_customer` via a request object, either of type
              #   {::Google::Cloud::CloudControlsPartner::V1::DeleteCustomerRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::CloudControlsPartner::V1::DeleteCustomerRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_customer(name: nil)
              #   Pass arguments to `delete_customer` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. name of the resource to be deleted
              #     format: name=organizations/*/locations/*/customers/*
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/cloud_controls_partner/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::CloudControlsPartner::V1::CloudControlsPartnerCore::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::CloudControlsPartner::V1::DeleteCustomerRequest.new
              #
              #   # Call the delete_customer method.
              #   result = client.delete_customer request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_customer request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CloudControlsPartner::V1::DeleteCustomerRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_customer.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::CloudControlsPartner::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_customer.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_customer.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_controls_partner_core_stub.delete_customer request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the CloudControlsPartnerCore REST API.
              #
              # This class represents the configuration for CloudControlsPartnerCore REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::CloudControlsPartner::V1::CloudControlsPartnerCore::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # get_workload to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::CloudControlsPartner::V1::CloudControlsPartnerCore::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.get_workload.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::CloudControlsPartner::V1::CloudControlsPartnerCore::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.get_workload.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "cloudcontrolspartner.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the CloudControlsPartnerCore API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `get_workload`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_workload
                  ##
                  # RPC-specific configuration for `list_workloads`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_workloads
                  ##
                  # RPC-specific configuration for `get_customer`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_customer
                  ##
                  # RPC-specific configuration for `list_customers`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_customers
                  ##
                  # RPC-specific configuration for `get_ekm_connections`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_ekm_connections
                  ##
                  # RPC-specific configuration for `get_partner_permissions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_partner_permissions
                  ##
                  # RPC-specific configuration for `list_access_approval_requests`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_access_approval_requests
                  ##
                  # RPC-specific configuration for `get_partner`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_partner
                  ##
                  # RPC-specific configuration for `create_customer`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_customer
                  ##
                  # RPC-specific configuration for `update_customer`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_customer
                  ##
                  # RPC-specific configuration for `delete_customer`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_customer

                  # @private
                  def initialize parent_rpcs = nil
                    get_workload_config = parent_rpcs.get_workload if parent_rpcs.respond_to? :get_workload
                    @get_workload = ::Gapic::Config::Method.new get_workload_config
                    list_workloads_config = parent_rpcs.list_workloads if parent_rpcs.respond_to? :list_workloads
                    @list_workloads = ::Gapic::Config::Method.new list_workloads_config
                    get_customer_config = parent_rpcs.get_customer if parent_rpcs.respond_to? :get_customer
                    @get_customer = ::Gapic::Config::Method.new get_customer_config
                    list_customers_config = parent_rpcs.list_customers if parent_rpcs.respond_to? :list_customers
                    @list_customers = ::Gapic::Config::Method.new list_customers_config
                    get_ekm_connections_config = parent_rpcs.get_ekm_connections if parent_rpcs.respond_to? :get_ekm_connections
                    @get_ekm_connections = ::Gapic::Config::Method.new get_ekm_connections_config
                    get_partner_permissions_config = parent_rpcs.get_partner_permissions if parent_rpcs.respond_to? :get_partner_permissions
                    @get_partner_permissions = ::Gapic::Config::Method.new get_partner_permissions_config
                    list_access_approval_requests_config = parent_rpcs.list_access_approval_requests if parent_rpcs.respond_to? :list_access_approval_requests
                    @list_access_approval_requests = ::Gapic::Config::Method.new list_access_approval_requests_config
                    get_partner_config = parent_rpcs.get_partner if parent_rpcs.respond_to? :get_partner
                    @get_partner = ::Gapic::Config::Method.new get_partner_config
                    create_customer_config = parent_rpcs.create_customer if parent_rpcs.respond_to? :create_customer
                    @create_customer = ::Gapic::Config::Method.new create_customer_config
                    update_customer_config = parent_rpcs.update_customer if parent_rpcs.respond_to? :update_customer
                    @update_customer = ::Gapic::Config::Method.new update_customer_config
                    delete_customer_config = parent_rpcs.delete_customer if parent_rpcs.respond_to? :delete_customer
                    @delete_customer = ::Gapic::Config::Method.new delete_customer_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
