# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/chronicle/v1/rule_pb"
require "google/cloud/chronicle/v1/rule_service"

class ::Google::Cloud::Chronicle::V1::RuleService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_rule
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Chronicle::V1::Rule.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    rule = {}

    create_rule_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_rule, name
      assert_kind_of ::Google::Cloud::Chronicle::V1::CreateRuleRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Chronicle::V1::Rule), request["rule"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_rule_client_stub do
      # Create client
      client = ::Google::Cloud::Chronicle::V1::RuleService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_rule({ parent: parent, rule: rule }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_rule parent: parent, rule: rule do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_rule ::Google::Cloud::Chronicle::V1::CreateRuleRequest.new(parent: parent, rule: rule) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_rule({ parent: parent, rule: rule }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_rule(::Google::Cloud::Chronicle::V1::CreateRuleRequest.new(parent: parent, rule: rule), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_rule_client_stub.call_rpc_count
    end
  end

  def test_get_rule
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Chronicle::V1::Rule.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :RULE_VIEW_UNSPECIFIED

    get_rule_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_rule, name
      assert_kind_of ::Google::Cloud::Chronicle::V1::GetRuleRequest, request
      assert_equal "hello world", request["name"]
      assert_equal :RULE_VIEW_UNSPECIFIED, request["view"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_rule_client_stub do
      # Create client
      client = ::Google::Cloud::Chronicle::V1::RuleService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_rule({ name: name, view: view }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_rule name: name, view: view do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_rule ::Google::Cloud::Chronicle::V1::GetRuleRequest.new(name: name, view: view) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_rule({ name: name, view: view }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_rule(::Google::Cloud::Chronicle::V1::GetRuleRequest.new(name: name, view: view), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_rule_client_stub.call_rpc_count
    end
  end

  def test_list_rules
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Chronicle::V1::ListRulesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    view = :RULE_VIEW_UNSPECIFIED
    filter = "hello world"

    list_rules_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_rules, name
      assert_kind_of ::Google::Cloud::Chronicle::V1::ListRulesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal :RULE_VIEW_UNSPECIFIED, request["view"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_rules_client_stub do
      # Create client
      client = ::Google::Cloud::Chronicle::V1::RuleService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_rules({ parent: parent, page_size: page_size, page_token: page_token, view: view, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_rules parent: parent, page_size: page_size, page_token: page_token, view: view, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_rules ::Google::Cloud::Chronicle::V1::ListRulesRequest.new(parent: parent, page_size: page_size, page_token: page_token, view: view, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_rules({ parent: parent, page_size: page_size, page_token: page_token, view: view, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_rules(::Google::Cloud::Chronicle::V1::ListRulesRequest.new(parent: parent, page_size: page_size, page_token: page_token, view: view, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_rules_client_stub.call_rpc_count
    end
  end

  def test_update_rule
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Chronicle::V1::Rule.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    rule = {}
    update_mask = {}

    update_rule_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_rule, name
      assert_kind_of ::Google::Cloud::Chronicle::V1::UpdateRuleRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Chronicle::V1::Rule), request["rule"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_rule_client_stub do
      # Create client
      client = ::Google::Cloud::Chronicle::V1::RuleService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_rule({ rule: rule, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_rule rule: rule, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_rule ::Google::Cloud::Chronicle::V1::UpdateRuleRequest.new(rule: rule, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_rule({ rule: rule, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_rule(::Google::Cloud::Chronicle::V1::UpdateRuleRequest.new(rule: rule, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_rule_client_stub.call_rpc_count
    end
  end

  def test_delete_rule
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_rule_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_rule, name
      assert_kind_of ::Google::Cloud::Chronicle::V1::DeleteRuleRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_rule_client_stub do
      # Create client
      client = ::Google::Cloud::Chronicle::V1::RuleService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_rule({ name: name, force: force }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_rule name: name, force: force do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_rule ::Google::Cloud::Chronicle::V1::DeleteRuleRequest.new(name: name, force: force) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_rule({ name: name, force: force }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_rule(::Google::Cloud::Chronicle::V1::DeleteRuleRequest.new(name: name, force: force), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_rule_client_stub.call_rpc_count
    end
  end

  def test_list_rule_revisions
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Chronicle::V1::ListRuleRevisionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    page_size = 42
    page_token = "hello world"
    view = :RULE_VIEW_UNSPECIFIED

    list_rule_revisions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_rule_revisions, name
      assert_kind_of ::Google::Cloud::Chronicle::V1::ListRuleRevisionsRequest, request
      assert_equal "hello world", request["name"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal :RULE_VIEW_UNSPECIFIED, request["view"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_rule_revisions_client_stub do
      # Create client
      client = ::Google::Cloud::Chronicle::V1::RuleService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_rule_revisions({ name: name, page_size: page_size, page_token: page_token, view: view }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_rule_revisions name: name, page_size: page_size, page_token: page_token, view: view do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_rule_revisions ::Google::Cloud::Chronicle::V1::ListRuleRevisionsRequest.new(name: name, page_size: page_size, page_token: page_token, view: view) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_rule_revisions({ name: name, page_size: page_size, page_token: page_token, view: view }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_rule_revisions(::Google::Cloud::Chronicle::V1::ListRuleRevisionsRequest.new(name: name, page_size: page_size, page_token: page_token, view: view), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_rule_revisions_client_stub.call_rpc_count
    end
  end

  def test_create_retrohunt
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    retrohunt = {}

    create_retrohunt_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_retrohunt, name
      assert_kind_of ::Google::Cloud::Chronicle::V1::CreateRetrohuntRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Chronicle::V1::Retrohunt), request["retrohunt"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_retrohunt_client_stub do
      # Create client
      client = ::Google::Cloud::Chronicle::V1::RuleService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_retrohunt({ parent: parent, retrohunt: retrohunt }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_retrohunt parent: parent, retrohunt: retrohunt do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_retrohunt ::Google::Cloud::Chronicle::V1::CreateRetrohuntRequest.new(parent: parent, retrohunt: retrohunt) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_retrohunt({ parent: parent, retrohunt: retrohunt }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_retrohunt(::Google::Cloud::Chronicle::V1::CreateRetrohuntRequest.new(parent: parent, retrohunt: retrohunt), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_retrohunt_client_stub.call_rpc_count
    end
  end

  def test_get_retrohunt
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Chronicle::V1::Retrohunt.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_retrohunt_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_retrohunt, name
      assert_kind_of ::Google::Cloud::Chronicle::V1::GetRetrohuntRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_retrohunt_client_stub do
      # Create client
      client = ::Google::Cloud::Chronicle::V1::RuleService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_retrohunt({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_retrohunt name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_retrohunt ::Google::Cloud::Chronicle::V1::GetRetrohuntRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_retrohunt({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_retrohunt(::Google::Cloud::Chronicle::V1::GetRetrohuntRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_retrohunt_client_stub.call_rpc_count
    end
  end

  def test_list_retrohunts
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Chronicle::V1::ListRetrohuntsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_retrohunts_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_retrohunts, name
      assert_kind_of ::Google::Cloud::Chronicle::V1::ListRetrohuntsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_retrohunts_client_stub do
      # Create client
      client = ::Google::Cloud::Chronicle::V1::RuleService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_retrohunts({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_retrohunts parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_retrohunts ::Google::Cloud::Chronicle::V1::ListRetrohuntsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_retrohunts({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_retrohunts(::Google::Cloud::Chronicle::V1::ListRetrohuntsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_retrohunts_client_stub.call_rpc_count
    end
  end

  def test_get_rule_deployment
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Chronicle::V1::RuleDeployment.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_rule_deployment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_rule_deployment, name
      assert_kind_of ::Google::Cloud::Chronicle::V1::GetRuleDeploymentRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_rule_deployment_client_stub do
      # Create client
      client = ::Google::Cloud::Chronicle::V1::RuleService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_rule_deployment({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_rule_deployment name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_rule_deployment ::Google::Cloud::Chronicle::V1::GetRuleDeploymentRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_rule_deployment({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_rule_deployment(::Google::Cloud::Chronicle::V1::GetRuleDeploymentRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_rule_deployment_client_stub.call_rpc_count
    end
  end

  def test_list_rule_deployments
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Chronicle::V1::ListRuleDeploymentsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_rule_deployments_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_rule_deployments, name
      assert_kind_of ::Google::Cloud::Chronicle::V1::ListRuleDeploymentsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_rule_deployments_client_stub do
      # Create client
      client = ::Google::Cloud::Chronicle::V1::RuleService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_rule_deployments({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_rule_deployments parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_rule_deployments ::Google::Cloud::Chronicle::V1::ListRuleDeploymentsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_rule_deployments({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_rule_deployments(::Google::Cloud::Chronicle::V1::ListRuleDeploymentsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_rule_deployments_client_stub.call_rpc_count
    end
  end

  def test_update_rule_deployment
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Chronicle::V1::RuleDeployment.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    rule_deployment = {}
    update_mask = {}

    update_rule_deployment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_rule_deployment, name
      assert_kind_of ::Google::Cloud::Chronicle::V1::UpdateRuleDeploymentRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Chronicle::V1::RuleDeployment), request["rule_deployment"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_rule_deployment_client_stub do
      # Create client
      client = ::Google::Cloud::Chronicle::V1::RuleService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_rule_deployment({ rule_deployment: rule_deployment, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_rule_deployment rule_deployment: rule_deployment, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_rule_deployment ::Google::Cloud::Chronicle::V1::UpdateRuleDeploymentRequest.new(rule_deployment: rule_deployment, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_rule_deployment({ rule_deployment: rule_deployment, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_rule_deployment(::Google::Cloud::Chronicle::V1::UpdateRuleDeploymentRequest.new(rule_deployment: rule_deployment, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_rule_deployment_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Chronicle::V1::RuleService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Chronicle::V1::RuleService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Chronicle::V1::RuleService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Chronicle::V1::RuleService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Chronicle::V1::RuleService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::Chronicle::V1::RuleService::Operations, client.operations_client
  end
end
