# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/chronicle/v1/reference_list_pb"
require "google/cloud/chronicle/v1/reference_list_service"

class ::Google::Cloud::Chronicle::V1::ReferenceListService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_get_reference_list
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Chronicle::V1::ReferenceList.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :REFERENCE_LIST_VIEW_UNSPECIFIED

    get_reference_list_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_reference_list, name
      assert_kind_of ::Google::Cloud::Chronicle::V1::GetReferenceListRequest, request
      assert_equal "hello world", request["name"]
      assert_equal :REFERENCE_LIST_VIEW_UNSPECIFIED, request["view"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_reference_list_client_stub do
      # Create client
      client = ::Google::Cloud::Chronicle::V1::ReferenceListService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_reference_list({ name: name, view: view }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_reference_list name: name, view: view do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_reference_list ::Google::Cloud::Chronicle::V1::GetReferenceListRequest.new(name: name, view: view) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_reference_list({ name: name, view: view }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_reference_list(::Google::Cloud::Chronicle::V1::GetReferenceListRequest.new(name: name, view: view), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_reference_list_client_stub.call_rpc_count
    end
  end

  def test_list_reference_lists
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Chronicle::V1::ListReferenceListsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    view = :REFERENCE_LIST_VIEW_UNSPECIFIED

    list_reference_lists_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_reference_lists, name
      assert_kind_of ::Google::Cloud::Chronicle::V1::ListReferenceListsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal :REFERENCE_LIST_VIEW_UNSPECIFIED, request["view"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_reference_lists_client_stub do
      # Create client
      client = ::Google::Cloud::Chronicle::V1::ReferenceListService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_reference_lists({ parent: parent, page_size: page_size, page_token: page_token, view: view }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_reference_lists parent: parent, page_size: page_size, page_token: page_token, view: view do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_reference_lists ::Google::Cloud::Chronicle::V1::ListReferenceListsRequest.new(parent: parent, page_size: page_size, page_token: page_token, view: view) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_reference_lists({ parent: parent, page_size: page_size, page_token: page_token, view: view }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_reference_lists(::Google::Cloud::Chronicle::V1::ListReferenceListsRequest.new(parent: parent, page_size: page_size, page_token: page_token, view: view), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_reference_lists_client_stub.call_rpc_count
    end
  end

  def test_create_reference_list
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Chronicle::V1::ReferenceList.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    reference_list = {}
    reference_list_id = "hello world"

    create_reference_list_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_reference_list, name
      assert_kind_of ::Google::Cloud::Chronicle::V1::CreateReferenceListRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Chronicle::V1::ReferenceList), request["reference_list"]
      assert_equal "hello world", request["reference_list_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_reference_list_client_stub do
      # Create client
      client = ::Google::Cloud::Chronicle::V1::ReferenceListService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_reference_list({ parent: parent, reference_list: reference_list, reference_list_id: reference_list_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_reference_list parent: parent, reference_list: reference_list, reference_list_id: reference_list_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_reference_list ::Google::Cloud::Chronicle::V1::CreateReferenceListRequest.new(parent: parent, reference_list: reference_list, reference_list_id: reference_list_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_reference_list({ parent: parent, reference_list: reference_list, reference_list_id: reference_list_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_reference_list(::Google::Cloud::Chronicle::V1::CreateReferenceListRequest.new(parent: parent, reference_list: reference_list, reference_list_id: reference_list_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_reference_list_client_stub.call_rpc_count
    end
  end

  def test_update_reference_list
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Chronicle::V1::ReferenceList.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    reference_list = {}
    update_mask = {}

    update_reference_list_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_reference_list, name
      assert_kind_of ::Google::Cloud::Chronicle::V1::UpdateReferenceListRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Chronicle::V1::ReferenceList), request["reference_list"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_reference_list_client_stub do
      # Create client
      client = ::Google::Cloud::Chronicle::V1::ReferenceListService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_reference_list({ reference_list: reference_list, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_reference_list reference_list: reference_list, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_reference_list ::Google::Cloud::Chronicle::V1::UpdateReferenceListRequest.new(reference_list: reference_list, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_reference_list({ reference_list: reference_list, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_reference_list(::Google::Cloud::Chronicle::V1::UpdateReferenceListRequest.new(reference_list: reference_list, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_reference_list_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Chronicle::V1::ReferenceListService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Chronicle::V1::ReferenceListService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Chronicle::V1::ReferenceListService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Chronicle::V1::ReferenceListService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
