# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/chronicle/v1/data_access_control_pb"
require "google/cloud/chronicle/v1/data_access_control_service"

class ::Google::Cloud::Chronicle::V1::DataAccessControlService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_data_access_label
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Chronicle::V1::DataAccessLabel.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    data_access_label = {}
    data_access_label_id = "hello world"

    create_data_access_label_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_data_access_label, name
      assert_kind_of ::Google::Cloud::Chronicle::V1::CreateDataAccessLabelRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Chronicle::V1::DataAccessLabel), request["data_access_label"]
      assert_equal "hello world", request["data_access_label_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_data_access_label_client_stub do
      # Create client
      client = ::Google::Cloud::Chronicle::V1::DataAccessControlService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_data_access_label({ parent: parent, data_access_label: data_access_label, data_access_label_id: data_access_label_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_data_access_label parent: parent, data_access_label: data_access_label, data_access_label_id: data_access_label_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_data_access_label ::Google::Cloud::Chronicle::V1::CreateDataAccessLabelRequest.new(parent: parent, data_access_label: data_access_label, data_access_label_id: data_access_label_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_data_access_label({ parent: parent, data_access_label: data_access_label, data_access_label_id: data_access_label_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_data_access_label(::Google::Cloud::Chronicle::V1::CreateDataAccessLabelRequest.new(parent: parent, data_access_label: data_access_label, data_access_label_id: data_access_label_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_data_access_label_client_stub.call_rpc_count
    end
  end

  def test_get_data_access_label
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Chronicle::V1::DataAccessLabel.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_data_access_label_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_data_access_label, name
      assert_kind_of ::Google::Cloud::Chronicle::V1::GetDataAccessLabelRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_data_access_label_client_stub do
      # Create client
      client = ::Google::Cloud::Chronicle::V1::DataAccessControlService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_data_access_label({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_data_access_label name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_data_access_label ::Google::Cloud::Chronicle::V1::GetDataAccessLabelRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_data_access_label({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_data_access_label(::Google::Cloud::Chronicle::V1::GetDataAccessLabelRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_data_access_label_client_stub.call_rpc_count
    end
  end

  def test_list_data_access_labels
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Chronicle::V1::ListDataAccessLabelsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_data_access_labels_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_data_access_labels, name
      assert_kind_of ::Google::Cloud::Chronicle::V1::ListDataAccessLabelsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_data_access_labels_client_stub do
      # Create client
      client = ::Google::Cloud::Chronicle::V1::DataAccessControlService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_data_access_labels({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_data_access_labels parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_data_access_labels ::Google::Cloud::Chronicle::V1::ListDataAccessLabelsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_data_access_labels({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_data_access_labels(::Google::Cloud::Chronicle::V1::ListDataAccessLabelsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_data_access_labels_client_stub.call_rpc_count
    end
  end

  def test_update_data_access_label
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Chronicle::V1::DataAccessLabel.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    data_access_label = {}
    update_mask = {}

    update_data_access_label_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_data_access_label, name
      assert_kind_of ::Google::Cloud::Chronicle::V1::UpdateDataAccessLabelRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Chronicle::V1::DataAccessLabel), request["data_access_label"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_data_access_label_client_stub do
      # Create client
      client = ::Google::Cloud::Chronicle::V1::DataAccessControlService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_data_access_label({ data_access_label: data_access_label, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_data_access_label data_access_label: data_access_label, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_data_access_label ::Google::Cloud::Chronicle::V1::UpdateDataAccessLabelRequest.new(data_access_label: data_access_label, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_data_access_label({ data_access_label: data_access_label, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_data_access_label(::Google::Cloud::Chronicle::V1::UpdateDataAccessLabelRequest.new(data_access_label: data_access_label, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_data_access_label_client_stub.call_rpc_count
    end
  end

  def test_delete_data_access_label
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_data_access_label_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_data_access_label, name
      assert_kind_of ::Google::Cloud::Chronicle::V1::DeleteDataAccessLabelRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_data_access_label_client_stub do
      # Create client
      client = ::Google::Cloud::Chronicle::V1::DataAccessControlService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_data_access_label({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_data_access_label name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_data_access_label ::Google::Cloud::Chronicle::V1::DeleteDataAccessLabelRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_data_access_label({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_data_access_label(::Google::Cloud::Chronicle::V1::DeleteDataAccessLabelRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_data_access_label_client_stub.call_rpc_count
    end
  end

  def test_create_data_access_scope
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Chronicle::V1::DataAccessScope.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    data_access_scope = {}
    data_access_scope_id = "hello world"

    create_data_access_scope_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_data_access_scope, name
      assert_kind_of ::Google::Cloud::Chronicle::V1::CreateDataAccessScopeRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Chronicle::V1::DataAccessScope), request["data_access_scope"]
      assert_equal "hello world", request["data_access_scope_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_data_access_scope_client_stub do
      # Create client
      client = ::Google::Cloud::Chronicle::V1::DataAccessControlService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_data_access_scope({ parent: parent, data_access_scope: data_access_scope, data_access_scope_id: data_access_scope_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_data_access_scope parent: parent, data_access_scope: data_access_scope, data_access_scope_id: data_access_scope_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_data_access_scope ::Google::Cloud::Chronicle::V1::CreateDataAccessScopeRequest.new(parent: parent, data_access_scope: data_access_scope, data_access_scope_id: data_access_scope_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_data_access_scope({ parent: parent, data_access_scope: data_access_scope, data_access_scope_id: data_access_scope_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_data_access_scope(::Google::Cloud::Chronicle::V1::CreateDataAccessScopeRequest.new(parent: parent, data_access_scope: data_access_scope, data_access_scope_id: data_access_scope_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_data_access_scope_client_stub.call_rpc_count
    end
  end

  def test_get_data_access_scope
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Chronicle::V1::DataAccessScope.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_data_access_scope_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_data_access_scope, name
      assert_kind_of ::Google::Cloud::Chronicle::V1::GetDataAccessScopeRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_data_access_scope_client_stub do
      # Create client
      client = ::Google::Cloud::Chronicle::V1::DataAccessControlService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_data_access_scope({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_data_access_scope name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_data_access_scope ::Google::Cloud::Chronicle::V1::GetDataAccessScopeRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_data_access_scope({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_data_access_scope(::Google::Cloud::Chronicle::V1::GetDataAccessScopeRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_data_access_scope_client_stub.call_rpc_count
    end
  end

  def test_list_data_access_scopes
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Chronicle::V1::ListDataAccessScopesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_data_access_scopes_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_data_access_scopes, name
      assert_kind_of ::Google::Cloud::Chronicle::V1::ListDataAccessScopesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_data_access_scopes_client_stub do
      # Create client
      client = ::Google::Cloud::Chronicle::V1::DataAccessControlService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_data_access_scopes({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_data_access_scopes parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_data_access_scopes ::Google::Cloud::Chronicle::V1::ListDataAccessScopesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_data_access_scopes({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_data_access_scopes(::Google::Cloud::Chronicle::V1::ListDataAccessScopesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_data_access_scopes_client_stub.call_rpc_count
    end
  end

  def test_update_data_access_scope
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Chronicle::V1::DataAccessScope.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    data_access_scope = {}
    update_mask = {}

    update_data_access_scope_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_data_access_scope, name
      assert_kind_of ::Google::Cloud::Chronicle::V1::UpdateDataAccessScopeRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Chronicle::V1::DataAccessScope), request["data_access_scope"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_data_access_scope_client_stub do
      # Create client
      client = ::Google::Cloud::Chronicle::V1::DataAccessControlService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_data_access_scope({ data_access_scope: data_access_scope, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_data_access_scope data_access_scope: data_access_scope, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_data_access_scope ::Google::Cloud::Chronicle::V1::UpdateDataAccessScopeRequest.new(data_access_scope: data_access_scope, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_data_access_scope({ data_access_scope: data_access_scope, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_data_access_scope(::Google::Cloud::Chronicle::V1::UpdateDataAccessScopeRequest.new(data_access_scope: data_access_scope, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_data_access_scope_client_stub.call_rpc_count
    end
  end

  def test_delete_data_access_scope
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_data_access_scope_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_data_access_scope, name
      assert_kind_of ::Google::Cloud::Chronicle::V1::DeleteDataAccessScopeRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_data_access_scope_client_stub do
      # Create client
      client = ::Google::Cloud::Chronicle::V1::DataAccessControlService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_data_access_scope({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_data_access_scope name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_data_access_scope ::Google::Cloud::Chronicle::V1::DeleteDataAccessScopeRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_data_access_scope({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_data_access_scope(::Google::Cloud::Chronicle::V1::DeleteDataAccessScopeRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_data_access_scope_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Chronicle::V1::DataAccessControlService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Chronicle::V1::DataAccessControlService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Chronicle::V1::DataAccessControlService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Chronicle::V1::DataAccessControlService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
