# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Chronicle
      module V1
        # The Rule resource represents a user-created rule.
        # NEXT TAG: 21
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Full resource name for the rule.
        #     Format:
        #     `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}`
        # @!attribute [r] revision_id
        #   @return [::String]
        #     Output only. The revision ID of the rule.
        #     A new revision is created whenever the rule text is changed in any way.
        #     Format: `v_{10 digits}_{9 digits}`
        #     Populated in REVISION_METADATA_ONLY view and FULL view.
        # @!attribute [r] display_name
        #   @return [::String]
        #     Output only. Display name of the rule.
        #     Populated in BASIC view and FULL view.
        # @!attribute [rw] text
        #   @return [::String]
        #     The YARA-L content of the rule.
        #     Populated in FULL view.
        # @!attribute [r] author
        #   @return [::String]
        #     Output only. The author of the rule. Extracted from the meta section of
        #     text. Populated in BASIC view and FULL view.
        # @!attribute [r] severity
        #   @return [::Google::Cloud::Chronicle::V1::Severity]
        #     Output only. The severity of the rule as specified in the meta section of
        #     text. Populated in BASIC view and FULL view.
        # @!attribute [r] metadata
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Output only. Additional metadata specified in the meta section of text.
        #     Populated in FULL view.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp of when the rule was created.
        #     Populated in FULL view.
        # @!attribute [r] revision_create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp of when the rule revision was created.
        #     Populated in FULL, REVISION_METADATA_ONLY views.
        # @!attribute [r] compilation_state
        #   @return [::Google::Cloud::Chronicle::V1::Rule::CompilationState]
        #     Output only. The current compilation state of the rule.
        #     Populated in FULL view.
        # @!attribute [r] type
        #   @return [::Google::Cloud::Chronicle::V1::RuleType]
        #     Output only. User-facing type of the rule. Extracted from the events
        #     section of rule text. Populated in BASIC view and FULL view.
        # @!attribute [r] reference_lists
        #   @return [::Array<::String>]
        #     Output only. Resource names of the reference lists used in this rule.
        #     Populated in FULL view.
        # @!attribute [r] allowed_run_frequencies
        #   @return [::Array<::Google::Cloud::Chronicle::V1::RunFrequency>]
        #     Output only. The run frequencies that are allowed for the rule.
        #     Populated in BASIC view and FULL view.
        # @!attribute [rw] etag
        #   @return [::String]
        #     The etag for this rule.
        #     If this is provided on update, the request will succeed if and only if it
        #     matches the server-computed value, and will fail with an ABORTED error
        #     otherwise.
        #     Populated in BASIC view and FULL view.
        # @!attribute [rw] scope
        #   @return [::String]
        #     Resource name of the DataAccessScope bound to this rule.
        #     Populated in BASIC view and FULL view.
        #     If reference lists are used in the rule, validations will be performed
        #     against this scope to ensure that the reference lists are compatible with
        #     both the user's and the rule's scopes.
        #     The scope should be in the format:
        #     `projects/{project}/locations/{location}/instances/{instance}/dataAccessScopes/{scope}`.
        # @!attribute [r] compilation_diagnostics
        #   @return [::Array<::Google::Cloud::Chronicle::V1::CompilationDiagnostic>]
        #     Output only. A list of a rule's corresponding compilation diagnostic
        #     messages such as compilation errors and compilation warnings. Populated in
        #     FULL view.
        # @!attribute [r] near_real_time_live_rule_eligible
        #   @return [::Boolean]
        #     Output only. Indicate the rule can run in near real time live rule.
        #     If this is true, the rule uses the near real time live rule when the run
        #     frequency is set to LIVE.
        # @!attribute [r] inputs_used
        #   @return [::Google::Cloud::Chronicle::V1::InputsUsed]
        #     Output only. The set of inputs used in the rule. For example, if the rule
        #     uses $e.principal.hostname, then the uses_udm field will be true.
        class Rule
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class MetadataEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The current compilation state of the rule.
          module CompilationState
            # The compilation state is unspecified/unknown.
            COMPILATION_STATE_UNSPECIFIED = 0

            # The Rule can successfully compile.
            SUCCEEDED = 1

            # The Rule cannot successfully compile.
            # This is possible if a backwards-incompatible change was made to the
            # compiler.
            FAILED = 2
          end
        end

        # The RuleDeployment resource represents the deployment state of a Rule.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the rule deployment.
        #     Note that RuleDeployment is a child of the overall Rule, not any individual
        #     revision, so the resource ID segment for the Rule resource must not
        #     reference a specific revision.
        #     Format:
        #     `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}/deployment`
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Whether the rule is currently deployed continuously against incoming data.
        # @!attribute [rw] alerting
        #   @return [::Boolean]
        #     Whether detections resulting from this deployment should be considered
        #     alerts.
        # @!attribute [rw] archived
        #   @return [::Boolean]
        #     The archive state of the rule deployment.
        #     Cannot be set to true unless enabled is set to false.
        #     If set to true, alerting will automatically be set to false.
        #     If currently set to true, enabled, alerting, and run_frequency cannot be
        #     updated.
        # @!attribute [r] archive_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the rule deployment archive state was last
        #     set to true. If the rule deployment's current archive state is not set to
        #     true, the field will be empty.
        # @!attribute [rw] run_frequency
        #   @return [::Google::Cloud::Chronicle::V1::RunFrequency]
        #     The run frequency of the rule deployment.
        # @!attribute [r] execution_state
        #   @return [::Google::Cloud::Chronicle::V1::RuleDeployment::ExecutionState]
        #     Output only. The execution state of the rule deployment.
        # @!attribute [r] producer_rules
        #   @return [::Array<::String>]
        #     Output only. The names of the associated/chained producer rules. Rules are
        #     considered producers for this rule if this rule explicitly filters on their
        #     ruleid. Format:
        #     `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}`
        # @!attribute [r] consumer_rules
        #   @return [::Array<::String>]
        #     Output only. The names of the associated/chained consumer rules. Rules are
        #     considered consumers of this rule if their rule text explicitly filters on
        #     this rule's ruleid. Format:
        #     `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}`
        # @!attribute [r] last_alert_status_change_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the rule deployment alert state was lastly
        #     changed. This is filled regardless of the current alert state. E.g. if the
        #     current alert status is false, this timestamp will be the timestamp when
        #     the alert status was changed to false.
        class RuleDeployment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The possible execution states the rule deployment can be in.
          module ExecutionState
            # Unspecified or unknown execution state.
            EXECUTION_STATE_UNSPECIFIED = 0

            # Default execution state.
            DEFAULT = 1

            # Rules in limited state may not have their executions guaranteed.
            LIMITED = 2

            # Paused rules are not executed at all.
            PAUSED = 3
          end
        end

        # Retrohunt is an execution of a Rule over a time range in the past.
        # @!attribute [rw] name
        #   @return [::String]
        #     The resource name of the retrohunt.
        #     Retrohunt is the child of a rule revision. \\{rule} in the format below is
        #     structured as \\{rule_id@revision_id}.
        #     Format:
        #     `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}/retrohunts/{retrohunt}`
        # @!attribute [rw] process_interval
        #   @return [::Google::Type::Interval]
        #     Required. The start and end time of the event time range this retrohunt
        #     processes.
        # @!attribute [r] execution_interval
        #   @return [::Google::Type::Interval]
        #     Output only. The start and end time of the retrohunt execution. If the
        #     retrohunt is not yet finished, the end time of the interval will not be
        #     populated.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Chronicle::V1::Retrohunt::State]
        #     Output only. The state of the retrohunt.
        # @!attribute [r] progress_percentage
        #   @return [::Float]
        #     Output only. Percent progress of the retrohunt towards completion, from
        #     0.00 to 100.00.
        class Retrohunt
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The possible states a retrohunt can be in.
          module State
            # Unspecified or unknown retrohunt state.
            STATE_UNSPECIFIED = 0

            # Running state.
            RUNNING = 1

            # Done state.
            DONE = 2

            # Cancelled state.
            CANCELLED = 3

            # Failed state.
            FAILED = 4
          end
        end

        # Request message for CreateRule method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where this rule will be created.
        #     Format: `projects/{project}/locations/{location}/instances/{instance}`
        # @!attribute [rw] rule
        #   @return [::Google::Cloud::Chronicle::V1::Rule]
        #     Required. The rule to create.
        class CreateRuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetRule method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the rule to retrieve.
        #     Format:
        #     `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}`
        # @!attribute [rw] view
        #   @return [::Google::Cloud::Chronicle::V1::RuleView]
        #     The view field indicates the scope of fields to populate for the Rule being
        #     returned. If unspecified, defaults to FULL.
        class GetRuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListRules method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of rules.
        #     Format:
        #     `projects/{project}/locations/{location}/instances/{instance}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of rules to return. The service may return fewer than
        #     this value. If unspecified, at most 100 rules will be returned. The
        #     maximum value is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListRules` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListRules`
        #     must match the call that provided the page token.
        # @!attribute [rw] view
        #   @return [::Google::Cloud::Chronicle::V1::RuleView]
        #     view indicates the scope of fields to populate for the Rule being returned.
        #     If unspecified, defaults to BASIC.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Only the following filters are allowed:
        #     "reference_lists:\\{reference_list_name}"
        #     "data_tables:\\{data_table_name}"
        #     "display_name:\\{display_name}"
        class ListRulesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListRules method.
        # @!attribute [rw] rules
        #   @return [::Array<::Google::Cloud::Chronicle::V1::Rule>]
        #     The rules from the specified instance.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListRulesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateRule method.
        # @!attribute [rw] rule
        #   @return [::Google::Cloud::Chronicle::V1::Rule]
        #     Required. The rule to update.
        #
        #     The rule's `name` field is used to identify the rule to update.
        #     Format:
        #     `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}`
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The list of fields to update. If not included, all fields with a non-empty
        #     value will be overwritten.
        class UpdateRuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the DeleteRule method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the rule to delete. A rule revision timestamp cannot
        #     be specified as part of the name, as deleting specific revisions is not
        #     supported.
        #     Format:
        #     `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}`
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. If set to true, any retrohunts and any detections associated with
        #     the rule will also be deleted. If set to false, the call will only succeed
        #     if the rule has no associated retrohunts, including completed retrohunts,
        #     and no associated detections. Regardless of this field's value, the rule
        #     deployment associated with this rule will also be deleted.
        class DeleteRuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListRuleRevisions method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the rule to list revisions for.
        #     Format:
        #     `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of revisions to return per page. The service may return
        #     fewer than this value. If unspecified, at most 100 revisions will be
        #     returned. The maximum value is 1000; values above 1000 will be coerced to
        #     1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The page token, received from a previous `ListRuleRevisions` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListRuleRevisions`
        #     must match the call that provided the page token.
        # @!attribute [rw] view
        #   @return [::Google::Cloud::Chronicle::V1::RuleView]
        #     The view field indicates the scope of fields to populate for the revision
        #     being returned. If unspecified, defaults to BASIC.
        class ListRuleRevisionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListRuleRevisions method.
        # @!attribute [rw] rules
        #   @return [::Array<::Google::Cloud::Chronicle::V1::Rule>]
        #     The revisions of the rule.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListRuleRevisionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateRetrohunt method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent of retrohunt, which is a rule.
        #     Format:
        #     `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}`
        # @!attribute [rw] retrohunt
        #   @return [::Google::Cloud::Chronicle::V1::Retrohunt]
        #     Required. The retrohunt to create.
        class CreateRetrohuntRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetRetrohunt method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the retrohunt to retrieve.
        #     Format:
        #     `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}/retrohunts/{retrohunt}`
        class GetRetrohuntRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListRetrohunts method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The rule that the retrohunts belong to.
        #     Format:
        #     `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of retrohunt to return. The service may return fewer
        #     than this value. If unspecified, at most 100 retrohunts will be returned.
        #     The maximum value is 1000; values above 1000 will be coerced to
        #     1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListRetrohunts` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListRetrohunts` must
        #     match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter that can be used to retrieve specific rule deployments.
        #     The following fields are filterable:
        #     state
        class ListRetrohuntsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListRetrohunts method.
        # @!attribute [rw] retrohunts
        #   @return [::Array<::Google::Cloud::Chronicle::V1::Retrohunt>]
        #     The retrohunts from the specified rule.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListRetrohuntsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetRuleDeployment.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the rule deployment to retrieve.
        #     Format:
        #     `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}/deployment`
        class GetRuleDeploymentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListRuleDeployments.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The collection of all parents which own all rule deployments. The
        #     "-" wildcard token must be used as the rule identifier in the resource
        #     path. Format:
        #     `projects/{project}/locations/{location}/instances/{instance}/rules/-`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of rule deployments to return. The service may return
        #     fewer than this value. If unspecified, at most 100 rule deployments will be
        #     returned. The maximum value is 1000; values above 1000 will be coerced to
        #     1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListRuleDeployments` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListRuleDeployments`
        #     must match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter that can be used to retrieve specific rule deployments.
        #     The following fields are filterable:
        #     archived, name
        class ListRuleDeploymentsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListRuleDeployments.
        # @!attribute [rw] rule_deployments
        #   @return [::Array<::Google::Cloud::Chronicle::V1::RuleDeployment>]
        #     The rule deployments from all rules.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListRuleDeploymentsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateRuleDeployment.
        # @!attribute [rw] rule_deployment
        #   @return [::Google::Cloud::Chronicle::V1::RuleDeployment]
        #     Required. The rule deployment to update.
        #
        #     The rule deployment's `name` field is used to identify the rule deployment
        #     to update. Format:
        #     `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}/deployment`
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to update.
        class UpdateRuleDeploymentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # CompilationPosition represents the location of a compilation diagnostic in
        # rule text.
        # @!attribute [r] start_line
        #   @return [::Integer]
        #     Output only. Start line number, beginning at 1.
        # @!attribute [r] start_column
        #   @return [::Integer]
        #     Output only. Start column number, beginning at 1.
        # @!attribute [r] end_line
        #   @return [::Integer]
        #     Output only. End line number, beginning at 1.
        # @!attribute [r] end_column
        #   @return [::Integer]
        #     Output only. End column number, beginning at 1.
        class CompilationPosition
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # CompilationDiagnostic represents a compilation diagnostic generated
        # during a rule's compilation, such as a compilation error or a compilation
        # warning.
        # @!attribute [r] message
        #   @return [::String]
        #     Output only. The diagnostic message.
        # @!attribute [r] position
        #   @return [::Google::Cloud::Chronicle::V1::CompilationPosition]
        #     Output only. The approximate position in the rule text associated with the
        #     compilation diagnostic.
        #     Compilation Position may be empty.
        # @!attribute [r] severity
        #   @return [::Google::Cloud::Chronicle::V1::CompilationDiagnostic::Severity]
        #     Output only. The severity of a rule's compilation diagnostic.
        # @!attribute [r] uri
        #   @return [::String]
        #     Output only. Link to documentation that describes a diagnostic in more
        #     detail.
        class CompilationDiagnostic
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The severity level of the compilation diagnostic.
          module Severity
            # An unspecified severity level.
            SEVERITY_UNSPECIFIED = 0

            # A compilation warning.
            WARNING = 1

            # A compilation error.
            ERROR = 2
          end
        end

        # Severity represents the severity level of the rule.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     The display name of the severity level. Extracted from the meta section of
        #     the rule text.
        class Severity
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Operation Metadata for Retrohunts.
        # @!attribute [rw] retrohunt
        #   @return [::String]
        #     The name of the retrohunt.
        #     Format:
        #     `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}/retrohunts/{retrohunt}`
        # @!attribute [rw] execution_interval
        #   @return [::Google::Type::Interval]
        #     The start and end time of the retrohunt execution. If the retrohunt is not
        #     yet finished, the end time of the interval will not be filled.
        # @!attribute [rw] progress_percentage
        #   @return [::Float]
        #     Percent progress of the retrohunt towards completion, from 0.00 to 100.00.
        class RetrohuntMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # InputsUsed is a convenience field that tells us which sources
        # of events (if any) were used in the rule.
        # NEXT TAG: 4
        # @!attribute [rw] uses_udm
        #   @return [::Boolean]
        #     Optional. Whether the rule queries UDM events.
        # @!attribute [rw] uses_entity
        #   @return [::Boolean]
        #     Optional. Whether the rule queries entity events.
        # @!attribute [rw] uses_detection
        #   @return [::Boolean]
        #     Optional. Whether the rule queries detections.
        class InputsUsed
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # RunFrequency indicates the run frequency at which a YARA-L 2 rule will run if
        # enabled.
        module RunFrequency
          # The run frequency is unspecified/unknown.
          RUN_FREQUENCY_UNSPECIFIED = 0

          # Executes in real time.
          LIVE = 1

          # Executes once per hour.
          HOURLY = 2

          # Executes once per day.
          DAILY = 3
        end

        # RuleType indicates the YARA-L rule type of user-created and Google Cloud
        # Threat Intelligence (GCTI) authored rules.
        module RuleType
          # The rule type is unspecified/unknown.
          RULE_TYPE_UNSPECIFIED = 0

          # Rule checks for the existence of a single event.
          SINGLE_EVENT = 1

          # Rule checks for correlation between multiple events
          MULTI_EVENT = 2
        end

        # RuleView indicates the scope of fields to populate when returning the Rule
        # resource.
        module RuleView
          # The default/unset value.
          # The API will default to the BASIC view for ListRules/ListRuleRevisions.
          # The API will default to the FULL view for GetRule.
          RULE_VIEW_UNSPECIFIED = 0

          # Include basic metadata about the rule, but not the full contents.
          # Returned fields include: revision_id, revision_create_time, display_name,
          # author, severity, type, allowed_run_frequency,
          # near_real_time_live_rule_eligible, etag, and scope.
          # This is the default value for ListRules and ListRuleRevisions.
          BASIC = 1

          # Include all fields.
          # This is the default value for GetRule.
          FULL = 2

          # Include basic metadata about the rule's revision only.
          # Returned fields include: revision_id and revision_create_time.
          REVISION_METADATA_ONLY = 3
        end
      end
    end
  end
end
